/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.predicates.VertexPredicate;

public class UserDatumVertexPredicate
extends VertexPredicate {
    public static final String message = "UserDatumVertexPredicate: ";
    private Object datum;
    private Object key;

    public UserDatumVertexPredicate(Object key, Object datum) {
        if (key == null) {
            throw new IllegalArgumentException("UserDatumVertexPredicate key must be non-null");
        }
        this.datum = datum;
        this.key = key;
    }

    public boolean evaluateVertex(ArchetypeVertex v) {
        Object value = v.getUserDatum(this.key);
        return this.datum == null && value == null || this.datum.equals(value);
    }

    public String toString() {
        return "UserDatumVertexPredicate: (" + this.key + ", " + this.datum + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserDatumVertexPredicate)) {
            return false;
        }
        UserDatumVertexPredicate udvp = (UserDatumVertexPredicate)o;
        return udvp.datum.equals(this.datum) && udvp.key.equals(this.key);
    }

    public int hashCode() {
        return this.datum.hashCode() + this.key.hashCode();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getDatum() {
        return this.datum;
    }
}

