/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.event;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.event.GraphEventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GraphListenerHandler {
    private ArchetypeGraph mGraph;
    Map mGraphListenerMap = new HashMap();

    public GraphListenerHandler(ArchetypeGraph graph) {
        this.mGraph = graph;
    }

    public void addListener(GraphEventListener gel, GraphEventType get) {
        if (get == GraphEventType.ALL_SINGLE_EVENTS) {
            this.addListener_internal(gel, GraphEventType.VERTEX_ADDITION);
            this.addListener_internal(gel, GraphEventType.VERTEX_REMOVAL);
            this.addListener_internal(gel, GraphEventType.EDGE_ADDITION);
            this.addListener_internal(gel, GraphEventType.EDGE_REMOVAL);
        } else {
            this.addListener_internal(gel, get);
        }
    }

    private void addListener_internal(GraphEventListener gel, GraphEventType get) {
        ArrayList<GraphEventListener> listeners = (ArrayList<GraphEventListener>)this.mGraphListenerMap.get(get);
        if (listeners == null) {
            listeners = new ArrayList<GraphEventListener>();
            this.mGraphListenerMap.put(get, listeners);
        }
        listeners.add(gel);
    }

    public void removeListener(GraphEventListener gel, GraphEventType get) {
        if (get == GraphEventType.ALL_SINGLE_EVENTS) {
            this.removeListener_internal(gel, GraphEventType.VERTEX_ADDITION);
            this.removeListener_internal(gel, GraphEventType.VERTEX_REMOVAL);
            this.removeListener_internal(gel, GraphEventType.EDGE_ADDITION);
            this.removeListener_internal(gel, GraphEventType.EDGE_REMOVAL);
        } else {
            this.removeListener_internal(gel, get);
        }
    }

    private void removeListener_internal(GraphEventListener gel, GraphEventType get) {
        List listeners = (List)this.mGraphListenerMap.get(get);
        if (listeners == null) {
            return;
        }
        listeners.remove(gel);
    }

    public boolean listenersExist(GraphEventType type) {
        List listeners = (List)this.mGraphListenerMap.get(type);
        return listeners != null && listeners.size() != 0;
    }

    protected void notifyListenersVertexAdded(GraphEvent ge) {
        List listeners = (List)this.mGraphListenerMap.get(GraphEventType.VERTEX_ADDITION);
        Iterator lIt = listeners.iterator();
        while (lIt.hasNext()) {
            GraphEventListener listener = (GraphEventListener)lIt.next();
            listener.vertexAdded(ge);
        }
    }

    protected void notifyListenersEdgeAdded(GraphEvent ge) {
        List listeners = (List)this.mGraphListenerMap.get(GraphEventType.EDGE_ADDITION);
        Iterator lIt = listeners.iterator();
        while (lIt.hasNext()) {
            GraphEventListener listener = (GraphEventListener)lIt.next();
            listener.edgeAdded(ge);
        }
    }

    protected void notifyListenersVertexRemoved(GraphEvent ge) {
        List listeners = (List)this.mGraphListenerMap.get(GraphEventType.VERTEX_REMOVAL);
        Iterator lIt = listeners.iterator();
        while (lIt.hasNext()) {
            GraphEventListener listener = (GraphEventListener)lIt.next();
            listener.vertexRemoved(ge);
        }
    }

    protected void notifyListenersEdgeRemoved(GraphEvent ge) {
        List listeners = (List)this.mGraphListenerMap.get(GraphEventType.EDGE_REMOVAL);
        Iterator lIt = listeners.iterator();
        while (lIt.hasNext()) {
            GraphEventListener listener = (GraphEventListener)lIt.next();
            listener.edgeRemoved(ge);
        }
    }

    public void handleAdd(ArchetypeEdge e) {
        if (this.listenersExist(GraphEventType.EDGE_ADDITION)) {
            this.notifyListenersEdgeAdded(new GraphEvent(this.mGraph, e));
        }
    }

    public void handleAdd(ArchetypeVertex v) {
        if (this.listenersExist(GraphEventType.VERTEX_ADDITION)) {
            this.notifyListenersVertexAdded(new GraphEvent(this.mGraph, v));
        }
    }

    public void handleRemove(ArchetypeVertex v) {
        if (this.listenersExist(GraphEventType.VERTEX_REMOVAL)) {
            this.notifyListenersVertexRemoved(new GraphEvent(this.mGraph, v));
        }
    }

    public void handleRemove(ArchetypeEdge e) {
        if (this.listenersExist(GraphEventType.EDGE_REMOVAL)) {
            this.notifyListenersEdgeRemoved(new GraphEvent(this.mGraph, e));
        }
    }
}

