/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.visualization.PickedInfo;
import java.awt.Paint;

public class PickableVertexPaintFunction
implements VertexPaintFunction {
    protected Paint draw_paint;
    protected Paint fill_paint;
    protected Paint picked_paint;
    protected PickedInfo pi;

    public PickableVertexPaintFunction(PickedInfo pi, Paint draw_paint, Paint fill_paint, Paint picked_paint) {
        if (pi == null) {
            throw new IllegalArgumentException("PickedInfo instance must be non-null");
        }
        this.pi = pi;
        this.draw_paint = draw_paint;
        this.fill_paint = fill_paint;
        this.picked_paint = picked_paint;
    }

    public Paint getDrawPaint(Vertex v) {
        return this.draw_paint;
    }

    public Paint getFillPaint(Vertex v) {
        if (this.pi.isPicked(v)) {
            return this.picked_paint;
        }
        return this.fill_paint;
    }
}

