/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Indexer {
    static final Object INDEX_DEFAULT_KEY = "IndexDefaultKey";
    int numNodes;
    private ArchetypeVertex[] indexToVertex;
    private Map vertexToIndex = new HashMap();
    private ArchetypeGraph graph;

    public static Indexer getIndexer(ArchetypeGraph g) {
        return Indexer.getIndexer(g, INDEX_DEFAULT_KEY, false, false, 0);
    }

    public static Indexer getAndUpdateIndexer(ArchetypeGraph g) {
        return Indexer.getIndexer(g, INDEX_DEFAULT_KEY, true, false, 0);
    }

    public static Indexer newIndexer(ArchetypeGraph g, int offset) {
        return Indexer.getIndexer(g, INDEX_DEFAULT_KEY, false, true, offset);
    }

    public static Indexer getIndexer(ArchetypeGraph g, Object key) {
        return Indexer.getIndexer(g, key, false, false, 0);
    }

    public static Indexer getAndUpdateIndexer(ArchetypeGraph g, Object key) {
        return Indexer.getIndexer(g, key, true, false, 0);
    }

    public static boolean hasIndexer(ArchetypeGraph g) {
        return Indexer.hasIndexer(g, INDEX_DEFAULT_KEY);
    }

    public static boolean hasIndexer(ArchetypeGraph g, Object key) {
        Indexer id = (Indexer)g.getUserDatum(key);
        return id != null;
    }

    private static Indexer getIndexer(ArchetypeGraph g, Object key, boolean reIndex, boolean recreate, int offset) {
        Indexer id = (Indexer)g.getUserDatum(key);
        if (!recreate && id != null) {
            if (id.numNodes != g.getVertices().size()) {
                if (!reIndex) {
                    throw new FatalException("Graph changed since last index update");
                }
                id = null;
            } else {
                return id;
            }
        }
        id = new Indexer(g);
        id.updateIndex(offset);
        g.setUserDatum(key, id, UserData.REMOVE);
        return id;
    }

    public void updateIndex(int offset) {
        this.indexToVertex = new ArchetypeVertex[this.graph.numVertices() + offset];
        this.vertexToIndex.clear();
        int i = offset;
        Iterator iter = this.graph.getVertices().iterator();
        while (iter.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)iter.next();
            Integer ix = new Integer(i);
            this.indexToVertex[i] = v;
            this.vertexToIndex.put(v, ix);
            ++i;
        }
        this.numNodes = this.graph.getVertices().size();
    }

    public void updateIndex() {
        this.updateIndex(0);
    }

    public int getIndex(ArchetypeVertex v) {
        return (Integer)this.vertexToIndex.get(v);
    }

    public ArchetypeVertex getVertex(int i) {
        return this.indexToVertex[i];
    }

    private Indexer(ArchetypeGraph g) {
        this.graph = g;
    }
}

