/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.flows;

import edu.uci.ics.jung.algorithms.IterativeProcess;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.MutableInteger;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;

public class EdmondsKarpMaxFlow
extends IterativeProcess {
    private static String RESIDUAL_CAPACITY_KEY = "jung.algorithms.flows.ResidualCapacity";
    private static String PARENT_KEY = "jung.algorithms.flows.Parent";
    private static String PARENT_CAPACITY_KEY = "jung.algorithms.flows.ParentCapacity";
    private DirectedGraph mFlowGraph;
    private DirectedGraph mOriginalGraph;
    private Vertex mSource;
    private Vertex mTarget;
    private String mEdgeFlowKey;
    private String mEdgeCapacityKey;
    private int mMaxFlow;
    private Set mSourcePartitionNodes;
    private Set mSinkPartitionNodes;
    private Set mMinCutEdges;

    public EdmondsKarpMaxFlow(DirectedGraph directedGraph, Vertex source, Vertex sink, String edgeCapacityKey, String edgeFlowKey) {
        if (source.getGraph() != directedGraph || sink.getGraph() != directedGraph) {
            throw new IllegalArgumentException("source and sink vertices must be elements of the specified graph");
        }
        if (source.equals(sink)) {
            throw new IllegalArgumentException("source and sink vertices must be distinct");
        }
        this.mOriginalGraph = directedGraph;
        this.mFlowGraph = (DirectedGraph)directedGraph.copy();
        this.mSource = (Vertex)source.getEqualVertex(this.mFlowGraph);
        this.mTarget = (Vertex)sink.getEqualVertex(this.mFlowGraph);
        this.mEdgeFlowKey = edgeFlowKey;
        this.mEdgeCapacityKey = edgeCapacityKey;
        this.mMaxFlow = 0;
        this.mSinkPartitionNodes = new HashSet();
        this.mSourcePartitionNodes = new HashSet();
        this.mMinCutEdges = new HashSet();
    }

    private void clearParentValues() {
        Iterator vIt = this.mFlowGraph.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            currentVertex.removeUserDatum(PARENT_CAPACITY_KEY);
            currentVertex.removeUserDatum(PARENT_KEY);
        }
        this.mSource.setUserDatum(PARENT_CAPACITY_KEY, new MutableInteger(Integer.MAX_VALUE), UserData.SHARED);
        this.mSource.setUserDatum(PARENT_KEY, this.mSource, UserData.SHARED);
    }

    protected boolean hasAugmentingPath() {
        this.mSinkPartitionNodes.clear();
        this.mSourcePartitionNodes.clear();
        Iterator vIt = this.mFlowGraph.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex v = (Vertex)vIt.next();
            this.mSinkPartitionNodes.add(v);
        }
        HashSet<DirectedEdge> visitedEdgesMap = new HashSet<DirectedEdge>();
        UnboundedFifoBuffer queue = new UnboundedFifoBuffer();
        queue.add((Object)this.mSource);
        while (!queue.isEmpty()) {
            Vertex currentVertex = (Vertex)queue.remove();
            this.mSinkPartitionNodes.remove(currentVertex);
            this.mSourcePartitionNodes.add(currentVertex);
            MutableInteger currentCapacity = (MutableInteger)currentVertex.getUserDatum(PARENT_CAPACITY_KEY);
            Set neighboringEdges = currentVertex.getOutEdges();
            Iterator neIt = neighboringEdges.iterator();
            while (neIt.hasNext()) {
                DirectedEdge neighboringEdge = (DirectedEdge)neIt.next();
                Vertex neighboringVertex = neighboringEdge.getDest();
                MutableInteger residualCapacity = (MutableInteger)neighboringEdge.getUserDatum(RESIDUAL_CAPACITY_KEY);
                if (residualCapacity.intValue() <= 0 || visitedEdgesMap.contains(neighboringEdge)) continue;
                Vertex neighborsParent = (Vertex)neighboringVertex.getUserDatum(PARENT_KEY);
                MutableInteger neighborCapacity = (MutableInteger)neighboringVertex.getUserDatum(PARENT_CAPACITY_KEY);
                int newCapacity = Math.min(residualCapacity.intValue(), currentCapacity.intValue());
                if (neighborsParent != null && newCapacity <= neighborCapacity.intValue()) continue;
                neighboringVertex.setUserDatum(PARENT_KEY, currentVertex, UserData.SHARED);
                neighboringVertex.setUserDatum(PARENT_CAPACITY_KEY, new MutableInteger(newCapacity), UserData.SHARED);
                visitedEdgesMap.add(neighboringEdge);
                if (neighboringVertex == this.mTarget) continue;
                queue.add((Object)neighboringVertex);
            }
        }
        boolean hasAugmentingPath = false;
        MutableInteger targetsParentCapacity = (MutableInteger)this.mTarget.getUserDatum(PARENT_CAPACITY_KEY);
        if (targetsParentCapacity != null && targetsParentCapacity.intValue() > 0) {
            this.updateResidualCapacities();
            hasAugmentingPath = true;
        }
        this.clearParentValues();
        return hasAugmentingPath;
    }

    protected double evaluateIteration() {
        while (this.hasAugmentingPath()) {
        }
        this.computeMinCut();
        return 0.0;
    }

    private void computeMinCut() {
        Iterator eIt = this.mOriginalGraph.getEdges().iterator();
        while (eIt.hasNext()) {
            DirectedEdge e = (DirectedEdge)eIt.next();
            if (this.mSinkPartitionNodes.contains(e.getSource()) && this.mSinkPartitionNodes.contains(e.getDest()) || this.mSourcePartitionNodes.contains(e.getSource()) && this.mSourcePartitionNodes.contains(e.getDest()) || this.mSinkPartitionNodes.contains(e.getSource()) && this.mSourcePartitionNodes.contains(e.getDest())) continue;
            this.mMinCutEdges.add(e);
        }
    }

    public int getMaxFlow() {
        return this.mMaxFlow;
    }

    public Set getNodesInSinkPartition() {
        return this.mSinkPartitionNodes;
    }

    public Set getNodesInSourcePartition() {
        return this.mSourcePartitionNodes;
    }

    public Set getMinCutEdges() {
        return this.mMinCutEdges;
    }

    public DirectedGraph getFlowGraph() {
        return (DirectedGraph)this.mFlowGraph.copy();
    }

    protected void initializeIterations() {
        this.mSource.setUserDatum(PARENT_CAPACITY_KEY, new MutableInteger(Integer.MAX_VALUE), UserData.SHARED);
        this.mSource.setUserDatum(PARENT_KEY, this.mSource, UserData.SHARED);
        ArrayList edgeList = new ArrayList();
        edgeList.addAll(this.mFlowGraph.getEdges());
        for (int eIdx = 0; eIdx < edgeList.size(); ++eIdx) {
            DirectedEdge edge = (DirectedEdge)edgeList.get(eIdx);
            Number capacity = (Number)edge.getUserDatum(this.mEdgeCapacityKey);
            if (capacity == null) {
                throw new IllegalArgumentException("Edge capacities must be decorated using key: " + this.mEdgeCapacityKey);
            }
            edge.setUserDatum(RESIDUAL_CAPACITY_KEY, new MutableInteger(capacity.intValue()), UserData.SHARED);
            if (edge.getDest().isPredecessorOf(edge.getSource())) continue;
            DirectedEdge backEdge = (DirectedEdge)GraphUtils.addEdge(this.mFlowGraph, edge.getDest(), edge.getSource());
            backEdge.setUserDatum(RESIDUAL_CAPACITY_KEY, new MutableInteger(0), UserData.SHARED);
        }
    }

    protected void finalizeIterations() {
        Iterator eIt = this.mFlowGraph.getEdges().iterator();
        while (eIt.hasNext()) {
            DirectedEdge currentEdge = (DirectedEdge)eIt.next();
            Number capacity = (Number)currentEdge.getUserDatum(this.mEdgeCapacityKey);
            Number residualCapacity = (Number)currentEdge.getUserDatum(RESIDUAL_CAPACITY_KEY);
            if (capacity == null) continue;
            MutableInteger flowValue = new MutableInteger(capacity.intValue() - residualCapacity.intValue());
            currentEdge.setUserDatum(this.mEdgeFlowKey, flowValue, UserData.SHARED);
        }
        HashSet<DirectedEdge> backEdges = new HashSet<DirectedEdge>();
        Iterator eIt2 = this.mFlowGraph.getEdges().iterator();
        while (eIt2.hasNext()) {
            DirectedEdge currentEdge = (DirectedEdge)eIt2.next();
            if (currentEdge.getUserDatum(this.mEdgeCapacityKey) == null) {
                backEdges.add(currentEdge);
                continue;
            }
            currentEdge.removeUserDatum(RESIDUAL_CAPACITY_KEY);
        }
        GraphUtils.removeEdges(this.mFlowGraph, backEdges);
    }

    private void updateResidualCapacities() {
        MutableInteger augmentingPathCapacity = (MutableInteger)this.mTarget.getUserDatum(PARENT_CAPACITY_KEY);
        this.mMaxFlow += augmentingPathCapacity.intValue();
        Vertex currentVertex = this.mTarget;
        Vertex parentVertex = null;
        while ((parentVertex = (Vertex)currentVertex.getUserDatum(PARENT_KEY)) != currentVertex) {
            DirectedEdge currentEdge = (DirectedEdge)parentVertex.findEdge(currentVertex);
            MutableInteger residualCapacity = (MutableInteger)currentEdge.getUserDatum(RESIDUAL_CAPACITY_KEY);
            residualCapacity.subtract(augmentingPathCapacity.intValue());
            DirectedEdge backEdge = (DirectedEdge)currentVertex.findEdge(parentVertex);
            residualCapacity = (MutableInteger)backEdge.getUserDatum(RESIDUAL_CAPACITY_KEY);
            residualCapacity.add(augmentingPathCapacity.intValue());
            currentVertex = parentVertex;
        }
    }
}

