/**
 * @file main.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <string.h>
#include "uzura.h"
#include "effect.h"
#include "system.h"
#include "lcd.h"
#include "led.h"
#include "rotenc.h"

typedef struct {
    UZURA uzura;
    uint8_t effect;
    int volume;
    char volmsg[9];
} work_t;

static void update_volmsg(work_t *w, const int vol)
{
    int nnn = (vol == 100) ? 1 : 0;
    int  nn = (vol == 100) ? 0 : (vol / 10);
    int   n = (vol == 100) ? 0 : (vol - (nn * 10));
    w->volmsg[5] = '0' + nnn;
    w->volmsg[6] = '0' +  nn;
    w->volmsg[7] = '0' +   n;
}

static void rotenc_callback(RotencAction action, void *extobj)
{
    work_t *w = (work_t *)extobj;
    if (RotencActionPush == action) {
        w->effect = !w->effect;
        if (w->effect) {
            uzura_set_effect(&(w->uzura), effect_karaoke);
            led_write(LedTargetR, 0);
            led_write(LedTargetG, 1);

        } else {
            uzura_set_effect(&(w->uzura), effect_through);
            led_write(LedTargetR, 1);
            led_write(LedTargetG, 1);
        }
    }
    if (RotencActionLeft == action) {
        if (0 < w->volume) {
            w->volume--;
            effect_param_volume(w->volume / 100.0, w->volume / 100.0);
            update_volmsg(w, w->volume);
            lcd_goto(0, 1);
            lcd_puts(w->volmsg);
        }
    }
    if (RotencActionRight == action) {
        if (w->volume < 100) {
            w->volume++;
            effect_param_volume(w->volume / 100.0, w->volume / 100.0);
            update_volmsg(w, w->volume);
            lcd_goto(0, 1);
            lcd_puts(w->volmsg);
        }
    }
}

int main(void)
{
    work_t w;

    w.effect = 0;
    w.volume = 100;
    strcpy(w.volmsg, "VOL: 100");

    effect_param_init();
    uzura_init(&w.uzura, &w);
    uzura_set_effect(&w.uzura, effect_through);
    uzura_set_system(&w.uzura, system_default);
    led_write(LedTargetR, 1);
    led_write(LedTargetG, 1);
    rotenc_init(rotenc_callback, &w);
    uzura_execute(&w.uzura);

    return 0;
}

