/**
 * @file rotenc.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <stddef.h>
#include <cdefBF592-A.h>
#include <builtins.h>
#include <sys/exception.h>
#include "rotenc.h"
#include "bfin_util.h"

/*
 * PA : PF6
 * PB : PF7
 * SW : PF10
 */

/* System clock frequency : 100MHz */
#define SCLOCK_HZ   (100000000)

#define INIT_PORT() \
    do { \
        *pPORTF_FER     &= ~(PF6 | PF7 | PF10); \
        *pPORTFIO_DIR   &= ~(PF6 | PF7 | PF10); \
        *pPORTFIO_INEN  |=  (PF6 | PF7 | PF10); \
    } while (0)
#define PA_STAT()   (((*pPORTFIO) & (1 <<  6)) ? 1 : 0)
#define PB_STAT()   (((*pPORTFIO) & (1 <<  7)) ? 1 : 0)
#define SW_STAT()   (((*pPORTFIO) & (1 << 10)) ? 1 : 0)

ROTENC_CALLBACK callback = NULL;
void *user_obj = NULL;

static __attribute__((interrupt_handler)) void rotenc_isr(void)
{
    /* Update the interrupt status */
    *pTIMER_STATUS = TIMIL1;
    ssync();

    static uint8_t swstat = 0;
    static const int dir[] = { 0,1,-1,0,-1,0,0,1,1,0,0,-1,0,-1,1,0 };
    static int index;
    int n;

    index = (index << 2) + (((PB_STAT() << 1) | (PA_STAT() << 0)) & 3);
    n = dir[index & 15];
    if (n) {
        if (n < 0) {
            callback(RotencActionLeft, user_obj);
        }
        if (0 < n) {
            callback(RotencActionRight, user_obj);
        }
    }
    swstat = (swstat << 1) | SW_STAT();
    if (swstat == 0xF0) {
        callback(RotencActionPush, user_obj);
    }
}

void rotenc_init(ROTENC_CALLBACK func, void *extobj)
{
    INIT_PORT();

    callback = func;
    user_obj = extobj;

    /* Register interrupt handler to IVG11 */
    bfin_util_register_handler(ik_ivg11, rotenc_isr);
    *pSIC_IMASK |= IRQ_TIMER1;

    /* Setup GP Timer 1 */
    /* 1ms/event */
    *pTIMER1_CONFIG = OUT_DIS | IRQ_ENA | PERIOD_CNT | PWM_OUT;
    *pTIMER1_PERIOD = SCLOCK_HZ / 1000;
    *pTIMER1_WIDTH = 1;
    *pTIMER_ENABLE = TIMEN1;
    ssync();
}

