/**
 * @file effect.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <stdlib.h>
#include "effect.h"
#include "tinyrand.h"

typedef struct {
    double left;
    double right;
} volume_t;

volume_t volume;
tinyrand_t tinyrand;

void effect_through(
        UZURA *p,
        const int32_t *src, int32_t *des, int32_t count)
{
    int i;
    UZURA_LEVEL_INPUT(p).left = 0;
    UZURA_LEVEL_INPUT(p).right = 0;
    UZURA_LEVEL_OUTPUT(p).left = 0;
    UZURA_LEVEL_OUTPUT(p).right = 0;
    for (i = 0; i < count; i+=2) {
        *(des + i + 0) = *(src + i + 0) * volume.left;
        *(des + i + 1) = *(src + i + 1) * volume.right;
        UZURA_LEVEL_INPUT(p).left += abs(*(src + i + 0)) >> 1;
        UZURA_LEVEL_INPUT(p).right += abs(*(src + i + 1)) >> 1;
        UZURA_LEVEL_OUTPUT(p).left += abs(*(des + i + 0)) >> 1;
        UZURA_LEVEL_OUTPUT(p).right += abs(*(des + i + 1)) >> 1;
    }
}

void effect_karaoke(
        UZURA *p,
        const int32_t *src, int32_t *des, int32_t count)
{
    int i;
    UZURA_LEVEL_INPUT(p).left = 0;
    UZURA_LEVEL_INPUT(p).right = 0;
    UZURA_LEVEL_OUTPUT(p).left = 0;
    UZURA_LEVEL_OUTPUT(p).right = 0;
    for (i = 0; i < count; i+=2) {
        *(des + i + 0) = (*(src + i + 0) - *(src + i + 1)) * volume.left;
        *(des + i + 1) = (*(src + i + 0) - *(src + i + 1)) * volume.right;
        UZURA_LEVEL_INPUT(p).left += abs(*(src + i + 0)) >> 1;
        UZURA_LEVEL_INPUT(p).right += abs(*(src + i + 1)) >> 1;
        UZURA_LEVEL_OUTPUT(p).left += abs(*(des + i + 0)) >> 1;
        UZURA_LEVEL_OUTPUT(p).right += abs(*(des + i + 1)) >> 1;
    }
}

void effect_noise(
        UZURA *p,
        const int32_t *src, int32_t *des, int32_t count)
{
    int32_t i;
    uint32_t vl, vr;
    UZURA_LEVEL_INPUT(p).left = 0;
    UZURA_LEVEL_INPUT(p).right = 0;
    UZURA_LEVEL_OUTPUT(p).left = 0;
    UZURA_LEVEL_OUTPUT(p).right = 0;
    for (i = 0; i < count; i+=2) {
        tinyrand_pop(&tinyrand, 32, &vl);
        tinyrand_pop(&tinyrand, 32, &vr);
        *(des + i + 0) = vl;
        *(des + i + 1) = vr;
        UZURA_LEVEL_INPUT(p).left += abs(*(src + i + 0)) >> 1;
        UZURA_LEVEL_INPUT(p).right += abs(*(src + i + 1)) >> 1;
        UZURA_LEVEL_OUTPUT(p).left += abs(*(des + i + 0)) >> 1;
        UZURA_LEVEL_OUTPUT(p).right += abs(*(des + i + 1)) >> 1;
    }
}

void effect_param_init(void)
{
    volume.left = 1.0;
    volume.right = 1.0;
    tinyrand_init(&tinyrand, 0x512367);
}

void effect_param_volume(const double left, const double right)
{
    volume.left = left;
    volume.right = right;
}

