/**
 * @file at24c.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <builtins.h>
#include "at24c.h"
#include "twi.h"
#include "bfin_util.h"

#define DEVICE_PINCONF      (0)
#define DEVICE_ADDRESS(N)   (0x50 | ((N) & 0x07))

void at24c_init()
{
    twi_init();
}

void at24c_read(const uint32_t addr, uint8_t *data)
{
    uint8_t buf[1];
    buf[0] = addr;
    twi_master_write(DEVICE_ADDRESS(DEVICE_PINCONF), TWI_RSTART, &buf[0], 1);
    while (twi_master_xfer_state() != TWI_STATE_COMP) {
        ssync();
    }
    twi_master_read(DEVICE_ADDRESS(DEVICE_PINCONF), TWI_STOP, data, 1);
    while (twi_master_xfer_state() != TWI_STATE_COMP) {
        ssync();
    }
    bfin_util_usleep(5000);
}

void at24c_write(const uint32_t addr, const uint8_t data)
{
    uint8_t buf[2];
    buf[0] = addr;
    buf[1] = data;
    twi_master_write(DEVICE_ADDRESS(DEVICE_PINCONF), TWI_STOP, &buf[0], 2);
    while (twi_master_xfer_state() != TWI_STATE_COMP) {
        ssync();
    }
    bfin_util_usleep(5000);
}

