#pragma once
#include "resource.h"


class CJobRetryDelaySettingDlg: public CDialogImpl<CJobRetryDelaySettingDlg>,
	public CWinDataExchange<CJobRetryDelaySettingDlg>
{
public:
	enum { IDD = IDD_RETRY_DELAY_SETTING };

	BEGIN_DDX_MAP(CJobRetryDelaySettingDlg)
		DDX_CONTROL_HANDLE(IDOK,					m_buttonOK)
		DDX_CONTROL_HANDLE(IDC_EDIT_RETRY_DELAY,	m_editRetryDelay)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobRetryDelaySettingDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDOK,		OnOK)
		COMMAND_ID_HANDLER_EX(IDCANCEL,	OnCancel)
		COMMAND_HANDLER_EX(IDC_EDIT_RETRY_DELAY, EN_CHANGE,	OnEnChangeRetryDelay)
	END_MSG_MAP()

	CJobRetryDelaySettingDlg(void);
	~CJobRetryDelaySettingDlg(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

private:
	CButton m_buttonOK;
	CEdit	m_editRetryDelay;

	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob> m_spJob;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeRetryDelay(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitDialogControls(void);
};
