#include "StdAfx.h"
#include "StringDef.h"
#include "JobChangeReplyFilePathDlg.h"
#include "MiscUtil.h"
#include "WTLCtrlUtil.h"


CJobChangeReplyFilePathDlg::CJobChangeReplyFilePathDlg(void)
{
	NULL;
}


CJobChangeReplyFilePathDlg::~CJobChangeReplyFilePathDlg(void)
{
	NULL;
}


LRESULT CJobChangeReplyFilePathDlg::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(CenterWindow(GetParent()));
	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitDialogControls());
	ATLVERIFY(UpdateUI());

	return TRUE;
}


LRESULT CJobChangeReplyFilePathDlg::OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(DoDataExchange(TRUE));

	if (false == CheckReplyFilePath()) {
		return 0;
	}

	m_editReplyFilePath.GetWindowText(m_strReplyFilePath);

	EndDialog(nID);

	return 0;
}


LRESULT CJobChangeReplyFilePathDlg::OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	EndDialog(nID);

	return 0;
}


LRESULT CJobChangeReplyFilePathDlg::OnBrowseButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
													   __in CWindow /*wndCtl*/)
{
	CFileDialog dlg(FALSE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, REPLY_FILE_EXTENSION_FILTER);
	INT_PTR nAnswer = dlg.DoModal(m_hWnd);
	if (IDCANCEL == nAnswer) {
		return 0;
	}
	m_strReplyFilePath = dlg.m_ofn.lpstrFile;

	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editReplyFilePath, m_strReplyFilePath));
	m_editReplyFilePath.SetFocus();

	return 0;
}


LRESULT CJobChangeReplyFilePathDlg::OnEnChangeReplyFilePath(__in UINT /*uNotifyCode*/, __in int /*nID*/,
															__in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateUI());

	return 0;
}


bool CJobChangeReplyFilePathDlg::InitDialogControls(void)
{
	m_editReplyFilePath.SetWindowText(m_strReplyFilePath);

	return true;
}


bool CJobChangeReplyFilePathDlg::UpdateUI(void)
{
	CString strReplyFilePath;
	m_editReplyFilePath.GetWindowText(strReplyFilePath);
	if (true == strReplyFilePath.IsEmpty()) {
		m_buttonOK.EnableWindow(FALSE);
	} else {
		m_buttonOK.EnableWindow(TRUE);
	}

	return true;
}


__checkReturn bool CJobChangeReplyFilePathDlg::CheckReplyFilePath(void)
{
	CString strReplyFilePath;
	m_editReplyFilePath.GetWindowText(strReplyFilePath);

	BOOL bIsRelative	= ::PathIsRelative(strReplyFilePath);
	BOOL bIsDirectory	= ::PathIsDirectory(strReplyFilePath);
	BOOL bIsRoot		= ::PathIsRoot(strReplyFilePath);
	if (TRUE == bIsRelative || TRUE == bIsDirectory || TRUE == bIsRoot) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_REPLY_FILE_PATH, IDR_MAINFRAME, MB_OK | MB_ICONINFORMATION);
		m_editReplyFilePath.SetFocus();
		return false;
	}

	return true;
}


CString CJobChangeReplyFilePathDlg::GetReplyFilePath(void)
{
	return m_strReplyFilePath;
}


void CJobChangeReplyFilePathDlg::SetReplyFilePath(__in LPCWSTR lpszReplyFilePath)
{
	if (NULL == lpszReplyFilePath) {
		ATLASSERT(false);
		return;
	}

	m_strReplyFilePath = lpszReplyFilePath;

	return;
}

