#include "StdAfx.h"
#include "JobAdvancedSetting3Page.h"
#include "BITSDef.h"
#include "BITSUtil.h"
#include "WTLCtrlUtil.h"
#include "MiscUtil.h"


CJobAdvancedSetting3Page::CJobAdvancedSetting3Page(void)
{
	NULL;
}


CJobAdvancedSetting3Page::~CJobAdvancedSetting3Page(void)
{
	NULL;
}


LRESULT CJobAdvancedSetting3Page::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(DoDataExchange(FALSE));
	ATLASSERT(m_spJob4);

	ATLVERIFY(InitPropertyPageControls());
	ATLVERIFY(RefreshUI());

	return TRUE;
}


LRESULT CJobAdvancedSetting3Page::OnChangeCustomHeadersButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
																  __in CWindow /*wndCtl*/)
{
	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_CHANGE_CUSTOM_HEADERS, IDR_MAINFRAME,
		MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	CString strCustomHeaders;
	m_editCustomHeaders.GetWindowText(strCustomHeaders);

	HRESULT hr = BITSUtil::SetJobCustomHeaders(m_spHttpOptions, strCustomHeaders);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_CUSTOM_HEADERS_CHANGE_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_CUSTOM_HEADERS_CHANGED, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnRemoveCustomHeadersButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
																  __in CWindow /*wndCtl*/)
{
	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_REMOVE_CUSTOM_HEADERS, IDR_MAINFRAME,
		MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	HRESULT hr = BITSUtil::SetJobCustomHeaders(m_spHttpOptions, L"");
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_REMOVE_CUSTOM_HEADERS_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_CUSTOM_HEADERS_REMOVED, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

	m_editCustomHeaders.SetWindowText(L"");

	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnSetCertButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_SET_CLIENT_CERT, IDR_MAINFRAME, MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	BG_CERT_STORE_LOCATION certStoreLocation = GetCertStoreLocationFromComboBox();
	ATLASSERT(BITSUtil::VerifyCertStoreLocation(certStoreLocation));

	CString strCertStoreName;
	BITS_CERT_STORE_ID certStoreId = GetCertStoreNameFromComboBox();
	if (BITS_ID_CERT_INVALID == certStoreId) {
		m_comboCertStoreName.GetWindowText(strCertStoreName);
	} else {
		strCertStoreName = CertStoreStringFromId(certStoreId);
	}

	HRESULT hr = E_FAIL;
	if (BST_CHECKED == m_radioCertSubjectName.GetCheck()) {
		CString strSubjectName;
		m_editCertData.GetWindowText(strSubjectName);

		hr = BITSUtil::SetJobClientCertificateByName(m_spHttpOptions, certStoreLocation,
			strCertStoreName, strSubjectName);
	} else {
		ATLASSERT(BST_CHECKED == m_radioCertSHA1Hash.GetCheck());

		CString strSHA1Hash;
		m_editCertData.GetWindowText(strSHA1Hash);

		BYTE SHA1Hash[20] = {0};
		if (false == MiscUtil::ConvertSHA1HashByteFromString(strSHA1Hash, SHA1Hash)) {
			MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_SHA1_HASH_STRING, IDR_MAINFRAME, MB_OK | MB_ICONINFORMATION);
			m_editCertData.SetFocus();

			return 0;
		}
		
		hr = BITSUtil::SetJobClientCertificateById(m_spHttpOptions, certStoreLocation, strCertStoreName,
			SHA1Hash);
	}

	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_SET_CLIENT_CERT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_CLIENT_CERT_SET, NULL, MB_ICONINFORMATION | MB_OK);

	ATLVERIFY(ResetCertControls());

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnRemoveCertButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
														 __in CWindow /*wndCtl*/)
{
	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_REMOVE_CLIENT_CERT, IDR_MAINFRAME, 
		MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	HRESULT hr = BITSUtil::RemoveJobClientCertificate(m_spHttpOptions);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_REMOVE_CLIENT_CERT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);
	} else if (S_FALSE == hr) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NO_CLIENT_CERT_REMOVED, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
	} else {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_CLIENT_CERT_REMOVED, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
	}

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnRadioButtonClicked(__in UINT /*uNotifyCode*/, __in int /*nID*/,
													   __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateUI());

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnCertComboBoxSelChanged(__in UINT /*uNotifyCode*/, __in int /*nID*/,
														   __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateUI());

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnEnChangeCustomHeaders(__in UINT /*uNotifyCode*/, __in int /*nID*/,
														  __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateUI());

	return 0;
}


LRESULT CJobAdvancedSetting3Page::OnEnChangeCertData(__in UINT /*uNotifyCode*/, __in int /*nID*/,
													 __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateUI());

	return 0;
}


bool CJobAdvancedSetting3Page::InitPropertyPageControls(void)
{
	ATLVERIFY(InitCustomHeadersControls());
	ATLVERIFY(InitCertControls());

	return true;
}


bool CJobAdvancedSetting3Page::InitCustomHeadersControls(void)
{
	m_editCustomHeaders.SetLimitText(BITS_MAX_CUSTOM_HEADERS_LEN);

	return true;
}


bool CJobAdvancedSetting3Page::InitCertControls(void)
{
	ATLVERIFY(InitCertLocationComboBox());
	ATLVERIFY(InitCertNameComboBox());

	m_radioCertSubjectName.SetCheck(BST_UNCHECKED);
	m_radioCertSHA1Hash.SetCheck(BST_UNCHECKED);

	m_buttonSetCert.EnableWindow(FALSE);
	m_buttonRemoveCert.EnableWindow(TRUE);

	m_editCertData.SetLimitText(BITS_MAX_CERT_SUBJECT_NAME_LEN);
	m_editCertData.EnableWindow(FALSE);

	return true;
}


bool CJobAdvancedSetting3Page::InitCertLocationComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_CURRENT_USER,
		BG_CERT_STORE_LOCATION_CURRENT_USER);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_LOCAL_MACHINE,
		BG_CERT_STORE_LOCATION_LOCAL_MACHINE);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_CURRENT_SERVICE ,
		BG_CERT_STORE_LOCATION_CURRENT_SERVICE );
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_SERVICES,
		BG_CERT_STORE_LOCATION_SERVICES);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_USERS ,
		BG_CERT_STORE_LOCATION_USERS);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_CURRENT_USER_GROUP_POLICY,
		BG_CERT_STORE_LOCATION_CURRENT_USER_GROUP_POLICY);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_LOCAL_MACHINE_GROUP_POLICY,
		BG_CERT_STORE_LOCATION_LOCAL_MACHINE_GROUP_POLICY);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertLocation, IDS_CERT_STORE_LOCATION_LOCAL_MACHINE_ENTERPRISE,
		BG_CERT_STORE_LOCATION_LOCAL_MACHINE_ENTERPRISE);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(SetCertStoreLocationToComboBox(BG_CERT_STORE_LOCATION_CURRENT_USER));

	return true;
}


bool CJobAdvancedSetting3Page::InitCertNameComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertStoreName, IDS_CERT_STORE_NAME_CA,
		BITS_ID_CERT_STORE_CA);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertStoreName, IDS_CERT_STORE_NAME_MY,
		BITS_ID_CERT_STORE_MY);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertStoreName, IDS_CERT_STORE_NAME_ROOT,
		BITS_ID_CERT_STORE_ROOT);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboCertStoreName, IDS_CERT_STORE_NAME_SPC,
		BITS_ID_CERT_STORE_SPC);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(CB_ERR != m_comboCertStoreName.LimitText(BITS_MAX_CERT_STORE_NAME_LEN));
	ATLVERIFY(SetCertStoreNameToComboBox(BITS_ID_CERT_STORE_CA));

	return true;
}


bool CJobAdvancedSetting3Page::ResetCertControls(void)
{
	ATLVERIFY(SetCertStoreNameToComboBox(BITS_ID_CERT_STORE_CA));
	ATLVERIFY(SetCertStoreLocationToComboBox(BG_CERT_STORE_LOCATION_CURRENT_USER));

	m_radioCertSubjectName.SetCheck(BST_UNCHECKED);
	m_radioCertSHA1Hash.SetCheck(BST_UNCHECKED);

	ATLVERIFY(UpdateUI());

	return true;
}


__checkReturn bool CJobAdvancedSetting3Page::IsBITS25Supported(void)
{
	if (!m_spJob4) {
		return false;
	}

	return true;
}


bool CJobAdvancedSetting3Page::RefreshUI(void)
{
	ATLVERIFY(RefreshCustomHeadersInfo());
	ATLVERIFY(UpdateUI());

	return true;
}


bool CJobAdvancedSetting3Page::RefreshCustomHeadersInfo(void)
{
	CString strCustomHeaders;
	HRESULT hr = BITSUtil::GetJobCustomHeaders(m_spHttpOptions, &strCustomHeaders);
	if (FAILED(hr)) {
		m_editCustomHeaders.EnableWindow(FALSE);
		m_buttonRemoveCustomHeaders.EnableWindow(FALSE);
		m_buttonChangeCustomHeaders.EnableWindow(FALSE);
		
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_GET_CUSTOM_HTTP_HEADER_FAILED_WITH_CODE, strErrorDescription);

		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editCustomHeaders, strMessage));

		return true;
	} else {
		m_editCustomHeaders.EnableWindow(TRUE);
		m_buttonChangeCustomHeaders.EnableWindow(TRUE);
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editCustomHeaders, strCustomHeaders));

		if (true == strCustomHeaders.IsEmpty()) {
			if (GetFocus() == m_buttonRemoveCustomHeaders) {
				m_editCustomHeaders.SetFocus();
			}
			m_buttonRemoveCustomHeaders.EnableWindow(FALSE);
		} else {
			m_buttonRemoveCustomHeaders.EnableWindow(TRUE);
		}
	}

	return true;
}


bool CJobAdvancedSetting3Page::UpdateUI(void)
{
	ATLVERIFY(UpdateCertControls());
	ATLVERIFY(UpdateCustomHeadersControls());

	return true;
}


bool CJobAdvancedSetting3Page::UpdateCustomHeadersControls(void)
{
	if (0 == m_editCustomHeaders.IsWindowEnabled()) {
		m_buttonChangeCustomHeaders.EnableWindow(FALSE);
		m_buttonRemoveCustomHeaders.EnableWindow(FALSE);
		return true;
	}

	CString strCustomHeaders;
	m_editCustomHeaders.GetWindowText(strCustomHeaders);

	if (true == strCustomHeaders.IsEmpty()) {
		m_buttonChangeCustomHeaders.EnableWindow(FALSE);
	} else {
		m_buttonChangeCustomHeaders.EnableWindow(TRUE);
	}

	return true;
}


bool CJobAdvancedSetting3Page::UpdateCertControls(void)
{
	CString strCertStoreName;
	m_comboCertStoreName.GetWindowText(strCertStoreName);

	CString strCertData;
	m_editCertData.GetWindowText(strCertData);

	if ((BST_CHECKED == m_radioCertSubjectName.GetCheck() || BST_CHECKED == m_radioCertSHA1Hash.GetCheck())) {
		m_editCertData.EnableWindow(TRUE);
		if (false == strCertStoreName.IsEmpty() && false == strCertData.IsEmpty()) {
			m_buttonSetCert.EnableWindow(TRUE);
		} else {
			m_buttonSetCert.EnableWindow(FALSE);
		}
	} else {
		m_editCertData.EnableWindow(FALSE);
		m_buttonSetCert.EnableWindow(FALSE);
	}

	return true;
}


BG_CERT_STORE_LOCATION CJobAdvancedSetting3Page::GetCertStoreLocationFromComboBox(void)
{
	int nCurSel = m_comboCertLocation.GetCurSel();
	ATLASSERT(CB_ERR != nCurSel);

	return static_cast<BG_CERT_STORE_LOCATION>(m_comboCertLocation.GetItemData(nCurSel));
}


bool CJobAdvancedSetting3Page::SetCertStoreLocationToComboBox(__in BG_CERT_STORE_LOCATION certStoreLocation)
{
	ATLASSERT(BITSUtil::VerifyCertStoreLocation(certStoreLocation));

	int nItemCount = m_comboCertLocation.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (certStoreLocation == static_cast<BG_CERT_STORE_LOCATION>(m_comboCertLocation.GetItemData(nIndex))) {
			m_comboCertLocation.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


__checkReturn BITS_CERT_STORE_ID CJobAdvancedSetting3Page::CertStoreIdFromString(__in LPCWSTR lpszCertStoreName)
{
	if (NULL == lpszCertStoreName) {
		ATLASSERT(false);
		return BITS_ID_CERT_INVALID;
	}

	CString strCertStoreName = lpszCertStoreName;
	if (0 == strCertStoreName.CompareNoCase(BITS_CERT_STORE_CA)) {
		return BITS_ID_CERT_STORE_CA;
	} else if (0 == strCertStoreName.CompareNoCase(BITS_CERT_STORE_MY)) {
		return BITS_ID_CERT_STORE_MY;
	} else if (0 == strCertStoreName.CompareNoCase(BITS_CERT_STORE_ROOT)) {
		return BITS_ID_CERT_STORE_ROOT;
	} else if (0 == strCertStoreName.CompareNoCase(BITS_CERT_STORE_SPC)) {
		return BITS_ID_CERT_STORE_SPC;
	} else {
		ATLASSERT(false);
	}

	return BITS_ID_CERT_INVALID;
}


__checkReturn CString CJobAdvancedSetting3Page::CertStoreStringFromId(__in BITS_CERT_STORE_ID certStoreId)
{
	CString strCertStoreString;

	switch (certStoreId) {
		case BITS_ID_CERT_STORE_CA:
			strCertStoreString = BITS_CERT_STORE_CA;
			break;

		case BITS_ID_CERT_STORE_MY:
			strCertStoreString = BITS_CERT_STORE_MY;
			break;

		case BITS_ID_CERT_STORE_ROOT:
			strCertStoreString = BITS_CERT_STORE_ROOT;
			break;

		case BITS_ID_CERT_STORE_SPC:
			strCertStoreString = BITS_CERT_STORE_SPC;
			break;

		default:
			ATLASSERT(false);
			break;
	}

	return strCertStoreString;
}


BITS_CERT_STORE_ID CJobAdvancedSetting3Page::GetCertStoreNameFromComboBox(void)
{
	int nCurSel = m_comboCertStoreName.GetCurSel();
	if (CB_ERR == nCurSel) {
		return BITS_ID_CERT_INVALID;
	}

	return static_cast<BITS_CERT_STORE_ID>(m_comboCertStoreName.GetItemData(nCurSel));
}


bool CJobAdvancedSetting3Page::SetCertStoreNameToComboBox(__in BITS_CERT_STORE_ID certStoreId)
{
	int nItemCount = m_comboCertStoreName.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (certStoreId == static_cast<BITS_CERT_STORE_ID>(m_comboCertStoreName.GetItemData(nIndex))) {
			m_comboCertStoreName.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


void CJobAdvancedSetting3Page::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobAdvancedSetting3Page::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob4) {
		ATLASSERT(false);
		m_spJob4.Release();
	}
	m_spJob4 = spJob;

	if (m_spJob4) {
		if (m_spHttpOptions) {
			ATLASSERT(false);
			m_spHttpOptions.Release();
		}
		m_spHttpOptions = spJob;
	}

	return;
}

