#pragma once

struct HEADER_COLUMN_INFO {
	DWORD dwColumnIndex;
	DWORD dwColumnWidth;
	UINT  unStringId;
};


class CBITSExplorerView : public CWindowImpl<CBITSExplorerView, CListViewCtrl>
{
public:
	DECLARE_WND_SUPERCLASS(NULL, CListViewCtrl::GetWndClassName())

	BEGIN_MSG_MAP(CBITSExplorerView)
		MSG_WM_CREATE(OnCreate)
		MSG_WM_DESTROY(OnDestroy)
		REFLECTED_NOTIFY_CODE_HANDLER_EX(NM_RCLICK, OnReflectedNMRClick)
		REFLECTED_NOTIFY_CODE_HANDLER_EX(NM_DBLCLK, OnReflectedNMDBClick)
	END_MSG_MAP()

	static const DWORD DISPLAY_NAME_COLUMN_INDEX		= 0;
	static const DWORD DISPLAY_NAME_COLUMN_WIDTH		= 150;
	static const DWORD TYPE_COLUMN_INDEX				= 1;
	static const DWORD TYPE_COLUMN_WIDTH				= 140;
	static const DWORD PRIORITY_COLUMN_INDEX			= 2;
	static const DWORD PRIORITY_COLUMN_WIDTH			= 85;
	static const DWORD STATE_COLUMN_INDEX				= 3;
	static const DWORD STATE_COLUMN_WIDTH				= 100;
	static const DWORD SIZE_COLUMN_INDEX				= 4;
	static const DWORD SIZE_COLUMN_WIDTH				= 85;
	static const DWORD TRANSFERED_COLUMN_INDEX			= 5;
	static const DWORD TRANSFERED_COLUMN_WIDTH			= 85;
	static const DWORD PROGRESS_COLUMN_INDEX			= 6;
	static const DWORD PROGRESS_COLUMN_WIDTH			= 85;
	static const DWORD OWNER_COLUMN_INDEX				= 7;
	static const DWORD OWNER_COLUMN_WIDTH				= 110;

	static const DWORD JOB_STATE_IMAGE_LIST_SIZE_X		= 16;
	static const DWORD JOB_STATE_IMAGE_LIST_SIZE_Y		= 16;

	static const COLORREF LIST_VIEW_BMP_MASK			= RGB(255, 0, 255);

	static const DWORD CANCEL_ICON_IMAGE_INDEX			= 0;
	static const DWORD PAUSE_ICON_IMAGE_INDEX			= 1;
	static const DWORD RUNNING_ICON_IMAGE_INDEX			= 2;
	static const DWORD COMPLETE_ICON_IMAGE_INDEX		= 3;
	static const DWORD WARNING_ICON_IMAGE_INDEX			= 4;
	static const DWORD ERROR_ICON_IMAGE_INDEX			= 5;

	CBITSExplorerView();

	BOOL PreTranslateMessage(__in MSG* pMsg);

	bool CreateHeaderColumns(void);
	bool InitJobStateImageList(void);

	bool Refresh(bool bCleanup = false);

	__checkReturn CComPtr<IBackgroundCopyJob> GetSelectedJob(void);
	inline __checkReturn CComPtr<IBackgroundCopyManager> GetBITSManager(void) const
	{
		return m_spBITSManager; 
	}

	inline void SetDisplyAllUsersJobsFlag(bool bShow)
	{
		m_bDisplyAllUsersJobs = bShow;
	}

private:
	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	bool m_bDisplyAllUsersJobs;

	LRESULT OnCreate(__in CREATESTRUCT* /*lpCreateStruct*/);
	LRESULT OnDestroy(void);
	LRESULT OnReflectedNMRClick(__in LPNMHDR pnmh);
	LRESULT OnReflectedNMDBClick(__in LPNMHDR pnmh);

	bool AddHeaderColumn(__in const HEADER_COLUMN_INFO& columnInfo);

	int	 CreateItem(__in const GUID& jobId, __in const CComPtr<IBackgroundCopyJob>& spJob);
	bool DeleteItem(__in int nItemIndex);
	int  FindItem(__in const GUID& jobId);
	bool UpdateAllItems(void);
	bool UpdateItem(__in int nItemIndex, __in const CComPtr<IBackgroundCopyJob>& spJob);
	bool UpdateItemText(__in int nItemIndex, __in int nSubItem, __in LPCWSTR lpszText);
	bool UpdateItemImageIcon(__in int nItemIndex, __in BG_JOB_STATE jobState);

	bool TrackJobPopupMenu(void);

	int GetImageIndexFromJobState(__in BG_JOB_STATE jobState);

	bool DeleteAllItems(void);
	bool CleanupOldItems(__in const CSimpleArray<GUID>& activeJobIdArray);
};
