/**
  * $Id: SGTemplatesManager.h,v 1.1.1.1 2005-05-11 17:51:45 tsawada2 Exp $
  * 
  * SGTemplatesManager.h
  *
  * Copyright (c) 2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */

#ifndef SGTEMPLATE_MGR_INCLUDED
#define SGTEMPLATE_MGR_INCLUDED

#import <Cocoa/Cocoa.h>
#import <SGFoundation/SGBase.h>

SG_DECL_BEGIN



/*!
 * @define      kSGAttributesTemplateFile
 * @discussion  t̃ev[gt@C
 */
#define kSGAttributesTemplateFile		@"StyleTemplates"
/*!
 * @define      kSGPropertyListTemplateFile
 * @discussion  Property List`̃ev[gt@C
 */
#define kSGPropertyListTemplateFile		@"KeyValueTemplates"



@interface NSMutableAttributedString(SGTemplateResourcesManagerPrivate)
- (id) setStringAndReturnSelf : (NSString *) aString;
@end



/*

[Attributed String Template]
RTF, RTFDt@CɋLqʎqoA
NSMutableAttributedString̃CX^XƂĊǗł܂B

Ƃ΁A%%%ExampleIdentifier%%%ƋLqRTFt@C
pӂĂ荞ނƁAAvP[V
- resourceForKey:@"ExampleIdentifier"
NSMutableAttributedStringCX^X𓾂邱Ƃł܂B

*/

@interface SGTemplatesManager : NSObject
{
	@private
	NSMutableDictionary		*_resources;
}
/*!
 * @method      sharedInstance
 * @abstract    LCX^X
 * @discussion  
 * 
 * AvP[VApplecation SupportfBNg
 * + [NSBundle mainBundle]烊\[XTCX^X
 * 
 * @result      LCX^X
 */
+ (SGTemplatesManager *) sharedInstance;

- (id) resourceForKey : (id) aKey;
- (void) addResourcesFromContentsOfFile : (NSString *) filepath;

- (void) resetAllResources;
@end


#define SGTemplateResource(aKey)	[[SGTemplatesManager sharedInstance] resourceForKey : (aKey)]

// Property List
#define SGTemplateSize(aKey)	NSSizeFromString(SGTemplateResource(aKey))
#define SGTemplatePoint(aKey)	NSPointFromString(SGTemplateResource(aKey))
#define SGTemplateRect(aKey)	NSRectFromString(SGTemplateResource(aKey))

#define SGTemplateSelector(aKey)	NSSelectorFromString(SGTemplateResource(aKey))
#define SGTemplateClass(aKey)	NSClassFromString(SGTemplateResource(aKey))


// v~eBu
#define SGTemplateBool(aKey)	[SGTemplateResource(aKey) boolValue]


// t
#define SGTemplateAttrString(aKey, aString)	[SGTemplateResource(aKey) setStringAndReturnSelf : (aString)]

#define SGTemplateAttribute(aKey, aName)	[SGTemplateResource(aKey) attribute:(aName) atIndex:0 effectiveRange:NULL]

// NSDictionary
#define SGTemplateAttributes(aKey)	[SGTemplateResource(aKey) attributesAtIndex:0 effectiveRange:NULL]

#define SGTemplateColor(aKey)	SGTemplateAttribute(aKey, NSForegroundColorAttributeName)

#define SGTemplateFont(aKey)	SGTemplateAttribute(aKey, NSFontAttributeName)



SG_DECL_END


#endif /* SGTEMPLATE_MGR_INCLUDED*/
