/**
  * $Id: CMRSubjectReader.m,v 1.4 2006-02-24 15:13:21 tsawada2 Exp $
  * 
  * CMRSubjectReader.m
  *
  * Copyright (c) 2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */
#import "CocoMonar_Prefix.h"
#import "CMRSubjectReader.h"

#import "CMXTextParser.h"
#import "CMRThreadSubjectComposer.h"



/*
2channel݊܂BBSsubject.txt͍s̖
ʂȂǂň͂܂ĂB
̈͂ł镶̃ZbgiJʂ̂݁j
*/
static NSCharacterSet *CMXSubjectCountBracketSet(void);
// subject.txt擾^CgK؂Ȍ`ɕϊ
static NSString *preprocessWithTitle(NSString *aTitle);



@implementation CMRSubjectReader
APP_SINGLETON_FACTORY_METHOD_IMPLEMENTATION(reader);


- (BOOL) composeLine : (NSString             *) aLine
          lineNumber : (unsigned int          ) aLineNum
        withComposer : (id<CMRSubjectComposer>) aComposer
{
	NSCharacterSet		*bracketCSet_ = CMXSubjectCountBracketSet();
	NSArray				*components_;
	
	NSString			*identifier_ = nil;
	id					title_       = nil;
	unsigned int		resCount_    = NSNotFound;
	
	NSRange				resRange_;
	
	UTILAssertNotNil(aComposer);
	UTILRequireCondition(aLine && NO == [aLine isEmpty], ErrCompose);
	
	// subject.txt͂Ȃ炩̎ŋ؂蕶݂鎖悤Ȃ̂ŁA
	// sׂ
	// ؂蕶s̏ꍇ͏Ȃ
	//
	//   0 : datʎq iK{j
	//   1 : ^Cg@iK{j--> XɂĂ邩
	//   2 : X@@i邩j
	
	components_ = [CMXTextParser separatedLine : aLine];
	UTILRequireCondition(components_ && [components_ count] >= 2, ErrCompose);
	//NSLog(@"%@",[components_ description]);
	// ʎq
	identifier_ = [components_ objectAtIndex : 0];
	identifier_ = [identifier_ stringByDeletingPathExtension];
	
	// ^Cg
	title_ = [components_ objectAtIndex : 1];
	
	// Rڂ̃tB[h
	if([components_ count] >= 3){
		const char		*s;
		
		if((s = [[components_ objectAtIndex : 2] UTF8String]) != NULL){
			char	*endp;
			
			resCount_ = strtoul(s, &endp, 10);
			if(endp == s) resCount_ = NSNotFound;
		}
	}
	
	// ܂X肵ĂȂƂƂ͎OԖڂ̃tB[hȂ
	// ^Cg̖𒲂ׂāAłȂ΃G[
	if(NSNotFound == resCount_){
		NSString			*field_;
		NSScanner			*scanner_;
		int				resCount2_;
		
		// ^CgƃX𒲂ׂ
		// X擾B
		// ^Cg̖'<res>','(res)','iresj'̂ꂩ
		// ̌`ŋLqĂ̂ŁA^Cg̖"<(i"ꂩ
		// ANSScannerŐ𓾂B
		field_ = title_;
		resRange_ = 
		  [field_ rangeOfCharacterFromSet : bracketCSet_
		  						options : NSBackwardsSearch];
		UTILRequireCondition(
			resRange_.location != NSNotFound && resRange_.length != 0,
			ErrCompose);
		scanner_ = [NSScanner scannerWithString : field_];
		//ŏ̊Jʂ͔΂
		//resCount_ = 0;
		resCount2_ = 0;
		[scanner_ setScanLocation : NSMaxRange(resRange_)];
		//if(NO == [scanner_ scanInt : &resCount_]){
		if(NO == [scanner_ scanInt : &resCount2_]){
			resCount_ = NSNotFound;
		} else {
			resCount_ = (unsigned int)resCount2_;
		}
		title_ = [field_ substringToIndex : resRange_.location];
	}
	title_ = preprocessWithTitle(title_);
	
	
	[aComposer composeIndex : aLineNum];
	[aComposer composeIdentifier : identifier_];
	[aComposer composeTitle : title_];
	[aComposer composeCount : resCount_];
	
	
	return YES;
	
ErrCompose:
	return NO;
}
@end



static NSCharacterSet *CMXSubjectCountBracketSet(void)
{
	static NSCharacterSet	*kResCountBracketSet;
	
	if(nil == kResCountBracketSet){
		NSString		*separaters_;
		
		separaters_ = NSLocalizedString(@"ResCount Separater", nil);
		UTILCAssertNotNil(separaters_);
		kResCountBracketSet = 
			[[NSCharacterSet 
				characterSetWithCharactersInString : separaters_] copy];
	}
	return kResCountBracketSet;
}
static NSString *preprocessWithTitle(NSString *aTitle)
{
	NSMutableString		*tmp = SGTemporaryString();
	NSString			*title_ = aTitle;
	
	if(nil == title_) return title_;
	
	[tmp setString : title_];
	[tmp replaceEntityReference];
		
	if(NO == [tmp isSameAsString : title_])
		title_ = [[tmp copy] autorelease];
	
	[tmp setString : @""];
	return title_;
}
