//
//  BSFileManagerHelper.m
//  BSDictionaryServicesHelper
//
//  Created by Tsutomu Sawada on 09/12/12.
//  Copyright 2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSFileManagerHelper.h"
#import <Carbon/Carbon.h>
#import <AudioToolbox/AudioToolbox.h>


@implementation BSFileManagerHelper
+ (BOOL)moveFilesToTrashSync:(NSArray *)files
{
    OSStatus err;
    for (NSString *path in files) {
        const char *rep = [path fileSystemRepresentation];
        err = FSPathMoveObjectToTrashSync(rep, NULL, kFSFileOperationDefaultOptions);
        if (err != noErr) {
            return NO;
        }
    }
    AudioServicesPlaySystemSound(16);
    return YES;
}
@end
