//
//  CMRThreadViewer.h
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 10/01/01.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Cocoa/Cocoa.h>
#import "CMRStatusLineWindowController.h"
#import "CMRFavoritesManager.h"

@class CMRIndexingStepper;
@class CMRThreadLayout;
@class CMRThreadAttributes;
@class CMRThreadSignature;
@class BSIndexingPopupper;
@class CMRReplyMessenger;

@interface CMRThreadViewer : CMRStatusLineWindowController
{	
	// History
	unsigned					_historyIndex;
	NSMutableArray				*_history;
	
	// Helper
	CMRThreadLayout             *_layout;
	NSUndoManager               *m_undo;

	// Interface
	IBOutlet NSView				*m_navigationBar;	
	IBOutlet NSView				*m_componentsView;
	IBOutlet NSView				*m_containerView;
	IBOutlet NSView				*m_windowContentView;	// dummy
	IBOutlet NSScrollView		*m_scrollView;
	IBOutlet NSTextView			*m_textView;
	
	struct {
		unsigned int invalidate:1; // invalid contents
		unsigned int themechangeing:1; // change theme task is in progress
//        unsigned int maruDownload:1; // ●で取得した→あとでスレッドを DB に登録必要
        unsigned int retrieving:1; // 再取得作業中→オフライン時でもリロード必須
		unsigned int reserved:29;
	} _flags;
}

/* Register history list if relativeIndex == 0 */
- (void)setThreadContentWithThreadIdentifier:(id)aThreadIdentifier noteHistoryList:(int)relativeIndex;
- (void)setThreadContentWithFilePath:(NSString *)filepath boardInfo:(NSDictionary *)boardInfo noteHistoryList:(int)relativeIndex;
- (void)setThreadContentWithThreadIdentifier:(id)aThreadIdentifier;
- (void)setThreadContentWithFilePath:(NSString *)filepath boardInfo:(NSDictionary *)boardInfo;

- (void)loadFromContentsOfFile:(NSString *)filepath;
- (void)composeDATContents:(NSString *)datContents threadSignature:(CMRThreadSignature *)aSignature nextIndex:(unsigned int)aNextIndex;

/*** auxiliary ***/
- (BOOL)isInvalidate;
- (void)setInvalidate:(BOOL)flag;
- (BOOL)changeThemeTaskIsInProgress;
- (void)setChangeThemeTaskIsInProgress:(BOOL)flag;
//- (BOOL)isMaruDownload;
//- (void)setMaruDownload:(BOOL)flag;
- (BOOL)isRetrieving;
- (void)setRetrieving:(BOOL)flag;

- (CMRThreadLayout *)threadLayout;
- (CMRThreadAttributes *)threadAttributes;

- (NSString *)titleForTitleBar;

/* called when thread did be changed */
- (void)didChangeThread;

- (void)closeWindowOfAlert:(NSAlert *)alert;

/*** NO_NAME properties ***/
- (NSString *)detectDefaultNoName;
- (void)setupDefaultNoNameIfNeeded;

- (NSString *)path;
- (NSString *)title;
- (NSString *)boardName;
- (NSURL *)boardURL;
- (NSURL *)threadURL;
- (NSString *)datIdentifier;
- (NSString *)bbsIdentifier;
- (NSArray *)cachedKeywords;
- (void)setCachedKeywords:(NSArray *)array;
@end


@interface CMRThreadViewer(Action)
- (NSPoint)locationForInformationPopUp;

// NOTE: CMRBrowser overrides this method.
- (NSArray *)targetThreadsForAction:(SEL)action;
- (NSArray *)targetBoardsForAction:(SEL)action;

- (void)quoteWithMessenger:(CMRReplyMessenger *)aMessenger;
- (CMRReplyMessenger *)plainReply:(id)sender;

// KeyBinding...
- (IBAction)reloadThread:(id)sender;
- (IBAction)reply:(id)sender;

- (IBAction)copyThreadAttributes:(id)sender;

- (IBAction)copySelectedResURL:(id)sender;
- (IBAction)reloadIfOnlineMode:(id)sender;
- (IBAction)addFavorites:(id)sender;

- (IBAction)openBBSInBrowser:(id)sender;
- (IBAction)showBoardInspectorPanel:(id)sender;
- (IBAction)showLocalRules:(id)sender;

// make text area to be first responder
- (IBAction)focus:(id)sender;
// NOTE: It is a history item's action.
- (IBAction)showThreadFromHistoryMenu:(id)sender; // Overrides CMRAppDelegate's one.

- (IBAction)biggerText:(id)sender;
- (IBAction)smallerText:(id)sender;
@end


@interface CMRThreadViewer(DeletionAndRetrieving)
- (void)closeWindowIfNeededAtPath:(NSString *)path;

- (BOOL)forceDeleteThreads:(NSArray *)threads;
- (BOOL)prepareRetrieving:(NSString *)logFilePath error:(NSError **)error;
- (BOOL)retrieveThreadAtPath:(NSString *)filepath title:(NSString *)title;

- (IBAction)deleteThread:(id)sender;
- (IBAction)retrieveThread:(id)sender;
@end


@interface CMRThreadViewer(History)
// History: ThreadSignature...
- (unsigned)historyIndex;
- (void)setHistoryIndex:(unsigned)aHistoryIndex;
- (NSMutableArray *)threadHistoryArray;

- (id)threadIdentifierFromHistoryWithRelativeIndex:(int)relativeIndex;
- (void)noteHistoryThreadChanged:(int)relativeIndex;
- (void)clearThreadHistories;

- (IBAction)historyMenuPerformForward:(id)sender;
- (IBAction)historyMenuPerformBack:(id)sender;
@end


@interface CMRThreadViewer(MoveAction)
/* 最初／最後のレス */
- (IBAction)scrollFirstMessage:(id)sender;
- (IBAction)scrollLastMessage:(id)sender;

/* 次／前のレス */
- (IBAction)scrollPrevMessage:(id)sender;
- (IBAction)scrollPreviousMessage:(id)sender;
- (IBAction)scrollNextMessage:(id)sender;

/* 次／前のブックマーク */
- (IBAction)scrollPreviousBookmark:(id)sender;
- (IBAction)scrollNextBookmark:(id)sender;

- (IBAction)scrollToLastReadedIndex:(id)sender;
- (IBAction)scrollToLastUpdatedIndex:(id)sender;

/* 今日のレス (available in Starlight Breaker.) */
- (IBAction)scrollToFirstTodayMessage:(id)sender;
@end


@interface CMRThreadViewer(MoveActionSupport)
- (void)updateIndexField;
- (void)scrollMessageAtIndex:(int)index;
@end


@interface CMRThreadViewer(TextViewSupport)
- (IBAction)findNextText:(id)sender;
- (IBAction)findPreviousText:(id)sender;
- (IBAction)findFirstText:(id)sender;
- (IBAction)findAll:(id)sender;
- (IBAction)findAllByFilter:(id)sender;

// Available in Starlight Breaker. For ID Popup.
- (void)extractMessagesWithIDString:(NSString *)IDString popUpLocation:(NSPoint)location;
@end


@interface CMRThreadViewer(Validation)
- (BOOL)validateDeleteThreadItemEnabling:(NSString *)threadPath;
- (void)validateDeleteThreadItemTitle:(id)theItem;
- (void)validateShowBoardInspectorPanelItemTitle:(id)item;
- (CMRFavoritesOperation)favoritesOperationForThreads:(NSArray *)threadsArray;
- (BOOL)validateAddFavoritesItem:(id)theItem forOperation:(CMRFavoritesOperation)operation;
@end


@interface CMRThreadViewer(SelectingThreads)
- (unsigned int)numberOfSelectedThreads;
- (NSDictionary *)selectedThread;
- (NSArray *)selectedThreads;
@end


extern NSString *const CMRThreadViewerDidChangeThreadNotification;

/**
  * userInfo:
  * 	@"Count"	-- number of found items (NSNumber, as an unsigned int)
  *
  */
#define kAppThreadViewerFindInfoKey	@"Count"

extern NSString *const BSThreadViewerWillStartFindingNotification;
extern NSString *const BSThreadViewerDidEndFindingNotification;

extern void *kThreadViewerAttrContext;
