//: NSString-SGExtensions.h
/**
  * $Id: NSString-SGExtensions.h,v 1.1.1.1 2005-05-11 17:51:45 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */

#import <Foundation/Foundation.h>
#import <CoreServices/CoreServices.h>



//
// CFStringEncoding <--> NSStringEncoding
//
#define CF2NSEncoding(x)	CFStringConvertEncodingToNSStringEncoding(x)
#define NS2CFEncoding(x)	CFStringConvertNSStringEncodingToEncoding(x)

//
// CFStringEncoding <--> TextEncoding
//
#define CF2TextEncoding(x)	x
#define Text2CFEncoding(x)	x


@interface NSString(SGExtensionTEC)
// Using TEC
- (id) initWithDataUsingTEC : (NSData     *) theData
                   encoding : (TextEncoding) encoding;
+ (id) stringWithDataUsingTEC : (NSData     *) theData
                     encoding : (TextEncoding) encoding;
@end



@interface NSString(SGExtensions)
+ (id) stringWithData : (NSData         *) data
             encoding : (NSStringEncoding) encoding;

+ (id) stringWithCharacter : (unichar) aCharacter;
- (id) initWithCharacter : (unichar) aCharacter;

+ (id) stringWithCStringNoCopy : (char *  ) cString
 						length : (unsigned) length
				  freeWhenDone : (BOOL    ) freeBuffer;
+ (id) stringWithCStringNoCopy : (char *  ) cString
				  freeWhenDone : (BOOL    ) freeBuffer;
// freeWhenDone == NO
+ (id) stringWithCStringNoCopy : (const char *) cString;


//////////////////////////////////////////////////////////////////////
//////////////////// [ CX^X\bh ] ////////////////////////
//////////////////////////////////////////////////////////////////////
- (BOOL) isValidURLCharacters;
- (NSString *) stringByDeletingURLScheme : (NSString *) aScheme;


/**
  * V[oaStringɎw肵܂ޏꍇYESԂB
  * 
  * @param    aString  T
  * @return            V[oaStringɎw肵܂ޏꍇYES
  */
- (BOOL) containsString : (NSString *) aString;

/**
  * V[oaStringɎw肵Zbg܂ޏꍇYESԂB
  * 
  * @param    characterSet  TZbg
  * @return                 V[oaStringɎw肵܂ޏꍇYES
  */
- (BOOL) containsCharacterFromSet : (NSCharacterSet *) characterSet;

//Data Using CFStringEncoding
/**
  * V[of[^ŕԂB
  * 
  * @param    anEncoding  CFStringEncoding
  * @return               ̃f[^
  */
- (NSData *) dataUsingCFEncoding : (CFStringEncoding) anEncoding;

/**
  * V[of[^ŕԂB
  * 
  * @param    anEncoding  CFStringEncoding
  * @param    lossy       f[^𖳎
  * @return               ̃f[^
  */
- (NSData *) dataUsingCFEncoding : (CFStringEncoding) anEncoding
            allowLossyConversion : (BOOL            ) lossy;

- (NSRange) rangeOfCharacterSequenceFromSet : (NSCharacterSet *) aSet;
- (NSRange) rangeOfCharacterSequenceFromSet : (NSCharacterSet *) aSet
									options : (unsigned int    ) mask;
- (NSRange) rangeOfCharacterSequenceFromSet : (NSCharacterSet *) aSet
									options : (unsigned int    ) mask
									  range : (NSRange         ) aRange;
- (NSArray *) componentsSeparatedByCharacterSequenceFromSet : (NSCharacterSet *) aCharacterSet;
- (NSArray *) componentsSeparatedByCharacterSequenceInString : (NSString *) characters;
/*!
  * 
  * @return            s܂܂ȂvfƂz
  */
/*!
 * @method      componentsSeparatedByNewline
 * @abstract    sŋ؂
 *
 * @discussion  w肳ꂽs(܂Unicode̒i؂蕶)
 *              ŋ؂Aꂼs܂܂ȂvfƂ
 *              zԂBs܂܂ȂA܂͖s̕
 *              ꍇ́AvfЂƂ̔zԂB
 *
 * @result      X̗vf܂ޔzIuWFNg
 */
- (NSArray *) componentsSeparatedByNewline;

- (NSString *) stringByReplaceEntityReference;

/**
  * w肳ꂽcharsׂāAreplacement
  * ŒuB
  * 
  * @param    chars        u镶
  * @return                V
  */
- (NSString *) stringByReplaceCharacters : (NSString        *) chars
                                toString : (NSString        *) replacement;

/**
  * w肳ꂽcharsׂāAreplacement
  * ŒuB
  * 
  * @param    chars        u镶
  * @param    replacement  u̕
  * @param    options      ̃IvV
  * @return                V
  */
- (NSString *) stringByReplaceCharacters : (NSString        *) chars
                                toString : (NSString        *) replacement
                                 options : (unsigned int     ) options;

/**
  * w肳ꂽcharsׂāAreplacement
  * ŒuB
  * 
  * @param    chars        u镶
  * @param    replacement  u̕
  * @param    options      ̃IvV
  * @param    range        u͈
  * @return                V
  */
- (NSString *) stringByReplaceCharacters : (NSString        *) chars
                                toString : (NSString        *) replacement
                                 options : (unsigned int     ) options
                                   range : (NSRange          ) aRange;

/**
  * V[ocharSetɊ܂܂镶ׂč폜B
  * 
  * @param    charSet      u镶̃Zbg
  * @return                V
  */
- (NSString *)  stringByDeleteCharactersInSet : (NSCharacterSet  *) charSet;

/**
  * V[ocharSetɊ܂܂镶ׂč폜B
  * 
  * @param    charSet      u镶̃Zbg
  * @param    range        u͈
  * @return                V
  */
- (NSString *)  stringByDeleteCharactersInSet : (NSCharacterSet  *) charSet
                                      options : (unsigned int     ) options;

/**
  * V[ocharSetɊ܂܂镶ׂč폜B
  * 
  * @param    charSet      u镶̃Zbg
  * @param    options      ̃IvV
  * @param    range        u͈
  * @return                V
  */
- (NSString *)  stringByDeleteCharactersInSet : (NSCharacterSet  *) charSet
                                      options : (unsigned int     ) options
                                        range : (NSRange          ) aRange;

/**
  * 擪Ɩ̘A󔒕A^uAs폜
  * ԂB
  *
  * @return     V
  */
- (NSString *) stringByStriped;

/**
  * 擪̘A󔒕A^uAs폜
  * ԂB
  *
  * @return     V
  */
- (NSString *) stringByStripedAtStart;

/**
  * ̘A󔒕A^uAs폜
  * ԂB
  *
  * @return     V
  */
- (NSString *) stringByStripedAtEnd;

- (BOOL) isSameAsString : (NSString *) other;
@end



@interface NSString(WorkingWithPascalString)
+ (id) stringWithPascalString : (ConstStr255Param) pStr;
- (id) initWithPascalString : (ConstStr255Param) pStr;

- (ConstStringPtr) pascalString;
- (BOOL) getPascalString : (StringPtr) buffer
               maxLength : (unsigned ) maxLength;
@end
