//: CMXTextParser.h
/**
  * $Id: CMXTextParser.h,v 1.1.1.1 2005-05-11 17:51:04 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */

#import <Foundation/Foundation.h>

@class CMRThreadMessage;

enum {
	k2chDATNameIndex			= 0,
	k2chDATMailIndex			,
	k2chDATDateExtraFieldIndex	,
	k2chDATMessageIndex			,
	
	// Optional
	k2chDATTitleIndex			
};


@interface CMXTextParser : NSObject
/**
  *
  * s"<>"܂","ŕzԂB
  * ؂蕶","̏ꍇ̓tB[h'@M'","ɕϊ
  *
  * ؂蕶݂Ȃꍇ͕sȕƌȂAnilԂB
  *
  * @param    line  s
  * @return         ؂蕶ŕz
  *
  */
+ (NSArray *) separatedLine : (NSString *) line;

/**
  *
  * 2chtNSDate𐶐
  * sȕłnilԂB
  * [t\]
  *   02/02/05 22:26
  *   2001/08/06() 21:45
  * 
  * @param    string  Ot@C̓t
  * @return           NSDate
  *
  */
+ (id) dateWith2chDateString : (NSString *) theString;

// DAT --> XIuWFNg
+ (NSArray *) messageArrayWithDATContents : (NSString  *) DATContens
								baseIndex : (unsigned   ) baseIndex
								    title : (NSString **) tilePtr;
+ (CMRThreadMessage *) messageWithDATLine : (NSString *) theString;
+ (CMRThreadMessage *) messageWithInvalidDATLineDetected : (NSString *) line;

// Entity Reference
// "&amp" --> "&amp;"
+ (void) replaceEntityReferenceWithString : (NSMutableString *) aString;

/*
X̖{̂ϊł͕̂ϊĂ܂B
svHTML^O菜As^Oϊ
*/
+ (NSString *) cachedMessageWithMessageSource : (NSString *) aSource;
+ (void) convertMessageSourceToCachedMessage : (NSMutableString *) aSource;



// ----------------------------------------
// CES (Code Encoding Scheme)
// ----------------------------------------
/*
Shift JIS ɂĂ͑Ή镄WƂĎO
₪lB

  - JIS Kiɒ JIS X 0208:1997
  - MicroSoft Ђ̎dl
  - Apple Ђ̎dl

͈ȉ CFStringEncodings ɑΉiʓ
CFStringConvertEncodingToIANACharSetName() ̕ԂOj

  - kCFStringEncodingShiftJIS (SHIFT_JIS)
  - kCFStringEncodingDOSJapanese (CP932)
  - kCFStringEncodingMacJapanese (X-MAC-JAPANESE)

CocoMonar ̏ꍇAƂΐVEmac ł Mac Japanese 
R[hgP[X邽߁AShift JIS ɊւĂ
炷ׂĂɑΉ̂IƎvB

̂߁Aȉ̃\bhł CFStringEncoding 
Ԃꍇ
(1) ܂ÃGR[fBO
(2) ŕϊłȂΎc̃GR[fBȌԂŎB
(3) ʓIɕϊłȂ΃G[

  - kCFStringEncodingDOSJapanese
  - kCFStringEncodingMacJapanese
  - kCFStringEncodingShiftJIS
----------------------------------------
*/

+ (NSString *) stringWithData : (NSData         *) aData
                   CFEncoding : (CFStringEncoding) enc;



// ----------------------------------------
// URL Encode
// ----------------------------------------
/*!
 * @method      availableURLEncodings
 * @discussion  
 * 
 * URLGR[hꂽƂ肷Ƃ
 * pGR[fBO̔ziI[F0j
 * 
 * @result      ziI[F0j
 */
+ (const NSStringEncoding *) availableURLEncodings;
+ (NSString *) stringByURLEncodedWithString : (NSString *) aString;
+ (NSString *) stringByURLDecodedWithString : (NSString *) aString;
+ (NSString *) queryWithDictionary : (NSDictionary *) aDictionary;
@end



@interface CMXTextParser(LowLevelAPIs)
+ (CMRThreadMessage *) messageWithDATLineComponentsSeparatedByNewline : (NSArray *) aComponents;

+ (BOOL) parseDateExtraField : (NSString         *) dateExtra
            convertToMessage : (CMRThreadMessage *) aMessage;
+ (BOOL) parseExtraField : (NSString         *) extraField
        convertToMessage : (CMRThreadMessage *) aMessage;
@end



extern void htmlConvertBreakLineTag(NSMutableString *theString);
