//
//  LoginController-VAccessor.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 10/03/22.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "LoginController_p.h"



@implementation LoginController(ViewAccessor)
- (NSButton *)cancelButton
{
    return m_cancelButton;
}

- (NSButton *)okButton
{
    return m_okButton;
}

- (NSTextField *)passwordField
{
    return m_passwordField;
}

- (NSButton *)shouldSavePWBtn
{
    return m_shouldSavePWBtn;
}

- (NSTextField *)userIDField
{
    return m_userIDField;
}
@end


@implementation LoginController(UISetup)
- (void)updateButtonState
{
    BOOL      canLogin_;
    NSString *value_;

    // パスワードが入力されていない、あるいは
    // ユーザIDが入力されていない場合は
    // ログインできない。
    value_ = [[self userIDField] stringValue];
    canLogin_ = (value_ && [value_ length] > 0);
    value_ = [[self passwordField] stringValue];
    canLogin_ = canLogin_ && (value_ && [value_ length] > 0);

    [[self okButton] setEnabled:canLogin_];
}

- (void)setupUIComponents
{
    NSString        *account_;
    NSString        *password_;
    BOOL            hasAccountInKeychain_;

    account_ = [[self preferences] x2chUserAccount];
    password_ = nil;
    hasAccountInKeychain_ = [[self preferences] hasAccountInKeychain];

    if (hasAccountInKeychain_) {
        password_ = [[self preferences] password];
        if (!password_) {
            password_ = @"";
        }
        [[self passwordField] setEnabled:YES];
        [[self passwordField] setStringValue:password_];
    }

    [[self userIDField] setStringValue:(account_ ?: @"")];
    [self updateButtonState];
}
@end


@implementation LoginController(NSControlDelegate)
- (void)controlTextDidChange:(NSNotification *)aNotification
{
   UTILAssertNotificationName(
     aNotification,
      NSControlTextDidChangeNotification);

    [self updateButtonState];
}
@end
