//
//  CMRBrowser-Action.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 08/02/10.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "CMRBrowser_p.h"
#import "CMRMainMenuManager.h"
#import "CMRHistoryManager.h"
#import "CMRThreadsList_p.h"
#import "FolderBoardListItem.h"
#import "CMRDocumentController.h"
#import "BoardListItem.h"

extern BOOL isOptionKeyDown(void); // described in CMRBrowser-Delegate.m

@class IndexField;

@implementation CMRBrowser(Action)
static int expandAndSelectItem(BoardListItem *selected, NSArray *anArray, NSOutlineView *bLT)
{
	NSEnumerator *iter_ = [anArray objectEnumerator];
	id	eachItem;
	int index = -1;
	while (eachItem = [iter_ nextObject]) {
		// 「閉じているカテゴリ」だけに興味がある
		if (NO == [SmartBoardList isCategory: eachItem] || NO == [(FolderBoardListItem *)eachItem hasChildren]) continue;

		if (NO == [bLT isItemExpanded: eachItem]) [bLT expandItem: eachItem];

		index = [bLT rowForItem: selected];
		if (-1 != index) { // 当たり！
			return index;
		} else { // カテゴリ内のサブカテゴリを開いて検査する
			index = expandAndSelectItem(selected, [(FolderBoardListItem *)eachItem items], bLT);
			if (-1 == index) // このカテゴリのどのサブカテゴリにも見つからなかった
				[bLT collapseItem: eachItem]; // このカテゴリは閉じる
		}
	}
	return index;
}

- (int)searchRowForItemInDeep:(BoardListItem *)boardItem inView:(NSOutlineView *)olView
{
	int	index = [olView rowForItem:boardItem];
	
	if (index == -1) {
		index = expandAndSelectItem(boardItem, [(SmartBoardList *)[olView dataSource] boardItems], olView);
	}
	
	return index;
}

#pragma mark -
- (IBAction)focus:(id)sender
{
    [[self window] makeFirstResponder:[[self threadsListTable] enclosingScrollView]];
}

- (void)selectRowOfName:(NSString *)boardName forceReload:(BOOL)flag
{
	NSOutlineView	*outlineView = [self boardListTable];
    SmartBoardList  *dataSource = [outlineView dataSource];
	BoardListItem	*selectedItem;
    int				index;

	UTILAssertNotNil(dataSource);

    selectedItem = [dataSource itemForName:boardName];

    if (!selectedItem) { // 必要なら掲示板を自動的に追加
		SmartBoardList	*defaultList = [[BoardManager defaultManager] defaultList];
		BoardListItem	*newItem = [defaultList itemForName:boardName];
		if (!newItem) {
			NSBeep();
			NSLog(@"No BoardListItem for board %@ found.", boardName);
			return;
		} else {
			[dataSource addItem:newItem afterObject:nil];
			selectedItem = [dataSource itemForName:boardName];
		}
	}

	index = [self searchRowForItemInDeep:selectedItem inView:outlineView];	
	if (index == -1) return;
	if ([outlineView isRowSelected:index]) { // すでに選択したい行が選択されている
		if (flag) {
			[self reloadThreadsList:self];
		} else {
			UTILNotifyName(CMRBrowserThListUpdateDelegateTaskDidFinishNotification);
		}
	} else {
		[outlineView selectRowIndexes:[NSIndexSet indexSetWithIndex:index] byExtendingSelection:NO];
	}

	[outlineView scrollRowToVisible:index];
}

- (IBAction)reloadThreadsList:(id)sender
{
    [self storeKeepPath:CMRAutoscrollWhenTLUpdate];
	[[self document] reloadThreadsList];
}

- (void)openThreadsInThreadWindow:(NSArray *)threads
{
	NSEnumerator	*iter_;
	NSDictionary	*thread_;
	NSString		*path_;
	
	iter_ = [threads objectEnumerator];
	while (thread_ = [iter_ nextObject]) {
		
		path_ = [CMRThreadAttributes pathFromDictionary:thread_];
		if ([self shouldShowContents] && [path_ isEqualToString:[self path]]) {
			continue;
		}
        [[CMRDocumentController sharedDocumentController] showDocumentWithContentOfFile:[NSURL fileURLWithPath:path_] boardInfo:thread_];
	}
}

- (NSArray *)targetBoardsForAction:(SEL)action
{
    NSEvent *event = [NSApp currentEvent];
    NSPoint mouse = [event locationInWindow];
    NSView *targetView = [[[self window] contentView] hitTest:mouse];

    NSArray *result = nil;

    if (!targetView) {
        NSView *focusedView = (NSView *)[[self window] firstResponder];

        if (focusedView == [self textView] || [self isIndexFieldFirstResponder]) {
            NSURL *url = [self boardURL];
            result = url ? [NSArray arrayWithObject:url] : [NSArray array];
        } else if (focusedView == [self boardListTable]) {
            // 掲示板リスト…
            int selectedRow = [[self boardListTable] selectedRow];
            id item_ = [[self boardListTable] itemAtRow:selectedRow];
            if ([BoardListItem isBoardItem:item_]) {
                NSURL *url3 = [(BoardListItem *)item_ url];
                result = [NSArray arrayWithObject:url3];
            }
        } else {
            NSURL *listUrl = [[self currentThreadsList] boardURL];
            result = listUrl ? [NSArray arrayWithObject:listUrl] : [NSArray array];
        }
    } else if ([targetView isKindOfClass:[m_boardListTable class]]) {
        // 掲示板リスト…
        int clickedRow = [(BSBoardListView *)[self boardListTable] semiSelectedRow];
        id item2 = [[self boardListTable] itemAtRow:clickedRow];
        if ([BoardListItem isBoardItem:item2]) {
            NSURL *url4 = [(BoardListItem *)item2 url];
            result = [NSArray arrayWithObject:url4];
        }
    } else if (targetView == [self brdListActMenuBtn]) {
        // アクションボタン…
        int selectedRow = [[self boardListTable] selectedRow];
        id item_ = [[self boardListTable] itemAtRow:selectedRow];
        if ([BoardListItem isBoardItem:item_]) {
            NSURL *url3 = [(BoardListItem *)item_ url];
            result = [NSArray arrayWithObject:url3];
        }
    }
    return result;
}

- (NSArray *)targetThreadsForAction:(SEL)action
{
	// BSQuickLookPanel からの openSelectedThreads: アクションを識別
	// -openSelectedThreads: メソッド内で引数が -fromQuickLook: に「すり替えられて」いる
	if (action == @selector(fromQuickLook:)) {
		return [self selectedThreadsReallySelected];
	}
	NSEvent *event = [NSApp currentEvent];
	NSPoint mouse = [event locationInWindow];
	NSView *targetView = [[[self window] contentView] hitTest:mouse];
	NSArray *result = nil;
	//NSLog(@"%@", NSStringFromClass([targetView class]));
	if ([targetView isKindOfClass:[m_threadsListTable class]] /*|| nil == targetView*/) {	// スレッドリストから
		result = [self selectedThreadsReallySelected];
		if (0 == [result count]) {
//			if (![self threadURL]) {
//				result = [NSArray empty];
//			}
			result = [self selectedThreads];
		}
	} else if (!targetView) {
		// メニューバーもしくはキーイベントから
		// あるいはツールバーボタンから
		// スレッドリストにフォーカスが当たっているかどうかで対象をスイッチする。
		NSView *focusedView_ = (NSView *)[[self window] firstResponder];
		if (focusedView_ == [self textView] || [self isIndexFieldFirstResponder]) {
			// フォーカスがスレッド本文領域にある
			id selected = [self selectedThread];
			if (nil == selected) {
				result = [NSArray empty];
			} else {
				result = [NSArray arrayWithObject:selected];
			}
		} else { // フォーカスがそれ以外の領域にある：スレッドリストの選択項目を優先
			result = [self selectedThreadsReallySelected];
			if (0 == [result count]) {
//				if (![self threadURL]) {
//					result = [NSArray empty];
//				}
				result = [self selectedThreads];
			}
		}	
	} else { //　スレッド本文領域から。
		id selected = [self selectedThread];
		if (!selected) {
			result = [NSArray empty];
		} else {
			result = [NSArray arrayWithObject:selected];
		}
	}
	return result;
}

- (IBAction)openSelectedThreads:(id)sender
{
	SEL action = _cmd;
	// BSQuickLookPanel からのアクション送信を -targetThreadsForAction: 内で識別
	// するために、ダミーのアクションに「すり替えて」引数に渡す
	if ([sender isKindOfClass:NSClassFromString(@"BSQuickLookPanel")]) {
		action = @selector(fromQuickLook:);
	}
	[self openThreadsInThreadWindow:[self targetThreadsForAction:action]];
}

- (IBAction)selectThread:(id)sender
{
	// 特定のモディファイア・キーが押されているときは
	// クリックで項目を選択してもスレッドを読み込まない
	if (![self shouldShowContents] || isOptionKeyDown()) return;
	
	[self showSelectedThread:self];
}

- (BOOL)shouldLoadThreadAtPath:(NSString *)filepath
{
	if (![self shouldShowContents]) return NO;
	
	return (![filepath isSameAsString:[self path]] || ![[NSFileManager defaultManager] fileExistsAtPath:filepath]);
}

- (void)showThreadAtRow:(int)rowIndex
{
	NSTableView				*tbView_ = [self threadsListTable];
	NSDictionary			*thread_;
	NSString				*path_;
	
	NSAssert2(
		(rowIndex >= 0 && rowIndex < [tbView_ numberOfRows]),
		@"  rowIndex was over. size = %d but was %d",
		[tbView_ numberOfRows],
		rowIndex);
	
	thread_ = [[self currentThreadsList] threadAttributesAtRowIndex:rowIndex inTableView:tbView_];
	path_ = [CMRThreadAttributes  pathFromDictionary:thread_];
	
	if ([self shouldLoadThreadAtPath:path_]) {
		[self setThreadContentWithFilePath:path_ boardInfo:thread_];
		// フォーカス
		//if ([CMRPref moveFocusToViewerWhenShowThreadAtRow]) {
			[[self window] makeFirstResponder:[self textView]];
		//}
		[self synchronizeWindowTitleWithDocumentName];
	}
}

- (IBAction)showSelectedThread:(id)sender
{
	if (-1 == [[self threadsListTable] selectedRow]) return;
	if ([[self threadsListTable] numberOfSelectedRows] != 1) return;
	
	[self showThreadAtRow:[[self threadsListTable] selectedRow]];
}

/*
	2005-06-06 tsawada2 <ben-sawa@td5.so-net.ne.jp>
	Key Binding の便宜を図るためだけのメソッド。
	return キーに対応するアクションにこれを指定しておくと、2ペインのとき、3ペインのとき
	それぞれに応じて自動的に適切な動作（別窓で開く、下部に表示する）を呼び出せるという仕掛け。
*/
// BSQuickLookPanel で return キーが押されたときもこのアクションが飛ぶ。
- (IBAction)showOrOpenSelectedThread:(id)sender
{
	if ([self shouldShowContents]) {
		[self showSelectedThread:sender];
	} else {
		[self openSelectedThreads:sender];
	}
}

- (IBAction)selectThreadOnly:(id)sender
{
	// do nothing.
}

- (unsigned int)indexOfNextUpdatedThread
{
    int index = [[self threadsListTable] selectedRow];
    if (index == -1) {
        index = NSNotFound;
    }
   return [[self currentThreadsList] indexOfNextUpdatedThread:index];
}

- (IBAction)selectNextUpdatedThread:(id)sender
{
    unsigned int index = [self indexOfNextUpdatedThread];
    if (index == NSNotFound) {
        NSBeep();
        return;
    }
    [[self threadsListTable] selectRowIndexes:[NSIndexSet indexSetWithIndex:index] byExtendingSelection:NO];
    [[self window] makeFirstResponder:[self threadsListTable]];
}

- (IBAction)showOrOpenNextUpdatedThread:(id)sender
{
    unsigned int index = [self indexOfNextUpdatedThread];
    if (index == NSNotFound) {
        NSBeep();
        return;
    }
    [[self threadsListTable] selectRowIndexes:[NSIndexSet indexSetWithIndex:index] byExtendingSelection:NO];
    [self showOrOpenSelectedThread:sender];
}

/*
#pragma mark MeteorSweeper Key Binding Action Additions
- (IBAction) scrollPageDownThViewOrThListProperly: (id) sender
{
	if ([CMRPref moveFocusToViewerWhenShowThreadAtRow] || ![self shouldShowContents]) {
		[[[self threadsListTable] enclosingScrollView] pageDown: sender];
	} else {
		[[self textView] scrollPageDown: sender];
	}
}

- (IBAction) scrollPageUpThViewOrThListProperly: (id) sender
{
	if ([CMRPref moveFocusToViewerWhenShowThreadAtRow] || ![self shouldShowContents]) {
		[[[self threadsListTable] enclosingScrollView] pageUp: sender];
	} else {
		[[self textView] scrollPageUp: sender];
	}
}

- (IBAction) scrollPageDownThreadViewWithoutFocus: (id) sender
{
	if(![self shouldShowContents]) {
		NSBeep();
		return;
	}
	
	[[self textView] scrollPageDown: sender];
}

- (IBAction) scrollPageUpThreadViewWithoutFocus: (id) sender
{
	if(![self shouldShowContents]) {
		NSBeep();
		return;
	}
	
	[[self textView] scrollPageUp: sender];
}
*/

#pragma mark Filtering
- (void)synchronizeWithSearchField
{
	[[self document] searchThreadsInListWithCurrentSearchString];
	[self synchronizeWindowTitleWithDocumentName];

	[[self threadsListTable] reloadData];
}

- (void)collapseOrExpandSplitView:(id)splitView
{
	BOOL currentState = [splitView isSubviewCollapsed:bottomSubview];
	[splitView setSubview:bottomSubview isCollapsed:!currentState];
	[splitView resizeSubviewsWithOldSize:[splitView frame].size];
}

- (IBAction)searchThread:(id)sender
{
	[self synchronizeWithSearchField];
}

- (IBAction)toggleLayout:(id)sender
{
    int idx;
    BOOL needsSync = NO;
    BOOL isExpanded = [self shouldShowContents];
    if (sender == [self layoutSwitcher]) {
        idx = [[self layoutSwitcher] selectedSegment];
    } else if ([sender isKindOfClass:[NSMenuItem class]]) {
        idx = [sender tag];
        needsSync = YES;
    } else {
        return;
    }

    if (idx == 0) {
        if (isExpanded) {
            [self collapseOrExpandSplitView:[self splitView]];
            if (needsSync) {
                [self synchronizeLayoutSwitcher];
            }
        }
        return;
    }

    if (idx == 1) {
        if ([CMRPref isSplitViewVertical]) {
            [CMRPref setIsSplitViewVertical:NO];
            [self setupSplitView];
        }
        if (!isExpanded) {
            [self collapseOrExpandSplitView:[self splitView]];
        } else {
            [[self splitView] resizeSubviewsWithOldSize:[[self splitView] frame].size];
        }
        if (needsSync) {
            [self synchronizeLayoutSwitcher];
        }
        return;
    }

    if (idx == 2) {
        if (![CMRPref isSplitViewVertical]) {
            [CMRPref setIsSplitViewVertical:YES];
            [self setupSplitView];
        }
        if (!isExpanded) {
            [self collapseOrExpandSplitView:[self splitView]];
        } else {
            [[self splitView] resizeSubviewsWithOldSize:[[self splitView] frame].size];        
        }
        if (needsSync) {
            [self synchronizeLayoutSwitcher];
        }
        return;
    }
}

- (unsigned int)isToolbarContainsSearchField
{
	NSToolbar	*toolbar = [[self window] toolbar];
	UTILAssertNotNil(toolbar);

	if (![toolbar isVisible]) {
		[toolbar setVisible:YES];
	}

	NSEnumerator *iter = [[toolbar visibleItems] objectEnumerator];
	id	item;
	while (item = [iter nextObject]) {
		if ([[item itemIdentifier] isEqualToString:kToolbarSearchFieldItemKey]) {
			return [toolbar displayMode] == NSToolbarDisplayModeLabelOnly ? 1 : 0;
		}
	}

	return 2;
}

- (IBAction)showSearchThreadPanel:(id)sender
{
	unsigned int toolbarState = [self isToolbarContainsSearchField];

	switch (toolbarState) {
	case 0:
		[[self searchField] selectText:sender];
		break;
	case 1:
		[[[self window] toolbar] setDisplayMode:NSToolbarDisplayModeIconAndLabel];
		[[self searchField] selectText:sender];
		break;
	default:
		NSBeep();
		break;
	}
}

#pragma mark View Menu
- (IBAction)collapseOrExpandBoardList:(id)sender
{
	RBSplitSubview	*tmp_;
	
	tmp_ = [self boardListSubView];
	if ([tmp_ isCollapsed]) {
		[tmp_ expand];
	} else {
		[tmp_ collapse];
	}
	// Leopard 暫定対策
	[[tmp_ splitView] adjustSubviews];
}

#pragma mark -

/*
NSTableView action, doubleAction はカラムのクリックでも
発生するので、以下のメソッドでフックする。
*/
- (IBAction)tableViewActionDispatch:(id)sender actionKey:(NSString *)aKey defaultAction:(SEL)defaultAction
{
	SEL action_;

	// カラムのクリック
	if (-1 == [[self threadsListTable] clickedRow]) return;

	// 設定されたアクションにディスパッチ
	action_ = SGTemplateSelector(aKey);
	if (NULL == action_ || _cmd == action_) {
		action_ = defaultAction;
	}
	[NSApp sendAction:action_ to:self from:sender];
}

- (IBAction)listViewAction:(id)sender
{
    // 時間内に二度目のクリックが発生した場合は、ダブルクリックと判断し、クリックの action を実行しない
    NSTimeInterval interval = [NSEvent bs_doubleClickInterval];
    NSEvent *nextEvent = [[self window] nextEventMatchingMask:NSLeftMouseUpMask
                                                    untilDate:[NSDate dateWithTimeIntervalSinceNow:interval]
                                                       inMode:NSEventTrackingRunLoopMode
                                                      dequeue:NO];
    NSEventType type = [nextEvent type];
    if (NSLeftMouseUp == type) {
        return;
    }
	[self tableViewActionDispatch:sender
						actionKey:kThreadsListTableActionKey
					defaultAction:@selector(selectThread:)];
}

- (IBAction)listViewDoubleAction:(id)sender
{
	[self tableViewActionDispatch:sender
						actionKey:kThreadsListTableDoubleActionKey
					defaultAction:@selector(openSelectedThreads:)];
}

- (IBAction)boardListViewDoubleAction:(id)sender
{
	UTILAssertKindOfClass(sender, NSOutlineView);

	int	rowNum = [sender clickedRow];
	if (-1 == rowNum) return;
	
	id item_ = [sender itemAtRow:rowNum];

	if ([sender isExpandable:item_]) {
		if ([sender isItemExpanded:item_]) {
			[sender collapseItem:item_];
		} else {
			[sender expandItem:item_];
		}
	}
}	
@end

#pragma mark -
@implementation CMRBrowser(DeletionAndRetrieving)
- (void)closeWindowIfNeededAtPath:(NSString *)path
{
    ;
}
@end
