//
//  SmartBLIEditorHelper.h
//  BathyScaphe
//
//  Created by Hori,Masaki on 06/01/03.
//  Copyright 2006 BathyScaphe Project. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "SmartCondition.h"

typedef enum UIItemTags {
	criterionPopUpTag = 100,
	stringExpressionFieldTag = 200,
	stringQualifierPopUpTag = 300,
	removeCriterionButtonTag = 400,
	addCriterionButtonTag = 500,
	
	dateExpressionFieldTag = 600,
	dateQualifierPopUpTag = 700,
	dateExpression2FieldTag = 800,
	dateExpressionToFieldTag = 801,
	daysExpressionFieldTag = 900,
	daysUnitPopUpTag = 1000,
	daysExpressionAgoFieldTag = 1100,
	daysExpressionField2Tag = 1200,
	daysExpressionToFieldTag = 1201,
	
	numberExpressionFieldTag = 1300,
	numberQualifierPopUpTag = 1400,
	numberExpression2FieldTag = 1500,
	numberExpressionToFieldTag = 1501,
} UIItemTags;

typedef enum CriterionTypes {
	unkownCriterionType,
	stringCriterionType,
	dateCriterionType,
	namberCriterionType,
} CriterionTypes;

typedef enum ExpressionTypes {
	stringExpressionType,
	dateExpressionType,
	dateExpressionRangeType,
	daysExpressionType,
	numberExpressionType,
	namberExpressionRangeType,
} ExpressionTypes;

typedef enum CriterionMenuItemTags {
	boardNameItemTag = 1,
	threadNameItemTag,
	numberOfResponseItemTag,
	numberOfReadItemTag,
	numberOfUnreadItemTag,
	dateOfThreadCreateItemTag,
	dateOfModifierItemTag,
	dateOfLastWritenItemTag,
} CriterionMenuItemTags;

typedef enum QualifierMenuItemTags {
	containsQualifierItemTag = 1,
	notContainsQualifierItemTag,
	exactQualifierItemTag,
	notExactQualifierItemTag,
	beginsWithQualifierItemTag,
	endsWithQualifierItemTag,
	
	isEqualQualifierItemTag = 7,
	notEqualQualifierItemTag,
	largerThanQualifierItemTag,
	smallerThanQualifierItemTag,
	rangeQualifierItemTag,
	
	daysDateItemExtension = 1000,
	daysTodayQualifierItemTag = daysDateItemExtension + 0,
	daysYesterdayQualifierItemTag = daysDateItemExtension + 1,
	daysThisWeekQualifierItemTag = daysDateItemExtension + 7,
	daysLastWeekQualifierItemTag = daysDateItemExtension + 14,
	
	daysItemExtension = 2000,
	daysIsEqualQualifierItemTag = daysItemExtension + isEqualQualifierItemTag,
	daysLargerThanQualifierItemTaag = daysItemExtension + largerThanQualifierItemTag,
	daysSmallerThanQualifierItemTag = daysItemExtension + smallerThanQualifierItemTag,
	daysRangeQualifierItemTag = daysItemExtension + rangeQualifierItemTag,
	
	dateItemExtension = 3000,
	dateIsEqualQualifierItemTag = dateItemExtension + isEqualQualifierItemTag,
	dateNotEqualQualifierItemTag = dateItemExtension + notEqualQualifierItemTag,
	dateLargerThanQualifierItemTaag = dateItemExtension + largerThanQualifierItemTag,
	dateSmallerThanQualifierItemTag = dateItemExtension + smallerThanQualifierItemTag,
	dateRangeQualifierItemTag = dateItemExtension + rangeQualifierItemTag,
	
	lastExtensionsLabel = 4000,
} QualifierMenuItemTags;

extern NSString *SmartBLIEditorComponentsNibName;

extern NSString *CriteriaSpecificationsPlist;
extern NSString *CriteriaSpecificationsCriteriaKey;
extern NSString		*CriteriaNameKey;
extern NSString		*CriteriaTypeKey;
extern NSString *CriteriaSpecificationsOrdersKey;

@class ColorBackgroundView;

@interface SmartBLIEditorHelper : NSObject
{
    IBOutlet NSPopUpButton *allOrAnyPopUp;
    IBOutlet NSScrollView *container;
    IBOutlet NSButton *includeFallInDATCheck;
	IBOutlet NSButton *excludeAdThreadCheck;
    IBOutlet NSTextField *nameField;
	
	IBOutlet id expressionView;
    IBOutlet id numberView;
	IBOutlet id dateView;
	
	SmartBLIEditorHelper *previousHelper;
	SmartBLIEditorHelper *nextHelper;
}
- (IBAction)addCriterion:(id)sender;
- (IBAction)changeCriterionPop:(id)sender;
- (IBAction)removeCriterion:(id)sender;

+ (NSDictionary *)criteriaSpecifications;

- (SmartBLIEditorHelper *)nextHelper;
- (SmartBLIEditorHelper *)previousHelper;
- (SmartBLIEditorHelper *)rootHelper;

- (void)insertHelper:(SmartBLIEditorHelper *)newHlper after:(SmartBLIEditorHelper *)helper;
- (void)addHelper:(SmartBLIEditorHelper *)newHlper;
- (void)removeHelper:(SmartBLIEditorHelper *)helper;

@end

@interface SmartBLIEditorHelper(SmartConditionAccesor)
- (BOOL)isValid;
- (id<SmartCondition>)condition;
- (BOOL)buildHelperFromCondition:(id<SmartCondition>)condition;
@end

@interface SmartBLIEditorHelper(ViewAccessor)
- (void)loadComponent;
- (NSScrollView *)container;
- (ColorBackgroundView *)conditionView;

- (void)relocateConditionView;

- (void)incrementContainerHeight;
- (void)decrementContainerHeight;

- (void)addConditionView;
- (void)removeConditionView;

- (void)builExpressionViews;
- (void)validateUIItem;
- (id)uiItemForTag:(UIItemTags)tag;
- (QualifierMenuItemTags)currentQualifierItemTag;
@end

@interface FlippedView : NSView
@end
@interface ColorBackgroundView : NSView
{
	NSColor *color;
}
- (void)setColor:(NSColor *)color;
- (NSColor *)color;
@end
