//
//  p22chConnector.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 2013/06/29.
//  encoding="UTF-8"
//

#import "p22chConnector.h"
#import "SG2chConnector_p.h"

@implementation p22chConnector
- (id)initWithUserInfo:(NSDictionary *)userInfo
{
    if ((self = [super init])) {
        m_userInfo = [userInfo copy];
    }
    return self;
}

- (void)dealloc
{
    [m_userInfo release];
    [super dealloc];
}

#pragma mark Overrides
- (void)loadInBackground
{
    // サポートしないのでブロック
    NSLog(@"Oh! not supported! You should not call this method on p22chConnector.");
}

- (BOOL)writeForm:(NSDictionary *)forms
{
    // サポートしないのでブロック
    return NO;
}

#pragma mark P2 writing
- (NSDictionary *)userInfo
{
    return m_userInfo;
}

- (BOOL)postUsingP22ch:(NSError **)error
{
    NSString *cookie = [[self userInfo] objectForKey:P22chPostUserInfoCookieKey];
    
    if (!cookie) {
        if (error != NULL) {
            *error = [NSError errorWithDomain:BSBathyScapheErrorDomain code:BSP22chWriteUnknownError userInfo:nil];
        }
        return NO;
    }
    
    NSString *p2Host = [[self userInfo] objectForKey:P22chPostUserInfoActualHostKey];
    
    NSString *bbs = [[self userInfo] objectForKey:P22chPostUserInfoThreadBBSKey];
    NSString *host = [[self userInfo] objectForKey:P22chPostUserInfoThreadHostKey];
    
    NSString *datIdentifier = [[self userInfo] objectForKey:P22chPostUserInfoThreadIdKey];
    
    NSError *underlyingError;
    
    NSMutableDictionary *forms = [NSMutableDictionary dictionary];
    
    NSString *url = [NSString stringWithFormat:@"http://%@/p2/post_form.php?host=%@&bbs=%@&key=%@", p2Host, host, bbs, datIdentifier];
    
    NSMutableURLRequest *urlRequest = [[[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]] autorelease];
    [urlRequest setHTTPShouldHandleCookies:NO];
    [urlRequest setHTTPMethod:@"GET"];
    [urlRequest addValue:cookie forHTTPHeaderField:HTTP_COOKIE_HEADER_KEY];
    
    NSURLResponse *response;
    NSData *result = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&underlyingError];
    if (!result) {
        if (error != NULL) {
            *error = errorWithUnderlyingCocoaError(underlyingError, 1);
        }
        return NO;
    }
    
    NSXMLDocument *document = [[[NSXMLDocument alloc] initWithData:result options:NSXMLDocumentTidyHTML error:&underlyingError] autorelease];
    if (!document) {
        if (error != NULL) {
            *error = errorWithUnderlyingCocoaError(underlyingError, 2);
        }
        return NO;
    }
    NSArray *objects = [document objectsForXQuery:@".//form[@action and @id=\"resform\"]" error:&underlyingError];
    if (!objects || [objects count] == 0) {
        // かわりにログインフォームがあれば、再ログインが必要
        if ([document objectsForXQuery:@".//form[@action and @id=\"login\"]" error:NULL]) {
            if (error != NULL) {
                *error = [NSError errorWithDomain:BSBathyScapheErrorDomain code:BSP22chWriteLoginNeededError userInfo:nil];
            }
            return NO;
        }
        return NO;
    } else if ([objects count] == 0) {
        if (error != NULL) {
            *error = [NSError errorWithDomain:BSBathyScapheErrorDomain code:BSP22chWriteUnknownError userInfo:nil];
        }
        return NO;
    }
    NSString *actionString = [[[objects objectAtIndex:0] attributeForName:@"action"] stringValue];
    //    NSLog(@"Postform action= %@", actionString);
    
    NSArray *forms2 = [[objects objectAtIndex:0] objectsForXQuery:@".//input[@name and @value]" error:&underlyingError];
    if (!forms2) {
        if (error != NULL) {
            *error = errorWithUnderlyingCocoaError(underlyingError, 3);
        }
        return NO;
    }
//    NSMutableString *postingBody = [NSMutableString string];
    id postingBody;
    NSString *submitValue = nil;
    NSString *submitValueForBe = nil;
    NSString *submitValueForMaru = nil;
//    BOOL allows = [[BoardManager defaultManager] allowsCharRefAtBoard:[self boardName]];

    for (id form in forms2) {
        NSString *formName = [[form attributeForName:@"name"] stringValue];
        NSString *formValue;
        if ([formName isEqualToString:@"FROM"]) {
//            formValue = [self name];
            formValue = [[self userInfo] objectForKey:P22chPostUserInfoNameKey];
        } else if ([formName isEqualToString:@"mail"]) {
//            formValue = [self mail];
            formValue = [[self userInfo] objectForKey:P22chPostUserInfoMailKey];
        } else if ([formName isEqualToString:@"submit"]) {
            submitValue = [[form attributeForName:@"value"] stringValue];
            continue;
        } else if ([formName isEqualToString:@"submit_beres"]) {
            submitValueForBe = [[form attributeForName:@"value"] stringValue];
            continue;
            // TODO ttitle_en には base64エンコードしたスレタイを渡さないといけないみたい（書き込み履歴ログなどで使用されるっぽ）
            //        } else if ([formName isEqualToString:@"ttitle_en"]) {
            //            formValue = [[self threadTitle] ...
        } else if ([formName isEqualToString:@"maru_kakiko"]) {
            submitValueForMaru = [[form attributeForName:@"value"] stringValue];
            continue;
        } else {
            formValue = [[form attributeForName:@"value"] stringValue];
        }
        
        // TODO エンコードできなかった文字の選択、警告
//        formValue = [formValue stringByURIEncodedUsingCFEncoding:kCFStringEncodingDOSJapanese convertToCharRefIfNeeded:allows unableToEncode:NULL];
        
//        [postingBody appendFormat:@"%@=%@&", formName, formValue];
        [forms setObject:formValue forKey:formName];
    }
    
//    if ([self shouldSendBeCookie]) {
    if ([[[self userInfo] objectForKey:P22chPostUserInfoBeKey] boolValue]) {
        if (submitValueForBe) {
//            [postingBody appendFormat:@"submit_beres=%@&", [submitValueForBe stringByURIEncodedUsingCFEncoding:kCFStringEncodingDOSJapanese convertToCharRefIfNeeded:NO unableToEncode:NULL]];
            [forms setObject:submitValueForBe forKey:@"submit_beres"];
        } else {
            // p2.2ch.net 側で設定ができていない
            if (error != NULL) {
                *error = [NSError errorWithDomain:BSBathyScapheErrorDomain code:BSP22chWriteNoBeSettingError userInfo:[NSDictionary dictionaryWithObjectsAndKeys:PluginLocalizedStringFromTable(@"Warning p2Post no be message", nil, @""), NSLocalizedDescriptionKey, PluginLocalizedStringFromTable(@"Warning p2Post no be info", nil, @""), NSLocalizedRecoverySuggestionErrorKey, [NSArray arrayWithObjects:PluginLocalizedStringFromTable(@"Warning p2Post no be recovery option 1", nil, @""), PluginLocalizedStringFromTable(@"Warning p2Post no be recovery option 2", nil, @""), nil], NSLocalizedRecoveryOptionsErrorKey, nil]];
            }
            return NO;
        }
    } else {
//        [postingBody appendFormat:@"submit=%@&", [submitValue stringByURIEncodedUsingCFEncoding:kCFStringEncodingDOSJapanese convertToCharRefIfNeeded:NO unableToEncode:NULL]];
        [forms setObject:submitValue forKey:@"submit"];
    }
    
    // ●が p2.2ch.net 側でログイン済みで、かつ、BathyScaphe の設定も「●を使用する」になっている場合
//    if (submitValueForMaru && [CMRPref shouldLoginIfNeeded]) {
    if (submitValueForMaru && [[[self userInfo] objectForKey:P22chPostUserInfoMaruKey] boolValue]) {
//        [postingBody appendFormat:@"maru_kakiko=%@&", [submitValueForMaru stringByURIEncodedUsingCFEncoding:kCFStringEncodingDOSJapanese convertToCharRefIfNeeded:NO unableToEncode:NULL]];
        [forms setObject:submitValueForMaru forKey:@"maru_kakiko"];
    }
    
    // TODO エンコードできなかった文字の選択、警告
    // 本文
/*    NSIndexSet *indexSet = nil;
    NSString *messageEncoded = [[self replyMessage] stringByURIEncodedUsingCFEncoding:kCFStringEncodingDOSJapanese convertToCharRefIfNeeded:allows unableToEncode:&indexSet];
    if (!messageEncoded) {
        if (indexSet) {
            //TODO アラート...;
            return NO;
        }
    }*/
//    [postingBody appendFormat:@"MESSAGE=%@", messageEncoded];
    [forms setObject:[[self userInfo] objectForKey:P22chPostUserInfoBodyKey] forKey:@"MESSAGE"];
    
    // URL エンコードもここでやる
    postingBody = [self parameterWithForm:forms error:error];
    if (!postingBody) { // どこかで URL エンコードに失敗
        return NO;
    }

//    NSLog(@"%@", postingBody);

    NSString *postToUrl = [NSString stringWithFormat:@"http://%@/p2/%@", p2Host, actionString];
    
    NSMutableURLRequest *postRequest = [[[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:postToUrl]] autorelease];
    [postRequest setHTTPMethod:@"POST"];
    [postRequest setHTTPBody:[postingBody dataUsingEncoding:NSASCIIStringEncoding allowLossyConversion:YES]];
    [postRequest setHTTPShouldHandleCookies:NO];
    [postRequest addValue:cookie forHTTPHeaderField:HTTP_COOKIE_HEADER_KEY];
    
    NSURLResponse *response2;
    NSData *result2 = [NSURLConnection sendSynchronousRequest:postRequest returningResponse:&response2 error:&underlyingError];
    if (!result2) {
        if (error != NULL) {
            *error = errorWithUnderlyingCocoaError(underlyingError, 4);
        }
        return NO;
    }
    
    return [self detectIsP2PostSuccess:result2 error:error];
}

- (BOOL)detectIsP2PostSuccess:(NSData *)responseData error:(NSError **)error
{
    NSString *string = [[[NSString alloc] initWithData:responseData encoding:NSShiftJISStringEncoding] autorelease];
    
    NSString *successHint = PluginLocalizedStringFromTable(@"p2Post success hint", nil, @"");
    
    if ([string rangeOfString:successHint options:NSLiteralSearch].location != NSNotFound) {
        return YES;
    } else if ([string rangeOfString:PluginLocalizedStringFromTable(@"p2Post no activation hint", nil, @"") options:NSLiteralSearch].location != NSNotFound) {
        if (error != NULL) {
            *error = [NSError errorWithDomain:BSBathyScapheErrorDomain code:BSP22chWriteNoActivationError userInfo:[NSDictionary dictionaryWithObjectsAndKeys:PluginLocalizedStringFromTable(@"Error p2Post no activation message", nil, @""), NSLocalizedDescriptionKey, PluginLocalizedStringFromTable(@"Error p2Post no activation info", nil, @""), NSLocalizedRecoverySuggestionErrorKey, nil]];
        }
        return NO;
    } else {
        // 手抜き...
        NSAttributedString *tmp = [[[NSAttributedString alloc] initWithHTML:responseData documentAttributes:NULL] autorelease];
        NSString *reason = [tmp string];
        if (error != NULL) {
            *error = [NSError errorWithDomain:SG2chErrorHandlerErrorDomain code:BSP22chWriteUnknownError userInfo:[NSDictionary dictionaryWithObjectsAndKeys:@"ERROR!", SG2chErrorTitleErrorKey, reason, SG2chErrorMessageErrorKey, nil]];
        }
        return NO;
    }
}

@end
