//:CMRThreadsList-Search.m
/**
  *
  * XbȟT|[g
  *
  * @version 1.0.0d2 (01/12/23  11:32:58 AM)
  *
  */

#import "CMRThreadsList_p.h"
/*
typedef enum _ThreadsListSearchMask{
	ThreadsListTitleSeach = 1,			//^CgŌ
	ThreadsListPathSearch = 1 << 1,		//pXŌ@
} ThreadsListSearchMask;
*/
/**
  * [֐]_seachByLogFilePath
  * 
  * XbhTŃpXSɈvꍇYESԂB
  * contextɂ̓pXnƁB
  * 
  * @param    thread    eXgXbhB
  * @param    context   pX
  */
static BOOL _seachByLogFilePath(NSDictionary *thread, void *context)
{
	NSString *path_;		//ƂȂpX
	NSString *target_;		//eXgpX
	
	path_ = (NSString *)context;
	NSCAssert(
		(path_ == nil || [path_ respondsToSelector : @selector(isSameAsString:)]),
		@"_seachByLogFilePath  context must be NSString!");
	
	target_ = [CMRThreadAttributes pathFromDictionary : thread];
	UTILCAssertNotNil(target_);
	
	if(target_ == nil && path_ == nil) return YES;
	if(target_ == nil || path_ == nil) return NO;
	
	return [path_ isSameAsString : target_];
}

/**
  * [֐ : _func4type]
  * ThreadsListSearchTypeɑΉ錟p֐ԂB
  */
static TLSearchFunction _func4type(ThreadsListSearchType type){
	switch(type){
	case ThreadsListTitleSeach:
		return _seachByLogFilePath;
		break;
	case ThreadsListPathSearch:
		return _seachByLogFilePath;
		break;
	default:
		return _seachByLogFilePath;
		break;
	}
	return _seachByLogFilePath;
}


@implementation CMRThreadsList(SearchThreads)
/**
  * Ot@C̕ۑꏊw肳ꂽpX
  * Xbhւ̎QƂԂB
  * Ȃ΁AnilԂB
  * 
  * @param    filepath  Ot@C̕ۑꏊ
  * @return             Xbh
  */
- (NSMutableDictionary *) seachThreadByPath : (NSString *) filepath
{
	id thread_;					//Xbh
	
	// ɃO擾Ă΁AɊi[ĂB
	// O݂ȂꍇNSNulli[ĂB
	thread_ = [[self threadsInfo] objectForKey : filepath];
	if(thread_ != nil && (NO == [thread_ isEqual : [NSNull null]]))
		return thread_;
	
	// OȂ΁Aꗗ猟B
	thread_ = [self seachThreadByPath : filepath inArray : [self threads]];
	
	return thread_;
}

/**
  * Ot@C̕ۑꏊw肳ꂽpX
  * Xbhւ̎QƂԂB
  * Ȃ΁AnilԂB
  * 
  * @param    filepath  Ot@C̕ۑꏊ
  * @return             Xbh
  */
- (NSMutableDictionary *) seachThreadByPath : (NSString *) filepath
									inArray : (NSArray  *) array
{
	NSArray *matched_;		//Xbh
	
	matched_ = [self _seachThreads : ThreadsListPathSearch
						   inArray : array
						   context : filepath];
	//Ȃ΁AnilԂB
	if([matched_ count] == 0) return nil;
	
	//pẌvXbh͂ЂƂȂB
	NSAssert(
		([matched_ count] == 1),
		@"duplicated threadsList.");
	
	return [matched_ objectAtIndex : 0];
}

/**
  * ێĂXbhꗗTAɃ}b`Xbh
  * i[ꎞIȔzIuWFNgVɍĕԂB
  * ̃eXgɂ́AcheckerŎw肳ꂽ֐gB̊֐
  * QƂAʂƂBOOLlԂ֐łȂĂ͂ȂȂB
  * 1ɃXbh̎nA2ɂcontextnB
  * 
  * i֐jBOOL mtCheck(NSDictionary *thread, void *context);
  * 
  * ܂AɃ}b`XbhЂƂȂꍇ͋̔zԂB
  * 
  * @param    checker  eXg֐
  * @param    context  ֐ɓn
  * @return            Ƀ}b`Xbh
  */
- (NSArray *) seachThreadsUsingFunction : (TLSearchFunction)checker 
                                context : (void  *) context
{
	//ێĂXbhꗗTB
	
	return [self _seachThreadsUsingFunction : checker
							        inArray : [self threads]
							        context : context];
}

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
/**
  * w肵XbhꗗTB
  * 
  * @see seachThreadsUsingFunction:context:
  *
  * @param    type     ̎
  * @param    array    TΏۂƂȂzIuWFNg
  * @param    context  ֐ɓn
  * @return            Ƀ}b`Xbh
  */

- (NSArray *) _seachThreads : (ThreadsListSearchType) type
			        inArray : (NSArray *) array
			        context : (void    *) context
{
	return [self _seachThreadsUsingFunction : _func4type(type)
							        inArray : array
							        context : context];
}

/**
  * w肵XbhꗗTB
  * 
  * @see seachThreadsUsingFunction:context:
  *
  * @param    checker  eXg֐
  * @param    array    TΏۂƂȂzIuWFNg
  * @param    context  ֐ɓn
  * @return            Ƀ}b`Xbh
  */

- (NSArray *) _seachThreadsUsingFunction : (TLSearchFunction)checker 
							     inArray : (NSArray *) array
							     context : (void *) context
{
	NSMutableArray *result_;		//Ƀ}b`Xbh
	NSEnumerator   *iter_;			//XbhT
	NSDictionary   *thread_;		//eXg̃Xbh
	
	result_ = [NSMutableArray array];
	if(nil == array || NULL == checker) return result_;

	iter_ = [array objectEnumerator];
	
	// eXbhTAchecker֐YESԂ
	// XbhɂĂ͉ϔzɒǉĂB
	while(thread_ = [iter_ nextObject]){
		if(checker(thread_, context)){
			[result_ addObject : thread_];
		}
	}
	
	return result_;
}
@end
