//: NSLayoutManager+CMXAdditions.h
/**
  * $Id: NSLayoutManager+CMXAdditions.h,v 1.1.4.1 2006-09-01 13:46:58 masakih Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

#import <Cocoa/Cocoa.h>

#define LAYOUTMANAGER_SHOULD_FIX_BAD_BEHAVIOR		YES


@interface NSLayoutManager(CMXAdditions)
/*!
 * @method      performsGlyphGenerationIfNeeded
 * @abstract    KvȏꍇGlyph𐶐
 *
 * @discussion  ĂȂGlyphΐ܂B
 * @result      Glyph̐
 */
- (unsigned) performsGlyphGenerationIfNeeded;
- (NSRect) boundingRectForTextContainer : (NSTextContainer *) aContainer;

/*!
 * @method            isValidGlyphRange:
 * @abstract          w肵͈͂ǂ̔
 *
 * @discussion        w肵Ot͈̔͂ȂYESԂ
 * @param glyphRange  QƂOt͈̔
 * @result            w肵Ot͈̔͂ȂYESԂ
 */
- (BOOL) isValidGlyphRange : (NSRange) glyphRange;

- (unsigned) glyphIndexForCharacterAtIndex : (unsigned) anIndex;
@end



@interface NSLayoutManager(FIX_BAD_BEHAVIOR)
- (void) changeTextStorage : (NSTextStorage *) newTextStorage;
@end
