//
//  BSThreadsListOPTask.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 06/08/06.
//  Copyright 2006-2011 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSThreadsListOPTask.h"

#import "CMRThreadsList_p.h"

#import "BSDownloadTask.h"
#import "BSDBThreadsListDBUpdateTask2.h"

#import "CMRTaskManager.h"
#import "CMXWorkerContext.h"
#import "AppDefaults.h"
#import "BoardManager.h"
#import "CMRHostHandler.h"

NSString *const ThreadsListDownloaderShouldRetryUpdateNotification = @"ThreadsListDownloaderShouldRetryUpdateNotification";

@implementation BSThreadsListOPTask
+ (NSString *)localizableStringsTableName
{
	return @"ThreadsList";
}

+ (id)taskWithThreadList:(BSDBThreadList *)list forceDownload:(BOOL)forceDownload
{
	return [[[[self class] alloc] initWithThreadList:list forceDownload:forceDownload rebuild:NO] autorelease];
}

- (id)initWithThreadList:(BSDBThreadList *)list forceDownload:(BOOL)forceDownload rebuild:(BOOL)flag
{
	if (self = [super init]) {
		m_targetList = list;
		m_forceDL = forceDownload;
		isRebuilding = flag;
		[self setBoardName:[list boardName]];

		if (![self boardName]) goto fail;
	}
	
	return self;
fail:
	[self release];
	return nil;
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	
	[targetURL release];
	[dlTask release];
	[dbupTask release];
	[m_downloadData release];
	[m_downloadError release];
	[bbsName release];
	
	[super dealloc];
}

#pragma mark-
- (void)setURL:(NSURL *)url
{
	id temp = targetURL;
	targetURL = [url retain];
	[temp release];
}

- (NSURL *)url
{
	return targetURL;
}

- (void)setBoardName:(NSString *)name
{
	id u = [[BoardManager defaultManager] URLForBoardName:name];
	u = [NSURL URLWithString:CMRAppSubjectTextFileName relativeToURL:u];
	if (!u) return;

    const char *host = NULL;
    CMRGetHostCStringFromBoardURL((NSURL *)u, &host);
    isLivedoor = host ? is_jbbs_livedoor(host) : NO;

	id temp = bbsName;
	bbsName = [name retain];
	[temp release];
	
	[self setURL:u];
}

- (NSString *)boardName
{
	return bbsName;
}

#pragma mark-
- (id)makeDownloadTask
{
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
	
	dlTask = [[BSDownloadTask alloc] initWithURL:[self url]];

	[nc addObserver:self
		   selector:@selector(dlDidFinishDownloadNotification:)
			   name:BSDownloadTaskFinishDownloadNotification
			 object:dlTask];
	[nc addObserver:self
		   selector:@selector(dlAbortDownloadNotification:)
			   name:BSDownloadTaskInternalErrorNotification
			 object:dlTask];
	[nc addObserver:self
		   selector:@selector(dlAbortDownloadNotification:)
			   name:BSDownloadTaskAbortDownloadNotification
			 object:dlTask];
	[nc addObserver:self
		   selector:@selector(dlDidFailDownloadNotification:)
			   name:BSDownloadTaskFailDownloadNotification
			 object:dlTask];
	[nc addObserver:self
		   selector:@selector(dlCancelDownloadNotification:)
			   name:BSDownloadTaskCanceledNotification
			 object:dlTask];
	
	return dlTask;
}

- (void)tryToDetectMovedBoardOnMainThread:(id)dummy
{
	BoardManager *bm = [BoardManager defaultManager];
	if ([bm tryToDetectMovedBoard:[self boardName]]) {
		UTILNotifyName(ThreadsListDownloaderShouldRetryUpdateNotification);
	} else {
		NSString *message = [NSString stringWithFormat:
			[self localizedString:APP_TLIST_NOT_FOUND_MSG_FMT], [targetURL absoluteString]];

		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setAlertStyle:NSWarningAlertStyle];
		[alert setMessageText:[self localizedString:APP_TLIST_NOT_FOUND_TITLE]];
		[alert setInformativeText:message];
		
		[alert addButtonWithTitle:@"OK"];

		NSBeep();
		[alert runModal];
	}
}

- (void)tryToDetectMovedBoard
{
	[self performSelectorOnMainThread:@selector(tryToDetectMovedBoardOnMainThread:)
						   withObject:nil
						waitUntilDone:NO];
}

- (void)showDownloadErrorAlert
{
	[self performSelectorOnMainThread:@selector(showDownloadErrorAlertOnMainThread) withObject:nil waitUntilDone:NO];
}

- (void)showDownloadErrorAlertOnMainThread
{
	UTILAssertNotNil(m_downloadError);

	NSString *message = [NSString stringWithFormat:
		[self localizedString:APP_TLIST_NOT_FOUND_MSG_FMT], [targetURL absoluteString]];

	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert setAlertStyle:NSWarningAlertStyle];
	[alert setMessageText:[m_downloadError localizedDescription]];
	[alert setInformativeText:message];
	
	[alert addButtonWithTitle:@"OK"];

	NSBeep();
	[alert runModal];
}

#pragma mark-
- (void)bindToSubTask:(id)subtask
{
	[self bind:@"amount"
	  toObject:subtask
   withKeyPath:@"amount"
	   options:nil];
	[self bind:@"isInProgress"
	  toObject:subtask
   withKeyPath:@"isInProgress"
	   options:nil];
	[self bind:@"message"
	  toObject:subtask
   withKeyPath:@"message"
	   options:nil];
}
- (void)unbindSubTask
{
	[self unbind:@"amount"];
	[self unbind:@"isInProgress"];
	[self unbind:@"message"];
}
- (void)doExecuteWithLayout:(CMRThreadLayout *)layout
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[self checkIsInterrupted];
	if ([CMRPref isOnlineMode] || m_forceDL) {
		dlTask = [self makeDownloadTask];
		[self bindToSubTask:dlTask];
		[dlTask doExecuteWithLayout:layout];
		[self unbindSubTask];
		[self setIsInProgress:YES];
		[self setAmount:-1];
		
		id temp = dlTask;
		dlTask = nil;
		[temp release];
		
		[self checkIsInterrupted];
		if (m_downloadData && [m_downloadData length] != 0) {
			dbupTask = [[BSDBThreadsListDBUpdateTask2 taskWithBBSName:bbsName data:m_downloadData livedoor:isLivedoor rebuilding:isRebuilding] retain];
			[self bindToSubTask:dbupTask];
			[dbupTask doExecuteWithLayout:layout];
			[self unbindSubTask];
			id temp = dbupTask;
			dbupTask = nil;
			[temp release];
            if (isRebuilding && [dbupTask lastErrorWhileRebuilding]) {
                m_targetList.rebuildError = [dbupTask lastErrorWhileRebuilding];
            }

            id temp2 = dbupTask;
            dbupTask = nil;
            [temp2 release];
			
			[self setIsInProgress:NO];
			[self setAmount:-1];
			
			[self checkIsInterrupted];
		} else if (m_downloadError) {
			[self showDownloadErrorAlert];
		} else {
			[self tryToDetectMovedBoard];
		}
	}
	
	[self setMessage:[self localizedString:@"Updating Thread List"]];
	[self setIsInProgress:YES];
	[m_targetList performSelectorOnMainThread:@selector(updateCursor)
								   withObject:nil
								waitUntilDone:YES];
	[self setIsInProgress:NO];
	
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	
	[pool drain];
}

- (void)finalizeWhenInterrupted
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super finalizeWhenInterrupted]; // 2008-03-11
}
	
- (void)dlDidFinishDownloadNotification:(NSNotification *)notification
{
	m_downloadData = [[[notification object] receivedData] retain];
}

- (void)dlDidFailDownloadNotification:(NSNotification *)notification
{
	UTILAssertNotNil([notification userInfo]);

	m_downloadError = [[[notification userInfo] objectForKey:BSDownloadTaskErrorObjectKey] retain];
}

-(void)dlCancelDownloadNotification:(NSNotification *)notification
{
	[self setIsInterrupted:YES];
}
-(void)dlAbortDownloadNotification:(NSNotification *)notification
{
	m_downloadData = nil;
}

#pragma mark -
- (id)identifier
{
	return [NSString stringWithFormat:@"%@-%p", self, self];
}
- (NSString *)title
{
	return [NSString stringWithFormat:[self localizedString:@"Update threads list. %@"], bbsName];
}
- (NSString *)messageInProgress
{
	return [NSString stringWithFormat:[self localizedString:@"Update threads list. %@"], bbsName];
}
- (void)cancel:(id)sender
{
	[dlTask cancel:sender];
	[dbupTask cancel:sender];
	
//	[m_targetList performSelectorOnMainThread:@selector(updateCursor)
//								   withObject:nil
//								waitUntilDone:YES];
	[m_targetList updateCursor];
	m_targetList = nil;
	[super cancel:sender];
}
@end
