//
//  BoardManager-BoardListRepair.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 11/03/30.
//  Copyright 2011 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BoardManager_p.h"
#import "BSCoreDataManager.h"

@implementation BoardManager(BoardListRepairing)
- (BOOL)shouldRepairInvalidBoardData
{
    NSString *path = [self userBoardListPath];
    BOOL isDir = NO;
    NSFileManager *fm = [NSFileManager defaultManager];
    if ([fm fileExistsAtPath:path isDirectory:&isDir] && !isDir) {
        return YES;
    }
    return NO;
}

// 掲示板リストから掲示板を探して、あれば削除して YES を返す。
// なかったら、NO を返す。
- (BOOL)removeTargetItemFromList:(SmartBoardList *)list urls:(NSArray *)array
{
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	
    for (NSString *url in array) {
		NSString *name = [cdm boardNameFromBoardURL:url];
		id item = [list itemForName:name ofType:BoardListBoardItem];
		if (!item) {
			continue;
		}
		[list removeItem:item];
    }
    return YES;
}

// データベースから BoardURLColumn 列の内容が削除対象 URL に一致するレコードを探し出して、あれば削除する。
// 正常時は YES を返す。
// エラー時は NO を返す。
- (BOOL)removeTargetURLFromDB:(NSArray *)array
{
	BSCoreDataManager *cdm = [BSCoreDataManager oneTimeEditor];
	
    for (NSString *url in array) {
		[cdm removeBoardInformationWithURL:url];
    }
	return YES;
}    

- (void)repairInvalidBoardData
{
    // 削除対象の取得…
    NSLog(@"** Remove invalid board data ** Started.");
    NSArray *urlsArray = [self invalidBoardURLsToBeRemoved];
    if (!urlsArray || ([urlsArray count] == 0)) {
        NSLog(@"** Remove invalid board data ** No invalid board data to remove, so cancel repairing.");
        return;
    }

    NSLog(@"** Remove invalid board data ** Entries count = %lu", (unsigned long)[urlsArray count]);
    // ユーザ定義リスト…
    // デフォルトリスト…
    NSLog(@"** Remove invalid board data ** Remove board item from user list.");
    [self removeTargetItemFromList:[self userList] urls:urlsArray];
    NSLog(@"** Remove invalid board data ** Remove board item from default list.");
    [self removeTargetItemFromList:[self defaultList] urls:urlsArray];

    // DB…
    NSLog(@"** Remove invalid board data ** Delete records from database.");
    [self removeTargetURLFromDB:urlsArray];
    NSLog(@"** Remove invalid board data ** Finished.");
}

- (NSArray *)invalidBoardURLsToBeRemoved
{
    if (!m_invalidBoardURLs) {
        NSString *filePath = [[NSBundle mainBundle] pathForResource:@"BoardURLsToBeRemoved" ofType:@"plist"];
        m_invalidBoardURLs = [[NSArray alloc] initWithContentsOfFile:filePath];
    }
    return m_invalidBoardURLs;
}
@end
