package cerot.blight.btrace;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.sun.btrace.comm.MessageCommand;

public class BTraceConverter {
	public static final String CALL = "CALL:";
	public static final String RETURN = "RETURN:";
	public static final String SEPARATOR = "#";

	public static List<MethodExpression> toMethodExpressionList(
			List<MessageCommand> messageList) {
		List<MethodExpression> result = new ArrayList<MethodExpression>(
				messageList.size());
		for (MessageCommand command : messageList) {
			MethodExpression methodCall = toMethodExpression(command);
			result.add(methodCall);
		}

		return result;
	}

	public static MethodExpression toMethodExpression(MessageCommand command) {
		String message = command.getMessage();
		message = message.replaceAll("\n$", "");
		message = message.replaceAll("\r$", "");

		MethodExpression result = null;
		if (message.startsWith(CALL)) {
			message = message.substring(CALL.length());
			result = new MethodCall();
		} else if (message.startsWith(RETURN)) {
			message = message.substring(RETURN.length());
			result = new MethodReturn();
		} else {
			throw new IllegalArgumentException(
					"Message is not method call or return.");
		}

		int index = message.indexOf(SEPARATOR);
		String className = message.substring(0, index);
		String methodName = message.substring(index + SEPARATOR.length());
		result.setClassName(className);
		result.setMethodName(methodName);
		result.setDate(new Date(command.getTime()));

		return result;
	}
}
