/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.AnyType;
import com.sun.btrace.org.objectweb.asm.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

class TypeUtils {
    public static final Type objectType = Type.getType(Object.class);
    public static final Type stringType = Type.getType(String.class);
    public static final Type throwableType = Type.getType(Throwable.class);
    public static final Type objectArrayType = Type.getType(Object[].class);
    public static final Type anyType = Type.getType(AnyType.class);
    public static final Type anyTypeArray = Type.getType(AnyType[].class);
    private static final Map<String, String> primitives = new HashMap<String, String>();

    private TypeUtils() {
    }

    public static boolean isAnyType(Type t) {
        return t.equals(anyType);
    }

    public static boolean isAnyTypeArray(Type t) {
        return t.equals(anyTypeArray);
    }

    public static boolean isObject(Type t) {
        return t.equals(objectType);
    }

    public static boolean isObjectOrAnyType(Type t) {
        return TypeUtils.isObject(t) || TypeUtils.isAnyType(t);
    }

    public static boolean isString(Type t) {
        return t.equals(stringType);
    }

    public static boolean isThrowable(Type t) {
        return t.equals(throwableType);
    }

    public static boolean isCompatible(Type left, Type right) {
        if (left.equals(right)) {
            return true;
        }
        if (TypeUtils.isAnyType(left)) {
            int sort2 = right.getSort();
            return sort2 == 10 || sort2 == 9;
        }
        return false;
    }

    public static boolean isCompatible(Type[] args1, Type[] args2) {
        if (args1.length != args2.length) {
            return false;
        }
        for (int i = 0; i < args1.length; ++i) {
            if (args1[i].equals(args2[i])) continue;
            int sort2 = args2[i].getSort();
            if (TypeUtils.isAnyType(args1[i]) && (sort2 == 10 || sort2 == 9)) continue;
            return false;
        }
        return true;
    }

    public static Type getArrayType(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 79: {
                return Type.getType("[I");
            }
            case 51: 
            case 84: {
                return Type.getType("[B");
            }
            case 50: 
            case 83: {
                return objectArrayType;
            }
            case 52: 
            case 85: {
                return Type.getType("[C");
            }
            case 48: 
            case 81: {
                return Type.getType("[F");
            }
            case 53: 
            case 86: {
                return Type.getType("[S");
            }
            case 47: 
            case 80: {
                return Type.getType("[J");
            }
            case 49: 
            case 82: {
                return Type.getType("[D");
            }
        }
        throw new RuntimeException("invalid array opcode");
    }

    public static Type getElementType(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 79: {
                return Type.INT_TYPE;
            }
            case 51: 
            case 84: {
                return Type.BYTE_TYPE;
            }
            case 50: 
            case 83: {
                return objectType;
            }
            case 52: 
            case 85: {
                return Type.CHAR_TYPE;
            }
            case 48: 
            case 81: {
                return Type.FLOAT_TYPE;
            }
            case 53: 
            case 86: {
                return Type.SHORT_TYPE;
            }
            case 47: 
            case 80: {
                return Type.LONG_TYPE;
            }
            case 49: 
            case 82: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new RuntimeException("invalid array opcode");
    }

    public static String declarationToDescriptor(String decl) {
        String descriptor;
        int leftParen = decl.indexOf(40);
        int rightParen = decl.indexOf(41);
        if (leftParen == -1 || rightParen == -1) {
            throw new IllegalArgumentException();
        }
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        String args = decl.substring(leftParen + 1, rightParen);
        StringTokenizer st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            String arg = st.nextToken().trim();
            descriptor = primitives.get(arg);
            if (arg.length() == 0) {
                throw new IllegalArgumentException();
            }
            if (descriptor == null) {
                descriptor = TypeUtils.objectOrArrayType(arg);
            }
            buf.append(descriptor);
        }
        buf.append(')');
        String returnType = decl.substring(0, leftParen).trim();
        descriptor = primitives.get(returnType);
        if (returnType.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (descriptor == null) {
            descriptor = TypeUtils.objectOrArrayType(returnType);
        }
        buf.append(descriptor);
        return buf.toString();
    }

    private static String objectOrArrayType(String type) {
        StringBuilder buf = new StringBuilder();
        int index = 0;
        while ((index = type.indexOf("[]", index) + 1) > 0) {
            buf.append('[');
        }
        String t = type.substring(0, type.length() - buf.length() * 2);
        String desc = primitives.get(t);
        if (desc != null) {
            buf.append(desc);
        } else {
            buf.append('L');
            if (t.indexOf(46) < 0) {
                buf.append(t);
            } else {
                buf.append(t.replace('.', '/'));
            }
            buf.append(';');
        }
        return buf.toString();
    }

    static {
        primitives.put("void", "V");
        primitives.put("byte", "B");
        primitives.put("char", "C");
        primitives.put("double", "D");
        primitives.put("float", "F");
        primitives.put("int", "I");
        primitives.put("long", "J");
        primitives.put("short", "S");
        primitives.put("boolean", "Z");
    }
}

