package cerot.blight.view.sequence;

import java.util.ArrayList;
import java.util.List;

import cerot.blight.view.sequence.SequenceConverter;
import cerot.blight.view.sequence.entity.Connector;
import cerot.blight.view.sequence.entity.ConnectorType;

import cerot.blight.btrace.MethodCall;
import cerot.blight.btrace.MethodExpression;
import cerot.blight.btrace.MethodReturn;
import junit.framework.TestCase;

public class SequenceConverterTest extends TestCase {
	public void testToConnectorList_正常系() {
		List<MethodExpression> input = new ArrayList<MethodExpression>();

		MethodCall call = new MethodCall();
		call.setClassName("Class1");
		call.setMethodName("method1");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class2");
		call.setMethodName("method2");
		input.add(call);

		MethodReturn ret = new MethodReturn();
		ret.setClassName("Class2");
		input.add(ret);

		ret = new MethodReturn();
		ret.setClassName("Class1");
		input.add(ret);

		List<Connector> result = SequenceConverter.toConnectorList(input);

		assertEquals("method1", result.get(0).getName());
		assertEquals(ConnectorType.METHOD_CALL, result.get(0)
				.getConnectorType());
		assertEquals("START", result.get(0).getFrom().getParentNode().getName());
		assertEquals("Class1", result.get(0).getTo().getParentNode().getName());

		assertEquals("method2", result.get(1).getName());
		assertEquals(ConnectorType.METHOD_CALL, result.get(1)
				.getConnectorType());
		assertEquals("Class1", result.get(1).getFrom().getParentNode()
				.getName());
		assertEquals("Class2", result.get(1).getTo().getParentNode().getName());

		assertEquals("Return", result.get(2).getName());
		assertEquals(ConnectorType.METHOD_RETURN, result.get(2)
				.getConnectorType());
		assertEquals("Class2", result.get(2).getFrom().getParentNode()
				.getName());
		assertEquals("Class1", result.get(2).getTo().getParentNode().getName());

		assertEquals("Return", result.get(3).getName());
		assertEquals(ConnectorType.METHOD_RETURN, result.get(3)
				.getConnectorType());
		assertEquals("Class1", result.get(3).getFrom().getParentNode()
				.getName());
		assertEquals("START", result.get(3).getTo().getParentNode().getName());
	}

	public void testToConnectorList_ネストした呼び出し() {
		List<MethodExpression> input = new ArrayList<MethodExpression>();

		MethodCall call = new MethodCall();
		call.setClassName("Class1");
		call.setMethodName("method1");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class2");
		call.setMethodName("method2");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class3");
		call.setMethodName("method3");
		input.add(call);

		MethodReturn ret = new MethodReturn();
		ret.setClassName("Class3");
		input.add(ret);

		call = new MethodCall();
		call.setClassName("Class3");
		call.setMethodName("method3");
		input.add(call);

		ret = new MethodReturn();
		ret.setClassName("Class3");
		input.add(ret);

		ret = new MethodReturn();
		ret.setClassName("Class2");
		input.add(ret);

		ret = new MethodReturn();
		ret.setClassName("Class1");
		input.add(ret);

		List<Connector> result = SequenceConverter.toConnectorList(input);

		int count = 0;
		assertEquals("START", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class1", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class1", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class2", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class2", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class3", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class3", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class2", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class2", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class3", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class3", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class2", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class2", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class1", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class1", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("START", result.get(count).getTo().getParentNode()
				.getName());
	}

	public void testToConnectorList_自クラス呼び出し() {
		List<MethodExpression> input = new ArrayList<MethodExpression>();

		MethodCall call = new MethodCall();
		call.setClassName("Class1");
		call.setMethodName("method1");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class2");
		call.setMethodName("method2");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class2");
		call.setMethodName("innerMethod");
		input.add(call);

		MethodReturn ret = new MethodReturn();
		ret.setClassName("Class2");
		input.add(ret);

		ret = new MethodReturn();
		ret.setClassName("Class2");
		input.add(ret);

		ret = new MethodReturn();
		ret.setClassName("Class1");
		input.add(ret);

		List<Connector> result = SequenceConverter.toConnectorList(input);

		int count = 0;
		assertEquals("START", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class1", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class1", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class2", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class2", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class1", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class1", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("START", result.get(count).getTo().getParentNode()
				.getName());
	}

	public void testToConnectorList_Returnなし() {
		List<MethodExpression> input = new ArrayList<MethodExpression>();

		MethodCall call = new MethodCall();
		call.setClassName("Class1");
		call.setMethodName("method1");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class2");
		call.setMethodName("method2");
		input.add(call);

		call = new MethodCall();
		call.setClassName("Class2");
		call.setMethodName("method2");
		input.add(call);

		List<Connector> result = SequenceConverter.toConnectorList(input);

		int count = 0;
		assertEquals("START", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class1", result.get(count).getTo().getParentNode()
				.getName());

		count++;
		assertEquals("Class1", result.get(count).getFrom().getParentNode()
				.getName());
		assertEquals("Class2", result.get(count).getTo().getParentNode()
				.getName());
	}
}
