/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class mxVertexHandler
extends mxCellHandler {
    public static Cursor[] CURSORS = new Cursor[]{new Cursor(6), new Cursor(8), new Cursor(7), new Cursor(10), new Cursor(11), new Cursor(4), new Cursor(9), new Cursor(5), new Cursor(13)};
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;

    public mxVertexHandler(mxGraphComponent mxGraphComponent2, mxCellState mxCellState2) {
        super(mxGraphComponent2, mxCellState2);
    }

    protected Rectangle[] createHandles() {
        Rectangle[] rectangleArray = null;
        if (this.graphComponent.getGraph().isSizable(this.getState().getCell())) {
            Rectangle rectangle = this.getState().getRectangle();
            int n = mxConstants.HANDLE_SIZE / 2;
            int n2 = rectangle.x - n;
            int n3 = rectangle.y - n;
            int n4 = rectangle.x + rectangle.width / 2 - n;
            int n5 = rectangle.y + rectangle.height / 2 - n;
            int n6 = rectangle.x + rectangle.width - n;
            int n7 = rectangle.y + rectangle.height - n;
            rectangleArray = new Rectangle[9];
            int n8 = mxConstants.HANDLE_SIZE;
            rectangleArray[0] = new Rectangle(n2, n3, n8, n8);
            rectangleArray[1] = new Rectangle(n4, n3, n8, n8);
            rectangleArray[2] = new Rectangle(n6, n3, n8, n8);
            rectangleArray[3] = new Rectangle(n2, n5, n8, n8);
            rectangleArray[4] = new Rectangle(n6, n5, n8, n8);
            rectangleArray[5] = new Rectangle(n2, n7, n8, n8);
            rectangleArray[6] = new Rectangle(n4, n7, n8, n8);
            rectangleArray[7] = new Rectangle(n6, n7, n8, n8);
        } else {
            rectangleArray = new Rectangle[1];
        }
        int n = mxConstants.HANDLE_SIZE / 2;
        mxRectangle mxRectangle2 = this.state.getLabelBounds();
        rectangleArray[rectangleArray.length - 1] = new Rectangle((int)(mxRectangle2.getX() + mxRectangle2.getWidth() / 2.0 - (double)n), (int)(mxRectangle2.getY() + mxRectangle2.getHeight() / 2.0 - (double)n), 2 * n, 2 * n);
        return rectangleArray;
    }

    protected JComponent createPreview() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(mxConstants.PREVIEW_BORDER);
        jPanel.setOpaque(false);
        jPanel.setVisible(false);
        return jPanel;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.start != null) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(mouseEvent);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(mouseEvent);
            double d = mouseEvent.getX() - this.start.x;
            double d2 = mouseEvent.getY() - this.start.y;
            if (this.isLabel(this.index)) {
                mxPoint mxPoint2 = new mxPoint(mouseEvent.getPoint());
                if (this.gridEnabledEvent) {
                    mxPoint2 = this.graphComponent.snapScaledPoint(mxPoint2);
                }
                int n = (int)Math.round(mxPoint2.getX() - (double)this.start.x);
                int n2 = (int)Math.round(mxPoint2.getY() - (double)this.start.y);
                if (this.constrainedEvent) {
                    if (Math.abs(n) > Math.abs(n2)) {
                        n2 = 0;
                    } else {
                        n = 0;
                    }
                }
                Rectangle rectangle = this.state.getLabelBounds().getRectangle();
                rectangle.translate(n, n2);
                this.preview.setBounds(rectangle);
            } else {
                mxGraph mxGraph2 = this.graphComponent.getGraph();
                double d3 = mxGraph2.getView().getScale();
                if (this.gridEnabledEvent) {
                    d = mxGraph2.snap(d / d3) * d3;
                    d2 = mxGraph2.snap(d2 / d3) * d3;
                }
                mxRectangle mxRectangle2 = this.union(this.getState(), d, d2, this.index);
                mxRectangle2.setWidth(mxRectangle2.getWidth() + 1.0);
                mxRectangle2.setHeight(mxRectangle2.getHeight() + 1.0);
                this.preview.setBounds(mxRectangle2.getRectangle());
            }
            if (!this.preview.isVisible() && this.graphComponent.isSignificant(d, d2)) {
                this.preview.setVisible(true);
            }
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.start != null) {
            if (this.preview != null && this.preview.isVisible()) {
                if (this.isLabel(this.index)) {
                    this.moveLabel(mouseEvent);
                } else {
                    this.resizeCell(mouseEvent);
                }
            }
            mouseEvent.consume();
        }
        super.mouseReleased(mouseEvent);
    }

    protected void moveLabel(MouseEvent mouseEvent) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxGeometry mxGeometry2 = mxGraph2.getModel().getGeometry(this.state.getCell());
        if (mxGeometry2 != null) {
            mxPoint mxPoint2;
            double d = mxGraph2.getView().getScale();
            mxPoint mxPoint3 = new mxPoint(mouseEvent.getPoint());
            if (this.gridEnabledEvent) {
                mxPoint3 = this.graphComponent.snapScaledPoint(mxPoint3);
            }
            double d2 = (mxPoint3.getX() - (double)this.start.x) / d;
            double d3 = (mxPoint3.getY() - (double)this.start.y) / d;
            if (this.constrainedEvent) {
                if (Math.abs(d2) > Math.abs(d3)) {
                    d3 = 0.0;
                } else {
                    d2 = 0.0;
                }
            }
            if ((mxPoint2 = mxGeometry2.getOffset()) == null) {
                mxPoint2 = new mxPoint();
            }
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            mxGeometry2.setOffset(new mxPoint(Math.round(d2 += mxPoint2.getX()), Math.round(d3 += mxPoint2.getY())));
            mxGraph2.getModel().setGeometry(this.state.getCell(), mxGeometry2);
        }
    }

    protected void resizeCell(MouseEvent mouseEvent) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        double d = mxGraph2.getView().getScale();
        Object object = this.state.getCell();
        mxGeometry mxGeometry2 = mxGraph2.getModel().getGeometry(object);
        if (mxGeometry2 != null) {
            double d2 = (double)(mouseEvent.getX() - this.start.x) / d;
            double d3 = (double)(mouseEvent.getY() - this.start.y) / d;
            if (this.isLabel(this.index)) {
                if ((mxGeometry2 = (mxGeometry)mxGeometry2.clone()).getOffset() != null) {
                    d2 += mxGeometry2.getOffset().getX();
                    d3 += mxGeometry2.getOffset().getY();
                }
                if (this.gridEnabledEvent) {
                    d2 = mxGraph2.snap(d2);
                    d3 = mxGraph2.snap(d3);
                }
                mxGeometry2.setOffset(new mxPoint(d2, d3));
                mxGraph2.getModel().setGeometry(object, mxGeometry2);
            } else {
                mxRectangle mxRectangle2 = this.union(mxGeometry2, d2, d3, this.index);
                Rectangle rectangle = mxRectangle2.getRectangle();
                if (this.gridEnabledEvent) {
                    int n = (int)mxGraph2.snap(rectangle.x);
                    int n2 = (int)mxGraph2.snap(rectangle.y);
                    rectangle.width = (int)mxGraph2.snap(rectangle.width - n + rectangle.x);
                    rectangle.height = (int)mxGraph2.snap(rectangle.height - n2 + rectangle.y);
                    rectangle.x = n;
                    rectangle.y = n2;
                }
                mxGraph2.resize(object, new mxRectangle(rectangle));
            }
        }
    }

    protected Cursor getCursor(MouseEvent mouseEvent, int n) {
        if (n >= 0 && n <= CURSORS.length) {
            return CURSORS[n];
        }
        return null;
    }

    protected mxRectangle union(mxRectangle mxRectangle2, double d, double d2, int n) {
        double d3 = mxRectangle2.getX();
        double d4 = d3 + mxRectangle2.getWidth();
        double d5 = mxRectangle2.getY();
        double d6 = d5 + mxRectangle2.getHeight();
        if (n > 4) {
            d6 += d2;
        } else if (n < 3) {
            d5 += d2;
        }
        if (n == 0 || n == 3 || n == 5) {
            d3 += d;
        } else if (n == 2 || n == 4 || n == 7) {
            d4 += d;
        }
        double d7 = d4 - d3;
        double d8 = d6 - d5;
        if (d7 < 0.0) {
            d3 += d7;
            d7 = Math.abs(d7);
        }
        if (d8 < 0.0) {
            d5 += d8;
            d8 = Math.abs(d8);
        }
        return new mxRectangle(d3, d5, d7, d8);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getState().getRectangle();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(mxConstants.SELECTION_STROKE);
        graphics.setColor(mxConstants.SELECTION_COLOR);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setStroke(stroke);
        super.paint(graphics);
    }
}

