#include <stdint.h>

typedef struct utosary {
	unsigned char		s1;	/* high byte of shift jis code */
	unsigned char		s2;	/* low byte of shift jis code */
	int8_t		lev;	/* shift jis kanji level no */
	unsigned char		u1;	/* high byte of unicode */
	unsigned char		u2;	/* low byte of unicode */
	uint16_t	uno;	/* unicode number */
} StoUtarray;

typedef struct utosarysurr {
	unsigned char		s1;	/* high byte of shift jis code */
	unsigned char		s2;	/* low byte of shift jis code */
	int8_t		lev;	/* shift jis kanji level no */
	unsigned char		u1;	/* high byte of unicode */
	unsigned char		u2;	/* low byte of unicode */
	uint32_t	uno;	/* unicode number */
} StoUtarraySurr;

	/* containor for utf16 format value without endian */
typedef struct charcodes {
	unsigned char	s1;
	unsigned char	s2;
	unsigned char	u1;
	unsigned char	u2;
} charcode;

charcode
decode2byte(uint8_t u1, uint8_t u2);

charcode
decode3byte(uint8_t u1, uint8_t u2, uint8_t u3);

charcode
decode4byte(uint8_t u1, uint8_t u2, uint8_t u3, uint8_t u4);

unsigned char *
chg_endian(const unsigned char *str, uint16_t strlen);