#include <stdint.h>
#include <stddef.h>
#include "s2u.h"

static StoUary s2utable[15218] = {
{ 0x8140, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-01 　	# IDEOGRAPHIC SPACE	 */
{ 0x8141, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-02 、	# IDEOGRAPHIC COMMA	 */
{ 0x8142, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-03 。	# IDEOGRAPHIC FULL STOP	 */
{ 0x8143, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-04 ，	# COMMA	Halfwidth: U+002C */
{ 0x8144, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-05 ．	# FULL STOP	Halfwidth: U+002E */
{ 0x8145, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-06 ・	# KATAKANA MIDDLE DOT	 */
{ 0x8146, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-07 ：	# COLON	Halfwidth: U+003A */
{ 0x8147, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-08 ；	# SEMICOLON	Halfwidth: U+003B */
{ 0x8148, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-09 ？	# QUESTION MARK	Halfwidth: U+003F */
{ 0x8149, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-10 ！	# EXCLAMATION MARK	Halfwidth: U+0021 */
{ 0x814A, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-11 ゛	# KATAKANA-HIRAGANA VOICED SOUND MARK	 */
{ 0x814B, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-12 ゜	# KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK	 */
{ 0x814C, -1, 4, { 0x00, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-13 ´	# ACUTE ACCENT	 */
{ 0x814D, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-14 ｀	# GRAVE ACCENT	Halfwidth: U+0060 */
{ 0x814E, -1, 4, { 0x00, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-15 ¨	# DIAERESIS	 */
{ 0x814F, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-16 ＾	# CIRCUMFLEX ACCENT	Halfwidth: U+005E */
{ 0x8150, -1, 5, { 0x02, 0x00, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-17 ‾	# OVERLINE	Windows: U+FFE3 (￣) */
{ 0x8151, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-18 ＿	# LOW LINE	Halfwidth: U+005F */
{ 0x8152, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-19 ヽ	# KATAKANA ITERATION MARK	 */
{ 0x8153, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-20 ヾ	# KATAKANA VOICED ITERATION MARK	 */
{ 0x8154, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-21 ゝ	# HIRAGANA ITERATION MARK	 */
{ 0x8155, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-22 ゞ	# HIRAGANA VOICED ITERATION MARK	 */
{ 0x8156, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-23 〃	# DITTO MARK	 */
{ 0x8157, -1, 5, { 0x04, 0x0e, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-24 仝	# [cjk]	 */
{ 0x8158, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-25 々	# IDEOGRAPHIC ITERATION MARK	 */
{ 0x8159, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-26 〆	# IDEOGRAPHIC CLOSING MARK	 */
{ 0x815A, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-27 〇	# IDEOGRAPHIC NUMBER ZERO	 */
{ 0x815B, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-28 ー	# KATAKANA-HIRAGANA PROLONGED SOUND MARK	 */
{ 0x815C, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-29 —	# EM DASH	Windows: U+2015 (―) */
{ 0x815D, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-30 ‐	# HYPHEN	 */
{ 0x815E, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-31 ／	# SOLIDUS	Halfwidth: U+002F */
{ 0x815F, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-32 \	# REVERSE SOLIDUS	Halfwidth: U+005C */
{ 0x8160, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-33 〜	# WAVE DASH	Windows: U+FF5E (～) */
{ 0x8161, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-34 ‖	# DOUBLE VERTICAL LINE	Windows: U+2225 (∥) */
{ 0x8162, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-35 ｜	# VERTICAL LINE	Halfwidth: U+007C */
{ 0x8163, -1, 5, { 0x02, 0x00, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-36 …	# HORIZONTAL ELLIPSIS	 */
{ 0x8164, -1, 5, { 0x02, 0x00, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-37 ‥	# TWO DOT LEADER	 */
{ 0x8165, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-38 ‘	# LEFT SINGLE QUOTATION MARK	 */
{ 0x8166, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-39 ’	# RIGHT SINGLE QUOTATION MARK	 */
{ 0x8167, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-40 “	# LEFT DOUBLE QUOTATION MARK	 */
{ 0x8168, -1, 5, { 0x02, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-41 ”	# RIGHT DOUBLE QUOTATION MARK	 */
{ 0x8169, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-42 （	# LEFT PARENTHESIS	Halfwidth: U+0028 */
{ 0x816A, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-43 ）	# RIGHT PARENTHESIS	Halfwidth: U+0029 */
{ 0x816B, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-44 〔	# LEFT TORTOISE SHELL BRACKET	 */
{ 0x816C, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-45 〕	# RIGHT TORTOISE SHELL BRACKET	 */
{ 0x816D, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-46 ［	# LEFT SQUARE BRACKET	Halfwidth: U+005B */
{ 0x816E, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-47 ］	# RIGHT SQUARE BRACKET	Halfwidth: U+005D */
{ 0x816F, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-48 ｛	# LEFT CURLY BRACKET	Halfwidth: U+007B */
{ 0x8170, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-49 ｝	# RIGHT CURLY BRACKET	Halfwidth: U+007D */
{ 0x8171, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-50 〈	# LEFT ANGLE BRACKET	 */
{ 0x8172, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-51 〉	# RIGHT ANGLE BRACKET	 */
{ 0x8173, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-52 《	# LEFT DOUBLE ANGLE BRACKET	 */
{ 0x8174, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-53 》	# RIGHT DOUBLE ANGLE BRACKET	 */
{ 0x8175, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-54 「	# LEFT CORNER BRACKET	 */
{ 0x8176, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-55 」	# RIGHT CORNER BRACKET	 */
{ 0x8177, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-56 『	# LEFT WHITE CORNER BRACKET	 */
{ 0x8178, -1, 5, { 0x03, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-57 』	# RIGHT WHITE CORNER BRACKET	 */
{ 0x8179, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-58 【	# LEFT BLACK LENTICULAR BRACKET	 */
{ 0x817A, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-59 】	# RIGHT BLACK LENTICULAR BRACKET	 */
{ 0x817B, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-60 ＋	# PLUS SIGN	Halfwidth: U+002B */
{ 0x817C, -1, 5, { 0x02, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-61 −	# MINUS SIGN	Windows: U+FF0D (－) */
{ 0x817D, -1, 4, { 0x00, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-62 ±	# PLUS-MINUS SIGN	 */
{ 0x817E, -1, 4, { 0x00, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-63 ×	# MULTIPLICATION SIGN	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8180, -1, 4, { 0x00, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-64 ÷	# DIVISION SIGN	 */
{ 0x8181, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-65 ＝	# EQUALS SIGN	Halfwidth: U+003D */
{ 0x8182, -1, 5, { 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-66 ≠	# NOT EQUAL TO	 */
{ 0x8183, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-67 ＜	# LESS-THAN SIGN	Halfwidth: U+003C */
{ 0x8184, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-68 ＞	# GREATER-THAN SIGN	Halfwidth: U+003E */
{ 0x8185, -1, 5, { 0x02, 0x02, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-69 ≦	# LESS-THAN OVER EQUAL TO	 */
{ 0x8186, -1, 5, { 0x02, 0x02, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-70 ≧	# GREATER-THAN OVER EQUAL TO	 */
{ 0x8187, -1, 5, { 0x02, 0x02, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-71 ∞	# INFINITY	 */
{ 0x8188, -1, 5, { 0x02, 0x02, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-72 ∴	# THEREFORE	 */
{ 0x8189, -1, 5, { 0x02, 0x06, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-73 ♂	# MALE SIGN	 */
{ 0x818A, -1, 5, { 0x02, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-74 ♀	# FEMALE SIGN	 */
{ 0x818B, -1, 4, { 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-75 °	# DEGREE SIGN	 */
{ 0x818C, -1, 5, { 0x02, 0x00, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-76 ′	# PRIME	 */
{ 0x818D, -1, 5, { 0x02, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-77 ″	# DOUBLE PRIME	 */
{ 0x818E, -1, 5, { 0x02, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-78 ℃	# DEGREE CELSIUS	 */
{ 0x818F, -1, 4, { 0x00, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-79 ¥	# YEN SIGN	Windows: U+FFE5 (￥) */
{ 0x8190, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-80 ＄	# DOLLAR SIGN	Halfwidth: U+0024 */
{ 0x8191, -1, 4, { 0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-81 ¢	# CENT SIGN	Windows: U+FFE0 (￠) */
{ 0x8192, -1, 4, { 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-82 £	# POUND SIGN	Windows: U+FFE1 (￡) */
{ 0x8193, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-83 ％	# PERCENT SIGN	Halfwidth: U+0025 */
{ 0x8194, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-84 ＃	# NUMBER SIGN	Halfwidth: U+0023 */
{ 0x8195, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-85 ＆	# AMPERSAND	Halfwidth: U+0026 */
{ 0x8196, -1, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-86 ＊	# ASTERISK	Halfwidth: U+002A */
{ 0x8197, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-87 ＠	# COMMERCIAL AT	Halfwidth: U+0040 */
{ 0x8198, -1, 4, { 0x00, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-88 §	# SECTION SIGN	 */
{ 0x8199, -1, 5, { 0x02, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-89 ☆	# WHITE STAR	 */
{ 0x819A, -1, 5, { 0x02, 0x06, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-90 ★	# BLACK STAR */
{ 0x819B, -1, 5, { 0x02, 0x05, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-91 ○	# WHITE CIRCLE */
{ 0x819C, -1, 5, { 0x02, 0x05, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-92 ●	# BLACK CIRCLE */
{ 0x819D, -1, 5, { 0x02, 0x05, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-93 ◎	# BULLSEYE */
{ 0x819E, -1, 5, { 0x02, 0x05, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-01-94 ◇	# WHITE DIAMOND */
{ 0x819F, -1, 5, { 0x02, 0x05, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-01 ◆	# BLACK DIAMOND */
{ 0x81A0, -1, 5, { 0x02, 0x05, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-02 □	# WHITE SQUARE */
{ 0x81A1, -1, 5, { 0x02, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-03 ■	# BLACK SQUARE */
{ 0x81A2, -1, 5, { 0x02, 0x05, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-04 △	# WHITE UP-POINTING TRIANGLE */
{ 0x81A3, -1, 5, { 0x02, 0x05, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-05 ▲	# BLACK UP-POINTING TRIANGLE */
{ 0x81A4, -1, 5, { 0x02, 0x05, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-06 ▽	# WHITE DOWN-POINTING TRIANGLE */
{ 0x81A5, -1, 5, { 0x02, 0x05, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-07 ▼	# BLACK DOWN-POINTING TRIANGLE */
{ 0x81A6, -1, 5, { 0x02, 0x00, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-08 ※	# REFERENCE MARK */
{ 0x81A7, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-09 〒	# POSTAL MARK */
{ 0x81A8, -1, 5, { 0x02, 0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-10 →	# RIGHTWARDS ARROW */
{ 0x81A9, -1, 5, { 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-11 ←	# LEFTWARDS ARROW */
{ 0x81AA, -1, 5, { 0x02, 0x01, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-12 ↑	# UPWARDS ARROW		 */
{ 0x81AB, -1, 5, { 0x02, 0x01, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-13 ↓	# DOWNWARDS ARROW		 */
{ 0x81AC, -1, 5, { 0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-14 〓	# GETA MARK		 */
{ 0x81AD, -2, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-15 ＇	# APOSTROPHE	Halfwidth: U+0027	 */
{ 0x81AE, -2, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-16 ＂	# QUOTATION MARK	[2000]	Halfwidth: U+0022 */
{ 0x81AF, -2, 5, { 0x0f, 0x0f, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-17 －	# HYPHEN-MINUS	[2000]	Halfwidth: U+002D */
{ 0x81B0, -2, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-18 〜	# TILDE	[2000]	Halfwidth: U+007E */
{ 0x81B1, -2, 5, { 0x03, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-19 〳	# VERTICAL KANA REPEAT MARK UPPER HALF	[2000]	 */
{ 0x81B2, -2, 5, { 0x03, 0x00, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-20 〴	# VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF	[2000]	 */
{ 0x81B3, -2, 5, { 0x03, 0x00, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-21 〵	# VERTICAL KANA REPEAT MARK LOWER HALF	[2000]	 */
{ 0x81B4, -2, 5, { 0x03, 0x00, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-22 〻	# VERTICAL IDEOGRAPHIC ITERATION MARK	[2000]	[Unicode3.2] */
{ 0x81B5, -2, 5, { 0x03, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-23 〼	# MASU MARK	[2000]	[Unicode3.2] */
{ 0x81B6, -2, 5, { 0x03, 0x00, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-24 ヿ	# KATAKANA DIGRAPH KOTO	[2000]	[Unicode3.2] */
{ 0x81B7, -2, 5, { 0x03, 0x00, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-25 ゟ	# HIRAGANA DIGRAPH YORI	[2000]	[Unicode3.2] */
{ 0x81B8, -1, 5, { 0x02, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-26 ∈	# ELEMENT OF	[1983]	 */
{ 0x81B9, -1, 5, { 0x02, 0x02, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-27 ∋	# CONTAINS AS MEMBER	[1983]	 */
{ 0x81BA, -1, 5, { 0x02, 0x02, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-28 ⊆	# SUBSET OF OR EQUAL TO	[1983] */
{ 0x81BB, -1, 5, { 0x02, 0x02, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-29 ⊇	# SUPERSET OF OR EQUAL TO	[1983] */
{ 0x81BC, -1, 5, { 0x02, 0x02, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-30 ⊂	# SUBSET OF	[1983] */
{ 0x81BD, -1, 5, { 0x02, 0x02, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-31 ⊃	# SUPERSET OF	[1983] */
{ 0x81BE, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-32 ∪	# UNION	[1983] */
{ 0x81BF, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-33 ∩	# INTERSECTION	[1983] */
{ 0x81C0, -2, 5, { 0x02, 0x02, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-34 ⊄	# NOT A SUBSET OF	[2000] */
{ 0x81C1, -2, 5, { 0x02, 0x02, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-35 ⊅	# NOT A SUPERSET OF	[2000] */
{ 0x81C2, -2, 5, { 0x02, 0x02, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-36 ⊊	# SUBSET OF WITH NOT EQUAL TO	[2000] */
{ 0x81C3, -2, 5, { 0x02, 0x02, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-37 ⊋	# SUPERSET OF WITH NOT EQUAL TO	[2000] */
{ 0x81C4, -2, 5, { 0x02, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-38 ∉	# NOT AN ELEMENT OF	[2000] */
{ 0x81C5, -2, 5, { 0x02, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-39 ∅	# EMPTY SET	[2000] */
{ 0x81C6, -2, 5, { 0x02, 0x03, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-40 ⌅	# PROJECTIVE	[2000] */
{ 0x81C7, -2, 5, { 0x02, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-41 ⌆	# PERSPECTIVE	[2000] */
{ 0x81C8, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-42 ∧	# LOGICAL AND	[1983] */
{ 0x81C9, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-43 ∨	# LOGICAL OR	[1983] */
{ 0x81CA, -1, 4, { 0x00, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-44 ¬	# NOT SIGN	[1983]	Windows: U+FFE2 (￢) */
{ 0x81CB, -1, 5, { 0x02, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-45 ⇒	# RIGHTWARDS DOUBLE ARROW	[1983]	 */
{ 0x81CC, -1, 5, { 0x02, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-46 ⇔	# LEFT RIGHT DOUBLE ARROW	[1983]	 */
{ 0x81CD, -1, 5, { 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-47 ∀	# FOR ALL	[1983]	 */
{ 0x81CE, -1, 5, { 0x02, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-48 ∃	# THERE EXISTS	[1983]	 */
{ 0x81CF, -2, 5, { 0x02, 0x02, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-49 ⊕	# CIRCLED PLUS	[2000]	 */
{ 0x81D0, -2, 5, { 0x02, 0x02, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-50 ⊖	# CIRCLED MINUS	[2000]	 */
{ 0x81D1, -2, 5, { 0x02, 0x02, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-51 ⊗	# CIRCLED TIMES	[2000]	 */
{ 0x81D2, -2, 5, { 0x02, 0x02, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-52 ∥	# PARALLEL TO	[2000]	 */
{ 0x81D3, -2, 5, { 0x02, 0x02, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-53 ∦	# NOT PARALLEL TO	[2000]	 */
{ 0x81D4, -2, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-54 ｟	# FULLWIDTH LEFT WHITE PARENTHESIS	[2000]	[Unicode3.2] */
{ 0x81D5, -2, 5, { 0x0f, 0x0f, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-55 ｠	# FULLWIDTH RIGHT WHITE PARENTHESIS	[2000]	[Unicode3.2] */
{ 0x81D6, -2, 5, { 0x03, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-56 〘	# LEFT WHITE TORTOISE SHELL BRACKET	[2000]	 */
{ 0x81D7, -2, 5, { 0x03, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-57 〙	# RIGHT WHITE TORTOISE SHELL BRACKET	[2000]	 */
{ 0x81D8, -2, 5, { 0x03, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-58 〖	# LEFT WHITE LENTICULAR BRACKET	[2000]	 */
{ 0x81D9, -2, 5, { 0x03, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-59 〗	# RIGHT WHITE LENTICULAR BRACKET	[2000]	 */
{ 0x81DA, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-60 ∠	# ANGLE	[1983] */
{ 0x81DB, -1, 5, { 0x02, 0x02, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-61 ⊥	# UP TACK	[1983] */
{ 0x81DC, -1, 5, { 0x02, 0x03, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-62 ⌒	# ARC	[1983] */
{ 0x81DD, -1, 5, { 0x02, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-63 ∂	# PARTIAL DIFFERENTIAL	[1983] */
{ 0x81DE, -1, 5, { 0x02, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-64 ∇	# NABLA	[1983] */
{ 0x81DF, -1, 5, { 0x02, 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-65 ≡	# IDENTICAL TO	[1983] */
{ 0x81E0, -1, 5, { 0x02, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-66 ≒	# APPROXIMATELY EQUAL TO OR THE IMAGE OF	[1983] */
{ 0x81E1, -1, 5, { 0x02, 0x02, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-67 ≪	# MUCH LESS-THAN	[1983] */
{ 0x81E2, -1, 5, { 0x02, 0x02, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-68 ≫	# MUCH GREATER-THAN	[1983] */
{ 0x81E3, -1, 5, { 0x02, 0x02, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-69 √	# SQUARE ROOT	[1983] */
{ 0x81E4, -1, 5, { 0x02, 0x02, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-70 ∽	# REVERSED TILDE 	[1983] */
{ 0x81E5, -1, 5, { 0x02, 0x02, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-71 ∝	# PROPORTIONAL TO	[1983] */
{ 0x81E6, -1, 5, { 0x02, 0x02, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-72 ∵	# BECAUSE	[1983] */
{ 0x81E7, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-73 ∫	# INTEGRAL	[1983] */
{ 0x81E8, -1, 5, { 0x02, 0x02, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-74 ∬	# DOUBLE INTEGRAL	[1983] */
{ 0x81E9, -2, 5, { 0x02, 0x02, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-75 ≢	# NOT IDENTICAL TO	[2000] */
{ 0x81EA, -2, 5, { 0x02, 0x02, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-76 ≃	# ASYMPTOTICALLY EQUAL TO	[2000] */
{ 0x81EB, -2, 5, { 0x02, 0x02, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-77 ≅	# APPROXIMATELY EQUAL TO	[2000] */
{ 0x81EC, -2, 5, { 0x02, 0x02, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-78 ≈	# ALMOST EQUAL TO	[2000] */
{ 0x81ED, -2, 5, { 0x02, 0x02, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-79 ≶	# LESS-THAN OR GREATER-THAN	[2000] */
{ 0x81EE, -2, 5, { 0x02, 0x02, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-80 ≷	# GREATER-THAN OR LESS-THAN	[2000] */
{ 0x81EF, -2, 5, { 0x02, 0x01, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-81 ↔	# LEFT RIGHT ARROW	[2000] */
{ 0x81F0, -1, 5, { 0x02, 0x01, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-82 Å	# ANGSTROM SIGN	[1983] */
{ 0x81F1, -1, 5, { 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-83 ‰	# PER MILLE SIGN	[1983] */
{ 0x81F2, -1, 5, { 0x02, 0x06, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-84 ♯	# MUSIC SHARP SIGN	[1983] */
{ 0x81F3, -1, 5, { 0x02, 0x06, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-85 ♭	# MUSIC FLAT SIGN	[1983] */
{ 0x81F4, -1, 5, { 0x02, 0x06, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-86 ♪	# EIGHTH NOTE	[1983] */
{ 0x81F5, -1, 5, { 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-87 †	# DAGGER	[1983] */
{ 0x81F6, -1, 5, { 0x02, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-88 ‡	# DOUBLE DAGGER	[1983] */
{ 0x81F7, -1, 4, { 0x00, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-89 ¶	# PILCROW SIGN	[1983] */
{ 0x81F8, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-90 ♮	# MUSIC NATURAL SIGN	[2000] */
{ 0x81F9, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-91 ♫	# BEAMED EIGHTH NOTES	[2000] */
{ 0x81FA, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-92 ♬	# BEAMED SIXTEENTH NOTES	[2000] */
{ 0x81FB, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-93 ♩	# QUARTER NOTE	[2000] */
{ 0x81FC, -1, 5, { 0x02, 0x05, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-02-94 ◯	# LARGE CIRCLE	[1983] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8240, -2, 5, { 0x02, 0x05, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-01 ▷	# WHITE RIGHT-POINTING TRIANGLE	[2000] */
{ 0x8241, -2, 5, { 0x02, 0x05, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-02 ▶	# BLACK RIGHT-POINTING TRIANGLE	[2000] */
{ 0x8242, -2, 5, { 0x02, 0x05, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-03 ◁	# WHITE LEFT-POINTING TRIANGLE	[2000] */
{ 0x8243, -2, 5, { 0x02, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-04 ◀	# BLACK LEFT-POINTING TRIANGLE	[2000] */
{ 0x8244, -2, 5, { 0x02, 0x01, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-05 ↗	# NORTH EAST ARROW	[2000] */
{ 0x8245, -2, 5, { 0x02, 0x01, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-06 ↘	# SOUTH EAST ARROW	[2000] */
{ 0x8246, -2, 5, { 0x02, 0x01, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-07 ↖	# NORTH WEST ARROW	[2000] */
{ 0x8247, -2, 5, { 0x02, 0x01, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-08 ↙	# SOUTH WEST ARROW	[2000] */
{ 0x8248, -2, 5, { 0x02, 0x01, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-09 ⇄	# RIGHTWARDS ARROW OVER LEFTWARDS ARROW	[2000] */
{ 0x8249, -2, 5, { 0x02, 0x01, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-10 ⇨	# RIGHTWARDS WHITE ARROW	[2000] */
{ 0x824A, -2, 5, { 0x02, 0x01, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-11 ⇦	# LEFTWARDS WHITE ARROW	[2000] */
{ 0x824B, -2, 5, { 0x02, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-12 ⇧	# UPWARDS WHITE ARROW	[2000] */
{ 0x824C, -2, 5, { 0x02, 0x01, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-13 ⇩	# DOWNWARDS WHITE ARROW	[2000] */
{ 0x824D, -2, 5, { 0x02, 0x09, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-14 ⤴	# ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS	[2000]	[Unicode3.2] */
{ 0x824E, -2, 5, { 0x02, 0x09, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-15 ⤵	# ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS	[2000]	[Unicode3.2] */
{ 0x824F, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-16 ０	# DIGIT ZERO	Halfwidth: U+0030	 */
{ 0x8250, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-17 １	# DIGIT ONE	Halfwidth: U+0031	 */
{ 0x8251, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-18 ２	# DIGIT TWO	Halfwidth: U+0032	 */
{ 0x8252, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-19 ３	# DIGIT THREE	Halfwidth: U+0033	 */
{ 0x8253, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-20 ４	# DIGIT FOUR	Halfwidth: U+034		 */
{ 0x8254, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-21 ５	# DIGIT FIVE	Halfwidth: U+0035	 */
{ 0x8255, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-22 ６	# DIGIT SIX	Halfwidth: U+0036	 */
{ 0x8256, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-23 ７	# DIGIT SEVEN	Halfwidth: U+0037	 */
{ 0x8257, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-24 ８	# DIGIT EIGHT	Halfwidth: U+0038	 */
{ 0x8258, -1, 5, { 0x0f, 0x0f, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-25 ９	# DIGIT NINE	Halfwidth: U+0039	 */
{ 0x8259, -2, 5, { 0x02, 0x09, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-26 ⦿	# CIRCLED BULLET	[2000]	[Unicode3.2] */
{ 0x825A, -2, 5, { 0x02, 0x05, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-27 ◉	# FISHEYE	[2000]	 */
{ 0x825B, -2, 5, { 0x03, 0x00, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-28 〽	# PART ALTERNATION MARK	[2000]	[Unicode3.2] */
{ 0x825C, -2, 5, { 0x0f, 0x0e, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-29 ﹆	# WHITE SESAME DOT	[2000]	[Unicode3.2] */
{ 0x825D, -2, 5, { 0x0f, 0x0e, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-30 ﹅	# SESAME DOT	[2000]	[Unicode3.2] */
{ 0x825E, -2, 5, { 0x02, 0x05, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-31 ◦	# WHITE BULLET	[2000]	 */
{ 0x825F, -2, 5, { 0x02, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-32 •	# BULLET	[2000]	 */
{ 0x8260, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-33 Ａ	# LATIN CAPITAL LETTER A	Halfwidth: U+0041	 */
{ 0x8261, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-34 Ｂ	# LATIN CAPITAL LETTER B	Halfwidth: U+0042	 */
{ 0x8262, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-35 Ｃ	# LATIN CAPITAL LETTER C	Halfwidth: U+0043	 */
{ 0x8263, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-36 Ｄ	# LATIN CAPITAL LETTER D	Halfwidth: U+0044	 */
{ 0x8264, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-37 Ｅ	# LATIN CAPITAL LETTER E	Halfwidth: U+0045	 */
{ 0x8265, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-38 Ｆ	# LATIN CAPITAL LETTER F	Halfwidth: U+0046	 */
{ 0x8266, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-39 Ｇ	# LATIN CAPITAL LETTER G	Halfwidth: U+0047	 */
{ 0x8267, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-40 Ｈ	# LATIN CAPITAL LETTER H	Halfwidth: U+0048	 */
{ 0x8268, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-41 Ｉ	# LATIN CAPITAL LETTER I	Halfwidth: U+0049	 */
{ 0x8269, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-42 Ｊ	# LATIN CAPITAL LETTER J	Halfwidth: U+004A	 */
{ 0x826A, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-43 Ｋ	# LATIN CAPITAL LETTER K	Halfwidth: U+004B	 */
{ 0x826B, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-44 Ｌ	# LATIN CAPITAL LETTER L	Halfwidth: U+004C	 */
{ 0x826C, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-45 Ｍ	# LATIN CAPITAL LETTER M	Halfwidth: U+004D	 */
{ 0x826D, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-46 Ｎ	# LATIN CAPITAL LETTER N	Halfwidth: U+004E */
{ 0x826E, -1, 5, { 0x0f, 0x0f, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-47 Ｏ	# LATIN CAPITAL LETTER O	Halfwidth: U+004F */
{ 0x826F, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-48 Ｐ	# LATIN CAPITAL LETTER P	Halfwidth: U+0050 */
{ 0x8270, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-49 Ｑ	# LATIN CAPITAL LETTER Q	Halfwidth: U+0051 */
{ 0x8271, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-50 Ｒ	# LATIN CAPITAL LETTER R	Halfwidth: U+0052 */
{ 0x8272, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-51 Ｓ	# LATIN CAPITAL LETTER S	Halfwidth: U+0053 */
{ 0x8273, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-52 Ｔ	# LATIN CAPITAL LETTER T	Halfwidth: U+0054 */
{ 0x8274, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-53 Ｕ	# LATIN CAPITAL LETTER U	Halfwidth: U+0055 */
{ 0x8275, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-54 Ｖ	# LATIN CAPITAL LETTER V	Halfwidth: U+0056 */
{ 0x8276, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-55 Ｗ	# LATIN CAPITAL LETTER W	Halfwidth: U+0057 */
{ 0x8277, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-56 Ｘ	# LATIN CAPITAL LETTER X	Halfwidth: U+0058 */
{ 0x8278, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-57 Ｙ	# LATIN CAPITAL LETTER Y	Halfwidth: U+0059 */
{ 0x8279, -1, 5, { 0x0f, 0x0f, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-58 Ｚ	# LATIN CAPITAL LETTER Z	Halfwidth: U+005A */
{ 0x827A, -2, 5, { 0x02, 0x02, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-59 ∓	# MINUS-OR-PLUS SIGN	[2000] */
{ 0x827B, -2, 5, { 0x02, 0x01, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-60 ℵ	# ALEF SYMBOL	[2000] */
{ 0x827C, -2, 5, { 0x02, 0x01, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-61 ℏ	# PLANCK CONSTANT OVER TWO PI	[2000] */
{ 0x827D, -2, 5, { 0x03, 0x03, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-62 ㏋	# SQUARE HP	[2000] */
{ 0x827E, -2, 5, { 0x02, 0x01, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-63 ℓ	# SCRIPT SMALL L	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8280, -2, 5, { 0x02, 0x01, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-64 ℧	# INVERTED OHM SIGN	[2000] */
{ 0x8281, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-65 ａ	# LATIN SMALL LETTER A	Halfwidth: U+0061 */
{ 0x8282, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-66 ｂ	# LATIN SMALL LETTER B	Halfwidth: U+0062 */
{ 0x8283, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-67 ｃ	# LATIN SMALL LETTER C	Halfwidth: U+0063 */
{ 0x8284, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-68 ｄ	# LATIN SMALL LETTER D	Halfwidth: U+0064 */
{ 0x8285, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-69 ｅ	# LATIN SMALL LETTER E	Halfwidth: U+0065 */
{ 0x8286, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-70 ｆ	# LATIN SMALL LETTER F	Halfwidth: U+0066 */
{ 0x8287, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-71 ｇ	# LATIN SMALL LETTER G	Halfwidth: U+0067 */
{ 0x8288, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-72 ｈ	# LATIN SMALL LETTER H	Halfwidth: U+0068 */
{ 0x8289, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-73 ｉ	# LATIN SMALL LETTER I	Halfwidth: U+0069 */
{ 0x828A, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-74 ｊ	# LATIN SMALL LETTER J	Halfwidth: U+006A */
{ 0x828B, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-75 ｋ	# LATIN SMALL LETTER K	Halfwidth: U+006B */
{ 0x828C, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-76 ｌ	# LATIN SMALL LETTER L	Halfwidth: U+006C */
{ 0x828D, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-77 ｍ	# LATIN SMALL LETTER M	Halfwidth: U+006D */
{ 0x828E, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-78 ｎ	# LATIN SMALL LETTER N	Halfwidth: U+006E	 */
{ 0x828F, -1, 5, { 0x0f, 0x0f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-79 ｏ	# LATIN SMALL LETTER O	Halfwidth: U+006F	 */
{ 0x8290, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-80 ｐ	# LATIN SMALL LETTER P	Halfwidth: U+0070	 */
{ 0x8291, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-81 ｑ	# LATIN SMALL LETTER Q	Halfwidth: U+0071	 */
{ 0x8292, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-82 ｒ	# LATIN SMALL LETTER R	Halfwidth: U+0072	 */
{ 0x8293, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-83 ｓ	# LATIN SMALL LETTER S	Halfwidth: U+0073	 */
{ 0x8294, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-84 ｔ	# LATIN SMALL LETTER T	Halfwidth: U+0074	 */
{ 0x8295, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-85 ｕ	# LATIN SMALL LETTER U	Halfwidth: U+0075	 */
{ 0x8296, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-86 ｖ	# LATIN SMALL LETTER V	Halfwidth: U+0076	 */
{ 0x8297, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-87 ｗ	# LATIN SMALL LETTER W	Halfwidth: U+0077	 */
{ 0x8298, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-88 ｘ	# LATIN SMALL LETTER X	Halfwidth: U+0078	 */
{ 0x8299, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-89 ｙ	# LATIN SMALL LETTER Y	Halfwidth: U+0079	 */
{ 0x829A, -1, 5, { 0x0f, 0x0f, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-90 ｚ	# LATIN SMALL LETTER Z	Halfwidth: U+007A	 */
{ 0x829B, -2, 5, { 0x03, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-91 ゠	# KATAKANA-HIRAGANA DOUBLE HYPHEN	[2000]	[Unicode3.2] */
{ 0x829C, -2, 5, { 0x02, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-92 –	# EN DASH	[2000]	 */
{ 0x829D, -2, 5, { 0x02, 0x09, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-93 ⧺	# DOUBLE PLUS	[2000]	[Unicode3.2] */
{ 0x829E, -2, 5, { 0x02, 0x09, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-03-94 ⧻	# TRIPLE PLUS	[2000]	[Unicode3.2] */
{ 0x829F, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-01 ぁ	# HIRAGANA LETTER SMALL A		 */
{ 0x82A0, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-02 あ	# HIRAGANA LETTER A		 */
{ 0x82A1, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-03 ぃ	# HIRAGANA LETTER SMALL I		 */
{ 0x82A2, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-04 い	# HIRAGANA LETTER I		 */
{ 0x82A3, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-05 ぅ	# HIRAGANA LETTER SMALL U		 */
{ 0x82A4, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-06 う	# HIRAGANA LETTER U		 */
{ 0x82A5, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-07 ぇ	# HIRAGANA LETTER SMALL E		 */
{ 0x82A6, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-08 え	# HIRAGANA LETTER E		 */
{ 0x82A7, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-09 ぉ	# HIRAGANA LETTER SMALL O		 */
{ 0x82A8, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-10 お	# HIRAGANA LETTER O		 */
{ 0x82A9, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-11 か	# HIRAGANA LETTER KA		 */
{ 0x82AA, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-12 が	# HIRAGANA LETTER GA		 */
{ 0x82AB, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-13 き	# HIRAGANA LETTER KI		 */
{ 0x82AC, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-14 ぎ	# HIRAGANA LETTER GI		 */
{ 0x82AD, -1, 5, { 0x03, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-15 く	# HIRAGANA LETTER KU		 */
{ 0x82AE, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-16 ぐ	# HIRAGANA LETTER GU */
{ 0x82AF, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-17 け	# HIRAGANA LETTER KE */
{ 0x82B0, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-18 げ	# HIRAGANA LETTER GE */
{ 0x82B1, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-19 こ	# HIRAGANA LETTER KO */
{ 0x82B2, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-20 ご	# HIRAGANA LETTER GO */
{ 0x82B3, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-21 さ	# HIRAGANA LETTER SA */
{ 0x82B4, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-22 ざ	# HIRAGANA LETTER ZA */
{ 0x82B5, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-23 し	# HIRAGANA LETTER SI */
{ 0x82B6, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-24 じ	# HIRAGANA LETTER ZI */
{ 0x82B7, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-25 す	# HIRAGANA LETTER SU */
{ 0x82B8, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-26 ず	# HIRAGANA LETTER ZU */
{ 0x82B9, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-27 せ	# HIRAGANA LETTER SE */
{ 0x82BA, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-28 ぜ	# HIRAGANA LETTER ZE */
{ 0x82BB, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-29 そ	# HIRAGANA LETTER SO */
{ 0x82BC, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-30 ぞ	# HIRAGANA LETTER ZO */
{ 0x82BD, -1, 5, { 0x03, 0x00, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-31 た	# HIRAGANA LETTER TA */
{ 0x82BE, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-32 だ	# HIRAGANA LETTER DA */
{ 0x82BF, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-33 ち	# HIRAGANA LETTER TI */
{ 0x82C0, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-34 ぢ	# HIRAGANA LETTER DI */
{ 0x82C1, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-35 っ	# HIRAGANA LETTER SMALL TU */
{ 0x82C2, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-36 つ	# HIRAGANA LETTER TU */
{ 0x82C3, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-37 づ	# HIRAGANA LETTER DU */
{ 0x82C4, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-38 て	# HIRAGANA LETTER TE */
{ 0x82C5, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-39 で	# HIRAGANA LETTER DE */
{ 0x82C6, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-40 と	# HIRAGANA LETTER TO */
{ 0x82C7, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-41 ど	# HIRAGANA LETTER DO */
{ 0x82C8, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-42 な	# HIRAGANA LETTER NA */
{ 0x82C9, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-43 に	# HIRAGANA LETTER NI */
{ 0x82CA, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-44 ぬ	# HIRAGANA LETTER NU */
{ 0x82CB, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-45 ね	# HIRAGANA LETTER NE */
{ 0x82CC, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-46 の	# HIRAGANA LETTER NO */
{ 0x82CD, -1, 5, { 0x03, 0x00, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-47 は	# HIRAGANA LETTER HA */
{ 0x82CE, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-48 ば	# HIRAGANA LETTER BA */
{ 0x82CF, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-49 ぱ	# HIRAGANA LETTER PA */
{ 0x82D0, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-50 ひ	# HIRAGANA LETTER HI */
{ 0x82D1, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-51 び	# HIRAGANA LETTER BI */
{ 0x82D2, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-52 ぴ	# HIRAGANA LETTER PI */
{ 0x82D3, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-53 ふ	# HIRAGANA LETTER HU */
{ 0x82D4, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-54 ぶ	# HIRAGANA LETTER BU */
{ 0x82D5, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-55 ぷ	# HIRAGANA LETTER PU */
{ 0x82D6, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-56 へ	# HIRAGANA LETTER HE */
{ 0x82D7, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-57 べ	# HIRAGANA LETTER BE */
{ 0x82D8, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-58 ぺ	# HIRAGANA LETTER PE */
{ 0x82D9, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-59 ほ	# HIRAGANA LETTER HO */
{ 0x82DA, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-60 ぼ	# HIRAGANA LETTER BO */
{ 0x82DB, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-61 ぽ	# HIRAGANA LETTER PO */
{ 0x82DC, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-62 ま	# HIRAGANA LETTER MA */
{ 0x82DD, -1, 5, { 0x03, 0x00, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-63 み	# HIRAGANA LETTER MI */
{ 0x82DE, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-64 む	# HIRAGANA LETTER MU */
{ 0x82DF, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-65 め	# HIRAGANA LETTER ME */
{ 0x82E0, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-66 も	# HIRAGANA LETTER MO */
{ 0x82E1, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-67 ゃ	# HIRAGANA LETTER SMALL YA */
{ 0x82E2, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-68 や	# HIRAGANA LETTER YA */
{ 0x82E3, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-69 ゅ	# HIRAGANA LETTER SMALL YU */
{ 0x82E4, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-70 ゆ	# HIRAGANA LETTER YU */
{ 0x82E5, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-71 ょ	# HIRAGANA LETTER SMALL YO */
{ 0x82E6, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-72 よ	# HIRAGANA LETTER YO */
{ 0x82E7, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-73 ら	# HIRAGANA LETTER RA */
{ 0x82E8, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-74 り	# HIRAGANA LETTER RI */
{ 0x82E9, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-75 る	# HIRAGANA LETTER RU */
{ 0x82EA, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-76 れ	# HIRAGANA LETTER RE */
{ 0x82EB, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-77 ろ	# HIRAGANA LETTER RO */
{ 0x82EC, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-78 ゎ	# HIRAGANA LETTER SMALL WA */
{ 0x82ED, -1, 5, { 0x03, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-79 わ	# HIRAGANA LETTER WA */
{ 0x82EE, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-80 ゐ	# HIRAGANA LETTER WI		 */
{ 0x82EF, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-81 ゑ	# HIRAGANA LETTER WE		 */
{ 0x82F0, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-82 を	# HIRAGANA LETTER WO		 */
{ 0x82F1, -1, 5, { 0x03, 0x00, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-83 ん	# HIRAGANA LETTER N		 */
{ 0x82F2, -2, 5, { 0x03, 0x00, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-84 ゔ	# HIRAGANA LETTER VU	[2000]	 */
{ 0x82F3, -2, 5, { 0x03, 0x00, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-85 ゕ	# HIRAGANA LETTER SMALL KA	[2000]	[Unicode3.2] */
{ 0x82F4, -2, 5, { 0x03, 0x00, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-04-86 ゖ	# HIRAGANA LETTER SMALL KE	[2000]	[Unicode3.2] */
{ 0x82F5, -2, 10, { 0x03, 0x00, 0x01, 0x00, 0x0b, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-04-87 か゚	# 	[2000]	 */
{ 0x82F6, -2, 10, { 0x03, 0x00, 0x01, 0x00, 0x0d, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-04-88 き゚	# 	[2000]	 */
{ 0x82F7, -2, 10, { 0x03, 0x00, 0x01, 0x00, 0x0f, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-04-89 く゚	# 	[2000]	 */
{ 0x82F8, -2, 10, { 0x03, 0x00, 0x01, 0x01, 0x01, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-04-90 け゚	# 	[2000]	 */
{ 0x82F9, -2, 10, { 0x03, 0x00, 0x01, 0x01, 0x03, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-04-91 こ゚	# 	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8340, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-01 ァ	# KATAKANA LETTER SMALL A		 */
{ 0x8341, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-02 ア	# KATAKANA LETTER A */
{ 0x8342, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-03 ィ	# KATAKANA LETTER SMALL I */
{ 0x8343, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-04 イ	# KATAKANA LETTER I */
{ 0x8344, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-05 ゥ	# KATAKANA LETTER SMALL U */
{ 0x8345, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-06 ウ	# KATAKANA LETTER U */
{ 0x8346, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-07 ェ	# KATAKANA LETTER SMALL E */
{ 0x8347, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-08 エ	# KATAKANA LETTER E */
{ 0x8348, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-09 ォ	# KATAKANA LETTER SMALL O */
{ 0x8349, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-10 オ	# KATAKANA LETTER O */
{ 0x834A, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-11 カ	# KATAKANA LETTER KA */
{ 0x834B, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-12 ガ	# KATAKANA LETTER GA */
{ 0x834C, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-13 キ	# KATAKANA LETTER KI */
{ 0x834D, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-14 ギ	# KATAKANA LETTER GI */
{ 0x834E, -1, 5, { 0x03, 0x00, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-15 ク	# KATAKANA LETTER KU */
{ 0x834F, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-16 グ	# KATAKANA LETTER GU */
{ 0x8350, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-17 ケ	# KATAKANA LETTER KE */
{ 0x8351, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-18 ゲ	# KATAKANA LETTER GE */
{ 0x8352, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-19 コ	# KATAKANA LETTER KO */
{ 0x8353, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-20 ゴ	# KATAKANA LETTER GO */
{ 0x8354, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-21 サ	# KATAKANA LETTER SA */
{ 0x8355, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-22 ザ	# KATAKANA LETTER ZA */
{ 0x8356, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-23 シ	# KATAKANA LETTER SI */
{ 0x8357, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-24 ジ	# KATAKANA LETTER ZI */
{ 0x8358, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-25 ス	# KATAKANA LETTER SU */
{ 0x8359, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-26 ズ	# KATAKANA LETTER ZU */
{ 0x835A, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-27 セ	# KATAKANA LETTER SE */
{ 0x835B, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-28 ゼ	# KATAKANA LETTER ZE */
{ 0x835C, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-29 ソ	# KATAKANA LETTER SO */
{ 0x835D, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-30 ゾ	# KATAKANA LETTER ZO */
{ 0x835E, -1, 5, { 0x03, 0x00, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-31 タ	# KATAKANA LETTER TA */
{ 0x835F, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-32 ダ	# KATAKANA LETTER DA */
{ 0x8360, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-33 チ	# KATAKANA LETTER TI */
{ 0x8361, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-34 ヂ	# KATAKANA LETTER DI */
{ 0x8362, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-35 ッ	# KATAKANA LETTER SMALL TU */
{ 0x8363, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-36 ツ	# KATAKANA LETTER TU */
{ 0x8364, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-37 ヅ	# KATAKANA LETTER DU */
{ 0x8365, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-38 テ	# KATAKANA LETTER TE */
{ 0x8366, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-39 デ	# KATAKANA LETTER DE */
{ 0x8367, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-40 ト	# KATAKANA LETTER TO */
{ 0x8368, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-41 ド	# KATAKANA LETTER DO */
{ 0x8369, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-42 ナ	# KATAKANA LETTER NA */
{ 0x836A, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-43 ニ	# KATAKANA LETTER NI */
{ 0x836B, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-44 ヌ	# KATAKANA LETTER NU */
{ 0x836C, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-45 ネ	# KATAKANA LETTER NE */
{ 0x836D, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-46 ノ	# KATAKANA LETTER NO */
{ 0x836E, -1, 5, { 0x03, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-47 ハ	# KATAKANA LETTER HA */
{ 0x836F, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-48 バ	# KATAKANA LETTER BA */
{ 0x8370, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-49 パ	# KATAKANA LETTER PA */
{ 0x8371, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-50 ヒ	# KATAKANA LETTER HI */
{ 0x8372, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-51 ビ	# KATAKANA LETTER BI */
{ 0x8373, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-52 ピ	# KATAKANA LETTER PI */
{ 0x8374, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-53 フ	# KATAKANA LETTER HU */
{ 0x8375, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-54 ブ	# KATAKANA LETTER BU */
{ 0x8376, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-55 プ	# KATAKANA LETTER PU */
{ 0x8377, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-56 ヘ	# KATAKANA LETTER HE */
{ 0x8378, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-57 ベ	# KATAKANA LETTER BE */
{ 0x8379, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-58 ペ	# KATAKANA LETTER PE */
{ 0x837A, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-59 ホ	# KATAKANA LETTER HO */
{ 0x837B, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-60 ボ	# KATAKANA LETTER BO */
{ 0x837C, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-61 ポ	# KATAKANA LETTER PO */
{ 0x837D, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-62 マ	# KATAKANA LETTER MA */
{ 0x837E, -1, 5, { 0x03, 0x00, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-63 ミ	# KATAKANA LETTER MI */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8380, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-64 ム	# KATAKANA LETTER MU */
{ 0x8381, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-65 メ	# KATAKANA LETTER ME */
{ 0x8382, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-66 モ	# KATAKANA LETTER MO */
{ 0x8383, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-67 ャ	# KATAKANA LETTER SMALL YA */
{ 0x8384, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-68 ヤ	# KATAKANA LETTER YA */
{ 0x8385, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-69 ュ	# KATAKANA LETTER SMALL YU */
{ 0x8386, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-70 ユ	# KATAKANA LETTER YU */
{ 0x8387, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-71 ョ	# KATAKANA LETTER SMALL YO */
{ 0x8388, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-72 ヨ	# KATAKANA LETTER YO */
{ 0x8389, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-73 ラ	# KATAKANA LETTER RA */
{ 0x838A, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-74 リ	# KATAKANA LETTER RI */
{ 0x838B, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-75 ル	# KATAKANA LETTER RU */
{ 0x838C, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-76 レ	# KATAKANA LETTER RE */
{ 0x838D, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-77 ロ	# KATAKANA LETTER RO */
{ 0x838E, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-78 ヮ	# KATAKANA LETTER SMALL WA */
{ 0x838F, -1, 5, { 0x03, 0x00, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-79 ワ	# KATAKANA LETTER WA */
{ 0x8390, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-80 ヰ	# KATAKANA LETTER WI */
{ 0x8391, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-81 ヱ	# KATAKANA LETTER WE */
{ 0x8392, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-82 ヲ	# KATAKANA LETTER WO	 */
{ 0x8393, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-83 ン	# KATAKANA LETTER N	 */
{ 0x8394, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-84 ヴ	# KATAKANA LETTER VU	 */
{ 0x8395, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-85 ヵ	# KATAKANA LETTER SMALL KA	 */
{ 0x8396, -1, 5, { 0x03, 0x00, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-05-86 ヶ	# KATAKANA LETTER SMALL KE	 */
{ 0x8397, -2, 10, { 0x03, 0x00, 0x02, 0x02, 0x0b, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-87 カ゚	# 	[2000] */
{ 0x8398, -2, 10, { 0x03, 0x00, 0x02, 0x02, 0x0d, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-88 キ゚	# 	[2000] */
{ 0x8399, -2, 10, { 0x03, 0x00, 0x02, 0x02, 0x0f, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-89 ク゚	# 	[2000] */
{ 0x839A, -2, 10, { 0x03, 0x00, 0x02, 0x03, 0x01, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-90 ケ゚	# 	[2000] */
{ 0x839B, -2, 10, { 0x03, 0x00, 0x02, 0x03, 0x03, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-91 コ゚	# 	[2000] */
{ 0x839C, -2, 10, { 0x03, 0x00, 0x02, 0x03, 0x0b, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-92 セ゚	# 	[2000] */
{ 0x839D, -2, 10, { 0x03, 0x00, 0x03, 0x00, 0x04, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-93 ツ゚	# 	[2000] */
{ 0x839E, -2, 10, { 0x03, 0x00, 0x03, 0x00, 0x08, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-05-94 ト゚	# 	[2000] */
{ 0x839F, -1, 4, { 0x03, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-01 Α	# GREEK CAPITAL LETTER ALPHA	 */
{ 0x83A0, -1, 4, { 0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-02 Β	# GREEK CAPITAL LETTER BETA	 */
{ 0x83A1, -1, 4, { 0x03, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-03 Γ	# GREEK CAPITAL LETTER GAMMA	 */
{ 0x83A2, -1, 4, { 0x03, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-04 Δ	# GREEK CAPITAL LETTER DELTA */
{ 0x83A3, -1, 4, { 0x03, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-05 Ε	# GREEK CAPITAL LETTER EPSILON */
{ 0x83A4, -1, 4, { 0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-06 Ζ	# GREEK CAPITAL LETTER ZETA */
{ 0x83A5, -1, 4, { 0x03, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-07 Η	# GREEK CAPITAL LETTER ETA */
{ 0x83A6, -1, 4, { 0x03, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-08 Θ	# GREEK CAPITAL LETTER THETA */
{ 0x83A7, -1, 4, { 0x03, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-09 Ι	# GREEK CAPITAL LETTER IOTA */
{ 0x83A8, -1, 4, { 0x03, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-10 Κ	# GREEK CAPITAL LETTER KAPPA */
{ 0x83A9, -1, 4, { 0x03, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-11 Λ	# GREEK CAPITAL LETTER LAMDA */
{ 0x83AA, -1, 4, { 0x03, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-12 Μ	# GREEK CAPITAL LETTER MU */
{ 0x83AB, -1, 4, { 0x03, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-13 Ν	# GREEK CAPITAL LETTER NU */
{ 0x83AC, -1, 4, { 0x03, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-14 Ξ	# GREEK CAPITAL LETTER XI */
{ 0x83AD, -1, 4, { 0x03, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-15 Ο	# GREEK CAPITAL LETTER OMICRON */
{ 0x83AE, -1, 4, { 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-16 Π	# GREEK CAPITAL LETTER PI */
{ 0x83AF, -1, 4, { 0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-17 Ρ	# GREEK CAPITAL LETTER RHO */
{ 0x83B0, -1, 4, { 0x03, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-18 Σ	# GREEK CAPITAL LETTER SIGMA */
{ 0x83B1, -1, 4, { 0x03, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-19 Τ	# GREEK CAPITAL LETTER TAU */
{ 0x83B2, -1, 4, { 0x03, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-20 Υ	# GREEK CAPITAL LETTER UPSILON	 */
{ 0x83B3, -1, 4, { 0x03, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-21 Φ	# GREEK CAPITAL LETTER PHI	 */
{ 0x83B4, -1, 4, { 0x03, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-22 Χ	# GREEK CAPITAL LETTER CHI	 */
{ 0x83B5, -1, 4, { 0x03, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-23 Ψ	# GREEK CAPITAL LETTER PSI	 */
{ 0x83B6, -1, 4, { 0x03, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-24 Ω	# GREEK CAPITAL LETTER OMEGA	 */
{ 0x83B7, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-25 ♤	# WHITE SPADE SUIT	[2000] */
{ 0x83B8, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-26 ♠	# BLACK SPADE SUIT	[2000] */
{ 0x83B9, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-27 ♢	# WHITE DIAMOND SUIT	[2000] */
{ 0x83BA, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-28 ♦	# BLACK DIAMOND SUIT	[2000] */
{ 0x83BB, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-29 ♡	# WHITE HEART SUIT	[2000] */
{ 0x83BC, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-30 ♥	# BLACK HEART SUIT	[2000] */
{ 0x83BD, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-31 ♧	# WHITE CLUB SUIT	[2000] */
{ 0x83BE, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-32 ♣	# BLACK CLUB SUIT	[2000] */
{ 0x83BF, -1, 4, { 0x03, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-33 α	# GREEK SMALL LETTER ALPHA	 */
{ 0x83C0, -1, 4, { 0x03, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-34 β	# GREEK SMALL LETTER BETA	 */
{ 0x83C1, -1, 4, { 0x03, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-35 γ	# GREEK SMALL LETTER GAMMA	 */
{ 0x83C2, -1, 4, { 0x03, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-36 δ	# GREEK SMALL LETTER DELTA */
{ 0x83C3, -1, 4, { 0x03, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-37 ε	# GREEK SMALL LETTER EPSILON */
{ 0x83C4, -1, 4, { 0x03, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-38 ζ	# GREEK SMALL LETTER ZETA */
{ 0x83C5, -1, 4, { 0x03, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-39 η	# GREEK SMALL LETTER ETA */
{ 0x83C6, -1, 4, { 0x03, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-40 θ	# GREEK SMALL LETTER THETA */
{ 0x83C7, -1, 4, { 0x03, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-41 ι	# GREEK SMALL LETTER IOTA */
{ 0x83C8, -1, 4, { 0x03, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-42 κ	# GREEK SMALL LETTER KAPPA */
{ 0x83C9, -1, 4, { 0x03, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-43 λ	# GREEK SMALL LETTER LAMDA */
{ 0x83CA, -1, 4, { 0x03, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-44 μ	# GREEK SMALL LETTER MU */
{ 0x83CB, -1, 4, { 0x03, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-45 ν	# GREEK SMALL LETTER NU */
{ 0x83CC, -1, 4, { 0x03, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-46 ξ	# GREEK SMALL LETTER XI */
{ 0x83CD, -1, 4, { 0x03, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-47 ο	# GREEK SMALL LETTER OMICRON */
{ 0x83CE, -1, 4, { 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-48 π	# GREEK SMALL LETTER PI */
{ 0x83CF, -1, 4, { 0x03, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-49 ρ	# GREEK SMALL LETTER RHO */
{ 0x83D0, -1, 4, { 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-50 σ	# GREEK SMALL LETTER SIGMA */
{ 0x83D1, -1, 4, { 0x03, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-51 τ	# GREEK SMALL LETTER TAU */
{ 0x83D2, -1, 4, { 0x03, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-52 υ	# GREEK SMALL LETTER UPSILON		 */
{ 0x83D3, -1, 4, { 0x03, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-53 φ	# GREEK SMALL LETTER PHI		 */
{ 0x83D4, -1, 4, { 0x03, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-54 χ	# GREEK SMALL LETTER CHI		 */
{ 0x83D5, -1, 4, { 0x03, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-55 ψ	# GREEK SMALL LETTER PSI		 */
{ 0x83D6, -1, 4, { 0x03, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-56 ω	# GREEK SMALL LETTER OMEGA		 */
{ 0x83D7, -2, 4, { 0x03, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-57 ς	# GREEK SMALL LETTER FINAL SIGMA	[2000]	 */
{ 0x83D8, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-58 ⓵	# DOUBLE CIRCLED DIGIT ONE	[2000]	[Unicode3.2] */
{ 0x83D9, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-59 ⓶	# DOUBLE CIRCLED DIGIT TWO	[2000]	[Unicode3.2] */
{ 0x83DA, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-60 ⓷	# DOUBLE CIRCLED DIGIT THREE	[2000]	[Unicode3.2] */
{ 0x83DB, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-61 ⓸	# DOUBLE CIRCLED DIGIT FOUR	[2000]	[Unicode3.2] */
{ 0x83DC, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-62 ⓹	# DOUBLE CIRCLED DIGIT FIVE	[2000]	[Unicode3.2] */
{ 0x83DD, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-63 ⓺	# DOUBLE CIRCLED DIGIT SIX	[2000]	[Unicode3.2] */
{ 0x83DE, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-64 ⓻	# DOUBLE CIRCLED DIGIT SEVEN	[2000]	[Unicode3.2] */
{ 0x83DF, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-65 ⓼	# DOUBLE CIRCLED DIGIT EIGHT	[2000]	[Unicode3.2] */
{ 0x83E0, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-66 ⓽	# DOUBLE CIRCLED DIGIT NINE	[2000]	[Unicode3.2] */
{ 0x83E1, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-67 ⓾	# DOUBLE CIRCLED NUMBER TEN	[2000]	[Unicode3.2] */
{ 0x83E2, -2, 5, { 0x02, 0x06, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-68 ☖	# WHITE SHOGI PIECE	[2000]	[Unicode3.2] */
{ 0x83E3, -2, 5, { 0x02, 0x06, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-69 ☗	# BLACK SHOGI PIECE	[2000]	[Unicode3.2] */
{ 0x83E4, -2, 5, { 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-70 〠	# POSTAL MARK FACE	[2000]	 */
{ 0x83E5, -2, 5, { 0x02, 0x06, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-71 ☎	# BLACK TELEPHONE	[2000]	 */
{ 0x83E6, -2, 5, { 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-72 ☀	# BLACK SUN WITH RAYS	[2000]	 */
{ 0x83E7, -2, 5, { 0x02, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-73 ☁	# CLOUD	[2000]	 */
{ 0x83E8, -2, 5, { 0x02, 0x06, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-74 ☂	# UMBRELLA	[2000]	 */
{ 0x83E9, -2, 5, { 0x02, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-75 ☃	# SNOWMAN	[2000]	 */
{ 0x83EA, -2, 5, { 0x02, 0x06, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-76 ♨	# HOT SPRINGS	[2000]	 */
{ 0x83EB, -2, 5, { 0x02, 0x05, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-77 ▱	# WHITE PARALLELOGRAM	[2000]	 */
{ 0x83EC, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-78 ㇰ	# KATAKANA LETTER SMALL KU	[2000]	[Unicode3.2] */
{ 0x83ED, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-79 ㇱ	# KATAKANA LETTER SMALL SI	[2000]	[Unicode3.2] */
{ 0x83EE, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-80 ㇲ	# KATAKANA LETTER SMALL SU	[2000]	[Unicode3.2] */
{ 0x83EF, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-81 ㇳ	# KATAKANA LETTER SMALL TO	[2000]	[Unicode3.2] */
{ 0x83F0, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-82 ㇴ	# KATAKANA LETTER SMALL NU	[2000]	[Unicode3.2] */
{ 0x83F1, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-83 ㇵ	# KATAKANA LETTER SMALL HA	[2000]	[Unicode3.2] */
{ 0x83F2, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-84 ㇶ	# KATAKANA LETTER SMALL HI	[2000]	[Unicode3.2] */
{ 0x83F3, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-85 ㇷ	# KATAKANA LETTER SMALL HU	[2000]	[Unicode3.2] */
{ 0x83F4, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-86 ㇸ	# KATAKANA LETTER SMALL HE	[2000]	[Unicode3.2] */
{ 0x83F5, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-87 ㇹ	# KATAKANA LETTER SMALL HO	[2000]	[Unicode3.2] */
{ 0x83F6, -2, 10, { 0x03, 0x01, 0x03, 0x03, 0x07, 0x03, 0x00, 0x02, 0x01, 0x0a }	},	/* 1-06-88 ㇷ゚	# 	[2000]	 */
{ 0x83F7, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-89 ㇺ	# KATAKANA LETTER SMALL MU	[2000]	[Unicode3.2] */
{ 0x83F8, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-90 ㇻ	# KATAKANA LETTER SMALL RA	[2000]	[Unicode3.2] */
{ 0x83F9, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-91 ㇼ	# KATAKANA LETTER SMALL RI	[2000]	[Unicode3.2] */
{ 0x83FA, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-92 ㇽ	# KATAKANA LETTER SMALL RU	[2000]	[Unicode3.2] */
{ 0x83FB, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-93 ㇾ	# KATAKANA LETTER SMALL RE	[2000]	[Unicode3.2] */
{ 0x83FC, -2, 5, { 0x03, 0x01, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-06-94 ㇿ	# KATAKANA LETTER SMALL RO	[2000]	[Unicode3.2] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8440, -1, 4, { 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-01 А	# CYRILLIC CAPITAL LETTER A		 */
{ 0x8441, -1, 4, { 0x04, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-02 Б	# CYRILLIC CAPITAL LETTER BE		 */
{ 0x8442, -1, 4, { 0x04, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-03 В	# CYRILLIC CAPITAL LETTER VE		 */
{ 0x8443, -1, 4, { 0x04, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-04 Г	# CYRILLIC CAPITAL LETTER GHE		 */
{ 0x8444, -1, 4, { 0x04, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-05 Д	# CYRILLIC CAPITAL LETTER DE		 */
{ 0x8445, -1, 4, { 0x04, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-06 Е	# CYRILLIC CAPITAL LETTER IE */
{ 0x8446, -1, 4, { 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-07 Ё	# CYRILLIC CAPITAL LETTER IO */
{ 0x8447, -1, 4, { 0x04, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-08 Ж	# CYRILLIC CAPITAL LETTER ZHE */
{ 0x8448, -1, 4, { 0x04, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-09 З	# CYRILLIC CAPITAL LETTER ZE */
{ 0x8449, -1, 4, { 0x04, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-10 И	# CYRILLIC CAPITAL LETTER I */
{ 0x844A, -1, 4, { 0x04, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-11 Й	# CYRILLIC CAPITAL LETTER SHORT I */
{ 0x844B, -1, 4, { 0x04, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-12 К	# CYRILLIC CAPITAL LETTER KA */
{ 0x844C, -1, 4, { 0x04, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-13 Л	# CYRILLIC CAPITAL LETTER EL */
{ 0x844D, -1, 4, { 0x04, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-14 М	# CYRILLIC CAPITAL LETTER EM */
{ 0x844E, -1, 4, { 0x04, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-15 Н	# CYRILLIC CAPITAL LETTER EN */
{ 0x844F, -1, 4, { 0x04, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-16 О	# CYRILLIC CAPITAL LETTER O */
{ 0x8450, -1, 4, { 0x04, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-17 П	# CYRILLIC CAPITAL LETTER PE */
{ 0x8451, -1, 4, { 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-18 Р	# CYRILLIC CAPITAL LETTER ER */
{ 0x8452, -1, 4, { 0x04, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-19 С	# CYRILLIC CAPITAL LETTER ES */
{ 0x8453, -1, 4, { 0x04, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-20 Т	# CYRILLIC CAPITAL LETTER TE */
{ 0x8454, -1, 4, { 0x04, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-21 У	# CYRILLIC CAPITAL LETTER U */
{ 0x8455, -1, 4, { 0x04, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-22 Ф	# CYRILLIC CAPITAL LETTER EF		 */
{ 0x8456, -1, 4, { 0x04, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-23 Х	# CYRILLIC CAPITAL LETTER HA		 */
{ 0x8457, -1, 4, { 0x04, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-24 Ц	# CYRILLIC CAPITAL LETTER TSE		 */
{ 0x8458, -1, 4, { 0x04, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-25 Ч	# CYRILLIC CAPITAL LETTER CHE		 */
{ 0x8459, -1, 4, { 0x04, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-26 Ш	# CYRILLIC CAPITAL LETTER SHA		 */
{ 0x845A, -1, 4, { 0x04, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-27 Щ	# CYRILLIC CAPITAL LETTER SHCHA		 */
{ 0x845B, -1, 4, { 0x04, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-28 Ъ	# CYRILLIC CAPITAL LETTER HARD SIGN		 */
{ 0x845C, -1, 4, { 0x04, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-29 Ы	# CYRILLIC CAPITAL LETTER YERU		 */
{ 0x845D, -1, 4, { 0x04, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-30 Ь	# CYRILLIC CAPITAL LETTER SOFT SIGN		 */
{ 0x845E, -1, 4, { 0x04, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-31 Э	# CYRILLIC CAPITAL LETTER E		 */
{ 0x845F, -1, 4, { 0x04, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-32 Ю	# CYRILLIC CAPITAL LETTER YU		 */
{ 0x8460, -1, 4, { 0x04, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-33 Я	# CYRILLIC CAPITAL LETTER YA		 */
{ 0x8461, -2, 5, { 0x02, 0x03, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-34 ⎾	# DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT	[2000]	[Unicode3.2] */
{ 0x8462, -2, 5, { 0x02, 0x03, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-35 ⎿	# DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT	[2000]	[Unicode3.2] */
{ 0x8463, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-36 ⏀	# DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE	[2000]	[Unicode3.2] */
{ 0x8464, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-37 ⏁	# DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE	[2000]	[Unicode3.2] */
{ 0x8465, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-38 ⏂	# DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE	[2000]	[Unicode3.2] */
{ 0x8466, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-39 ⏃	# DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE	[2000]	[Unicode3.2] */
{ 0x8467, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-40 ⏄	# DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE	[2000]	[Unicode3.2] */
{ 0x8468, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-41 ⏅	# DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE	[2000]	[Unicode3.2] */
{ 0x8469, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-42 ⏆	# DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE	[2000]	[Unicode3.2] */
{ 0x846A, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-43 ⏇	# DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE	[2000]	[Unicode3.2] */
{ 0x846B, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-44 ⏈	# DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE	[2000]	[Unicode3.2] */
{ 0x846C, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-45 ⏉	# DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL	[2000]	[Unicode3.2] */
{ 0x846D, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-46 ⏊	# DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL	[2000]	[Unicode3.2] */
{ 0x846E, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-47 ⏋	# DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT	[2000]	[Unicode3.2] */
{ 0x846F, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-48 ⏌	# DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT	[2000]	[Unicode3.2] */
{ 0x8470, -1, 4, { 0x04, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-49 а	# CYRILLIC SMALL LETTER A		 */
{ 0x8471, -1, 4, { 0x04, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-50 б	# CYRILLIC SMALL LETTER BE		 */
{ 0x8472, -1, 4, { 0x04, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-51 в	# CYRILLIC SMALL LETTER VE		 */
{ 0x8473, -1, 4, { 0x04, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-52 г	# CYRILLIC SMALL LETTER GHE		 */
{ 0x8474, -1, 4, { 0x04, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-53 д	# CYRILLIC SMALL LETTER DE		 */
{ 0x8475, -1, 4, { 0x04, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-54 е	# CYRILLIC SMALL LETTER IE */
{ 0x8476, -1, 4, { 0x04, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-55 ё	# CYRILLIC SMALL LETTER IO */
{ 0x8477, -1, 4, { 0x04, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-56 ж	# CYRILLIC SMALL LETTER ZHE */
{ 0x8478, -1, 4, { 0x04, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-57 з	# CYRILLIC SMALL LETTER ZE */
{ 0x8479, -1, 4, { 0x04, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-58 и	# CYRILLIC SMALL LETTER I */
{ 0x847A, -1, 4, { 0x04, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-59 й	# CYRILLIC SMALL LETTER SHORT I */
{ 0x847B, -1, 4, { 0x04, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-60 к	# CYRILLIC SMALL LETTER KA */
{ 0x847C, -1, 4, { 0x04, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-61 л	# CYRILLIC SMALL LETTER EL */
{ 0x847D, -1, 4, { 0x04, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-62 м	# CYRILLIC SMALL LETTER EM */
{ 0x847E, -1, 4, { 0x04, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-63 н	# CYRILLIC SMALL LETTER EN */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8480, -1, 4, { 0x04, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-64 о	# CYRILLIC SMALL LETTER O */
{ 0x8481, -1, 4, { 0x04, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-65 п	# CYRILLIC SMALL LETTER PE */
{ 0x8482, -1, 4, { 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-66 р	# CYRILLIC SMALL LETTER ER */
{ 0x8483, -1, 4, { 0x04, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-67 с	# CYRILLIC SMALL LETTER ES */
{ 0x8484, -1, 4, { 0x04, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-68 т	# CYRILLIC SMALL LETTER TE */
{ 0x8485, -1, 4, { 0x04, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-69 у	# CYRILLIC SMALL LETTER U */
{ 0x8486, -1, 4, { 0x04, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-70 ф	# CYRILLIC SMALL LETTER EF	 */
{ 0x8487, -1, 4, { 0x04, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-71 х	# CYRILLIC SMALL LETTER HA	 */
{ 0x8488, -1, 4, { 0x04, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-72 ц	# CYRILLIC SMALL LETTER TSE	 */
{ 0x8489, -1, 4, { 0x04, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-73 ч	# CYRILLIC SMALL LETTER CHE	 */
{ 0x848A, -1, 4, { 0x04, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-74 ш	# CYRILLIC SMALL LETTER SHA	 */
{ 0x848B, -1, 4, { 0x04, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-75 щ	# CYRILLIC SMALL LETTER SHCHA	 */
{ 0x848C, -1, 4, { 0x04, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-76 ъ	# CYRILLIC SMALL LETTER HARD SIGN	 */
{ 0x848D, -1, 4, { 0x04, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-77 ы	# CYRILLIC SMALL LETTER YERU	 */
{ 0x848E, -1, 4, { 0x04, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-78 ь	# CYRILLIC SMALL LETTER SOFT SIGN	 */
{ 0x848F, -1, 4, { 0x04, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-79 э	# CYRILLIC SMALL LETTER E	 */
{ 0x8490, -1, 4, { 0x04, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-80 ю	# CYRILLIC SMALL LETTER YU	 */
{ 0x8491, -1, 4, { 0x04, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-81 я	# CYRILLIC SMALL LETTER YA	 */
{ 0x8492, -2, 5, { 0x03, 0x00, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-82 ヷ	# KATAKANA LETTER VA	[2000] */
{ 0x8493, -2, 5, { 0x03, 0x00, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-83 ヸ	# KATAKANA LETTER VI	[2000] */
{ 0x8494, -2, 5, { 0x03, 0x00, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-84 ヹ	# KATAKANA LETTER VE	[2000] */
{ 0x8495, -2, 5, { 0x03, 0x00, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-85 ヺ	# KATAKANA LETTER VO	[2000] */
{ 0x8496, -2, 5, { 0x02, 0x02, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-86 ⋚	# LESS-THAN EQUAL TO OR GREATER-THAN	[2000]	 */
{ 0x8497, -2, 5, { 0x02, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-87 ⋛	# GREATER-THAN EQUAL TO OR LESS-THAN	[2000]	 */
{ 0x8498, -2, 5, { 0x02, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-88 ⅓	# VULGAR FRACTION ONE THIRD	[2000]	 */
{ 0x8499, -2, 5, { 0x02, 0x01, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-89 ⅔	# VULGAR FRACTION TWO THIRDS	[2000]	 */
{ 0x849A, -2, 5, { 0x02, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-90 ⅕	# VULGAR FRACTION ONE FIFTH	[2000]	 */
{ 0x849B, -2, 5, { 0x02, 0x07, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-91 ✓	# CHECK MARK	[2000]	 */
{ 0x849C, -2, 5, { 0x02, 0x03, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-92 ⌘	# PLACE OF INTEREST SIGN	[2000]	 */
{ 0x849D, -2, 5, { 0x02, 0x04, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-93 ␣	# OPEN BOX	[2000]	 */
{ 0x849E, -2, 5, { 0x02, 0x03, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-07-94 ⏎	# RETURN SYMBOL	[2000]	[Unicode3.2] */
{ 0x849F, -1, 5, { 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-01 ─	# BOX DRAWINGS LIGHT HORIZONTAL	[1983]	 */
{ 0x84A0, -1, 5, { 0x02, 0x05, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-02 │	# BOX DRAWINGS LIGHT VERTICAL	[1983]	 */
{ 0x84A1, -1, 5, { 0x02, 0x05, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-03 ┌	# BOX DRAWINGS LIGHT DOWN AND RIGHT	[1983]	 */
{ 0x84A2, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-04 ┐	# BOX DRAWINGS LIGHT DOWN AND LEFT	[1983]	 */
{ 0x84A3, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-05 ┘	# BOX DRAWINGS LIGHT UP AND LEFT	[1983]	 */
{ 0x84A4, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-06 └	# BOX DRAWINGS LIGHT UP AND RIGHT	[1983]	 */
{ 0x84A5, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-07 ├	# BOX DRAWINGS LIGHT VERTICAL AND RIGHT	[1983]	 */
{ 0x84A6, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-08 ┬	# BOX DRAWINGS LIGHT DOWN AND HORIZONTAL	[1983] */
{ 0x84A7, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-09 ┤	# BOX DRAWINGS LIGHT VERTICAL AND LEFT	[1983] */
{ 0x84A8, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-10 ┴	# BOX DRAWINGS LIGHT UP AND HORIZONTAL	[1983] */
{ 0x84A9, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-11 ┼	# BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL	[1983] */
{ 0x84AA, -1, 5, { 0x02, 0x05, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-12 ━	# BOX DRAWINGS HEAVY HORIZONTAL	[1983] */
{ 0x84AB, -1, 5, { 0x02, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-13 ┃	# BOX DRAWINGS HEAVY VERTICAL	[1983] */
{ 0x84AC, -1, 5, { 0x02, 0x05, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-14 ┏	# BOX DRAWINGS HEAVY DOWN AND RIGHT	[1983] */
{ 0x84AD, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-15 ┓	# BOX DRAWINGS HEAVY DOWN AND LEFT	[1983] */
{ 0x84AE, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-16 ┛	# BOX DRAWINGS HEAVY UP AND LEFT	[1983] */
{ 0x84AF, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-17 ┗	# BOX DRAWINGS HEAVY UP AND RIGHT	[1983] */
{ 0x84B0, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-18 ┣	# BOX DRAWINGS HEAVY VERTICAL AND RIGHT	[1983] */
{ 0x84B1, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-19 ┳	# BOX DRAWINGS HEAVY DOWN AND HORIZONTAL	[1983] */
{ 0x84B2, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-20 ┫	# BOX DRAWINGS HEAVY VERTICAL AND LEFT	[1983] */
{ 0x84B3, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-21 ┻	# BOX DRAWINGS HEAVY UP AND HORIZONTAL	[1983] */
{ 0x84B4, -1, 5, { 0x02, 0x05, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-22 ╋	# BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL	[1983] */
{ 0x84B5, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-23 ┠	# BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT	[1983] */
{ 0x84B6, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-24 ┯	# BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY	[1983]	 */
{ 0x84B7, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-25 ┨	# BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT	[1983]	 */
{ 0x84B8, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-26 ┷	# BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY	[1983]	 */
{ 0x84B9, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-27 ┿	# BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY	[1983]	 */
{ 0x84BA, -1, 5, { 0x02, 0x05, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-28 ┝	# BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY	[1983]	 */
{ 0x84BB, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-29 ┰	# BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT	[1983]	 */
{ 0x84BC, -1, 5, { 0x02, 0x05, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-30 ┥	# BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY	[1983]	 */
{ 0x84BD, -1, 5, { 0x02, 0x05, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-31 ┸	# BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT	[1983]	 */
{ 0x84BE, -1, 5, { 0x02, 0x05, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-32 ╂	# BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT	[1983]	 */
{ 0x84BF, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-33 ㉑	# CIRCLED NUMBER TWENTY ONE	[2000]	[Unicode3.2] */
{ 0x84C0, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-34 ㉒	# CIRCLED NUMBER TWENTY TWO	[2000]	[Unicode3.2] */
{ 0x84C1, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-35 ㉓	# CIRCLED NUMBER TWENTY THREE	[2000]	[Unicode3.2] */
{ 0x84C2, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-36 ㉔	# CIRCLED NUMBER TWENTY FOUR	[2000]	[Unicode3.2] */
{ 0x84C3, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-37 ㉕	# CIRCLED NUMBER TWENTY FIVE	[2000]	[Unicode3.2] */
{ 0x84C4, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-38 ㉖	# CIRCLED NUMBER TWENTY SIX	[2000]	[Unicode3.2] */
{ 0x84C5, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-39 ㉗	# CIRCLED NUMBER TWENTY SEVEN	[2000]	[Unicode3.2] */
{ 0x84C6, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-40 ㉘	# CIRCLED NUMBER TWENTY EIGHT	[2000]	[Unicode3.2] */
{ 0x84C7, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-41 ㉙	# CIRCLED NUMBER TWENTY NINE	[2000]	[Unicode3.2] */
{ 0x84C8, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-42 ㉚	# CIRCLED NUMBER THIRTY	[2000]	[Unicode3.2] */
{ 0x84C9, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-43 ㉛	# CIRCLED NUMBER THIRTY ONE	[2000]	[Unicode3.2] */
{ 0x84CA, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-44 ㉜	# CIRCLED NUMBER THIRTY TWO	[2000]	[Unicode3.2] */
{ 0x84CB, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-45 ㉝	# CIRCLED NUMBER THIRTY THREE	[2000]	[Unicode3.2] */
{ 0x84CC, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-46 ㉞	# CIRCLED NUMBER THIRTY FOUR	[2000]	[Unicode3.2] */
{ 0x84CD, -2, 5, { 0x03, 0x02, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-47 ㉟	# CIRCLED NUMBER THIRTY FIVE	[2000]	[Unicode3.2] */
{ 0x84CE, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-48 ㊱	# CIRCLED NUMBER THIRTY SIX	[2000]	[Unicode3.2] */
{ 0x84CF, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-49 ㊲	# CIRCLED NUMBER THIRTY SEVEN	[2000]	[Unicode3.2] */
{ 0x84D0, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-50 ㊳	# CIRCLED NUMBER THIRTY EIGHT	[2000]	[Unicode3.2] */
{ 0x84D1, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-51 ㊴	# CIRCLED NUMBER THIRTY NINE	[2000]	[Unicode3.2] */
{ 0x84D2, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-52 ㊵	# CIRCLED NUMBER FORTY	[2000]	[Unicode3.2] */
{ 0x84D3, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-53 ㊶	# CIRCLED NUMBER FORTY ONE	[2000]	[Unicode3.2] */
{ 0x84D4, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-54 ㊷	# CIRCLED NUMBER FORTY TWO	[2000]	[Unicode3.2] */
{ 0x84D5, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-55 ㊸	# CIRCLED NUMBER FORTY THREE	[2000]	[Unicode3.2] */
{ 0x84D6, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-56 ㊹	# CIRCLED NUMBER FORTY FOUR	[2000]	[Unicode3.2] */
{ 0x84D7, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-57 ㊺	# CIRCLED NUMBER FORTY FIVE	[2000]	[Unicode3.2] */
{ 0x84D8, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-58 ㊻	# CIRCLED NUMBER FORTY SIX	[2000]	[Unicode3.2] */
{ 0x84D9, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-59 ㊼	# CIRCLED NUMBER FORTY SEVEN	[2000]	[Unicode3.2] */
{ 0x84DA, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-60 ㊽	# CIRCLED NUMBER FORTY EIGHT	[2000]	[Unicode3.2] */
{ 0x84DB, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-61 ㊾	# CIRCLED NUMBER FORTY NINE	[2000]	[Unicode3.2] */
{ 0x84DC, -2, 5, { 0x03, 0x02, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-62 ㊿	# CIRCLED NUMBER FIFTY	[2000]	[Unicode3.2] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x84E5, -2, 5, { 0x02, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-71 ◐	# CIRCLE WITH LEFT HALF BLACK	[2000]	 */
{ 0x84E6, -2, 5, { 0x02, 0x05, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-72 ◑	# CIRCLE WITH RIGHT HALF BLACK	[2000]	 */
{ 0x84E7, -2, 5, { 0x02, 0x05, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-73 ◒	# CIRCLE WITH LOWER HALF BLACK	[2000]	 */
{ 0x84E8, -2, 5, { 0x02, 0x05, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-74 ◓	# CIRCLE WITH UPPER HALF BLACK	[2000]	 */
{ 0x84E9, -2, 5, { 0x02, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-75 ‼	# DOUBLE EXCLAMATION MARK	[2000]	 */
{ 0x84EA, -2, 5, { 0x02, 0x00, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-76 ⁇	# DOUBLE QUESTION MARK	[2000]	[Unicode3.2] */
{ 0x84EB, -2, 5, { 0x02, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-77 ⁈	# QUESTION EXCLAMATION MARK	[2000]	 */
{ 0x84EC, -2, 5, { 0x02, 0x00, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-78 ⁉	# EXCLAMATION QUESTION MARK	[2000]	 */
{ 0x84ED, -2, 4, { 0x01, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-79 Ǎ	# LATIN CAPITAL LETTER A WITH CARON	[2000]	 */
{ 0x84EE, -2, 4, { 0x01, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-80 ǎ	# LATIN SMALL LETTER A WITH CARON	[2000]	 */
{ 0x84EF, -2, 4, { 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-81 ǐ	# LATIN SMALL LETTER I WITH CARON	[2000]	 */
{ 0x84F0, -2, 5, { 0x01, 0x0e, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-82 Ḿ	# LATIN CAPITAL LETTER M WITH ACUTE	[2000]	 */
{ 0x84F1, -2, 5, { 0x01, 0x0e, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-83 ḿ	# LATIN SMALL LETTER M WITH ACUTE	[2000]	 */
{ 0x84F2, -2, 4, { 0x01, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-84 Ǹ	# LATIN CAPITAL LETTER N WITH GRAVE	[2000]	 */
{ 0x84F3, -2, 4, { 0x01, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-85 ǹ	# LATIN SMALL LETTER N WITH GRAVE	[2000]	 */
{ 0x84F4, -2, 4, { 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-86 Ǒ	# LATIN CAPITAL LETTER O WITH CARON	[2000]	 */
{ 0x84F5, -2, 4, { 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-87 ǒ	# LATIN SMALL LETTER O WITH CARON	[2000]	 */
{ 0x84F6, -2, 4, { 0x01, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-88 ǔ	# LATIN SMALL LETTER U WITH CARON	[2000] */
{ 0x84F7, -2, 4, { 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-89 ǖ	# LATIN SMALL LETTER U WITH DIAERESIS AND MACRON	[2000] */
{ 0x84F8, -2, 4, { 0x01, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-90 ǘ	# LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE	[2000] */
{ 0x84F9, -2, 4, { 0x01, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-91 ǚ	# LATIN SMALL LETTER U WITH DIAERESIS AND CARON	[2000] */
{ 0x84FA, -2, 4, { 0x01, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-08-92 ǜ	# LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8540, -2, 5, { 0x02, 0x00, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-01 €	# EURO SIGN	[2000] */
{ 0x8541, -2, 4, { 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-02  	# NO-BREAK SPACE	[2000] */
{ 0x8542, -2, 4, { 0x00, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-03 ¡	# INVERTED EXCLAMATION MARK	[2000] */
{ 0x8543, -2, 4, { 0x00, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-04 ¤	# CURRENCY SIGN	[2000] */
{ 0x8544, -2, 4, { 0x00, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-05 ¦	# BROKEN BAR	[2000] */
{ 0x8545, -2, 4, { 0x00, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-06 ©	# COPYRIGHT SIGN	[2000] */
{ 0x8546, -2, 4, { 0x00, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-07 ª	# FEMININE ORDINAL INDICATOR	[2000] */
{ 0x8547, -2, 4, { 0x00, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-08 «	# LEFT-POINTING DOUBLE ANGLE QUOTATION MARK 	[2000] */
{ 0x8548, -2, 4, { 0x00, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-09 ­	# SOFT HYPHEN	[2000] */
{ 0x8549, -2, 4, { 0x00, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-10 ®	# REGISTERED SIGN	[2000] */
{ 0x854A, -2, 4, { 0x00, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-11 ¯	# MACRON	[2000] */
{ 0x854B, -2, 4, { 0x00, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-12 ²	# SUPERSCRIPT TWO	[2000] */
{ 0x854C, -2, 4, { 0x00, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-13 ³	# SUPERSCRIPT THREE	[2000] */
{ 0x854D, -2, 4, { 0x00, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-14 ·	# MIDDLE DOT	[2000] */
{ 0x854E, -2, 4, { 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-15 ¸	# CEDILLA	[2000] */
{ 0x854F, -2, 4, { 0x00, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-16 ¹	# SUPERSCRIPT ONE	[2000] */
{ 0x8550, -2, 4, { 0x00, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-17 º	# MASCULINE ORDINAL INDICATOR	[2000] */
{ 0x8551, -2, 4, { 0x00, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-18 »	# RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK 	[2000] */
{ 0x8552, -2, 4, { 0x00, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-19 ¼	# VULGAR FRACTION ONE QUARTER	[2000] */
{ 0x8553, -2, 4, { 0x00, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-20 ½	# VULGAR FRACTION ONE HALF	[2000] */
{ 0x8554, -2, 4, { 0x00, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-21 ¾	# VULGAR FRACTION THREE QUARTERS	[2000] */
{ 0x8555, -2, 4, { 0x00, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-22 ¿	# INVERTED QUESTION MARK	[2000] */
{ 0x8556, -2, 4, { 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-23 À	# LATIN CAPITAL LETTER A WITH GRAVE	[2000] */
{ 0x8557, -2, 4, { 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-24 Á	# LATIN CAPITAL LETTER A WITH ACUTE	[2000] */
{ 0x8558, -2, 4, { 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-25 Â	# LATIN CAPITAL LETTER A WITH CIRCUMFLEX	[2000] */
{ 0x8559, -2, 4, { 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-26 Ã	# LATIN CAPITAL LETTER A WITH TILDE	[2000] */
{ 0x855A, -2, 4, { 0x00, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-27 Ä	# LATIN CAPITAL LETTER A WITH DIAERESIS	[2000] */
{ 0x855B, -2, 4, { 0x00, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-28 Å	# LATIN CAPITAL LETTER A WITH RING ABOVE	[2000] */
{ 0x855C, -2, 4, { 0x00, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-29 Æ	# LATIN CAPITAL LETTER AE 	[2000] */
{ 0x855D, -2, 4, { 0x00, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-30 Ç	# LATIN CAPITAL LETTER C WITH CEDILLA	[2000] */
{ 0x855E, -2, 4, { 0x00, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-31 È	# LATIN CAPITAL LETTER E WITH GRAVE	[2000] */
{ 0x855F, -2, 4, { 0x00, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-32 É	# LATIN CAPITAL LETTER E WITH ACUTE	[2000] */
{ 0x8560, -2, 4, { 0x00, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-33 Ê	# LATIN CAPITAL LETTER E WITH CIRCUMFLEX	[2000] */
{ 0x8561, -2, 4, { 0x00, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-34 Ë	# LATIN CAPITAL LETTER E WITH DIAERESIS	[2000] */
{ 0x8562, -2, 4, { 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-35 Ì	# LATIN CAPITAL LETTER I WITH GRAVE	[2000] */
{ 0x8563, -2, 4, { 0x00, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-36 Í	# LATIN CAPITAL LETTER I WITH ACUTE	[2000] */
{ 0x8564, -2, 4, { 0x00, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-37 Î	# LATIN CAPITAL LETTER I WITH CIRCUMFLEX	[2000] */
{ 0x8565, -2, 4, { 0x00, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-38 Ï	# LATIN CAPITAL LETTER I WITH DIAERESIS	[2000] */
{ 0x8566, -2, 4, { 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-39 Ð	# LATIN CAPITAL LETTER ETH 	[2000] */
{ 0x8567, -2, 4, { 0x00, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-40 Ñ	# LATIN CAPITAL LETTER N WITH TILDE	[2000] */
{ 0x8568, -2, 4, { 0x00, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-41 Ò	# LATIN CAPITAL LETTER O WITH GRAVE	[2000] */
{ 0x8569, -2, 4, { 0x00, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-42 Ó	# LATIN CAPITAL LETTER O WITH ACUTE	[2000] */
{ 0x856A, -2, 4, { 0x00, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-43 Ô	# LATIN CAPITAL LETTER O WITH CIRCUMFLEX	[2000] */
{ 0x856B, -2, 4, { 0x00, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-44 Õ	# LATIN CAPITAL LETTER O WITH TILDE	[2000] */
{ 0x856C, -2, 4, { 0x00, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-45 Ö	# LATIN CAPITAL LETTER O WITH DIAERESIS	[2000] */
{ 0x856D, -2, 4, { 0x00, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-46 Ø	# LATIN CAPITAL LETTER O WITH STROKE	[2000] */
{ 0x856E, -2, 4, { 0x00, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-47 Ù	# LATIN CAPITAL LETTER U WITH GRAVE	[2000] */
{ 0x856F, -2, 4, { 0x00, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-48 Ú	# LATIN CAPITAL LETTER U WITH ACUTE	[2000] */
{ 0x8570, -2, 4, { 0x00, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-49 Û	# LATIN CAPITAL LETTER U WITH CIRCUMFLEX	[2000] */
{ 0x8571, -2, 4, { 0x00, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-50 Ü	# LATIN CAPITAL LETTER U WITH DIAERESIS	[2000] */
{ 0x8572, -2, 4, { 0x00, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-51 Ý	# LATIN CAPITAL LETTER Y WITH ACUTE	[2000] */
{ 0x8573, -2, 4, { 0x00, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-52 Þ	# LATIN CAPITAL LETTER THORN 	[2000] */
{ 0x8574, -2, 4, { 0x00, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-53 ß	# LATIN SMALL LETTER SHARP S 	[2000] */
{ 0x8575, -2, 4, { 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-54 à	# LATIN SMALL LETTER A WITH GRAVE	[2000] */
{ 0x8576, -2, 4, { 0x00, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-55 á	# LATIN SMALL LETTER A WITH ACUTE	[2000] */
{ 0x8577, -2, 4, { 0x00, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-56 â	# LATIN SMALL LETTER A WITH CIRCUMFLEX	[2000] */
{ 0x8578, -2, 4, { 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-57 ã	# LATIN SMALL LETTER A WITH TILDE	[2000] */
{ 0x8579, -2, 4, { 0x00, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-58 ä	# LATIN SMALL LETTER A WITH DIAERESIS	[2000] */
{ 0x857A, -2, 4, { 0x00, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-59 å	# LATIN SMALL LETTER A WITH RING ABOVE	[2000] */
{ 0x857B, -2, 4, { 0x00, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-60 æ	# LATIN SMALL LETTER AE 	[2000] */
{ 0x857C, -2, 4, { 0x00, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-61 ç	# LATIN SMALL LETTER C WITH CEDILLA	[2000] */
{ 0x857D, -2, 4, { 0x00, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-62 è	# LATIN SMALL LETTER E WITH GRAVE	[2000] */
{ 0x857E, -2, 4, { 0x00, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-63 é	# LATIN SMALL LETTER E WITH ACUTE	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8580, -2, 4, { 0x00, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-64 ê	# LATIN SMALL LETTER E WITH CIRCUMFLEX	[2000] */
{ 0x8581, -2, 4, { 0x00, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-65 ë	# LATIN SMALL LETTER E WITH DIAERESIS	[2000] */
{ 0x8582, -2, 4, { 0x00, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-66 ì	# LATIN SMALL LETTER I WITH GRAVE	[2000] */
{ 0x8583, -2, 4, { 0x00, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-67 í	# LATIN SMALL LETTER I WITH ACUTE	[2000] */
{ 0x8584, -2, 4, { 0x00, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-68 î	# LATIN SMALL LETTER I WITH CIRCUMFLEX	[2000] */
{ 0x8585, -2, 4, { 0x00, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-69 ï	# LATIN SMALL LETTER I WITH DIAERESIS	[2000] */
{ 0x8586, -2, 4, { 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-70 ð	# LATIN SMALL LETTER ETH 	[2000] */
{ 0x8587, -2, 4, { 0x00, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-71 ñ	# LATIN SMALL LETTER N WITH TILDE	[2000] */
{ 0x8588, -2, 4, { 0x00, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-72 ò	# LATIN SMALL LETTER O WITH GRAVE	[2000] */
{ 0x8589, -2, 4, { 0x00, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-73 ó	# LATIN SMALL LETTER O WITH ACUTE	[2000] */
{ 0x858A, -2, 4, { 0x00, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-74 ô	# LATIN SMALL LETTER O WITH CIRCUMFLEX	[2000] */
{ 0x858B, -2, 4, { 0x00, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-75 õ	# LATIN SMALL LETTER O WITH TILDE	[2000] */
{ 0x858C, -2, 4, { 0x00, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-76 ö	# LATIN SMALL LETTER O WITH DIAERESIS	[2000] */
{ 0x858D, -2, 4, { 0x00, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-77 ø	# LATIN SMALL LETTER O WITH STROKE	[2000] */
{ 0x858E, -2, 4, { 0x00, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-78 ù	# LATIN SMALL LETTER U WITH GRAVE	[2000] */
{ 0x858F, -2, 4, { 0x00, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-79 ú	# LATIN SMALL LETTER U WITH ACUTE	[2000] */
{ 0x8590, -2, 4, { 0x00, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-80 û	# LATIN SMALL LETTER U WITH CIRCUMFLEX	[2000] */
{ 0x8591, -2, 4, { 0x00, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-81 ü	# LATIN SMALL LETTER U WITH DIAERESIS	[2000] */
{ 0x8592, -2, 4, { 0x00, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-82 ý	# LATIN SMALL LETTER Y WITH ACUTE	[2000] */
{ 0x8593, -2, 4, { 0x00, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-83 þ	# LATIN SMALL LETTER THORN 	[2000] */
{ 0x8594, -2, 4, { 0x00, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-84 ÿ	# LATIN SMALL LETTER Y WITH DIAERESIS	[2000] */
{ 0x8595, -2, 4, { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-85 Ā	# LATIN CAPITAL LETTER A WITH MACRON	[2000] */
{ 0x8596, -2, 4, { 0x01, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-86 Ī	# LATIN CAPITAL LETTER I WITH MACRON	[2000] */
{ 0x8597, -2, 4, { 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-87 Ū	# LATIN CAPITAL LETTER U WITH MACRON	[2000] */
{ 0x8598, -2, 4, { 0x01, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-88 Ē	# LATIN CAPITAL LETTER E WITH MACRON	[2000] */
{ 0x8599, -2, 4, { 0x01, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-89 Ō	# LATIN CAPITAL LETTER O WITH MACRON	[2000] */
{ 0x859A, -2, 4, { 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-90 ā	# LATIN SMALL LETTER A WITH MACRON	[2000] */
{ 0x859B, -2, 4, { 0x01, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-91 ī	# LATIN SMALL LETTER I WITH MACRON	[2000] */
{ 0x859C, -2, 4, { 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-92 ū	# LATIN SMALL LETTER U WITH MACRON	[2000] */
{ 0x859D, -2, 4, { 0x01, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-93 ē	# LATIN SMALL LETTER E WITH MACRON	[2000] */
{ 0x859E, -2, 4, { 0x01, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-09-94 ō	# LATIN SMALL LETTER O WITH MACRON	[2000] */
{ 0x859F, -2, 4, { 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-01 Ą	# LATIN CAPITAL LETTER A WITH OGONEK	[2000] */
{ 0x85A0, -2, 4, { 0x02, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-02 ˘	# BREVE	[2000] */
{ 0x85A1, -2, 4, { 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-03 Ł	# LATIN CAPITAL LETTER L WITH STROKE	[2000] */
{ 0x85A2, -2, 4, { 0x01, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-04 Ľ	# LATIN CAPITAL LETTER L WITH CARON	[2000] */
{ 0x85A3, -2, 4, { 0x01, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-05 Ś	# LATIN CAPITAL LETTER S WITH ACUTE	[2000] */
{ 0x85A4, -2, 4, { 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-06 Š	# LATIN CAPITAL LETTER S WITH CARON	[2000] */
{ 0x85A5, -2, 4, { 0x01, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-07 Ş	# LATIN CAPITAL LETTER S WITH CEDILLA 	[2000] */
{ 0x85A6, -2, 4, { 0x01, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-08 Ť	# LATIN CAPITAL LETTER T WITH CARON	[2000] */
{ 0x85A7, -2, 4, { 0x01, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-09 Ź	# LATIN CAPITAL LETTER Z WITH ACUTE	[2000] */
{ 0x85A8, -2, 4, { 0x01, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-10 Ž	# LATIN CAPITAL LETTER Z WITH CARON	[2000] */
{ 0x85A9, -2, 4, { 0x01, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-11 Ż	# LATIN CAPITAL LETTER Z WITH DOT ABOVE	[2000] */
{ 0x85AA, -2, 4, { 0x01, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-12 ą	# LATIN SMALL LETTER A WITH OGONEK	[2000] */
{ 0x85AB, -2, 4, { 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-13 ˛	# OGONEK	[2000] */
{ 0x85AC, -2, 4, { 0x01, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-14 ł	# LATIN SMALL LETTER L WITH STROKE	[2000] */
{ 0x85AD, -2, 4, { 0x01, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-15 ľ	# LATIN SMALL LETTER L WITH CARON	[2000] */
{ 0x85AE, -2, 4, { 0x01, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-16 ś	# LATIN SMALL LETTER S WITH ACUTE	[2000] */
{ 0x85AF, -2, 4, { 0x02, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-17 ˇ	# CARON 	[2000] */
{ 0x85B0, -2, 4, { 0x01, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-18 š	# LATIN SMALL LETTER S WITH CARON	[2000] */
{ 0x85B1, -2, 4, { 0x01, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-19 ş	# LATIN SMALL LETTER S WITH CEDILLA 	[2000] */
{ 0x85B2, -2, 4, { 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-20 ť	# LATIN SMALL LETTER T WITH CARON	[2000] */
{ 0x85B3, -2, 4, { 0x01, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-21 ź	# LATIN SMALL LETTER Z WITH ACUTE	[2000] */
{ 0x85B4, -2, 4, { 0x02, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-22 ˝	# DOUBLE ACUTE ACCENT	[2000] */
{ 0x85B5, -2, 4, { 0x01, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-23 ž	# LATIN SMALL LETTER Z WITH CARON	[2000] */
{ 0x85B6, -2, 4, { 0x01, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-24 ż	# LATIN SMALL LETTER Z WITH DOT ABOVE	[2000] */
{ 0x85B7, -2, 4, { 0x01, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-25 Ŕ	# LATIN CAPITAL LETTER R WITH ACUTE	[2000] */
{ 0x85B8, -2, 4, { 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-26 Ă	# LATIN CAPITAL LETTER A WITH BREVE	[2000] */
{ 0x85B9, -2, 4, { 0x01, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-27 Ĺ	# LATIN CAPITAL LETTER L WITH ACUTE	[2000] */
{ 0x85BA, -2, 4, { 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-28 Ć	# LATIN CAPITAL LETTER C WITH ACUTE	[2000] */
{ 0x85BB, -2, 4, { 0x01, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-29 Č	# LATIN CAPITAL LETTER C WITH CARON	[2000] */
{ 0x85BC, -2, 4, { 0x01, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-30 Ę	# LATIN CAPITAL LETTER E WITH OGONEK	[2000] */
{ 0x85BD, -2, 4, { 0x01, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-31 Ě	# LATIN CAPITAL LETTER E WITH CARON	[2000] */
{ 0x85BE, -2, 4, { 0x01, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-32 Ď	# LATIN CAPITAL LETTER D WITH CARON	[2000] */
{ 0x85BF, -2, 4, { 0x01, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-33 Ń	# LATIN CAPITAL LETTER N WITH ACUTE	[2000] */
{ 0x85C0, -2, 4, { 0x01, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-34 Ň	# LATIN CAPITAL LETTER N WITH CARON	[2000] */
{ 0x85C1, -2, 4, { 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-35 Ő	# LATIN CAPITAL LETTER O WITH DOUBLE ACUTE	[2000] */
{ 0x85C2, -2, 4, { 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-36 Ř	# LATIN CAPITAL LETTER R WITH CARON	[2000] */
{ 0x85C3, -2, 4, { 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-37 Ů	# LATIN CAPITAL LETTER U WITH RING ABOVE	[2000] */
{ 0x85C4, -2, 4, { 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-38 Ű	# LATIN CAPITAL LETTER U WITH DOUBLE ACUTE	[2000] */
{ 0x85C5, -2, 4, { 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-39 Ţ	# LATIN CAPITAL LETTER T WITH CEDILLA 	[2000] */
{ 0x85C6, -2, 4, { 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-40 ŕ	# LATIN SMALL LETTER R WITH ACUTE	[2000] */
{ 0x85C7, -2, 4, { 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-41 ă	# LATIN SMALL LETTER A WITH BREVE	[2000] */
{ 0x85C8, -2, 4, { 0x01, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-42 ĺ	# LATIN SMALL LETTER L WITH ACUTE	[2000] */
{ 0x85C9, -2, 4, { 0x01, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-43 ć	# LATIN SMALL LETTER C WITH ACUTE	[2000] */
{ 0x85CA, -2, 4, { 0x01, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-44 č	# LATIN SMALL LETTER C WITH CARON	[2000] */
{ 0x85CB, -2, 4, { 0x01, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-45 ę	# LATIN SMALL LETTER E WITH OGONEK	[2000] */
{ 0x85CC, -2, 4, { 0x01, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-46 ě	# LATIN SMALL LETTER E WITH CARON	[2000] */
{ 0x85CD, -2, 4, { 0x01, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-47 ď	# LATIN SMALL LETTER D WITH CARON	[2000] */
{ 0x85CE, -2, 4, { 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-48 đ	# LATIN SMALL LETTER D WITH STROKE	[2000] */
{ 0x85CF, -2, 4, { 0x01, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-49 ń	# LATIN SMALL LETTER N WITH ACUTE	[2000] */
{ 0x85D0, -2, 4, { 0x01, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-50 ň	# LATIN SMALL LETTER N WITH CARON	[2000] */
{ 0x85D1, -2, 4, { 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-51 ő	# LATIN SMALL LETTER O WITH DOUBLE ACUTE	[2000] */
{ 0x85D2, -2, 4, { 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-52 ř	# LATIN SMALL LETTER R WITH CARON	[2000] */
{ 0x85D3, -2, 4, { 0x01, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-53 ů	# LATIN SMALL LETTER U WITH RING ABOVE	[2000] */
{ 0x85D4, -2, 4, { 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-54 ű	# LATIN SMALL LETTER U WITH DOUBLE ACUTE	[2000] */
{ 0x85D5, -2, 4, { 0x01, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-55 ţ	# LATIN SMALL LETTER T WITH CEDILLA 	[2000] */
{ 0x85D6, -2, 4, { 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-56 ˙	# DOT ABOVE 	[2000] */
{ 0x85D7, -2, 4, { 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-57 Ĉ	# LATIN CAPITAL LETTER C WITH CIRCUMFLEX	[2000] */
{ 0x85D8, -2, 4, { 0x01, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-58 Ĝ	# LATIN CAPITAL LETTER G WITH CIRCUMFLEX	[2000] */
{ 0x85D9, -2, 4, { 0x01, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-59 Ĥ	# LATIN CAPITAL LETTER H WITH CIRCUMFLEX	[2000] */
{ 0x85DA, -2, 4, { 0x01, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-60 Ĵ	# LATIN CAPITAL LETTER J WITH CIRCUMFLEX	[2000] */
{ 0x85DB, -2, 4, { 0x01, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-61 Ŝ	# LATIN CAPITAL LETTER S WITH CIRCUMFLEX	[2000] */
{ 0x85DC, -2, 4, { 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-62 Ŭ	# LATIN CAPITAL LETTER U WITH BREVE	[2000] */
{ 0x85DD, -2, 4, { 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-63 ĉ	# LATIN SMALL LETTER C WITH CIRCUMFLEX	[2000] */
{ 0x85DE, -2, 4, { 0x01, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-64 ĝ	# LATIN SMALL LETTER G WITH CIRCUMFLEX	[2000] */
{ 0x85DF, -2, 4, { 0x01, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-65 ĥ	# LATIN SMALL LETTER H WITH CIRCUMFLEX	[2000] */
{ 0x85E0, -2, 4, { 0x01, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-66 ĵ	# LATIN SMALL LETTER J WITH CIRCUMFLEX	[2000] */
{ 0x85E1, -2, 4, { 0x01, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-67 ŝ	# LATIN SMALL LETTER S WITH CIRCUMFLEX	[2000] */
{ 0x85E2, -2, 4, { 0x01, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-68 ŭ	# LATIN SMALL LETTER U WITH BREVE	[2000] */
{ 0x85E3, -2, 4, { 0x02, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-69 ɱ	# LATIN SMALL LETTER M WITH HOOK	[2000] */
{ 0x85E4, -2, 4, { 0x02, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-70 ʋ	# LATIN SMALL LETTER V WITH HOOK	[2000] */
{ 0x85E5, -2, 4, { 0x02, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-71 ɾ	# LATIN SMALL LETTER R WITH FISHHOOK	[2000] */
{ 0x85E6, -2, 4, { 0x02, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-72 ʃ	# LATIN SMALL LETTER ESH	[2000] */
{ 0x85E7, -2, 4, { 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-73 ʒ	# LATIN SMALL LETTER EZH	[2000] */
{ 0x85E8, -2, 4, { 0x02, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-74 ɬ	# LATIN SMALL LETTER L WITH BELT	[2000] */
{ 0x85E9, -2, 4, { 0x02, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-75 ɮ	# LATIN SMALL LETTER LEZH	[2000] */
{ 0x85EA, -2, 4, { 0x02, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-76 ɹ	# LATIN SMALL LETTER TURNED R	[2000] */
{ 0x85EB, -2, 4, { 0x02, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-77 ʈ	# LATIN SMALL LETTER T WITH RETROFLEX HOOK	[2000] */
{ 0x85EC, -2, 4, { 0x02, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-78 ɖ	# LATIN SMALL LETTER D WITH TAIL	[2000] */
{ 0x85ED, -2, 4, { 0x02, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-79 ɳ	# LATIN SMALL LETTER N WITH RETROFLEX HOOK	[2000] */
{ 0x85EE, -2, 4, { 0x02, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-80 ɽ	# LATIN SMALL LETTER R WITH TAIL	[2000] */
{ 0x85EF, -2, 4, { 0x02, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-81 ʂ	# LATIN SMALL LETTER S WITH HOOK	[2000] */
{ 0x85F0, -2, 4, { 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-82 ʐ	# LATIN SMALL LETTER Z WITH RETROFLEX HOOK	[2000] */
{ 0x85F1, -2, 4, { 0x02, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-83 ɻ	# LATIN SMALL LETTER TURNED R WITH HOOK	[2000] */
{ 0x85F2, -2, 4, { 0x02, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-84 ɭ	# LATIN SMALL LETTER L WITH RETROFLEX HOOK	[2000] */
{ 0x85F3, -2, 4, { 0x02, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-85 ɟ	# LATIN SMALL LETTER DOTLESS J WITH STROKE	[2000] */
{ 0x85F4, -2, 4, { 0x02, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-86 ɲ	# LATIN SMALL LETTER N WITH LEFT HOOK	[2000] */
{ 0x85F5, -2, 4, { 0x02, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-87 ʝ	# LATIN SMALL LETTER J WITH CROSSED-TAIL	[2000] */
{ 0x85F6, -2, 4, { 0x02, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-88 ʎ	# LATIN SMALL LETTER TURNED Y	[2000] */
{ 0x85F7, -2, 4, { 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-89 ɡ	# LATIN SMALL LETTER SCRIPT G	[2000] */
{ 0x85F8, -2, 4, { 0x01, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-90 ŋ	# LATIN SMALL LETTER ENG 	[2000] */
{ 0x85F9, -2, 4, { 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-91 ɰ	# LATIN SMALL LETTER TURNED M WITH LONG LEG	[2000] */
{ 0x85FA, -2, 4, { 0x02, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-92 ʁ	# LATIN LETTER SMALL CAPITAL INVERTED R	[2000] */
{ 0x85FB, -2, 4, { 0x01, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-93 ħ	# LATIN SMALL LETTER H WITH STROKE	[2000] */
{ 0x85FC, -2, 4, { 0x02, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-10-94 ʕ	# LATIN LETTER PHARYNGEAL VOICED FRICATIVE	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8640, -2, 4, { 0x02, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-01 ʔ	# LATIN LETTER GLOTTAL STOP	[2000] */
{ 0x8641, -2, 4, { 0x02, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-02 ɦ	# LATIN SMALL LETTER H WITH HOOK	[2000] */
{ 0x8642, -2, 4, { 0x02, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-03 ʘ	# LATIN LETTER BILABIAL CLICK	[2000] */
{ 0x8643, -2, 4, { 0x01, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-04 ǂ	# LATIN LETTER ALVEOLAR CLICK	[2000] */
{ 0x8644, -2, 4, { 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-05 ɓ	# LATIN SMALL LETTER B WITH HOOK	[2000] */
{ 0x8645, -2, 4, { 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-06 ɗ	# LATIN SMALL LETTER D WITH HOOK	[2000] */
{ 0x8646, -2, 4, { 0x02, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-07 ʄ	# LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK	[2000] */
{ 0x8647, -2, 4, { 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-08 ɠ	# LATIN SMALL LETTER G WITH HOOK	[2000] */
{ 0x8648, -2, 4, { 0x01, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-09 Ɠ	# LATIN CAPITAL LETTER G WITH HOOK	[2000] */
{ 0x8649, -2, 4, { 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-10 œ	# LATIN SMALL LIGATURE OE	[2000] */
{ 0x864A, -2, 4, { 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-11 Œ	# LATIN CAPITAL LIGATURE OE	[2000] */
{ 0x864B, -2, 4, { 0x02, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-12 ɨ	# LATIN SMALL LETTER I WITH STROKE	[2000] */
{ 0x864C, -2, 4, { 0x02, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-13 ʉ	# LATIN SMALL LETTER U BAR	[2000] */
{ 0x864D, -2, 4, { 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-14 ɘ	# LATIN SMALL LETTER REVERSED E	[2000] */
{ 0x864E, -2, 4, { 0x02, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-15 ɵ	# LATIN SMALL LETTER BARRED O	[2000] */
{ 0x864F, -2, 4, { 0x02, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-16 ə	# LATIN SMALL LETTER SCHWA	[2000] */
{ 0x8650, -2, 4, { 0x02, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-17 ɜ	# LATIN SMALL LETTER REVERSED OPEN E	[2000] */
{ 0x8651, -2, 4, { 0x02, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-18 ɞ	# LATIN SMALL LETTER CLOSED REVERSED OPEN E	[2000] */
{ 0x8652, -2, 4, { 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-19 ɐ	# LATIN SMALL LETTER TURNED A	[2000] */
{ 0x8653, -2, 4, { 0x02, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-20 ɯ	# LATIN SMALL LETTER TURNED M	[2000] */
{ 0x8654, -2, 4, { 0x02, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-21 ʊ	# LATIN SMALL LETTER UPSILON	[2000] */
{ 0x8655, -2, 4, { 0x02, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-22 ɤ	# LATIN SMALL LETTER RAMS HORN	[2000] */
{ 0x8656, -2, 4, { 0x02, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-23 ʌ	# LATIN SMALL LETTER TURNED V	[2000] */
{ 0x8657, -2, 4, { 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-24 ɔ	# LATIN SMALL LETTER OPEN O	[2000] */
{ 0x8658, -2, 4, { 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-25 ɑ	# LATIN SMALL LETTER ALPHA	[2000] */
{ 0x8659, -2, 4, { 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-26 ɒ	# LATIN SMALL LETTER TURNED ALPHA	[2000] */
{ 0x865A, -2, 4, { 0x02, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-27 ʍ	# LATIN SMALL LETTER TURNED W	[2000] */
{ 0x865B, -2, 4, { 0x02, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-28 ɥ	# LATIN SMALL LETTER TURNED H	[2000] */
{ 0x865C, -2, 4, { 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-29 ʢ	# LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE	[2000] */
{ 0x865D, -2, 4, { 0x02, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-30 ʡ	# LATIN LETTER GLOTTAL STOP WITH STROKE	[2000] */
{ 0x865E, -2, 4, { 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-31 ɕ	# LATIN SMALL LETTER C WITH CURL	[2000] */
{ 0x865F, -2, 4, { 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-32 ʑ	# LATIN SMALL LETTER Z WITH CURL	[2000] */
{ 0x8660, -2, 4, { 0x02, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-33 ɺ	# LATIN SMALL LETTER TURNED R WITH LONG LEG	[2000] */
{ 0x8661, -2, 4, { 0x02, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-34 ɧ	# LATIN SMALL LETTER HENG WITH HOOK	[2000] */
{ 0x8662, -2, 4, { 0x02, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-35 ɚ	# LATIN SMALL LETTER SCHWA WITH HOOK	[2000] */
{ 0x8663, -2, 8, { 0x00, 0x03, 0x02, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-36 æ̀	# 	[2000] */
{ 0x8664, -2, 4, { 0x01, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-37 ǽ	# LATIN SMALL LETTER AE WITH ACUTE 	[2000] */
{ 0x8665, -2, 5, { 0x01, 0x0f, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-38 ὰ	# GREEK SMALL LETTER ALPHA WITH VARIA	[2000] */
{ 0x8666, -2, 5, { 0x01, 0x0f, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-39 ά	# GREEK SMALL LETTER ALPHA WITH OXIA	[2000] */
{ 0x8667, -2, 8, { 0x02, 0x01, 0x01, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-40 ɔ̀	# 	[2000] */
{ 0x8668, -2, 8, { 0x02, 0x01, 0x01, 0x04, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00 }	},	/* 1-11-41 ɔ́	# 	[2000] */
{ 0x8669, -2, 8, { 0x02, 0x02, 0x00, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-42 ʌ̀	# 	[2000] */
{ 0x866A, -2, 8, { 0x02, 0x02, 0x00, 0x0c, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00 }	},	/* 1-11-43 ʌ́	# 	[2000] */
{ 0x866B, -2, 8, { 0x02, 0x01, 0x01, 0x09, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-44 ə̀	# 	[2000] */
{ 0x866C, -2, 8, { 0x02, 0x01, 0x01, 0x09, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00 }	},	/* 1-11-45 ə́	# 	[2000] */
{ 0x866D, -2, 8, { 0x02, 0x01, 0x01, 0x0a, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-46 ɚ̀	# 	[2000] */
{ 0x866E, -2, 8, { 0x02, 0x01, 0x01, 0x0a, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00 }	},	/* 1-11-47 ɚ́	# 	[2000] */
{ 0x866F, -2, 5, { 0x01, 0x0f, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-48 ὲ	# GREEK SMALL LETTER EPSILON WITH VARIA	[2000] */
{ 0x8670, -2, 5, { 0x01, 0x0f, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-49 έ	# GREEK SMALL LETTER EPSILON WITH OXIA	[2000] */
{ 0x8671, -2, 4, { 0x03, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-50 ͡	# COMBINING DOUBLE INVERTED BREVE	[2000] */
{ 0x8672, -2, 4, { 0x02, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-51 ˈ	# MODIFIER LETTER VERTICAL LINE	[2000] */
{ 0x8673, -2, 4, { 0x02, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-52 ˌ	# MODIFIER LETTER LOW VERTICAL LINE	[2000] */
{ 0x8674, -2, 4, { 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-53 ː	# MODIFIER LETTER TRIANGULAR COLON	[2000] */
{ 0x8675, -2, 4, { 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-54 ˑ	# MODIFIER LETTER HALF TRIANGULAR COLON	[2000] */
{ 0x8676, -2, 4, { 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-55 ̆	# COMBINING BREVE 	[2000] */
{ 0x8677, -2, 5, { 0x02, 0x00, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-56 ‿	# UNDERTIE 	[2000] */
{ 0x8678, -2, 4, { 0x03, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-57 ̋	# COMBINING DOUBLE ACUTE ACCENT	[2000] */
{ 0x8679, -2, 4, { 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-58 ́	# COMBINING ACUTE ACCENT 	[2000] */
{ 0x867A, -2, 4, { 0x03, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-59 ̄	# COMBINING MACRON	[2000] */
{ 0x867B, -2, 4, { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-60 ̀	# COMBINING GRAVE ACCENT 	[2000] */
{ 0x867C, -2, 4, { 0x03, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-61 ̏	# COMBINING DOUBLE GRAVE ACCENT	[2000] */
{ 0x867D, -2, 4, { 0x03, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-62 ̌	# COMBINING CARON	[2000] */
{ 0x867E, -2, 4, { 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-63 ̂	# COMBINING CIRCUMFLEX ACCENT	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8680, -2, 4, { 0x02, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-64 ˥	# MODIFIER LETTER EXTRA-HIGH TONE BAR	[2000] */
{ 0x8681, -2, 4, { 0x02, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-65 ˦	# MODIFIER LETTER HIGH TONE BAR	[2000] */
{ 0x8682, -2, 4, { 0x02, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-66 ˧	# MODIFIER LETTER MID TONE BAR	[2000] */
{ 0x8683, -2, 4, { 0x02, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-67 ˨	# MODIFIER LETTER LOW TONE BAR	[2000] */
{ 0x8684, -2, 4, { 0x02, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-68 ˩	# MODIFIER LETTER EXTRA-LOW TONE BAR	[2000] */
{ 0x8685, -2, 8, { 0x02, 0x03, 0x02, 0x09, 0x02, 0x03, 0x02, 0x05, 0x00, 0x00 }	},	/* 1-11-69 ˩˥	# 	[2000] */
{ 0x8686, -2, 8, { 0x02, 0x03, 0x02, 0x05, 0x02, 0x03, 0x02, 0x09, 0x00, 0x00 }	},	/* 1-11-70 ˥˩	# 	[2000] */
{ 0x8687, -2, 4, { 0x03, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-71 ̥	# COMBINING RING BELOW	[2000] */
{ 0x8688, -2, 4, { 0x03, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-72 ̬	# COMBINING CARON BELOW	[2000] */
{ 0x8689, -2, 4, { 0x03, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-73 ̹	# COMBINING RIGHT HALF RING BELOW	[2000] */
{ 0x868A, -2, 4, { 0x03, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-74 ̜	# COMBINING LEFT HALF RING BELOW	[2000] */
{ 0x868B, -2, 4, { 0x03, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-75 ̟	# COMBINING PLUS SIGN BELOW	[2000] */
{ 0x868C, -2, 4, { 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-76 ̠	# COMBINING MINUS SIGN BELOW	[2000] */
{ 0x868D, -2, 4, { 0x03, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-77 ̈	# COMBINING DIAERESIS 	[2000] */
{ 0x868E, -2, 4, { 0x03, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-78 ̽	# COMBINING X ABOVE	[2000] */
{ 0x868F, -2, 4, { 0x03, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-79 ̩	# COMBINING VERTICAL LINE BELOW	[2000] */
{ 0x8690, -2, 4, { 0x03, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-80 ̯	# COMBINING INVERTED BREVE BELOW	[2000] */
{ 0x8691, -2, 4, { 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-81 ˞	# MODIFIER LETTER RHOTIC HOOK	[2000] */
{ 0x8692, -2, 4, { 0x03, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-82 ̤	# COMBINING DIAERESIS BELOW	[2000] */
{ 0x8693, -2, 4, { 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-83 ̰	# COMBINING TILDE BELOW	[2000] */
{ 0x8694, -2, 4, { 0x03, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-84 ̼	# COMBINING SEAGULL BELOW	[2000] */
{ 0x8695, -2, 4, { 0x03, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-85 ̴	# COMBINING TILDE OVERLAY	[2000] */
{ 0x8696, -2, 4, { 0x03, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-86 ̝	# COMBINING UP TACK BELOW	[2000] */
{ 0x8697, -2, 4, { 0x03, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-87 ̞	# COMBINING DOWN TACK BELOW	[2000] */
{ 0x8698, -2, 4, { 0x03, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-88 ̘	# COMBINING LEFT TACK BELOW	[2000] */
{ 0x8699, -2, 4, { 0x03, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-89 ̙	# COMBINING RIGHT TACK BELOW	[2000] */
{ 0x869A, -2, 4, { 0x03, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-90 ̪	# COMBINING BRIDGE BELOW	[2000] */
{ 0x869B, -2, 4, { 0x03, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-91 ̺	# COMBINING INVERTED BRIDGE BELOW	[2000] */
{ 0x869C, -2, 4, { 0x03, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-92 ̻	# COMBINING SQUARE BELOW	[2000] */
{ 0x869D, -2, 4, { 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-93 ̃	# COMBINING TILDE	[2000] */
{ 0x869E, -2, 4, { 0x03, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-11-94 ̚	# COMBINING LEFT ANGLE ABOVE	[2000]	 */
{ 0x869F, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-01 ❶	# DINGBAT NEGATIVE CIRCLED DIGIT ONE	[2000]	 */
{ 0x86A0, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-02 ❷	# DINGBAT NEGATIVE CIRCLED DIGIT TWO	[2000]	 */
{ 0x86A1, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-03 ❸	# DINGBAT NEGATIVE CIRCLED DIGIT THREE	[2000]	 */
{ 0x86A2, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-04 ❹	# DINGBAT NEGATIVE CIRCLED DIGIT FOUR	[2000]	 */
{ 0x86A3, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-05 ❺	# DINGBAT NEGATIVE CIRCLED DIGIT FIVE	[2000]	 */
{ 0x86A4, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-06 ❻	# DINGBAT NEGATIVE CIRCLED DIGIT SIX	[2000]	 */
{ 0x86A5, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-07 ❼	# DINGBAT NEGATIVE CIRCLED DIGIT SEVEN	[2000]	 */
{ 0x86A6, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-08 ❽	# DINGBAT NEGATIVE CIRCLED DIGIT EIGHT	[2000]	 */
{ 0x86A7, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-09 ❾	# DINGBAT NEGATIVE CIRCLED DIGIT NINE	[2000]	 */
{ 0x86A8, -2, 5, { 0x02, 0x07, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-10 ❿	# DINGBAT NEGATIVE CIRCLED NUMBER TEN	[2000]	 */
{ 0x86A9, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-11 ⓫	# NEGATIVE CIRCLED NUMBER ELEVEN	[2000]	[Unicode3.2] */
{ 0x86AA, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-12 ⓬	# NEGATIVE CIRCLED NUMBER TWELVE	[2000]	[Unicode3.2] */
{ 0x86AB, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-13 ⓭	# NEGATIVE CIRCLED NUMBER THIRTEEN	[2000]	[Unicode3.2] */
{ 0x86AC, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-14 ⓮	# NEGATIVE CIRCLED NUMBER FOURTEEN	[2000]	[Unicode3.2] */
{ 0x86AD, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-15 ⓯	# NEGATIVE CIRCLED NUMBER FIFTEEN	[2000]	[Unicode3.2] */
{ 0x86AE, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-16 ⓰	# NEGATIVE CIRCLED NUMBER SIXTEEN	[2000]	[Unicode3.2] */
{ 0x86AF, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-17 ⓱	# NEGATIVE CIRCLED NUMBER SEVENTEEN	[2000]	[Unicode3.2] */
{ 0x86B0, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-18 ⓲	# NEGATIVE CIRCLED NUMBER EIGHTEEN	[2000]	[Unicode3.2] */
{ 0x86B1, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-19 ⓳	# NEGATIVE CIRCLED NUMBER NINETEEN	[2000]	[Unicode3.2] */
{ 0x86B2, -2, 5, { 0x02, 0x04, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-20 ⓴	# NEGATIVE CIRCLED NUMBER TWENTY	[2000]	[Unicode3.2] */
{ 0x86B3, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-21 ⅰ	# SMALL ROMAN NUMERAL ONE	[2000]	 */
{ 0x86B4, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-22 ⅱ	# SMALL ROMAN NUMERAL TWO	[2000]	 */
{ 0x86B5, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-23 ⅲ	# SMALL ROMAN NUMERAL THREE	[2000]	 */
{ 0x86B6, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-24 ⅳ	# SMALL ROMAN NUMERAL FOUR	[2000]	 */
{ 0x86B7, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-25 ⅴ	# SMALL ROMAN NUMERAL FIVE	[2000]	 */
{ 0x86B8, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-26 ⅵ	# SMALL ROMAN NUMERAL SIX	[2000]	 */
{ 0x86B9, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-27 ⅶ	# SMALL ROMAN NUMERAL SEVEN	[2000]	 */
{ 0x86BA, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-28 ⅷ	# SMALL ROMAN NUMERAL EIGHT	[2000]	 */
{ 0x86BB, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-29 ⅸ	# SMALL ROMAN NUMERAL NINE	[2000]	 */
{ 0x86BC, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-30 ⅹ	# SMALL ROMAN NUMERAL TEN	[2000]	 */
{ 0x86BD, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-31 ⅺ	# SMALL ROMAN NUMERAL ELEVEN	[2000]	 */
{ 0x86BE, -2, 5, { 0x02, 0x01, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-32 ⅻ	# SMALL ROMAN NUMERAL TWELVE	[2000] */
{ 0x86BF, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-33 ⓐ	# CIRCLED LATIN SMALL LETTER A	[2000] */
{ 0x86C0, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-34 ⓑ	# CIRCLED LATIN SMALL LETTER B	[2000] */
{ 0x86C1, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-35 ⓒ	# CIRCLED LATIN SMALL LETTER C	[2000] */
{ 0x86C2, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-36 ⓓ	# CIRCLED LATIN SMALL LETTER D	[2000] */
{ 0x86C3, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-37 ⓔ	# CIRCLED LATIN SMALL LETTER E	[2000] */
{ 0x86C4, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-38 ⓕ	# CIRCLED LATIN SMALL LETTER F	[2000] */
{ 0x86C5, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-39 ⓖ	# CIRCLED LATIN SMALL LETTER G	[2000] */
{ 0x86C6, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-40 ⓗ	# CIRCLED LATIN SMALL LETTER H	[2000] */
{ 0x86C7, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-41 ⓘ	# CIRCLED LATIN SMALL LETTER I	[2000] */
{ 0x86C8, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-42 ⓙ	# CIRCLED LATIN SMALL LETTER J	[2000] */
{ 0x86C9, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-43 ⓚ	# CIRCLED LATIN SMALL LETTER K	[2000] */
{ 0x86CA, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-44 ⓛ	# CIRCLED LATIN SMALL LETTER L	[2000] */
{ 0x86CB, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-45 ⓜ	# CIRCLED LATIN SMALL LETTER M	[2000] */
{ 0x86CC, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-46 ⓝ	# CIRCLED LATIN SMALL LETTER N	[2000] */
{ 0x86CD, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-47 ⓞ	# CIRCLED LATIN SMALL LETTER O	[2000] */
{ 0x86CE, -2, 5, { 0x02, 0x04, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-48 ⓟ	# CIRCLED LATIN SMALL LETTER P	[2000] */
{ 0x86CF, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-49 ⓠ	# CIRCLED LATIN SMALL LETTER Q	[2000] */
{ 0x86D0, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-50 ⓡ	# CIRCLED LATIN SMALL LETTER R	[2000] */
{ 0x86D1, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-51 ⓢ	# CIRCLED LATIN SMALL LETTER S	[2000] */
{ 0x86D2, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-52 ⓣ	# CIRCLED LATIN SMALL LETTER T	[2000] */
{ 0x86D3, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-53 ⓤ	# CIRCLED LATIN SMALL LETTER U	[2000] */
{ 0x86D4, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-54 ⓥ	# CIRCLED LATIN SMALL LETTER V	[2000] */
{ 0x86D5, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-55 ⓦ	# CIRCLED LATIN SMALL LETTER W	[2000] */
{ 0x86D6, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-56 ⓧ	# CIRCLED LATIN SMALL LETTER X	[2000] */
{ 0x86D7, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-57 ⓨ	# CIRCLED LATIN SMALL LETTER Y	[2000] */
{ 0x86D8, -2, 5, { 0x02, 0x04, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-58 ⓩ	# CIRCLED LATIN SMALL LETTER Z	[2000] */
{ 0x86D9, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-59 ㋐	# CIRCLED KATAKANA A	[2000] */
{ 0x86DA, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-60 ㋑	# CIRCLED KATAKANA I	[2000] */
{ 0x86DB, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-61 ㋒	# CIRCLED KATAKANA U	[2000] */
{ 0x86DC, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-62 ㋓	# CIRCLED KATAKANA E	[2000] */
{ 0x86DD, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-63 ㋔	# CIRCLED KATAKANA O	[2000] */
{ 0x86DE, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-64 ㋕	# CIRCLED KATAKANA KA	[2000] */
{ 0x86DF, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-65 ㋖	# CIRCLED KATAKANA KI	[2000] */
{ 0x86E0, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-66 ㋗	# CIRCLED KATAKANA KU	[2000] */
{ 0x86E1, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-67 ㋘	# CIRCLED KATAKANA KE	[2000] */
{ 0x86E2, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-68 ㋙	# CIRCLED KATAKANA KO	[2000] */
{ 0x86E3, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-69 ㋚	# CIRCLED KATAKANA SA	[2000] */
{ 0x86E4, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-70 ㋛	# CIRCLED KATAKANA SI	[2000] */
{ 0x86E5, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-71 ㋜	# CIRCLED KATAKANA SU	[2000] */
{ 0x86E6, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-72 ㋝	# CIRCLED KATAKANA SE	[2000] */
{ 0x86E7, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-73 ㋞	# CIRCLED KATAKANA SO	[2000] */
{ 0x86E8, -2, 5, { 0x03, 0x02, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-74 ㋟	# CIRCLED KATAKANA TA	[2000] */
{ 0x86E9, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-75 ㋠	# CIRCLED KATAKANA TI	[2000] */
{ 0x86EA, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-76 ㋡	# CIRCLED KATAKANA TU	[2000] */
{ 0x86EB, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-77 ㋢	# CIRCLED KATAKANA TE	[2000] */
{ 0x86EC, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-78 ㋣	# CIRCLED KATAKANA TO	[2000] */
{ 0x86ED, -2, 5, { 0x03, 0x02, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-79 ㋺	# CIRCLED KATAKANA RO	[2000] */
{ 0x86EE, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-80 ㋩	# CIRCLED KATAKANA HA	[2000]	 */
{ 0x86EF, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-81 ㋥	# CIRCLED KATAKANA NI	[2000]	 */
{ 0x86F0, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-82 ㋭	# CIRCLED KATAKANA HO	[2000]	 */
{ 0x86F1, -2, 5, { 0x03, 0x02, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-83 ㋬	# CIRCLED KATAKANA HE	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x86FB, -2, 5, { 0x02, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-93 ⁑	# TWO ASTERISKS ALIGNED VERTICALLY	[2000]	[Unicode3.2] */
{ 0x86FC, -2, 5, { 0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-12-94 ⁂	# ASTERISM	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8740, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-01 ①	# CIRCLED DIGIT ONE	[2000]	 */
{ 0x8741, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-02 ②	# CIRCLED DIGIT TWO	[2000] */
{ 0x8742, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-03 ③	# CIRCLED DIGIT THREE	[2000] */
{ 0x8743, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-04 ④	# CIRCLED DIGIT FOUR	[2000] */
{ 0x8744, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-05 ⑤	# CIRCLED DIGIT FIVE	[2000] */
{ 0x8745, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-06 ⑥	# CIRCLED DIGIT SIX	[2000] */
{ 0x8746, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-07 ⑦	# CIRCLED DIGIT SEVEN	[2000] */
{ 0x8747, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-08 ⑧	# CIRCLED DIGIT EIGHT	[2000] */
{ 0x8748, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-09 ⑨	# CIRCLED DIGIT NINE	[2000] */
{ 0x8749, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-10 ⑩	# CIRCLED NUMBER TEN	[2000] */
{ 0x874A, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-11 ⑪	# CIRCLED NUMBER ELEVEN	[2000] */
{ 0x874B, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-12 ⑫	# CIRCLED NUMBER TWELVE	[2000] */
{ 0x874C, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-13 ⑬	# CIRCLED NUMBER THIRTEEN	[2000] */
{ 0x874D, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-14 ⑭	# CIRCLED NUMBER FOURTEEN	[2000] */
{ 0x874E, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-15 ⑮	# CIRCLED NUMBER FIFTEEN	[2000] */
{ 0x874F, -2, 5, { 0x02, 0x04, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-16 ⑯	# CIRCLED NUMBER SIXTEEN	[2000] */
{ 0x8750, -2, 5, { 0x02, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-17 ⑰	# CIRCLED NUMBER SEVENTEEN	[2000] */
{ 0x8751, -2, 5, { 0x02, 0x04, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-18 ⑱	# CIRCLED NUMBER EIGHTEEN	[2000] */
{ 0x8752, -2, 5, { 0x02, 0x04, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-19 ⑲	# CIRCLED NUMBER NINETEEN	[2000] */
{ 0x8753, -2, 5, { 0x02, 0x04, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-20 ⑳	# CIRCLED NUMBER TWENTY	[2000] */
{ 0x8754, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-21 Ⅰ	# ROMAN NUMERAL ONE	[2000] */
{ 0x8755, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-22 Ⅱ	# ROMAN NUMERAL TWO	[2000] */
{ 0x8756, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-23 Ⅲ	# ROMAN NUMERAL THREE	[2000] */
{ 0x8757, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-24 Ⅳ	# ROMAN NUMERAL FOUR	[2000] */
{ 0x8758, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-25 Ⅴ	# ROMAN NUMERAL FIVE	[2000] */
{ 0x8759, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-26 Ⅵ	# ROMAN NUMERAL SIX	[2000] */
{ 0x875A, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-27 Ⅶ	# ROMAN NUMERAL SEVEN	[2000] */
{ 0x875B, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-28 Ⅷ	# ROMAN NUMERAL EIGHT	[2000] */
{ 0x875C, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-29 Ⅸ	# ROMAN NUMERAL NINE	[2000] */
{ 0x875D, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-30 Ⅹ	# ROMAN NUMERAL TEN	[2000] */
{ 0x875E, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-31 Ⅺ	# ROMAN NUMERAL ELEVEN	[2000] */
{ 0x875F, -2, 5, { 0x03, 0x03, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-32 ㍉	# SQUARE MIRI	[2000] */
{ 0x8760, -2, 5, { 0x03, 0x03, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-33 ㌔	# SQUARE KIRO	[2000] */
{ 0x8761, -2, 5, { 0x03, 0x03, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-34 ㌢	# SQUARE SENTI	[2000] */
{ 0x8762, -2, 5, { 0x03, 0x03, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-35 ㍍	# SQUARE MEETORU	[2000] */
{ 0x8763, -2, 5, { 0x03, 0x03, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-36 ㌘	# SQUARE GURAMU	[2000] */
{ 0x8764, -2, 5, { 0x03, 0x03, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-37 ㌧	# SQUARE TON	[2000] */
{ 0x8765, -2, 5, { 0x03, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-38 ㌃	# SQUARE AARU	[2000] */
{ 0x8766, -2, 5, { 0x03, 0x03, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-39 ㌶	# SQUARE HEKUTAARU	[2000] */
{ 0x8767, -2, 5, { 0x03, 0x03, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-40 ㍑	# SQUARE RITTORU	[2000] */
{ 0x8768, -2, 5, { 0x03, 0x03, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-41 ㍗	# SQUARE WATTO	[2000] */
{ 0x8769, -2, 5, { 0x03, 0x03, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-42 ㌍	# SQUARE KARORII	[2000] */
{ 0x876A, -2, 5, { 0x03, 0x03, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-43 ㌦	# SQUARE DORU	[2000] */
{ 0x876B, -2, 5, { 0x03, 0x03, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-44 ㌣	# SQUARE SENTO	[2000] */
{ 0x876C, -2, 5, { 0x03, 0x03, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-45 ㌫	# SQUARE PAASENTO	[2000] */
{ 0x876D, -2, 5, { 0x03, 0x03, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-46 ㍊	# SQUARE MIRIBAARU	[2000] */
{ 0x876E, -2, 5, { 0x03, 0x03, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-47 ㌻	# SQUARE PEEZI	[2000] */
{ 0x876F, -2, 5, { 0x03, 0x03, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-48 ㎜	# SQUARE MM	[2000] */
{ 0x8770, -2, 5, { 0x03, 0x03, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-49 ㎝	# SQUARE CM	[2000] */
{ 0x8771, -2, 5, { 0x03, 0x03, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-50 ㎞	# SQUARE KM	[2000] */
{ 0x8772, -2, 5, { 0x03, 0x03, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-51 ㎎	# SQUARE MG	[2000] */
{ 0x8773, -2, 5, { 0x03, 0x03, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-52 ㎏	# SQUARE KG	[2000] */
{ 0x8774, -2, 5, { 0x03, 0x03, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-53 ㏄	# SQUARE CC	[2000] */
{ 0x8775, -2, 5, { 0x03, 0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-54 ㎡	# SQUARE M SQUARED	[2000] */
{ 0x8776, -2, 5, { 0x02, 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-55 Ⅻ	# ROMAN NUMERAL TWELVE	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x877E, -2, 5, { 0x03, 0x03, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-63 ㍻	# SQUARE ERA NAME HEISEI	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8780, -2, 5, { 0x03, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-64 〝	# REVERSED DOUBLE PRIME QUOTATION MARK	[2000] */
{ 0x8781, -2, 5, { 0x03, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-65 〟	# LOW DOUBLE PRIME QUOTATION MARK	[2000] */
{ 0x8782, -2, 5, { 0x02, 0x01, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-66 №	# NUMERO SIGN	[2000] */
{ 0x8783, -2, 5, { 0x03, 0x03, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-67 ㏍	# SQUARE KK	[2000] */
{ 0x8784, -2, 5, { 0x02, 0x01, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-68 ℡	# TELEPHONE SIGN	[2000] */
{ 0x8785, -2, 5, { 0x03, 0x02, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-69 ㊤	# CIRCLED IDEOGRAPH HIGH	[2000] */
{ 0x8786, -2, 5, { 0x03, 0x02, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-70 ㊥	# CIRCLED IDEOGRAPH CENTRE	[2000] */
{ 0x8787, -2, 5, { 0x03, 0x02, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-71 ㊦	# CIRCLED IDEOGRAPH LOW	[2000] */
{ 0x8788, -2, 5, { 0x03, 0x02, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-72 ㊧	# CIRCLED IDEOGRAPH LEFT	[2000] */
{ 0x8789, -2, 5, { 0x03, 0x02, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-73 ㊨	# CIRCLED IDEOGRAPH RIGHT	[2000] */
{ 0x878A, -2, 5, { 0x03, 0x02, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-74 ㈱	# PARENTHESIZED IDEOGRAPH STOCK	[2000] */
{ 0x878B, -2, 5, { 0x03, 0x02, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-75 ㈲	# PARENTHESIZED IDEOGRAPH HAVE	[2000] */
{ 0x878C, -2, 5, { 0x03, 0x02, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-76 ㈹	# PARENTHESIZED IDEOGRAPH REPRESENT	[2000] */
{ 0x878D, -2, 5, { 0x03, 0x03, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-77 ㍾	# SQUARE ERA NAME MEIZI	[2000] */
{ 0x878E, -2, 5, { 0x03, 0x03, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-78 ㍽	# SQUARE ERA NAME TAISYOU	[2000] */
{ 0x878F, -2, 5, { 0x03, 0x03, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-79 ㍼	# SQUARE ERA NAME SYOUWA	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8793, -2, 5, { 0x02, 0x02, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-83 ∮	# CONTOUR INTEGRAL	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8798, -2, 5, { 0x02, 0x02, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-88 ∟	# RIGHT ANGLE	[2000]	 */
{ 0x8799, -2, 5, { 0x02, 0x02, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-89 ⊿	# RIGHT TRIANGLE	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x879D, -2, 5, { 0x02, 0x07, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-93 ❖	# BLACK DIAMOND MINUS WHITE X	[2000]	 */
{ 0x879E, -2, 5, { 0x02, 0x06, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-13-94 ☞	# WHITE RIGHT POINTING INDEX	[2000]	 */
{ 0x879F,  3, 5, { 0x04, 0x0f, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-01 俱	# [cjk]	[2004]	 */
{ 0x87A0,  3, 7, { 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00 }	},	/* 1-14-02 𠀋	# [cjk]	[2000]	[Unicode3.1] */
{ 0x87A1,  3, 5, { 0x03, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-03 㐂	# [cjk]	[2000]	 */
{ 0x87A2,  3, 5, { 0x04, 0x0e, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-04 丨	# [cjk]	[2000] */
{ 0x87A3,  3, 5, { 0x04, 0x0e, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-05 丯	# [cjk]	[2000] */
{ 0x87A4,  3, 5, { 0x04, 0x0e, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-06 丰	# [cjk]	[2000] */
{ 0x87A5,  3, 5, { 0x04, 0x0e, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-07 亍	# [cjk]	[2000] */
{ 0x87A6,  3, 5, { 0x04, 0x0e, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-08 仡	# [cjk]	[2000] */
{ 0x87A7,  3, 5, { 0x04, 0x0e, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-09 份	# [cjk]	[2000] */
{ 0x87A8,  3, 5, { 0x04, 0x0e, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-10 仿	# [cjk]	[2000] */
{ 0x87A9,  3, 5, { 0x04, 0x0f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-11 伃	# [cjk]	[2000] */
{ 0x87AA,  3, 5, { 0x04, 0x0f, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-12 伋	# [cjk]	[2000] */
{ 0x87AB,  3, 5, { 0x04, 0x0f, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-13 你	# [cjk]	[2000] */
{ 0x87AC,  3, 5, { 0x04, 0x0f, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-14 佈	# [cjk]	[2000] */
{ 0x87AD,  3, 5, { 0x04, 0x0f, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-15 佉	# [cjk]	[2000] */
{ 0x87AE,  3, 5, { 0x04, 0x0f, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-16 佖	# [cjk]	[2000] */
{ 0x87AF,  3, 5, { 0x04, 0x0f, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-17 佟	# [cjk]	[2000] */
{ 0x87B0,  3, 5, { 0x04, 0x0f, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-18 佪	# [cjk]	[2000] */
{ 0x87B1,  3, 5, { 0x04, 0x0f, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-19 佬	# [cjk]	[2000] */
{ 0x87B2,  3, 5, { 0x04, 0x0f, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-20 佾	# [cjk]	[2000]	 */
{ 0x87B3,  3, 5, { 0x04, 0x0f, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-21 侊	# [cjk]	[2000]	 */
{ 0x87B4,  3, 5, { 0x04, 0x0f, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-22 侔	# [cjk]	[2000]	 */
{ 0x87B5,  3, 5, { 0x04, 0x0f, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-23 侗	# [cjk]	[2000]	 */
{ 0x87B6,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-24 侮	# CJK COMPATIBILITY IDEOGRAPH-FA30	[2000]	[Unicode3.2] */
{ 0x87B7,  3, 5, { 0x04, 0x0f, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-25 俉	# [cjk]	[2000]	 */
{ 0x87B8,  3, 5, { 0x04, 0x0f, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-26 俠	# [cjk]	[2000]	 */
{ 0x87B9,  3, 5, { 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-27 倁	# [cjk]	[2000]	 */
{ 0x87BA,  3, 5, { 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-28 倂	# [cjk]	[2000]	 */
{ 0x87BB,  3, 5, { 0x05, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-29 倎	# [cjk]	[2000]	 */
{ 0x87BC,  3, 5, { 0x05, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-30 倘	# [cjk]	[2000]	 */
{ 0x87BD,  3, 5, { 0x05, 0x00, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-31 倧	# [cjk]	[2000]	 */
{ 0x87BE,  3, 5, { 0x05, 0x00, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-32 倮	# [cjk]	[2000]	 */
{ 0x87BF,  3, 5, { 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-33 偀	# [cjk]	[2000]	 */
{ 0x87C0,  3, 5, { 0x05, 0x00, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-34 倻	# [cjk]	[2000]	 */
{ 0x87C1,  3, 5, { 0x05, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-35 偁	# [cjk]	[2000]	 */
{ 0x87C2,  3, 5, { 0x05, 0x00, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-36 傔	# [cjk]	[2000]	 */
{ 0x87C3,  3, 5, { 0x05, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-37 僌	# [cjk]	[2000]	 */
{ 0x87C4,  3, 5, { 0x05, 0x00, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-38 僲	# [cjk]	[2000]	 */
{ 0x87C5,  3, 5, { 0x05, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-39 僐	# [cjk]	[2000]	 */
{ 0x87C6,  3, 5, { 0x05, 0x00, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-40 僦	# [cjk]	[2000]	 */
{ 0x87C7,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-41 僧	# CJK COMPATIBILITY IDEOGRAPH-FA31	[2000]	[Unicode3.2] */
{ 0x87C8,  3, 5, { 0x05, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-42 儆	# [cjk]	[2000]	 */
{ 0x87C9,  3, 5, { 0x05, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-43 儃	# [cjk]	[2000]	 */
{ 0x87CA,  3, 5, { 0x05, 0x01, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-44 儋	# [cjk]	[2000]	 */
{ 0x87CB,  3, 5, { 0x05, 0x01, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-45 儞	# [cjk]	[2000]	 */
{ 0x87CC,  3, 5, { 0x05, 0x01, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-46 儵	# [cjk]	[2000]	 */
{ 0x87CD,  3, 5, { 0x05, 0x01, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-47 兊	# [cjk]	[2000]	 */
{ 0x87CE,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-48 免	# CJK COMPATIBILITY IDEOGRAPH-FA32	[2000]	[Unicode3.2] */
{ 0x87CF,  3, 5, { 0x05, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-49 兕	# [cjk]	[2000]	 */
{ 0x87D0,  3, 5, { 0x05, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-50 兗	# [cjk]	[2000]	 */
{ 0x87D1,  3, 5, { 0x03, 0x04, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-51 㒵	# [cjk]	[2000]	 */
{ 0x87D2,  3, 5, { 0x05, 0x01, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-52 冝	# [cjk]	[2000]	 */
{ 0x87D3,  3, 5, { 0x05, 0x01, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-53 凃	# [cjk]	[2000]	 */
{ 0x87D4,  3, 5, { 0x05, 0x01, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-54 凊	# [cjk]	[2000]	 */
{ 0x87D5,  3, 5, { 0x05, 0x01, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-55 凞	# [cjk]	[2000]	 */
{ 0x87D6,  3, 5, { 0x05, 0x01, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-56 凢	# [cjk]	[2000]	 */
{ 0x87D7,  3, 5, { 0x05, 0x01, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-57 凮	# [cjk]	[2000]	 */
{ 0x87D8,  3, 5, { 0x05, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-58 刁	# [cjk]	[2000]	 */
{ 0x87D9,  3, 5, { 0x03, 0x04, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-59 㓛	# [cjk]	[2000]	 */
{ 0x87DA,  3, 5, { 0x05, 0x02, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-60 刓	# [cjk]	[2000]	 */
{ 0x87DB,  3, 5, { 0x05, 0x02, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-61 刕	# [cjk]	[2000]	 */
{ 0x87DC,  3, 5, { 0x05, 0x02, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-62 剉	# [cjk]	[2000]	 */
{ 0x87DD,  3, 5, { 0x05, 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-63 剗	# [cjk]	[2000]	 */
{ 0x87DE,  3, 5, { 0x05, 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-64 剡	# [cjk]	[2000]	 */
{ 0x87DF,  3, 5, { 0x05, 0x02, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-65 劓	# [cjk]	[2000]	 */
{ 0x87E0,  3, 5, { 0x05, 0x02, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-66 勈	# [cjk]	[2000]	 */
{ 0x87E1,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-67 勉	# CJK COMPATIBILITY IDEOGRAPH-FA33	[2000]	[Unicode3.2] */
{ 0x87E2,  3, 5, { 0x05, 0x02, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-68 勌	# [cjk]	[2000]	 */
{ 0x87E3,  3, 5, { 0x05, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-69 勐	# [cjk]	[2000]	 */
{ 0x87E4,  3, 5, { 0x05, 0x02, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-70 勖	# [cjk]	[2000]	 */
{ 0x87E5,  3, 5, { 0x05, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-71 勛	# [cjk]	[2000]	 */
{ 0x87E6,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-72 勤	# CJK COMPATIBILITY IDEOGRAPH-FA34	[2000]	[Unicode3.2] */
{ 0x87E7,  3, 5, { 0x05, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-73 勰	# [cjk]	[2000]	 */
{ 0x87E8,  3, 5, { 0x05, 0x02, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-74 勻	# [cjk]	[2000]	 */
{ 0x87E9,  3, 5, { 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-75 匀	# [cjk]	[2000]	 */
{ 0x87EA,  3, 5, { 0x05, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-76 匇	# [cjk]	[2000]	 */
{ 0x87EB,  3, 5, { 0x05, 0x03, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-77 匜	# [cjk]	[2000]	 */
{ 0x87EC,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-78 卑	# CJK COMPATIBILITY IDEOGRAPH-FA35	[2000]	[Unicode3.2] */
{ 0x87ED,  3, 5, { 0x05, 0x03, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-79 卡	# [cjk]	[2000]	 */
{ 0x87EE,  3, 5, { 0x05, 0x03, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-80 卣	# [cjk]	[2000]	 */
{ 0x87EF,  3, 5, { 0x05, 0x03, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-81 卽	# [cjk]	[2000]	 */
{ 0x87F0,  3, 5, { 0x05, 0x03, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-82 厓	# [cjk]	[2000]	 */
{ 0x87F1,  3, 5, { 0x05, 0x03, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-83 厝	# [cjk]	[2000]	 */
{ 0x87F2,  3, 5, { 0x05, 0x03, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-84 厲	# [cjk]	[2000] */
{ 0x87F3,  3, 5, { 0x05, 0x04, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-85 吒	# [cjk]	[2000] */
{ 0x87F4,  3, 5, { 0x05, 0x04, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-86 吧	# [cjk]	[2000] */
{ 0x87F5,  3, 5, { 0x05, 0x04, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-87 呍	# [cjk]	[2000] */
{ 0x87F6,  3, 5, { 0x05, 0x04, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-88 咜	# [cjk]	[2000] */
{ 0x87F7,  3, 5, { 0x05, 0x04, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-89 呫	# [cjk]	[2000] */
{ 0x87F8,  3, 5, { 0x05, 0x04, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-90 呴	# [cjk]	[2000] */
{ 0x87F9,  3, 5, { 0x05, 0x04, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-91 呿	# [cjk]	[2000] */
{ 0x87FA,  3, 5, { 0x05, 0x04, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-92 咈	# [cjk]	[2000] */
{ 0x87FB,  3, 5, { 0x05, 0x04, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-93 咖	# [cjk]	[2000] */
{ 0x87FC,  3, 5, { 0x05, 0x04, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-14-94 咡	# [cjk]	[2000] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8840,  3, 5, { 0x05, 0x04, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-01 咩	# [cjk]	[2000] */
{ 0x8841,  3, 5, { 0x05, 0x04, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-02 哆	# [cjk]	[2000] */
{ 0x8842,  3, 5, { 0x05, 0x04, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-03 哿	# [cjk]	[2000] */
{ 0x8843,  3, 5, { 0x05, 0x05, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-04 唎	# [cjk]	[2000] */
{ 0x8844,  3, 5, { 0x05, 0x05, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-05 唫	# [cjk]	[2000] */
{ 0x8845,  3, 5, { 0x05, 0x05, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-06 唵	# [cjk]	[2000]	 */
{ 0x8846,  3, 5, { 0x05, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-07 啐	# [cjk]	[2000]	 */
{ 0x8847,  3, 5, { 0x05, 0x05, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-08 啞	# [cjk]	[2000]	 */
{ 0x8848,  3, 5, { 0x05, 0x05, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-09 喁	# [cjk]	[2000]	 */
{ 0x8849,  3, 5, { 0x05, 0x05, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-10 喆	# [cjk]	[2000]	 */
{ 0x884A,  3, 5, { 0x05, 0x05, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-11 喎	# [cjk]	[2000]	 */
{ 0x884B,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-12 喝	# CJK COMPATIBILITY IDEOGRAPH-FA36	[2000]	[Unicode3.2] */
{ 0x884C,  3, 5, { 0x05, 0x05, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-13 喭	# [cjk]	[2000]	 */
{ 0x884D,  3, 5, { 0x05, 0x05, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-14 嗎	# [cjk]	[2000]	 */
{ 0x884E,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-15 嘆	# CJK COMPATIBILITY IDEOGRAPH-FA37	[2000]	[Unicode3.2] */
{ 0x884F,  3, 5, { 0x05, 0x06, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-16 嘈	# [cjk]	[2000]	 */
{ 0x8850,  3, 5, { 0x05, 0x06, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-17 嘎	# [cjk]	[2000]	 */
{ 0x8851,  3, 5, { 0x05, 0x06, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-18 嘻	# [cjk]	[2000]	 */
{ 0x8852,  3, 5, { 0x05, 0x06, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-19 噉	# [cjk]	[2000]	 */
{ 0x8853,  3, 5, { 0x05, 0x06, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-20 噶	# [cjk]	[2000]	 */
{ 0x8854,  3, 5, { 0x05, 0x06, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-21 噦	# [cjk]	[2000]	 */
{ 0x8855,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-22 器	# CJK COMPATIBILITY IDEOGRAPH-FA38	[2000]	[Unicode3.2] */
{ 0x8856,  3, 5, { 0x05, 0x06, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-23 噯	# [cjk]	[2000]	 */
{ 0x8857,  3, 5, { 0x05, 0x06, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-24 噱	# [cjk]	[2000]	 */
{ 0x8858,  3, 5, { 0x05, 0x06, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-25 噲	# [cjk]	[2000]	 */
{ 0x8859,  3, 5, { 0x05, 0x06, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-26 嚙	# [cjk]	[2000]	 */
{ 0x885A,  3, 5, { 0x05, 0x06, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-27 嚞	# [cjk]	[2000]	 */
{ 0x885B,  3, 5, { 0x05, 0x06, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-28 嚩	# [cjk]	[2000]	 */
{ 0x885C,  3, 5, { 0x05, 0x06, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-29 嚬	# [cjk]	[2000]	 */
{ 0x885D,  3, 5, { 0x05, 0x06, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-30 嚳	# [cjk]	[2000]	 */
{ 0x885E,  3, 5, { 0x05, 0x06, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-31 囉	# [cjk]	[2000]	 */
{ 0x885F,  3, 5, { 0x05, 0x06, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-32 囊	# [cjk]	[2000]	 */
{ 0x8860,  3, 5, { 0x05, 0x07, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-33 圊	# [cjk]	[2000]	 */
{ 0x8861,  3, 7, { 0x00, 0x02, 0x01, 0x00, 0x02, 0x00, 0x3d, 0x00, 0x00, 0x00 }	},	/* 1-15-34 𡈽	# [cjk]	[2000]	[Unicode3.1] */
{ 0x8862,  3, 5, { 0x05, 0x07, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-35 圡	# [cjk]	[2000]	 */
{ 0x8863,  3, 5, { 0x05, 0x07, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-36 圯	# [cjk]	[2000]	 */
{ 0x8864,  3, 5, { 0x05, 0x07, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-37 圳	# [cjk]	[2000]	 */
{ 0x8865,  3, 5, { 0x05, 0x07, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-38 圴	# [cjk]	[2000]	 */
{ 0x8866,  3, 5, { 0x05, 0x07, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-39 坰	# [cjk]	[2000]	 */
{ 0x8867,  3, 5, { 0x05, 0x07, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-40 坷	# [cjk]	[2000]	 */
{ 0x8868,  3, 5, { 0x05, 0x07, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-41 坼	# [cjk]	[2000]	 */
{ 0x8869,  3, 5, { 0x05, 0x07, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-42 垜	# [cjk]	[2000]	 */
{ 0x886A,  3, 5, { 0x0f, 0x0a, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-43 﨏	# CJK COMPATIBILITY IDEOGRAPH-FA0F	[2000]	 */
{ 0x886B,  3, 7, { 0x00, 0x02, 0x01, 0x00, 0x03, 0x00, 0x1b, 0x00, 0x00, 0x00 }	},	/* 1-15-44 𡌛	# [cjk]	[2000]	[Unicode3.1] */
{ 0x886C,  3, 5, { 0x05, 0x07, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-45 垸	# [cjk]	[2000]	 */
{ 0x886D,  3, 5, { 0x05, 0x07, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-46 埇	# [cjk]	[2000]	 */
{ 0x886E,  3, 5, { 0x05, 0x07, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-47 埈	# [cjk]	[2000]	 */
{ 0x886F,  3, 5, { 0x05, 0x07, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-48 埏	# [cjk]	[2000]	 */
{ 0x8870,  3, 5, { 0x05, 0x07, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-49 埤	# [cjk]	[2000]	 */
{ 0x8871,  3, 5, { 0x05, 0x07, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-50 埭	# [cjk]	[2000]	 */
{ 0x8872,  3, 5, { 0x05, 0x07, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-51 埵	# [cjk]	[2000]	 */
{ 0x8873,  3, 5, { 0x05, 0x07, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-52 埶	# [cjk]	[2000]	 */
{ 0x8874,  3, 5, { 0x05, 0x07, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-53 埿	# [cjk]	[2000]	 */
{ 0x8875,  3, 5, { 0x05, 0x08, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-54 堉	# [cjk]	[2000]	 */
{ 0x8876,  3, 5, { 0x0f, 0x0a, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-55 塚	# CJK COMPATIBILITY IDEOGRAPH-FA10	[2000]	 */
{ 0x8877,  3, 5, { 0x05, 0x08, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-56 塡	# [cjk]	[2000]	 */
{ 0x8878,  3, 5, { 0x05, 0x08, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-57 塤	# [cjk]	[2000]	 */
{ 0x8879,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-58 塀	# CJK COMPATIBILITY IDEOGRAPH-FA39	[2000]	[Unicode3.2] */
{ 0x887A,  3, 5, { 0x05, 0x08, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-59 塼	# [cjk]	[2000]	 */
{ 0x887B,  3, 5, { 0x05, 0x08, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-60 墉	# [cjk]	[2000]	 */
{ 0x887C,  3, 5, { 0x05, 0x08, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-61 增	# [cjk]	[2000]	 */
{ 0x887D,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-62 墨	# CJK COMPATIBILITY IDEOGRAPH-FA3A	[2000]	[Unicode3.2] */
{ 0x887E,  3, 5, { 0x05, 0x08, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-63 墩	# [cjk]	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8880,  3, 7, { 0x00, 0x02, 0x01, 0x01, 0x00, 0x01, 0x2e, 0x00, 0x00, 0x00 }	},	/* 1-15-64 𡑮	# [cjk]	[2000]	[Unicode3.1] */
{ 0x8881,  3, 5, { 0x05, 0x08, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-65 壒	# [cjk]	[2000]	 */
{ 0x8882,  3, 5, { 0x05, 0x08, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-66 壎	# [cjk]	[2000]	 */
{ 0x8883,  3, 5, { 0x05, 0x08, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-67 壔	# [cjk]	[2000]	 */
{ 0x8884,  3, 5, { 0x05, 0x08, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-68 壚	# [cjk]	[2000]	 */
{ 0x8885,  3, 5, { 0x05, 0x08, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-69 壠	# [cjk]	[2000]	 */
{ 0x8886,  3, 5, { 0x05, 0x08, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-70 壩	# [cjk]	[2000] */
{ 0x8887,  3, 5, { 0x05, 0x09, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-71 夌	# [cjk]	[2000] */
{ 0x8888,  3, 5, { 0x08, 0x06, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-72 虁	# [cjk]	[2000] */
{ 0x8889,  3, 5, { 0x05, 0x09, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-73 奝	# [cjk]	[2000] */
{ 0x888A,  3, 5, { 0x05, 0x09, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-74 奭	# [cjk]	[2000] */
{ 0x888B,  3, 5, { 0x05, 0x09, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-75 妋	# [cjk]	[2000] */
{ 0x888C,  3, 5, { 0x05, 0x09, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-76 妒	# [cjk]	[2000] */
{ 0x888D,  3, 5, { 0x05, 0x09, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-77 妤	# [cjk]	[2000] */
{ 0x888E,  3, 5, { 0x05, 0x09, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-78 姃	# [cjk]	[2000] */
{ 0x888F,  3, 5, { 0x05, 0x09, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-79 姒	# [cjk]	[2000] */
{ 0x8890,  3, 5, { 0x05, 0x09, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-80 姝	# [cjk]	[2000] */
{ 0x8891,  3, 5, { 0x05, 0x0a, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-81 娓	# [cjk]	[2000] */
{ 0x8892,  3, 5, { 0x05, 0x0a, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-82 娣	# [cjk]	[2000] */
{ 0x8893,  3, 5, { 0x05, 0x0a, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-83 婧	# [cjk]	[2000] */
{ 0x8894,  3, 5, { 0x05, 0x0a, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-84 婭	# [cjk]	[2000] */
{ 0x8895,  3, 5, { 0x05, 0x0a, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-85 婷	# [cjk]	[2000] */
{ 0x8896,  3, 5, { 0x05, 0x0a, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-86 婾	# [cjk]	[2000]	 */
{ 0x8897,  3, 5, { 0x05, 0x0a, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-87 媄	# [cjk]	[2000]	 */
{ 0x8898,  3, 5, { 0x05, 0x0a, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-88 媞	# [cjk]	[2000]	 */
{ 0x8899,  3, 5, { 0x05, 0x0a, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-89 媧	# [cjk]	[2000]	 */
{ 0x889A,  3, 5, { 0x05, 0x0a, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-90 嫄	# [cjk]	[2000]	 */
{ 0x889B,  3, 7, { 0x00, 0x02, 0x01, 0x02, 0x00, 0x02, 0x3d, 0x00, 0x00, 0x00 }	},	/* 1-15-91 𡢽	# [cjk]	[2000]	[Unicode3.1] */
{ 0x889C,  3, 5, { 0x05, 0x0b, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-92 嬙	# [cjk]	[2000]	 */
{ 0x889D,  3, 5, { 0x05, 0x0b, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-93 嬥	# [cjk]	[2000]	 */
{ 0x889E,  3, 5, { 0x05, 0x02, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-15-94 剝	# [cjk]	[2004]	 */
{ 0x889F,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-01 亜	# [cjk]		 */
{ 0x88A0,  1, 5, { 0x05, 0x05, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-02 唖	# [cjk]		 */
{ 0x88A1,  1, 5, { 0x05, 0x0a, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-03 娃	# [cjk]		 */
{ 0x88A2,  1, 5, { 0x09, 0x06, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-04 阿	# [cjk]		 */
{ 0x88A3,  1, 5, { 0x05, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-05 哀	# [cjk]		 */
{ 0x88A4,  1, 5, { 0x06, 0x01, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-06 愛	# [cjk]		 */
{ 0x88A5,  1, 5, { 0x06, 0x03, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-07 挨	# [cjk]		 */
{ 0x88A6,  1, 5, { 0x05, 0x09, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-08 姶	# [cjk] */
{ 0x88A7,  1, 5, { 0x09, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-09 逢	# [cjk] */
{ 0x88A8,  1, 5, { 0x08, 0x04, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-10 葵	# [cjk] */
{ 0x88A9,  1, 5, { 0x08, 0x03, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-11 茜	# [cjk] */
{ 0x88AA,  1, 5, { 0x07, 0x0a, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-12 穐	# [cjk] */
{ 0x88AB,  1, 5, { 0x06, 0x00, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-13 悪	# [cjk] */
{ 0x88AC,  1, 5, { 0x06, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-14 握	# [cjk] */
{ 0x88AD,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-15 渥	# [cjk] */
{ 0x88AE,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-16 旭	# [cjk] */
{ 0x88AF,  1, 5, { 0x08, 0x04, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-17 葦	# [cjk] */
{ 0x88B0,  1, 5, { 0x08, 0x02, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-18 芦	# [cjk] */
{ 0x88B1,  1, 5, { 0x09, 0x0b, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-19 鯵	# [cjk] */
{ 0x88B2,  1, 5, { 0x06, 0x08, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-20 梓	# [cjk] */
{ 0x88B3,  1, 5, { 0x05, 0x07, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-21 圧	# [cjk] */
{ 0x88B4,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-22 斡	# [cjk] */
{ 0x88B5,  1, 5, { 0x06, 0x02, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-23 扱	# [cjk] */
{ 0x88B6,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-24 宛	# [cjk] */
{ 0x88B7,  1, 5, { 0x05, 0x09, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-25 姐	# [cjk] */
{ 0x88B8,  1, 5, { 0x08, 0x06, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-26 虻	# [cjk] */
{ 0x88B9,  1, 5, { 0x09, 0x08, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-27 飴	# [cjk] */
{ 0x88BA,  1, 5, { 0x07, 0x0d, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-28 絢	# [cjk] */
{ 0x88BB,  1, 5, { 0x07, 0x0d, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-29 綾	# [cjk] */
{ 0x88BC,  1, 5, { 0x09, 0x0b, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-30 鮎	# [cjk] */
{ 0x88BD,  1, 5, { 0x06, 0x02, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-31 或	# [cjk] */
{ 0x88BE,  1, 5, { 0x07, 0x0c, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-32 粟	# [cjk] */
{ 0x88BF,  1, 5, { 0x08, 0x08, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-33 袷	# [cjk] */
{ 0x88C0,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-34 安	# [cjk] */
{ 0x88C1,  1, 5, { 0x05, 0x0e, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-35 庵	# [cjk] */
{ 0x88C2,  1, 5, { 0x06, 0x03, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-36 按	# [cjk] */
{ 0x88C3,  1, 5, { 0x06, 0x06, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-37 暗	# [cjk] */
{ 0x88C4,  1, 5, { 0x06, 0x08, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-38 案	# [cjk] */
{ 0x88C5,  1, 5, { 0x09, 0x05, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-39 闇	# [cjk] */
{ 0x88C6,  1, 5, { 0x09, 0x07, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-40 鞍	# [cjk] */
{ 0x88C7,  1, 5, { 0x06, 0x07, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-41 杏	# [cjk] */
{ 0x88C8,  1, 5, { 0x04, 0x0e, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-42 以	# [cjk] */
{ 0x88C9,  1, 5, { 0x04, 0x0f, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-43 伊	# [cjk] */
{ 0x88CA,  1, 5, { 0x04, 0x0f, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-44 位	# [cjk] */
{ 0x88CB,  1, 5, { 0x04, 0x0f, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-45 依	# [cjk] */
{ 0x88CC,  1, 5, { 0x05, 0x00, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-46 偉	# [cjk] */
{ 0x88CD,  1, 5, { 0x05, 0x06, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-47 囲	# [cjk] */
{ 0x88CE,  1, 5, { 0x05, 0x09, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-48 夷	# [cjk] */
{ 0x88CF,  1, 5, { 0x05, 0x09, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-49 委	# [cjk] */
{ 0x88D0,  1, 5, { 0x05, 0x0a, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-50 威	# [cjk] */
{ 0x88D1,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-51 尉	# [cjk] */
{ 0x88D2,  1, 5, { 0x06, 0x00, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-52 惟	# [cjk] */
{ 0x88D3,  1, 5, { 0x06, 0x01, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-53 意	# [cjk] */
{ 0x88D4,  1, 5, { 0x06, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-54 慰	# [cjk] */
{ 0x88D5,  1, 5, { 0x06, 0x06, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-55 易	# [cjk] */
{ 0x88D6,  1, 5, { 0x06, 0x09, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-56 椅	# [cjk] */
{ 0x88D7,  1, 5, { 0x07, 0x00, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-57 為	# [cjk] */
{ 0x88D8,  1, 5, { 0x07, 0x05, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-58 畏	# [cjk] */
{ 0x88D9,  1, 5, { 0x07, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-59 異	# [cjk] */
{ 0x88DA,  1, 5, { 0x07, 0x09, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-60 移	# [cjk] */
{ 0x88DB,  1, 5, { 0x07, 0x0d, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-61 維	# [cjk] */
{ 0x88DC,  1, 5, { 0x07, 0x0d, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-62 緯	# [cjk] */
{ 0x88DD,  1, 5, { 0x08, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-63 胃	# [cjk] */
{ 0x88DE,  1, 5, { 0x08, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-64 萎	# [cjk] */
{ 0x88DF,  1, 5, { 0x08, 0x08, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-65 衣	# [cjk] */
{ 0x88E0,  1, 5, { 0x08, 0x0b, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-66 謂	# [cjk] */
{ 0x88E1,  1, 5, { 0x09, 0x00, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-67 違	# [cjk] */
{ 0x88E2,  1, 5, { 0x09, 0x00, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-68 遺	# [cjk] */
{ 0x88E3,  1, 5, { 0x05, 0x03, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-69 医	# [cjk] */
{ 0x88E4,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-70 井	# [cjk] */
{ 0x88E5,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-71 亥	# [cjk] */
{ 0x88E6,  1, 5, { 0x05, 0x07, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-72 域	# [cjk] */
{ 0x88E7,  1, 5, { 0x08, 0x00, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-73 育	# [cjk] */
{ 0x88E8,  1, 5, { 0x09, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-74 郁	# [cjk] */
{ 0x88E9,  1, 5, { 0x07, 0x08, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-75 磯	# [cjk] */
{ 0x88EA,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-76 一	# [cjk] */
{ 0x88EB,  1, 5, { 0x05, 0x08, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-77 壱	# [cjk] */
{ 0x88EC,  1, 5, { 0x06, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-78 溢	# [cjk] */
{ 0x88ED,  1, 5, { 0x09, 0x00, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-79 逸	# [cjk] */
{ 0x88EE,  1, 5, { 0x07, 0x0a, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-80 稲	# [cjk] */
{ 0x88EF,  1, 5, { 0x08, 0x03, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-81 茨	# [cjk] */
{ 0x88F0,  1, 5, { 0x08, 0x02, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-82 芋	# [cjk] */
{ 0x88F1,  1, 5, { 0x09, 0x0c, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-83 鰯	# [cjk] */
{ 0x88F2,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-84 允	# [cjk] */
{ 0x88F3,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-85 印	# [cjk] */
{ 0x88F4,  1, 5, { 0x05, 0x04, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-86 咽	# [cjk] */
{ 0x88F5,  1, 5, { 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-87 員	# [cjk] */
{ 0x88F6,  1, 5, { 0x05, 0x06, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-88 因	# [cjk] */
{ 0x88F7,  1, 5, { 0x05, 0x09, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-89 姻	# [cjk] */
{ 0x88F8,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-90 引	# [cjk] */
{ 0x88F9,  1, 5, { 0x09, 0x08, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-91 飲	# [cjk] */
{ 0x88FA,  1, 5, { 0x06, 0x0d, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-92 淫	# [cjk] */
{ 0x88FB,  1, 5, { 0x08, 0x00, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-93 胤	# [cjk] */
{ 0x88FC,  1, 5, { 0x08, 0x05, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-16-94 蔭	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8940,  1, 5, { 0x09, 0x06, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-01 院	# [cjk] */
{ 0x8941,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-02 陰	# [cjk] */
{ 0x8942,  1, 5, { 0x09, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-03 隠	# [cjk] */
{ 0x8943,  1, 5, { 0x09, 0x07, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-04 韻	# [cjk] */
{ 0x8944,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-05 吋	# [cjk] */
{ 0x8945,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-06 右	# [cjk] */
{ 0x8946,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-07 宇	# [cjk] */
{ 0x8947,  1, 5, { 0x07, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-08 烏	# [cjk] */
{ 0x8948,  1, 5, { 0x07, 0x0f, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-09 羽	# [cjk] */
{ 0x8949,  1, 5, { 0x08, 0x0f, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-10 迂	# [cjk] */
{ 0x894A,  1, 5, { 0x09, 0x06, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-11 雨	# [cjk] */
{ 0x894B,  1, 5, { 0x05, 0x03, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-12 卯	# [cjk] */
{ 0x894C,  1, 5, { 0x09, 0x0d, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-13 鵜	# [cjk] */
{ 0x894D,  1, 5, { 0x07, 0x0a, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-14 窺	# [cjk] */
{ 0x894E,  1, 5, { 0x04, 0x0e, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-15 丑	# [cjk] */
{ 0x894F,  1, 5, { 0x07, 0x08, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-16 碓	# [cjk] */
{ 0x8950,  1, 5, { 0x08, 0x01, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-17 臼	# [cjk] */
{ 0x8951,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-18 渦	# [cjk] */
{ 0x8952,  1, 5, { 0x05, 0x06, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-19 嘘	# [cjk] */
{ 0x8953,  1, 5, { 0x05, 0x05, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-20 唄	# [cjk] */
{ 0x8954,  1, 5, { 0x06, 0x0b, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-21 欝	# [cjk] */
{ 0x8955,  1, 5, { 0x08, 0x05, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-22 蔚	# [cjk] */
{ 0x8956,  1, 5, { 0x09, 0x0c, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-23 鰻	# [cjk] */
{ 0x8957,  1, 5, { 0x05, 0x09, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-24 姥	# [cjk] */
{ 0x8958,  1, 5, { 0x05, 0x03, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-25 厩	# [cjk] */
{ 0x8959,  1, 5, { 0x06, 0x0d, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-26 浦	# [cjk] */
{ 0x895A,  1, 5, { 0x07, 0x04, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-27 瓜	# [cjk] */
{ 0x895B,  1, 5, { 0x09, 0x05, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-28 閏	# [cjk] */
{ 0x895C,  1, 5, { 0x05, 0x06, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-29 噂	# [cjk] */
{ 0x895D,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-30 云	# [cjk] */
{ 0x895E,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-31 運	# [cjk] */
{ 0x895F,  1, 5, { 0x09, 0x06, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-32 雲	# [cjk] */
{ 0x8960,  1, 5, { 0x08, 0x03, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-33 荏	# [cjk] */
{ 0x8961,  1, 5, { 0x09, 0x09, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-34 餌	# [cjk] */
{ 0x8962,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-35 叡	# [cjk] */
{ 0x8963,  1, 5, { 0x05, 0x05, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-36 営	# [cjk] */
{ 0x8964,  1, 5, { 0x05, 0x0b, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-37 嬰	# [cjk] */
{ 0x8965,  1, 5, { 0x05, 0x0f, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-38 影	# [cjk] */
{ 0x8966,  1, 5, { 0x06, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-39 映	# [cjk] */
{ 0x8967,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-40 曳	# [cjk] */
{ 0x8968,  1, 5, { 0x06, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-41 栄	# [cjk] */
{ 0x8969,  1, 5, { 0x06, 0x0c, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-42 永	# [cjk] */
{ 0x896A,  1, 5, { 0x06, 0x0c, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-43 泳	# [cjk] */
{ 0x896B,  1, 5, { 0x06, 0x0d, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-44 洩	# [cjk] */
{ 0x896C,  1, 5, { 0x07, 0x04, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-45 瑛	# [cjk] */
{ 0x896D,  1, 5, { 0x07, 0x06, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-46 盈	# [cjk] */
{ 0x896E,  1, 5, { 0x07, 0x0a, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-47 穎	# [cjk] */
{ 0x896F,  1, 5, { 0x09, 0x08, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-48 頴	# [cjk] */
{ 0x8970,  1, 5, { 0x08, 0x02, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-49 英	# [cjk] */
{ 0x8971,  1, 5, { 0x08, 0x08, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-50 衛	# [cjk] */
{ 0x8972,  1, 5, { 0x08, 0x0a, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-51 詠	# [cjk] */
{ 0x8973,  1, 5, { 0x09, 0x02, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-52 鋭	# [cjk] */
{ 0x8974,  1, 5, { 0x06, 0x0d, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-53 液	# [cjk] */
{ 0x8975,  1, 5, { 0x07, 0x05, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-54 疫	# [cjk] */
{ 0x8976,  1, 5, { 0x07, 0x06, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-55 益	# [cjk] */
{ 0x8977,  1, 5, { 0x09, 0x09, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-56 駅	# [cjk] */
{ 0x8978,  1, 5, { 0x06, 0x00, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-57 悦	# [cjk] */
{ 0x8979,  1, 5, { 0x08, 0x0b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-58 謁	# [cjk] */
{ 0x897A,  1, 5, { 0x08, 0x0d, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-59 越	# [cjk] */
{ 0x897B,  1, 5, { 0x09, 0x05, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-60 閲	# [cjk] */
{ 0x897C,  1, 5, { 0x06, 0x09, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-61 榎	# [cjk] */
{ 0x897D,  1, 5, { 0x05, 0x03, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-62 厭	# [cjk] */
{ 0x897E,  1, 5, { 0x05, 0x01, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-63 円	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8980,  1, 5, { 0x05, 0x07, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-64 園	# [cjk] */
{ 0x8981,  1, 5, { 0x05, 0x08, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-65 堰	# [cjk] */
{ 0x8982,  1, 5, { 0x05, 0x09, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-66 奄	# [cjk] */
{ 0x8983,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-67 宴	# [cjk] */
{ 0x8984,  1, 5, { 0x05, 0x0e, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-68 延	# [cjk] */
{ 0x8985,  1, 5, { 0x06, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-69 怨	# [cjk] */
{ 0x8986,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-70 掩	# [cjk] */
{ 0x8987,  1, 5, { 0x06, 0x03, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-71 援	# [cjk] */
{ 0x8988,  1, 5, { 0x06, 0x0c, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-72 沿	# [cjk] */
{ 0x8989,  1, 5, { 0x06, 0x0f, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-73 演	# [cjk] */
{ 0x898A,  1, 5, { 0x07, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-74 炎	# [cjk] */
{ 0x898B,  1, 5, { 0x07, 0x01, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-75 焔	# [cjk] */
{ 0x898C,  1, 5, { 0x07, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-76 煙	# [cjk] */
{ 0x898D,  1, 5, { 0x07, 0x01, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-77 燕	# [cjk] */
{ 0x898E,  1, 5, { 0x07, 0x03, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-78 猿	# [cjk] */
{ 0x898F,  1, 5, { 0x07, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-79 縁	# [cjk] */
{ 0x8990,  1, 5, { 0x08, 0x02, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-80 艶	# [cjk] */
{ 0x8991,  1, 5, { 0x08, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-81 苑	# [cjk] */
{ 0x8992,  1, 5, { 0x08, 0x05, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-82 薗	# [cjk] */
{ 0x8993,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-83 遠	# [cjk] */
{ 0x8994,  1, 5, { 0x09, 0x02, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-84 鉛	# [cjk] */
{ 0x8995,  1, 5, { 0x09, 0x0d, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-85 鴛	# [cjk] */
{ 0x8996,  1, 5, { 0x05, 0x08, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-86 塩	# [cjk] */
{ 0x8997,  1, 5, { 0x06, 0x05, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-87 於	# [cjk] */
{ 0x8998,  1, 5, { 0x06, 0x0c, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-88 汚	# [cjk] */
{ 0x8999,  1, 5, { 0x07, 0x05, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-89 甥	# [cjk] */
{ 0x899A,  1, 5, { 0x05, 0x01, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-90 凹	# [cjk] */
{ 0x899B,  1, 5, { 0x05, 0x09, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-91 央	# [cjk] */
{ 0x899C,  1, 5, { 0x05, 0x09, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-92 奥	# [cjk] */
{ 0x899D,  1, 5, { 0x05, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-93 往	# [cjk] */
{ 0x899E,  1, 5, { 0x05, 0x0f, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-17-94 応	# [cjk] */
{ 0x899F,  1, 5, { 0x06, 0x02, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-01 押	# [cjk] */
{ 0x89A0,  1, 5, { 0x06, 0x05, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-02 旺	# [cjk] */
{ 0x89A1,  1, 5, { 0x06, 0x0a, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-03 横	# [cjk] */
{ 0x89A2,  1, 5, { 0x06, 0x0b, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-04 欧	# [cjk] */
{ 0x89A3,  1, 5, { 0x06, 0x0b, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-05 殴	# [cjk] */
{ 0x89A4,  1, 5, { 0x07, 0x03, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-06 王	# [cjk] */
{ 0x89A5,  1, 5, { 0x07, 0x0f, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-07 翁	# [cjk] */
{ 0x89A6,  1, 5, { 0x08, 0x09, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-08 襖	# [cjk] */
{ 0x89A7,  1, 5, { 0x09, 0x0d, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-09 鴬	# [cjk] */
{ 0x89A8,  1, 5, { 0x09, 0x0d, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-10 鴎	# [cjk] */
{ 0x89A9,  1, 5, { 0x09, 0x0e, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-11 黄	# [cjk] */
{ 0x89AA,  1, 5, { 0x05, 0x0c, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-12 岡	# [cjk] */
{ 0x89AB,  1, 5, { 0x06, 0x0c, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-13 沖	# [cjk] */
{ 0x89AC,  1, 5, { 0x08, 0x03, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-14 荻	# [cjk] */
{ 0x89AD,  1, 5, { 0x05, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-15 億	# [cjk] */
{ 0x89AE,  1, 5, { 0x05, 0x0c, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-16 屋	# [cjk] */
{ 0x89AF,  1, 5, { 0x06, 0x01, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-17 憶	# [cjk] */
{ 0x89B0,  1, 5, { 0x08, 0x01, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-18 臆	# [cjk] */
{ 0x89B1,  1, 5, { 0x06, 0x08, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-19 桶	# [cjk] */
{ 0x89B2,  1, 5, { 0x07, 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-20 牡	# [cjk] */
{ 0x89B3,  1, 5, { 0x04, 0x0e, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-21 乙	# [cjk] */
{ 0x89B4,  1, 5, { 0x04, 0x0f, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-22 俺	# [cjk] */
{ 0x89B5,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-23 卸	# [cjk] */
{ 0x89B6,  1, 5, { 0x06, 0x00, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-24 恩	# [cjk] */
{ 0x89B7,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-25 温	# [cjk] */
{ 0x89B8,  1, 5, { 0x07, 0x0a, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-26 穏	# [cjk] */
{ 0x89B9,  1, 5, { 0x09, 0x07, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-27 音	# [cjk] */
{ 0x89BA,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-28 下	# [cjk] */
{ 0x89BB,  1, 5, { 0x05, 0x03, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-29 化	# [cjk] */
{ 0x89BC,  1, 5, { 0x04, 0x0e, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-30 仮	# [cjk] */
{ 0x89BD,  1, 5, { 0x04, 0x0f, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-31 何	# [cjk] */
{ 0x89BE,  1, 5, { 0x04, 0x0f, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-32 伽	# [cjk] */
{ 0x89BF,  1, 5, { 0x04, 0x0f, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-33 価	# [cjk] */
{ 0x89C0,  1, 5, { 0x04, 0x0f, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-34 佳	# [cjk] */
{ 0x89C1,  1, 5, { 0x05, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-35 加	# [cjk] */
{ 0x89C2,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-36 可	# [cjk] */
{ 0x89C3,  1, 5, { 0x05, 0x06, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-37 嘉	# [cjk] */
{ 0x89C4,  1, 5, { 0x05, 0x09, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-38 夏	# [cjk] */
{ 0x89C5,  1, 5, { 0x05, 0x0a, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-39 嫁	# [cjk] */
{ 0x89C6,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-40 家	# [cjk] */
{ 0x89C7,  1, 5, { 0x05, 0x0b, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-41 寡	# [cjk] */
{ 0x89C8,  1, 5, { 0x07, 0x09, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-42 科	# [cjk] */
{ 0x89C9,  1, 5, { 0x06, 0x06, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-43 暇	# [cjk] */
{ 0x89CA,  1, 5, { 0x06, 0x07, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-44 果	# [cjk] */
{ 0x89CB,  1, 5, { 0x06, 0x07, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-45 架	# [cjk] */
{ 0x89CC,  1, 5, { 0x06, 0x0b, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-46 歌	# [cjk] */
{ 0x89CD,  1, 5, { 0x06, 0x0c, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-47 河	# [cjk] */
{ 0x89CE,  1, 5, { 0x07, 0x00, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-48 火	# [cjk] */
{ 0x89CF,  1, 5, { 0x07, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-49 珂	# [cjk] */
{ 0x89D0,  1, 5, { 0x07, 0x09, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-50 禍	# [cjk] */
{ 0x89D1,  1, 5, { 0x07, 0x09, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-51 禾	# [cjk] */
{ 0x89D2,  1, 5, { 0x07, 0x0a, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-52 稼	# [cjk] */
{ 0x89D3,  1, 5, { 0x07, 0x0b, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-53 箇	# [cjk] */
{ 0x89D4,  1, 5, { 0x08, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-54 花	# [cjk] */
{ 0x89D5,  1, 5, { 0x08, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-55 苛	# [cjk] */
{ 0x89D6,  1, 5, { 0x08, 0x03, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-56 茄	# [cjk] */
{ 0x89D7,  1, 5, { 0x08, 0x03, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-57 荷	# [cjk] */
{ 0x89D8,  1, 5, { 0x08, 0x03, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-58 華	# [cjk] */
{ 0x89D9,  1, 5, { 0x08, 0x03, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-59 菓	# [cjk] */
{ 0x89DA,  1, 5, { 0x08, 0x07, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-60 蝦	# [cjk] */
{ 0x89DB,  1, 5, { 0x08, 0x0a, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-61 課	# [cjk] */
{ 0x89DC,  1, 5, { 0x05, 0x06, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-62 嘩	# [cjk] */
{ 0x89DD,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-63 貨	# [cjk] */
{ 0x89DE,  1, 5, { 0x08, 0x0f, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-64 迦	# [cjk] */
{ 0x89DF,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-65 過	# [cjk] */
{ 0x89E0,  1, 5, { 0x09, 0x07, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-66 霞	# [cjk] */
{ 0x89E1,  1, 5, { 0x08, 0x06, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-67 蚊	# [cjk] */
{ 0x89E2,  1, 5, { 0x04, 0x0f, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-68 俄	# [cjk] */
{ 0x89E3,  1, 5, { 0x05, 0x0c, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-69 峨	# [cjk] */
{ 0x89E4,  1, 5, { 0x06, 0x02, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-70 我	# [cjk] */
{ 0x89E5,  1, 5, { 0x07, 0x02, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-71 牙	# [cjk] */
{ 0x89E6,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-72 画	# [cjk] */
{ 0x89E7,  1, 5, { 0x08, 0x01, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-73 臥	# [cjk] */
{ 0x89E8,  1, 5, { 0x08, 0x02, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-74 芽	# [cjk] */
{ 0x89E9,  1, 5, { 0x08, 0x06, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-75 蛾	# [cjk] */
{ 0x89EA,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-76 賀	# [cjk] */
{ 0x89EB,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-77 雅	# [cjk] */
{ 0x89EC,  1, 5, { 0x09, 0x09, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-78 餓	# [cjk] */
{ 0x89ED,  1, 5, { 0x09, 0x09, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-79 駕	# [cjk] */
{ 0x89EE,  1, 5, { 0x04, 0x0e, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-80 介	# [cjk] */
{ 0x89EF,  1, 5, { 0x04, 0x0f, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-81 会	# [cjk] */
{ 0x89F0,  1, 5, { 0x08, 0x09, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-82 解	# [cjk] */
{ 0x89F1,  1, 5, { 0x05, 0x06, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-83 回	# [cjk] */
{ 0x89F2,  1, 5, { 0x05, 0x08, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-84 塊	# [cjk] */
{ 0x89F3,  1, 5, { 0x05, 0x08, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-85 壊	# [cjk] */
{ 0x89F4,  1, 5, { 0x05, 0x0e, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-86 廻	# [cjk] */
{ 0x89F5,  1, 5, { 0x05, 0x0f, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-87 快	# [cjk] */
{ 0x89F6,  1, 5, { 0x06, 0x00, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-88 怪	# [cjk] */
{ 0x89F7,  1, 5, { 0x06, 0x00, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-89 悔	# [cjk] */
{ 0x89F8,  1, 5, { 0x06, 0x00, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-90 恢	# [cjk] */
{ 0x89F9,  1, 5, { 0x06, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-91 懐	# [cjk] */
{ 0x89FA,  1, 5, { 0x06, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-92 戒	# [cjk] */
{ 0x89FB,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-93 拐	# [cjk] */
{ 0x89FC,  1, 5, { 0x06, 0x05, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-18-94 改	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8A40,  1, 5, { 0x09, 0x0b, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-01 魁	# [cjk] */
{ 0x8A41,  1, 5, { 0x06, 0x06, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-02 晦	# [cjk] */
{ 0x8A42,  1, 5, { 0x06, 0x08, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-03 械	# [cjk] */
{ 0x8A43,  1, 5, { 0x06, 0x0d, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-04 海	# [cjk] */
{ 0x8A44,  1, 5, { 0x07, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-05 灰	# [cjk] */
{ 0x8A45,  1, 5, { 0x07, 0x05, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-06 界	# [cjk] */
{ 0x8A46,  1, 5, { 0x07, 0x06, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-07 皆	# [cjk] */
{ 0x8A47,  1, 5, { 0x07, 0x0d, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-08 絵	# [cjk] */
{ 0x8A48,  1, 5, { 0x08, 0x02, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-09 芥	# [cjk] */
{ 0x8A49,  1, 5, { 0x08, 0x07, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-10 蟹	# [cjk] */
{ 0x8A4A,  1, 5, { 0x09, 0x05, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-11 開	# [cjk] */
{ 0x8A4B,  1, 5, { 0x09, 0x06, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-12 階	# [cjk] */
{ 0x8A4C,  1, 5, { 0x08, 0x0c, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-13 貝	# [cjk] */
{ 0x8A4D,  1, 5, { 0x05, 0x01, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-14 凱	# [cjk] */
{ 0x8A4E,  1, 5, { 0x05, 0x02, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-15 劾	# [cjk] */
{ 0x8A4F,  1, 5, { 0x05, 0x09, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-16 外	# [cjk] */
{ 0x8A50,  1, 5, { 0x05, 0x04, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-17 咳	# [cjk] */
{ 0x8A51,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-18 害	# [cjk] */
{ 0x8A52,  1, 5, { 0x05, 0x0d, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-19 崖	# [cjk] */
{ 0x8A53,  1, 5, { 0x06, 0x01, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-20 慨	# [cjk] */
{ 0x8A54,  1, 5, { 0x06, 0x09, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-21 概	# [cjk] */
{ 0x8A55,  1, 5, { 0x06, 0x0d, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-22 涯	# [cjk] */
{ 0x8A56,  1, 5, { 0x07, 0x08, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-23 碍	# [cjk] */
{ 0x8A57,  1, 5, { 0x08, 0x04, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-24 蓋	# [cjk] */
{ 0x8A58,  1, 5, { 0x08, 0x08, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-25 街	# [cjk] */
{ 0x8A59,  1, 5, { 0x08, 0x0a, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-26 該	# [cjk] */
{ 0x8A5A,  1, 5, { 0x09, 0x03, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-27 鎧	# [cjk] */
{ 0x8A5B,  1, 5, { 0x09, 0x0a, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-28 骸	# [cjk] */
{ 0x8A5C,  1, 5, { 0x06, 0x0d, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-29 浬	# [cjk] */
{ 0x8A5D,  1, 5, { 0x09, 0x09, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-30 馨	# [cjk] */
{ 0x8A5E,  1, 5, { 0x08, 0x06, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-31 蛙	# [cjk] */
{ 0x8A5F,  1, 5, { 0x05, 0x07, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-32 垣	# [cjk] */
{ 0x8A60,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-33 柿	# [cjk] */
{ 0x8A61,  1, 5, { 0x08, 0x06, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-34 蛎	# [cjk] */
{ 0x8A62,  1, 5, { 0x09, 0x02, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-35 鈎	# [cjk] */
{ 0x8A63,  1, 5, { 0x05, 0x02, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-36 劃	# [cjk] */
{ 0x8A64,  1, 5, { 0x05, 0x06, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-37 嚇	# [cjk] */
{ 0x8A65,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-38 各	# [cjk] */
{ 0x8A66,  1, 5, { 0x05, 0x0e, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-39 廓	# [cjk] */
{ 0x8A67,  1, 5, { 0x06, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-40 拡	# [cjk] */
{ 0x8A68,  1, 5, { 0x06, 0x04, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-41 撹	# [cjk] */
{ 0x8A69,  1, 5, { 0x06, 0x08, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-42 格	# [cjk] */
{ 0x8A6A,  1, 5, { 0x06, 0x08, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-43 核	# [cjk] */
{ 0x8A6B,  1, 5, { 0x06, 0x0b, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-44 殻	# [cjk] */
{ 0x8A6C,  1, 5, { 0x07, 0x03, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-45 獲	# [cjk] */
{ 0x8A6D,  1, 5, { 0x07, 0x08, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-46 確	# [cjk] */
{ 0x8A6E,  1, 5, { 0x07, 0x0a, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-47 穫	# [cjk] */
{ 0x8A6F,  1, 5, { 0x08, 0x09, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-48 覚	# [cjk] */
{ 0x8A70,  1, 5, { 0x08, 0x09, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-49 角	# [cjk] */
{ 0x8A71,  1, 5, { 0x08, 0x0d, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-50 赫	# [cjk] */
{ 0x8A72,  1, 5, { 0x08, 0x0f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-51 較	# [cjk] */
{ 0x8A73,  1, 5, { 0x09, 0x00, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-52 郭	# [cjk] */
{ 0x8A74,  1, 5, { 0x09, 0x05, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-53 閣	# [cjk] */
{ 0x8A75,  1, 5, { 0x09, 0x06, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-54 隔	# [cjk] */
{ 0x8A76,  1, 5, { 0x09, 0x07, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-55 革	# [cjk] */
{ 0x8A77,  1, 5, { 0x05, 0x0b, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-56 学	# [cjk] */
{ 0x8A78,  1, 5, { 0x05, 0x0c, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-57 岳	# [cjk] */
{ 0x8A79,  1, 5, { 0x06, 0x09, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-58 楽	# [cjk] */
{ 0x8A7A,  1, 5, { 0x09, 0x08, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-59 額	# [cjk] */
{ 0x8A7B,  1, 5, { 0x09, 0x08, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-60 顎	# [cjk] */
{ 0x8A7C,  1, 5, { 0x06, 0x03, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-61 掛	# [cjk] */
{ 0x8A7D,  1, 5, { 0x07, 0x0b, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-62 笠	# [cjk] */
{ 0x8A7E,  1, 5, { 0x06, 0x0a, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-63 樫	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8A80,  1, 5, { 0x06, 0x0a, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-64 橿	# [cjk] */
{ 0x8A81,  1, 5, { 0x06, 0x08, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-65 梶	# [cjk] */
{ 0x8A82,  1, 5, { 0x09, 0x0c, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-66 鰍	# [cjk] */
{ 0x8A83,  1, 5, { 0x06, 0x0f, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-67 潟	# [cjk] */
{ 0x8A84,  1, 5, { 0x05, 0x02, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-68 割	# [cjk] */
{ 0x8A85,  1, 5, { 0x05, 0x05, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-69 喝	# [cjk] */
{ 0x8A86,  1, 5, { 0x06, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-70 恰	# [cjk] */
{ 0x8A87,  1, 5, { 0x06, 0x02, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-71 括	# [cjk] */
{ 0x8A88,  1, 5, { 0x06, 0x0d, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-72 活	# [cjk] */
{ 0x8A89,  1, 5, { 0x06, 0x0e, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-73 渇	# [cjk] */
{ 0x8A8A,  1, 5, { 0x06, 0x0e, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-74 滑	# [cjk] */
{ 0x8A8B,  1, 5, { 0x08, 0x04, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-75 葛	# [cjk] */
{ 0x8A8C,  1, 5, { 0x08, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-76 褐	# [cjk] */
{ 0x8A8D,  1, 5, { 0x08, 0x0f, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-77 轄	# [cjk] */
{ 0x8A8E,  1, 5, { 0x04, 0x0e, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-78 且	# [cjk] */
{ 0x8A8F,  1, 5, { 0x09, 0x0c, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-79 鰹	# [cjk] */
{ 0x8A90,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-80 叶	# [cjk] */
{ 0x8A91,  1, 5, { 0x06, 0x09, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-81 椛	# [cjk] */
{ 0x8A92,  1, 5, { 0x06, 0x0a, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-82 樺	# [cjk] */
{ 0x8A93,  1, 5, { 0x09, 0x07, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-83 鞄	# [cjk] */
{ 0x8A94,  1, 5, { 0x06, 0x08, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-84 株	# [cjk] */
{ 0x8A95,  1, 5, { 0x05, 0x01, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-85 兜	# [cjk] */
{ 0x8A96,  1, 5, { 0x07, 0x0a, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-86 竃	# [cjk] */
{ 0x8A97,  1, 5, { 0x08, 0x04, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-87 蒲	# [cjk] */
{ 0x8A98,  1, 5, { 0x09, 0x01, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-88 釜	# [cjk] */
{ 0x8A99,  1, 5, { 0x09, 0x03, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-89 鎌	# [cjk] */
{ 0x8A9A,  1, 5, { 0x05, 0x06, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-90 噛	# [cjk] */
{ 0x8A9B,  1, 5, { 0x09, 0x0d, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-91 鴨	# [cjk] */
{ 0x8A9C,  1, 5, { 0x06, 0x08, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-92 栢	# [cjk] */
{ 0x8A9D,  1, 5, { 0x08, 0x03, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-93 茅	# [cjk] */
{ 0x8A9E,  1, 5, { 0x08, 0x04, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-19-94 萱	# [cjk] */
{ 0x8A9F,  1, 5, { 0x07, 0x0c, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-01 粥	# [cjk] */
{ 0x8AA0,  1, 5, { 0x05, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-02 刈	# [cjk] */
{ 0x8AA1,  1, 5, { 0x08, 0x02, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-03 苅	# [cjk] */
{ 0x8AA2,  1, 5, { 0x07, 0x04, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-04 瓦	# [cjk] */
{ 0x8AA3,  1, 5, { 0x04, 0x0e, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-05 乾	# [cjk] */
{ 0x8AA4,  1, 5, { 0x04, 0x0f, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-06 侃	# [cjk] */
{ 0x8AA5,  1, 5, { 0x05, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-07 冠	# [cjk] */
{ 0x8AA6,  1, 5, { 0x05, 0x0b, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-08 寒	# [cjk] */
{ 0x8AA7,  1, 5, { 0x05, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-09 刊	# [cjk] */
{ 0x8AA8,  1, 5, { 0x05, 0x02, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-10 勘	# [cjk] */
{ 0x8AA9,  1, 5, { 0x05, 0x02, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-11 勧	# [cjk] */
{ 0x8AAA,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-12 巻	# [cjk] */
{ 0x8AAB,  1, 5, { 0x05, 0x05, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-13 喚	# [cjk] */
{ 0x8AAC,  1, 5, { 0x05, 0x08, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-14 堪	# [cjk] */
{ 0x8AAD,  1, 5, { 0x05, 0x09, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-15 姦	# [cjk] */
{ 0x8AAE,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-16 完	# [cjk] */
{ 0x8AAF,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-17 官	# [cjk] */
{ 0x8AB0,  1, 5, { 0x05, 0x0b, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-18 寛	# [cjk] */
{ 0x8AB1,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-19 干	# [cjk] */
{ 0x8AB2,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-20 幹	# [cjk] */
{ 0x8AB3,  1, 5, { 0x06, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-21 患	# [cjk] */
{ 0x8AB4,  1, 5, { 0x06, 0x01, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-22 感	# [cjk] */
{ 0x8AB5,  1, 5, { 0x06, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-23 慣	# [cjk] */
{ 0x8AB6,  1, 5, { 0x06, 0x01, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-24 憾	# [cjk] */
{ 0x8AB7,  1, 5, { 0x06, 0x03, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-25 換	# [cjk] */
{ 0x8AB8,  1, 5, { 0x06, 0x05, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-26 敢	# [cjk] */
{ 0x8AB9,  1, 5, { 0x06, 0x07, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-27 柑	# [cjk] */
{ 0x8ABA,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-28 桓	# [cjk] */
{ 0x8ABB,  1, 5, { 0x06, 0x08, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-29 棺	# [cjk] */
{ 0x8ABC,  1, 5, { 0x06, 0x0b, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-30 款	# [cjk] */
{ 0x8ABD,  1, 5, { 0x06, 0x0b, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-31 歓	# [cjk] */
{ 0x8ABE,  1, 5, { 0x06, 0x0c, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-32 汗	# [cjk] */
{ 0x8ABF,  1, 5, { 0x06, 0x0f, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-33 漢	# [cjk] */
{ 0x8AC0,  1, 5, { 0x06, 0x0f, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-34 澗	# [cjk] */
{ 0x8AC1,  1, 5, { 0x06, 0x0f, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-35 潅	# [cjk] */
{ 0x8AC2,  1, 5, { 0x07, 0x04, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-36 環	# [cjk] */
{ 0x8AC3,  1, 5, { 0x07, 0x05, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-37 甘	# [cjk] */
{ 0x8AC4,  1, 5, { 0x07, 0x06, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-38 監	# [cjk] */
{ 0x8AC5,  1, 5, { 0x07, 0x07, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-39 看	# [cjk] */
{ 0x8AC6,  1, 5, { 0x07, 0x0a, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-40 竿	# [cjk] */
{ 0x8AC7,  1, 5, { 0x07, 0x0b, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-41 管	# [cjk] */
{ 0x8AC8,  1, 5, { 0x07, 0x0c, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-42 簡	# [cjk] */
{ 0x8AC9,  1, 5, { 0x07, 0x0d, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-43 緩	# [cjk] */
{ 0x8ACA,  1, 5, { 0x07, 0x0f, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-44 缶	# [cjk] */
{ 0x8ACB,  1, 5, { 0x07, 0x0f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-45 翰	# [cjk] */
{ 0x8ACC,  1, 5, { 0x08, 0x00, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-46 肝	# [cjk] */
{ 0x8ACD,  1, 5, { 0x08, 0x02, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-47 艦	# [cjk] */
{ 0x8ACE,  1, 5, { 0x08, 0x03, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-48 莞	# [cjk] */
{ 0x8ACF,  1, 5, { 0x08, 0x09, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-49 観	# [cjk] */
{ 0x8AD0,  1, 5, { 0x08, 0x0a, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-50 諌	# [cjk] */
{ 0x8AD1,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-51 貫	# [cjk] */
{ 0x8AD2,  1, 5, { 0x09, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-52 還	# [cjk] */
{ 0x8AD3,  1, 5, { 0x09, 0x04, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-53 鑑	# [cjk] */
{ 0x8AD4,  1, 5, { 0x09, 0x05, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-54 間	# [cjk] */
{ 0x8AD5,  1, 5, { 0x09, 0x05, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-55 閑	# [cjk] */
{ 0x8AD6,  1, 5, { 0x09, 0x05, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-56 関	# [cjk] */
{ 0x8AD7,  1, 5, { 0x09, 0x06, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-57 陥	# [cjk] */
{ 0x8AD8,  1, 5, { 0x09, 0x07, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-58 韓	# [cjk] */
{ 0x8AD9,  1, 5, { 0x09, 0x09, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-59 館	# [cjk] */
{ 0x8ADA,  1, 5, { 0x08, 0x02, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-60 舘	# [cjk] */
{ 0x8ADB,  1, 5, { 0x04, 0x0e, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-61 丸	# [cjk] */
{ 0x8ADC,  1, 5, { 0x05, 0x04, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-62 含	# [cjk] */
{ 0x8ADD,  1, 5, { 0x05, 0x0c, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-63 岸	# [cjk] */
{ 0x8ADE,  1, 5, { 0x05, 0x0d, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-64 巌	# [cjk] */
{ 0x8ADF,  1, 5, { 0x07, 0x03, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-65 玩	# [cjk] */
{ 0x8AE0,  1, 5, { 0x07, 0x06, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-66 癌	# [cjk] */
{ 0x8AE1,  1, 5, { 0x07, 0x07, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-67 眼	# [cjk] */
{ 0x8AE2,  1, 5, { 0x05, 0x0c, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-68 岩	# [cjk] */
{ 0x8AE3,  1, 5, { 0x07, 0x0f, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-69 翫	# [cjk] */
{ 0x8AE4,  1, 5, { 0x08, 0x0d, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-70 贋	# [cjk] */
{ 0x8AE5,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-71 雁	# [cjk] */
{ 0x8AE6,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-72 頑	# [cjk] */
{ 0x8AE7,  1, 5, { 0x09, 0x08, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-73 顔	# [cjk] */
{ 0x8AE8,  1, 5, { 0x09, 0x08, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-74 願	# [cjk] */
{ 0x8AE9,  1, 5, { 0x04, 0x0f, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-75 企	# [cjk] */
{ 0x8AEA,  1, 5, { 0x04, 0x0f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-76 伎	# [cjk] */
{ 0x8AEB,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-77 危	# [cjk] */
{ 0x8AEC,  1, 5, { 0x05, 0x05, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-78 喜	# [cjk] */
{ 0x8AED,  1, 5, { 0x05, 0x06, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-79 器	# [cjk] */
{ 0x8AEE,  1, 5, { 0x05, 0x07, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-80 基	# [cjk] */
{ 0x8AEF,  1, 5, { 0x05, 0x09, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-81 奇	# [cjk] */
{ 0x8AF0,  1, 5, { 0x05, 0x0b, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-82 嬉	# [cjk] */
{ 0x8AF1,  1, 5, { 0x05, 0x0b, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-83 寄	# [cjk] */
{ 0x8AF2,  1, 5, { 0x05, 0x0c, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-84 岐	# [cjk] */
{ 0x8AF3,  1, 5, { 0x05, 0x0e, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-85 希	# [cjk] */
{ 0x8AF4,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-86 幾	# [cjk] */
{ 0x8AF5,  1, 5, { 0x05, 0x0f, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-87 忌	# [cjk] */
{ 0x8AF6,  1, 5, { 0x06, 0x03, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-88 揮	# [cjk] */
{ 0x8AF7,  1, 5, { 0x06, 0x07, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-89 机	# [cjk] */
{ 0x8AF8,  1, 5, { 0x06, 0x05, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-90 旗	# [cjk] */
{ 0x8AF9,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-91 既	# [cjk] */
{ 0x8AFA,  1, 5, { 0x06, 0x07, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-92 期	# [cjk] */
{ 0x8AFB,  1, 5, { 0x06, 0x08, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-93 棋	# [cjk] */
{ 0x8AFC,  1, 5, { 0x06, 0x08, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-20-94 棄	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8B40,  1, 5, { 0x06, 0x0a, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-01 機	# [cjk] */
{ 0x8B41,  1, 5, { 0x05, 0x0e, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-02 帰	# [cjk] */
{ 0x8B42,  1, 5, { 0x06, 0x0b, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-03 毅	# [cjk] */
{ 0x8B43,  1, 5, { 0x06, 0x0c, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-04 気	# [cjk] */
{ 0x8B44,  1, 5, { 0x06, 0x0c, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-05 汽	# [cjk] */
{ 0x8B45,  1, 5, { 0x07, 0x05, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-06 畿	# [cjk] */
{ 0x8B46,  1, 5, { 0x07, 0x09, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-07 祈	# [cjk] */
{ 0x8B47,  1, 5, { 0x05, 0x0b, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-08 季	# [cjk] */
{ 0x8B48,  1, 5, { 0x07, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-09 稀	# [cjk] */
{ 0x8B49,  1, 5, { 0x07, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-10 紀	# [cjk] */
{ 0x8B4A,  1, 5, { 0x05, 0x0f, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-11 徽	# [cjk] */
{ 0x8B4B,  1, 5, { 0x08, 0x09, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-12 規	# [cjk] */
{ 0x8B4C,  1, 5, { 0x08, 0x0a, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-13 記	# [cjk] */
{ 0x8B4D,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-14 貴	# [cjk] */
{ 0x8B4E,  1, 5, { 0x08, 0x0d, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-15 起	# [cjk] */
{ 0x8B4F,  1, 5, { 0x08, 0x0e, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-16 軌	# [cjk] */
{ 0x8B50,  1, 5, { 0x08, 0x0f, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-17 輝	# [cjk] */
{ 0x8B51,  1, 5, { 0x09, 0x08, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-18 飢	# [cjk] */
{ 0x8B52,  1, 5, { 0x09, 0x0a, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-19 騎	# [cjk] */
{ 0x8B53,  1, 5, { 0x09, 0x0b, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-20 鬼	# [cjk] */
{ 0x8B54,  1, 5, { 0x04, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-21 亀	# [cjk] */
{ 0x8B55,  1, 5, { 0x05, 0x00, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-22 偽	# [cjk] */
{ 0x8B56,  1, 5, { 0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-23 儀	# [cjk] */
{ 0x8B57,  1, 5, { 0x05, 0x09, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-24 妓	# [cjk] */
{ 0x8B58,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-25 宜	# [cjk] */
{ 0x8B59,  1, 5, { 0x06, 0x02, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-26 戯	# [cjk] */
{ 0x8B5A,  1, 5, { 0x06, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-27 技	# [cjk] */
{ 0x8B5B,  1, 5, { 0x06, 0x04, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-28 擬	# [cjk] */
{ 0x8B5C,  1, 5, { 0x06, 0x0b, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-29 欺	# [cjk] */
{ 0x8B5D,  1, 5, { 0x07, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-30 犠	# [cjk] */
{ 0x8B5E,  1, 5, { 0x07, 0x05, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-31 疑	# [cjk] */
{ 0x8B5F,  1, 5, { 0x07, 0x09, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-32 祇	# [cjk] */
{ 0x8B60,  1, 5, { 0x07, 0x0f, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-33 義	# [cjk] */
{ 0x8B61,  1, 5, { 0x08, 0x07, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-34 蟻	# [cjk] */
{ 0x8B62,  1, 5, { 0x08, 0x0a, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-35 誼	# [cjk] */
{ 0x8B63,  1, 5, { 0x08, 0x0b, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-36 議	# [cjk] */
{ 0x8B64,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-37 掬	# [cjk] */
{ 0x8B65,  1, 5, { 0x08, 0x03, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-38 菊	# [cjk] */
{ 0x8B66,  1, 5, { 0x09, 0x07, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-39 鞠	# [cjk] */
{ 0x8B67,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-40 吉	# [cjk] */
{ 0x8B68,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-41 吃	# [cjk] */
{ 0x8B69,  1, 5, { 0x05, 0x05, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-42 喫	# [cjk] */
{ 0x8B6A,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-43 桔	# [cjk] */
{ 0x8B6B,  1, 5, { 0x06, 0x0a, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-44 橘	# [cjk] */
{ 0x8B6C,  1, 5, { 0x08, 0x0a, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-45 詰	# [cjk] */
{ 0x8B6D,  1, 5, { 0x07, 0x08, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-46 砧	# [cjk] */
{ 0x8B6E,  1, 5, { 0x06, 0x07, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-47 杵	# [cjk] */
{ 0x8B6F,  1, 5, { 0x09, 0x0e, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-48 黍	# [cjk] */
{ 0x8B70,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-49 却	# [cjk] */
{ 0x8B71,  1, 5, { 0x05, 0x0b, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-50 客	# [cjk] */
{ 0x8B72,  1, 5, { 0x08, 0x01, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-51 脚	# [cjk] */
{ 0x8B73,  1, 5, { 0x08, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-52 虐	# [cjk] */
{ 0x8B74,  1, 5, { 0x09, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-53 逆	# [cjk] */
{ 0x8B75,  1, 5, { 0x04, 0x0e, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-54 丘	# [cjk] */
{ 0x8B76,  1, 5, { 0x04, 0x0e, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-55 久	# [cjk] */
{ 0x8B77,  1, 5, { 0x04, 0x0e, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-56 仇	# [cjk] */
{ 0x8B78,  1, 5, { 0x04, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-57 休	# [cjk] */
{ 0x8B79,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-58 及	# [cjk] */
{ 0x8B7A,  1, 5, { 0x05, 0x04, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-59 吸	# [cjk] */
{ 0x8B7B,  1, 5, { 0x05, 0x0b, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-60 宮	# [cjk] */
{ 0x8B7C,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-61 弓	# [cjk] */
{ 0x8B7D,  1, 5, { 0x06, 0x00, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-62 急	# [cjk] */
{ 0x8B7E,  1, 5, { 0x06, 0x05, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-63 救	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8B80,  1, 5, { 0x06, 0x07, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-64 朽	# [cjk] */
{ 0x8B81,  1, 5, { 0x06, 0x0c, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-65 求	# [cjk] */
{ 0x8B82,  1, 5, { 0x06, 0x0c, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-66 汲	# [cjk] */
{ 0x8B83,  1, 5, { 0x06, 0x0c, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-67 泣	# [cjk] */
{ 0x8B84,  1, 5, { 0x07, 0x00, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-68 灸	# [cjk] */
{ 0x8B85,  1, 5, { 0x07, 0x04, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-69 球	# [cjk] */
{ 0x8B86,  1, 5, { 0x07, 0x0a, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-70 究	# [cjk] */
{ 0x8B87,  1, 5, { 0x07, 0x0a, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-71 窮	# [cjk] */
{ 0x8B88,  1, 5, { 0x07, 0x0b, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-72 笈	# [cjk] */
{ 0x8B89,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-73 級	# [cjk] */
{ 0x8B8A,  1, 5, { 0x07, 0x0c, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-74 糾	# [cjk] */
{ 0x8B8B,  1, 5, { 0x07, 0x0d, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-75 給	# [cjk] */
{ 0x8B8C,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-76 旧	# [cjk] */
{ 0x8B8D,  1, 5, { 0x07, 0x02, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-77 牛	# [cjk] */
{ 0x8B8E,  1, 5, { 0x05, 0x03, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-78 去	# [cjk] */
{ 0x8B8F,  1, 5, { 0x05, 0x0c, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-79 居	# [cjk] */
{ 0x8B90,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-80 巨	# [cjk] */
{ 0x8B91,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-81 拒	# [cjk] */
{ 0x8B92,  1, 5, { 0x06, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-82 拠	# [cjk] */
{ 0x8B93,  1, 5, { 0x06, 0x03, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-83 挙	# [cjk] */
{ 0x8B94,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-84 渠	# [cjk] */
{ 0x8B95,  1, 5, { 0x08, 0x06, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-85 虚	# [cjk] */
{ 0x8B96,  1, 5, { 0x08, 0x0a, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-86 許	# [cjk] */
{ 0x8B97,  1, 5, { 0x08, 0x0d, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-87 距	# [cjk] */
{ 0x8B98,  1, 5, { 0x09, 0x02, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-88 鋸	# [cjk] */
{ 0x8B99,  1, 5, { 0x06, 0x0f, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-89 漁	# [cjk] */
{ 0x8B9A,  1, 5, { 0x07, 0x09, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-90 禦	# [cjk] */
{ 0x8B9B,  1, 5, { 0x09, 0x0b, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-91 魚	# [cjk] */
{ 0x8B9C,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-92 亨	# [cjk] */
{ 0x8B9D,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-93 享	# [cjk] */
{ 0x8B9E,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-21-94 京	# [cjk] */
{ 0x8B9F,  1, 5, { 0x04, 0x0f, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-01 供	# [cjk] */
{ 0x8BA0,  1, 5, { 0x04, 0x0f, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-02 侠	# [cjk] */
{ 0x8BA1,  1, 5, { 0x05, 0x00, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-03 僑	# [cjk] */
{ 0x8BA2,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-04 兇	# [cjk] */
{ 0x8BA3,  1, 5, { 0x07, 0x0a, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-05 競	# [cjk] */
{ 0x8BA4,  1, 5, { 0x05, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-06 共	# [cjk] */
{ 0x8BA5,  1, 5, { 0x05, 0x01, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-07 凶	# [cjk] */
{ 0x8BA6,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-08 協	# [cjk] */
{ 0x8BA7,  1, 5, { 0x05, 0x03, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-09 匡	# [cjk] */
{ 0x8BA8,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-10 卿	# [cjk] */
{ 0x8BA9,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-11 叫	# [cjk] */
{ 0x8BAA,  1, 5, { 0x05, 0x05, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-12 喬	# [cjk] */
{ 0x8BAB,  1, 5, { 0x05, 0x08, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-13 境	# [cjk] */
{ 0x8BAC,  1, 5, { 0x05, 0x0c, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-14 峡	# [cjk] */
{ 0x8BAD,  1, 5, { 0x05, 0x0f, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-15 強	# [cjk] */
{ 0x8BAE,  1, 5, { 0x05, 0x0f, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-16 彊	# [cjk] */
{ 0x8BAF,  1, 5, { 0x06, 0x00, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-17 怯	# [cjk] */
{ 0x8BB0,  1, 5, { 0x06, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-18 恐	# [cjk] */
{ 0x8BB1,  1, 5, { 0x06, 0x00, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-19 恭	# [cjk] */
{ 0x8BB2,  1, 5, { 0x06, 0x03, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-20 挟	# [cjk] */
{ 0x8BB3,  1, 5, { 0x06, 0x05, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-21 教	# [cjk] */
{ 0x8BB4,  1, 5, { 0x06, 0x0a, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-22 橋	# [cjk] */
{ 0x8BB5,  1, 5, { 0x06, 0x0c, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-23 況	# [cjk] */
{ 0x8BB6,  1, 5, { 0x07, 0x02, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-24 狂	# [cjk] */
{ 0x8BB7,  1, 5, { 0x07, 0x02, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-25 狭	# [cjk] */
{ 0x8BB8,  1, 5, { 0x07, 0x07, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-26 矯	# [cjk] */
{ 0x8BB9,  1, 5, { 0x08, 0x00, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-27 胸	# [cjk] */
{ 0x8BBA,  1, 5, { 0x08, 0x01, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-28 脅	# [cjk] */
{ 0x8BBB,  1, 5, { 0x08, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-29 興	# [cjk] */
{ 0x8BBC,  1, 5, { 0x08, 0x05, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-30 蕎	# [cjk] */
{ 0x8BBD,  1, 5, { 0x09, 0x00, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-31 郷	# [cjk] */
{ 0x8BBE,  1, 5, { 0x09, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-32 鏡	# [cjk] */
{ 0x8BBF,  1, 5, { 0x09, 0x07, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-33 響	# [cjk] */
{ 0x8BC0,  1, 5, { 0x09, 0x09, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-34 饗	# [cjk] */
{ 0x8BC1,  1, 5, { 0x09, 0x0a, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-35 驚	# [cjk] */
{ 0x8BC2,  1, 5, { 0x04, 0x0e, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-36 仰	# [cjk] */
{ 0x8BC3,  1, 5, { 0x05, 0x01, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-37 凝	# [cjk] */
{ 0x8BC4,  1, 5, { 0x05, 0x0c, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-38 尭	# [cjk] */
{ 0x8BC5,  1, 5, { 0x06, 0x06, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-39 暁	# [cjk] */
{ 0x8BC6,  1, 5, { 0x06, 0x09, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-40 業	# [cjk] */
{ 0x8BC7,  1, 5, { 0x05, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-41 局	# [cjk] */
{ 0x8BC8,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-42 曲	# [cjk] */
{ 0x8BC9,  1, 5, { 0x06, 0x09, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-43 極	# [cjk] */
{ 0x8BCA,  1, 5, { 0x07, 0x03, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-44 玉	# [cjk] */
{ 0x8BCB,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-45 桐	# [cjk] */
{ 0x8BCC,  1, 5, { 0x07, 0x0c, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-46 粁	# [cjk] */
{ 0x8BCD,  1, 5, { 0x05, 0x00, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-47 僅	# [cjk] */
{ 0x8BCE,  1, 5, { 0x05, 0x02, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-48 勤	# [cjk] */
{ 0x8BCF,  1, 5, { 0x05, 0x07, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-49 均	# [cjk] */
{ 0x8BD0,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-50 巾	# [cjk] */
{ 0x8BD1,  1, 5, { 0x09, 0x03, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-51 錦	# [cjk] */
{ 0x8BD2,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-52 斤	# [cjk] */
{ 0x8BD3,  1, 5, { 0x06, 0x0b, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-53 欣	# [cjk] */
{ 0x8BD4,  1, 5, { 0x06, 0x0b, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-54 欽	# [cjk] */
{ 0x8BD5,  1, 5, { 0x07, 0x04, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-55 琴	# [cjk] */
{ 0x8BD6,  1, 5, { 0x07, 0x09, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-56 禁	# [cjk] */
{ 0x8BD7,  1, 5, { 0x07, 0x09, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-57 禽	# [cjk] */
{ 0x8BD8,  1, 5, { 0x07, 0x0b, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-58 筋	# [cjk] */
{ 0x8BD9,  1, 5, { 0x07, 0x0d, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-59 緊	# [cjk] */
{ 0x8BDA,  1, 5, { 0x08, 0x02, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-60 芹	# [cjk] */
{ 0x8BDB,  1, 5, { 0x08, 0x03, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-61 菌	# [cjk] */
{ 0x8BDC,  1, 5, { 0x08, 0x08, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-62 衿	# [cjk] */
{ 0x8BDD,  1, 5, { 0x08, 0x09, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-63 襟	# [cjk] */
{ 0x8BDE,  1, 5, { 0x08, 0x0b, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-64 謹	# [cjk] */
{ 0x8BDF,  1, 5, { 0x08, 0x0f, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-65 近	# [cjk] */
{ 0x8BE0,  1, 5, { 0x09, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-66 金	# [cjk] */
{ 0x8BE1,  1, 5, { 0x05, 0x04, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-67 吟	# [cjk] */
{ 0x8BE2,  1, 5, { 0x09, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-68 銀	# [cjk] */
{ 0x8BE3,  1, 5, { 0x04, 0x0e, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-69 九	# [cjk] */
{ 0x8BE4,  1, 5, { 0x05, 0x00, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-70 倶	# [cjk] */
{ 0x8BE5,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-71 句	# [cjk] */
{ 0x8BE6,  1, 5, { 0x05, 0x03, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-72 区	# [cjk] */
{ 0x8BE7,  1, 5, { 0x07, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-73 狗	# [cjk] */
{ 0x8BE8,  1, 5, { 0x07, 0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-74 玖	# [cjk] */
{ 0x8BE9,  1, 5, { 0x07, 0x07, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-75 矩	# [cjk] */
{ 0x8BEA,  1, 5, { 0x08, 0x02, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-76 苦	# [cjk] */
{ 0x8BEB,  1, 5, { 0x08, 0x0e, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-77 躯	# [cjk] */
{ 0x8BEC,  1, 5, { 0x09, 0x09, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-78 駆	# [cjk] */
{ 0x8BED,  1, 5, { 0x09, 0x09, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-79 駈	# [cjk] */
{ 0x8BEE,  1, 5, { 0x09, 0x09, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-80 駒	# [cjk] */
{ 0x8BEF,  1, 5, { 0x05, 0x01, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-81 具	# [cjk] */
{ 0x8BF0,  1, 5, { 0x06, 0x01, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-82 愚	# [cjk] */
{ 0x8BF1,  1, 5, { 0x08, 0x06, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-83 虞	# [cjk] */
{ 0x8BF2,  1, 5, { 0x05, 0x05, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-84 喰	# [cjk] */
{ 0x8BF3,  1, 5, { 0x07, 0x0a, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-85 空	# [cjk] */
{ 0x8BF4,  1, 5, { 0x05, 0x00, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-86 偶	# [cjk] */
{ 0x8BF5,  1, 5, { 0x05, 0x0b, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-87 寓	# [cjk] */
{ 0x8BF6,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-88 遇	# [cjk] */
{ 0x8BF7,  1, 5, { 0x09, 0x06, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-89 隅	# [cjk] */
{ 0x8BF8,  1, 5, { 0x04, 0x0e, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-90 串	# [cjk] */
{ 0x8BF9,  1, 5, { 0x06, 0x0a, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-91 櫛	# [cjk] */
{ 0x8BFA,  1, 5, { 0x09, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-92 釧	# [cjk] */
{ 0x8BFB,  1, 5, { 0x05, 0x0c, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-93 屑	# [cjk] */
{ 0x8BFC,  1, 5, { 0x05, 0x0c, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-22-94 屈	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8C40,  1, 5, { 0x06, 0x03, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-01 掘	# [cjk] */
{ 0x8C41,  1, 5, { 0x07, 0x0a, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-02 窟	# [cjk] */
{ 0x8C42,  1, 5, { 0x06, 0x0c, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-03 沓	# [cjk] */
{ 0x8C43,  1, 5, { 0x09, 0x07, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-04 靴	# [cjk] */
{ 0x8C44,  1, 5, { 0x08, 0x0f, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-05 轡	# [cjk] */
{ 0x8C45,  1, 5, { 0x07, 0x0a, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-06 窪	# [cjk] */
{ 0x8C46,  1, 5, { 0x07, 0x01, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-07 熊	# [cjk] */
{ 0x8C47,  1, 5, { 0x09, 0x06, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-08 隈	# [cjk] */
{ 0x8C48,  1, 5, { 0x07, 0x0c, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-09 粂	# [cjk] */
{ 0x8C49,  1, 5, { 0x06, 0x08, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-10 栗	# [cjk] */
{ 0x8C4A,  1, 5, { 0x07, 0x0e, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-11 繰	# [cjk] */
{ 0x8C4B,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-12 桑	# [cjk] */
{ 0x8C4C,  1, 5, { 0x09, 0x03, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-13 鍬	# [cjk] */
{ 0x8C4D,  1, 5, { 0x05, 0x02, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-14 勲	# [cjk] */
{ 0x8C4E,  1, 5, { 0x05, 0x04, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-15 君	# [cjk] */
{ 0x8C4F,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-16 薫	# [cjk] */
{ 0x8C50,  1, 5, { 0x08, 0x0a, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-17 訓	# [cjk] */
{ 0x8C51,  1, 5, { 0x07, 0x0f, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-18 群	# [cjk] */
{ 0x8C52,  1, 5, { 0x08, 0x0e, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-19 軍	# [cjk] */
{ 0x8C53,  1, 5, { 0x09, 0x00, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-20 郡	# [cjk] */
{ 0x8C54,  1, 5, { 0x05, 0x03, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-21 卦	# [cjk] */
{ 0x8C55,  1, 5, { 0x08, 0x08, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-22 袈	# [cjk] */
{ 0x8C56,  1, 5, { 0x07, 0x09, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-23 祁	# [cjk] */
{ 0x8C57,  1, 5, { 0x04, 0x0f, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-24 係	# [cjk] */
{ 0x8C58,  1, 5, { 0x05, 0x00, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-25 傾	# [cjk] */
{ 0x8C59,  1, 5, { 0x05, 0x02, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-26 刑	# [cjk] */
{ 0x8C5A,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-27 兄	# [cjk] */
{ 0x8C5B,  1, 5, { 0x05, 0x05, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-28 啓	# [cjk] */
{ 0x8C5C,  1, 5, { 0x05, 0x07, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-29 圭	# [cjk] */
{ 0x8C5D,  1, 5, { 0x07, 0x03, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-30 珪	# [cjk] */
{ 0x8C5E,  1, 5, { 0x05, 0x07, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-31 型	# [cjk] */
{ 0x8C5F,  1, 5, { 0x05, 0x09, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-32 契	# [cjk] */
{ 0x8C60,  1, 5, { 0x05, 0x0f, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-33 形	# [cjk] */
{ 0x8C61,  1, 5, { 0x05, 0x0f, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-34 径	# [cjk] */
{ 0x8C62,  1, 5, { 0x06, 0x00, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-35 恵	# [cjk] */
{ 0x8C63,  1, 5, { 0x06, 0x01, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-36 慶	# [cjk] */
{ 0x8C64,  1, 5, { 0x06, 0x01, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-37 慧	# [cjk] */
{ 0x8C65,  1, 5, { 0x06, 0x01, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-38 憩	# [cjk] */
{ 0x8C66,  1, 5, { 0x06, 0x03, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-39 掲	# [cjk] */
{ 0x8C67,  1, 5, { 0x06, 0x04, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-40 携	# [cjk] */
{ 0x8C68,  1, 5, { 0x06, 0x05, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-41 敬	# [cjk] */
{ 0x8C69,  1, 5, { 0x06, 0x06, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-42 景	# [cjk] */
{ 0x8C6A,  1, 5, { 0x06, 0x08, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-43 桂	# [cjk] */
{ 0x8C6B,  1, 5, { 0x06, 0x0e, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-44 渓	# [cjk] */
{ 0x8C6C,  1, 5, { 0x07, 0x05, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-45 畦	# [cjk] */
{ 0x8C6D,  1, 5, { 0x07, 0x0a, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-46 稽	# [cjk] */
{ 0x8C6E,  1, 5, { 0x07, 0x0c, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-47 系	# [cjk] */
{ 0x8C6F,  1, 5, { 0x07, 0x0d, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-48 経	# [cjk] */
{ 0x8C70,  1, 5, { 0x07, 0x0d, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-49 継	# [cjk] */
{ 0x8C71,  1, 5, { 0x07, 0x0e, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-50 繋	# [cjk] */
{ 0x8C72,  1, 5, { 0x07, 0x0f, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-51 罫	# [cjk] */
{ 0x8C73,  1, 5, { 0x08, 0x03, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-52 茎	# [cjk] */
{ 0x8C74,  1, 5, { 0x08, 0x03, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-53 荊	# [cjk] */
{ 0x8C75,  1, 5, { 0x08, 0x06, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-54 蛍	# [cjk] */
{ 0x8C76,  1, 5, { 0x08, 0x0a, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-55 計	# [cjk] */
{ 0x8C77,  1, 5, { 0x08, 0x0a, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-56 詣	# [cjk] */
{ 0x8C78,  1, 5, { 0x08, 0x0b, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-57 警	# [cjk] */
{ 0x8C79,  1, 5, { 0x08, 0x0e, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-58 軽	# [cjk] */
{ 0x8C7A,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-59 頚	# [cjk] */
{ 0x8C7B,  1, 5, { 0x09, 0x0d, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-60 鶏	# [cjk] */
{ 0x8C7C,  1, 5, { 0x08, 0x02, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-61 芸	# [cjk] */
{ 0x8C7D,  1, 5, { 0x08, 0x0f, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-62 迎	# [cjk] */
{ 0x8C7E,  1, 5, { 0x09, 0x0b, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-63 鯨	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8C80,  1, 5, { 0x05, 0x02, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-64 劇	# [cjk] */
{ 0x8C81,  1, 5, { 0x06, 0x02, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-65 戟	# [cjk] */
{ 0x8C82,  1, 5, { 0x06, 0x04, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-66 撃	# [cjk] */
{ 0x8C83,  1, 5, { 0x06, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-67 激	# [cjk] */
{ 0x8C84,  1, 5, { 0x09, 0x06, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-68 隙	# [cjk] */
{ 0x8C85,  1, 5, { 0x06, 0x08, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-69 桁	# [cjk] */
{ 0x8C86,  1, 5, { 0x05, 0x00, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-70 傑	# [cjk] */
{ 0x8C87,  1, 5, { 0x06, 0x0b, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-71 欠	# [cjk] */
{ 0x8C88,  1, 5, { 0x06, 0x0c, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-72 決	# [cjk] */
{ 0x8C89,  1, 5, { 0x06, 0x0f, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-73 潔	# [cjk] */
{ 0x8C8A,  1, 5, { 0x07, 0x0a, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-74 穴	# [cjk] */
{ 0x8C8B,  1, 5, { 0x07, 0x0d, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-75 結	# [cjk] */
{ 0x8C8C,  1, 5, { 0x08, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-76 血	# [cjk] */
{ 0x8C8D,  1, 5, { 0x08, 0x0a, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-77 訣	# [cjk] */
{ 0x8C8E,  1, 5, { 0x06, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-78 月	# [cjk] */
{ 0x8C8F,  1, 5, { 0x04, 0x0e, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-79 件	# [cjk] */
{ 0x8C90,  1, 5, { 0x05, 0x00, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-80 倹	# [cjk] */
{ 0x8C91,  1, 5, { 0x05, 0x00, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-81 倦	# [cjk] */
{ 0x8C92,  1, 5, { 0x05, 0x00, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-82 健	# [cjk] */
{ 0x8C93,  1, 5, { 0x05, 0x01, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-83 兼	# [cjk] */
{ 0x8C94,  1, 5, { 0x05, 0x02, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-84 券	# [cjk] */
{ 0x8C95,  1, 5, { 0x05, 0x02, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-85 剣	# [cjk] */
{ 0x8C96,  1, 5, { 0x05, 0x05, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-86 喧	# [cjk] */
{ 0x8C97,  1, 5, { 0x05, 0x07, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-87 圏	# [cjk] */
{ 0x8C98,  1, 5, { 0x05, 0x08, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-88 堅	# [cjk] */
{ 0x8C99,  1, 5, { 0x05, 0x0a, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-89 嫌	# [cjk] */
{ 0x8C9A,  1, 5, { 0x05, 0x0e, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-90 建	# [cjk] */
{ 0x8C9B,  1, 5, { 0x06, 0x01, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-91 憲	# [cjk] */
{ 0x8C9C,  1, 5, { 0x06, 0x01, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-92 懸	# [cjk] */
{ 0x8C9D,  1, 5, { 0x06, 0x02, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-93 拳	# [cjk] */
{ 0x8C9E,  1, 5, { 0x06, 0x03, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-23-94 捲	# [cjk] */
{ 0x8C9F,  1, 5, { 0x06, 0x09, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-01 検	# [cjk] */
{ 0x8CA0,  1, 5, { 0x06, 0x0a, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-02 権	# [cjk] */
{ 0x8CA1,  1, 5, { 0x07, 0x02, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-03 牽	# [cjk] */
{ 0x8CA2,  1, 5, { 0x07, 0x02, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-04 犬	# [cjk] */
{ 0x8CA3,  1, 5, { 0x07, 0x03, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-05 献	# [cjk] */
{ 0x8CA4,  1, 5, { 0x07, 0x08, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-06 研	# [cjk] */
{ 0x8CA5,  1, 5, { 0x07, 0x08, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-07 硯	# [cjk] */
{ 0x8CA6,  1, 5, { 0x07, 0x0d, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-08 絹	# [cjk] */
{ 0x8CA7,  1, 5, { 0x07, 0x07, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-09 県	# [cjk] */
{ 0x8CA8,  1, 5, { 0x08, 0x00, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-10 肩	# [cjk] */
{ 0x8CA9,  1, 5, { 0x08, 0x09, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-11 見	# [cjk] */
{ 0x8CAA,  1, 5, { 0x08, 0x0b, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-12 謙	# [cjk] */
{ 0x8CAB,  1, 5, { 0x08, 0x0c, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-13 賢	# [cjk] */
{ 0x8CAC,  1, 5, { 0x08, 0x0e, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-14 軒	# [cjk] */
{ 0x8CAD,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-15 遣	# [cjk] */
{ 0x8CAE,  1, 5, { 0x09, 0x03, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-16 鍵	# [cjk] */
{ 0x8CAF,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-17 険	# [cjk] */
{ 0x8CB0,  1, 5, { 0x09, 0x08, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-18 顕	# [cjk] */
{ 0x8CB1,  1, 5, { 0x09, 0x0a, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-19 験	# [cjk] */
{ 0x8CB2,  1, 5, { 0x09, 0x0e, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-20 鹸	# [cjk] */
{ 0x8CB3,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-21 元	# [cjk] */
{ 0x8CB4,  1, 5, { 0x05, 0x03, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-22 原	# [cjk] */
{ 0x8CB5,  1, 5, { 0x05, 0x03, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-23 厳	# [cjk] */
{ 0x8CB6,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-24 幻	# [cjk] */
{ 0x8CB7,  1, 5, { 0x05, 0x0f, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-25 弦	# [cjk] */
{ 0x8CB8,  1, 5, { 0x06, 0x0e, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-26 減	# [cjk] */
{ 0x8CB9,  1, 5, { 0x06, 0x0e, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-27 源	# [cjk] */
{ 0x8CBA,  1, 5, { 0x07, 0x03, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-28 玄	# [cjk] */
{ 0x8CBB,  1, 5, { 0x07, 0x03, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-29 現	# [cjk] */
{ 0x8CBC,  1, 5, { 0x07, 0x0d, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-30 絃	# [cjk] */
{ 0x8CBD,  1, 5, { 0x08, 0x02, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-31 舷	# [cjk] */
{ 0x8CBE,  1, 5, { 0x08, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-32 言	# [cjk] */
{ 0x8CBF,  1, 5, { 0x08, 0x0a, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-33 諺	# [cjk] */
{ 0x8CC0,  1, 5, { 0x09, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-34 限	# [cjk] */
{ 0x8CC1,  1, 5, { 0x04, 0x0e, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-35 乎	# [cjk] */
{ 0x8CC2,  1, 5, { 0x05, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-36 個	# [cjk] */
{ 0x8CC3,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-37 古	# [cjk] */
{ 0x8CC4,  1, 5, { 0x05, 0x04, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-38 呼	# [cjk] */
{ 0x8CC5,  1, 5, { 0x05, 0x06, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-39 固	# [cjk] */
{ 0x8CC6,  1, 5, { 0x05, 0x09, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-40 姑	# [cjk] */
{ 0x8CC7,  1, 5, { 0x05, 0x0b, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-41 孤	# [cjk] */
{ 0x8CC8,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-42 己	# [cjk] */
{ 0x8CC9,  1, 5, { 0x05, 0x0e, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-43 庫	# [cjk] */
{ 0x8CCA,  1, 5, { 0x05, 0x0f, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-44 弧	# [cjk] */
{ 0x8CCB,  1, 5, { 0x06, 0x02, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-45 戸	# [cjk] */
{ 0x8CCC,  1, 5, { 0x06, 0x05, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-46 故	# [cjk] */
{ 0x8CCD,  1, 5, { 0x06, 0x07, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-47 枯	# [cjk] */
{ 0x8CCE,  1, 5, { 0x06, 0x0e, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-48 湖	# [cjk] */
{ 0x8CCF,  1, 5, { 0x07, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-49 狐	# [cjk] */
{ 0x8CD0,  1, 5, { 0x07, 0x0c, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-50 糊	# [cjk] */
{ 0x8CD1,  1, 5, { 0x08, 0x08, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-51 袴	# [cjk] */
{ 0x8CD2,  1, 5, { 0x08, 0x00, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-52 股	# [cjk] */
{ 0x8CD3,  1, 5, { 0x08, 0x00, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-53 胡	# [cjk] */
{ 0x8CD4,  1, 5, { 0x08, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-54 菰	# [cjk] */
{ 0x8CD5,  1, 5, { 0x08, 0x06, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-55 虎	# [cjk] */
{ 0x8CD6,  1, 5, { 0x08, 0x0a, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-56 誇	# [cjk] */
{ 0x8CD7,  1, 5, { 0x08, 0x0d, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-57 跨	# [cjk] */
{ 0x8CD8,  1, 5, { 0x09, 0x02, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-58 鈷	# [cjk] */
{ 0x8CD9,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-59 雇	# [cjk] */
{ 0x8CDA,  1, 5, { 0x09, 0x08, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-60 顧	# [cjk] */
{ 0x8CDB,  1, 5, { 0x09, 0x0f, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-61 鼓	# [cjk] */
{ 0x8CDC,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-62 五	# [cjk] */
{ 0x8CDD,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-63 互	# [cjk] */
{ 0x8CDE,  1, 5, { 0x04, 0x0f, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-64 伍	# [cjk] */
{ 0x8CDF,  1, 5, { 0x05, 0x03, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-65 午	# [cjk] */
{ 0x8CE0,  1, 5, { 0x05, 0x04, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-66 呉	# [cjk] */
{ 0x8CE1,  1, 5, { 0x05, 0x04, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-67 吾	# [cjk] */
{ 0x8CE2,  1, 5, { 0x05, 0x0a, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-68 娯	# [cjk] */
{ 0x8CE3,  1, 5, { 0x05, 0x0f, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-69 後	# [cjk] */
{ 0x8CE4,  1, 5, { 0x05, 0x0f, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-70 御	# [cjk] */
{ 0x8CE5,  1, 5, { 0x06, 0x00, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-71 悟	# [cjk] */
{ 0x8CE6,  1, 5, { 0x06, 0x08, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-72 梧	# [cjk] */
{ 0x8CE7,  1, 5, { 0x06, 0x0a, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-73 檎	# [cjk] */
{ 0x8CE8,  1, 5, { 0x07, 0x04, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-74 瑚	# [cjk] */
{ 0x8CE9,  1, 5, { 0x07, 0x08, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-75 碁	# [cjk] */
{ 0x8CEA,  1, 5, { 0x08, 0x0a, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-76 語	# [cjk] */
{ 0x8CEB,  1, 5, { 0x08, 0x0a, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-77 誤	# [cjk] */
{ 0x8CEC,  1, 5, { 0x08, 0x0b, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-78 護	# [cjk] */
{ 0x8CED,  1, 5, { 0x09, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-79 醐	# [cjk] */
{ 0x8CEE,  1, 5, { 0x04, 0x0e, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-80 乞	# [cjk] */
{ 0x8CEF,  1, 5, { 0x09, 0x0b, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-81 鯉	# [cjk] */
{ 0x8CF0,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-82 交	# [cjk] */
{ 0x8CF1,  1, 5, { 0x04, 0x0f, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-83 佼	# [cjk] */
{ 0x8CF2,  1, 5, { 0x04, 0x0f, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-84 侯	# [cjk] */
{ 0x8CF3,  1, 5, { 0x05, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-85 候	# [cjk] */
{ 0x8CF4,  1, 5, { 0x05, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-86 倖	# [cjk] */
{ 0x8CF5,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-87 光	# [cjk] */
{ 0x8CF6,  1, 5, { 0x05, 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-88 公	# [cjk] */
{ 0x8CF7,  1, 5, { 0x05, 0x02, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-89 功	# [cjk] */
{ 0x8CF8,  1, 5, { 0x05, 0x02, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-90 効	# [cjk] */
{ 0x8CF9,  1, 5, { 0x05, 0x02, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-91 勾	# [cjk] */
{ 0x8CFA,  1, 5, { 0x05, 0x03, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-92 厚	# [cjk] */
{ 0x8CFB,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-93 口	# [cjk] */
{ 0x8CFC,  1, 5, { 0x05, 0x04, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-24-94 向	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8D40,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-01 后	# [cjk] */
{ 0x8D41,  1, 5, { 0x05, 0x05, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-02 喉	# [cjk] */
{ 0x8D42,  1, 5, { 0x05, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-03 坑	# [cjk] */
{ 0x8D43,  1, 5, { 0x05, 0x07, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-04 垢	# [cjk] */
{ 0x8D44,  1, 5, { 0x05, 0x09, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-05 好	# [cjk] */
{ 0x8D45,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-06 孔	# [cjk] */
{ 0x8D46,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-07 孝	# [cjk] */
{ 0x8D47,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-08 宏	# [cjk] */
{ 0x8D48,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-09 工	# [cjk] */
{ 0x8D49,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-10 巧	# [cjk] */
{ 0x8D4A,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-11 巷	# [cjk] */
{ 0x8D4B,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-12 幸	# [cjk] */
{ 0x8D4C,  1, 5, { 0x05, 0x0e, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-13 広	# [cjk] */
{ 0x8D4D,  1, 5, { 0x05, 0x0e, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-14 庚	# [cjk] */
{ 0x8D4E,  1, 5, { 0x05, 0x0e, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-15 康	# [cjk] */
{ 0x8D4F,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-16 弘	# [cjk] */
{ 0x8D50,  1, 5, { 0x06, 0x00, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-17 恒	# [cjk] */
{ 0x8D51,  1, 5, { 0x06, 0x01, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-18 慌	# [cjk] */
{ 0x8D52,  1, 5, { 0x06, 0x02, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-19 抗	# [cjk] */
{ 0x8D53,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-20 拘	# [cjk] */
{ 0x8D54,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-21 控	# [cjk] */
{ 0x8D55,  1, 5, { 0x06, 0x05, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-22 攻	# [cjk] */
{ 0x8D56,  1, 5, { 0x06, 0x06, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-23 昂	# [cjk] */
{ 0x8D57,  1, 5, { 0x06, 0x06, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-24 晃	# [cjk] */
{ 0x8D58,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-25 更	# [cjk] */
{ 0x8D59,  1, 5, { 0x06, 0x07, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-26 杭	# [cjk] */
{ 0x8D5A,  1, 5, { 0x06, 0x08, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-27 校	# [cjk] */
{ 0x8D5B,  1, 5, { 0x06, 0x08, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-28 梗	# [cjk] */
{ 0x8D5C,  1, 5, { 0x06, 0x09, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-29 構	# [cjk] */
{ 0x8D5D,  1, 5, { 0x06, 0x0c, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-30 江	# [cjk] */
{ 0x8D5E,  1, 5, { 0x06, 0x0d, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-31 洪	# [cjk] */
{ 0x8D5F,  1, 5, { 0x06, 0x0d, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-32 浩	# [cjk] */
{ 0x8D60,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-33 港	# [cjk] */
{ 0x8D61,  1, 5, { 0x06, 0x0e, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-34 溝	# [cjk] */
{ 0x8D62,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-35 甲	# [cjk] */
{ 0x8D63,  1, 5, { 0x07, 0x06, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-36 皇	# [cjk] */
{ 0x8D64,  1, 5, { 0x07, 0x08, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-37 硬	# [cjk] */
{ 0x8D65,  1, 5, { 0x07, 0x0a, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-38 稿	# [cjk] */
{ 0x8D66,  1, 5, { 0x07, 0x0c, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-39 糠	# [cjk] */
{ 0x8D67,  1, 5, { 0x07, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-40 紅	# [cjk] */
{ 0x8D68,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-41 紘	# [cjk] */
{ 0x8D69,  1, 5, { 0x07, 0x0d, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-42 絞	# [cjk] */
{ 0x8D6A,  1, 5, { 0x07, 0x0d, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-43 綱	# [cjk] */
{ 0x8D6B,  1, 5, { 0x08, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-44 耕	# [cjk] */
{ 0x8D6C,  1, 5, { 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-45 考	# [cjk] */
{ 0x8D6D,  1, 5, { 0x08, 0x00, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-46 肯	# [cjk] */
{ 0x8D6E,  1, 5, { 0x08, 0x00, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-47 肱	# [cjk] */
{ 0x8D6F,  1, 5, { 0x08, 0x01, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-48 腔	# [cjk] */
{ 0x8D70,  1, 5, { 0x08, 0x01, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-49 膏	# [cjk] */
{ 0x8D71,  1, 5, { 0x08, 0x02, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-50 航	# [cjk] */
{ 0x8D72,  1, 5, { 0x08, 0x03, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-51 荒	# [cjk] */
{ 0x8D73,  1, 5, { 0x08, 0x08, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-52 行	# [cjk] */
{ 0x8D74,  1, 5, { 0x08, 0x08, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-53 衡	# [cjk] */
{ 0x8D75,  1, 5, { 0x08, 0x0b, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-54 講	# [cjk] */
{ 0x8D76,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-55 貢	# [cjk] */
{ 0x8D77,  1, 5, { 0x08, 0x0c, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-56 購	# [cjk] */
{ 0x8D78,  1, 5, { 0x09, 0x00, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-57 郊	# [cjk] */
{ 0x8D79,  1, 5, { 0x09, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-58 酵	# [cjk] */
{ 0x8D7A,  1, 5, { 0x09, 0x02, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-59 鉱	# [cjk] */
{ 0x8D7B,  1, 5, { 0x07, 0x08, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-60 砿	# [cjk] */
{ 0x8D7C,  1, 5, { 0x09, 0x02, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-61 鋼	# [cjk] */
{ 0x8D7D,  1, 5, { 0x09, 0x05, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-62 閤	# [cjk] */
{ 0x8D7E,  1, 5, { 0x09, 0x06, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-63 降	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8D80,  1, 5, { 0x09, 0x08, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-64 項	# [cjk] */
{ 0x8D81,  1, 5, { 0x09, 0x09, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-65 香	# [cjk] */
{ 0x8D82,  1, 5, { 0x09, 0x0a, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-66 高	# [cjk] */
{ 0x8D83,  1, 5, { 0x09, 0x0d, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-67 鴻	# [cjk] */
{ 0x8D84,  1, 5, { 0x05, 0x02, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-68 剛	# [cjk] */
{ 0x8D85,  1, 5, { 0x05, 0x02, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-69 劫	# [cjk] */
{ 0x8D86,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-70 号	# [cjk] */
{ 0x8D87,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-71 合	# [cjk] */
{ 0x8D88,  1, 5, { 0x05, 0x08, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-72 壕	# [cjk] */
{ 0x8D89,  1, 5, { 0x06, 0x02, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-73 拷	# [cjk] */
{ 0x8D8A,  1, 5, { 0x06, 0x0f, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-74 濠	# [cjk] */
{ 0x8D8B,  1, 5, { 0x08, 0x0c, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-75 豪	# [cjk] */
{ 0x8D8C,  1, 5, { 0x08, 0x0f, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-76 轟	# [cjk] */
{ 0x8D8D,  1, 5, { 0x09, 0x0e, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-77 麹	# [cjk] */
{ 0x8D8E,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-78 克	# [cjk] */
{ 0x8D8F,  1, 5, { 0x05, 0x02, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-79 刻	# [cjk] */
{ 0x8D90,  1, 5, { 0x05, 0x04, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-80 告	# [cjk] */
{ 0x8D91,  1, 5, { 0x05, 0x06, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-81 国	# [cjk] */
{ 0x8D92,  1, 5, { 0x07, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-82 穀	# [cjk] */
{ 0x8D93,  1, 5, { 0x09, 0x01, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-83 酷	# [cjk] */
{ 0x8D94,  1, 5, { 0x09, 0x0d, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-84 鵠	# [cjk] */
{ 0x8D95,  1, 5, { 0x09, 0x0e, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-85 黒	# [cjk] */
{ 0x8D96,  1, 5, { 0x07, 0x03, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-86 獄	# [cjk] */
{ 0x8D97,  1, 5, { 0x06, 0x0f, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-87 漉	# [cjk] */
{ 0x8D98,  1, 5, { 0x08, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-88 腰	# [cjk] */
{ 0x8D99,  1, 5, { 0x07, 0x05, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-89 甑	# [cjk] */
{ 0x8D9A,  1, 5, { 0x05, 0x0f, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-90 忽	# [cjk] */
{ 0x8D9B,  1, 5, { 0x06, 0x00, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-91 惚	# [cjk] */
{ 0x8D9C,  1, 5, { 0x09, 0x0a, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-92 骨	# [cjk] */
{ 0x8D9D,  1, 5, { 0x07, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-93 狛	# [cjk] */
{ 0x8D9E,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-25-94 込	# [cjk] */
{ 0x8D9F,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-01 此	# [cjk] */
{ 0x8DA0,  1, 5, { 0x09, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-02 頃	# [cjk] */
{ 0x8DA1,  1, 5, { 0x04, 0x0e, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-03 今	# [cjk] */
{ 0x8DA2,  1, 5, { 0x05, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-04 困	# [cjk] */
{ 0x8DA3,  1, 5, { 0x05, 0x07, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-05 坤	# [cjk] */
{ 0x8DA4,  1, 5, { 0x05, 0x08, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-06 墾	# [cjk] */
{ 0x8DA5,  1, 5, { 0x05, 0x0a, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-07 婚	# [cjk] */
{ 0x8DA6,  1, 5, { 0x06, 0x00, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-08 恨	# [cjk] */
{ 0x8DA7,  1, 5, { 0x06, 0x01, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-09 懇	# [cjk] */
{ 0x8DA8,  1, 5, { 0x06, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-10 昏	# [cjk] */
{ 0x8DA9,  1, 5, { 0x06, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-11 昆	# [cjk] */
{ 0x8DAA,  1, 5, { 0x06, 0x08, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-12 根	# [cjk] */
{ 0x8DAB,  1, 5, { 0x06, 0x08, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-13 梱	# [cjk] */
{ 0x8DAC,  1, 5, { 0x06, 0x0d, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-14 混	# [cjk] */
{ 0x8DAD,  1, 5, { 0x07, 0x05, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-15 痕	# [cjk] */
{ 0x8DAE,  1, 5, { 0x07, 0x0d, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-16 紺	# [cjk] */
{ 0x8DAF,  1, 5, { 0x08, 0x02, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-17 艮	# [cjk] */
{ 0x8DB0,  1, 5, { 0x09, 0x0b, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-18 魂	# [cjk] */
{ 0x8DB1,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-19 些	# [cjk] */
{ 0x8DB2,  1, 5, { 0x04, 0x0f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-20 佐	# [cjk] */
{ 0x8DB3,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-21 叉	# [cjk] */
{ 0x8DB4,  1, 5, { 0x05, 0x05, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-22 唆	# [cjk] */
{ 0x8DB5,  1, 5, { 0x05, 0x0d, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-23 嵯	# [cjk] */
{ 0x8DB6,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-24 左	# [cjk] */
{ 0x8DB7,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-25 差	# [cjk] */
{ 0x8DB8,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-26 査	# [cjk] */
{ 0x8DB9,  1, 5, { 0x06, 0x0c, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-27 沙	# [cjk] */
{ 0x8DBA,  1, 5, { 0x07, 0x04, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-28 瑳	# [cjk] */
{ 0x8DBB,  1, 5, { 0x07, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-29 砂	# [cjk] */
{ 0x8DBC,  1, 5, { 0x08, 0x0a, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-30 詐	# [cjk] */
{ 0x8DBD,  1, 5, { 0x09, 0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-31 鎖	# [cjk] */
{ 0x8DBE,  1, 5, { 0x08, 0x08, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-32 裟	# [cjk] */
{ 0x8DBF,  1, 5, { 0x05, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-33 坐	# [cjk] */
{ 0x8DC0,  1, 5, { 0x05, 0x0e, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-34 座	# [cjk] */
{ 0x8DC1,  1, 5, { 0x06, 0x03, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-35 挫	# [cjk] */
{ 0x8DC2,  1, 5, { 0x05, 0x00, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-36 債	# [cjk] */
{ 0x8DC3,  1, 5, { 0x05, 0x00, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-37 催	# [cjk] */
{ 0x8DC4,  1, 5, { 0x05, 0x01, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-38 再	# [cjk] */
{ 0x8DC5,  1, 5, { 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-39 最	# [cjk] */
{ 0x8DC6,  1, 5, { 0x05, 0x04, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-40 哉	# [cjk] */
{ 0x8DC7,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-41 塞	# [cjk] */
{ 0x8DC8,  1, 5, { 0x05, 0x09, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-42 妻	# [cjk] */
{ 0x8DC9,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-43 宰	# [cjk] */
{ 0x8DCA,  1, 5, { 0x05, 0x0f, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-44 彩	# [cjk] */
{ 0x8DCB,  1, 5, { 0x06, 0x02, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-45 才	# [cjk] */
{ 0x8DCC,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-46 採	# [cjk] */
{ 0x8DCD,  1, 5, { 0x06, 0x08, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-47 栽	# [cjk] */
{ 0x8DCE,  1, 5, { 0x06, 0x0b, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-48 歳	# [cjk] */
{ 0x8DCF,  1, 5, { 0x06, 0x0e, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-49 済	# [cjk] */
{ 0x8DD0,  1, 5, { 0x07, 0x00, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-50 災	# [cjk] */
{ 0x8DD1,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-51 采	# [cjk] */
{ 0x8DD2,  1, 5, { 0x07, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-52 犀	# [cjk] */
{ 0x8DD3,  1, 5, { 0x07, 0x08, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-53 砕	# [cjk] */
{ 0x8DD4,  1, 5, { 0x07, 0x08, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-54 砦	# [cjk] */
{ 0x8DD5,  1, 5, { 0x07, 0x09, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-55 祭	# [cjk] */
{ 0x8DD6,  1, 5, { 0x06, 0x05, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-56 斎	# [cjk] */
{ 0x8DD7,  1, 5, { 0x07, 0x0d, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-57 細	# [cjk] */
{ 0x8DD8,  1, 5, { 0x08, 0x03, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-58 菜	# [cjk] */
{ 0x8DD9,  1, 5, { 0x08, 0x08, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-59 裁	# [cjk] */
{ 0x8DDA,  1, 5, { 0x08, 0x0f, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-60 載	# [cjk] */
{ 0x8DDB,  1, 5, { 0x09, 0x06, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-61 際	# [cjk] */
{ 0x8DDC,  1, 5, { 0x05, 0x02, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-62 剤	# [cjk] */
{ 0x8DDD,  1, 5, { 0x05, 0x07, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-63 在	# [cjk] */
{ 0x8DDE,  1, 5, { 0x06, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-64 材	# [cjk] */
{ 0x8DDF,  1, 5, { 0x07, 0x0f, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-65 罪	# [cjk] */
{ 0x8DE0,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-66 財	# [cjk] */
{ 0x8DE1,  1, 5, { 0x05, 0x01, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-67 冴	# [cjk] */
{ 0x8DE2,  1, 5, { 0x05, 0x07, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-68 坂	# [cjk] */
{ 0x8DE3,  1, 5, { 0x09, 0x06, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-69 阪	# [cjk] */
{ 0x8DE4,  1, 5, { 0x05, 0x08, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-70 堺	# [cjk] */
{ 0x8DE5,  1, 5, { 0x06, 0x09, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-71 榊	# [cjk] */
{ 0x8DE6,  1, 5, { 0x08, 0x00, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-72 肴	# [cjk] */
{ 0x8DE7,  1, 5, { 0x05, 0x04, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-73 咲	# [cjk] */
{ 0x8DE8,  1, 5, { 0x05, 0x0d, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-74 崎	# [cjk] */
{ 0x8DE9,  1, 5, { 0x05, 0x07, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-75 埼	# [cjk] */
{ 0x8DEA,  1, 5, { 0x07, 0x08, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-76 碕	# [cjk] */
{ 0x8DEB,  1, 5, { 0x09, 0x0d, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-77 鷺	# [cjk] */
{ 0x8DEC,  1, 5, { 0x04, 0x0f, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-78 作	# [cjk] */
{ 0x8DED,  1, 5, { 0x05, 0x02, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-79 削	# [cjk] */
{ 0x8DEE,  1, 5, { 0x05, 0x04, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-80 咋	# [cjk] */
{ 0x8DEF,  1, 5, { 0x06, 0x04, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-81 搾	# [cjk] */
{ 0x8DF0,  1, 5, { 0x06, 0x06, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-82 昨	# [cjk] */
{ 0x8DF1,  1, 5, { 0x06, 0x07, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-83 朔	# [cjk] */
{ 0x8DF2,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-84 柵	# [cjk] */
{ 0x8DF3,  1, 5, { 0x07, 0x0a, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-85 窄	# [cjk] */
{ 0x8DF4,  1, 5, { 0x07, 0x0b, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-86 策	# [cjk] */
{ 0x8DF5,  1, 5, { 0x07, 0x0d, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-87 索	# [cjk] */
{ 0x8DF6,  1, 5, { 0x09, 0x03, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-88 錯	# [cjk] */
{ 0x8DF7,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-89 桜	# [cjk] */
{ 0x8DF8,  1, 5, { 0x09, 0x0b, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-90 鮭	# [cjk] */
{ 0x8DF9,  1, 5, { 0x07, 0x0b, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-91 笹	# [cjk] */
{ 0x8DFA,  1, 5, { 0x05, 0x03, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-92 匙	# [cjk] */
{ 0x8DFB,  1, 5, { 0x05, 0x01, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-93 冊	# [cjk] */
{ 0x8DFC,  1, 5, { 0x05, 0x02, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-26-94 刷	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8E40,  1, 5, { 0x05, 0x0b, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-01 察	# [cjk] */
{ 0x8E41,  1, 5, { 0x06, 0x02, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-02 拶	# [cjk] */
{ 0x8E42,  1, 5, { 0x06, 0x04, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-03 撮	# [cjk] */
{ 0x8E43,  1, 5, { 0x06, 0x04, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-04 擦	# [cjk] */
{ 0x8E44,  1, 5, { 0x06, 0x07, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-05 札	# [cjk] */
{ 0x8E45,  1, 5, { 0x06, 0x0b, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-06 殺	# [cjk] */
{ 0x8E46,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-07 薩	# [cjk] */
{ 0x8E47,  1, 5, { 0x09, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-08 雑	# [cjk] */
{ 0x8E48,  1, 5, { 0x07, 0x06, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-09 皐	# [cjk] */
{ 0x8E49,  1, 5, { 0x09, 0x0b, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-10 鯖	# [cjk] */
{ 0x8E4A,  1, 5, { 0x06, 0x03, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-11 捌	# [cjk] */
{ 0x8E4B,  1, 5, { 0x09, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-12 錆	# [cjk] */
{ 0x8E4C,  1, 5, { 0x09, 0x0b, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-13 鮫	# [cjk] */
{ 0x8E4D,  1, 5, { 0x07, 0x06, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-14 皿	# [cjk] */
{ 0x8E4E,  1, 5, { 0x06, 0x06, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-15 晒	# [cjk] */
{ 0x8E4F,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-16 三	# [cjk] */
{ 0x8E50,  1, 5, { 0x05, 0x00, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-17 傘	# [cjk] */
{ 0x8E51,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-18 参	# [cjk] */
{ 0x8E52,  1, 5, { 0x05, 0x0c, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-19 山	# [cjk] */
{ 0x8E53,  1, 5, { 0x06, 0x00, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-20 惨	# [cjk] */
{ 0x8E54,  1, 5, { 0x06, 0x04, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-21 撒	# [cjk] */
{ 0x8E55,  1, 5, { 0x06, 0x05, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-22 散	# [cjk] */
{ 0x8E56,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-23 桟	# [cjk] */
{ 0x8E57,  1, 5, { 0x07, 0x01, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-24 燦	# [cjk] */
{ 0x8E58,  1, 5, { 0x07, 0x03, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-25 珊	# [cjk] */
{ 0x8E59,  1, 5, { 0x07, 0x05, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-26 産	# [cjk] */
{ 0x8E5A,  1, 5, { 0x07, 0x0b, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-27 算	# [cjk] */
{ 0x8E5B,  1, 5, { 0x07, 0x0e, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-28 纂	# [cjk] */
{ 0x8E5C,  1, 5, { 0x08, 0x06, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-29 蚕	# [cjk] */
{ 0x8E5D,  1, 5, { 0x08, 0x0b, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-30 讃	# [cjk] */
{ 0x8E5E,  1, 5, { 0x08, 0x0c, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-31 賛	# [cjk] */
{ 0x8E5F,  1, 5, { 0x09, 0x01, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-32 酸	# [cjk] */
{ 0x8E60,  1, 5, { 0x09, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-33 餐	# [cjk] */
{ 0x8E61,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-34 斬	# [cjk] */
{ 0x8E62,  1, 5, { 0x06, 0x06, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-35 暫	# [cjk] */
{ 0x8E63,  1, 5, { 0x06, 0x0b, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-36 残	# [cjk] */
{ 0x8E64,  1, 5, { 0x04, 0x0e, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-37 仕	# [cjk] */
{ 0x8E65,  1, 5, { 0x04, 0x0e, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-38 仔	# [cjk] */
{ 0x8E66,  1, 5, { 0x04, 0x0f, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-39 伺	# [cjk] */
{ 0x8E67,  1, 5, { 0x04, 0x0f, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-40 使	# [cjk] */
{ 0x8E68,  1, 5, { 0x05, 0x02, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-41 刺	# [cjk] */
{ 0x8E69,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-42 司	# [cjk] */
{ 0x8E6A,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-43 史	# [cjk] */
{ 0x8E6B,  1, 5, { 0x05, 0x05, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-44 嗣	# [cjk] */
{ 0x8E6C,  1, 5, { 0x05, 0x06, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-45 四	# [cjk] */
{ 0x8E6D,  1, 5, { 0x05, 0x08, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-46 士	# [cjk] */
{ 0x8E6E,  1, 5, { 0x05, 0x09, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-47 始	# [cjk] */
{ 0x8E6F,  1, 5, { 0x05, 0x09, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-48 姉	# [cjk] */
{ 0x8E70,  1, 5, { 0x05, 0x09, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-49 姿	# [cjk] */
{ 0x8E71,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-50 子	# [cjk] */
{ 0x8E72,  1, 5, { 0x05, 0x0c, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-51 屍	# [cjk] */
{ 0x8E73,  1, 5, { 0x05, 0x0e, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-52 市	# [cjk] */
{ 0x8E74,  1, 5, { 0x05, 0x0e, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-53 師	# [cjk] */
{ 0x8E75,  1, 5, { 0x05, 0x0f, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-54 志	# [cjk] */
{ 0x8E76,  1, 5, { 0x06, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-55 思	# [cjk] */
{ 0x8E77,  1, 5, { 0x06, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-56 指	# [cjk] */
{ 0x8E78,  1, 5, { 0x06, 0x05, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-57 支	# [cjk] */
{ 0x8E79,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-58 孜	# [cjk] */
{ 0x8E7A,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-59 斯	# [cjk] */
{ 0x8E7B,  1, 5, { 0x06, 0x05, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-60 施	# [cjk] */
{ 0x8E7C,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-61 旨	# [cjk] */
{ 0x8E7D,  1, 5, { 0x06, 0x07, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-62 枝	# [cjk] */
{ 0x8E7E,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-63 止	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8E80,  1, 5, { 0x06, 0x0b, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-64 死	# [cjk] */
{ 0x8E81,  1, 5, { 0x06, 0x0c, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-65 氏	# [cjk] */
{ 0x8E82,  1, 5, { 0x07, 0x03, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-66 獅	# [cjk] */
{ 0x8E83,  1, 5, { 0x07, 0x09, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-67 祉	# [cjk] */
{ 0x8E84,  1, 5, { 0x07, 0x09, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-68 私	# [cjk] */
{ 0x8E85,  1, 5, { 0x07, 0x0c, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-69 糸	# [cjk] */
{ 0x8E86,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-70 紙	# [cjk] */
{ 0x8E87,  1, 5, { 0x07, 0x0d, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-71 紫	# [cjk] */
{ 0x8E88,  1, 5, { 0x08, 0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-72 肢	# [cjk] */
{ 0x8E89,  1, 5, { 0x08, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-73 脂	# [cjk] */
{ 0x8E8A,  1, 5, { 0x08, 0x01, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-74 至	# [cjk] */
{ 0x8E8B,  1, 5, { 0x08, 0x09, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-75 視	# [cjk] */
{ 0x8E8C,  1, 5, { 0x08, 0x0a, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-76 詞	# [cjk] */
{ 0x8E8D,  1, 5, { 0x08, 0x0a, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-77 詩	# [cjk] */
{ 0x8E8E,  1, 5, { 0x08, 0x0a, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-78 試	# [cjk] */
{ 0x8E8F,  1, 5, { 0x08, 0x0a, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-79 誌	# [cjk] */
{ 0x8E90,  1, 5, { 0x08, 0x0a, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-80 諮	# [cjk] */
{ 0x8E91,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-81 資	# [cjk] */
{ 0x8E92,  1, 5, { 0x08, 0x0c, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-82 賜	# [cjk] */
{ 0x8E93,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-83 雌	# [cjk] */
{ 0x8E94,  1, 5, { 0x09, 0x08, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-84 飼	# [cjk] */
{ 0x8E95,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-85 歯	# [cjk] */
{ 0x8E96,  1, 5, { 0x04, 0x0e, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-86 事	# [cjk] */
{ 0x8E97,  1, 5, { 0x04, 0x0f, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-87 似	# [cjk] */
{ 0x8E98,  1, 5, { 0x04, 0x0f, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-88 侍	# [cjk] */
{ 0x8E99,  1, 5, { 0x05, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-89 児	# [cjk] */
{ 0x8E9A,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-90 字	# [cjk] */
{ 0x8E9B,  1, 5, { 0x05, 0x0b, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-91 寺	# [cjk] */
{ 0x8E9C,  1, 5, { 0x06, 0x01, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-92 慈	# [cjk] */
{ 0x8E9D,  1, 5, { 0x06, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-93 持	# [cjk] */
{ 0x8E9E,  1, 5, { 0x06, 0x06, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-27-94 時	# [cjk] */
{ 0x8E9F,  1, 5, { 0x06, 0x0b, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-01 次	# [cjk] */
{ 0x8EA0,  1, 5, { 0x06, 0x0e, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-02 滋	# [cjk] */
{ 0x8EA1,  1, 5, { 0x06, 0x0c, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-03 治	# [cjk] */
{ 0x8EA2,  1, 5, { 0x07, 0x02, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-04 爾	# [cjk] */
{ 0x8EA3,  1, 5, { 0x07, 0x04, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-05 璽	# [cjk] */
{ 0x8EA4,  1, 5, { 0x07, 0x05, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-06 痔	# [cjk] */
{ 0x8EA5,  1, 5, { 0x07, 0x08, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-07 磁	# [cjk] */
{ 0x8EA6,  1, 5, { 0x07, 0x09, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-08 示	# [cjk] */
{ 0x8EA7,  1, 5, { 0x08, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-09 而	# [cjk] */
{ 0x8EA8,  1, 5, { 0x08, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-10 耳	# [cjk] */
{ 0x8EA9,  1, 5, { 0x08, 0x01, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-11 自	# [cjk] */
{ 0x8EAA,  1, 5, { 0x08, 0x04, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-12 蒔	# [cjk] */
{ 0x8EAB,  1, 5, { 0x08, 0x0f, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-13 辞	# [cjk] */
{ 0x8EAC,  1, 5, { 0x06, 0x0c, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-14 汐	# [cjk] */
{ 0x8EAD,  1, 5, { 0x09, 0x0e, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-15 鹿	# [cjk] */
{ 0x8EAE,  1, 5, { 0x05, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-16 式	# [cjk] */
{ 0x8EAF,  1, 5, { 0x08, 0x0b, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-17 識	# [cjk] */
{ 0x8EB0,  1, 5, { 0x09, 0x0d, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-18 鴫	# [cjk] */
{ 0x8EB1,  1, 5, { 0x07, 0x0a, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-19 竺	# [cjk] */
{ 0x8EB2,  1, 5, { 0x08, 0x0e, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-20 軸	# [cjk] */
{ 0x8EB3,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-21 宍	# [cjk] */
{ 0x8EB4,  1, 5, { 0x09, 0x06, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-22 雫	# [cjk] */
{ 0x8EB5,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-23 七	# [cjk] */
{ 0x8EB6,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-24 叱	# [cjk] */
{ 0x8EB7,  1, 5, { 0x05, 0x07, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-25 執	# [cjk] */
{ 0x8EB8,  1, 5, { 0x05, 0x09, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-26 失	# [cjk] */
{ 0x8EB9,  1, 5, { 0x05, 0x0a, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-27 嫉	# [cjk] */
{ 0x8EBA,  1, 5, { 0x05, 0x0b, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-28 室	# [cjk] */
{ 0x8EBB,  1, 5, { 0x06, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-29 悉	# [cjk] */
{ 0x8EBC,  1, 5, { 0x06, 0x0e, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-30 湿	# [cjk] */
{ 0x8EBD,  1, 5, { 0x06, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-31 漆	# [cjk] */
{ 0x8EBE,  1, 5, { 0x07, 0x05, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-32 疾	# [cjk] */
{ 0x8EBF,  1, 5, { 0x08, 0x0c, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-33 質	# [cjk] */
{ 0x8EC0,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-34 実	# [cjk] */
{ 0x8EC1,  1, 5, { 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-35 蔀	# [cjk] */
{ 0x8EC2,  1, 5, { 0x07, 0x0b, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-36 篠	# [cjk] */
{ 0x8EC3,  1, 5, { 0x05, 0x00, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-37 偲	# [cjk] */
{ 0x8EC4,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-38 柴	# [cjk] */
{ 0x8EC5,  1, 5, { 0x08, 0x02, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-39 芝	# [cjk] */
{ 0x8EC6,  1, 5, { 0x05, 0x0c, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-40 屡	# [cjk] */
{ 0x8EC7,  1, 5, { 0x08, 0x05, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-41 蕊	# [cjk] */
{ 0x8EC8,  1, 5, { 0x07, 0x0e, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-42 縞	# [cjk] */
{ 0x8EC9,  1, 5, { 0x08, 0x02, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-43 舎	# [cjk] */
{ 0x8ECA,  1, 5, { 0x05, 0x01, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-44 写	# [cjk] */
{ 0x8ECB,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-45 射	# [cjk] */
{ 0x8ECC,  1, 5, { 0x06, 0x03, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-46 捨	# [cjk] */
{ 0x8ECD,  1, 5, { 0x08, 0x0d, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-47 赦	# [cjk] */
{ 0x8ECE,  1, 5, { 0x06, 0x05, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-48 斜	# [cjk] */
{ 0x8ECF,  1, 5, { 0x07, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-49 煮	# [cjk] */
{ 0x8ED0,  1, 5, { 0x07, 0x09, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-50 社	# [cjk] */
{ 0x8ED1,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-51 紗	# [cjk] */
{ 0x8ED2,  1, 5, { 0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-52 者	# [cjk] */
{ 0x8ED3,  1, 5, { 0x08, 0x0b, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-53 謝	# [cjk] */
{ 0x8ED4,  1, 5, { 0x08, 0x0e, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-54 車	# [cjk] */
{ 0x8ED5,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-55 遮	# [cjk] */
{ 0x8ED6,  1, 5, { 0x08, 0x06, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-56 蛇	# [cjk] */
{ 0x8ED7,  1, 5, { 0x09, 0x00, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-57 邪	# [cjk] */
{ 0x8ED8,  1, 5, { 0x05, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-58 借	# [cjk] */
{ 0x8ED9,  1, 5, { 0x05, 0x02, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-59 勺	# [cjk] */
{ 0x8EDA,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-60 尺	# [cjk] */
{ 0x8EDB,  1, 5, { 0x06, 0x07, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-61 杓	# [cjk] */
{ 0x8EDC,  1, 5, { 0x07, 0x00, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-62 灼	# [cjk] */
{ 0x8EDD,  1, 5, { 0x07, 0x02, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-63 爵	# [cjk] */
{ 0x8EDE,  1, 5, { 0x09, 0x01, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-64 酌	# [cjk] */
{ 0x8EDF,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-65 釈	# [cjk] */
{ 0x8EE0,  1, 5, { 0x09, 0x03, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-66 錫	# [cjk] */
{ 0x8EE1,  1, 5, { 0x08, 0x02, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-67 若	# [cjk] */
{ 0x8EE2,  1, 5, { 0x05, 0x0b, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-68 寂	# [cjk] */
{ 0x8EE3,  1, 5, { 0x05, 0x0f, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-69 弱	# [cjk] */
{ 0x8EE4,  1, 5, { 0x06, 0x00, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-70 惹	# [cjk] */
{ 0x8EE5,  1, 5, { 0x04, 0x0e, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-71 主	# [cjk] */
{ 0x8EE6,  1, 5, { 0x05, 0x03, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-72 取	# [cjk] */
{ 0x8EE7,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-73 守	# [cjk] */
{ 0x8EE8,  1, 5, { 0x06, 0x02, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-74 手	# [cjk] */
{ 0x8EE9,  1, 5, { 0x06, 0x07, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-75 朱	# [cjk] */
{ 0x8EEA,  1, 5, { 0x06, 0x0b, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-76 殊	# [cjk] */
{ 0x8EEB,  1, 5, { 0x07, 0x02, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-77 狩	# [cjk] */
{ 0x8EEC,  1, 5, { 0x07, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-78 珠	# [cjk] */
{ 0x8EED,  1, 5, { 0x07, 0x0a, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-79 種	# [cjk] */
{ 0x8EEE,  1, 5, { 0x08, 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-80 腫	# [cjk] */
{ 0x8EEF,  1, 5, { 0x08, 0x0d, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-81 趣	# [cjk] */
{ 0x8EF0,  1, 5, { 0x09, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-82 酒	# [cjk] */
{ 0x8EF1,  1, 5, { 0x09, 0x09, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-83 首	# [cjk] */
{ 0x8EF2,  1, 5, { 0x05, 0x01, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-84 儒	# [cjk] */
{ 0x8EF3,  1, 5, { 0x05, 0x03, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-85 受	# [cjk] */
{ 0x8EF4,  1, 5, { 0x05, 0x04, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-86 呪	# [cjk] */
{ 0x8EF5,  1, 5, { 0x05, 0x0b, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-87 寿	# [cjk] */
{ 0x8EF6,  1, 5, { 0x06, 0x03, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-88 授	# [cjk] */
{ 0x8EF7,  1, 5, { 0x06, 0x0a, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-89 樹	# [cjk] */
{ 0x8EF8,  1, 5, { 0x07, 0x0d, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-90 綬	# [cjk] */
{ 0x8EF9,  1, 5, { 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-91 需	# [cjk] */
{ 0x8EFA,  1, 5, { 0x05, 0x06, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-92 囚	# [cjk] */
{ 0x8EFB,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-93 収	# [cjk] */
{ 0x8EFC,  1, 5, { 0x05, 0x04, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-28-94 周	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8F40,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-01 宗	# [cjk] */
{ 0x8F41,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-02 就	# [cjk] */
{ 0x8F42,  1, 5, { 0x05, 0x0d, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-03 州	# [cjk] */
{ 0x8F43,  1, 5, { 0x04, 0x0f, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-04 修	# [cjk] */
{ 0x8F44,  1, 5, { 0x06, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-05 愁	# [cjk] */
{ 0x8F45,  1, 5, { 0x06, 0x02, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-06 拾	# [cjk] */
{ 0x8F46,  1, 5, { 0x06, 0x0d, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-07 洲	# [cjk] */
{ 0x8F47,  1, 5, { 0x07, 0x09, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-08 秀	# [cjk] */
{ 0x8F48,  1, 5, { 0x07, 0x09, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-09 秋	# [cjk] */
{ 0x8F49,  1, 5, { 0x07, 0x0d, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-10 終	# [cjk] */
{ 0x8F4A,  1, 5, { 0x07, 0x0e, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-11 繍	# [cjk] */
{ 0x8F4B,  1, 5, { 0x07, 0x0f, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-12 習	# [cjk] */
{ 0x8F4C,  1, 5, { 0x08, 0x01, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-13 臭	# [cjk] */
{ 0x8F4D,  1, 5, { 0x08, 0x02, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-14 舟	# [cjk] */
{ 0x8F4E,  1, 5, { 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-15 蒐	# [cjk] */
{ 0x8F4F,  1, 5, { 0x08, 0x08, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-16 衆	# [cjk] */
{ 0x8F50,  1, 5, { 0x08, 0x09, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-17 襲	# [cjk] */
{ 0x8F51,  1, 5, { 0x08, 0x0b, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-18 讐	# [cjk] */
{ 0x8F52,  1, 5, { 0x08, 0x0e, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-19 蹴	# [cjk] */
{ 0x8F53,  1, 5, { 0x08, 0x0f, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-20 輯	# [cjk] */
{ 0x8F54,  1, 5, { 0x09, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-21 週	# [cjk] */
{ 0x8F55,  1, 5, { 0x09, 0x01, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-22 酋	# [cjk] */
{ 0x8F56,  1, 5, { 0x09, 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-23 酬	# [cjk] */
{ 0x8F57,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-24 集	# [cjk] */
{ 0x8F58,  1, 5, { 0x09, 0x01, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-25 醜	# [cjk] */
{ 0x8F59,  1, 5, { 0x04, 0x0e, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-26 什	# [cjk] */
{ 0x8F5A,  1, 5, { 0x04, 0x0f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-27 住	# [cjk] */
{ 0x8F5B,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-28 充	# [cjk] */
{ 0x8F5C,  1, 5, { 0x05, 0x03, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-29 十	# [cjk] */
{ 0x8F5D,  1, 5, { 0x05, 0x0f, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-30 従	# [cjk] */
{ 0x8F5E,  1, 5, { 0x06, 0x02, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-31 戎	# [cjk] */
{ 0x8F5F,  1, 5, { 0x06, 0x07, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-32 柔	# [cjk] */
{ 0x8F60,  1, 5, { 0x06, 0x0c, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-33 汁	# [cjk] */
{ 0x8F61,  1, 5, { 0x06, 0x0e, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-34 渋	# [cjk] */
{ 0x8F62,  1, 5, { 0x07, 0x03, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-35 獣	# [cjk] */
{ 0x8F63,  1, 5, { 0x07, 0x0e, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-36 縦	# [cjk] */
{ 0x8F64,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-37 重	# [cjk] */
{ 0x8F65,  1, 5, { 0x09, 0x02, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-38 銃	# [cjk] */
{ 0x8F66,  1, 5, { 0x05, 0x03, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-39 叔	# [cjk] */
{ 0x8F67,  1, 5, { 0x05, 0x09, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-40 夙	# [cjk] */
{ 0x8F68,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-41 宿	# [cjk] */
{ 0x8F69,  1, 5, { 0x06, 0x0d, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-42 淑	# [cjk] */
{ 0x8F6A,  1, 5, { 0x07, 0x09, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-43 祝	# [cjk] */
{ 0x8F6B,  1, 5, { 0x07, 0x0e, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-44 縮	# [cjk] */
{ 0x8F6C,  1, 5, { 0x07, 0x0c, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-45 粛	# [cjk] */
{ 0x8F6D,  1, 5, { 0x05, 0x08, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-46 塾	# [cjk] */
{ 0x8F6E,  1, 5, { 0x07, 0x01, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-47 熟	# [cjk] */
{ 0x8F6F,  1, 5, { 0x05, 0x01, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-48 出	# [cjk] */
{ 0x8F70,  1, 5, { 0x08, 0x08, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-49 術	# [cjk] */
{ 0x8F71,  1, 5, { 0x08, 0x0f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-50 述	# [cjk] */
{ 0x8F72,  1, 5, { 0x04, 0x0f, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-51 俊	# [cjk] */
{ 0x8F73,  1, 5, { 0x05, 0x0c, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-52 峻	# [cjk] */
{ 0x8F74,  1, 5, { 0x06, 0x06, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-53 春	# [cjk] */
{ 0x8F75,  1, 5, { 0x07, 0x07, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-54 瞬	# [cjk] */
{ 0x8F76,  1, 5, { 0x07, 0x0a, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-55 竣	# [cjk] */
{ 0x8F77,  1, 5, { 0x08, 0x02, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-56 舜	# [cjk] */
{ 0x8F78,  1, 5, { 0x09, 0x09, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-57 駿	# [cjk] */
{ 0x8F79,  1, 5, { 0x05, 0x01, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-58 准	# [cjk] */
{ 0x8F7A,  1, 5, { 0x05, 0x0f, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-59 循	# [cjk] */
{ 0x8F7B,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-60 旬	# [cjk] */
{ 0x8F7C,  1, 5, { 0x06, 0x09, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-61 楯	# [cjk] */
{ 0x8F7D,  1, 5, { 0x06, 0x0b, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-62 殉	# [cjk] */
{ 0x8F7E,  1, 5, { 0x06, 0x0d, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-63 淳	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x8F80,  1, 5, { 0x06, 0x0e, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-64 準	# [cjk] */
{ 0x8F81,  1, 5, { 0x06, 0x0f, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-65 潤	# [cjk] */
{ 0x8F82,  1, 5, { 0x07, 0x06, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-66 盾	# [cjk] */
{ 0x8F83,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-67 純	# [cjk] */
{ 0x8F84,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-68 巡	# [cjk] */
{ 0x8F85,  1, 5, { 0x09, 0x00, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-69 遵	# [cjk] */
{ 0x8F86,  1, 5, { 0x09, 0x01, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-70 醇	# [cjk] */
{ 0x8F87,  1, 5, { 0x09, 0x08, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-71 順	# [cjk] */
{ 0x8F88,  1, 5, { 0x05, 0x01, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-72 処	# [cjk] */
{ 0x8F89,  1, 5, { 0x05, 0x02, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-73 初	# [cjk] */
{ 0x8F8A,  1, 5, { 0x06, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-74 所	# [cjk] */
{ 0x8F8B,  1, 5, { 0x06, 0x06, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-75 暑	# [cjk] */
{ 0x8F8C,  1, 5, { 0x06, 0x06, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-76 曙	# [cjk] */
{ 0x8F8D,  1, 5, { 0x06, 0x0e, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-77 渚	# [cjk] */
{ 0x8F8E,  1, 5, { 0x05, 0x0e, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-78 庶	# [cjk] */
{ 0x8F8F,  1, 5, { 0x07, 0x0d, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-79 緒	# [cjk] */
{ 0x8F90,  1, 5, { 0x07, 0x0f, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-80 署	# [cjk] */
{ 0x8F91,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-81 書	# [cjk] */
{ 0x8F92,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-82 薯	# [cjk] */
{ 0x8F93,  1, 5, { 0x08, 0x05, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-83 藷	# [cjk] */
{ 0x8F94,  1, 5, { 0x08, 0x0a, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-84 諸	# [cjk] */
{ 0x8F95,  1, 5, { 0x05, 0x02, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-85 助	# [cjk] */
{ 0x8F96,  1, 5, { 0x05, 0x03, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-86 叙	# [cjk] */
{ 0x8F97,  1, 5, { 0x05, 0x09, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-87 女	# [cjk] */
{ 0x8F98,  1, 5, { 0x05, 0x0e, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-88 序	# [cjk] */
{ 0x8F99,  1, 5, { 0x05, 0x0f, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-89 徐	# [cjk] */
{ 0x8F9A,  1, 5, { 0x06, 0x00, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-90 恕	# [cjk] */
{ 0x8F9B,  1, 5, { 0x09, 0x02, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-91 鋤	# [cjk] */
{ 0x8F9C,  1, 5, { 0x09, 0x06, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-92 除	# [cjk] */
{ 0x8F9D,  1, 5, { 0x05, 0x00, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-93 傷	# [cjk] */
{ 0x8F9E,  1, 5, { 0x05, 0x01, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-29-94 償	# [cjk] */
{ 0x8F9F,  1, 5, { 0x05, 0x02, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-01 勝	# [cjk] */
{ 0x8FA0,  1, 5, { 0x05, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-02 匠	# [cjk] */
{ 0x8FA1,  1, 5, { 0x05, 0x03, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-03 升	# [cjk] */
{ 0x8FA2,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-04 召	# [cjk] */
{ 0x8FA3,  1, 5, { 0x05, 0x04, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-05 哨	# [cjk] */
{ 0x8FA4,  1, 5, { 0x05, 0x05, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-06 商	# [cjk] */
{ 0x8FA5,  1, 5, { 0x05, 0x05, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-07 唱	# [cjk] */
{ 0x8FA6,  1, 5, { 0x05, 0x06, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-08 嘗	# [cjk] */
{ 0x8FA7,  1, 5, { 0x05, 0x09, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-09 奨	# [cjk] */
{ 0x8FA8,  1, 5, { 0x05, 0x09, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-10 妾	# [cjk] */
{ 0x8FA9,  1, 5, { 0x05, 0x0a, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-11 娼	# [cjk] */
{ 0x8FAA,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-12 宵	# [cjk] */
{ 0x8FAB,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-13 将	# [cjk] */
{ 0x8FAC,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-14 小	# [cjk] */
{ 0x8FAD,  1, 5, { 0x05, 0x0c, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-15 少	# [cjk] */
{ 0x8FAE,  1, 5, { 0x05, 0x0c, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-16 尚	# [cjk] */
{ 0x8FAF,  1, 5, { 0x05, 0x0e, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-17 庄	# [cjk] */
{ 0x8FB0,  1, 5, { 0x05, 0x0e, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-18 床	# [cjk] */
{ 0x8FB1,  1, 5, { 0x05, 0x0e, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-19 廠	# [cjk] */
{ 0x8FB2,  1, 5, { 0x05, 0x0f, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-20 彰	# [cjk] */
{ 0x8FB3,  1, 5, { 0x06, 0x02, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-21 承	# [cjk] */
{ 0x8FB4,  1, 5, { 0x06, 0x02, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-22 抄	# [cjk] */
{ 0x8FB5,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-23 招	# [cjk] */
{ 0x8FB6,  1, 5, { 0x06, 0x03, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-24 掌	# [cjk] */
{ 0x8FB7,  1, 5, { 0x06, 0x03, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-25 捷	# [cjk] */
{ 0x8FB8,  1, 5, { 0x06, 0x06, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-26 昇	# [cjk] */
{ 0x8FB9,  1, 5, { 0x06, 0x06, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-27 昌	# [cjk] */
{ 0x8FBA,  1, 5, { 0x06, 0x06, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-28 昭	# [cjk] */
{ 0x8FBB,  1, 5, { 0x06, 0x06, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-29 晶	# [cjk] */
{ 0x8FBC,  1, 5, { 0x06, 0x07, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-30 松	# [cjk] */
{ 0x8FBD,  1, 5, { 0x06, 0x08, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-31 梢	# [cjk] */
{ 0x8FBE,  1, 5, { 0x06, 0x0a, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-32 樟	# [cjk] */
{ 0x8FBF,  1, 5, { 0x06, 0x0a, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-33 樵	# [cjk] */
{ 0x8FC0,  1, 5, { 0x06, 0x0c, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-34 沼	# [cjk] */
{ 0x8FC1,  1, 5, { 0x06, 0x0d, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-35 消	# [cjk] */
{ 0x8FC2,  1, 5, { 0x06, 0x0e, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-36 渉	# [cjk] */
{ 0x8FC3,  1, 5, { 0x06, 0x0e, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-37 湘	# [cjk] */
{ 0x8FC4,  1, 5, { 0x07, 0x01, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-38 焼	# [cjk] */
{ 0x8FC5,  1, 5, { 0x07, 0x01, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-39 焦	# [cjk] */
{ 0x8FC6,  1, 5, { 0x07, 0x01, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-40 照	# [cjk] */
{ 0x8FC7,  1, 5, { 0x07, 0x05, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-41 症	# [cjk] */
{ 0x8FC8,  1, 5, { 0x07, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-42 省	# [cjk] */
{ 0x8FC9,  1, 5, { 0x07, 0x08, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-43 硝	# [cjk] */
{ 0x8FCA,  1, 5, { 0x07, 0x09, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-44 礁	# [cjk] */
{ 0x8FCB,  1, 5, { 0x07, 0x09, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-45 祥	# [cjk] */
{ 0x8FCC,  1, 5, { 0x07, 0x09, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-46 称	# [cjk] */
{ 0x8FCD,  1, 5, { 0x07, 0x0a, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-47 章	# [cjk] */
{ 0x8FCE,  1, 5, { 0x07, 0x0b, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-48 笑	# [cjk] */
{ 0x8FCF,  1, 5, { 0x07, 0x0c, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-49 粧	# [cjk] */
{ 0x8FD0,  1, 5, { 0x07, 0x0d, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-50 紹	# [cjk] */
{ 0x8FD1,  1, 5, { 0x08, 0x00, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-51 肖	# [cjk] */
{ 0x8FD2,  1, 5, { 0x08, 0x03, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-52 菖	# [cjk] */
{ 0x8FD3,  1, 5, { 0x08, 0x04, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-53 蒋	# [cjk] */
{ 0x8FD4,  1, 5, { 0x08, 0x05, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-54 蕉	# [cjk] */
{ 0x8FD5,  1, 5, { 0x08, 0x08, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-55 衝	# [cjk] */
{ 0x8FD6,  1, 5, { 0x08, 0x08, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-56 裳	# [cjk] */
{ 0x8FD7,  1, 5, { 0x08, 0x0a, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-57 訟	# [cjk] */
{ 0x8FD8,  1, 5, { 0x08, 0x0a, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-58 証	# [cjk] */
{ 0x8FD9,  1, 5, { 0x08, 0x0a, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-59 詔	# [cjk] */
{ 0x8FDA,  1, 5, { 0x08, 0x0a, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-60 詳	# [cjk] */
{ 0x8FDB,  1, 5, { 0x08, 0x0c, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-61 象	# [cjk] */
{ 0x8FDC,  1, 5, { 0x08, 0x0c, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-62 賞	# [cjk] */
{ 0x8FDD,  1, 5, { 0x09, 0x01, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-63 醤	# [cjk] */
{ 0x8FDE,  1, 5, { 0x09, 0x02, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-64 鉦	# [cjk] */
{ 0x8FDF,  1, 5, { 0x09, 0x03, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-65 鍾	# [cjk] */
{ 0x8FE0,  1, 5, { 0x09, 0x04, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-66 鐘	# [cjk] */
{ 0x8FE1,  1, 5, { 0x09, 0x06, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-67 障	# [cjk] */
{ 0x8FE2,  1, 5, { 0x09, 0x07, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-68 鞘	# [cjk] */
{ 0x8FE3,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-69 上	# [cjk] */
{ 0x8FE4,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-70 丈	# [cjk] */
{ 0x8FE5,  1, 5, { 0x04, 0x0e, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-71 丞	# [cjk] */
{ 0x8FE6,  1, 5, { 0x04, 0x0e, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-72 乗	# [cjk] */
{ 0x8FE7,  1, 5, { 0x05, 0x01, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-73 冗	# [cjk] */
{ 0x8FE8,  1, 5, { 0x05, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-74 剰	# [cjk] */
{ 0x8FE9,  1, 5, { 0x05, 0x07, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-75 城	# [cjk] */
{ 0x8FEA,  1, 5, { 0x05, 0x08, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-76 場	# [cjk] */
{ 0x8FEB,  1, 5, { 0x05, 0x08, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-77 壌	# [cjk] */
{ 0x8FEC,  1, 5, { 0x05, 0x0b, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-78 嬢	# [cjk] */
{ 0x8FED,  1, 5, { 0x05, 0x0e, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-79 常	# [cjk] */
{ 0x8FEE,  1, 5, { 0x06, 0x00, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-80 情	# [cjk] */
{ 0x8FEF,  1, 5, { 0x06, 0x04, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-81 擾	# [cjk] */
{ 0x8FF0,  1, 5, { 0x06, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-82 条	# [cjk] */
{ 0x8FF1,  1, 5, { 0x06, 0x07, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-83 杖	# [cjk] */
{ 0x8FF2,  1, 5, { 0x06, 0x0d, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-84 浄	# [cjk] */
{ 0x8FF3,  1, 5, { 0x07, 0x02, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-85 状	# [cjk] */
{ 0x8FF4,  1, 5, { 0x07, 0x05, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-86 畳	# [cjk] */
{ 0x8FF5,  1, 5, { 0x07, 0x0a, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-87 穣	# [cjk] */
{ 0x8FF6,  1, 5, { 0x08, 0x04, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-88 蒸	# [cjk] */
{ 0x8FF7,  1, 5, { 0x08, 0x0b, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-89 譲	# [cjk] */
{ 0x8FF8,  1, 5, { 0x09, 0x01, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-90 醸	# [cjk] */
{ 0x8FF9,  1, 5, { 0x09, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-91 錠	# [cjk] */
{ 0x8FFA,  1, 5, { 0x05, 0x06, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-92 嘱	# [cjk] */
{ 0x8FFB,  1, 5, { 0x05, 0x07, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-93 埴	# [cjk] */
{ 0x8FFC,  1, 5, { 0x09, 0x08, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-30-94 飾	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9040,  1, 5, { 0x06, 0x02, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-01 拭	# [cjk] */
{ 0x9041,  1, 5, { 0x06, 0x09, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-02 植	# [cjk] */
{ 0x9042,  1, 5, { 0x06, 0x0b, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-03 殖	# [cjk] */
{ 0x9043,  1, 5, { 0x07, 0x01, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-04 燭	# [cjk] */
{ 0x9044,  1, 5, { 0x07, 0x0e, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-05 織	# [cjk] */
{ 0x9045,  1, 5, { 0x08, 0x00, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-06 職	# [cjk] */
{ 0x9046,  1, 5, { 0x08, 0x02, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-07 色	# [cjk] */
{ 0x9047,  1, 5, { 0x08, 0x09, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-08 触	# [cjk] */
{ 0x9048,  1, 5, { 0x09, 0x08, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-09 食	# [cjk] */
{ 0x9049,  1, 5, { 0x08, 0x07, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-10 蝕	# [cjk] */
{ 0x904A,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-11 辱	# [cjk] */
{ 0x904B,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-12 尻	# [cjk] */
{ 0x904C,  1, 5, { 0x04, 0x0f, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-13 伸	# [cjk] */
{ 0x904D,  1, 5, { 0x04, 0x0f, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-14 信	# [cjk] */
{ 0x904E,  1, 5, { 0x04, 0x0f, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-15 侵	# [cjk] */
{ 0x904F,  1, 5, { 0x05, 0x05, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-16 唇	# [cjk] */
{ 0x9050,  1, 5, { 0x05, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-17 娠	# [cjk] */
{ 0x9051,  1, 5, { 0x05, 0x0b, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-18 寝	# [cjk] */
{ 0x9052,  1, 5, { 0x05, 0x0b, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-19 審	# [cjk] */
{ 0x9053,  1, 5, { 0x05, 0x0f, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-20 心	# [cjk] */
{ 0x9054,  1, 5, { 0x06, 0x01, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-21 慎	# [cjk] */
{ 0x9055,  1, 5, { 0x06, 0x03, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-22 振	# [cjk] */
{ 0x9056,  1, 5, { 0x06, 0x05, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-23 新	# [cjk] */
{ 0x9057,  1, 5, { 0x06, 0x06, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-24 晋	# [cjk] */
{ 0x9058,  1, 5, { 0x06, 0x08, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-25 森	# [cjk] */
{ 0x9059,  1, 5, { 0x06, 0x09, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-26 榛	# [cjk] */
{ 0x905A,  1, 5, { 0x06, 0x0d, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-27 浸	# [cjk] */
{ 0x905B,  1, 5, { 0x06, 0x0d, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-28 深	# [cjk] */
{ 0x905C,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-29 申	# [cjk] */
{ 0x905D,  1, 5, { 0x07, 0x05, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-30 疹	# [cjk] */
{ 0x905E,  1, 5, { 0x07, 0x07, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-31 真	# [cjk] */
{ 0x905F,  1, 5, { 0x07, 0x09, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-32 神	# [cjk] */
{ 0x9060,  1, 5, { 0x07, 0x09, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-33 秦	# [cjk] */
{ 0x9061,  1, 5, { 0x07, 0x0d, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-34 紳	# [cjk] */
{ 0x9062,  1, 5, { 0x08, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-35 臣	# [cjk] */
{ 0x9063,  1, 5, { 0x08, 0x02, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-36 芯	# [cjk] */
{ 0x9064,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-37 薪	# [cjk] */
{ 0x9065,  1, 5, { 0x08, 0x09, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-38 親	# [cjk] */
{ 0x9066,  1, 5, { 0x08, 0x0a, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-39 診	# [cjk] */
{ 0x9067,  1, 5, { 0x08, 0x0e, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-40 身	# [cjk] */
{ 0x9068,  1, 5, { 0x08, 0x0f, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-41 辛	# [cjk] */
{ 0x9069,  1, 5, { 0x09, 0x00, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-42 進	# [cjk] */
{ 0x906A,  1, 5, { 0x09, 0x01, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-43 針	# [cjk] */
{ 0x906B,  1, 5, { 0x09, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-44 震	# [cjk] */
{ 0x906C,  1, 5, { 0x04, 0x0e, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-45 人	# [cjk] */
{ 0x906D,  1, 5, { 0x04, 0x0e, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-46 仁	# [cjk] */
{ 0x906E,  1, 5, { 0x05, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-47 刃	# [cjk] */
{ 0x906F,  1, 5, { 0x05, 0x08, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-48 塵	# [cjk] */
{ 0x9070,  1, 5, { 0x05, 0x08, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-49 壬	# [cjk] */
{ 0x9071,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-50 尋	# [cjk] */
{ 0x9072,  1, 5, { 0x07, 0x05, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-51 甚	# [cjk] */
{ 0x9073,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-52 尽	# [cjk] */
{ 0x9074,  1, 5, { 0x08, 0x01, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-53 腎	# [cjk] */
{ 0x9075,  1, 5, { 0x08, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-54 訊	# [cjk] */
{ 0x9076,  1, 5, { 0x08, 0x0f, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-55 迅	# [cjk] */
{ 0x9077,  1, 5, { 0x09, 0x06, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-56 陣	# [cjk] */
{ 0x9078,  1, 5, { 0x09, 0x07, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-57 靭	# [cjk] */
{ 0x9079,  1, 5, { 0x07, 0x0b, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-58 笥	# [cjk] */
{ 0x907A,  1, 5, { 0x08, 0x0a, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-59 諏	# [cjk] */
{ 0x907B,  1, 5, { 0x09, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-60 須	# [cjk] */
{ 0x907C,  1, 5, { 0x09, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-61 酢	# [cjk] */
{ 0x907D,  1, 5, { 0x05, 0x06, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-62 図	# [cjk] */
{ 0x907E,  1, 5, { 0x05, 0x03, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-63 厨	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9080,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-64 逗	# [cjk] */
{ 0x9081,  1, 5, { 0x05, 0x04, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-65 吹	# [cjk] */
{ 0x9082,  1, 5, { 0x05, 0x07, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-66 垂	# [cjk] */
{ 0x9083,  1, 5, { 0x05, 0x0e, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-67 帥	# [cjk] */
{ 0x9084,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-68 推	# [cjk] */
{ 0x9085,  1, 5, { 0x06, 0x0c, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-69 水	# [cjk] */
{ 0x9086,  1, 5, { 0x07, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-70 炊	# [cjk] */
{ 0x9087,  1, 5, { 0x07, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-71 睡	# [cjk] */
{ 0x9088,  1, 5, { 0x07, 0x0c, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-72 粋	# [cjk] */
{ 0x9089,  1, 5, { 0x07, 0x0f, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-73 翠	# [cjk] */
{ 0x908A,  1, 5, { 0x08, 0x08, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-74 衰	# [cjk] */
{ 0x908B,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-75 遂	# [cjk] */
{ 0x908C,  1, 5, { 0x09, 0x01, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-76 酔	# [cjk] */
{ 0x908D,  1, 5, { 0x09, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-77 錐	# [cjk] */
{ 0x908E,  1, 5, { 0x09, 0x03, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-78 錘	# [cjk] */
{ 0x908F,  1, 5, { 0x09, 0x06, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-79 随	# [cjk] */
{ 0x9090,  1, 5, { 0x07, 0x04, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-80 瑞	# [cjk] */
{ 0x9091,  1, 5, { 0x09, 0x0a, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-81 髄	# [cjk] */
{ 0x9092,  1, 5, { 0x05, 0x0d, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-82 崇	# [cjk] */
{ 0x9093,  1, 5, { 0x05, 0x0d, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-83 嵩	# [cjk] */
{ 0x9094,  1, 5, { 0x06, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-84 数	# [cjk] */
{ 0x9095,  1, 5, { 0x06, 0x07, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-85 枢	# [cjk] */
{ 0x9096,  1, 5, { 0x08, 0x0d, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-86 趨	# [cjk] */
{ 0x9097,  1, 5, { 0x09, 0x06, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-87 雛	# [cjk] */
{ 0x9098,  1, 5, { 0x06, 0x03, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-88 据	# [cjk] */
{ 0x9099,  1, 5, { 0x06, 0x07, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-89 杉	# [cjk] */
{ 0x909A,  1, 5, { 0x06, 0x09, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-90 椙	# [cjk] */
{ 0x909B,  1, 5, { 0x08, 0x03, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-91 菅	# [cjk] */
{ 0x909C,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-92 頗	# [cjk] */
{ 0x909D,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-93 雀	# [cjk] */
{ 0x909E,  1, 5, { 0x08, 0x08, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-31-94 裾	# [cjk] */
{ 0x909F,  1, 5, { 0x06, 0x0f, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-01 澄	# [cjk] */
{ 0x90A0,  1, 5, { 0x06, 0x04, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-02 摺	# [cjk] */
{ 0x90A1,  1, 5, { 0x05, 0x0b, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-03 寸	# [cjk] */
{ 0x90A2,  1, 5, { 0x04, 0x0e, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-04 世	# [cjk] */
{ 0x90A3,  1, 5, { 0x07, 0x00, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-05 瀬	# [cjk] */
{ 0x90A4,  1, 5, { 0x07, 0x05, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-06 畝	# [cjk] */
{ 0x90A5,  1, 5, { 0x06, 0x06, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-07 是	# [cjk] */
{ 0x90A6,  1, 5, { 0x05, 0x01, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-08 凄	# [cjk] */
{ 0x90A7,  1, 5, { 0x05, 0x02, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-09 制	# [cjk] */
{ 0x90A8,  1, 5, { 0x05, 0x02, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-10 勢	# [cjk] */
{ 0x90A9,  1, 5, { 0x05, 0x09, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-11 姓	# [cjk] */
{ 0x90AA,  1, 5, { 0x05, 0x0f, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-12 征	# [cjk] */
{ 0x90AB,  1, 5, { 0x06, 0x00, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-13 性	# [cjk] */
{ 0x90AC,  1, 5, { 0x06, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-14 成	# [cjk] */
{ 0x90AD,  1, 5, { 0x06, 0x05, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-15 政	# [cjk] */
{ 0x90AE,  1, 5, { 0x06, 0x05, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-16 整	# [cjk] */
{ 0x90AF,  1, 5, { 0x06, 0x06, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-17 星	# [cjk] */
{ 0x90B0,  1, 5, { 0x06, 0x06, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-18 晴	# [cjk] */
{ 0x90B1,  1, 5, { 0x06, 0x08, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-19 棲	# [cjk] */
{ 0x90B2,  1, 5, { 0x06, 0x08, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-20 栖	# [cjk] */
{ 0x90B3,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-21 正	# [cjk] */
{ 0x90B4,  1, 5, { 0x06, 0x0e, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-22 清	# [cjk] */
{ 0x90B5,  1, 5, { 0x07, 0x02, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-23 牲	# [cjk] */
{ 0x90B6,  1, 5, { 0x07, 0x05, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-24 生	# [cjk] */
{ 0x90B7,  1, 5, { 0x07, 0x06, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-25 盛	# [cjk] */
{ 0x90B8,  1, 5, { 0x07, 0x0c, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-26 精	# [cjk] */
{ 0x90B9,  1, 5, { 0x08, 0x00, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-27 聖	# [cjk] */
{ 0x90BA,  1, 5, { 0x05, 0x08, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-28 声	# [cjk] */
{ 0x90BB,  1, 5, { 0x08, 0x08, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-29 製	# [cjk] */
{ 0x90BC,  1, 5, { 0x08, 0x09, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-30 西	# [cjk] */
{ 0x90BD,  1, 5, { 0x08, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-31 誠	# [cjk] */
{ 0x90BE,  1, 5, { 0x08, 0x0a, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-32 誓	# [cjk] */
{ 0x90BF,  1, 5, { 0x08, 0x0a, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-33 請	# [cjk] */
{ 0x90C0,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-34 逝	# [cjk] */
{ 0x90C1,  1, 5, { 0x09, 0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-35 醒	# [cjk] */
{ 0x90C2,  1, 5, { 0x09, 0x07, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-36 青	# [cjk] */
{ 0x90C3,  1, 5, { 0x09, 0x07, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-37 静	# [cjk] */
{ 0x90C4,  1, 5, { 0x06, 0x05, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-38 斉	# [cjk] */
{ 0x90C5,  1, 5, { 0x07, 0x0a, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-39 税	# [cjk] */
{ 0x90C6,  1, 5, { 0x08, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-40 脆	# [cjk] */
{ 0x90C7,  1, 5, { 0x09, 0x06, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-41 隻	# [cjk] */
{ 0x90C8,  1, 5, { 0x05, 0x0e, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-42 席	# [cjk] */
{ 0x90C9,  1, 5, { 0x06, 0x00, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-43 惜	# [cjk] */
{ 0x90CA,  1, 5, { 0x06, 0x02, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-44 戚	# [cjk] */
{ 0x90CB,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-45 斥	# [cjk] */
{ 0x90CC,  1, 5, { 0x06, 0x06, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-46 昔	# [cjk] */
{ 0x90CD,  1, 5, { 0x06, 0x07, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-47 析	# [cjk] */
{ 0x90CE,  1, 5, { 0x07, 0x07, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-48 石	# [cjk] */
{ 0x90CF,  1, 5, { 0x07, 0x0a, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-49 積	# [cjk] */
{ 0x90D0,  1, 5, { 0x07, 0x0c, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-50 籍	# [cjk] */
{ 0x90D1,  1, 5, { 0x07, 0x0e, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-51 績	# [cjk] */
{ 0x90D2,  1, 5, { 0x08, 0x01, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-52 脊	# [cjk] */
{ 0x90D3,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-53 責	# [cjk] */
{ 0x90D4,  1, 5, { 0x08, 0x0d, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-54 赤	# [cjk] */
{ 0x90D5,  1, 5, { 0x08, 0x0d, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-55 跡	# [cjk] */
{ 0x90D6,  1, 5, { 0x08, 0x0e, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-56 蹟	# [cjk] */
{ 0x90D7,  1, 5, { 0x07, 0x08, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-57 碩	# [cjk] */
{ 0x90D8,  1, 5, { 0x05, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-58 切	# [cjk] */
{ 0x90D9,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-59 拙	# [cjk] */
{ 0x90DA,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-60 接	# [cjk] */
{ 0x90DB,  1, 5, { 0x06, 0x04, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-61 摂	# [cjk] */
{ 0x90DC,  1, 5, { 0x06, 0x02, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-62 折	# [cjk] */
{ 0x90DD,  1, 5, { 0x08, 0x0a, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-63 設	# [cjk] */
{ 0x90DE,  1, 5, { 0x07, 0x0a, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-64 窃	# [cjk] */
{ 0x90DF,  1, 5, { 0x07, 0x0b, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-65 節	# [cjk] */
{ 0x90E0,  1, 5, { 0x08, 0x0a, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-66 説	# [cjk] */
{ 0x90E1,  1, 5, { 0x09, 0x06, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-67 雪	# [cjk] */
{ 0x90E2,  1, 5, { 0x07, 0x0d, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-68 絶	# [cjk] */
{ 0x90E3,  1, 5, { 0x08, 0x02, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-69 舌	# [cjk] */
{ 0x90E4,  1, 5, { 0x08, 0x07, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-70 蝉	# [cjk] */
{ 0x90E5,  1, 5, { 0x04, 0x0e, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-71 仙	# [cjk] */
{ 0x90E6,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-72 先	# [cjk] */
{ 0x90E7,  1, 5, { 0x05, 0x03, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-73 千	# [cjk] */
{ 0x90E8,  1, 5, { 0x05, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-74 占	# [cjk] */
{ 0x90E9,  1, 5, { 0x05, 0x0b, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-75 宣	# [cjk] */
{ 0x90EA,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-76 専	# [cjk] */
{ 0x90EB,  1, 5, { 0x05, 0x0c, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-77 尖	# [cjk] */
{ 0x90EC,  1, 5, { 0x05, 0x0d, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-78 川	# [cjk] */
{ 0x90ED,  1, 5, { 0x06, 0x02, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-79 戦	# [cjk] */
{ 0x90EE,  1, 5, { 0x06, 0x02, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-80 扇	# [cjk] */
{ 0x90EF,  1, 5, { 0x06, 0x04, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-81 撰	# [cjk] */
{ 0x90F0,  1, 5, { 0x06, 0x08, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-82 栓	# [cjk] */
{ 0x90F1,  1, 5, { 0x06, 0x08, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-83 栴	# [cjk] */
{ 0x90F2,  1, 5, { 0x06, 0x0c, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-84 泉	# [cjk] */
{ 0x90F3,  1, 5, { 0x06, 0x0d, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-85 浅	# [cjk] */
{ 0x90F4,  1, 5, { 0x06, 0x0d, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-86 洗	# [cjk] */
{ 0x90F5,  1, 5, { 0x06, 0x07, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-87 染	# [cjk] */
{ 0x90F6,  1, 5, { 0x06, 0x0f, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-88 潜	# [cjk] */
{ 0x90F7,  1, 5, { 0x07, 0x01, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-89 煎	# [cjk] */
{ 0x90F8,  1, 5, { 0x07, 0x01, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-90 煽	# [cjk] */
{ 0x90F9,  1, 5, { 0x06, 0x05, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-91 旋	# [cjk] */
{ 0x90FA,  1, 5, { 0x07, 0x0a, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-92 穿	# [cjk] */
{ 0x90FB,  1, 5, { 0x07, 0x0b, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-93 箭	# [cjk] */
{ 0x90FC,  1, 5, { 0x07, 0x0d, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-32-94 線	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9140,  1, 5, { 0x07, 0x0e, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-01 繊	# [cjk] */
{ 0x9141,  1, 5, { 0x07, 0x0f, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-02 羨	# [cjk] */
{ 0x9142,  1, 5, { 0x08, 0x01, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-03 腺	# [cjk] */
{ 0x9143,  1, 5, { 0x08, 0x02, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-04 舛	# [cjk] */
{ 0x9144,  1, 5, { 0x08, 0x02, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-05 船	# [cjk] */
{ 0x9145,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-06 薦	# [cjk] */
{ 0x9146,  1, 5, { 0x08, 0x0a, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-07 詮	# [cjk] */
{ 0x9147,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-08 賎	# [cjk] */
{ 0x9148,  1, 5, { 0x08, 0x0d, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-09 践	# [cjk] */
{ 0x9149,  1, 5, { 0x09, 0x00, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-10 選	# [cjk] */
{ 0x914A,  1, 5, { 0x09, 0x00, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-11 遷	# [cjk] */
{ 0x914B,  1, 5, { 0x09, 0x02, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-12 銭	# [cjk] */
{ 0x914C,  1, 5, { 0x09, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-13 銑	# [cjk] */
{ 0x914D,  1, 5, { 0x09, 0x05, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-14 閃	# [cjk] */
{ 0x914E,  1, 5, { 0x09, 0x0b, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-15 鮮	# [cjk] */
{ 0x914F,  1, 5, { 0x05, 0x02, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-16 前	# [cjk] */
{ 0x9150,  1, 5, { 0x05, 0x05, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-17 善	# [cjk] */
{ 0x9151,  1, 5, { 0x06, 0x0f, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-18 漸	# [cjk] */
{ 0x9152,  1, 5, { 0x07, 0x01, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-19 然	# [cjk] */
{ 0x9153,  1, 5, { 0x05, 0x01, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-20 全	# [cjk] */
{ 0x9154,  1, 5, { 0x07, 0x09, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-21 禅	# [cjk] */
{ 0x9155,  1, 5, { 0x07, 0x0e, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-22 繕	# [cjk] */
{ 0x9156,  1, 5, { 0x08, 0x01, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-23 膳	# [cjk] */
{ 0x9157,  1, 5, { 0x07, 0x0c, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-24 糎	# [cjk] */
{ 0x9158,  1, 5, { 0x05, 0x06, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-25 噌	# [cjk] */
{ 0x9159,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-26 塑	# [cjk] */
{ 0x915A,  1, 5, { 0x05, 0x0c, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-27 岨	# [cjk] */
{ 0x915B,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-28 措	# [cjk] */
{ 0x915C,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-29 曾	# [cjk] */
{ 0x915D,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-30 曽	# [cjk] */
{ 0x915E,  1, 5, { 0x06, 0x09, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-31 楚	# [cjk] */
{ 0x915F,  1, 5, { 0x07, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-32 狙	# [cjk] */
{ 0x9160,  1, 5, { 0x07, 0x05, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-33 疏	# [cjk] */
{ 0x9161,  1, 5, { 0x07, 0x05, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-34 疎	# [cjk] */
{ 0x9162,  1, 5, { 0x07, 0x09, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-35 礎	# [cjk] */
{ 0x9163,  1, 5, { 0x07, 0x09, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-36 祖	# [cjk] */
{ 0x9164,  1, 5, { 0x07, 0x09, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-37 租	# [cjk] */
{ 0x9165,  1, 5, { 0x07, 0x0c, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-38 粗	# [cjk] */
{ 0x9166,  1, 5, { 0x07, 0x0d, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-39 素	# [cjk] */
{ 0x9167,  1, 5, { 0x07, 0x0d, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-40 組	# [cjk] */
{ 0x9168,  1, 5, { 0x08, 0x06, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-41 蘇	# [cjk] */
{ 0x9169,  1, 5, { 0x08, 0x0a, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-42 訴	# [cjk] */
{ 0x916A,  1, 5, { 0x09, 0x06, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-43 阻	# [cjk] */
{ 0x916B,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-44 遡	# [cjk] */
{ 0x916C,  1, 5, { 0x09, 0x0f, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-45 鼠	# [cjk] */
{ 0x916D,  1, 5, { 0x05, 0x00, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-46 僧	# [cjk] */
{ 0x916E,  1, 5, { 0x05, 0x02, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-47 創	# [cjk] */
{ 0x916F,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-48 双	# [cjk] */
{ 0x9170,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-49 叢	# [cjk] */
{ 0x9171,  1, 5, { 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-50 倉	# [cjk] */
{ 0x9172,  1, 5, { 0x05, 0x05, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-51 喪	# [cjk] */
{ 0x9173,  1, 5, { 0x05, 0x08, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-52 壮	# [cjk] */
{ 0x9174,  1, 5, { 0x05, 0x09, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-53 奏	# [cjk] */
{ 0x9175,  1, 5, { 0x07, 0x02, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-54 爽	# [cjk] */
{ 0x9176,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-55 宋	# [cjk] */
{ 0x9177,  1, 5, { 0x05, 0x0c, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-56 層	# [cjk] */
{ 0x9178,  1, 5, { 0x05, 0x03, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-57 匝	# [cjk] */
{ 0x9179,  1, 5, { 0x06, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-58 惣	# [cjk] */
{ 0x917A,  1, 5, { 0x06, 0x00, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-59 想	# [cjk] */
{ 0x917B,  1, 5, { 0x06, 0x03, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-60 捜	# [cjk] */
{ 0x917C,  1, 5, { 0x06, 0x03, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-61 掃	# [cjk] */
{ 0x917D,  1, 5, { 0x06, 0x03, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-62 挿	# [cjk] */
{ 0x917E,  1, 5, { 0x06, 0x03, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-63 掻	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9180,  1, 5, { 0x06, 0x04, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-64 操	# [cjk] */
{ 0x9181,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-65 早	# [cjk] */
{ 0x9182,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-66 曹	# [cjk] */
{ 0x9183,  1, 5, { 0x05, 0x0d, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-67 巣	# [cjk] */
{ 0x9184,  1, 5, { 0x06, 0x09, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-68 槍	# [cjk] */
{ 0x9185,  1, 5, { 0x06, 0x09, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-69 槽	# [cjk] */
{ 0x9186,  1, 5, { 0x06, 0x0f, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-70 漕	# [cjk] */
{ 0x9187,  1, 5, { 0x07, 0x01, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-71 燥	# [cjk] */
{ 0x9188,  1, 5, { 0x04, 0x0e, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-72 争	# [cjk] */
{ 0x9189,  1, 5, { 0x07, 0x05, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-73 痩	# [cjk] */
{ 0x918A,  1, 5, { 0x07, 0x06, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-74 相	# [cjk] */
{ 0x918B,  1, 5, { 0x07, 0x0a, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-75 窓	# [cjk] */
{ 0x918C,  1, 5, { 0x07, 0x0c, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-76 糟	# [cjk] */
{ 0x918D,  1, 5, { 0x07, 0x0d, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-77 総	# [cjk] */
{ 0x918E,  1, 5, { 0x07, 0x0d, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-78 綜	# [cjk] */
{ 0x918F,  1, 5, { 0x08, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-79 聡	# [cjk] */
{ 0x9190,  1, 5, { 0x08, 0x03, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-80 草	# [cjk] */
{ 0x9191,  1, 5, { 0x08, 0x03, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-81 荘	# [cjk] */
{ 0x9192,  1, 5, { 0x08, 0x04, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-82 葬	# [cjk] */
{ 0x9193,  1, 5, { 0x08, 0x04, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-83 蒼	# [cjk] */
{ 0x9194,  1, 5, { 0x08, 0x05, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-84 藻	# [cjk] */
{ 0x9195,  1, 5, { 0x08, 0x08, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-85 装	# [cjk] */
{ 0x9196,  1, 5, { 0x08, 0x0d, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-86 走	# [cjk] */
{ 0x9197,  1, 5, { 0x09, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-87 送	# [cjk] */
{ 0x9198,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-88 遭	# [cjk] */
{ 0x9199,  1, 5, { 0x09, 0x03, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-89 鎗	# [cjk] */
{ 0x919A,  1, 5, { 0x09, 0x07, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-90 霜	# [cjk] */
{ 0x919B,  1, 5, { 0x09, 0x0a, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-91 騒	# [cjk] */
{ 0x919C,  1, 5, { 0x05, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-92 像	# [cjk] */
{ 0x919D,  1, 5, { 0x05, 0x08, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-93 増	# [cjk] */
{ 0x919E,  1, 5, { 0x06, 0x01, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-33-94 憎	# [cjk] */
{ 0x919F,  1, 5, { 0x08, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-01 臓	# [cjk] */
{ 0x91A0,  1, 5, { 0x08, 0x05, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-02 蔵	# [cjk] */
{ 0x91A1,  1, 5, { 0x08, 0x0d, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-03 贈	# [cjk] */
{ 0x91A2,  1, 5, { 0x09, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-04 造	# [cjk] */
{ 0x91A3,  1, 5, { 0x04, 0x0f, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-05 促	# [cjk] */
{ 0x91A4,  1, 5, { 0x05, 0x00, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-06 側	# [cjk] */
{ 0x91A5,  1, 5, { 0x05, 0x02, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-07 則	# [cjk] */
{ 0x91A6,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-08 即	# [cjk] */
{ 0x91A7,  1, 5, { 0x06, 0x00, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-09 息	# [cjk] */
{ 0x91A8,  1, 5, { 0x06, 0x03, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-10 捉	# [cjk] */
{ 0x91A9,  1, 5, { 0x06, 0x07, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-11 束	# [cjk] */
{ 0x91AA,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-12 測	# [cjk] */
{ 0x91AB,  1, 5, { 0x08, 0x0d, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-13 足	# [cjk] */
{ 0x91AC,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-14 速	# [cjk] */
{ 0x91AD,  1, 5, { 0x04, 0x0f, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-15 俗	# [cjk] */
{ 0x91AE,  1, 5, { 0x05, 0x0c, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-16 属	# [cjk] */
{ 0x91AF,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-17 賊	# [cjk] */
{ 0x91B0,  1, 5, { 0x06, 0x05, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-18 族	# [cjk] */
{ 0x91B1,  1, 5, { 0x07, 0x0d, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-19 続	# [cjk] */
{ 0x91B2,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-20 卒	# [cjk] */
{ 0x91B3,  1, 5, { 0x08, 0x08, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-21 袖	# [cjk] */
{ 0x91B4,  1, 5, { 0x05, 0x01, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-22 其	# [cjk] */
{ 0x91B5,  1, 5, { 0x06, 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-23 揃	# [cjk] */
{ 0x91B6,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-24 存	# [cjk] */
{ 0x91B7,  1, 5, { 0x05, 0x0b, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-25 孫	# [cjk] */
{ 0x91B8,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-26 尊	# [cjk] */
{ 0x91B9,  1, 5, { 0x06, 0x04, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-27 損	# [cjk] */
{ 0x91BA,  1, 5, { 0x06, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-28 村	# [cjk] */
{ 0x91BB,  1, 5, { 0x09, 0x00, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-29 遜	# [cjk] */
{ 0x91BC,  1, 5, { 0x04, 0x0e, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-30 他	# [cjk] */
{ 0x91BD,  1, 5, { 0x05, 0x09, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-31 多	# [cjk] */
{ 0x91BE,  1, 5, { 0x05, 0x09, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-32 太	# [cjk] */
{ 0x91BF,  1, 5, { 0x06, 0x0c, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-33 汰	# [cjk] */
{ 0x91C0,  1, 5, { 0x08, 0x0a, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-34 詑	# [cjk] */
{ 0x91C1,  1, 5, { 0x05, 0x05, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-35 唾	# [cjk] */
{ 0x91C2,  1, 5, { 0x05, 0x08, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-36 堕	# [cjk] */
{ 0x91C3,  1, 5, { 0x05, 0x09, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-37 妥	# [cjk] */
{ 0x91C4,  1, 5, { 0x06, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-38 惰	# [cjk] */
{ 0x91C5,  1, 5, { 0x06, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-39 打	# [cjk] */
{ 0x91C6,  1, 5, { 0x06, 0x07, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-40 柁	# [cjk] */
{ 0x91C7,  1, 5, { 0x08, 0x02, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-41 舵	# [cjk] */
{ 0x91C8,  1, 5, { 0x06, 0x09, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-42 楕	# [cjk] */
{ 0x91C9,  1, 5, { 0x09, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-43 陀	# [cjk] */
{ 0x91CA,  1, 5, { 0x09, 0x09, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-44 駄	# [cjk] */
{ 0x91CB,  1, 5, { 0x09, 0x0a, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-45 騨	# [cjk] */
{ 0x91CC,  1, 5, { 0x04, 0x0f, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-46 体	# [cjk] */
{ 0x91CD,  1, 5, { 0x05, 0x08, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-47 堆	# [cjk] */
{ 0x91CE,  1, 5, { 0x05, 0x0b, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-48 対	# [cjk] */
{ 0x91CF,  1, 5, { 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-49 耐	# [cjk] */
{ 0x91D0,  1, 5, { 0x05, 0x0c, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-50 岱	# [cjk] */
{ 0x91D1,  1, 5, { 0x05, 0x0e, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-51 帯	# [cjk] */
{ 0x91D2,  1, 5, { 0x05, 0x0f, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-52 待	# [cjk] */
{ 0x91D3,  1, 5, { 0x06, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-53 怠	# [cjk] */
{ 0x91D4,  1, 5, { 0x06, 0x01, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-54 態	# [cjk] */
{ 0x91D5,  1, 5, { 0x06, 0x02, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-55 戴	# [cjk] */
{ 0x91D6,  1, 5, { 0x06, 0x06, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-56 替	# [cjk] */
{ 0x91D7,  1, 5, { 0x06, 0x0c, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-57 泰	# [cjk] */
{ 0x91D8,  1, 5, { 0x06, 0x0e, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-58 滞	# [cjk] */
{ 0x91D9,  1, 5, { 0x08, 0x00, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-59 胎	# [cjk] */
{ 0x91DA,  1, 5, { 0x08, 0x01, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-60 腿	# [cjk] */
{ 0x91DB,  1, 5, { 0x08, 0x02, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-61 苔	# [cjk] */
{ 0x91DC,  1, 5, { 0x08, 0x08, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-62 袋	# [cjk] */
{ 0x91DD,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-63 貸	# [cjk] */
{ 0x91DE,  1, 5, { 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-64 退	# [cjk] */
{ 0x91DF,  1, 5, { 0x09, 0x00, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-65 逮	# [cjk] */
{ 0x91E0,  1, 5, { 0x09, 0x06, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-66 隊	# [cjk] */
{ 0x91E1,  1, 5, { 0x09, 0x0e, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-67 黛	# [cjk] */
{ 0x91E2,  1, 5, { 0x09, 0x0b, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-68 鯛	# [cjk] */
{ 0x91E3,  1, 5, { 0x04, 0x0e, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-69 代	# [cjk] */
{ 0x91E4,  1, 5, { 0x05, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-70 台	# [cjk] */
{ 0x91E5,  1, 5, { 0x05, 0x09, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-71 大	# [cjk] */
{ 0x91E6,  1, 5, { 0x07, 0x0b, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-72 第	# [cjk] */
{ 0x91E7,  1, 5, { 0x09, 0x01, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-73 醍	# [cjk] */
{ 0x91E8,  1, 5, { 0x09, 0x08, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-74 題	# [cjk] */
{ 0x91E9,  1, 5, { 0x09, 0x0d, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-75 鷹	# [cjk] */
{ 0x91EA,  1, 5, { 0x06, 0x0e, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-76 滝	# [cjk] */
{ 0x91EB,  1, 5, { 0x07, 0x00, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-77 瀧	# [cjk] */
{ 0x91EC,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-78 卓	# [cjk] */
{ 0x91ED,  1, 5, { 0x05, 0x05, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-79 啄	# [cjk] */
{ 0x91EE,  1, 5, { 0x05, 0x0b, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-80 宅	# [cjk] */
{ 0x91EF,  1, 5, { 0x06, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-81 托	# [cjk] */
{ 0x91F0,  1, 5, { 0x06, 0x02, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-82 択	# [cjk] */
{ 0x91F1,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-83 拓	# [cjk] */
{ 0x91F2,  1, 5, { 0x06, 0x0c, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-84 沢	# [cjk] */
{ 0x91F3,  1, 5, { 0x06, 0x0f, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-85 濯	# [cjk] */
{ 0x91F4,  1, 5, { 0x07, 0x04, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-86 琢	# [cjk] */
{ 0x91F5,  1, 5, { 0x08, 0x0a, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-87 託	# [cjk] */
{ 0x91F6,  1, 5, { 0x09, 0x04, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-88 鐸	# [cjk] */
{ 0x91F7,  1, 5, { 0x06, 0x0f, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-89 濁	# [cjk] */
{ 0x91F8,  1, 5, { 0x08, 0x0a, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-90 諾	# [cjk] */
{ 0x91F9,  1, 5, { 0x08, 0x03, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-91 茸	# [cjk] */
{ 0x91FA,  1, 5, { 0x05, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-92 凧	# [cjk] */
{ 0x91FB,  1, 5, { 0x08, 0x06, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-93 蛸	# [cjk] */
{ 0x91FC,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-34-94 只	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9240,  1, 5, { 0x05, 0x03, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-01 叩	# [cjk] */
{ 0x9241,  1, 5, { 0x04, 0x0f, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-02 但	# [cjk] */
{ 0x9242,  1, 5, { 0x09, 0x00, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-03 達	# [cjk] */
{ 0x9243,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-04 辰	# [cjk] */
{ 0x9244,  1, 5, { 0x05, 0x09, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-05 奪	# [cjk] */
{ 0x9245,  1, 5, { 0x08, 0x01, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-06 脱	# [cjk] */
{ 0x9246,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-07 巽	# [cjk] */
{ 0x9247,  1, 5, { 0x07, 0x0a, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-08 竪	# [cjk] */
{ 0x9248,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-09 辿	# [cjk] */
{ 0x9249,  1, 5, { 0x06, 0x08, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-10 棚	# [cjk] */
{ 0x924A,  1, 5, { 0x08, 0x0c, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-11 谷	# [cjk] */
{ 0x924B,  1, 5, { 0x07, 0x02, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-12 狸	# [cjk] */
{ 0x924C,  1, 5, { 0x09, 0x0c, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-13 鱈	# [cjk] */
{ 0x924D,  1, 5, { 0x06, 0x0a, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-14 樽	# [cjk] */
{ 0x924E,  1, 5, { 0x08, 0x0a, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-15 誰	# [cjk] */
{ 0x924F,  1, 5, { 0x04, 0x0e, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-16 丹	# [cjk] */
{ 0x9250,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-17 単	# [cjk] */
{ 0x9251,  1, 5, { 0x05, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-18 嘆	# [cjk] */
{ 0x9252,  1, 5, { 0x05, 0x07, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-19 坦	# [cjk] */
{ 0x9253,  1, 5, { 0x06, 0x02, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-20 担	# [cjk] */
{ 0x9254,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-21 探	# [cjk] */
{ 0x9255,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-22 旦	# [cjk] */
{ 0x9256,  1, 5, { 0x06, 0x0b, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-23 歎	# [cjk] */
{ 0x9257,  1, 5, { 0x06, 0x0d, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-24 淡	# [cjk] */
{ 0x9258,  1, 5, { 0x06, 0x0e, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-25 湛	# [cjk] */
{ 0x9259,  1, 5, { 0x07, 0x00, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-26 炭	# [cjk] */
{ 0x925A,  1, 5, { 0x07, 0x07, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-27 短	# [cjk] */
{ 0x925B,  1, 5, { 0x07, 0x0a, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-28 端	# [cjk] */
{ 0x925C,  1, 5, { 0x07, 0x0b, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-29 箪	# [cjk] */
{ 0x925D,  1, 5, { 0x07, 0x0d, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-30 綻	# [cjk] */
{ 0x925E,  1, 5, { 0x08, 0x00, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-31 耽	# [cjk] */
{ 0x925F,  1, 5, { 0x08, 0x00, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-32 胆	# [cjk] */
{ 0x9260,  1, 5, { 0x08, 0x06, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-33 蛋	# [cjk] */
{ 0x9261,  1, 5, { 0x08, 0x0a, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-34 誕	# [cjk] */
{ 0x9262,  1, 5, { 0x09, 0x03, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-35 鍛	# [cjk] */
{ 0x9263,  1, 5, { 0x05, 0x06, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-36 団	# [cjk] */
{ 0x9264,  1, 5, { 0x05, 0x08, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-37 壇	# [cjk] */
{ 0x9265,  1, 5, { 0x05, 0x0f, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-38 弾	# [cjk] */
{ 0x9266,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-39 断	# [cjk] */
{ 0x9267,  1, 5, { 0x06, 0x06, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-40 暖	# [cjk] */
{ 0x9268,  1, 5, { 0x06, 0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-41 檀	# [cjk] */
{ 0x9269,  1, 5, { 0x06, 0x0b, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-42 段	# [cjk] */
{ 0x926A,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-43 男	# [cjk] */
{ 0x926B,  1, 5, { 0x08, 0x0a, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-44 談	# [cjk] */
{ 0x926C,  1, 5, { 0x05, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-45 値	# [cjk] */
{ 0x926D,  1, 5, { 0x07, 0x07, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-46 知	# [cjk] */
{ 0x926E,  1, 5, { 0x05, 0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-47 地	# [cjk] */
{ 0x926F,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-48 弛	# [cjk] */
{ 0x9270,  1, 5, { 0x06, 0x00, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-49 恥	# [cjk] */
{ 0x9271,  1, 5, { 0x06, 0x06, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-50 智	# [cjk] */
{ 0x9272,  1, 5, { 0x06, 0x0c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-51 池	# [cjk] */
{ 0x9273,  1, 5, { 0x07, 0x05, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-52 痴	# [cjk] */
{ 0x9274,  1, 5, { 0x07, 0x0a, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-53 稚	# [cjk] */
{ 0x9275,  1, 5, { 0x07, 0x0f, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-54 置	# [cjk] */
{ 0x9276,  1, 5, { 0x08, 0x01, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-55 致	# [cjk] */
{ 0x9277,  1, 5, { 0x08, 0x07, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-56 蜘	# [cjk] */
{ 0x9278,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-57 遅	# [cjk] */
{ 0x9279,  1, 5, { 0x09, 0x09, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-58 馳	# [cjk] */
{ 0x927A,  1, 5, { 0x07, 0x0b, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-59 築	# [cjk] */
{ 0x927B,  1, 5, { 0x07, 0x05, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-60 畜	# [cjk] */
{ 0x927C,  1, 5, { 0x07, 0x0a, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-61 竹	# [cjk] */
{ 0x927D,  1, 5, { 0x07, 0x0b, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-62 筑	# [cjk] */
{ 0x927E,  1, 5, { 0x08, 0x04, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-63 蓄	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9280,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-64 逐	# [cjk] */
{ 0x9281,  1, 5, { 0x07, 0x09, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-65 秩	# [cjk] */
{ 0x9282,  1, 5, { 0x07, 0x0a, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-66 窒	# [cjk] */
{ 0x9283,  1, 5, { 0x08, 0x03, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-67 茶	# [cjk] */
{ 0x9284,  1, 5, { 0x05, 0x0a, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-68 嫡	# [cjk] */
{ 0x9285,  1, 5, { 0x07, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-69 着	# [cjk] */
{ 0x9286,  1, 5, { 0x04, 0x0e, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-70 中	# [cjk] */
{ 0x9287,  1, 5, { 0x04, 0x0e, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-71 仲	# [cjk] */
{ 0x9288,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-72 宙	# [cjk] */
{ 0x9289,  1, 5, { 0x05, 0x0f, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-73 忠	# [cjk] */
{ 0x928A,  1, 5, { 0x06, 0x02, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-74 抽	# [cjk] */
{ 0x928B,  1, 5, { 0x06, 0x06, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-75 昼	# [cjk] */
{ 0x928C,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-76 柱	# [cjk] */
{ 0x928D,  1, 5, { 0x06, 0x0c, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-77 注	# [cjk] */
{ 0x928E,  1, 5, { 0x08, 0x06, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-78 虫	# [cjk] */
{ 0x928F,  1, 5, { 0x08, 0x08, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-79 衷	# [cjk] */
{ 0x9290,  1, 5, { 0x08, 0x0a, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-80 註	# [cjk] */
{ 0x9291,  1, 5, { 0x09, 0x01, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-81 酎	# [cjk] */
{ 0x9292,  1, 5, { 0x09, 0x02, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-82 鋳	# [cjk] */
{ 0x9293,  1, 5, { 0x09, 0x09, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-83 駐	# [cjk] */
{ 0x9294,  1, 5, { 0x06, 0x0a, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-84 樗	# [cjk] */
{ 0x9295,  1, 5, { 0x07, 0x00, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-85 瀦	# [cjk] */
{ 0x9296,  1, 5, { 0x07, 0x03, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-86 猪	# [cjk] */
{ 0x9297,  1, 5, { 0x08, 0x02, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-87 苧	# [cjk] */
{ 0x9298,  1, 5, { 0x08, 0x04, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-88 著	# [cjk] */
{ 0x9299,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-89 貯	# [cjk] */
{ 0x929A,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-90 丁	# [cjk] */
{ 0x929B,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-91 兆	# [cjk] */
{ 0x929C,  1, 5, { 0x05, 0x01, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-92 凋	# [cjk] */
{ 0x929D,  1, 5, { 0x05, 0x05, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-93 喋	# [cjk] */
{ 0x929E,  1, 5, { 0x05, 0x0b, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-35-94 寵	# [cjk] */
{ 0x929F,  1, 5, { 0x05, 0x0e, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-01 帖	# [cjk] */
{ 0x92A0,  1, 5, { 0x05, 0x0e, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-02 帳	# [cjk] */
{ 0x92A1,  1, 5, { 0x05, 0x0e, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-03 庁	# [cjk] */
{ 0x92A2,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-04 弔	# [cjk] */
{ 0x92A3,  1, 5, { 0x05, 0x0f, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-05 張	# [cjk] */
{ 0x92A4,  1, 5, { 0x05, 0x0f, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-06 彫	# [cjk] */
{ 0x92A5,  1, 5, { 0x05, 0x0f, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-07 徴	# [cjk] */
{ 0x92A6,  1, 5, { 0x06, 0x01, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-08 懲	# [cjk] */
{ 0x92A7,  1, 5, { 0x06, 0x03, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-09 挑	# [cjk] */
{ 0x92A8,  1, 5, { 0x06, 0x06, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-10 暢	# [cjk] */
{ 0x92A9,  1, 5, { 0x06, 0x07, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-11 朝	# [cjk] */
{ 0x92AA,  1, 5, { 0x06, 0x0f, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-12 潮	# [cjk] */
{ 0x92AB,  1, 5, { 0x07, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-13 牒	# [cjk] */
{ 0x92AC,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-14 町	# [cjk] */
{ 0x92AD,  1, 5, { 0x07, 0x07, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-15 眺	# [cjk] */
{ 0x92AE,  1, 5, { 0x08, 0x00, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-16 聴	# [cjk] */
{ 0x92AF,  1, 5, { 0x08, 0x01, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-17 脹	# [cjk] */
{ 0x92B0,  1, 5, { 0x08, 0x01, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-18 腸	# [cjk] */
{ 0x92B1,  1, 5, { 0x08, 0x07, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-19 蝶	# [cjk] */
{ 0x92B2,  1, 5, { 0x08, 0x0a, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-20 調	# [cjk] */
{ 0x92B3,  1, 5, { 0x08, 0x0a, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-21 諜	# [cjk] */
{ 0x92B4,  1, 5, { 0x08, 0x0d, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-22 超	# [cjk] */
{ 0x92B5,  1, 5, { 0x08, 0x0d, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-23 跳	# [cjk] */
{ 0x92B6,  1, 5, { 0x09, 0x02, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-24 銚	# [cjk] */
{ 0x92B7,  1, 5, { 0x09, 0x05, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-25 長	# [cjk] */
{ 0x92B8,  1, 5, { 0x09, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-26 頂	# [cjk] */
{ 0x92B9,  1, 5, { 0x09, 0x0c, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-27 鳥	# [cjk] */
{ 0x92BA,  1, 5, { 0x05, 0x02, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-28 勅	# [cjk] */
{ 0x92BB,  1, 5, { 0x06, 0x03, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-29 捗	# [cjk] */
{ 0x92BC,  1, 5, { 0x07, 0x06, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-30 直	# [cjk] */
{ 0x92BD,  1, 5, { 0x06, 0x07, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-31 朕	# [cjk] */
{ 0x92BE,  1, 5, { 0x06, 0x0c, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-32 沈	# [cjk] */
{ 0x92BF,  1, 5, { 0x07, 0x03, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-33 珍	# [cjk] */
{ 0x92C0,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-34 賃	# [cjk] */
{ 0x92C1,  1, 5, { 0x09, 0x03, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-35 鎮	# [cjk] */
{ 0x92C2,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-36 陳	# [cjk] */
{ 0x92C3,  1, 5, { 0x06, 0x0d, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-37 津	# [cjk] */
{ 0x92C4,  1, 5, { 0x05, 0x08, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-38 墜	# [cjk] */
{ 0x92C5,  1, 5, { 0x06, 0x09, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-39 椎	# [cjk] */
{ 0x92C6,  1, 5, { 0x06, 0x09, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-40 槌	# [cjk] */
{ 0x92C7,  1, 5, { 0x08, 0x0f, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-41 追	# [cjk] */
{ 0x92C8,  1, 5, { 0x09, 0x03, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-42 鎚	# [cjk] */
{ 0x92C9,  1, 5, { 0x07, 0x05, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-43 痛	# [cjk] */
{ 0x92CA,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-44 通	# [cjk] */
{ 0x92CB,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-45 塚	# [cjk] */
{ 0x92CC,  1, 5, { 0x06, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-46 栂	# [cjk] */
{ 0x92CD,  1, 5, { 0x06, 0x03, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-47 掴	# [cjk] */
{ 0x92CE,  1, 5, { 0x06, 0x09, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-48 槻	# [cjk] */
{ 0x92CF,  1, 5, { 0x04, 0x0f, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-49 佃	# [cjk] */
{ 0x92D0,  1, 5, { 0x06, 0x0f, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-50 漬	# [cjk] */
{ 0x92D1,  1, 5, { 0x06, 0x07, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-51 柘	# [cjk] */
{ 0x92D2,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-52 辻	# [cjk] */
{ 0x92D3,  1, 5, { 0x08, 0x05, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-53 蔦	# [cjk] */
{ 0x92D4,  1, 5, { 0x07, 0x0d, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-54 綴	# [cjk] */
{ 0x92D5,  1, 5, { 0x09, 0x03, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-55 鍔	# [cjk] */
{ 0x92D6,  1, 5, { 0x06, 0x09, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-56 椿	# [cjk] */
{ 0x92D7,  1, 5, { 0x06, 0x0f, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-57 潰	# [cjk] */
{ 0x92D8,  1, 5, { 0x05, 0x07, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-58 坪	# [cjk] */
{ 0x92D9,  1, 5, { 0x05, 0x08, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-59 壷	# [cjk] */
{ 0x92DA,  1, 5, { 0x05, 0x0b, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-60 嬬	# [cjk] */
{ 0x92DB,  1, 5, { 0x07, 0x0d, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-61 紬	# [cjk] */
{ 0x92DC,  1, 5, { 0x07, 0x02, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-62 爪	# [cjk] */
{ 0x92DD,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-63 吊	# [cjk] */
{ 0x92DE,  1, 5, { 0x09, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-64 釣	# [cjk] */
{ 0x92DF,  1, 5, { 0x09, 0x0d, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-65 鶴	# [cjk] */
{ 0x92E0,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-66 亭	# [cjk] */
{ 0x92E1,  1, 5, { 0x04, 0x0f, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-67 低	# [cjk] */
{ 0x92E2,  1, 5, { 0x05, 0x00, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-68 停	# [cjk] */
{ 0x92E3,  1, 5, { 0x05, 0x00, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-69 偵	# [cjk] */
{ 0x92E4,  1, 5, { 0x05, 0x02, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-70 剃	# [cjk] */
{ 0x92E5,  1, 5, { 0x08, 0x0c, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-71 貞	# [cjk] */
{ 0x92E6,  1, 5, { 0x05, 0x04, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-72 呈	# [cjk] */
{ 0x92E7,  1, 5, { 0x05, 0x08, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-73 堤	# [cjk] */
{ 0x92E8,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-74 定	# [cjk] */
{ 0x92E9,  1, 5, { 0x05, 0x0e, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-75 帝	# [cjk] */
{ 0x92EA,  1, 5, { 0x05, 0x0e, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-76 底	# [cjk] */
{ 0x92EB,  1, 5, { 0x05, 0x0e, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-77 庭	# [cjk] */
{ 0x92EC,  1, 5, { 0x05, 0x0e, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-78 廷	# [cjk] */
{ 0x92ED,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-79 弟	# [cjk] */
{ 0x92EE,  1, 5, { 0x06, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-80 悌	# [cjk] */
{ 0x92EF,  1, 5, { 0x06, 0x02, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-81 抵	# [cjk] */
{ 0x92F0,  1, 5, { 0x06, 0x03, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-82 挺	# [cjk] */
{ 0x92F1,  1, 5, { 0x06, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-83 提	# [cjk] */
{ 0x92F2,  1, 5, { 0x06, 0x08, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-84 梯	# [cjk] */
{ 0x92F3,  1, 5, { 0x06, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-85 汀	# [cjk] */
{ 0x92F4,  1, 5, { 0x07, 0x08, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-86 碇	# [cjk] */
{ 0x92F5,  1, 5, { 0x07, 0x09, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-87 禎	# [cjk] */
{ 0x92F6,  1, 5, { 0x07, 0x0a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-88 程	# [cjk] */
{ 0x92F7,  1, 5, { 0x07, 0x0d, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-89 締	# [cjk] */
{ 0x92F8,  1, 5, { 0x08, 0x02, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-90 艇	# [cjk] */
{ 0x92F9,  1, 5, { 0x08, 0x0a, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-91 訂	# [cjk] */
{ 0x92FA,  1, 5, { 0x08, 0x0a, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-92 諦	# [cjk] */
{ 0x92FB,  1, 5, { 0x08, 0x0e, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-93 蹄	# [cjk] */
{ 0x92FC,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-36-94 逓	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9340,  1, 5, { 0x09, 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-01 邸	# [cjk] */
{ 0x9341,  1, 5, { 0x09, 0x01, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-02 鄭	# [cjk] */
{ 0x9342,  1, 5, { 0x09, 0x01, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-03 釘	# [cjk] */
{ 0x9343,  1, 5, { 0x09, 0x0f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-04 鼎	# [cjk] */
{ 0x9344,  1, 5, { 0x06, 0x0c, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-05 泥	# [cjk] */
{ 0x9345,  1, 5, { 0x06, 0x04, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-06 摘	# [cjk] */
{ 0x9346,  1, 5, { 0x06, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-07 擢	# [cjk] */
{ 0x9347,  1, 5, { 0x06, 0x05, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-08 敵	# [cjk] */
{ 0x9348,  1, 5, { 0x06, 0x0e, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-09 滴	# [cjk] */
{ 0x9349,  1, 5, { 0x07, 0x06, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-10 的	# [cjk] */
{ 0x934A,  1, 5, { 0x07, 0x0b, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-11 笛	# [cjk] */
{ 0x934B,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-12 適	# [cjk] */
{ 0x934C,  1, 5, { 0x09, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-13 鏑	# [cjk] */
{ 0x934D,  1, 5, { 0x06, 0x0e, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-14 溺	# [cjk] */
{ 0x934E,  1, 5, { 0x05, 0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-15 哲	# [cjk] */
{ 0x934F,  1, 5, { 0x05, 0x0f, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-16 徹	# [cjk] */
{ 0x9350,  1, 5, { 0x06, 0x04, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-17 撤	# [cjk] */
{ 0x9351,  1, 5, { 0x08, 0x0f, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-18 轍	# [cjk] */
{ 0x9352,  1, 5, { 0x08, 0x0f, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-19 迭	# [cjk] */
{ 0x9353,  1, 5, { 0x09, 0x02, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-20 鉄	# [cjk] */
{ 0x9354,  1, 5, { 0x05, 0x01, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-21 典	# [cjk] */
{ 0x9355,  1, 5, { 0x05, 0x08, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-22 填	# [cjk] */
{ 0x9356,  1, 5, { 0x05, 0x09, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-23 天	# [cjk] */
{ 0x9357,  1, 5, { 0x05, 0x0c, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-24 展	# [cjk] */
{ 0x9358,  1, 5, { 0x05, 0x0e, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-25 店	# [cjk] */
{ 0x9359,  1, 5, { 0x06, 0x0d, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-26 添	# [cjk] */
{ 0x935A,  1, 5, { 0x07, 0x0e, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-27 纏	# [cjk] */
{ 0x935B,  1, 5, { 0x07, 0x05, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-28 甜	# [cjk] */
{ 0x935C,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-29 貼	# [cjk] */
{ 0x935D,  1, 5, { 0x08, 0x0e, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-30 転	# [cjk] */
{ 0x935E,  1, 5, { 0x09, 0x08, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-31 顛	# [cjk] */
{ 0x935F,  1, 5, { 0x07, 0x00, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-32 点	# [cjk] */
{ 0x9360,  1, 5, { 0x04, 0x0f, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-33 伝	# [cjk] */
{ 0x9361,  1, 5, { 0x06, 0x0b, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-34 殿	# [cjk] */
{ 0x9362,  1, 5, { 0x06, 0x0f, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-35 澱	# [cjk] */
{ 0x9363,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-36 田	# [cjk] */
{ 0x9364,  1, 5, { 0x09, 0x06, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-37 電	# [cjk] */
{ 0x9365,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-38 兎	# [cjk] */
{ 0x9366,  1, 5, { 0x05, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-39 吐	# [cjk] */
{ 0x9367,  1, 5, { 0x05, 0x08, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-40 堵	# [cjk] */
{ 0x9368,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-41 塗	# [cjk] */
{ 0x9369,  1, 5, { 0x05, 0x09, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-42 妬	# [cjk] */
{ 0x936A,  1, 5, { 0x05, 0x0c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-43 屠	# [cjk] */
{ 0x936B,  1, 5, { 0x05, 0x0f, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-44 徒	# [cjk] */
{ 0x936C,  1, 5, { 0x06, 0x05, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-45 斗	# [cjk] */
{ 0x936D,  1, 5, { 0x06, 0x07, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-46 杜	# [cjk] */
{ 0x936E,  1, 5, { 0x06, 0x0e, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-47 渡	# [cjk] */
{ 0x936F,  1, 5, { 0x07, 0x06, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-48 登	# [cjk] */
{ 0x9370,  1, 5, { 0x08, 0x03, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-49 菟	# [cjk] */
{ 0x9371,  1, 5, { 0x08, 0x0c, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-50 賭	# [cjk] */
{ 0x9372,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-51 途	# [cjk] */
{ 0x9373,  1, 5, { 0x09, 0x00, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-52 都	# [cjk] */
{ 0x9374,  1, 5, { 0x09, 0x03, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-53 鍍	# [cjk] */
{ 0x9375,  1, 5, { 0x07, 0x08, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-54 砥	# [cjk] */
{ 0x9376,  1, 5, { 0x07, 0x08, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-55 砺	# [cjk] */
{ 0x9377,  1, 5, { 0x05, 0x02, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-56 努	# [cjk] */
{ 0x9378,  1, 5, { 0x05, 0x0e, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-57 度	# [cjk] */
{ 0x9379,  1, 5, { 0x05, 0x07, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-58 土	# [cjk] */
{ 0x937A,  1, 5, { 0x05, 0x09, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-59 奴	# [cjk] */
{ 0x937B,  1, 5, { 0x06, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-60 怒	# [cjk] */
{ 0x937C,  1, 5, { 0x05, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-61 倒	# [cjk] */
{ 0x937D,  1, 5, { 0x05, 0x01, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-62 党	# [cjk] */
{ 0x937E,  1, 5, { 0x05, 0x01, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-63 冬	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9380,  1, 5, { 0x05, 0x01, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-64 凍	# [cjk] */
{ 0x9381,  1, 5, { 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-65 刀	# [cjk] */
{ 0x9382,  1, 5, { 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-66 唐	# [cjk] */
{ 0x9383,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-67 塔	# [cjk] */
{ 0x9384,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-68 塘	# [cjk] */
{ 0x9385,  1, 5, { 0x05, 0x09, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-69 套	# [cjk] */
{ 0x9386,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-70 宕	# [cjk] */
{ 0x9387,  1, 5, { 0x05, 0x0c, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-71 島	# [cjk] */
{ 0x9388,  1, 5, { 0x05, 0x0d, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-72 嶋	# [cjk] */
{ 0x9389,  1, 5, { 0x06, 0x00, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-73 悼	# [cjk] */
{ 0x938A,  1, 5, { 0x06, 0x02, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-74 投	# [cjk] */
{ 0x938B,  1, 5, { 0x06, 0x04, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-75 搭	# [cjk] */
{ 0x938C,  1, 5, { 0x06, 0x07, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-76 東	# [cjk] */
{ 0x938D,  1, 5, { 0x06, 0x08, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-77 桃	# [cjk] */
{ 0x938E,  1, 5, { 0x06, 0x08, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-78 梼	# [cjk] */
{ 0x938F,  1, 5, { 0x06, 0x08, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-79 棟	# [cjk] */
{ 0x9390,  1, 5, { 0x07, 0x06, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-80 盗	# [cjk] */
{ 0x9391,  1, 5, { 0x06, 0x0d, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-81 淘	# [cjk] */
{ 0x9392,  1, 5, { 0x06, 0x0e, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-82 湯	# [cjk] */
{ 0x9393,  1, 5, { 0x06, 0x0d, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-83 涛	# [cjk] */
{ 0x9394,  1, 5, { 0x07, 0x00, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-84 灯	# [cjk] */
{ 0x9395,  1, 5, { 0x07, 0x01, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-85 燈	# [cjk] */
{ 0x9396,  1, 5, { 0x05, 0x0f, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-86 当	# [cjk] */
{ 0x9397,  1, 5, { 0x07, 0x05, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-87 痘	# [cjk] */
{ 0x9398,  1, 5, { 0x07, 0x09, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-88 祷	# [cjk] */
{ 0x9399,  1, 5, { 0x07, 0x0b, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-89 等	# [cjk] */
{ 0x939A,  1, 5, { 0x07, 0x0b, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-90 答	# [cjk] */
{ 0x939B,  1, 5, { 0x07, 0x0b, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-91 筒	# [cjk] */
{ 0x939C,  1, 5, { 0x07, 0x0c, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-92 糖	# [cjk] */
{ 0x939D,  1, 5, { 0x07, 0x0d, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-93 統	# [cjk] */
{ 0x939E,  1, 5, { 0x05, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-37-94 到	# [cjk] */
{ 0x939F,  1, 5, { 0x08, 0x04, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-01 董	# [cjk] */
{ 0x93A0,  1, 5, { 0x08, 0x05, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-02 蕩	# [cjk] */
{ 0x93A1,  1, 5, { 0x08, 0x05, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-03 藤	# [cjk] */
{ 0x93A2,  1, 5, { 0x08, 0x0a, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-04 討	# [cjk] */
{ 0x93A3,  1, 5, { 0x08, 0x0b, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-05 謄	# [cjk] */
{ 0x93A4,  1, 5, { 0x08, 0x0c, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-06 豆	# [cjk] */
{ 0x93A5,  1, 5, { 0x08, 0x0e, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-07 踏	# [cjk] */
{ 0x93A6,  1, 5, { 0x09, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-08 逃	# [cjk] */
{ 0x93A7,  1, 5, { 0x09, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-09 透	# [cjk] */
{ 0x93A8,  1, 5, { 0x09, 0x04, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-10 鐙	# [cjk] */
{ 0x93A9,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-11 陶	# [cjk] */
{ 0x93AA,  1, 5, { 0x09, 0x08, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-12 頭	# [cjk] */
{ 0x93AB,  1, 5, { 0x09, 0x0a, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-13 騰	# [cjk] */
{ 0x93AC,  1, 5, { 0x09, 0x05, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-14 闘	# [cjk] */
{ 0x93AD,  1, 5, { 0x05, 0x00, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-15 働	# [cjk] */
{ 0x93AE,  1, 5, { 0x05, 0x02, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-16 動	# [cjk] */
{ 0x93AF,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-17 同	# [cjk] */
{ 0x93B0,  1, 5, { 0x05, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-18 堂	# [cjk] */
{ 0x93B1,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-19 導	# [cjk] */
{ 0x93B2,  1, 5, { 0x06, 0x01, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-20 憧	# [cjk] */
{ 0x93B3,  1, 5, { 0x06, 0x04, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-21 撞	# [cjk] */
{ 0x93B4,  1, 5, { 0x06, 0x0d, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-22 洞	# [cjk] */
{ 0x93B5,  1, 5, { 0x07, 0x07, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-23 瞳	# [cjk] */
{ 0x93B6,  1, 5, { 0x07, 0x0a, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-24 童	# [cjk] */
{ 0x93B7,  1, 5, { 0x08, 0x00, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-25 胴	# [cjk] */
{ 0x93B8,  1, 5, { 0x08, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-26 萄	# [cjk] */
{ 0x93B9,  1, 5, { 0x09, 0x00, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-27 道	# [cjk] */
{ 0x93BA,  1, 5, { 0x09, 0x02, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-28 銅	# [cjk] */
{ 0x93BB,  1, 5, { 0x05, 0x0c, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-29 峠	# [cjk] */
{ 0x93BC,  1, 5, { 0x09, 0x0d, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-30 鴇	# [cjk] */
{ 0x93BD,  1, 5, { 0x05, 0x03, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-31 匿	# [cjk] */
{ 0x93BE,  1, 5, { 0x05, 0x0f, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-32 得	# [cjk] */
{ 0x93BF,  1, 5, { 0x05, 0x0f, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-33 徳	# [cjk] */
{ 0x93C0,  1, 5, { 0x06, 0x0d, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-34 涜	# [cjk] */
{ 0x93C1,  1, 5, { 0x07, 0x02, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-35 特	# [cjk] */
{ 0x93C2,  1, 5, { 0x07, 0x07, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-36 督	# [cjk] */
{ 0x93C3,  1, 5, { 0x07, 0x09, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-37 禿	# [cjk] */
{ 0x93C4,  1, 5, { 0x07, 0x0b, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-38 篤	# [cjk] */
{ 0x93C5,  1, 5, { 0x06, 0x0b, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-39 毒	# [cjk] */
{ 0x93C6,  1, 5, { 0x07, 0x02, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-40 独	# [cjk] */
{ 0x93C7,  1, 5, { 0x08, 0x0a, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-41 読	# [cjk] */
{ 0x93C8,  1, 5, { 0x06, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-42 栃	# [cjk] */
{ 0x93C9,  1, 5, { 0x06, 0x0a, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-43 橡	# [cjk] */
{ 0x93CA,  1, 5, { 0x05, 0x01, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-44 凸	# [cjk] */
{ 0x93CB,  1, 5, { 0x07, 0x0a, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-45 突	# [cjk] */
{ 0x93CC,  1, 5, { 0x06, 0x09, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-46 椴	# [cjk] */
{ 0x93CD,  1, 5, { 0x05, 0x0c, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-47 届	# [cjk] */
{ 0x93CE,  1, 5, { 0x09, 0x0c, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-48 鳶	# [cjk] */
{ 0x93CF,  1, 5, { 0x08, 0x02, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-49 苫	# [cjk] */
{ 0x93D0,  1, 5, { 0x05, 0x0b, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-50 寅	# [cjk] */
{ 0x93D1,  1, 5, { 0x09, 0x01, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-51 酉	# [cjk] */
{ 0x93D2,  1, 5, { 0x07, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-52 瀞	# [cjk] */
{ 0x93D3,  1, 5, { 0x05, 0x06, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-53 噸	# [cjk] */
{ 0x93D4,  1, 5, { 0x05, 0x0c, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-54 屯	# [cjk] */
{ 0x93D5,  1, 5, { 0x06, 0x00, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-55 惇	# [cjk] */
{ 0x93D6,  1, 5, { 0x06, 0x05, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-56 敦	# [cjk] */
{ 0x93D7,  1, 5, { 0x06, 0x0c, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-57 沌	# [cjk] */
{ 0x93D8,  1, 5, { 0x08, 0x0c, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-58 豚	# [cjk] */
{ 0x93D9,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-59 遁	# [cjk] */
{ 0x93DA,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-60 頓	# [cjk] */
{ 0x93DB,  1, 5, { 0x05, 0x04, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-61 呑	# [cjk] */
{ 0x93DC,  1, 5, { 0x06, 0x06, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-62 曇	# [cjk] */
{ 0x93DD,  1, 5, { 0x09, 0x02, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-63 鈍	# [cjk] */
{ 0x93DE,  1, 5, { 0x05, 0x09, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-64 奈	# [cjk] */
{ 0x93DF,  1, 5, { 0x09, 0x00, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-65 那	# [cjk] */
{ 0x93E0,  1, 5, { 0x05, 0x01, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-66 内	# [cjk] */
{ 0x93E1,  1, 5, { 0x04, 0x0e, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-67 乍	# [cjk] */
{ 0x93E2,  1, 5, { 0x05, 0x01, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-68 凪	# [cjk] */
{ 0x93E3,  1, 5, { 0x08, 0x05, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-69 薙	# [cjk] */
{ 0x93E4,  1, 5, { 0x08, 0x0b, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-70 謎	# [cjk] */
{ 0x93E5,  1, 5, { 0x07, 0x00, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-71 灘	# [cjk] */
{ 0x93E6,  1, 5, { 0x06, 0x03, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-72 捺	# [cjk] */
{ 0x93E7,  1, 5, { 0x09, 0x03, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-73 鍋	# [cjk] */
{ 0x93E8,  1, 5, { 0x06, 0x09, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-74 楢	# [cjk] */
{ 0x93E9,  1, 5, { 0x09, 0x09, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-75 馴	# [cjk] */
{ 0x93EA,  1, 5, { 0x07, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-76 縄	# [cjk] */
{ 0x93EB,  1, 5, { 0x07, 0x05, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-77 畷	# [cjk] */
{ 0x93EC,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-78 南	# [cjk] */
{ 0x93ED,  1, 5, { 0x06, 0x09, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-79 楠	# [cjk] */
{ 0x93EE,  1, 5, { 0x08, 0x0e, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-80 軟	# [cjk] */
{ 0x93EF,  1, 5, { 0x09, 0x06, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-81 難	# [cjk] */
{ 0x93F0,  1, 5, { 0x06, 0x0c, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-82 汝	# [cjk] */
{ 0x93F1,  1, 5, { 0x04, 0x0e, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-83 二	# [cjk] */
{ 0x93F2,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-84 尼	# [cjk] */
{ 0x93F3,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-85 弐	# [cjk] */
{ 0x93F4,  1, 5, { 0x08, 0x0f, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-86 迩	# [cjk] */
{ 0x93F5,  1, 5, { 0x05, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-87 匂	# [cjk] */
{ 0x93F6,  1, 5, { 0x08, 0x0c, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-88 賑	# [cjk] */
{ 0x93F7,  1, 5, { 0x08, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-89 肉	# [cjk] */
{ 0x93F8,  1, 5, { 0x08, 0x06, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-90 虹	# [cjk] */
{ 0x93F9,  1, 5, { 0x05, 0x0e, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-91 廿	# [cjk] */
{ 0x93FA,  1, 5, { 0x06, 0x05, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-92 日	# [cjk] */
{ 0x93FB,  1, 5, { 0x04, 0x0e, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-93 乳	# [cjk] */
{ 0x93FC,  1, 5, { 0x05, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-38-94 入	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9440,  1, 5, { 0x05, 0x09, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-01 如	# [cjk] */
{ 0x9441,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-02 尿	# [cjk] */
{ 0x9442,  1, 5, { 0x09, 0x07, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-03 韮	# [cjk] */
{ 0x9443,  1, 5, { 0x04, 0x0e, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-04 任	# [cjk] */
{ 0x9444,  1, 5, { 0x05, 0x09, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-05 妊	# [cjk] */
{ 0x9445,  1, 5, { 0x05, 0x0f, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-06 忍	# [cjk] */
{ 0x9446,  1, 5, { 0x08, 0x0a, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-07 認	# [cjk] */
{ 0x9447,  1, 5, { 0x06, 0x0f, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-08 濡	# [cjk] */
{ 0x9448,  1, 5, { 0x07, 0x09, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-09 禰	# [cjk] */
{ 0x9449,  1, 5, { 0x07, 0x09, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-10 祢	# [cjk] */
{ 0x944A,  1, 5, { 0x05, 0x0b, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-11 寧	# [cjk] */
{ 0x944B,  1, 5, { 0x08, 0x04, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-12 葱	# [cjk] */
{ 0x944C,  1, 5, { 0x07, 0x03, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-13 猫	# [cjk] */
{ 0x944D,  1, 5, { 0x07, 0x01, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-14 熱	# [cjk] */
{ 0x944E,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-15 年	# [cjk] */
{ 0x944F,  1, 5, { 0x05, 0x0f, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-16 念	# [cjk] */
{ 0x9450,  1, 5, { 0x06, 0x03, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-17 捻	# [cjk] */
{ 0x9451,  1, 5, { 0x06, 0x04, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-18 撚	# [cjk] */
{ 0x9452,  1, 5, { 0x07, 0x01, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-19 燃	# [cjk] */
{ 0x9453,  1, 5, { 0x07, 0x0c, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-20 粘	# [cjk] */
{ 0x9454,  1, 5, { 0x04, 0x0e, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-21 乃	# [cjk] */
{ 0x9455,  1, 5, { 0x05, 0x0e, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-22 廼	# [cjk] */
{ 0x9456,  1, 5, { 0x04, 0x0e, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-23 之	# [cjk] */
{ 0x9457,  1, 5, { 0x05, 0x07, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-24 埜	# [cjk] */
{ 0x9458,  1, 5, { 0x05, 0x06, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-25 嚢	# [cjk] */
{ 0x9459,  1, 5, { 0x06, 0x00, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-26 悩	# [cjk] */
{ 0x945A,  1, 5, { 0x06, 0x0f, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-27 濃	# [cjk] */
{ 0x945B,  1, 5, { 0x07, 0x0d, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-28 納	# [cjk] */
{ 0x945C,  1, 5, { 0x08, 0x00, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-29 能	# [cjk] */
{ 0x945D,  1, 5, { 0x08, 0x01, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-30 脳	# [cjk] */
{ 0x945E,  1, 5, { 0x08, 0x01, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-31 膿	# [cjk] */
{ 0x945F,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-32 農	# [cjk] */
{ 0x9460,  1, 5, { 0x08, 0x09, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-33 覗	# [cjk] */
{ 0x9461,  1, 5, { 0x08, 0x06, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-34 蚤	# [cjk] */
{ 0x9462,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-35 巴	# [cjk] */
{ 0x9463,  1, 5, { 0x06, 0x02, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-36 把	# [cjk] */
{ 0x9464,  1, 5, { 0x06, 0x04, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-37 播	# [cjk] */
{ 0x9465,  1, 5, { 0x08, 0x09, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-38 覇	# [cjk] */
{ 0x9466,  1, 5, { 0x06, 0x07, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-39 杷	# [cjk] */
{ 0x9467,  1, 5, { 0x06, 0x0c, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-40 波	# [cjk] */
{ 0x9468,  1, 5, { 0x06, 0x0d, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-41 派	# [cjk] */
{ 0x9469,  1, 5, { 0x07, 0x04, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-42 琶	# [cjk] */
{ 0x946A,  1, 5, { 0x07, 0x08, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-43 破	# [cjk] */
{ 0x946B,  1, 5, { 0x05, 0x0a, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-44 婆	# [cjk] */
{ 0x946C,  1, 5, { 0x07, 0x0f, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-45 罵	# [cjk] */
{ 0x946D,  1, 5, { 0x08, 0x02, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-46 芭	# [cjk] */
{ 0x946E,  1, 5, { 0x09, 0x09, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-47 馬	# [cjk] */
{ 0x946F,  1, 5, { 0x04, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-48 俳	# [cjk] */
{ 0x9470,  1, 5, { 0x05, 0x0e, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-49 廃	# [cjk] */
{ 0x9471,  1, 5, { 0x06, 0x02, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-50 拝	# [cjk] */
{ 0x9472,  1, 5, { 0x06, 0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-51 排	# [cjk] */
{ 0x9473,  1, 5, { 0x06, 0x05, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-52 敗	# [cjk] */
{ 0x9474,  1, 5, { 0x06, 0x07, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-53 杯	# [cjk] */
{ 0x9475,  1, 5, { 0x07, 0x06, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-54 盃	# [cjk] */
{ 0x9476,  1, 5, { 0x07, 0x02, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-55 牌	# [cjk] */
{ 0x9477,  1, 5, { 0x08, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-56 背	# [cjk] */
{ 0x9478,  1, 5, { 0x08, 0x00, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-57 肺	# [cjk] */
{ 0x9479,  1, 5, { 0x08, 0x0f, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-58 輩	# [cjk] */
{ 0x947A,  1, 5, { 0x09, 0x01, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-59 配	# [cjk] */
{ 0x947B,  1, 5, { 0x05, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-60 倍	# [cjk] */
{ 0x947C,  1, 5, { 0x05, 0x07, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-61 培	# [cjk] */
{ 0x947D,  1, 5, { 0x05, 0x0a, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-62 媒	# [cjk] */
{ 0x947E,  1, 5, { 0x06, 0x08, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-63 梅	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9480,  1, 5, { 0x06, 0x09, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-64 楳	# [cjk] */
{ 0x9481,  1, 5, { 0x07, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-65 煤	# [cjk] */
{ 0x9482,  1, 5, { 0x07, 0x02, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-66 狽	# [cjk] */
{ 0x9483,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-67 買	# [cjk] */
{ 0x9484,  1, 5, { 0x05, 0x08, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-68 売	# [cjk] */
{ 0x9485,  1, 5, { 0x08, 0x0c, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-69 賠	# [cjk] */
{ 0x9486,  1, 5, { 0x09, 0x06, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-70 陪	# [cjk] */
{ 0x9487,  1, 5, { 0x09, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-71 這	# [cjk] */
{ 0x9488,  1, 5, { 0x08, 0x07, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-72 蝿	# [cjk] */
{ 0x9489,  1, 5, { 0x07, 0x09, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-73 秤	# [cjk] */
{ 0x948A,  1, 5, { 0x07, 0x07, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-74 矧	# [cjk] */
{ 0x948B,  1, 5, { 0x08, 0x04, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-75 萩	# [cjk] */
{ 0x948C,  1, 5, { 0x04, 0x0f, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-76 伯	# [cjk] */
{ 0x948D,  1, 5, { 0x05, 0x02, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-77 剥	# [cjk] */
{ 0x948E,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-78 博	# [cjk] */
{ 0x948F,  1, 5, { 0x06, 0x02, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-79 拍	# [cjk] */
{ 0x9490,  1, 5, { 0x06, 0x07, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-80 柏	# [cjk] */
{ 0x9491,  1, 5, { 0x06, 0x0c, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-81 泊	# [cjk] */
{ 0x9492,  1, 5, { 0x07, 0x06, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-82 白	# [cjk] */
{ 0x9493,  1, 5, { 0x07, 0x0b, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-83 箔	# [cjk] */
{ 0x9494,  1, 5, { 0x07, 0x0c, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-84 粕	# [cjk] */
{ 0x9495,  1, 5, { 0x08, 0x02, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-85 舶	# [cjk] */
{ 0x9496,  1, 5, { 0x08, 0x05, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-86 薄	# [cjk] */
{ 0x9497,  1, 5, { 0x08, 0x0f, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-87 迫	# [cjk] */
{ 0x9498,  1, 5, { 0x06, 0x06, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-88 曝	# [cjk] */
{ 0x9499,  1, 5, { 0x06, 0x0f, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-89 漠	# [cjk] */
{ 0x949A,  1, 5, { 0x07, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-90 爆	# [cjk] */
{ 0x949B,  1, 5, { 0x07, 0x0e, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-91 縛	# [cjk] */
{ 0x949C,  1, 5, { 0x08, 0x03, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-92 莫	# [cjk] */
{ 0x949D,  1, 5, { 0x09, 0x09, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-93 駁	# [cjk] */
{ 0x949E,  1, 5, { 0x09, 0x0e, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-39-94 麦	# [cjk] */
{ 0x949F,  1, 5, { 0x05, 0x01, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-01 函	# [cjk] */
{ 0x94A0,  1, 5, { 0x07, 0x0b, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-02 箱	# [cjk] */
{ 0x94A1,  1, 5, { 0x07, 0x08, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-03 硲	# [cjk] */
{ 0x94A2,  1, 5, { 0x07, 0x0b, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-04 箸	# [cjk] */
{ 0x94A3,  1, 5, { 0x08, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-05 肇	# [cjk] */
{ 0x94A4,  1, 5, { 0x07, 0x0b, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-06 筈	# [cjk] */
{ 0x94A5,  1, 5, { 0x06, 0x0a, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-07 櫨	# [cjk] */
{ 0x94A6,  1, 5, { 0x05, 0x0e, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-08 幡	# [cjk] */
{ 0x94A7,  1, 5, { 0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-09 肌	# [cjk] */
{ 0x94A8,  1, 5, { 0x07, 0x05, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-10 畑	# [cjk] */
{ 0x94A9,  1, 5, { 0x07, 0x05, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-11 畠	# [cjk] */
{ 0x94AA,  1, 5, { 0x05, 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-12 八	# [cjk] */
{ 0x94AB,  1, 5, { 0x09, 0x02, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-13 鉢	# [cjk] */
{ 0x94AC,  1, 5, { 0x06, 0x0e, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-14 溌	# [cjk] */
{ 0x94AD,  1, 5, { 0x07, 0x06, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-15 発	# [cjk] */
{ 0x94AE,  1, 5, { 0x09, 0x01, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-16 醗	# [cjk] */
{ 0x94AF,  1, 5, { 0x09, 0x0a, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-17 髪	# [cjk] */
{ 0x94B0,  1, 5, { 0x04, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-18 伐	# [cjk] */
{ 0x94B1,  1, 5, { 0x07, 0x0f, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-19 罰	# [cjk] */
{ 0x94B2,  1, 5, { 0x06, 0x02, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-20 抜	# [cjk] */
{ 0x94B3,  1, 5, { 0x07, 0x0b, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-21 筏	# [cjk] */
{ 0x94B4,  1, 5, { 0x09, 0x05, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-22 閥	# [cjk] */
{ 0x94B5,  1, 5, { 0x09, 0x0c, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-23 鳩	# [cjk] */
{ 0x94B6,  1, 5, { 0x05, 0x06, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-24 噺	# [cjk] */
{ 0x94B7,  1, 5, { 0x05, 0x08, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-25 塙	# [cjk] */
{ 0x94B8,  1, 5, { 0x08, 0x06, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-26 蛤	# [cjk] */
{ 0x94B9,  1, 5, { 0x09, 0x06, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-27 隼	# [cjk] */
{ 0x94BA,  1, 5, { 0x04, 0x0f, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-28 伴	# [cjk] */
{ 0x94BB,  1, 5, { 0x05, 0x02, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-29 判	# [cjk] */
{ 0x94BC,  1, 5, { 0x05, 0x03, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-30 半	# [cjk] */
{ 0x94BD,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-31 反	# [cjk] */
{ 0x94BE,  1, 5, { 0x05, 0x03, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-32 叛	# [cjk] */
{ 0x94BF,  1, 5, { 0x05, 0x0e, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-33 帆	# [cjk] */
{ 0x94C0,  1, 5, { 0x06, 0x04, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-34 搬	# [cjk] */
{ 0x94C1,  1, 5, { 0x06, 0x05, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-35 斑	# [cjk] */
{ 0x94C2,  1, 5, { 0x06, 0x07, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-36 板	# [cjk] */
{ 0x94C3,  1, 5, { 0x06, 0x0c, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-37 氾	# [cjk] */
{ 0x94C4,  1, 5, { 0x06, 0x0c, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-38 汎	# [cjk] */
{ 0x94C5,  1, 5, { 0x07, 0x02, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-39 版	# [cjk] */
{ 0x94C6,  1, 5, { 0x07, 0x02, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-40 犯	# [cjk] */
{ 0x94C7,  1, 5, { 0x07, 0x03, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-41 班	# [cjk] */
{ 0x94C8,  1, 5, { 0x07, 0x05, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-42 畔	# [cjk] */
{ 0x94C9,  1, 5, { 0x07, 0x0e, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-43 繁	# [cjk] */
{ 0x94CA,  1, 5, { 0x08, 0x02, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-44 般	# [cjk] */
{ 0x94CB,  1, 5, { 0x08, 0x05, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-45 藩	# [cjk] */
{ 0x94CC,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-46 販	# [cjk] */
{ 0x94CD,  1, 5, { 0x07, 0x0b, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-47 範	# [cjk] */
{ 0x94CE,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-48 釆	# [cjk] */
{ 0x94CF,  1, 5, { 0x07, 0x01, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-49 煩	# [cjk] */
{ 0x94D0,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-50 頒	# [cjk] */
{ 0x94D1,  1, 5, { 0x09, 0x08, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-51 飯	# [cjk] */
{ 0x94D2,  1, 5, { 0x06, 0x03, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-52 挽	# [cjk] */
{ 0x94D3,  1, 5, { 0x06, 0x06, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-53 晩	# [cjk] */
{ 0x94D4,  1, 5, { 0x07, 0x05, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-54 番	# [cjk] */
{ 0x94D5,  1, 5, { 0x07, 0x06, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-55 盤	# [cjk] */
{ 0x94D6,  1, 5, { 0x07, 0x08, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-56 磐	# [cjk] */
{ 0x94D7,  1, 5, { 0x08, 0x05, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-57 蕃	# [cjk] */
{ 0x94D8,  1, 5, { 0x08, 0x06, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-58 蛮	# [cjk] */
{ 0x94D9,  1, 5, { 0x05, 0x03, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-59 匪	# [cjk] */
{ 0x94DA,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-60 卑	# [cjk] */
{ 0x94DB,  1, 5, { 0x05, 0x04, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-61 否	# [cjk] */
{ 0x94DC,  1, 5, { 0x05, 0x09, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-62 妃	# [cjk] */
{ 0x94DD,  1, 5, { 0x05, 0x0e, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-63 庇	# [cjk] */
{ 0x94DE,  1, 5, { 0x05, 0x0f, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-64 彼	# [cjk] */
{ 0x94DF,  1, 5, { 0x06, 0x00, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-65 悲	# [cjk] */
{ 0x94E0,  1, 5, { 0x06, 0x02, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-66 扉	# [cjk] */
{ 0x94E1,  1, 5, { 0x06, 0x02, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-67 批	# [cjk] */
{ 0x94E2,  1, 5, { 0x06, 0x02, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-68 披	# [cjk] */
{ 0x94E3,  1, 5, { 0x06, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-69 斐	# [cjk] */
{ 0x94E4,  1, 5, { 0x06, 0x0b, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-70 比	# [cjk] */
{ 0x94E5,  1, 5, { 0x06, 0x0c, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-71 泌	# [cjk] */
{ 0x94E6,  1, 5, { 0x07, 0x05, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-72 疲	# [cjk] */
{ 0x94E7,  1, 5, { 0x07, 0x06, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-73 皮	# [cjk] */
{ 0x94E8,  1, 5, { 0x07, 0x08, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-74 碑	# [cjk] */
{ 0x94E9,  1, 5, { 0x07, 0x09, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-75 秘	# [cjk] */
{ 0x94EA,  1, 5, { 0x07, 0x0d, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-76 緋	# [cjk] */
{ 0x94EB,  1, 5, { 0x07, 0x0f, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-77 罷	# [cjk] */
{ 0x94EC,  1, 5, { 0x08, 0x00, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-78 肥	# [cjk] */
{ 0x94ED,  1, 5, { 0x08, 0x08, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-79 被	# [cjk] */
{ 0x94EE,  1, 5, { 0x08, 0x0a, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-80 誹	# [cjk] */
{ 0x94EF,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-81 費	# [cjk] */
{ 0x94F0,  1, 5, { 0x09, 0x00, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-82 避	# [cjk] */
{ 0x94F1,  1, 5, { 0x09, 0x07, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-83 非	# [cjk] */
{ 0x94F2,  1, 5, { 0x09, 0x08, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-84 飛	# [cjk] */
{ 0x94F3,  1, 5, { 0x06, 0x0a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-85 樋	# [cjk] */
{ 0x94F4,  1, 5, { 0x07, 0x0c, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-86 簸	# [cjk] */
{ 0x94F5,  1, 5, { 0x05, 0x00, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-87 備	# [cjk] */
{ 0x94F6,  1, 5, { 0x05, 0x0c, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-88 尾	# [cjk] */
{ 0x94F7,  1, 5, { 0x05, 0x0f, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-89 微	# [cjk] */
{ 0x94F8,  1, 5, { 0x06, 0x07, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-90 枇	# [cjk] */
{ 0x94F9,  1, 5, { 0x06, 0x0b, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-91 毘	# [cjk] */
{ 0x94FA,  1, 5, { 0x07, 0x04, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-92 琵	# [cjk] */
{ 0x94FB,  1, 5, { 0x07, 0x07, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-93 眉	# [cjk] */
{ 0x94FC,  1, 5, { 0x07, 0x0f, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-40-94 美	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9540,  1, 5, { 0x09, 0x0f, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-01 鼻	# [cjk] */
{ 0x9541,  1, 5, { 0x06, 0x07, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-02 柊	# [cjk] */
{ 0x9542,  1, 5, { 0x07, 0x0a, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-03 稗	# [cjk] */
{ 0x9543,  1, 5, { 0x05, 0x03, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-04 匹	# [cjk] */
{ 0x9544,  1, 5, { 0x07, 0x05, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-05 疋	# [cjk] */
{ 0x9545,  1, 5, { 0x09, 0x0a, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-06 髭	# [cjk] */
{ 0x9546,  1, 5, { 0x05, 0x0f, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-07 彦	# [cjk] */
{ 0x9547,  1, 5, { 0x08, 0x01, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-08 膝	# [cjk] */
{ 0x9548,  1, 5, { 0x08, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-09 菱	# [cjk] */
{ 0x9549,  1, 5, { 0x08, 0x00, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-10 肘	# [cjk] */
{ 0x954A,  1, 5, { 0x05, 0x0f, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-11 弼	# [cjk] */
{ 0x954B,  1, 5, { 0x05, 0x0f, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-12 必	# [cjk] */
{ 0x954C,  1, 5, { 0x07, 0x05, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-13 畢	# [cjk] */
{ 0x954D,  1, 5, { 0x07, 0x0b, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-14 筆	# [cjk] */
{ 0x954E,  1, 5, { 0x09, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-15 逼	# [cjk] */
{ 0x954F,  1, 5, { 0x06, 0x08, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-16 桧	# [cjk] */
{ 0x9550,  1, 5, { 0x05, 0x09, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-17 姫	# [cjk] */
{ 0x9551,  1, 5, { 0x05, 0x0a, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-18 媛	# [cjk] */
{ 0x9552,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-19 紐	# [cjk] */
{ 0x9553,  1, 5, { 0x07, 0x06, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-20 百	# [cjk] */
{ 0x9554,  1, 5, { 0x08, 0x0b, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-21 謬	# [cjk] */
{ 0x9555,  1, 5, { 0x04, 0x0f, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-22 俵	# [cjk] */
{ 0x9556,  1, 5, { 0x05, 0x0f, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-23 彪	# [cjk] */
{ 0x9557,  1, 5, { 0x06, 0x0a, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-24 標	# [cjk] */
{ 0x9558,  1, 5, { 0x06, 0x0c, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-25 氷	# [cjk] */
{ 0x9559,  1, 5, { 0x06, 0x0f, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-26 漂	# [cjk] */
{ 0x955A,  1, 5, { 0x07, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-27 瓢	# [cjk] */
{ 0x955B,  1, 5, { 0x07, 0x09, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-28 票	# [cjk] */
{ 0x955C,  1, 5, { 0x08, 0x08, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-29 表	# [cjk] */
{ 0x955D,  1, 5, { 0x08, 0x0a, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-30 評	# [cjk] */
{ 0x955E,  1, 5, { 0x08, 0x0c, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-31 豹	# [cjk] */
{ 0x955F,  1, 5, { 0x05, 0x0e, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-32 廟	# [cjk] */
{ 0x9560,  1, 5, { 0x06, 0x03, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-33 描	# [cjk] */
{ 0x9561,  1, 5, { 0x07, 0x05, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-34 病	# [cjk] */
{ 0x9562,  1, 5, { 0x07, 0x09, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-35 秒	# [cjk] */
{ 0x9563,  1, 5, { 0x08, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-36 苗	# [cjk] */
{ 0x9564,  1, 5, { 0x09, 0x03, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-37 錨	# [cjk] */
{ 0x9565,  1, 5, { 0x09, 0x02, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-38 鋲	# [cjk] */
{ 0x9566,  1, 5, { 0x08, 0x04, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-39 蒜	# [cjk] */
{ 0x9567,  1, 5, { 0x08, 0x06, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-40 蛭	# [cjk] */
{ 0x9568,  1, 5, { 0x09, 0x0c, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-41 鰭	# [cjk] */
{ 0x9569,  1, 5, { 0x05, 0x04, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-42 品	# [cjk] */
{ 0x956A,  1, 5, { 0x05, 0x0f, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-43 彬	# [cjk] */
{ 0x956B,  1, 5, { 0x06, 0x05, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-44 斌	# [cjk] */
{ 0x956C,  1, 5, { 0x06, 0x0d, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-45 浜	# [cjk] */
{ 0x956D,  1, 5, { 0x07, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-46 瀕	# [cjk] */
{ 0x956E,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-47 貧	# [cjk] */
{ 0x956F,  1, 5, { 0x08, 0x0c, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-48 賓	# [cjk] */
{ 0x9570,  1, 5, { 0x09, 0x08, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-49 頻	# [cjk] */
{ 0x9571,  1, 5, { 0x06, 0x05, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-50 敏	# [cjk] */
{ 0x9572,  1, 5, { 0x07, 0x04, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-51 瓶	# [cjk] */
{ 0x9573,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-52 不	# [cjk] */
{ 0x9574,  1, 5, { 0x04, 0x0e, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-53 付	# [cjk] */
{ 0x9575,  1, 5, { 0x05, 0x07, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-54 埠	# [cjk] */
{ 0x9576,  1, 5, { 0x05, 0x09, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-55 夫	# [cjk] */
{ 0x9577,  1, 5, { 0x05, 0x0a, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-56 婦	# [cjk] */
{ 0x9578,  1, 5, { 0x05, 0x0b, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-57 富	# [cjk] */
{ 0x9579,  1, 5, { 0x05, 0x01, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-58 冨	# [cjk] */
{ 0x957A,  1, 5, { 0x05, 0x0e, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-59 布	# [cjk] */
{ 0x957B,  1, 5, { 0x05, 0x0e, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-60 府	# [cjk] */
{ 0x957C,  1, 5, { 0x06, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-61 怖	# [cjk] */
{ 0x957D,  1, 5, { 0x06, 0x02, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-62 扶	# [cjk] */
{ 0x957E,  1, 5, { 0x06, 0x05, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-63 敷	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9580,  1, 5, { 0x06, 0x05, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-64 斧	# [cjk] */
{ 0x9581,  1, 5, { 0x06, 0x06, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-65 普	# [cjk] */
{ 0x9582,  1, 5, { 0x06, 0x0d, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-66 浮	# [cjk] */
{ 0x9583,  1, 5, { 0x07, 0x02, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-67 父	# [cjk] */
{ 0x9584,  1, 5, { 0x07, 0x0b, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-68 符	# [cjk] */
{ 0x9585,  1, 5, { 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-69 腐	# [cjk] */
{ 0x9586,  1, 5, { 0x08, 0x01, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-70 膚	# [cjk] */
{ 0x9587,  1, 5, { 0x08, 0x02, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-71 芙	# [cjk] */
{ 0x9588,  1, 5, { 0x08, 0x0b, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-72 譜	# [cjk] */
{ 0x9589,  1, 5, { 0x08, 0x0c, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-73 負	# [cjk] */
{ 0x958A,  1, 5, { 0x08, 0x0c, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-74 賦	# [cjk] */
{ 0x958B,  1, 5, { 0x08, 0x0d, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-75 赴	# [cjk] */
{ 0x958C,  1, 5, { 0x09, 0x06, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-76 阜	# [cjk] */
{ 0x958D,  1, 5, { 0x09, 0x06, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-77 附	# [cjk] */
{ 0x958E,  1, 5, { 0x04, 0x0f, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-78 侮	# [cjk] */
{ 0x958F,  1, 5, { 0x06, 0x04, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-79 撫	# [cjk] */
{ 0x9590,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-80 武	# [cjk] */
{ 0x9591,  1, 5, { 0x08, 0x02, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-81 舞	# [cjk] */
{ 0x9592,  1, 5, { 0x08, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-82 葡	# [cjk] */
{ 0x9593,  1, 5, { 0x08, 0x05, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-83 蕪	# [cjk] */
{ 0x9594,  1, 5, { 0x09, 0x00, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-84 部	# [cjk] */
{ 0x9595,  1, 5, { 0x05, 0x0c, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-85 封	# [cjk] */
{ 0x9596,  1, 5, { 0x06, 0x09, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-86 楓	# [cjk] */
{ 0x9597,  1, 5, { 0x09, 0x08, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-87 風	# [cjk] */
{ 0x9598,  1, 5, { 0x08, 0x04, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-88 葺	# [cjk] */
{ 0x9599,  1, 5, { 0x08, 0x05, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-89 蕗	# [cjk] */
{ 0x959A,  1, 5, { 0x04, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-90 伏	# [cjk] */
{ 0x959B,  1, 5, { 0x05, 0x02, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-91 副	# [cjk] */
{ 0x959C,  1, 5, { 0x05, 0x0f, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-92 復	# [cjk] */
{ 0x959D,  1, 5, { 0x05, 0x0e, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-93 幅	# [cjk] */
{ 0x959E,  1, 5, { 0x06, 0x07, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-41-94 服	# [cjk] */
{ 0x959F,  1, 5, { 0x07, 0x09, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-01 福	# [cjk] */
{ 0x95A0,  1, 5, { 0x08, 0x01, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-02 腹	# [cjk] */
{ 0x95A1,  1, 5, { 0x08, 0x09, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-03 複	# [cjk] */
{ 0x95A2,  1, 5, { 0x08, 0x09, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-04 覆	# [cjk] */
{ 0x95A3,  1, 5, { 0x06, 0x0d, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-05 淵	# [cjk] */
{ 0x95A4,  1, 5, { 0x05, 0x0f, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-06 弗	# [cjk] */
{ 0x95A5,  1, 5, { 0x06, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-07 払	# [cjk] */
{ 0x95A6,  1, 5, { 0x06, 0x0c, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-08 沸	# [cjk] */
{ 0x95A7,  1, 5, { 0x04, 0x0e, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-09 仏	# [cjk] */
{ 0x95A8,  1, 5, { 0x07, 0x02, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-10 物	# [cjk] */
{ 0x95A9,  1, 5, { 0x09, 0x0b, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-11 鮒	# [cjk] */
{ 0x95AA,  1, 5, { 0x05, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-12 分	# [cjk] */
{ 0x95AB,  1, 5, { 0x05, 0x04, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-13 吻	# [cjk] */
{ 0x95AC,  1, 5, { 0x05, 0x06, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-14 噴	# [cjk] */
{ 0x95AD,  1, 5, { 0x05, 0x08, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-15 墳	# [cjk] */
{ 0x95AE,  1, 5, { 0x06, 0x01, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-16 憤	# [cjk] */
{ 0x95AF,  1, 5, { 0x06, 0x02, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-17 扮	# [cjk] */
{ 0x95B0,  1, 5, { 0x07, 0x01, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-18 焚	# [cjk] */
{ 0x95B1,  1, 5, { 0x05, 0x09, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-19 奮	# [cjk] */
{ 0x95B2,  1, 5, { 0x07, 0x0c, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-20 粉	# [cjk] */
{ 0x95B3,  1, 5, { 0x07, 0x0c, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-21 糞	# [cjk] */
{ 0x95B4,  1, 5, { 0x07, 0x0d, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-22 紛	# [cjk] */
{ 0x95B5,  1, 5, { 0x09, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-23 雰	# [cjk] */
{ 0x95B6,  1, 5, { 0x06, 0x05, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-24 文	# [cjk] */
{ 0x95B7,  1, 5, { 0x08, 0x00, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-25 聞	# [cjk] */
{ 0x95B8,  1, 5, { 0x04, 0x0e, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-26 丙	# [cjk] */
{ 0x95B9,  1, 5, { 0x04, 0x0f, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-27 併	# [cjk] */
{ 0x95BA,  1, 5, { 0x05, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-28 兵	# [cjk] */
{ 0x95BB,  1, 5, { 0x05, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-29 塀	# [cjk] */
{ 0x95BC,  1, 5, { 0x05, 0x0e, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-30 幣	# [cjk] */
{ 0x95BD,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-31 平	# [cjk] */
{ 0x95BE,  1, 5, { 0x05, 0x0f, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-32 弊	# [cjk] */
{ 0x95BF,  1, 5, { 0x06, 0x07, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-33 柄	# [cjk] */
{ 0x95C0,  1, 5, { 0x04, 0x0e, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-34 並	# [cjk] */
{ 0x95C1,  1, 5, { 0x08, 0x05, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-35 蔽	# [cjk] */
{ 0x95C2,  1, 5, { 0x09, 0x05, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-36 閉	# [cjk] */
{ 0x95C3,  1, 5, { 0x09, 0x06, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-37 陛	# [cjk] */
{ 0x95C4,  1, 5, { 0x07, 0x0c, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-38 米	# [cjk] */
{ 0x95C5,  1, 5, { 0x09, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-39 頁	# [cjk] */
{ 0x95C6,  1, 5, { 0x05, 0x00, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-40 僻	# [cjk] */
{ 0x95C7,  1, 5, { 0x05, 0x08, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-41 壁	# [cjk] */
{ 0x95C8,  1, 5, { 0x07, 0x06, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-42 癖	# [cjk] */
{ 0x95C9,  1, 5, { 0x07, 0x08, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-43 碧	# [cjk] */
{ 0x95CA,  1, 5, { 0x05, 0x02, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-44 別	# [cjk] */
{ 0x95CB,  1, 5, { 0x07, 0x07, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-45 瞥	# [cjk] */
{ 0x95CC,  1, 5, { 0x08, 0x05, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-46 蔑	# [cjk] */
{ 0x95CD,  1, 5, { 0x07, 0x0b, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-47 箆	# [cjk] */
{ 0x95CE,  1, 5, { 0x05, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-48 偏	# [cjk] */
{ 0x95CF,  1, 5, { 0x05, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-49 変	# [cjk] */
{ 0x95D0,  1, 5, { 0x07, 0x02, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-50 片	# [cjk] */
{ 0x95D1,  1, 5, { 0x07, 0x0b, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-51 篇	# [cjk] */
{ 0x95D2,  1, 5, { 0x07, 0x0d, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-52 編	# [cjk] */
{ 0x95D3,  1, 5, { 0x08, 0x0f, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-53 辺	# [cjk] */
{ 0x95D4,  1, 5, { 0x08, 0x0f, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-54 返	# [cjk] */
{ 0x95D5,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-55 遍	# [cjk] */
{ 0x95D6,  1, 5, { 0x04, 0x0f, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-56 便	# [cjk] */
{ 0x95D7,  1, 5, { 0x05, 0x02, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-57 勉	# [cjk] */
{ 0x95D8,  1, 5, { 0x05, 0x0a, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-58 娩	# [cjk] */
{ 0x95D9,  1, 5, { 0x05, 0x0f, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-59 弁	# [cjk] */
{ 0x95DA,  1, 5, { 0x09, 0x07, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-60 鞭	# [cjk] */
{ 0x95DB,  1, 5, { 0x04, 0x0f, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-61 保	# [cjk] */
{ 0x95DC,  1, 5, { 0x08, 0x02, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-62 舗	# [cjk] */
{ 0x95DD,  1, 5, { 0x09, 0x02, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-63 鋪	# [cjk] */
{ 0x95DE,  1, 5, { 0x05, 0x07, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-64 圃	# [cjk] */
{ 0x95DF,  1, 5, { 0x06, 0x03, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-65 捕	# [cjk] */
{ 0x95E0,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-66 歩	# [cjk] */
{ 0x95E1,  1, 5, { 0x07, 0x05, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-67 甫	# [cjk] */
{ 0x95E2,  1, 5, { 0x08, 0x08, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-68 補	# [cjk] */
{ 0x95E3,  1, 5, { 0x08, 0x0f, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-69 輔	# [cjk] */
{ 0x95E4,  1, 5, { 0x07, 0x0a, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-70 穂	# [cjk] */
{ 0x95E5,  1, 5, { 0x05, 0x02, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-71 募	# [cjk] */
{ 0x95E6,  1, 5, { 0x05, 0x08, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-72 墓	# [cjk] */
{ 0x95E7,  1, 5, { 0x06, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-73 慕	# [cjk] */
{ 0x95E8,  1, 5, { 0x06, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-74 戊	# [cjk] */
{ 0x95E9,  1, 5, { 0x06, 0x06, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-75 暮	# [cjk] */
{ 0x95EA,  1, 5, { 0x06, 0x0b, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-76 母	# [cjk] */
{ 0x95EB,  1, 5, { 0x07, 0x0c, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-77 簿	# [cjk] */
{ 0x95EC,  1, 5, { 0x08, 0x03, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-78 菩	# [cjk] */
{ 0x95ED,  1, 5, { 0x05, 0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-79 倣	# [cjk] */
{ 0x95EE,  1, 5, { 0x04, 0x0f, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-80 俸	# [cjk] */
{ 0x95EF,  1, 5, { 0x05, 0x03, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-81 包	# [cjk] */
{ 0x95F0,  1, 5, { 0x05, 0x04, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-82 呆	# [cjk] */
{ 0x95F1,  1, 5, { 0x05, 0x08, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-83 報	# [cjk] */
{ 0x95F2,  1, 5, { 0x05, 0x09, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-84 奉	# [cjk] */
{ 0x95F3,  1, 5, { 0x05, 0x0b, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-85 宝	# [cjk] */
{ 0x95F4,  1, 5, { 0x05, 0x0c, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-86 峰	# [cjk] */
{ 0x95F5,  1, 5, { 0x05, 0x0c, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-87 峯	# [cjk] */
{ 0x95F6,  1, 5, { 0x05, 0x0d, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-88 崩	# [cjk] */
{ 0x95F7,  1, 5, { 0x05, 0x0e, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-89 庖	# [cjk] */
{ 0x95F8,  1, 5, { 0x06, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-90 抱	# [cjk] */
{ 0x95F9,  1, 5, { 0x06, 0x03, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-91 捧	# [cjk] */
{ 0x95FA,  1, 5, { 0x06, 0x05, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-92 放	# [cjk] */
{ 0x95FB,  1, 5, { 0x06, 0x05, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-93 方	# [cjk] */
{ 0x95FC,  1, 5, { 0x06, 0x07, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-42-94 朋	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9640,  1, 5, { 0x06, 0x0c, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-01 法	# [cjk] */
{ 0x9641,  1, 5, { 0x06, 0x0c, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-02 泡	# [cjk] */
{ 0x9642,  1, 5, { 0x07, 0x00, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-03 烹	# [cjk] */
{ 0x9643,  1, 5, { 0x07, 0x08, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-04 砲	# [cjk] */
{ 0x9644,  1, 5, { 0x07, 0x0e, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-05 縫	# [cjk] */
{ 0x9645,  1, 5, { 0x08, 0x00, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-06 胞	# [cjk] */
{ 0x9646,  1, 5, { 0x08, 0x02, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-07 芳	# [cjk] */
{ 0x9647,  1, 5, { 0x08, 0x04, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-08 萌	# [cjk] */
{ 0x9648,  1, 5, { 0x08, 0x04, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-09 蓬	# [cjk] */
{ 0x9649,  1, 5, { 0x08, 0x07, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-10 蜂	# [cjk] */
{ 0x964A,  1, 5, { 0x08, 0x09, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-11 褒	# [cjk] */
{ 0x964B,  1, 5, { 0x08, 0x0a, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-12 訪	# [cjk] */
{ 0x964C,  1, 5, { 0x08, 0x0c, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-13 豊	# [cjk] */
{ 0x964D,  1, 5, { 0x09, 0x00, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-14 邦	# [cjk] */
{ 0x964E,  1, 5, { 0x09, 0x02, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-15 鋒	# [cjk] */
{ 0x964F,  1, 5, { 0x09, 0x08, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-16 飽	# [cjk] */
{ 0x9650,  1, 5, { 0x09, 0x0c, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-17 鳳	# [cjk] */
{ 0x9651,  1, 5, { 0x09, 0x0d, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-18 鵬	# [cjk] */
{ 0x9652,  1, 5, { 0x04, 0x0e, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-19 乏	# [cjk] */
{ 0x9653,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-20 亡	# [cjk] */
{ 0x9654,  1, 5, { 0x05, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-21 傍	# [cjk] */
{ 0x9655,  1, 5, { 0x05, 0x02, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-22 剖	# [cjk] */
{ 0x9656,  1, 5, { 0x05, 0x07, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-23 坊	# [cjk] */
{ 0x9657,  1, 5, { 0x05, 0x09, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-24 妨	# [cjk] */
{ 0x9658,  1, 5, { 0x05, 0x0e, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-25 帽	# [cjk] */
{ 0x9659,  1, 5, { 0x05, 0x0f, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-26 忘	# [cjk] */
{ 0x965A,  1, 5, { 0x05, 0x0f, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-27 忙	# [cjk] */
{ 0x965B,  1, 5, { 0x06, 0x02, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-28 房	# [cjk] */
{ 0x965C,  1, 5, { 0x06, 0x06, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-29 暴	# [cjk] */
{ 0x965D,  1, 5, { 0x06, 0x07, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-30 望	# [cjk] */
{ 0x965E,  1, 5, { 0x06, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-31 某	# [cjk] */
{ 0x965F,  1, 5, { 0x06, 0x08, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-32 棒	# [cjk] */
{ 0x9660,  1, 5, { 0x05, 0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-33 冒	# [cjk] */
{ 0x9661,  1, 5, { 0x07, 0x0d, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-34 紡	# [cjk] */
{ 0x9662,  1, 5, { 0x08, 0x00, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-35 肪	# [cjk] */
{ 0x9663,  1, 5, { 0x08, 0x01, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-36 膨	# [cjk] */
{ 0x9664,  1, 5, { 0x08, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-37 謀	# [cjk] */
{ 0x9665,  1, 5, { 0x08, 0x0c, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-38 貌	# [cjk] */
{ 0x9666,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-39 貿	# [cjk] */
{ 0x9667,  1, 5, { 0x09, 0x02, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-40 鉾	# [cjk] */
{ 0x9668,  1, 5, { 0x09, 0x06, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-41 防	# [cjk] */
{ 0x9669,  1, 5, { 0x05, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-42 吠	# [cjk] */
{ 0x966A,  1, 5, { 0x09, 0x08, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-43 頬	# [cjk] */
{ 0x966B,  1, 5, { 0x05, 0x03, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-44 北	# [cjk] */
{ 0x966C,  1, 5, { 0x05, 0x00, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-45 僕	# [cjk] */
{ 0x966D,  1, 5, { 0x05, 0x03, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-46 卜	# [cjk] */
{ 0x966E,  1, 5, { 0x05, 0x08, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-47 墨	# [cjk] */
{ 0x966F,  1, 5, { 0x06, 0x04, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-48 撲	# [cjk] */
{ 0x9670,  1, 5, { 0x06, 0x07, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-49 朴	# [cjk] */
{ 0x9671,  1, 5, { 0x07, 0x02, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-50 牧	# [cjk] */
{ 0x9672,  1, 5, { 0x07, 0x07, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-51 睦	# [cjk] */
{ 0x9673,  1, 5, { 0x07, 0x0a, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-52 穆	# [cjk] */
{ 0x9674,  1, 5, { 0x09, 0x01, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-53 釦	# [cjk] */
{ 0x9675,  1, 5, { 0x05, 0x02, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-54 勃	# [cjk] */
{ 0x9676,  1, 5, { 0x06, 0x0c, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-55 没	# [cjk] */
{ 0x9677,  1, 5, { 0x06, 0x0b, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-56 殆	# [cjk] */
{ 0x9678,  1, 5, { 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-57 堀	# [cjk] */
{ 0x9679,  1, 5, { 0x05, 0x0e, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-58 幌	# [cjk] */
{ 0x967A,  1, 5, { 0x05, 0x09, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-59 奔	# [cjk] */
{ 0x967B,  1, 5, { 0x06, 0x07, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-60 本	# [cjk] */
{ 0x967C,  1, 5, { 0x07, 0x0f, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-61 翻	# [cjk] */
{ 0x967D,  1, 5, { 0x05, 0x01, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-62 凡	# [cjk] */
{ 0x967E,  1, 5, { 0x07, 0x06, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-63 盆	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9680,  1, 5, { 0x06, 0x04, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-64 摩	# [cjk] */
{ 0x9681,  1, 5, { 0x07, 0x08, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-65 磨	# [cjk] */
{ 0x9682,  1, 5, { 0x09, 0x0b, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-66 魔	# [cjk] */
{ 0x9683,  1, 5, { 0x09, 0x0e, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-67 麻	# [cjk] */
{ 0x9684,  1, 5, { 0x05, 0x07, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-68 埋	# [cjk] */
{ 0x9685,  1, 5, { 0x05, 0x09, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-69 妹	# [cjk] */
{ 0x9686,  1, 5, { 0x06, 0x06, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-70 昧	# [cjk] */
{ 0x9687,  1, 5, { 0x06, 0x07, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-71 枚	# [cjk] */
{ 0x9688,  1, 5, { 0x06, 0x0b, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-72 毎	# [cjk] */
{ 0x9689,  1, 5, { 0x05, 0x04, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-73 哩	# [cjk] */
{ 0x968A,  1, 5, { 0x06, 0x09, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-74 槙	# [cjk] */
{ 0x968B,  1, 5, { 0x05, 0x0e, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-75 幕	# [cjk] */
{ 0x968C,  1, 5, { 0x08, 0x01, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-76 膜	# [cjk] */
{ 0x968D,  1, 5, { 0x06, 0x07, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-77 枕	# [cjk] */
{ 0x968E,  1, 5, { 0x09, 0x0b, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-78 鮪	# [cjk] */
{ 0x968F,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-79 柾	# [cjk] */
{ 0x9690,  1, 5, { 0x09, 0x0c, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-80 鱒	# [cjk] */
{ 0x9691,  1, 5, { 0x06, 0x08, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-81 桝	# [cjk] */
{ 0x9692,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-82 亦	# [cjk] */
{ 0x9693,  1, 5, { 0x04, 0x0f, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-83 俣	# [cjk] */
{ 0x9694,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-84 又	# [cjk] */
{ 0x9695,  1, 5, { 0x06, 0x02, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-85 抹	# [cjk] */
{ 0x9696,  1, 5, { 0x06, 0x07, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-86 末	# [cjk] */
{ 0x9697,  1, 5, { 0x06, 0x0c, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-87 沫	# [cjk] */
{ 0x9698,  1, 5, { 0x08, 0x0f, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-88 迄	# [cjk] */
{ 0x9699,  1, 5, { 0x04, 0x0f, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-89 侭	# [cjk] */
{ 0x969A,  1, 5, { 0x07, 0x0e, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-90 繭	# [cjk] */
{ 0x969B,  1, 5, { 0x09, 0x0e, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-91 麿	# [cjk] */
{ 0x969C,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-92 万	# [cjk] */
{ 0x969D,  1, 5, { 0x06, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-93 慢	# [cjk] */
{ 0x969E,  1, 5, { 0x06, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-43-94 満	# [cjk] */
{ 0x969F,  1, 5, { 0x06, 0x0f, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-01 漫	# [cjk] */
{ 0x96A0,  1, 5, { 0x08, 0x05, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-02 蔓	# [cjk] */
{ 0x96A1,  1, 5, { 0x05, 0x04, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-03 味	# [cjk] */
{ 0x96A2,  1, 5, { 0x06, 0x07, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-04 未	# [cjk] */
{ 0x96A3,  1, 5, { 0x09, 0x0b, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-05 魅	# [cjk] */
{ 0x96A4,  1, 5, { 0x05, 0x0d, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-06 巳	# [cjk] */
{ 0x96A5,  1, 5, { 0x07, 0x0b, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-07 箕	# [cjk] */
{ 0x96A6,  1, 5, { 0x05, 0x0c, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-08 岬	# [cjk] */
{ 0x96A7,  1, 5, { 0x05, 0x0b, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-09 密	# [cjk] */
{ 0x96A8,  1, 5, { 0x08, 0x07, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-10 蜜	# [cjk] */
{ 0x96A9,  1, 5, { 0x06, 0x0e, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-11 湊	# [cjk] */
{ 0x96AA,  1, 5, { 0x08, 0x04, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-12 蓑	# [cjk] */
{ 0x96AB,  1, 5, { 0x07, 0x0a, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-13 稔	# [cjk] */
{ 0x96AC,  1, 5, { 0x08, 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-14 脈	# [cjk] */
{ 0x96AD,  1, 5, { 0x05, 0x09, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-15 妙	# [cjk] */
{ 0x96AE,  1, 5, { 0x07, 0x0c, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-16 粍	# [cjk] */
{ 0x96AF,  1, 5, { 0x06, 0x0c, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-17 民	# [cjk] */
{ 0x96B0,  1, 5, { 0x07, 0x07, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-18 眠	# [cjk] */
{ 0x96B1,  1, 5, { 0x05, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-19 務	# [cjk] */
{ 0x96B2,  1, 5, { 0x05, 0x09, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-20 夢	# [cjk] */
{ 0x96B3,  1, 5, { 0x07, 0x01, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-21 無	# [cjk] */
{ 0x96B4,  1, 5, { 0x07, 0x02, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-22 牟	# [cjk] */
{ 0x96B5,  1, 5, { 0x07, 0x07, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-23 矛	# [cjk] */
{ 0x96B6,  1, 5, { 0x09, 0x07, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-24 霧	# [cjk] */
{ 0x96B7,  1, 5, { 0x09, 0x0d, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-25 鵡	# [cjk] */
{ 0x96B8,  1, 5, { 0x06, 0x09, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-26 椋	# [cjk] */
{ 0x96B9,  1, 5, { 0x05, 0x0a, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-27 婿	# [cjk] */
{ 0x96BA,  1, 5, { 0x05, 0x0a, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-28 娘	# [cjk] */
{ 0x96BB,  1, 5, { 0x05, 0x01, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-29 冥	# [cjk] */
{ 0x96BC,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-30 名	# [cjk] */
{ 0x96BD,  1, 5, { 0x05, 0x04, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-31 命	# [cjk] */
{ 0x96BE,  1, 5, { 0x06, 0x06, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-32 明	# [cjk] */
{ 0x96BF,  1, 5, { 0x07, 0x06, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-33 盟	# [cjk] */
{ 0x96C0,  1, 5, { 0x08, 0x0f, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-34 迷	# [cjk] */
{ 0x96C1,  1, 5, { 0x09, 0x02, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-35 銘	# [cjk] */
{ 0x96C2,  1, 5, { 0x09, 0x0c, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-36 鳴	# [cjk] */
{ 0x96C3,  1, 5, { 0x05, 0x09, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-37 姪	# [cjk] */
{ 0x96C4,  1, 5, { 0x07, 0x02, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-38 牝	# [cjk] */
{ 0x96C5,  1, 5, { 0x06, 0x0e, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-39 滅	# [cjk] */
{ 0x96C6,  1, 5, { 0x05, 0x01, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-40 免	# [cjk] */
{ 0x96C7,  1, 5, { 0x06, 0x08, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-41 棉	# [cjk] */
{ 0x96C8,  1, 5, { 0x07, 0x0d, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-42 綿	# [cjk] */
{ 0x96C9,  1, 5, { 0x07, 0x0d, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-43 緬	# [cjk] */
{ 0x96CA,  1, 5, { 0x09, 0x07, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-44 面	# [cjk] */
{ 0x96CB,  1, 5, { 0x09, 0x0e, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-45 麺	# [cjk] */
{ 0x96CC,  1, 5, { 0x06, 0x04, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-46 摸	# [cjk] */
{ 0x96CD,  1, 5, { 0x06, 0x0a, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-47 模	# [cjk] */
{ 0x96CE,  1, 5, { 0x08, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-48 茂	# [cjk] */
{ 0x96CF,  1, 5, { 0x05, 0x09, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-49 妄	# [cjk] */
{ 0x96D0,  1, 5, { 0x05, 0x0b, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-50 孟	# [cjk] */
{ 0x96D1,  1, 5, { 0x06, 0x0b, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-51 毛	# [cjk] */
{ 0x96D2,  1, 5, { 0x07, 0x03, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-52 猛	# [cjk] */
{ 0x96D3,  1, 5, { 0x07, 0x06, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-53 盲	# [cjk] */
{ 0x96D4,  1, 5, { 0x07, 0x0d, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-54 網	# [cjk] */
{ 0x96D5,  1, 5, { 0x08, 0x00, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-55 耗	# [cjk] */
{ 0x96D6,  1, 5, { 0x08, 0x04, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-56 蒙	# [cjk] */
{ 0x96D7,  1, 5, { 0x05, 0x01, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-57 儲	# [cjk] */
{ 0x96D8,  1, 5, { 0x06, 0x07, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-58 木	# [cjk] */
{ 0x96D9,  1, 5, { 0x09, 0x0e, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-59 黙	# [cjk] */
{ 0x96DA,  1, 5, { 0x07, 0x06, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-60 目	# [cjk] */
{ 0x96DB,  1, 5, { 0x06, 0x07, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-61 杢	# [cjk] */
{ 0x96DC,  1, 5, { 0x05, 0x02, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-62 勿	# [cjk] */
{ 0x96DD,  1, 5, { 0x09, 0x09, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-63 餅	# [cjk] */
{ 0x96DE,  1, 5, { 0x05, 0x0c, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-64 尤	# [cjk] */
{ 0x96DF,  1, 5, { 0x06, 0x02, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-65 戻	# [cjk] */
{ 0x96E0,  1, 5, { 0x07, 0x0c, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-66 籾	# [cjk] */
{ 0x96E1,  1, 5, { 0x08, 0x0c, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-67 貰	# [cjk] */
{ 0x96E2,  1, 5, { 0x05, 0x05, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-68 問	# [cjk] */
{ 0x96E3,  1, 5, { 0x06, 0x00, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-69 悶	# [cjk] */
{ 0x96E4,  1, 5, { 0x07, 0x0d, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-70 紋	# [cjk] */
{ 0x96E5,  1, 5, { 0x09, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-71 門	# [cjk] */
{ 0x96E6,  1, 5, { 0x05, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-72 匁	# [cjk] */
{ 0x96E7,  1, 5, { 0x04, 0x0e, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-73 也	# [cjk] */
{ 0x96E8,  1, 5, { 0x05, 0x01, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-74 冶	# [cjk] */
{ 0x96E9,  1, 5, { 0x05, 0x09, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-75 夜	# [cjk] */
{ 0x96EA,  1, 5, { 0x07, 0x02, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-76 爺	# [cjk] */
{ 0x96EB,  1, 5, { 0x08, 0x00, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-77 耶	# [cjk] */
{ 0x96EC,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-78 野	# [cjk] */
{ 0x96ED,  1, 5, { 0x05, 0x0f, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-79 弥	# [cjk] */
{ 0x96EE,  1, 5, { 0x07, 0x07, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-80 矢	# [cjk] */
{ 0x96EF,  1, 5, { 0x05, 0x03, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-81 厄	# [cjk] */
{ 0x96F0,  1, 5, { 0x05, 0x0f, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-82 役	# [cjk] */
{ 0x96F1,  1, 5, { 0x07, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-83 約	# [cjk] */
{ 0x96F2,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-84 薬	# [cjk] */
{ 0x96F3,  1, 5, { 0x08, 0x0a, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-85 訳	# [cjk] */
{ 0x96F4,  1, 5, { 0x08, 0x0e, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-86 躍	# [cjk] */
{ 0x96F5,  1, 5, { 0x09, 0x07, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-87 靖	# [cjk] */
{ 0x96F6,  1, 5, { 0x06, 0x07, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-88 柳	# [cjk] */
{ 0x96F7,  1, 5, { 0x08, 0x05, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-89 薮	# [cjk] */
{ 0x96F8,  1, 5, { 0x09, 0x04, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-90 鑓	# [cjk] */
{ 0x96F9,  1, 5, { 0x06, 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-91 愉	# [cjk] */
{ 0x96FA,  1, 5, { 0x06, 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-92 愈	# [cjk] */
{ 0x96FB,  1, 5, { 0x06, 0x0c, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-93 油	# [cjk] */
{ 0x96FC,  1, 5, { 0x07, 0x06, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-44-94 癒	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9740,  1, 5, { 0x08, 0x0a, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-01 諭	# [cjk] */
{ 0x9741,  1, 5, { 0x08, 0x0f, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-02 輸	# [cjk] */
{ 0x9742,  1, 5, { 0x05, 0x05, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-03 唯	# [cjk] */
{ 0x9743,  1, 5, { 0x04, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-04 佑	# [cjk] */
{ 0x9744,  1, 5, { 0x05, 0x01, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-05 優	# [cjk] */
{ 0x9745,  1, 5, { 0x05, 0x02, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-06 勇	# [cjk] */
{ 0x9746,  1, 5, { 0x05, 0x03, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-07 友	# [cjk] */
{ 0x9747,  1, 5, { 0x05, 0x0b, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-08 宥	# [cjk] */
{ 0x9748,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-09 幽	# [cjk] */
{ 0x9749,  1, 5, { 0x06, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-10 悠	# [cjk] */
{ 0x974A,  1, 5, { 0x06, 0x01, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-11 憂	# [cjk] */
{ 0x974B,  1, 5, { 0x06, 0x03, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-12 揖	# [cjk] */
{ 0x974C,  1, 5, { 0x06, 0x07, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-13 有	# [cjk] */
{ 0x974D,  1, 5, { 0x06, 0x07, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-14 柚	# [cjk] */
{ 0x974E,  1, 5, { 0x06, 0x0e, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-15 湧	# [cjk] */
{ 0x974F,  1, 5, { 0x06, 0x0d, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-16 涌	# [cjk] */
{ 0x9750,  1, 5, { 0x07, 0x03, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-17 猶	# [cjk] */
{ 0x9751,  1, 5, { 0x07, 0x03, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-18 猷	# [cjk] */
{ 0x9752,  1, 5, { 0x07, 0x05, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-19 由	# [cjk] */
{ 0x9753,  1, 5, { 0x07, 0x09, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-20 祐	# [cjk] */
{ 0x9754,  1, 5, { 0x08, 0x08, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-21 裕	# [cjk] */
{ 0x9755,  1, 5, { 0x08, 0x0a, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-22 誘	# [cjk] */
{ 0x9756,  1, 5, { 0x09, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-23 遊	# [cjk] */
{ 0x9757,  1, 5, { 0x09, 0x00, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-24 邑	# [cjk] */
{ 0x9758,  1, 5, { 0x09, 0x00, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-25 郵	# [cjk] */
{ 0x9759,  1, 5, { 0x09, 0x06, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-26 雄	# [cjk] */
{ 0x975A,  1, 5, { 0x08, 0x07, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-27 融	# [cjk] */
{ 0x975B,  1, 5, { 0x05, 0x09, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-28 夕	# [cjk] */
{ 0x975C,  1, 5, { 0x04, 0x0e, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-29 予	# [cjk] */
{ 0x975D,  1, 5, { 0x04, 0x0f, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-30 余	# [cjk] */
{ 0x975E,  1, 5, { 0x04, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-31 与	# [cjk] */
{ 0x975F,  1, 5, { 0x08, 0x0a, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-32 誉	# [cjk] */
{ 0x9760,  1, 5, { 0x08, 0x0f, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-33 輿	# [cjk] */
{ 0x9761,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-34 預	# [cjk] */
{ 0x9762,  1, 5, { 0x05, 0x00, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-35 傭	# [cjk] */
{ 0x9763,  1, 5, { 0x05, 0x0e, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-36 幼	# [cjk] */
{ 0x9764,  1, 5, { 0x05, 0x09, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-37 妖	# [cjk] */
{ 0x9765,  1, 5, { 0x05, 0x0b, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-38 容	# [cjk] */
{ 0x9766,  1, 5, { 0x05, 0x0e, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-39 庸	# [cjk] */
{ 0x9767,  1, 5, { 0x06, 0x03, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-40 揚	# [cjk] */
{ 0x9768,  1, 5, { 0x06, 0x03, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-41 揺	# [cjk] */
{ 0x9769,  1, 5, { 0x06, 0x04, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-42 擁	# [cjk] */
{ 0x976A,  1, 5, { 0x06, 0x06, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-43 曜	# [cjk] */
{ 0x976B,  1, 5, { 0x06, 0x09, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-44 楊	# [cjk] */
{ 0x976C,  1, 5, { 0x06, 0x09, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-45 様	# [cjk] */
{ 0x976D,  1, 5, { 0x06, 0x0d, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-46 洋	# [cjk] */
{ 0x976E,  1, 5, { 0x06, 0x0e, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-47 溶	# [cjk] */
{ 0x976F,  1, 5, { 0x07, 0x01, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-48 熔	# [cjk] */
{ 0x9770,  1, 5, { 0x07, 0x05, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-49 用	# [cjk] */
{ 0x9771,  1, 5, { 0x07, 0x0a, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-50 窯	# [cjk] */
{ 0x9772,  1, 5, { 0x07, 0x0f, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-51 羊	# [cjk] */
{ 0x9773,  1, 5, { 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-52 耀	# [cjk] */
{ 0x9774,  1, 5, { 0x08, 0x04, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-53 葉	# [cjk] */
{ 0x9775,  1, 5, { 0x08, 0x04, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-54 蓉	# [cjk] */
{ 0x9776,  1, 5, { 0x08, 0x09, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-55 要	# [cjk] */
{ 0x9777,  1, 5, { 0x08, 0x0b, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-56 謡	# [cjk] */
{ 0x9778,  1, 5, { 0x08, 0x0e, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-57 踊	# [cjk] */
{ 0x9779,  1, 5, { 0x09, 0x00, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-58 遥	# [cjk] */
{ 0x977A,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-59 陽	# [cjk] */
{ 0x977B,  1, 5, { 0x09, 0x09, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-60 養	# [cjk] */
{ 0x977C,  1, 5, { 0x06, 0x01, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-61 慾	# [cjk] */
{ 0x977D,  1, 5, { 0x06, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-62 抑	# [cjk] */
{ 0x977E,  1, 5, { 0x06, 0x0b, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-63 欲	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9780,  1, 5, { 0x06, 0x0c, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-64 沃	# [cjk] */
{ 0x9781,  1, 5, { 0x06, 0x0d, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-65 浴	# [cjk] */
{ 0x9782,  1, 5, { 0x07, 0x0f, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-66 翌	# [cjk] */
{ 0x9783,  1, 5, { 0x07, 0x0f, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-67 翼	# [cjk] */
{ 0x9784,  1, 5, { 0x06, 0x0d, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-68 淀	# [cjk] */
{ 0x9785,  1, 5, { 0x07, 0x0f, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-69 羅	# [cjk] */
{ 0x9786,  1, 5, { 0x08, 0x07, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-70 螺	# [cjk] */
{ 0x9787,  1, 5, { 0x08, 0x08, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-71 裸	# [cjk] */
{ 0x9788,  1, 5, { 0x06, 0x07, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-72 来	# [cjk] */
{ 0x9789,  1, 5, { 0x08, 0x03, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-73 莱	# [cjk] */
{ 0x978A,  1, 5, { 0x09, 0x08, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-74 頼	# [cjk] */
{ 0x978B,  1, 5, { 0x09, 0x06, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-75 雷	# [cjk] */
{ 0x978C,  1, 5, { 0x06, 0x0d, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-76 洛	# [cjk] */
{ 0x978D,  1, 5, { 0x07, 0x0d, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-77 絡	# [cjk] */
{ 0x978E,  1, 5, { 0x08, 0x04, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-78 落	# [cjk] */
{ 0x978F,  1, 5, { 0x09, 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-79 酪	# [cjk] */
{ 0x9790,  1, 5, { 0x04, 0x0e, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-80 乱	# [cjk] */
{ 0x9791,  1, 5, { 0x05, 0x03, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-81 卵	# [cjk] */
{ 0x9792,  1, 5, { 0x05, 0x0d, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-82 嵐	# [cjk] */
{ 0x9793,  1, 5, { 0x06, 0x0b, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-83 欄	# [cjk] */
{ 0x9794,  1, 5, { 0x06, 0x0f, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-84 濫	# [cjk] */
{ 0x9795,  1, 5, { 0x08, 0x05, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-85 藍	# [cjk] */
{ 0x9796,  1, 5, { 0x08, 0x06, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-86 蘭	# [cjk] */
{ 0x9797,  1, 5, { 0x08, 0x09, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-87 覧	# [cjk] */
{ 0x9798,  1, 5, { 0x05, 0x02, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-88 利	# [cjk] */
{ 0x9799,  1, 5, { 0x05, 0x04, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-89 吏	# [cjk] */
{ 0x979A,  1, 5, { 0x05, 0x0c, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-90 履	# [cjk] */
{ 0x979B,  1, 5, { 0x06, 0x07, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-91 李	# [cjk] */
{ 0x979C,  1, 5, { 0x06, 0x08, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-92 梨	# [cjk] */
{ 0x979D,  1, 5, { 0x07, 0x04, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-93 理	# [cjk] */
{ 0x979E,  1, 5, { 0x07, 0x04, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-45-94 璃	# [cjk] */
{ 0x979F,  1, 5, { 0x07, 0x05, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-01 痢	# [cjk] */
{ 0x97A0,  1, 5, { 0x08, 0x08, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-02 裏	# [cjk] */
{ 0x97A1,  1, 5, { 0x08, 0x08, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-03 裡	# [cjk] */
{ 0x97A2,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-04 里	# [cjk] */
{ 0x97A3,  1, 5, { 0x09, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-05 離	# [cjk] */
{ 0x97A4,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-06 陸	# [cjk] */
{ 0x97A5,  1, 5, { 0x05, 0x0f, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-07 律	# [cjk] */
{ 0x97A6,  1, 5, { 0x07, 0x03, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-08 率	# [cjk] */
{ 0x97A7,  1, 5, { 0x07, 0x0a, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-09 立	# [cjk] */
{ 0x97A8,  1, 5, { 0x08, 0x04, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-10 葎	# [cjk] */
{ 0x97A9,  1, 5, { 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-11 掠	# [cjk] */
{ 0x97AA,  1, 5, { 0x07, 0x05, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-12 略	# [cjk] */
{ 0x97AB,  1, 5, { 0x05, 0x02, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-13 劉	# [cjk] */
{ 0x97AC,  1, 5, { 0x06, 0x0d, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-14 流	# [cjk] */
{ 0x97AD,  1, 5, { 0x06, 0x0e, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-15 溜	# [cjk] */
{ 0x97AE,  1, 5, { 0x07, 0x04, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-16 琉	# [cjk] */
{ 0x97AF,  1, 5, { 0x07, 0x05, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-17 留	# [cjk] */
{ 0x97B0,  1, 5, { 0x07, 0x08, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-18 硫	# [cjk] */
{ 0x97B1,  1, 5, { 0x07, 0x0c, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-19 粒	# [cjk] */
{ 0x97B2,  1, 5, { 0x09, 0x06, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-20 隆	# [cjk] */
{ 0x97B3,  1, 5, { 0x07, 0x0a, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-21 竜	# [cjk] */
{ 0x97B4,  1, 5, { 0x09, 0x0f, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-22 龍	# [cjk] */
{ 0x97B5,  1, 5, { 0x04, 0x0f, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-23 侶	# [cjk] */
{ 0x97B6,  1, 5, { 0x06, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-24 慮	# [cjk] */
{ 0x97B7,  1, 5, { 0x06, 0x05, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-25 旅	# [cjk] */
{ 0x97B8,  1, 5, { 0x08, 0x06, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-26 虜	# [cjk] */
{ 0x97B9,  1, 5, { 0x04, 0x0e, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-27 了	# [cjk] */
{ 0x97BA,  1, 5, { 0x04, 0x0e, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-28 亮	# [cjk] */
{ 0x97BB,  1, 5, { 0x05, 0x00, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-29 僚	# [cjk] */
{ 0x97BC,  1, 5, { 0x04, 0x0e, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-30 両	# [cjk] */
{ 0x97BD,  1, 5, { 0x05, 0x01, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-31 凌	# [cjk] */
{ 0x97BE,  1, 5, { 0x05, 0x0b, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-32 寮	# [cjk] */
{ 0x97BF,  1, 5, { 0x06, 0x05, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-33 料	# [cjk] */
{ 0x97C0,  1, 5, { 0x06, 0x08, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-34 梁	# [cjk] */
{ 0x97C1,  1, 5, { 0x06, 0x0d, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-35 涼	# [cjk] */
{ 0x97C2,  1, 5, { 0x07, 0x03, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-36 猟	# [cjk] */
{ 0x97C3,  1, 5, { 0x07, 0x06, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-37 療	# [cjk] */
{ 0x97C4,  1, 5, { 0x07, 0x07, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-38 瞭	# [cjk] */
{ 0x97C5,  1, 5, { 0x07, 0x0a, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-39 稜	# [cjk] */
{ 0x97C6,  1, 5, { 0x07, 0x0c, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-40 糧	# [cjk] */
{ 0x97C7,  1, 5, { 0x08, 0x02, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-41 良	# [cjk] */
{ 0x97C8,  1, 5, { 0x08, 0x0a, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-42 諒	# [cjk] */
{ 0x97C9,  1, 5, { 0x09, 0x00, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-43 遼	# [cjk] */
{ 0x97CA,  1, 5, { 0x09, 0x01, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-44 量	# [cjk] */
{ 0x97CB,  1, 5, { 0x09, 0x06, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-45 陵	# [cjk] */
{ 0x97CC,  1, 5, { 0x09, 0x08, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-46 領	# [cjk] */
{ 0x97CD,  1, 5, { 0x05, 0x02, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-47 力	# [cjk] */
{ 0x97CE,  1, 5, { 0x07, 0x0d, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-48 緑	# [cjk] */
{ 0x97CF,  1, 5, { 0x05, 0x00, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-49 倫	# [cjk] */
{ 0x97D0,  1, 5, { 0x05, 0x03, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-50 厘	# [cjk] */
{ 0x97D1,  1, 5, { 0x06, 0x07, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-51 林	# [cjk] */
{ 0x97D2,  1, 5, { 0x06, 0x0d, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-52 淋	# [cjk] */
{ 0x97D3,  1, 5, { 0x07, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-53 燐	# [cjk] */
{ 0x97D4,  1, 5, { 0x07, 0x04, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-54 琳	# [cjk] */
{ 0x97D5,  1, 5, { 0x08, 0x01, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-55 臨	# [cjk] */
{ 0x97D6,  1, 5, { 0x08, 0x0f, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-56 輪	# [cjk] */
{ 0x97D7,  1, 5, { 0x09, 0x06, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-57 隣	# [cjk] */
{ 0x97D8,  1, 5, { 0x09, 0x0c, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-58 鱗	# [cjk] */
{ 0x97D9,  1, 5, { 0x09, 0x0e, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-59 麟	# [cjk] */
{ 0x97DA,  1, 5, { 0x07, 0x04, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-60 瑠	# [cjk] */
{ 0x97DB,  1, 5, { 0x05, 0x08, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-61 塁	# [cjk] */
{ 0x97DC,  1, 5, { 0x06, 0x0d, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-62 涙	# [cjk] */
{ 0x97DD,  1, 5, { 0x07, 0x0d, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-63 累	# [cjk] */
{ 0x97DE,  1, 5, { 0x09, 0x08, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-64 類	# [cjk] */
{ 0x97DF,  1, 5, { 0x04, 0x0e, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-65 令	# [cjk] */
{ 0x97E0,  1, 5, { 0x04, 0x0f, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-66 伶	# [cjk] */
{ 0x97E1,  1, 5, { 0x04, 0x0f, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-67 例	# [cjk] */
{ 0x97E2,  1, 5, { 0x05, 0x01, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-68 冷	# [cjk] */
{ 0x97E3,  1, 5, { 0x05, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-69 励	# [cjk] */
{ 0x97E4,  1, 5, { 0x05, 0x0d, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-70 嶺	# [cjk] */
{ 0x97E5,  1, 5, { 0x06, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-71 怜	# [cjk] */
{ 0x97E6,  1, 5, { 0x07, 0x03, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-72 玲	# [cjk] */
{ 0x97E7,  1, 5, { 0x07, 0x09, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-73 礼	# [cjk] */
{ 0x97E8,  1, 5, { 0x08, 0x02, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-74 苓	# [cjk] */
{ 0x97E9,  1, 5, { 0x09, 0x02, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-75 鈴	# [cjk] */
{ 0x97EA,  1, 5, { 0x09, 0x06, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-76 隷	# [cjk] */
{ 0x97EB,  1, 5, { 0x09, 0x06, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-77 零	# [cjk] */
{ 0x97EC,  1, 5, { 0x09, 0x07, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-78 霊	# [cjk] */
{ 0x97ED,  1, 5, { 0x09, 0x0e, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-79 麗	# [cjk] */
{ 0x97EE,  1, 5, { 0x09, 0x0f, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-80 齢	# [cjk] */
{ 0x97EF,  1, 5, { 0x06, 0x06, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-81 暦	# [cjk] */
{ 0x97F0,  1, 5, { 0x06, 0x0b, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-82 歴	# [cjk] */
{ 0x97F1,  1, 5, { 0x05, 0x02, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-83 列	# [cjk] */
{ 0x97F2,  1, 5, { 0x05, 0x02, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-84 劣	# [cjk] */
{ 0x97F3,  1, 5, { 0x07, 0x00, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-85 烈	# [cjk] */
{ 0x97F4,  1, 5, { 0x08, 0x08, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-86 裂	# [cjk] */
{ 0x97F5,  1, 5, { 0x05, 0x0e, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-87 廉	# [cjk] */
{ 0x97F6,  1, 5, { 0x06, 0x00, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-88 恋	# [cjk] */
{ 0x97F7,  1, 5, { 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-89 憐	# [cjk] */
{ 0x97F8,  1, 5, { 0x06, 0x0f, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-90 漣	# [cjk] */
{ 0x97F9,  1, 5, { 0x07, 0x01, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-91 煉	# [cjk] */
{ 0x97FA,  1, 5, { 0x07, 0x0c, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-92 簾	# [cjk] */
{ 0x97FB,  1, 5, { 0x07, 0x0d, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-93 練	# [cjk] */
{ 0x97FC,  1, 5, { 0x08, 0x00, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-46-94 聯	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9840,  1, 5, { 0x08, 0x04, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-01 蓮	# [cjk] */
{ 0x9841,  1, 5, { 0x09, 0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-02 連	# [cjk] */
{ 0x9842,  1, 5, { 0x09, 0x03, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-03 錬	# [cjk] */
{ 0x9843,  1, 5, { 0x05, 0x04, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-04 呂	# [cjk] */
{ 0x9844,  1, 5, { 0x09, 0x0b, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-05 魯	# [cjk] */
{ 0x9845,  1, 5, { 0x06, 0x0a, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-06 櫓	# [cjk] */
{ 0x9846,  1, 5, { 0x07, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-07 炉	# [cjk] */
{ 0x9847,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-08 賂	# [cjk] */
{ 0x9848,  1, 5, { 0x08, 0x0d, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-09 路	# [cjk] */
{ 0x9849,  1, 5, { 0x09, 0x07, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-10 露	# [cjk] */
{ 0x984A,  1, 5, { 0x05, 0x02, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-11 労	# [cjk] */
{ 0x984B,  1, 5, { 0x05, 0x0a, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-12 婁	# [cjk] */
{ 0x984C,  1, 5, { 0x05, 0x0e, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-13 廊	# [cjk] */
{ 0x984D,  1, 5, { 0x05, 0x0f, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-14 弄	# [cjk] */
{ 0x984E,  1, 5, { 0x06, 0x07, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-15 朗	# [cjk] */
{ 0x984F,  1, 5, { 0x06, 0x09, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-16 楼	# [cjk] */
{ 0x9850,  1, 5, { 0x06, 0x09, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-17 榔	# [cjk] */
{ 0x9851,  1, 5, { 0x06, 0x0d, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-18 浪	# [cjk] */
{ 0x9852,  1, 5, { 0x06, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-19 漏	# [cjk] */
{ 0x9853,  1, 5, { 0x07, 0x02, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-20 牢	# [cjk] */
{ 0x9854,  1, 5, { 0x07, 0x02, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-21 狼	# [cjk] */
{ 0x9855,  1, 5, { 0x07, 0x0b, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-22 篭	# [cjk] */
{ 0x9856,  1, 5, { 0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-23 老	# [cjk] */
{ 0x9857,  1, 5, { 0x08, 0x00, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-24 聾	# [cjk] */
{ 0x9858,  1, 5, { 0x08, 0x07, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-25 蝋	# [cjk] */
{ 0x9859,  1, 5, { 0x09, 0x00, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-26 郎	# [cjk] */
{ 0x985A,  1, 5, { 0x05, 0x01, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-27 六	# [cjk] */
{ 0x985B,  1, 5, { 0x09, 0x0e, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-28 麓	# [cjk] */
{ 0x985C,  1, 5, { 0x07, 0x09, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-29 禄	# [cjk] */
{ 0x985D,  1, 5, { 0x08, 0x00, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-30 肋	# [cjk] */
{ 0x985E,  1, 5, { 0x09, 0x03, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-31 録	# [cjk] */
{ 0x985F,  1, 5, { 0x08, 0x0a, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-32 論	# [cjk] */
{ 0x9860,  1, 5, { 0x05, 0x00, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-33 倭	# [cjk] */
{ 0x9861,  1, 5, { 0x05, 0x04, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-34 和	# [cjk] */
{ 0x9862,  1, 5, { 0x08, 0x0a, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-35 話	# [cjk] */
{ 0x9863,  1, 5, { 0x06, 0x0b, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-36 歪	# [cjk] */
{ 0x9864,  1, 5, { 0x08, 0x0c, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-37 賄	# [cjk] */
{ 0x9865,  1, 5, { 0x08, 0x01, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-38 脇	# [cjk]		 */
{ 0x9866,  1, 5, { 0x06, 0x00, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-39 惑	# [cjk]		 */
{ 0x9867,  1, 5, { 0x06, 0x07, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-40 枠	# [cjk]		 */
{ 0x9868,  1, 5, { 0x09, 0x0d, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-41 鷲	# [cjk]		 */
{ 0x9869,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-42 亙	# [cjk]		 */
{ 0x986A,  1, 5, { 0x04, 0x0e, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-43 亘	# [cjk]		 */
{ 0x986B,  1, 5, { 0x09, 0x0c, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-44 鰐	# [cjk]		 */
{ 0x986C,  1, 5, { 0x08, 0x0a, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-45 詫	# [cjk]		 */
{ 0x986D,  1, 5, { 0x08, 0x05, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-46 藁	# [cjk]		 */
{ 0x986E,  1, 5, { 0x08, 0x05, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-47 蕨	# [cjk]		 */
{ 0x986F,  1, 5, { 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-48 椀	# [cjk]		 */
{ 0x9870,  1, 5, { 0x06, 0x0e, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-49 湾	# [cjk]		 */
{ 0x9871,  1, 5, { 0x07, 0x08, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-50 碗	# [cjk]		 */
{ 0x9872,  1, 5, { 0x08, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-51 腕	# [cjk]		 */
{ 0x9873,  3, 7, { 0x00, 0x02, 0x00, 0x02, 0x03, 0x02, 0x1f, 0x00, 0x00, 0x00 }	},	/* 1-47-52 𠮟	# [cjk]	[2004]	[Unicode3.1] */
{ 0x9874,  3, 5, { 0x05, 0x0b, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-53 孁	# [cjk]	[2000]	 */
{ 0x9875,  3, 5, { 0x05, 0x0b, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-54 孖	# [cjk]	[2000]	 */
{ 0x9876,  3, 5, { 0x05, 0x0b, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-55 孽	# [cjk]	[2000]	 */
{ 0x9877,  3, 5, { 0x05, 0x0b, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-56 宓	# [cjk]	[2000]	 */
{ 0x9878,  3, 5, { 0x05, 0x0b, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-57 寘	# [cjk]	[2000]	 */
{ 0x9879,  3, 5, { 0x05, 0x0b, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-58 寬	# [cjk]	[2000]	 */
{ 0x987A,  3, 5, { 0x05, 0x0c, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-59 尒	# [cjk]	[2000]	 */
{ 0x987B,  3, 5, { 0x05, 0x0c, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-60 尞	# [cjk]	[2000]	 */
{ 0x987C,  3, 5, { 0x05, 0x0c, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-61 尣	# [cjk]	[2000]	 */
{ 0x987D,  3, 5, { 0x05, 0x0c, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-62 尫	# [cjk]	[2000]	 */
{ 0x987E,  3, 5, { 0x03, 0x07, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-63 㞍	# [cjk]	[2000]	 */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9880,  3, 5, { 0x05, 0x0c, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-64 屢	# [cjk]	[2000]	 */
{ 0x9881,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-65 層	# CJK COMPATIBILITY IDEOGRAPH-FA3B	[2000]	[Unicode3.2] */
{ 0x9882,  3, 5, { 0x0f, 0x0a, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-66 屮	# CJK COMPATIBILITY IDEOGRAPH-FA3C	[2000]	[Unicode3.2] */
{ 0x9883,  3, 7, { 0x00, 0x02, 0x01, 0x01, 0x02, 0x02, 0x34, 0x00, 0x00, 0x00 }	},	/* 1-47-67 𡚴	# [cjk]	[2000]	[Unicode3.1] */
{ 0x9884,  3, 5, { 0x05, 0x0c, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-68 屺	# [cjk]	[2000]	 */
{ 0x9885,  3, 5, { 0x05, 0x0c, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-69 岏	# [cjk]	[2000]	 */
{ 0x9886,  3, 5, { 0x05, 0x0c, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-70 岟	# [cjk]	[2000]	 */
{ 0x9887,  3, 5, { 0x05, 0x0c, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-71 岣	# [cjk]	[2000]	 */
{ 0x9888,  3, 5, { 0x05, 0x0c, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-72 岪	# [cjk]	[2000]	 */
{ 0x9889,  3, 5, { 0x05, 0x0c, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-73 岺	# [cjk]	[2000]	 */
{ 0x988A,  3, 5, { 0x05, 0x0c, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-74 峋	# [cjk]	[2000]	 */
{ 0x988B,  3, 5, { 0x05, 0x0c, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-75 峐	# [cjk]	[2000]	 */
{ 0x988C,  3, 5, { 0x05, 0x0c, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-76 峒	# [cjk]	[2000]	 */
{ 0x988D,  3, 5, { 0x05, 0x0c, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-77 峴	# [cjk]	[2000]	 */
{ 0x988E,  3, 7, { 0x00, 0x02, 0x01, 0x03, 0x02, 0x00, 0x34, 0x00, 0x00, 0x00 }	},	/* 1-47-78 𡸴	# [cjk]	[2000]	[Unicode3.1] */
{ 0x988F,  3, 5, { 0x03, 0x07, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-79 㟢	# [cjk]	[2000]	 */
{ 0x9890,  3, 5, { 0x05, 0x0d, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-80 崍	# [cjk]	[2000]	 */
{ 0x9891,  3, 5, { 0x05, 0x0d, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-81 崧	# [cjk]	[2000]	 */
{ 0x9892,  3, 5, { 0x0f, 0x0a, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-82 﨑	# CJK COMPATIBILITY IDEOGRAPH-FA11	[2000]	 */
{ 0x9893,  3, 5, { 0x05, 0x0d, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-83 嵆	# [cjk]	[2000]	 */
{ 0x9894,  3, 5, { 0x05, 0x0d, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-84 嵇	# [cjk]	[2000]	 */
{ 0x9895,  3, 5, { 0x05, 0x0d, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-85 嵓	# [cjk]	[2000]	 */
{ 0x9896,  3, 5, { 0x05, 0x0d, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-86 嵊	# [cjk]	[2000] */
{ 0x9897,  3, 5, { 0x05, 0x0d, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-87 嵭	# [cjk]	[2000] */
{ 0x9898,  3, 5, { 0x05, 0x0d, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-88 嶁	# [cjk]	[2000] */
{ 0x9899,  3, 5, { 0x05, 0x0d, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-89 嶠	# [cjk]	[2000] */
{ 0x989A,  3, 5, { 0x05, 0x0d, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-90 嶤	# [cjk]	[2000] */
{ 0x989B,  3, 5, { 0x05, 0x0d, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-91 嶧	# [cjk]	[2000] */
{ 0x989C,  3, 5, { 0x05, 0x0d, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-92 嶸	# [cjk]	[2000] */
{ 0x989D,  3, 5, { 0x05, 0x0d, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-93 巋	# [cjk]	[2000] */
{ 0x989E,  3, 5, { 0x05, 0x04, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-47-94 吞	# [cjk]	[2004] */
{ 0x989F,  2, 5, { 0x05, 0x0f, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-01 弌	# [cjk]	 */
{ 0x98A0,  2, 5, { 0x04, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-02 丐	# [cjk]	 */
{ 0x98A1,  2, 5, { 0x04, 0x0e, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-03 丕	# [cjk]	 */
{ 0x98A2,  2, 5, { 0x04, 0x0e, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-04 个	# [cjk]	 */
{ 0x98A3,  2, 5, { 0x04, 0x0e, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-05 丱	# [cjk]	 */
{ 0x98A4,  2, 5, { 0x04, 0x0e, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-06 丶	# [cjk]	 */
{ 0x98A5,  2, 5, { 0x04, 0x0e, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-07 丼	# [cjk]	 */
{ 0x98A6,  2, 5, { 0x04, 0x0e, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-08 丿	# [cjk] */
{ 0x98A7,  2, 5, { 0x04, 0x0e, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-09 乂	# [cjk] */
{ 0x98A8,  2, 5, { 0x04, 0x0e, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-10 乖	# [cjk] */
{ 0x98A9,  2, 5, { 0x04, 0x0e, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-11 乘	# [cjk] */
{ 0x98AA,  2, 5, { 0x04, 0x0e, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-12 亂	# [cjk] */
{ 0x98AB,  2, 5, { 0x04, 0x0e, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-13 亅	# [cjk] */
{ 0x98AC,  2, 5, { 0x08, 0x0c, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-14 豫	# [cjk] */
{ 0x98AD,  2, 5, { 0x04, 0x0e, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-15 亊	# [cjk] */
{ 0x98AE,  2, 5, { 0x08, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-16 舒	# [cjk] */
{ 0x98AF,  2, 5, { 0x05, 0x0f, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-17 弍	# [cjk] */
{ 0x98B0,  2, 5, { 0x04, 0x0e, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-18 于	# [cjk] */
{ 0x98B1,  2, 5, { 0x04, 0x0e, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-19 亞	# [cjk] */
{ 0x98B2,  2, 5, { 0x04, 0x0e, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-20 亟	# [cjk] */
{ 0x98B3,  2, 5, { 0x04, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-21 亠	# [cjk] */
{ 0x98B4,  2, 5, { 0x04, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-22 亢	# [cjk] */
{ 0x98B5,  2, 5, { 0x04, 0x0e, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-23 亰	# [cjk] */
{ 0x98B6,  2, 5, { 0x04, 0x0e, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-24 亳	# [cjk] */
{ 0x98B7,  2, 5, { 0x04, 0x0e, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-25 亶	# [cjk] */
{ 0x98B8,  2, 5, { 0x04, 0x0e, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-26 从	# [cjk] */
{ 0x98B9,  2, 5, { 0x04, 0x0e, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-27 仍	# [cjk] */
{ 0x98BA,  2, 5, { 0x04, 0x0e, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-28 仄	# [cjk] */
{ 0x98BB,  2, 5, { 0x04, 0x0e, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-29 仆	# [cjk] */
{ 0x98BC,  2, 5, { 0x04, 0x0e, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-30 仂	# [cjk] */
{ 0x98BD,  2, 5, { 0x04, 0x0e, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-31 仗	# [cjk] */
{ 0x98BE,  2, 5, { 0x04, 0x0e, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-32 仞	# [cjk] */
{ 0x98BF,  2, 5, { 0x04, 0x0e, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-33 仭	# [cjk] */
{ 0x98C0,  2, 5, { 0x04, 0x0e, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-34 仟	# [cjk] */
{ 0x98C1,  2, 5, { 0x04, 0x0e, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-35 价	# [cjk] */
{ 0x98C2,  2, 5, { 0x04, 0x0f, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-36 伉	# [cjk] */
{ 0x98C3,  2, 5, { 0x04, 0x0f, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-37 佚	# [cjk] */
{ 0x98C4,  2, 5, { 0x04, 0x0f, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-38 估	# [cjk] */
{ 0x98C5,  2, 5, { 0x04, 0x0f, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-39 佛	# [cjk] */
{ 0x98C6,  2, 5, { 0x04, 0x0f, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-40 佝	# [cjk] */
{ 0x98C7,  2, 5, { 0x04, 0x0f, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-41 佗	# [cjk] */
{ 0x98C8,  2, 5, { 0x04, 0x0f, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-42 佇	# [cjk] */
{ 0x98C9,  2, 5, { 0x04, 0x0f, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-43 佶	# [cjk] */
{ 0x98CA,  2, 5, { 0x04, 0x0f, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-44 侈	# [cjk] */
{ 0x98CB,  2, 5, { 0x04, 0x0f, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-45 侏	# [cjk] */
{ 0x98CC,  2, 5, { 0x04, 0x0f, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-46 侘	# [cjk] */
{ 0x98CD,  2, 5, { 0x04, 0x0f, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-47 佻	# [cjk] */
{ 0x98CE,  2, 5, { 0x04, 0x0f, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-48 佩	# [cjk] */
{ 0x98CF,  2, 5, { 0x04, 0x0f, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-49 佰	# [cjk] */
{ 0x98D0,  2, 5, { 0x04, 0x0f, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-50 侑	# [cjk] */
{ 0x98D1,  2, 5, { 0x04, 0x0f, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-51 佯	# [cjk] */
{ 0x98D2,  2, 5, { 0x04, 0x0f, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-52 來	# [cjk] */
{ 0x98D3,  2, 5, { 0x04, 0x0f, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-53 侖	# [cjk] */
{ 0x98D4,  2, 5, { 0x05, 0x01, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-54 儘	# [cjk] */
{ 0x98D5,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-55 俔	# [cjk] */
{ 0x98D6,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-56 俟	# [cjk] */
{ 0x98D7,  2, 5, { 0x04, 0x0f, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-57 俎	# [cjk] */
{ 0x98D8,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-58 俘	# [cjk] */
{ 0x98D9,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-59 俛	# [cjk] */
{ 0x98DA,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-60 俑	# [cjk] */
{ 0x98DB,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-61 俚	# [cjk] */
{ 0x98DC,  2, 5, { 0x04, 0x0f, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-62 俐	# [cjk] */
{ 0x98DD,  2, 5, { 0x04, 0x0f, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-63 俤	# [cjk] */
{ 0x98DE,  2, 5, { 0x04, 0x0f, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-64 俥	# [cjk] */
{ 0x98DF,  2, 5, { 0x05, 0x00, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-65 倚	# [cjk] */
{ 0x98E0,  2, 5, { 0x05, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-66 倨	# [cjk] */
{ 0x98E1,  2, 5, { 0x05, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-67 倔	# [cjk] */
{ 0x98E2,  2, 5, { 0x05, 0x00, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-68 倪	# [cjk] */
{ 0x98E3,  2, 5, { 0x05, 0x00, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-69 倥	# [cjk] */
{ 0x98E4,  2, 5, { 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-70 倅	# [cjk] */
{ 0x98E5,  2, 5, { 0x04, 0x0f, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-71 伜	# [cjk] */
{ 0x98E6,  2, 5, { 0x04, 0x0f, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-72 俶	# [cjk] */
{ 0x98E7,  2, 5, { 0x05, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-73 倡	# [cjk] */
{ 0x98E8,  2, 5, { 0x05, 0x00, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-74 倩	# [cjk] */
{ 0x98E9,  2, 5, { 0x05, 0x00, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-75 倬	# [cjk] */
{ 0x98EA,  2, 5, { 0x04, 0x0f, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-76 俾	# [cjk] */
{ 0x98EB,  2, 5, { 0x04, 0x0f, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-77 俯	# [cjk] */
{ 0x98EC,  2, 5, { 0x05, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-78 們	# [cjk] */
{ 0x98ED,  2, 5, { 0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-79 倆	# [cjk] */
{ 0x98EE,  2, 5, { 0x05, 0x00, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-80 偃	# [cjk] */
{ 0x98EF,  2, 5, { 0x05, 0x00, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-81 假	# [cjk] */
{ 0x98F0,  2, 5, { 0x06, 0x07, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-82 會	# [cjk] */
{ 0x98F1,  2, 5, { 0x05, 0x00, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-83 偕	# [cjk] */
{ 0x98F2,  2, 5, { 0x05, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-84 偐	# [cjk] */
{ 0x98F3,  2, 5, { 0x05, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-85 偈	# [cjk] */
{ 0x98F4,  2, 5, { 0x05, 0x00, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-86 做	# [cjk] */
{ 0x98F5,  2, 5, { 0x05, 0x00, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-87 偖	# [cjk] */
{ 0x98F6,  2, 5, { 0x05, 0x00, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-88 偬	# [cjk] */
{ 0x98F7,  2, 5, { 0x05, 0x00, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-89 偸	# [cjk] */
{ 0x98F8,  2, 5, { 0x05, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-90 傀	# [cjk] */
{ 0x98F9,  2, 5, { 0x05, 0x00, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-91 傚	# [cjk] */
{ 0x98FA,  2, 5, { 0x05, 0x00, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-92 傅	# [cjk] */
{ 0x98FB,  2, 5, { 0x05, 0x00, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-93 傴	# [cjk] */
{ 0x98FC,  2, 5, { 0x05, 0x00, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-48-94 傲	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9940,  2, 5, { 0x05, 0x00, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-01 僉	# [cjk] */
{ 0x9941,  2, 5, { 0x05, 0x00, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-02 僊	# [cjk] */
{ 0x9942,  2, 5, { 0x05, 0x00, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-03 傳	# [cjk] */
{ 0x9943,  2, 5, { 0x05, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-04 僂	# [cjk] */
{ 0x9944,  2, 5, { 0x05, 0x00, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-05 僖	# [cjk] */
{ 0x9945,  2, 5, { 0x05, 0x00, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-06 僞	# [cjk] */
{ 0x9946,  2, 5, { 0x05, 0x00, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-07 僥	# [cjk] */
{ 0x9947,  2, 5, { 0x05, 0x00, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-08 僭	# [cjk] */
{ 0x9948,  2, 5, { 0x05, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-09 僣	# [cjk] */
{ 0x9949,  2, 5, { 0x05, 0x00, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-10 僮	# [cjk] */
{ 0x994A,  2, 5, { 0x05, 0x00, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-11 價	# [cjk] */
{ 0x994B,  2, 5, { 0x05, 0x00, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-12 僵	# [cjk] */
{ 0x994C,  2, 5, { 0x05, 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-13 儉	# [cjk] */
{ 0x994D,  2, 5, { 0x05, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-14 儁	# [cjk] */
{ 0x994E,  2, 5, { 0x05, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-15 儂	# [cjk] */
{ 0x994F,  2, 5, { 0x05, 0x01, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-16 儖	# [cjk] */
{ 0x9950,  2, 5, { 0x05, 0x01, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-17 儕	# [cjk] */
{ 0x9951,  2, 5, { 0x05, 0x01, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-18 儔	# [cjk] */
{ 0x9952,  2, 5, { 0x05, 0x01, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-19 儚	# [cjk] */
{ 0x9953,  2, 5, { 0x05, 0x01, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-20 儡	# [cjk] */
{ 0x9954,  2, 5, { 0x05, 0x01, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-21 儺	# [cjk] */
{ 0x9955,  2, 5, { 0x05, 0x01, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-22 儷	# [cjk] */
{ 0x9956,  2, 5, { 0x05, 0x01, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-23 儼	# [cjk] */
{ 0x9957,  2, 5, { 0x05, 0x01, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-24 儻	# [cjk] */
{ 0x9958,  2, 5, { 0x05, 0x01, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-25 儿	# [cjk] */
{ 0x9959,  2, 5, { 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-26 兀	# [cjk] */
{ 0x995A,  2, 5, { 0x05, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-27 兒	# [cjk] */
{ 0x995B,  2, 5, { 0x05, 0x01, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-28 兌	# [cjk] */
{ 0x995C,  2, 5, { 0x05, 0x01, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-29 兔	# [cjk] */
{ 0x995D,  2, 5, { 0x05, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-30 兢	# [cjk] */
{ 0x995E,  2, 5, { 0x07, 0x0a, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-31 竸	# [cjk] */
{ 0x995F,  2, 5, { 0x05, 0x01, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-32 兩	# [cjk] */
{ 0x9960,  2, 5, { 0x05, 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-33 兪	# [cjk] */
{ 0x9961,  2, 5, { 0x05, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-34 兮	# [cjk] */
{ 0x9962,  2, 5, { 0x05, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-35 冀	# [cjk] */
{ 0x9963,  2, 5, { 0x05, 0x01, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-36 冂	# [cjk] */
{ 0x9964,  2, 5, { 0x05, 0x06, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-37 囘	# [cjk] */
{ 0x9965,  2, 5, { 0x05, 0x01, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-38 册	# [cjk] */
{ 0x9966,  2, 5, { 0x05, 0x01, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-39 冉	# [cjk] */
{ 0x9967,  2, 5, { 0x05, 0x01, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-40 冏	# [cjk] */
{ 0x9968,  2, 5, { 0x05, 0x01, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-41 冑	# [cjk] */
{ 0x9969,  2, 5, { 0x05, 0x01, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-42 冓	# [cjk] */
{ 0x996A,  2, 5, { 0x05, 0x01, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-43 冕	# [cjk] */
{ 0x996B,  2, 5, { 0x05, 0x01, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-44 冖	# [cjk] */
{ 0x996C,  2, 5, { 0x05, 0x01, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-45 冤	# [cjk] */
{ 0x996D,  2, 5, { 0x05, 0x01, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-46 冦	# [cjk] */
{ 0x996E,  2, 5, { 0x05, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-47 冢	# [cjk] */
{ 0x996F,  2, 5, { 0x05, 0x01, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-48 冩	# [cjk] */
{ 0x9970,  2, 5, { 0x05, 0x01, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-49 冪	# [cjk] */
{ 0x9971,  2, 5, { 0x05, 0x01, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-50 冫	# [cjk] */
{ 0x9972,  2, 5, { 0x05, 0x01, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-51 决	# [cjk] */
{ 0x9973,  2, 5, { 0x05, 0x01, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-52 冱	# [cjk] */
{ 0x9974,  2, 5, { 0x05, 0x01, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-53 冲	# [cjk] */
{ 0x9975,  2, 5, { 0x05, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-54 冰	# [cjk] */
{ 0x9976,  2, 5, { 0x05, 0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-55 况	# [cjk] */
{ 0x9977,  2, 5, { 0x05, 0x01, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-56 冽	# [cjk] */
{ 0x9978,  2, 5, { 0x05, 0x01, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-57 凅	# [cjk] */
{ 0x9979,  2, 5, { 0x05, 0x01, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-58 凉	# [cjk] */
{ 0x997A,  2, 5, { 0x05, 0x01, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-59 凛	# [cjk] */
{ 0x997B,  2, 5, { 0x05, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-60 几	# [cjk] */
{ 0x997C,  2, 5, { 0x08, 0x06, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-61 處	# [cjk] */
{ 0x997D,  2, 5, { 0x05, 0x01, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-62 凩	# [cjk] */
{ 0x997E,  2, 5, { 0x05, 0x01, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-63 凭	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9980,  2, 5, { 0x05, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-64 凰	# [cjk] */
{ 0x9981,  2, 5, { 0x05, 0x01, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-65 凵	# [cjk] */
{ 0x9982,  2, 5, { 0x05, 0x01, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-66 凾	# [cjk] */
{ 0x9983,  2, 5, { 0x05, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-67 刄	# [cjk] */
{ 0x9984,  2, 5, { 0x05, 0x02, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-68 刋	# [cjk] */
{ 0x9985,  2, 5, { 0x05, 0x02, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-69 刔	# [cjk] */
{ 0x9986,  2, 5, { 0x05, 0x02, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-70 刎	# [cjk] */
{ 0x9987,  2, 5, { 0x05, 0x02, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-71 刧	# [cjk] */
{ 0x9988,  2, 5, { 0x05, 0x02, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-72 刪	# [cjk] */
{ 0x9989,  2, 5, { 0x05, 0x02, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-73 刮	# [cjk] */
{ 0x998A,  2, 5, { 0x05, 0x02, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-74 刳	# [cjk] */
{ 0x998B,  2, 5, { 0x05, 0x02, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-75 刹	# [cjk] */
{ 0x998C,  2, 5, { 0x05, 0x02, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-76 剏	# [cjk] */
{ 0x998D,  2, 5, { 0x05, 0x02, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-77 剄	# [cjk] */
{ 0x998E,  2, 5, { 0x05, 0x02, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-78 剋	# [cjk] */
{ 0x998F,  2, 5, { 0x05, 0x02, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-79 剌	# [cjk] */
{ 0x9990,  2, 5, { 0x05, 0x02, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-80 剞	# [cjk] */
{ 0x9991,  2, 5, { 0x05, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-81 剔	# [cjk] */
{ 0x9992,  2, 5, { 0x05, 0x02, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-82 剪	# [cjk] */
{ 0x9993,  2, 5, { 0x05, 0x02, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-83 剴	# [cjk] */
{ 0x9994,  2, 5, { 0x05, 0x02, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-84 剩	# [cjk] */
{ 0x9995,  2, 5, { 0x05, 0x02, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-85 剳	# [cjk] */
{ 0x9996,  2, 5, { 0x05, 0x02, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-86 剿	# [cjk] */
{ 0x9997,  2, 5, { 0x05, 0x02, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-87 剽	# [cjk] */
{ 0x9998,  2, 5, { 0x05, 0x02, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-88 劍	# [cjk] */
{ 0x9999,  2, 5, { 0x05, 0x02, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-89 劔	# [cjk] */
{ 0x999A,  2, 5, { 0x05, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-90 劒	# [cjk] */
{ 0x999B,  2, 5, { 0x05, 0x02, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-91 剱	# [cjk] */
{ 0x999C,  2, 5, { 0x05, 0x02, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-92 劈	# [cjk] */
{ 0x999D,  2, 5, { 0x05, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-93 劑	# [cjk] */
{ 0x999E,  2, 5, { 0x08, 0x0f, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-49-94 辨	# [cjk] */
{ 0x999F,  2, 5, { 0x08, 0x0f, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-01 辧	# [cjk] */
{ 0x99A0,  2, 5, { 0x05, 0x02, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-02 劬	# [cjk] */
{ 0x99A1,  2, 5, { 0x05, 0x02, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-03 劭	# [cjk] */
{ 0x99A2,  2, 5, { 0x05, 0x02, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-04 劼	# [cjk] */
{ 0x99A3,  2, 5, { 0x05, 0x02, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-05 劵	# [cjk] */
{ 0x99A4,  2, 5, { 0x05, 0x02, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-06 勁	# [cjk] */
{ 0x99A5,  2, 5, { 0x05, 0x02, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-07 勍	# [cjk] */
{ 0x99A6,  2, 5, { 0x05, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-08 勗	# [cjk] */
{ 0x99A7,  2, 5, { 0x05, 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-09 勞	# [cjk] */
{ 0x99A8,  2, 5, { 0x05, 0x02, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-10 勣	# [cjk] */
{ 0x99A9,  2, 5, { 0x05, 0x02, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-11 勦	# [cjk] */
{ 0x99AA,  2, 5, { 0x09, 0x08, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-12 飭	# [cjk] */
{ 0x99AB,  2, 5, { 0x05, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-13 勠	# [cjk] */
{ 0x99AC,  2, 5, { 0x05, 0x02, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-14 勳	# [cjk] */
{ 0x99AD,  2, 5, { 0x05, 0x02, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-15 勵	# [cjk] */
{ 0x99AE,  2, 5, { 0x05, 0x02, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-16 勸	# [cjk] */
{ 0x99AF,  2, 5, { 0x05, 0x02, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-17 勹	# [cjk] */
{ 0x99B0,  2, 5, { 0x05, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-18 匆	# [cjk] */
{ 0x99B1,  2, 5, { 0x05, 0x03, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-19 匈	# [cjk] */
{ 0x99B2,  2, 5, { 0x07, 0x05, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-20 甸	# [cjk] */
{ 0x99B3,  2, 5, { 0x05, 0x03, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-21 匍	# [cjk] */
{ 0x99B4,  2, 5, { 0x05, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-22 匐	# [cjk] */
{ 0x99B5,  2, 5, { 0x05, 0x03, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-23 匏	# [cjk] */
{ 0x99B6,  2, 5, { 0x05, 0x03, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-24 匕	# [cjk] */
{ 0x99B7,  2, 5, { 0x05, 0x03, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-25 匚	# [cjk] */
{ 0x99B8,  2, 5, { 0x05, 0x03, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-26 匣	# [cjk] */
{ 0x99B9,  2, 5, { 0x05, 0x03, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-27 匯	# [cjk] */
{ 0x99BA,  2, 5, { 0x05, 0x03, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-28 匱	# [cjk] */
{ 0x99BB,  2, 5, { 0x05, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-29 匳	# [cjk] */
{ 0x99BC,  2, 5, { 0x05, 0x03, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-30 匸	# [cjk] */
{ 0x99BD,  2, 5, { 0x05, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-31 區	# [cjk] */
{ 0x99BE,  2, 5, { 0x05, 0x03, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-32 卆	# [cjk] */
{ 0x99BF,  2, 5, { 0x05, 0x03, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-33 卅	# [cjk] */
{ 0x99C0,  2, 5, { 0x04, 0x0e, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-34 丗	# [cjk] */
{ 0x99C1,  2, 5, { 0x05, 0x03, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-35 卉	# [cjk] */
{ 0x99C2,  2, 5, { 0x05, 0x03, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-36 卍	# [cjk] */
{ 0x99C3,  2, 5, { 0x05, 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-37 凖	# [cjk] */
{ 0x99C4,  2, 5, { 0x05, 0x03, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-38 卞	# [cjk] */
{ 0x99C5,  2, 5, { 0x05, 0x03, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-39 卩	# [cjk] */
{ 0x99C6,  2, 5, { 0x05, 0x03, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-40 卮	# [cjk] */
{ 0x99C7,  2, 5, { 0x05, 0x09, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-41 夘	# [cjk] */
{ 0x99C8,  2, 5, { 0x05, 0x03, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-42 卻	# [cjk] */
{ 0x99C9,  2, 5, { 0x05, 0x03, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-43 卷	# [cjk] */
{ 0x99CA,  2, 5, { 0x05, 0x03, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-44 厂	# [cjk] */
{ 0x99CB,  2, 5, { 0x05, 0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-45 厖	# [cjk] */
{ 0x99CC,  2, 5, { 0x05, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-46 厠	# [cjk] */
{ 0x99CD,  2, 5, { 0x05, 0x03, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-47 厦	# [cjk] */
{ 0x99CE,  2, 5, { 0x05, 0x03, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-48 厥	# [cjk] */
{ 0x99CF,  2, 5, { 0x05, 0x03, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-49 厮	# [cjk] */
{ 0x99D0,  2, 5, { 0x05, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-50 厰	# [cjk] */
{ 0x99D1,  2, 5, { 0x05, 0x03, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-51 厶	# [cjk] */
{ 0x99D2,  2, 5, { 0x05, 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-52 參	# [cjk] */
{ 0x99D3,  2, 5, { 0x07, 0x0c, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-53 簒	# [cjk] */
{ 0x99D4,  2, 5, { 0x09, 0x06, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-54 雙	# [cjk] */
{ 0x99D5,  2, 5, { 0x05, 0x03, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-55 叟	# [cjk] */
{ 0x99D6,  2, 5, { 0x06, 0x06, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-56 曼	# [cjk] */
{ 0x99D7,  2, 5, { 0x07, 0x01, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-57 燮	# [cjk] */
{ 0x99D8,  2, 5, { 0x05, 0x03, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-58 叮	# [cjk] */
{ 0x99D9,  2, 5, { 0x05, 0x03, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-59 叨	# [cjk] */
{ 0x99DA,  2, 5, { 0x05, 0x03, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-60 叭	# [cjk] */
{ 0x99DB,  2, 5, { 0x05, 0x03, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-61 叺	# [cjk] */
{ 0x99DC,  2, 5, { 0x05, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-62 吁	# [cjk] */
{ 0x99DD,  2, 5, { 0x05, 0x04, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-63 吽	# [cjk] */
{ 0x99DE,  2, 5, { 0x05, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-64 呀	# [cjk] */
{ 0x99DF,  2, 5, { 0x05, 0x04, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-65 听	# [cjk] */
{ 0x99E0,  2, 5, { 0x05, 0x04, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-66 吭	# [cjk] */
{ 0x99E1,  2, 5, { 0x05, 0x04, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-67 吼	# [cjk] */
{ 0x99E2,  2, 5, { 0x05, 0x04, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-68 吮	# [cjk] */
{ 0x99E3,  2, 5, { 0x05, 0x04, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-69 吶	# [cjk] */
{ 0x99E4,  2, 5, { 0x05, 0x04, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-70 吩	# [cjk] */
{ 0x99E5,  2, 5, { 0x05, 0x04, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-71 吝	# [cjk] */
{ 0x99E6,  2, 5, { 0x05, 0x04, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-72 呎	# [cjk] */
{ 0x99E7,  2, 5, { 0x05, 0x04, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-73 咏	# [cjk] */
{ 0x99E8,  2, 5, { 0x05, 0x04, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-74 呵	# [cjk] */
{ 0x99E9,  2, 5, { 0x05, 0x04, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-75 咎	# [cjk] */
{ 0x99EA,  2, 5, { 0x05, 0x04, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-76 呟	# [cjk] */
{ 0x99EB,  2, 5, { 0x05, 0x04, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-77 呱	# [cjk] */
{ 0x99EC,  2, 5, { 0x05, 0x04, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-78 呷	# [cjk] */
{ 0x99ED,  2, 5, { 0x05, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-79 呰	# [cjk] */
{ 0x99EE,  2, 5, { 0x05, 0x04, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-80 咒	# [cjk] */
{ 0x99EF,  2, 5, { 0x05, 0x04, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-81 呻	# [cjk] */
{ 0x99F0,  2, 5, { 0x05, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-82 咀	# [cjk] */
{ 0x99F1,  2, 5, { 0x05, 0x04, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-83 呶	# [cjk] */
{ 0x99F2,  2, 5, { 0x05, 0x04, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-84 咄	# [cjk] */
{ 0x99F3,  2, 5, { 0x05, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-85 咐	# [cjk] */
{ 0x99F4,  2, 5, { 0x05, 0x04, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-86 咆	# [cjk] */
{ 0x99F5,  2, 5, { 0x05, 0x04, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-87 哇	# [cjk] */
{ 0x99F6,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-88 咢	# [cjk] */
{ 0x99F7,  2, 5, { 0x05, 0x04, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-89 咸	# [cjk] */
{ 0x99F8,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-90 咥	# [cjk] */
{ 0x99F9,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-91 咬	# [cjk] */
{ 0x99FA,  2, 5, { 0x05, 0x04, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-92 哄	# [cjk] */
{ 0x99FB,  2, 5, { 0x05, 0x04, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-93 哈	# [cjk] */
{ 0x99FC,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-50-94 咨	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9A40,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-01 咫	# [cjk] */
{ 0x9A41,  2, 5, { 0x05, 0x04, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-02 哂	# [cjk] */
{ 0x9A42,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-03 咤	# [cjk] */
{ 0x9A43,  2, 5, { 0x05, 0x04, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-04 咾	# [cjk] */
{ 0x9A44,  2, 5, { 0x05, 0x04, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-05 咼	# [cjk] */
{ 0x9A45,  2, 5, { 0x05, 0x04, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-06 哘	# [cjk] */
{ 0x9A46,  2, 5, { 0x05, 0x04, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-07 哥	# [cjk] */
{ 0x9A47,  2, 5, { 0x05, 0x04, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-08 哦	# [cjk] */
{ 0x9A48,  2, 5, { 0x05, 0x05, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-09 唏	# [cjk] */
{ 0x9A49,  2, 5, { 0x05, 0x05, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-10 唔	# [cjk] */
{ 0x9A4A,  2, 5, { 0x05, 0x04, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-11 哽	# [cjk] */
{ 0x9A4B,  2, 5, { 0x05, 0x04, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-12 哮	# [cjk] */
{ 0x9A4C,  2, 5, { 0x05, 0x04, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-13 哭	# [cjk] */
{ 0x9A4D,  2, 5, { 0x05, 0x04, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-14 哺	# [cjk] */
{ 0x9A4E,  2, 5, { 0x05, 0x04, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-15 哢	# [cjk] */
{ 0x9A4F,  2, 5, { 0x05, 0x05, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-16 唹	# [cjk] */
{ 0x9A50,  2, 5, { 0x05, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-17 啀	# [cjk] */
{ 0x9A51,  2, 5, { 0x05, 0x05, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-18 啣	# [cjk] */
{ 0x9A52,  2, 5, { 0x05, 0x05, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-19 啌	# [cjk] */
{ 0x9A53,  2, 5, { 0x05, 0x05, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-20 售	# [cjk] */
{ 0x9A54,  2, 5, { 0x05, 0x05, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-21 啜	# [cjk] */
{ 0x9A55,  2, 5, { 0x05, 0x05, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-22 啅	# [cjk] */
{ 0x9A56,  2, 5, { 0x05, 0x05, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-23 啖	# [cjk] */
{ 0x9A57,  2, 5, { 0x05, 0x05, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-24 啗	# [cjk] */
{ 0x9A58,  2, 5, { 0x05, 0x05, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-25 唸	# [cjk] */
{ 0x9A59,  2, 5, { 0x05, 0x05, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-26 唳	# [cjk] */
{ 0x9A5A,  2, 5, { 0x05, 0x05, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-27 啝	# [cjk] */
{ 0x9A5B,  2, 5, { 0x05, 0x05, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-28 喙	# [cjk] */
{ 0x9A5C,  2, 5, { 0x05, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-29 喀	# [cjk] */
{ 0x9A5D,  2, 5, { 0x05, 0x04, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-30 咯	# [cjk] */
{ 0x9A5E,  2, 5, { 0x05, 0x05, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-31 喊	# [cjk] */
{ 0x9A5F,  2, 5, { 0x05, 0x05, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-32 喟	# [cjk] */
{ 0x9A60,  2, 5, { 0x05, 0x05, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-33 啻	# [cjk] */
{ 0x9A61,  2, 5, { 0x05, 0x05, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-34 啾	# [cjk] */
{ 0x9A62,  2, 5, { 0x05, 0x05, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-35 喘	# [cjk] */
{ 0x9A63,  2, 5, { 0x05, 0x05, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-36 喞	# [cjk] */
{ 0x9A64,  2, 5, { 0x05, 0x05, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-37 單	# [cjk] */
{ 0x9A65,  2, 5, { 0x05, 0x05, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-38 啼	# [cjk] */
{ 0x9A66,  2, 5, { 0x05, 0x05, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-39 喃	# [cjk] */
{ 0x9A67,  2, 5, { 0x05, 0x05, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-40 喩	# [cjk] */
{ 0x9A68,  2, 5, { 0x05, 0x05, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-41 喇	# [cjk] */
{ 0x9A69,  2, 5, { 0x05, 0x05, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-42 喨	# [cjk] */
{ 0x9A6A,  2, 5, { 0x05, 0x05, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-43 嗚	# [cjk] */
{ 0x9A6B,  2, 5, { 0x05, 0x05, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-44 嗅	# [cjk] */
{ 0x9A6C,  2, 5, { 0x05, 0x05, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-45 嗟	# [cjk] */
{ 0x9A6D,  2, 5, { 0x05, 0x05, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-46 嗄	# [cjk] */
{ 0x9A6E,  2, 5, { 0x05, 0x05, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-47 嗜	# [cjk] */
{ 0x9A6F,  2, 5, { 0x05, 0x05, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-48 嗤	# [cjk] */
{ 0x9A70,  2, 5, { 0x05, 0x05, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-49 嗔	# [cjk] */
{ 0x9A71,  2, 5, { 0x05, 0x06, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-50 嘔	# [cjk] */
{ 0x9A72,  2, 5, { 0x05, 0x05, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-51 嗷	# [cjk] */
{ 0x9A73,  2, 5, { 0x05, 0x06, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-52 嘖	# [cjk] */
{ 0x9A74,  2, 5, { 0x05, 0x05, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-53 嗾	# [cjk] */
{ 0x9A75,  2, 5, { 0x05, 0x05, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-54 嗽	# [cjk] */
{ 0x9A76,  2, 5, { 0x05, 0x06, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-55 嘛	# [cjk] */
{ 0x9A77,  2, 5, { 0x05, 0x05, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-56 嗹	# [cjk] */
{ 0x9A78,  2, 5, { 0x05, 0x06, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-57 噎	# [cjk] */
{ 0x9A79,  2, 5, { 0x05, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-58 噐	# [cjk] */
{ 0x9A7A,  2, 5, { 0x07, 0x01, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-59 營	# [cjk] */
{ 0x9A7B,  2, 5, { 0x05, 0x06, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-60 嘴	# [cjk] */
{ 0x9A7C,  2, 5, { 0x05, 0x06, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-61 嘶	# [cjk] */
{ 0x9A7D,  2, 5, { 0x05, 0x06, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-62 嘲	# [cjk] */
{ 0x9A7E,  2, 5, { 0x05, 0x06, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-63 嘸	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9A80,  2, 5, { 0x05, 0x06, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-64 噫	# [cjk] */
{ 0x9A81,  2, 5, { 0x05, 0x06, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-65 噤	# [cjk] */
{ 0x9A82,  2, 5, { 0x05, 0x06, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-66 嘯	# [cjk] */
{ 0x9A83,  2, 5, { 0x05, 0x06, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-67 噬	# [cjk] */
{ 0x9A84,  2, 5, { 0x05, 0x06, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-68 噪	# [cjk] */
{ 0x9A85,  2, 5, { 0x05, 0x06, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-69 嚆	# [cjk] */
{ 0x9A86,  2, 5, { 0x05, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-70 嚀	# [cjk] */
{ 0x9A87,  2, 5, { 0x05, 0x06, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-71 嚊	# [cjk] */
{ 0x9A88,  2, 5, { 0x05, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-72 嚠	# [cjk] */
{ 0x9A89,  2, 5, { 0x05, 0x06, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-73 嚔	# [cjk] */
{ 0x9A8A,  2, 5, { 0x05, 0x06, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-74 嚏	# [cjk] */
{ 0x9A8B,  2, 5, { 0x05, 0x06, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-75 嚥	# [cjk] */
{ 0x9A8C,  2, 5, { 0x05, 0x06, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-76 嚮	# [cjk] */
{ 0x9A8D,  2, 5, { 0x05, 0x06, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-77 嚶	# [cjk] */
{ 0x9A8E,  2, 5, { 0x05, 0x06, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-78 嚴	# [cjk] */
{ 0x9A8F,  2, 5, { 0x05, 0x06, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-79 囂	# [cjk] */
{ 0x9A90,  2, 5, { 0x05, 0x06, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-80 嚼	# [cjk] */
{ 0x9A91,  2, 5, { 0x05, 0x06, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-81 囁	# [cjk] */
{ 0x9A92,  2, 5, { 0x05, 0x06, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-82 囃	# [cjk] */
{ 0x9A93,  2, 5, { 0x05, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-83 囀	# [cjk] */
{ 0x9A94,  2, 5, { 0x05, 0x06, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-84 囈	# [cjk] */
{ 0x9A95,  2, 5, { 0x05, 0x06, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-85 囎	# [cjk] */
{ 0x9A96,  2, 5, { 0x05, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-86 囑	# [cjk] */
{ 0x9A97,  2, 5, { 0x05, 0x06, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-87 囓	# [cjk] */
{ 0x9A98,  2, 5, { 0x05, 0x06, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-88 囗	# [cjk] */
{ 0x9A99,  2, 5, { 0x05, 0x06, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-89 囮	# [cjk] */
{ 0x9A9A,  2, 5, { 0x05, 0x06, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-90 囹	# [cjk] */
{ 0x9A9B,  2, 5, { 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-91 圀	# [cjk] */
{ 0x9A9C,  2, 5, { 0x05, 0x06, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-92 囿	# [cjk] */
{ 0x9A9D,  2, 5, { 0x05, 0x07, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-93 圄	# [cjk] */
{ 0x9A9E,  2, 5, { 0x05, 0x07, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-51-94 圉	# [cjk] */
{ 0x9A9F,  2, 5, { 0x05, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-01 圈	# [cjk] */
{ 0x9AA0,  2, 5, { 0x05, 0x07, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-02 國	# [cjk] */
{ 0x9AA1,  2, 5, { 0x05, 0x07, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-03 圍	# [cjk] */
{ 0x9AA2,  2, 5, { 0x05, 0x07, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-04 圓	# [cjk] */
{ 0x9AA3,  2, 5, { 0x05, 0x07, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-05 團	# [cjk] */
{ 0x9AA4,  2, 5, { 0x05, 0x07, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-06 圖	# [cjk] */
{ 0x9AA5,  2, 5, { 0x05, 0x05, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-07 嗇	# [cjk] */
{ 0x9AA6,  2, 5, { 0x05, 0x07, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-08 圜	# [cjk] */
{ 0x9AA7,  2, 5, { 0x05, 0x07, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-09 圦	# [cjk] */
{ 0x9AA8,  2, 5, { 0x05, 0x07, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-10 圷	# [cjk] */
{ 0x9AA9,  2, 5, { 0x05, 0x07, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-11 圸	# [cjk] */
{ 0x9AAA,  2, 5, { 0x05, 0x07, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-12 坎	# [cjk] */
{ 0x9AAB,  2, 5, { 0x05, 0x07, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-13 圻	# [cjk] */
{ 0x9AAC,  2, 5, { 0x05, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-14 址	# [cjk] */
{ 0x9AAD,  2, 5, { 0x05, 0x07, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-15 坏	# [cjk] */
{ 0x9AAE,  2, 5, { 0x05, 0x07, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-16 坩	# [cjk] */
{ 0x9AAF,  2, 5, { 0x05, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-17 埀	# [cjk] */
{ 0x9AB0,  2, 5, { 0x05, 0x07, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-18 垈	# [cjk] */
{ 0x9AB1,  2, 5, { 0x05, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-19 坡	# [cjk] */
{ 0x9AB2,  2, 5, { 0x05, 0x07, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-20 坿	# [cjk] */
{ 0x9AB3,  2, 5, { 0x05, 0x07, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-21 垉	# [cjk] */
{ 0x9AB4,  2, 5, { 0x05, 0x07, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-22 垓	# [cjk] */
{ 0x9AB5,  2, 5, { 0x05, 0x07, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-23 垠	# [cjk] */
{ 0x9AB6,  2, 5, { 0x05, 0x07, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-24 垳	# [cjk] */
{ 0x9AB7,  2, 5, { 0x05, 0x07, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-25 垤	# [cjk] */
{ 0x9AB8,  2, 5, { 0x05, 0x07, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-26 垪	# [cjk] */
{ 0x9AB9,  2, 5, { 0x05, 0x07, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-27 垰	# [cjk] */
{ 0x9ABA,  2, 5, { 0x05, 0x07, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-28 埃	# [cjk] */
{ 0x9ABB,  2, 5, { 0x05, 0x07, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-29 埆	# [cjk] */
{ 0x9ABC,  2, 5, { 0x05, 0x07, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-30 埔	# [cjk] */
{ 0x9ABD,  2, 5, { 0x05, 0x07, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-31 埒	# [cjk] */
{ 0x9ABE,  2, 5, { 0x05, 0x07, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-32 埓	# [cjk] */
{ 0x9ABF,  2, 5, { 0x05, 0x08, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-33 堊	# [cjk] */
{ 0x9AC0,  2, 5, { 0x05, 0x07, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-34 埖	# [cjk] */
{ 0x9AC1,  2, 5, { 0x05, 0x07, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-35 埣	# [cjk] */
{ 0x9AC2,  2, 5, { 0x05, 0x08, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-36 堋	# [cjk] */
{ 0x9AC3,  2, 5, { 0x05, 0x08, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-37 堙	# [cjk] */
{ 0x9AC4,  2, 5, { 0x05, 0x08, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-38 堝	# [cjk] */
{ 0x9AC5,  2, 5, { 0x05, 0x08, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-39 塲	# [cjk] */
{ 0x9AC6,  2, 5, { 0x05, 0x08, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-40 堡	# [cjk] */
{ 0x9AC7,  2, 5, { 0x05, 0x08, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-41 塢	# [cjk] */
{ 0x9AC8,  2, 5, { 0x05, 0x08, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-42 塋	# [cjk] */
{ 0x9AC9,  2, 5, { 0x05, 0x08, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-43 塰	# [cjk] */
{ 0x9ACA,  2, 5, { 0x06, 0x0b, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-44 毀	# [cjk] */
{ 0x9ACB,  2, 5, { 0x05, 0x08, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-45 塒	# [cjk] */
{ 0x9ACC,  2, 5, { 0x05, 0x08, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-46 堽	# [cjk] */
{ 0x9ACD,  2, 5, { 0x05, 0x08, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-47 塹	# [cjk] */
{ 0x9ACE,  2, 5, { 0x05, 0x08, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-48 墅	# [cjk] */
{ 0x9ACF,  2, 5, { 0x05, 0x08, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-49 墹	# [cjk] */
{ 0x9AD0,  2, 5, { 0x05, 0x08, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-50 墟	# [cjk] */
{ 0x9AD1,  2, 5, { 0x05, 0x08, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-51 墫	# [cjk] */
{ 0x9AD2,  2, 5, { 0x05, 0x08, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-52 墺	# [cjk] */
{ 0x9AD3,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-53 壞	# [cjk] */
{ 0x9AD4,  2, 5, { 0x05, 0x08, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-54 墻	# [cjk] */
{ 0x9AD5,  2, 5, { 0x05, 0x08, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-55 墸	# [cjk] */
{ 0x9AD6,  2, 5, { 0x05, 0x08, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-56 墮	# [cjk] */
{ 0x9AD7,  2, 5, { 0x05, 0x08, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-57 壅	# [cjk] */
{ 0x9AD8,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-58 壓	# [cjk] */
{ 0x9AD9,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-59 壑	# [cjk] */
{ 0x9ADA,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-60 壗	# [cjk] */
{ 0x9ADB,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-61 壙	# [cjk] */
{ 0x9ADC,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-62 壘	# [cjk] */
{ 0x9ADD,  2, 5, { 0x05, 0x08, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-63 壥	# [cjk] */
{ 0x9ADE,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-64 壜	# [cjk] */
{ 0x9ADF,  2, 5, { 0x05, 0x08, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-65 壤	# [cjk] */
{ 0x9AE0,  2, 5, { 0x05, 0x08, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-66 壟	# [cjk] */
{ 0x9AE1,  2, 5, { 0x05, 0x08, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-67 壯	# [cjk] */
{ 0x9AE2,  2, 5, { 0x05, 0x08, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-68 壺	# [cjk] */
{ 0x9AE3,  2, 5, { 0x05, 0x08, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-69 壹	# [cjk] */
{ 0x9AE4,  2, 5, { 0x05, 0x08, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-70 壻	# [cjk] */
{ 0x9AE5,  2, 5, { 0x05, 0x08, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-71 壼	# [cjk] */
{ 0x9AE6,  2, 5, { 0x05, 0x08, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-72 壽	# [cjk] */
{ 0x9AE7,  2, 5, { 0x05, 0x09, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-73 夂	# [cjk] */
{ 0x9AE8,  2, 5, { 0x05, 0x09, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-74 夊	# [cjk] */
{ 0x9AE9,  2, 5, { 0x05, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-75 夐	# [cjk] */
{ 0x9AEA,  2, 5, { 0x05, 0x09, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-76 夛	# [cjk] */
{ 0x9AEB,  2, 5, { 0x06, 0x08, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-77 梦	# [cjk] */
{ 0x9AEC,  2, 5, { 0x05, 0x09, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-78 夥	# [cjk] */
{ 0x9AED,  2, 5, { 0x05, 0x09, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-79 夬	# [cjk] */
{ 0x9AEE,  2, 5, { 0x05, 0x09, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-80 夭	# [cjk] */
{ 0x9AEF,  2, 5, { 0x05, 0x09, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-81 夲	# [cjk] */
{ 0x9AF0,  2, 5, { 0x05, 0x09, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-82 夸	# [cjk] */
{ 0x9AF1,  2, 5, { 0x05, 0x09, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-83 夾	# [cjk] */
{ 0x9AF2,  2, 5, { 0x07, 0x0a, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-84 竒	# [cjk] */
{ 0x9AF3,  2, 5, { 0x05, 0x09, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-85 奕	# [cjk] */
{ 0x9AF4,  2, 5, { 0x05, 0x09, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-86 奐	# [cjk] */
{ 0x9AF5,  2, 5, { 0x05, 0x09, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-87 奎	# [cjk] */
{ 0x9AF6,  2, 5, { 0x05, 0x09, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-88 奚	# [cjk] */
{ 0x9AF7,  2, 5, { 0x05, 0x09, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-89 奘	# [cjk] */
{ 0x9AF8,  2, 5, { 0x05, 0x09, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-90 奢	# [cjk] */
{ 0x9AF9,  2, 5, { 0x05, 0x09, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-91 奠	# [cjk] */
{ 0x9AFA,  2, 5, { 0x05, 0x09, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-92 奧	# [cjk] */
{ 0x9AFB,  2, 5, { 0x05, 0x09, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-93 奬	# [cjk] */
{ 0x9AFC,  2, 5, { 0x05, 0x09, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-52-94 奩	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9B40,  2, 5, { 0x05, 0x09, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-01 奸	# [cjk] */
{ 0x9B41,  2, 5, { 0x05, 0x09, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-02 妁	# [cjk] */
{ 0x9B42,  2, 5, { 0x05, 0x09, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-03 妝	# [cjk] */
{ 0x9B43,  2, 5, { 0x04, 0x0f, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-04 佞	# [cjk] */
{ 0x9B44,  2, 5, { 0x04, 0x0f, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-05 侫	# [cjk] */
{ 0x9B45,  2, 5, { 0x05, 0x09, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-06 妣	# [cjk] */
{ 0x9B46,  2, 5, { 0x05, 0x09, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-07 妲	# [cjk] */
{ 0x9B47,  2, 5, { 0x05, 0x09, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-08 姆	# [cjk] */
{ 0x9B48,  2, 5, { 0x05, 0x09, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-09 姨	# [cjk] */
{ 0x9B49,  2, 5, { 0x05, 0x09, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-10 姜	# [cjk] */
{ 0x9B4A,  2, 5, { 0x05, 0x09, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-11 妍	# [cjk] */
{ 0x9B4B,  2, 5, { 0x05, 0x09, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-12 姙	# [cjk] */
{ 0x9B4C,  2, 5, { 0x05, 0x09, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-13 姚	# [cjk] */
{ 0x9B4D,  2, 5, { 0x05, 0x0a, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-14 娥	# [cjk] */
{ 0x9B4E,  2, 5, { 0x05, 0x0a, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-15 娟	# [cjk] */
{ 0x9B4F,  2, 5, { 0x05, 0x0a, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-16 娑	# [cjk] */
{ 0x9B50,  2, 5, { 0x05, 0x0a, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-17 娜	# [cjk] */
{ 0x9B51,  2, 5, { 0x05, 0x0a, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-18 娉	# [cjk] */
{ 0x9B52,  2, 5, { 0x05, 0x0a, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-19 娚	# [cjk] */
{ 0x9B53,  2, 5, { 0x05, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-20 婀	# [cjk] */
{ 0x9B54,  2, 5, { 0x05, 0x0a, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-21 婬	# [cjk] */
{ 0x9B55,  2, 5, { 0x05, 0x0a, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-22 婉	# [cjk] */
{ 0x9B56,  2, 5, { 0x05, 0x0a, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-23 娵	# [cjk] */
{ 0x9B57,  2, 5, { 0x05, 0x0a, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-24 娶	# [cjk] */
{ 0x9B58,  2, 5, { 0x05, 0x0a, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-25 婢	# [cjk] */
{ 0x9B59,  2, 5, { 0x05, 0x0a, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-26 婪	# [cjk] */
{ 0x9B5A,  2, 5, { 0x05, 0x0a, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-27 媚	# [cjk] */
{ 0x9B5B,  2, 5, { 0x05, 0x0a, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-28 媼	# [cjk] */
{ 0x9B5C,  2, 5, { 0x05, 0x0a, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-29 媾	# [cjk] */
{ 0x9B5D,  2, 5, { 0x05, 0x0a, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-30 嫋	# [cjk] */
{ 0x9B5E,  2, 5, { 0x05, 0x0a, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-31 嫂	# [cjk] */
{ 0x9B5F,  2, 5, { 0x05, 0x0a, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-32 媽	# [cjk] */
{ 0x9B60,  2, 5, { 0x05, 0x0a, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-33 嫣	# [cjk] */
{ 0x9B61,  2, 5, { 0x05, 0x0a, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-34 嫗	# [cjk] */
{ 0x9B62,  2, 5, { 0x05, 0x0a, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-35 嫦	# [cjk] */
{ 0x9B63,  2, 5, { 0x05, 0x0a, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-36 嫩	# [cjk] */
{ 0x9B64,  2, 5, { 0x05, 0x0a, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-37 嫖	# [cjk] */
{ 0x9B65,  2, 5, { 0x05, 0x0a, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-38 嫺	# [cjk] */
{ 0x9B66,  2, 5, { 0x05, 0x0a, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-39 嫻	# [cjk] */
{ 0x9B67,  2, 5, { 0x05, 0x0b, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-40 嬌	# [cjk] */
{ 0x9B68,  2, 5, { 0x05, 0x0b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-41 嬋	# [cjk] */
{ 0x9B69,  2, 5, { 0x05, 0x0b, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-42 嬖	# [cjk] */
{ 0x9B6A,  2, 5, { 0x05, 0x0b, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-43 嬲	# [cjk] */
{ 0x9B6B,  2, 5, { 0x05, 0x0a, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-44 嫐	# [cjk] */
{ 0x9B6C,  2, 5, { 0x05, 0x0b, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-45 嬪	# [cjk] */
{ 0x9B6D,  2, 5, { 0x05, 0x0b, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-46 嬶	# [cjk] */
{ 0x9B6E,  2, 5, { 0x05, 0x0b, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-47 嬾	# [cjk] */
{ 0x9B6F,  2, 5, { 0x05, 0x0b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-48 孃	# [cjk] */
{ 0x9B70,  2, 5, { 0x05, 0x0b, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-49 孅	# [cjk] */
{ 0x9B71,  2, 5, { 0x05, 0x0b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-50 孀	# [cjk] */
{ 0x9B72,  2, 5, { 0x05, 0x0b, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-51 孑	# [cjk] */
{ 0x9B73,  2, 5, { 0x05, 0x0b, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-52 孕	# [cjk] */
{ 0x9B74,  2, 5, { 0x05, 0x0b, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-53 孚	# [cjk] */
{ 0x9B75,  2, 5, { 0x05, 0x0b, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-54 孛	# [cjk] */
{ 0x9B76,  2, 5, { 0x05, 0x0b, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-55 孥	# [cjk] */
{ 0x9B77,  2, 5, { 0x05, 0x0b, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-56 孩	# [cjk] */
{ 0x9B78,  2, 5, { 0x05, 0x0b, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-57 孰	# [cjk] */
{ 0x9B79,  2, 5, { 0x05, 0x0b, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-58 孳	# [cjk] */
{ 0x9B7A,  2, 5, { 0x05, 0x0b, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-59 孵	# [cjk] */
{ 0x9B7B,  2, 5, { 0x05, 0x0b, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-60 學	# [cjk] */
{ 0x9B7C,  2, 5, { 0x06, 0x05, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-61 斈	# [cjk] */
{ 0x9B7D,  2, 5, { 0x05, 0x0b, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-62 孺	# [cjk] */
{ 0x9B7E,  2, 5, { 0x05, 0x0b, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-63 宀	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9B80,  2, 5, { 0x05, 0x0b, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-64 它	# [cjk] */
{ 0x9B81,  2, 5, { 0x05, 0x0b, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-65 宦	# [cjk] */
{ 0x9B82,  2, 5, { 0x05, 0x0b, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-66 宸	# [cjk] */
{ 0x9B83,  2, 5, { 0x05, 0x0b, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-67 寃	# [cjk] */
{ 0x9B84,  2, 5, { 0x05, 0x0b, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-68 寇	# [cjk] */
{ 0x9B85,  2, 5, { 0x05, 0x0b, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-69 寉	# [cjk] */
{ 0x9B86,  2, 5, { 0x05, 0x0b, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-70 寔	# [cjk] */
{ 0x9B87,  2, 5, { 0x05, 0x0b, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-71 寐	# [cjk] */
{ 0x9B88,  2, 5, { 0x05, 0x0b, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-72 寤	# [cjk] */
{ 0x9B89,  2, 5, { 0x05, 0x0b, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-73 實	# [cjk] */
{ 0x9B8A,  2, 5, { 0x05, 0x0b, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-74 寢	# [cjk] */
{ 0x9B8B,  2, 5, { 0x05, 0x0b, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-75 寞	# [cjk] */
{ 0x9B8C,  2, 5, { 0x05, 0x0b, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-76 寥	# [cjk] */
{ 0x9B8D,  2, 5, { 0x05, 0x0b, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-77 寫	# [cjk] */
{ 0x9B8E,  2, 5, { 0x05, 0x0b, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-78 寰	# [cjk] */
{ 0x9B8F,  2, 5, { 0x05, 0x0b, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-79 寶	# [cjk] */
{ 0x9B90,  2, 5, { 0x05, 0x0b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-80 寳	# [cjk] */
{ 0x9B91,  2, 5, { 0x05, 0x0c, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-81 尅	# [cjk] */
{ 0x9B92,  2, 5, { 0x05, 0x0c, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-82 將	# [cjk] */
{ 0x9B93,  2, 5, { 0x05, 0x0c, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-83 專	# [cjk] */
{ 0x9B94,  2, 5, { 0x05, 0x0c, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-84 對	# [cjk] */
{ 0x9B95,  2, 5, { 0x05, 0x0c, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-85 尓	# [cjk] */
{ 0x9B96,  2, 5, { 0x05, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-86 尠	# [cjk] */
{ 0x9B97,  2, 5, { 0x05, 0x0c, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-87 尢	# [cjk] */
{ 0x9B98,  2, 5, { 0x05, 0x0c, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-88 尨	# [cjk] */
{ 0x9B99,  2, 5, { 0x05, 0x0c, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-89 尸	# [cjk] */
{ 0x9B9A,  2, 5, { 0x05, 0x0c, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-90 尹	# [cjk] */
{ 0x9B9B,  2, 5, { 0x05, 0x0c, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-91 屁	# [cjk] */
{ 0x9B9C,  2, 5, { 0x05, 0x0c, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-92 屆	# [cjk] */
{ 0x9B9D,  2, 5, { 0x05, 0x0c, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-93 屎	# [cjk] */
{ 0x9B9E,  2, 5, { 0x05, 0x0c, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-53-94 屓	# [cjk] */
{ 0x9B9F,  2, 5, { 0x05, 0x0c, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-01 屐	# [cjk] */
{ 0x9BA0,  2, 5, { 0x05, 0x0c, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-02 屏	# [cjk] */
{ 0x9BA1,  2, 5, { 0x05, 0x0b, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-03 孱	# [cjk] */
{ 0x9BA2,  2, 5, { 0x05, 0x0c, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-04 屬	# [cjk] */
{ 0x9BA3,  2, 5, { 0x05, 0x0c, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-05 屮	# [cjk] */
{ 0x9BA4,  2, 5, { 0x04, 0x0e, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-06 乢	# [cjk] */
{ 0x9BA5,  2, 5, { 0x05, 0x0c, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-07 屶	# [cjk] */
{ 0x9BA6,  2, 5, { 0x05, 0x0c, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-08 屹	# [cjk] */
{ 0x9BA7,  2, 5, { 0x05, 0x0c, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-09 岌	# [cjk] */
{ 0x9BA8,  2, 5, { 0x05, 0x0c, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-10 岑	# [cjk] */
{ 0x9BA9,  2, 5, { 0x05, 0x0c, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-11 岔	# [cjk] */
{ 0x9BAA,  2, 5, { 0x05, 0x09, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-12 妛	# [cjk] */
{ 0x9BAB,  2, 5, { 0x05, 0x0c, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-13 岫	# [cjk] */
{ 0x9BAC,  2, 5, { 0x05, 0x0c, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-14 岻	# [cjk] */
{ 0x9BAD,  2, 5, { 0x05, 0x0c, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-15 岶	# [cjk] */
{ 0x9BAE,  2, 5, { 0x05, 0x0c, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-16 岼	# [cjk] */
{ 0x9BAF,  2, 5, { 0x05, 0x0c, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-17 岷	# [cjk] */
{ 0x9BB0,  2, 5, { 0x05, 0x0c, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-18 峅	# [cjk] */
{ 0x9BB1,  2, 5, { 0x05, 0x0c, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-19 岾	# [cjk] */
{ 0x9BB2,  2, 5, { 0x05, 0x0c, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-20 峇	# [cjk] */
{ 0x9BB3,  2, 5, { 0x05, 0x0c, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-21 峙	# [cjk] */
{ 0x9BB4,  2, 5, { 0x05, 0x0c, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-22 峩	# [cjk] */
{ 0x9BB5,  2, 5, { 0x05, 0x0c, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-23 峽	# [cjk] */
{ 0x9BB6,  2, 5, { 0x05, 0x0c, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-24 峺	# [cjk] */
{ 0x9BB7,  2, 5, { 0x05, 0x0c, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-25 峭	# [cjk] */
{ 0x9BB8,  2, 5, { 0x05, 0x0d, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-26 嶌	# [cjk] */
{ 0x9BB9,  2, 5, { 0x05, 0x0c, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-27 峪	# [cjk] */
{ 0x9BBA,  2, 5, { 0x05, 0x0d, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-28 崋	# [cjk] */
{ 0x9BBB,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-29 崕	# [cjk] */
{ 0x9BBC,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-30 崗	# [cjk] */
{ 0x9BBD,  2, 5, { 0x05, 0x0d, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-31 嵜	# [cjk] */
{ 0x9BBE,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-32 崟	# [cjk] */
{ 0x9BBF,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-33 崛	# [cjk] */
{ 0x9BC0,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-34 崑	# [cjk] */
{ 0x9BC1,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-35 崔	# [cjk] */
{ 0x9BC2,  2, 5, { 0x05, 0x0d, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-36 崢	# [cjk] */
{ 0x9BC3,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-37 崚	# [cjk] */
{ 0x9BC4,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-38 崙	# [cjk] */
{ 0x9BC5,  2, 5, { 0x05, 0x0d, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-39 崘	# [cjk] */
{ 0x9BC6,  2, 5, { 0x05, 0x0d, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-40 嵌	# [cjk] */
{ 0x9BC7,  2, 5, { 0x05, 0x0d, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-41 嵒	# [cjk] */
{ 0x9BC8,  2, 5, { 0x05, 0x0d, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-42 嵎	# [cjk] */
{ 0x9BC9,  2, 5, { 0x05, 0x0d, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-43 嵋	# [cjk] */
{ 0x9BCA,  2, 5, { 0x05, 0x0d, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-44 嵬	# [cjk] */
{ 0x9BCB,  2, 5, { 0x05, 0x0d, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-45 嵳	# [cjk] */
{ 0x9BCC,  2, 5, { 0x05, 0x0d, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-46 嵶	# [cjk] */
{ 0x9BCD,  2, 5, { 0x05, 0x0d, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-47 嶇	# [cjk] */
{ 0x9BCE,  2, 5, { 0x05, 0x0d, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-48 嶄	# [cjk] */
{ 0x9BCF,  2, 5, { 0x05, 0x0d, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-49 嶂	# [cjk] */
{ 0x9BD0,  2, 5, { 0x05, 0x0d, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-50 嶢	# [cjk] */
{ 0x9BD1,  2, 5, { 0x05, 0x0d, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-51 嶝	# [cjk] */
{ 0x9BD2,  2, 5, { 0x05, 0x0d, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-52 嶬	# [cjk] */
{ 0x9BD3,  2, 5, { 0x05, 0x0d, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-53 嶮	# [cjk] */
{ 0x9BD4,  2, 5, { 0x05, 0x0d, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-54 嶽	# [cjk] */
{ 0x9BD5,  2, 5, { 0x05, 0x0d, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-55 嶐	# [cjk] */
{ 0x9BD6,  2, 5, { 0x05, 0x0d, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-56 嶷	# [cjk] */
{ 0x9BD7,  2, 5, { 0x05, 0x0d, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-57 嶼	# [cjk] */
{ 0x9BD8,  2, 5, { 0x05, 0x0d, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-58 巉	# [cjk] */
{ 0x9BD9,  2, 5, { 0x05, 0x0d, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-59 巍	# [cjk] */
{ 0x9BDA,  2, 5, { 0x05, 0x0d, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-60 巓	# [cjk] */
{ 0x9BDB,  2, 5, { 0x05, 0x0d, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-61 巒	# [cjk] */
{ 0x9BDC,  2, 5, { 0x05, 0x0d, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-62 巖	# [cjk] */
{ 0x9BDD,  2, 5, { 0x05, 0x0d, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-63 巛	# [cjk] */
{ 0x9BDE,  2, 5, { 0x05, 0x0d, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-64 巫	# [cjk] */
{ 0x9BDF,  2, 5, { 0x05, 0x0d, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-65 已	# [cjk] */
{ 0x9BE0,  2, 5, { 0x05, 0x0d, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-66 巵	# [cjk] */
{ 0x9BE1,  2, 5, { 0x05, 0x0e, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-67 帋	# [cjk] */
{ 0x9BE2,  2, 5, { 0x05, 0x0e, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-68 帚	# [cjk] */
{ 0x9BE3,  2, 5, { 0x05, 0x0e, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-69 帙	# [cjk] */
{ 0x9BE4,  2, 5, { 0x05, 0x0e, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-70 帑	# [cjk] */
{ 0x9BE5,  2, 5, { 0x05, 0x0e, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-71 帛	# [cjk] */
{ 0x9BE6,  2, 5, { 0x05, 0x0e, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-72 帶	# [cjk] */
{ 0x9BE7,  2, 5, { 0x05, 0x0e, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-73 帷	# [cjk] */
{ 0x9BE8,  2, 5, { 0x05, 0x0e, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-74 幄	# [cjk] */
{ 0x9BE9,  2, 5, { 0x05, 0x0e, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-75 幃	# [cjk] */
{ 0x9BEA,  2, 5, { 0x05, 0x0e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-76 幀	# [cjk] */
{ 0x9BEB,  2, 5, { 0x05, 0x0e, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-77 幎	# [cjk] */
{ 0x9BEC,  2, 5, { 0x05, 0x0e, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-78 幗	# [cjk] */
{ 0x9BED,  2, 5, { 0x05, 0x0e, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-79 幔	# [cjk] */
{ 0x9BEE,  2, 5, { 0x05, 0x0e, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-80 幟	# [cjk] */
{ 0x9BEF,  2, 5, { 0x05, 0x0e, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-81 幢	# [cjk] */
{ 0x9BF0,  2, 5, { 0x05, 0x0e, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-82 幤	# [cjk] */
{ 0x9BF1,  2, 5, { 0x05, 0x0e, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-83 幇	# [cjk] */
{ 0x9BF2,  2, 5, { 0x05, 0x0e, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-84 幵	# [cjk] */
{ 0x9BF3,  2, 5, { 0x05, 0x0e, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-85 并	# [cjk] */
{ 0x9BF4,  2, 5, { 0x05, 0x0e, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-86 幺	# [cjk] */
{ 0x9BF5,  2, 5, { 0x09, 0x0e, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-87 麼	# [cjk] */
{ 0x9BF6,  2, 5, { 0x05, 0x0e, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-88 广	# [cjk] */
{ 0x9BF7,  2, 5, { 0x05, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-89 庠	# [cjk] */
{ 0x9BF8,  2, 5, { 0x05, 0x0e, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-90 廁	# [cjk] */
{ 0x9BF9,  2, 5, { 0x05, 0x0e, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-91 廂	# [cjk] */
{ 0x9BFA,  2, 5, { 0x05, 0x0e, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-92 廈	# [cjk] */
{ 0x9BFB,  2, 5, { 0x05, 0x0e, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-93 廐	# [cjk] */
{ 0x9BFC,  2, 5, { 0x05, 0x0e, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-54-94 廏	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9C40,  2, 5, { 0x05, 0x0e, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-01 廖	# [cjk] */
{ 0x9C41,  2, 5, { 0x05, 0x0e, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-02 廣	# [cjk] */
{ 0x9C42,  2, 5, { 0x05, 0x0e, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-03 廝	# [cjk] */
{ 0x9C43,  2, 5, { 0x05, 0x0e, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-04 廚	# [cjk] */
{ 0x9C44,  2, 5, { 0x05, 0x0e, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-05 廛	# [cjk] */
{ 0x9C45,  2, 5, { 0x05, 0x0e, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-06 廢	# [cjk] */
{ 0x9C46,  2, 5, { 0x05, 0x0e, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-07 廡	# [cjk] */
{ 0x9C47,  2, 5, { 0x05, 0x0e, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-08 廨	# [cjk] */
{ 0x9C48,  2, 5, { 0x05, 0x0e, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-09 廩	# [cjk] */
{ 0x9C49,  2, 5, { 0x05, 0x0e, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-10 廬	# [cjk] */
{ 0x9C4A,  2, 5, { 0x05, 0x0e, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-11 廱	# [cjk] */
{ 0x9C4B,  2, 5, { 0x05, 0x0e, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-12 廳	# [cjk] */
{ 0x9C4C,  2, 5, { 0x05, 0x0e, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-13 廰	# [cjk] */
{ 0x9C4D,  2, 5, { 0x05, 0x0e, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-14 廴	# [cjk] */
{ 0x9C4E,  2, 5, { 0x05, 0x0e, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-15 廸	# [cjk] */
{ 0x9C4F,  2, 5, { 0x05, 0x0e, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-16 廾	# [cjk] */
{ 0x9C50,  2, 5, { 0x05, 0x0f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-17 弃	# [cjk] */
{ 0x9C51,  2, 5, { 0x05, 0x0f, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-18 弉	# [cjk] */
{ 0x9C52,  2, 5, { 0x05, 0x0f, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-19 彝	# [cjk] */
{ 0x9C53,  2, 5, { 0x05, 0x0f, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-20 彜	# [cjk] */
{ 0x9C54,  2, 5, { 0x05, 0x0f, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-21 弋	# [cjk] */
{ 0x9C55,  2, 5, { 0x05, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-22 弑	# [cjk] */
{ 0x9C56,  2, 5, { 0x05, 0x0f, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-23 弖	# [cjk] */
{ 0x9C57,  2, 5, { 0x05, 0x0f, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-24 弩	# [cjk] */
{ 0x9C58,  2, 5, { 0x05, 0x0f, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-25 弭	# [cjk] */
{ 0x9C59,  2, 5, { 0x05, 0x0f, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-26 弸	# [cjk] */
{ 0x9C5A,  2, 5, { 0x05, 0x0f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-27 彁	# [cjk] */
{ 0x9C5B,  2, 5, { 0x05, 0x0f, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-28 彈	# [cjk] */
{ 0x9C5C,  2, 5, { 0x05, 0x0f, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-29 彌	# [cjk] */
{ 0x9C5D,  2, 5, { 0x05, 0x0f, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-30 彎	# [cjk] */
{ 0x9C5E,  2, 5, { 0x05, 0x0f, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-31 弯	# [cjk] */
{ 0x9C5F,  2, 5, { 0x05, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-32 彑	# [cjk] */
{ 0x9C60,  2, 5, { 0x05, 0x0f, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-33 彖	# [cjk] */
{ 0x9C61,  2, 5, { 0x05, 0x0f, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-34 彗	# [cjk] */
{ 0x9C62,  2, 5, { 0x05, 0x0f, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-35 彙	# [cjk] */
{ 0x9C63,  2, 5, { 0x05, 0x0f, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-36 彡	# [cjk] */
{ 0x9C64,  2, 5, { 0x05, 0x0f, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-37 彭	# [cjk] */
{ 0x9C65,  2, 5, { 0x05, 0x0f, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-38 彳	# [cjk] */
{ 0x9C66,  2, 5, { 0x05, 0x0f, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-39 彷	# [cjk] */
{ 0x9C67,  2, 5, { 0x05, 0x0f, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-40 徃	# [cjk] */
{ 0x9C68,  2, 5, { 0x05, 0x0f, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-41 徂	# [cjk] */
{ 0x9C69,  2, 5, { 0x05, 0x0f, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-42 彿	# [cjk] */
{ 0x9C6A,  2, 5, { 0x05, 0x0f, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-43 徊	# [cjk] */
{ 0x9C6B,  2, 5, { 0x05, 0x0f, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-44 很	# [cjk] */
{ 0x9C6C,  2, 5, { 0x05, 0x0f, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-45 徑	# [cjk] */
{ 0x9C6D,  2, 5, { 0x05, 0x0f, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-46 徇	# [cjk] */
{ 0x9C6E,  2, 5, { 0x05, 0x0f, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-47 從	# [cjk] */
{ 0x9C6F,  2, 5, { 0x05, 0x0f, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-48 徙	# [cjk] */
{ 0x9C70,  2, 5, { 0x05, 0x0f, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-49 徘	# [cjk] */
{ 0x9C71,  2, 5, { 0x05, 0x0f, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-50 徠	# [cjk] */
{ 0x9C72,  2, 5, { 0x05, 0x0f, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-51 徨	# [cjk] */
{ 0x9C73,  2, 5, { 0x05, 0x0f, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-52 徭	# [cjk] */
{ 0x9C74,  2, 5, { 0x05, 0x0f, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-53 徼	# [cjk] */
{ 0x9C75,  2, 5, { 0x05, 0x0f, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-54 忖	# [cjk] */
{ 0x9C76,  2, 5, { 0x05, 0x0f, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-55 忻	# [cjk] */
{ 0x9C77,  2, 5, { 0x05, 0x0f, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-56 忤	# [cjk] */
{ 0x9C78,  2, 5, { 0x05, 0x0f, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-57 忸	# [cjk] */
{ 0x9C79,  2, 5, { 0x05, 0x0f, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-58 忱	# [cjk] */
{ 0x9C7A,  2, 5, { 0x05, 0x0f, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-59 忝	# [cjk] */
{ 0x9C7B,  2, 5, { 0x06, 0x00, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-60 悳	# [cjk] */
{ 0x9C7C,  2, 5, { 0x05, 0x0f, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-61 忿	# [cjk] */
{ 0x9C7D,  2, 5, { 0x06, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-62 怡	# [cjk] */
{ 0x9C7E,  2, 5, { 0x06, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-63 恠	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9C80,  2, 5, { 0x06, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-64 怙	# [cjk] */
{ 0x9C81,  2, 5, { 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-65 怐	# [cjk] */
{ 0x9C82,  2, 5, { 0x06, 0x00, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-66 怩	# [cjk] */
{ 0x9C83,  2, 5, { 0x06, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-67 怎	# [cjk] */
{ 0x9C84,  2, 5, { 0x06, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-68 怱	# [cjk] */
{ 0x9C85,  2, 5, { 0x06, 0x00, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-69 怛	# [cjk] */
{ 0x9C86,  2, 5, { 0x06, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-70 怕	# [cjk] */
{ 0x9C87,  2, 5, { 0x06, 0x00, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-71 怫	# [cjk] */
{ 0x9C88,  2, 5, { 0x06, 0x00, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-72 怦	# [cjk] */
{ 0x9C89,  2, 5, { 0x06, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-73 怏	# [cjk] */
{ 0x9C8A,  2, 5, { 0x06, 0x00, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-74 怺	# [cjk] */
{ 0x9C8B,  2, 5, { 0x06, 0x00, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-75 恚	# [cjk] */
{ 0x9C8C,  2, 5, { 0x06, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-76 恁	# [cjk] */
{ 0x9C8D,  2, 5, { 0x06, 0x00, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-77 恪	# [cjk] */
{ 0x9C8E,  2, 5, { 0x06, 0x00, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-78 恷	# [cjk] */
{ 0x9C8F,  2, 5, { 0x06, 0x00, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-79 恟	# [cjk] */
{ 0x9C90,  2, 5, { 0x06, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-80 恊	# [cjk] */
{ 0x9C91,  2, 5, { 0x06, 0x00, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-81 恆	# [cjk] */
{ 0x9C92,  2, 5, { 0x06, 0x00, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-82 恍	# [cjk] */
{ 0x9C93,  2, 5, { 0x06, 0x00, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-83 恣	# [cjk] */
{ 0x9C94,  2, 5, { 0x06, 0x00, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-84 恃	# [cjk] */
{ 0x9C95,  2, 5, { 0x06, 0x00, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-85 恤	# [cjk] */
{ 0x9C96,  2, 5, { 0x06, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-86 恂	# [cjk] */
{ 0x9C97,  2, 5, { 0x06, 0x00, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-87 恬	# [cjk] */
{ 0x9C98,  2, 5, { 0x06, 0x00, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-88 恫	# [cjk] */
{ 0x9C99,  2, 5, { 0x06, 0x00, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-89 恙	# [cjk] */
{ 0x9C9A,  2, 5, { 0x06, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-90 悁	# [cjk] */
{ 0x9C9B,  2, 5, { 0x06, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-91 悍	# [cjk] */
{ 0x9C9C,  2, 5, { 0x06, 0x00, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-92 惧	# [cjk] */
{ 0x9C9D,  2, 5, { 0x06, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-93 悃	# [cjk] */
{ 0x9C9E,  2, 5, { 0x06, 0x00, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-55-94 悚	# [cjk] */
{ 0x9C9F,  2, 5, { 0x06, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-01 悄	# [cjk] */
{ 0x9CA0,  2, 5, { 0x06, 0x00, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-02 悛	# [cjk] */
{ 0x9CA1,  2, 5, { 0x06, 0x00, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-03 悖	# [cjk] */
{ 0x9CA2,  2, 5, { 0x06, 0x00, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-04 悗	# [cjk] */
{ 0x9CA3,  2, 5, { 0x06, 0x00, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-05 悒	# [cjk] */
{ 0x9CA4,  2, 5, { 0x06, 0x00, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-06 悧	# [cjk] */
{ 0x9CA5,  2, 5, { 0x06, 0x00, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-07 悋	# [cjk] */
{ 0x9CA6,  2, 5, { 0x06, 0x00, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-08 惡	# [cjk] */
{ 0x9CA7,  2, 5, { 0x06, 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-09 悸	# [cjk] */
{ 0x9CA8,  2, 5, { 0x06, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-10 惠	# [cjk] */
{ 0x9CA9,  2, 5, { 0x06, 0x00, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-11 惓	# [cjk] */
{ 0x9CAA,  2, 5, { 0x06, 0x00, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-12 悴	# [cjk] */
{ 0x9CAB,  2, 5, { 0x05, 0x0f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-13 忰	# [cjk] */
{ 0x9CAC,  2, 5, { 0x06, 0x00, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-14 悽	# [cjk] */
{ 0x9CAD,  2, 5, { 0x06, 0x00, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-15 惆	# [cjk] */
{ 0x9CAE,  2, 5, { 0x06, 0x00, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-16 悵	# [cjk] */
{ 0x9CAF,  2, 5, { 0x06, 0x00, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-17 惘	# [cjk] */
{ 0x9CB0,  2, 5, { 0x06, 0x01, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-18 慍	# [cjk] */
{ 0x9CB1,  2, 5, { 0x06, 0x01, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-19 愕	# [cjk] */
{ 0x9CB2,  2, 5, { 0x06, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-20 愆	# [cjk] */
{ 0x9CB3,  2, 5, { 0x06, 0x00, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-21 惶	# [cjk] */
{ 0x9CB4,  2, 5, { 0x06, 0x00, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-22 惷	# [cjk] */
{ 0x9CB5,  2, 5, { 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-23 愀	# [cjk] */
{ 0x9CB6,  2, 5, { 0x06, 0x00, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-24 惴	# [cjk] */
{ 0x9CB7,  2, 5, { 0x06, 0x00, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-25 惺	# [cjk] */
{ 0x9CB8,  2, 5, { 0x06, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-26 愃	# [cjk] */
{ 0x9CB9,  2, 5, { 0x06, 0x01, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-27 愡	# [cjk] */
{ 0x9CBA,  2, 5, { 0x06, 0x00, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-28 惻	# [cjk] */
{ 0x9CBB,  2, 5, { 0x06, 0x00, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-29 惱	# [cjk] */
{ 0x9CBC,  2, 5, { 0x06, 0x01, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-30 愍	# [cjk] */
{ 0x9CBD,  2, 5, { 0x06, 0x01, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-31 愎	# [cjk] */
{ 0x9CBE,  2, 5, { 0x06, 0x01, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-32 慇	# [cjk] */
{ 0x9CBF,  2, 5, { 0x06, 0x01, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-33 愾	# [cjk] */
{ 0x9CC0,  2, 5, { 0x06, 0x01, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-34 愨	# [cjk] */
{ 0x9CC1,  2, 5, { 0x06, 0x01, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-35 愧	# [cjk] */
{ 0x9CC2,  2, 5, { 0x06, 0x01, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-36 慊	# [cjk] */
{ 0x9CC3,  2, 5, { 0x06, 0x01, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-37 愿	# [cjk] */
{ 0x9CC4,  2, 5, { 0x06, 0x01, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-38 愼	# [cjk] */
{ 0x9CC5,  2, 5, { 0x06, 0x01, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-39 愬	# [cjk] */
{ 0x9CC6,  2, 5, { 0x06, 0x01, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-40 愴	# [cjk] */
{ 0x9CC7,  2, 5, { 0x06, 0x01, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-41 愽	# [cjk] */
{ 0x9CC8,  2, 5, { 0x06, 0x01, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-42 慂	# [cjk] */
{ 0x9CC9,  2, 5, { 0x06, 0x01, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-43 慄	# [cjk] */
{ 0x9CCA,  2, 5, { 0x06, 0x01, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-44 慳	# [cjk] */
{ 0x9CCB,  2, 5, { 0x06, 0x01, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-45 慷	# [cjk] */
{ 0x9CCC,  2, 5, { 0x06, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-46 慘	# [cjk] */
{ 0x9CCD,  2, 5, { 0x06, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-47 慙	# [cjk] */
{ 0x9CCE,  2, 5, { 0x06, 0x01, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-48 慚	# [cjk] */
{ 0x9CCF,  2, 5, { 0x06, 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-49 慫	# [cjk] */
{ 0x9CD0,  2, 5, { 0x06, 0x01, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-50 慴	# [cjk] */
{ 0x9CD1,  2, 5, { 0x06, 0x01, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-51 慯	# [cjk] */
{ 0x9CD2,  2, 5, { 0x06, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-52 慥	# [cjk] */
{ 0x9CD3,  2, 5, { 0x06, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-53 慱	# [cjk] */
{ 0x9CD4,  2, 5, { 0x06, 0x01, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-54 慟	# [cjk] */
{ 0x9CD5,  2, 5, { 0x06, 0x01, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-55 慝	# [cjk] */
{ 0x9CD6,  2, 5, { 0x06, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-56 慓	# [cjk] */
{ 0x9CD7,  2, 5, { 0x06, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-57 慵	# [cjk] */
{ 0x9CD8,  2, 5, { 0x06, 0x01, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-58 憙	# [cjk] */
{ 0x9CD9,  2, 5, { 0x06, 0x01, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-59 憖	# [cjk] */
{ 0x9CDA,  2, 5, { 0x06, 0x01, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-60 憇	# [cjk] */
{ 0x9CDB,  2, 5, { 0x06, 0x01, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-61 憬	# [cjk] */
{ 0x9CDC,  2, 5, { 0x06, 0x01, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-62 憔	# [cjk] */
{ 0x9CDD,  2, 5, { 0x06, 0x01, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-63 憚	# [cjk] */
{ 0x9CDE,  2, 5, { 0x06, 0x01, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-64 憊	# [cjk] */
{ 0x9CDF,  2, 5, { 0x06, 0x01, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-65 憑	# [cjk] */
{ 0x9CE0,  2, 5, { 0x06, 0x01, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-66 憫	# [cjk] */
{ 0x9CE1,  2, 5, { 0x06, 0x01, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-67 憮	# [cjk] */
{ 0x9CE2,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-68 懌	# [cjk] */
{ 0x9CE3,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-69 懊	# [cjk] */
{ 0x9CE4,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-70 應	# [cjk] */
{ 0x9CE5,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-71 懷	# [cjk] */
{ 0x9CE6,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-72 懈	# [cjk] */
{ 0x9CE7,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-73 懃	# [cjk] */
{ 0x9CE8,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-74 懆	# [cjk] */
{ 0x9CE9,  2, 5, { 0x06, 0x01, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-75 憺	# [cjk] */
{ 0x9CEA,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-76 懋	# [cjk] */
{ 0x9CEB,  2, 5, { 0x07, 0x0f, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-77 罹	# [cjk] */
{ 0x9CEC,  2, 5, { 0x06, 0x01, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-78 懍	# [cjk] */
{ 0x9CED,  2, 5, { 0x06, 0x01, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-79 懦	# [cjk] */
{ 0x9CEE,  2, 5, { 0x06, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-80 懣	# [cjk] */
{ 0x9CEF,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-81 懶	# [cjk] */
{ 0x9CF0,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-82 懺	# [cjk] */
{ 0x9CF1,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-83 懴	# [cjk] */
{ 0x9CF2,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-84 懿	# [cjk] */
{ 0x9CF3,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-85 懽	# [cjk] */
{ 0x9CF4,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-86 懼	# [cjk] */
{ 0x9CF5,  2, 5, { 0x06, 0x01, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-87 懾	# [cjk] */
{ 0x9CF6,  2, 5, { 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-88 戀	# [cjk] */
{ 0x9CF7,  2, 5, { 0x06, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-89 戈	# [cjk] */
{ 0x9CF8,  2, 5, { 0x06, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-90 戉	# [cjk] */
{ 0x9CF9,  2, 5, { 0x06, 0x02, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-91 戍	# [cjk] */
{ 0x9CFA,  2, 5, { 0x06, 0x02, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-92 戌	# [cjk] */
{ 0x9CFB,  2, 5, { 0x06, 0x02, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-93 戔	# [cjk] */
{ 0x9CFC,  2, 5, { 0x06, 0x02, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-56-94 戛	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9D40,  2, 5, { 0x06, 0x02, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-01 戞	# [cjk] */
{ 0x9D41,  2, 5, { 0x06, 0x02, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-02 戡	# [cjk] */
{ 0x9D42,  2, 5, { 0x06, 0x02, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-03 截	# [cjk] */
{ 0x9D43,  2, 5, { 0x06, 0x02, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-04 戮	# [cjk] */
{ 0x9D44,  2, 5, { 0x06, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-05 戰	# [cjk] */
{ 0x9D45,  2, 5, { 0x06, 0x02, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-06 戲	# [cjk] */
{ 0x9D46,  2, 5, { 0x06, 0x02, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-07 戳	# [cjk] */
{ 0x9D47,  2, 5, { 0x06, 0x02, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-08 扁	# [cjk] */
{ 0x9D48,  2, 5, { 0x06, 0x02, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-09 扎	# [cjk] */
{ 0x9D49,  2, 5, { 0x06, 0x02, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-10 扞	# [cjk] */
{ 0x9D4A,  2, 5, { 0x06, 0x02, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-11 扣	# [cjk] */
{ 0x9D4B,  2, 5, { 0x06, 0x02, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-12 扛	# [cjk] */
{ 0x9D4C,  2, 5, { 0x06, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-13 扠	# [cjk] */
{ 0x9D4D,  2, 5, { 0x06, 0x02, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-14 扨	# [cjk] */
{ 0x9D4E,  2, 5, { 0x06, 0x02, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-15 扼	# [cjk] */
{ 0x9D4F,  2, 5, { 0x06, 0x02, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-16 抂	# [cjk] */
{ 0x9D50,  2, 5, { 0x06, 0x02, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-17 抉	# [cjk] */
{ 0x9D51,  2, 5, { 0x06, 0x02, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-18 找	# [cjk] */
{ 0x9D52,  2, 5, { 0x06, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-19 抒	# [cjk] */
{ 0x9D53,  2, 5, { 0x06, 0x02, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-20 抓	# [cjk] */
{ 0x9D54,  2, 5, { 0x06, 0x02, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-21 抖	# [cjk] */
{ 0x9D55,  2, 5, { 0x06, 0x02, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-22 拔	# [cjk] */
{ 0x9D56,  2, 5, { 0x06, 0x02, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-23 抃	# [cjk] */
{ 0x9D57,  2, 5, { 0x06, 0x02, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-24 抔	# [cjk] */
{ 0x9D58,  2, 5, { 0x06, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-25 拗	# [cjk] */
{ 0x9D59,  2, 5, { 0x06, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-26 拑	# [cjk] */
{ 0x9D5A,  2, 5, { 0x06, 0x02, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-27 抻	# [cjk] */
{ 0x9D5B,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-28 拏	# [cjk] */
{ 0x9D5C,  2, 5, { 0x06, 0x02, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-29 拿	# [cjk] */
{ 0x9D5D,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-30 拆	# [cjk] */
{ 0x9D5E,  2, 5, { 0x06, 0x04, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-31 擔	# [cjk] */
{ 0x9D5F,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-32 拈	# [cjk] */
{ 0x9D60,  2, 5, { 0x06, 0x02, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-33 拜	# [cjk] */
{ 0x9D61,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-34 拌	# [cjk] */
{ 0x9D62,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-35 拊	# [cjk] */
{ 0x9D63,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-36 拂	# [cjk] */
{ 0x9D64,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-37 拇	# [cjk] */
{ 0x9D65,  2, 5, { 0x06, 0x02, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-38 抛	# [cjk] */
{ 0x9D66,  2, 5, { 0x06, 0x02, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-39 拉	# [cjk] */
{ 0x9D67,  2, 5, { 0x06, 0x03, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-40 挌	# [cjk] */
{ 0x9D68,  2, 5, { 0x06, 0x02, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-41 拮	# [cjk] */
{ 0x9D69,  2, 5, { 0x06, 0x02, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-42 拱	# [cjk] */
{ 0x9D6A,  2, 5, { 0x06, 0x03, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-43 挧	# [cjk] */
{ 0x9D6B,  2, 5, { 0x06, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-44 挂	# [cjk] */
{ 0x9D6C,  2, 5, { 0x06, 0x03, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-45 挈	# [cjk] */
{ 0x9D6D,  2, 5, { 0x06, 0x02, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-46 拯	# [cjk] */
{ 0x9D6E,  2, 5, { 0x06, 0x02, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-47 拵	# [cjk] */
{ 0x9D6F,  2, 5, { 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-48 捐	# [cjk] */
{ 0x9D70,  2, 5, { 0x06, 0x03, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-49 挾	# [cjk] */
{ 0x9D71,  2, 5, { 0x06, 0x03, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-50 捍	# [cjk] */
{ 0x9D72,  2, 5, { 0x06, 0x04, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-51 搜	# [cjk] */
{ 0x9D73,  2, 5, { 0x06, 0x03, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-52 捏	# [cjk] */
{ 0x9D74,  2, 5, { 0x06, 0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-53 掖	# [cjk] */
{ 0x9D75,  2, 5, { 0x06, 0x03, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-54 掎	# [cjk] */
{ 0x9D76,  2, 5, { 0x06, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-55 掀	# [cjk] */
{ 0x9D77,  2, 5, { 0x06, 0x03, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-56 掫	# [cjk] */
{ 0x9D78,  2, 5, { 0x06, 0x03, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-57 捶	# [cjk] */
{ 0x9D79,  2, 5, { 0x06, 0x03, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-58 掣	# [cjk] */
{ 0x9D7A,  2, 5, { 0x06, 0x03, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-59 掏	# [cjk] */
{ 0x9D7B,  2, 5, { 0x06, 0x03, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-60 掉	# [cjk] */
{ 0x9D7C,  2, 5, { 0x06, 0x03, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-61 掟	# [cjk] */
{ 0x9D7D,  2, 5, { 0x06, 0x03, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-62 掵	# [cjk] */
{ 0x9D7E,  2, 5, { 0x06, 0x03, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-63 捫	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9D80,  2, 5, { 0x06, 0x03, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-64 捩	# [cjk] */
{ 0x9D81,  2, 5, { 0x06, 0x03, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-65 掾	# [cjk] */
{ 0x9D82,  2, 5, { 0x06, 0x03, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-66 揩	# [cjk] */
{ 0x9D83,  2, 5, { 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-67 揀	# [cjk] */
{ 0x9D84,  2, 5, { 0x06, 0x03, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-68 揆	# [cjk] */
{ 0x9D85,  2, 5, { 0x06, 0x03, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-69 揣	# [cjk] */
{ 0x9D86,  2, 5, { 0x06, 0x03, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-70 揉	# [cjk] */
{ 0x9D87,  2, 5, { 0x06, 0x03, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-71 插	# [cjk] */
{ 0x9D88,  2, 5, { 0x06, 0x03, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-72 揶	# [cjk] */
{ 0x9D89,  2, 5, { 0x06, 0x03, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-73 揄	# [cjk] */
{ 0x9D8A,  2, 5, { 0x06, 0x04, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-74 搖	# [cjk] */
{ 0x9D8B,  2, 5, { 0x06, 0x04, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-75 搴	# [cjk] */
{ 0x9D8C,  2, 5, { 0x06, 0x04, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-76 搆	# [cjk] */
{ 0x9D8D,  2, 5, { 0x06, 0x04, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-77 搓	# [cjk] */
{ 0x9D8E,  2, 5, { 0x06, 0x04, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-78 搦	# [cjk] */
{ 0x9D8F,  2, 5, { 0x06, 0x04, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-79 搶	# [cjk] */
{ 0x9D90,  2, 5, { 0x06, 0x05, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-80 攝	# [cjk] */
{ 0x9D91,  2, 5, { 0x06, 0x04, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-81 搗	# [cjk] */
{ 0x9D92,  2, 5, { 0x06, 0x04, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-82 搨	# [cjk] */
{ 0x9D93,  2, 5, { 0x06, 0x04, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-83 搏	# [cjk] */
{ 0x9D94,  2, 5, { 0x06, 0x04, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-84 摧	# [cjk] */
{ 0x9D95,  2, 5, { 0x06, 0x04, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-85 摯	# [cjk] */
{ 0x9D96,  2, 5, { 0x06, 0x04, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-86 摶	# [cjk] */
{ 0x9D97,  2, 5, { 0x06, 0x04, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-87 摎	# [cjk] */
{ 0x9D98,  2, 5, { 0x06, 0x05, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-88 攪	# [cjk] */
{ 0x9D99,  2, 5, { 0x06, 0x04, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-89 撕	# [cjk] */
{ 0x9D9A,  2, 5, { 0x06, 0x04, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-90 撓	# [cjk] */
{ 0x9D9B,  2, 5, { 0x06, 0x04, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-91 撥	# [cjk] */
{ 0x9D9C,  2, 5, { 0x06, 0x04, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-92 撩	# [cjk] */
{ 0x9D9D,  2, 5, { 0x06, 0x04, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-93 撈	# [cjk] */
{ 0x9D9E,  2, 5, { 0x06, 0x04, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-57-94 撼	# [cjk] */
{ 0x9D9F,  2, 5, { 0x06, 0x04, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-01 據	# [cjk] */
{ 0x9DA0,  2, 5, { 0x06, 0x04, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-02 擒	# [cjk] */
{ 0x9DA1,  2, 5, { 0x06, 0x04, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-03 擅	# [cjk] */
{ 0x9DA2,  2, 5, { 0x06, 0x04, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-04 擇	# [cjk] */
{ 0x9DA3,  2, 5, { 0x06, 0x04, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-05 撻	# [cjk] */
{ 0x9DA4,  2, 5, { 0x06, 0x04, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-06 擘	# [cjk] */
{ 0x9DA5,  2, 5, { 0x06, 0x04, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-07 擂	# [cjk] */
{ 0x9DA6,  2, 5, { 0x06, 0x04, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-08 擱	# [cjk] */
{ 0x9DA7,  2, 5, { 0x06, 0x04, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-09 擧	# [cjk] */
{ 0x9DA8,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-10 舉	# [cjk] */
{ 0x9DA9,  2, 5, { 0x06, 0x04, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-11 擠	# [cjk] */
{ 0x9DAA,  2, 5, { 0x06, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-12 擡	# [cjk] */
{ 0x9DAB,  2, 5, { 0x06, 0x02, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-13 抬	# [cjk] */
{ 0x9DAC,  2, 5, { 0x06, 0x04, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-14 擣	# [cjk] */
{ 0x9DAD,  2, 5, { 0x06, 0x04, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-15 擯	# [cjk] */
{ 0x9DAE,  2, 5, { 0x06, 0x05, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-16 攬	# [cjk] */
{ 0x9DAF,  2, 5, { 0x06, 0x04, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-17 擶	# [cjk] */
{ 0x9DB0,  2, 5, { 0x06, 0x04, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-18 擴	# [cjk] */
{ 0x9DB1,  2, 5, { 0x06, 0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-19 擲	# [cjk] */
{ 0x9DB2,  2, 5, { 0x06, 0x04, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-20 擺	# [cjk] */
{ 0x9DB3,  2, 5, { 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-21 攀	# [cjk] */
{ 0x9DB4,  2, 5, { 0x06, 0x04, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-22 擽	# [cjk] */
{ 0x9DB5,  2, 5, { 0x06, 0x05, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-23 攘	# [cjk] */
{ 0x9DB6,  2, 5, { 0x06, 0x05, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-24 攜	# [cjk] */
{ 0x9DB7,  2, 5, { 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-25 攅	# [cjk] */
{ 0x9DB8,  2, 5, { 0x06, 0x05, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-26 攤	# [cjk] */
{ 0x9DB9,  2, 5, { 0x06, 0x05, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-27 攣	# [cjk] */
{ 0x9DBA,  2, 5, { 0x06, 0x05, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-28 攫	# [cjk] */
{ 0x9DBB,  2, 5, { 0x06, 0x05, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-29 攴	# [cjk] */
{ 0x9DBC,  2, 5, { 0x06, 0x05, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-30 攵	# [cjk] */
{ 0x9DBD,  2, 5, { 0x06, 0x05, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-31 攷	# [cjk] */
{ 0x9DBE,  2, 5, { 0x06, 0x05, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-32 收	# [cjk] */
{ 0x9DBF,  2, 5, { 0x06, 0x05, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-33 攸	# [cjk] */
{ 0x9DC0,  2, 5, { 0x07, 0x05, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-34 畋	# [cjk] */
{ 0x9DC1,  2, 5, { 0x06, 0x05, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-35 效	# [cjk] */
{ 0x9DC2,  2, 5, { 0x06, 0x05, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-36 敖	# [cjk] */
{ 0x9DC3,  2, 5, { 0x06, 0x05, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-37 敕	# [cjk] */
{ 0x9DC4,  2, 5, { 0x06, 0x05, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-38 敍	# [cjk] */
{ 0x9DC5,  2, 5, { 0x06, 0x05, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-39 敘	# [cjk] */
{ 0x9DC6,  2, 5, { 0x06, 0x05, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-40 敞	# [cjk] */
{ 0x9DC7,  2, 5, { 0x06, 0x05, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-41 敝	# [cjk] */
{ 0x9DC8,  2, 5, { 0x06, 0x05, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-42 敲	# [cjk] */
{ 0x9DC9,  2, 5, { 0x06, 0x05, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-43 數	# [cjk] */
{ 0x9DCA,  2, 5, { 0x06, 0x05, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-44 斂	# [cjk] */
{ 0x9DCB,  2, 5, { 0x06, 0x05, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-45 斃	# [cjk] */
{ 0x9DCC,  2, 5, { 0x08, 0x0b, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-46 變	# [cjk] */
{ 0x9DCD,  2, 5, { 0x06, 0x05, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-47 斛	# [cjk] */
{ 0x9DCE,  2, 5, { 0x06, 0x05, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-48 斟	# [cjk] */
{ 0x9DCF,  2, 5, { 0x06, 0x05, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-49 斫	# [cjk] */
{ 0x9DD0,  2, 5, { 0x06, 0x05, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-50 斷	# [cjk] */
{ 0x9DD1,  2, 5, { 0x06, 0x05, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-51 旃	# [cjk] */
{ 0x9DD2,  2, 5, { 0x06, 0x05, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-52 旆	# [cjk] */
{ 0x9DD3,  2, 5, { 0x06, 0x05, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-53 旁	# [cjk] */
{ 0x9DD4,  2, 5, { 0x06, 0x05, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-54 旄	# [cjk] */
{ 0x9DD5,  2, 5, { 0x06, 0x05, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-55 旌	# [cjk] */
{ 0x9DD6,  2, 5, { 0x06, 0x05, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-56 旒	# [cjk] */
{ 0x9DD7,  2, 5, { 0x06, 0x05, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-57 旛	# [cjk] */
{ 0x9DD8,  2, 5, { 0x06, 0x05, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-58 旙	# [cjk] */
{ 0x9DD9,  2, 5, { 0x06, 0x05, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-59 无	# [cjk] */
{ 0x9DDA,  2, 5, { 0x06, 0x05, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-60 旡	# [cjk] */
{ 0x9DDB,  2, 5, { 0x06, 0x05, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-61 旱	# [cjk] */
{ 0x9DDC,  2, 5, { 0x06, 0x07, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-62 杲	# [cjk] */
{ 0x9DDD,  2, 5, { 0x06, 0x06, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-63 昊	# [cjk] */
{ 0x9DDE,  2, 5, { 0x06, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-64 昃	# [cjk] */
{ 0x9DDF,  2, 5, { 0x06, 0x05, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-65 旻	# [cjk] */
{ 0x9DE0,  2, 5, { 0x06, 0x07, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-66 杳	# [cjk] */
{ 0x9DE1,  2, 5, { 0x06, 0x06, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-67 昵	# [cjk] */
{ 0x9DE2,  2, 5, { 0x06, 0x06, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-68 昶	# [cjk] */
{ 0x9DE3,  2, 5, { 0x06, 0x06, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-69 昴	# [cjk] */
{ 0x9DE4,  2, 5, { 0x06, 0x06, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-70 昜	# [cjk] */
{ 0x9DE5,  2, 5, { 0x06, 0x06, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-71 晏	# [cjk] */
{ 0x9DE6,  2, 5, { 0x06, 0x06, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-72 晄	# [cjk] */
{ 0x9DE7,  2, 5, { 0x06, 0x06, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-73 晉	# [cjk] */
{ 0x9DE8,  2, 5, { 0x06, 0x06, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-74 晁	# [cjk] */
{ 0x9DE9,  2, 5, { 0x06, 0x06, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-75 晞	# [cjk] */
{ 0x9DEA,  2, 5, { 0x06, 0x06, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-76 晝	# [cjk] */
{ 0x9DEB,  2, 5, { 0x06, 0x06, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-77 晤	# [cjk] */
{ 0x9DEC,  2, 5, { 0x06, 0x06, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-78 晧	# [cjk] */
{ 0x9DED,  2, 5, { 0x06, 0x06, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-79 晨	# [cjk] */
{ 0x9DEE,  2, 5, { 0x06, 0x06, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-80 晟	# [cjk] */
{ 0x9DEF,  2, 5, { 0x06, 0x06, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-81 晢	# [cjk] */
{ 0x9DF0,  2, 5, { 0x06, 0x06, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-82 晰	# [cjk] */
{ 0x9DF1,  2, 5, { 0x06, 0x06, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-83 暃	# [cjk] */
{ 0x9DF2,  2, 5, { 0x06, 0x06, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-84 暈	# [cjk] */
{ 0x9DF3,  2, 5, { 0x06, 0x06, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-85 暎	# [cjk] */
{ 0x9DF4,  2, 5, { 0x06, 0x06, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-86 暉	# [cjk] */
{ 0x9DF5,  2, 5, { 0x06, 0x06, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-87 暄	# [cjk] */
{ 0x9DF6,  2, 5, { 0x06, 0x06, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-88 暘	# [cjk] */
{ 0x9DF7,  2, 5, { 0x06, 0x06, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-89 暝	# [cjk] */
{ 0x9DF8,  2, 5, { 0x06, 0x06, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-90 曁	# [cjk] */
{ 0x9DF9,  2, 5, { 0x06, 0x06, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-91 暹	# [cjk] */
{ 0x9DFA,  2, 5, { 0x06, 0x06, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-92 曉	# [cjk] */
{ 0x9DFB,  2, 5, { 0x06, 0x06, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-93 暾	# [cjk] */
{ 0x9DFC,  2, 5, { 0x06, 0x06, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-58-94 暼	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9E40,  2, 5, { 0x06, 0x06, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-01 曄	# [cjk] */
{ 0x9E41,  2, 5, { 0x06, 0x06, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-02 暸	# [cjk] */
{ 0x9E42,  2, 5, { 0x06, 0x06, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-03 曖	# [cjk] */
{ 0x9E43,  2, 5, { 0x06, 0x06, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-04 曚	# [cjk] */
{ 0x9E44,  2, 5, { 0x06, 0x06, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-05 曠	# [cjk] */
{ 0x9E45,  2, 5, { 0x06, 0x06, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-06 昿	# [cjk] */
{ 0x9E46,  2, 5, { 0x06, 0x06, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-07 曦	# [cjk] */
{ 0x9E47,  2, 5, { 0x06, 0x06, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-08 曩	# [cjk] */
{ 0x9E48,  2, 5, { 0x06, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-09 曰	# [cjk] */
{ 0x9E49,  2, 5, { 0x06, 0x06, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-10 曵	# [cjk] */
{ 0x9E4A,  2, 5, { 0x06, 0x06, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-11 曷	# [cjk] */
{ 0x9E4B,  2, 5, { 0x06, 0x07, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-12 朏	# [cjk] */
{ 0x9E4C,  2, 5, { 0x06, 0x07, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-13 朖	# [cjk] */
{ 0x9E4D,  2, 5, { 0x06, 0x07, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-14 朞	# [cjk] */
{ 0x9E4E,  2, 5, { 0x06, 0x07, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-15 朦	# [cjk] */
{ 0x9E4F,  2, 5, { 0x06, 0x07, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-16 朧	# [cjk] */
{ 0x9E50,  2, 5, { 0x09, 0x07, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-17 霸	# [cjk] */
{ 0x9E51,  2, 5, { 0x06, 0x07, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-18 朮	# [cjk] */
{ 0x9E52,  2, 5, { 0x06, 0x07, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-19 朿	# [cjk] */
{ 0x9E53,  2, 5, { 0x06, 0x07, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-20 朶	# [cjk] */
{ 0x9E54,  2, 5, { 0x06, 0x07, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-21 杁	# [cjk] */
{ 0x9E55,  2, 5, { 0x06, 0x07, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-22 朸	# [cjk] */
{ 0x9E56,  2, 5, { 0x06, 0x07, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-23 朷	# [cjk] */
{ 0x9E57,  2, 5, { 0x06, 0x07, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-24 杆	# [cjk] */
{ 0x9E58,  2, 5, { 0x06, 0x07, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-25 杞	# [cjk] */
{ 0x9E59,  2, 5, { 0x06, 0x07, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-26 杠	# [cjk] */
{ 0x9E5A,  2, 5, { 0x06, 0x07, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-27 杙	# [cjk] */
{ 0x9E5B,  2, 5, { 0x06, 0x07, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-28 杣	# [cjk] */
{ 0x9E5C,  2, 5, { 0x06, 0x07, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-29 杤	# [cjk] */
{ 0x9E5D,  2, 5, { 0x06, 0x07, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-30 枉	# [cjk] */
{ 0x9E5E,  2, 5, { 0x06, 0x07, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-31 杰	# [cjk] */
{ 0x9E5F,  2, 5, { 0x06, 0x07, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-32 枩	# [cjk] */
{ 0x9E60,  2, 5, { 0x06, 0x07, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-33 杼	# [cjk] */
{ 0x9E61,  2, 5, { 0x06, 0x07, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-34 杪	# [cjk] */
{ 0x9E62,  2, 5, { 0x06, 0x07, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-35 枌	# [cjk] */
{ 0x9E63,  2, 5, { 0x06, 0x07, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-36 枋	# [cjk] */
{ 0x9E64,  2, 5, { 0x06, 0x07, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-37 枦	# [cjk] */
{ 0x9E65,  2, 5, { 0x06, 0x07, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-38 枡	# [cjk] */
{ 0x9E66,  2, 5, { 0x06, 0x07, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-39 枅	# [cjk] */
{ 0x9E67,  2, 5, { 0x06, 0x07, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-40 枷	# [cjk] */
{ 0x9E68,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-41 柯	# [cjk] */
{ 0x9E69,  2, 5, { 0x06, 0x07, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-42 枴	# [cjk] */
{ 0x9E6A,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-43 柬	# [cjk] */
{ 0x9E6B,  2, 5, { 0x06, 0x07, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-44 枳	# [cjk] */
{ 0x9E6C,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-45 柩	# [cjk] */
{ 0x9E6D,  2, 5, { 0x06, 0x07, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-46 枸	# [cjk] */
{ 0x9E6E,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-47 柤	# [cjk] */
{ 0x9E6F,  2, 5, { 0x06, 0x07, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-48 柞	# [cjk] */
{ 0x9E70,  2, 5, { 0x06, 0x07, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-49 柝	# [cjk] */
{ 0x9E71,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-50 柢	# [cjk] */
{ 0x9E72,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-51 柮	# [cjk] */
{ 0x9E73,  2, 5, { 0x06, 0x07, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-52 枹	# [cjk] */
{ 0x9E74,  2, 5, { 0x06, 0x07, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-53 柎	# [cjk] */
{ 0x9E75,  2, 5, { 0x06, 0x07, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-54 柆	# [cjk] */
{ 0x9E76,  2, 5, { 0x06, 0x07, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-55 柧	# [cjk] */
{ 0x9E77,  2, 5, { 0x06, 0x0a, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-56 檜	# [cjk] */
{ 0x9E78,  2, 5, { 0x06, 0x08, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-57 栞	# [cjk] */
{ 0x9E79,  2, 5, { 0x06, 0x08, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-58 框	# [cjk] */
{ 0x9E7A,  2, 5, { 0x06, 0x08, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-59 栩	# [cjk] */
{ 0x9E7B,  2, 5, { 0x06, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-60 桀	# [cjk] */
{ 0x9E7C,  2, 5, { 0x06, 0x08, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-61 桍	# [cjk] */
{ 0x9E7D,  2, 5, { 0x06, 0x08, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-62 栲	# [cjk] */
{ 0x9E7E,  2, 5, { 0x06, 0x08, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-63 桎	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9E80,  2, 5, { 0x06, 0x08, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-64 梳	# [cjk] */
{ 0x9E81,  2, 5, { 0x06, 0x08, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-65 栫	# [cjk] */
{ 0x9E82,  2, 5, { 0x06, 0x08, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-66 桙	# [cjk] */
{ 0x9E83,  2, 5, { 0x06, 0x08, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-67 档	# [cjk] */
{ 0x9E84,  2, 5, { 0x06, 0x08, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-68 桷	# [cjk] */
{ 0x9E85,  2, 5, { 0x06, 0x08, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-69 桿	# [cjk] */
{ 0x9E86,  2, 5, { 0x06, 0x08, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-70 梟	# [cjk] */
{ 0x9E87,  2, 5, { 0x06, 0x08, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-71 梏	# [cjk] */
{ 0x9E88,  2, 5, { 0x06, 0x08, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-72 梭	# [cjk] */
{ 0x9E89,  2, 5, { 0x06, 0x08, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-73 梔	# [cjk] */
{ 0x9E8A,  2, 5, { 0x06, 0x08, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-74 條	# [cjk] */
{ 0x9E8B,  2, 5, { 0x06, 0x08, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-75 梛	# [cjk] */
{ 0x9E8C,  2, 5, { 0x06, 0x08, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-76 梃	# [cjk] */
{ 0x9E8D,  2, 5, { 0x06, 0x0a, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-77 檮	# [cjk] */
{ 0x9E8E,  2, 5, { 0x06, 0x08, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-78 梹	# [cjk] */
{ 0x9E8F,  2, 5, { 0x06, 0x08, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-79 桴	# [cjk] */
{ 0x9E90,  2, 5, { 0x06, 0x08, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-80 梵	# [cjk] */
{ 0x9E91,  2, 5, { 0x06, 0x08, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-81 梠	# [cjk] */
{ 0x9E92,  2, 5, { 0x06, 0x08, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-82 梺	# [cjk] */
{ 0x9E93,  2, 5, { 0x06, 0x09, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-83 椏	# [cjk] */
{ 0x9E94,  2, 5, { 0x06, 0x08, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-84 梍	# [cjk] */
{ 0x9E95,  2, 5, { 0x06, 0x08, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-85 桾	# [cjk] */
{ 0x9E96,  2, 5, { 0x06, 0x09, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-86 椁	# [cjk] */
{ 0x9E97,  2, 5, { 0x06, 0x08, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-87 棊	# [cjk] */
{ 0x9E98,  2, 5, { 0x06, 0x09, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-88 椈	# [cjk] */
{ 0x9E99,  2, 5, { 0x06, 0x08, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-89 棘	# [cjk] */
{ 0x9E9A,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-90 椢	# [cjk] */
{ 0x9E9B,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-91 椦	# [cjk] */
{ 0x9E9C,  2, 5, { 0x06, 0x08, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-92 棡	# [cjk] */
{ 0x9E9D,  2, 5, { 0x06, 0x09, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-93 椌	# [cjk] */
{ 0x9E9E,  2, 5, { 0x06, 0x08, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-59-94 棍	# [cjk] */
{ 0x9E9F,  2, 5, { 0x06, 0x08, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-01 棔	# [cjk] */
{ 0x9EA0,  2, 5, { 0x06, 0x08, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-02 棧	# [cjk] */
{ 0x9EA1,  2, 5, { 0x06, 0x08, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-03 棕	# [cjk] */
{ 0x9EA2,  2, 5, { 0x06, 0x09, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-04 椶	# [cjk] */
{ 0x9EA3,  2, 5, { 0x06, 0x09, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-05 椒	# [cjk] */
{ 0x9EA4,  2, 5, { 0x06, 0x09, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-06 椄	# [cjk] */
{ 0x9EA5,  2, 5, { 0x06, 0x08, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-07 棗	# [cjk] */
{ 0x9EA6,  2, 5, { 0x06, 0x08, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-08 棣	# [cjk] */
{ 0x9EA7,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-09 椥	# [cjk] */
{ 0x9EA8,  2, 5, { 0x06, 0x08, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-10 棹	# [cjk] */
{ 0x9EA9,  2, 5, { 0x06, 0x08, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-11 棠	# [cjk] */
{ 0x9EAA,  2, 5, { 0x06, 0x08, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-12 棯	# [cjk] */
{ 0x9EAB,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-13 椨	# [cjk] */
{ 0x9EAC,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-14 椪	# [cjk] */
{ 0x9EAD,  2, 5, { 0x06, 0x09, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-15 椚	# [cjk] */
{ 0x9EAE,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-16 椣	# [cjk] */
{ 0x9EAF,  2, 5, { 0x06, 0x09, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-17 椡	# [cjk] */
{ 0x9EB0,  2, 5, { 0x06, 0x08, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-18 棆	# [cjk] */
{ 0x9EB1,  2, 5, { 0x06, 0x09, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-19 楹	# [cjk] */
{ 0x9EB2,  2, 5, { 0x06, 0x09, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-20 楷	# [cjk] */
{ 0x9EB3,  2, 5, { 0x06, 0x09, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-21 楜	# [cjk] */
{ 0x9EB4,  2, 5, { 0x06, 0x09, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-22 楸	# [cjk] */
{ 0x9EB5,  2, 5, { 0x06, 0x09, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-23 楫	# [cjk] */
{ 0x9EB6,  2, 5, { 0x06, 0x09, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-24 楔	# [cjk] */
{ 0x9EB7,  2, 5, { 0x06, 0x09, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-25 楾	# [cjk] */
{ 0x9EB8,  2, 5, { 0x06, 0x09, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-26 楮	# [cjk] */
{ 0x9EB9,  2, 5, { 0x06, 0x09, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-27 椹	# [cjk] */
{ 0x9EBA,  2, 5, { 0x06, 0x09, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-28 楴	# [cjk] */
{ 0x9EBB,  2, 5, { 0x06, 0x09, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-29 椽	# [cjk] */
{ 0x9EBC,  2, 5, { 0x06, 0x09, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-30 楙	# [cjk] */
{ 0x9EBD,  2, 5, { 0x06, 0x09, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-31 椰	# [cjk] */
{ 0x9EBE,  2, 5, { 0x06, 0x09, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-32 楡	# [cjk] */
{ 0x9EBF,  2, 5, { 0x06, 0x09, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-33 楞	# [cjk] */
{ 0x9EC0,  2, 5, { 0x06, 0x09, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-34 楝	# [cjk] */
{ 0x9EC1,  2, 5, { 0x06, 0x09, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-35 榁	# [cjk] */
{ 0x9EC2,  2, 5, { 0x06, 0x09, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-36 楪	# [cjk] */
{ 0x9EC3,  2, 5, { 0x06, 0x09, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-37 榲	# [cjk] */
{ 0x9EC4,  2, 5, { 0x06, 0x09, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-38 榮	# [cjk] */
{ 0x9EC5,  2, 5, { 0x06, 0x09, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-39 槐	# [cjk] */
{ 0x9EC6,  2, 5, { 0x06, 0x09, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-40 榿	# [cjk] */
{ 0x9EC7,  2, 5, { 0x06, 0x09, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-41 槁	# [cjk] */
{ 0x9EC8,  2, 5, { 0x06, 0x09, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-42 槓	# [cjk] */
{ 0x9EC9,  2, 5, { 0x06, 0x09, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-43 榾	# [cjk] */
{ 0x9ECA,  2, 5, { 0x06, 0x09, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-44 槎	# [cjk] */
{ 0x9ECB,  2, 5, { 0x05, 0x0b, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-45 寨	# [cjk] */
{ 0x9ECC,  2, 5, { 0x06, 0x09, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-46 槊	# [cjk] */
{ 0x9ECD,  2, 5, { 0x06, 0x09, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-47 槝	# [cjk] */
{ 0x9ECE,  2, 5, { 0x06, 0x09, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-48 榻	# [cjk] */
{ 0x9ECF,  2, 5, { 0x06, 0x09, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-49 槃	# [cjk] */
{ 0x9ED0,  2, 5, { 0x06, 0x09, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-50 榧	# [cjk] */
{ 0x9ED1,  2, 5, { 0x06, 0x0a, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-51 樮	# [cjk] */
{ 0x9ED2,  2, 5, { 0x06, 0x09, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-52 榑	# [cjk] */
{ 0x9ED3,  2, 5, { 0x06, 0x09, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-53 榠	# [cjk] */
{ 0x9ED4,  2, 5, { 0x06, 0x09, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-54 榜	# [cjk] */
{ 0x9ED5,  2, 5, { 0x06, 0x09, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-55 榕	# [cjk] */
{ 0x9ED6,  2, 5, { 0x06, 0x09, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-56 榴	# [cjk] */
{ 0x9ED7,  2, 5, { 0x06, 0x09, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-57 槞	# [cjk] */
{ 0x9ED8,  2, 5, { 0x06, 0x09, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-58 槨	# [cjk] */
{ 0x9ED9,  2, 5, { 0x06, 0x0a, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-59 樂	# [cjk] */
{ 0x9EDA,  2, 5, { 0x06, 0x0a, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-60 樛	# [cjk] */
{ 0x9EDB,  2, 5, { 0x06, 0x09, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-61 槿	# [cjk] */
{ 0x9EDC,  2, 5, { 0x06, 0x0b, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-62 權	# [cjk] */
{ 0x9EDD,  2, 5, { 0x06, 0x09, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-63 槹	# [cjk] */
{ 0x9EDE,  2, 5, { 0x06, 0x09, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-64 槲	# [cjk] */
{ 0x9EDF,  2, 5, { 0x06, 0x09, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-65 槧	# [cjk] */
{ 0x9EE0,  2, 5, { 0x06, 0x0a, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-66 樅	# [cjk] */
{ 0x9EE1,  2, 5, { 0x06, 0x09, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-67 榱	# [cjk] */
{ 0x9EE2,  2, 5, { 0x06, 0x0a, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-68 樞	# [cjk] */
{ 0x9EE3,  2, 5, { 0x06, 0x09, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-69 槭	# [cjk] */
{ 0x9EE4,  2, 5, { 0x06, 0x0a, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-70 樔	# [cjk] */
{ 0x9EE5,  2, 5, { 0x06, 0x09, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-71 槫	# [cjk] */
{ 0x9EE6,  2, 5, { 0x06, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-72 樊	# [cjk] */
{ 0x9EE7,  2, 5, { 0x06, 0x0a, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-73 樒	# [cjk] */
{ 0x9EE8,  2, 5, { 0x06, 0x0a, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-74 櫁	# [cjk] */
{ 0x9EE9,  2, 5, { 0x06, 0x0a, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-75 樣	# [cjk] */
{ 0x9EEA,  2, 5, { 0x06, 0x0a, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-76 樓	# [cjk] */
{ 0x9EEB,  2, 5, { 0x06, 0x0a, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-77 橄	# [cjk] */
{ 0x9EEC,  2, 5, { 0x06, 0x0a, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-78 樌	# [cjk] */
{ 0x9EED,  2, 5, { 0x06, 0x0a, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-79 橲	# [cjk] */
{ 0x9EEE,  2, 5, { 0x06, 0x0a, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-80 樶	# [cjk] */
{ 0x9EEF,  2, 5, { 0x06, 0x0a, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-81 橸	# [cjk] */
{ 0x9EF0,  2, 5, { 0x06, 0x0a, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-82 橇	# [cjk] */
{ 0x9EF1,  2, 5, { 0x06, 0x0a, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-83 橢	# [cjk] */
{ 0x9EF2,  2, 5, { 0x06, 0x0a, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-84 橙	# [cjk] */
{ 0x9EF3,  2, 5, { 0x06, 0x0a, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-85 橦	# [cjk] */
{ 0x9EF4,  2, 5, { 0x06, 0x0a, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-86 橈	# [cjk] */
{ 0x9EF5,  2, 5, { 0x06, 0x0a, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-87 樸	# [cjk] */
{ 0x9EF6,  2, 5, { 0x06, 0x0a, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-88 樢	# [cjk] */
{ 0x9EF7,  2, 5, { 0x06, 0x0a, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-89 檐	# [cjk] */
{ 0x9EF8,  2, 5, { 0x06, 0x0a, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-90 檍	# [cjk] */
{ 0x9EF9,  2, 5, { 0x06, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-91 檠	# [cjk] */
{ 0x9EFA,  2, 5, { 0x06, 0x0a, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-92 檄	# [cjk] */
{ 0x9EFB,  2, 5, { 0x06, 0x0a, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-93 檢	# [cjk] */
{ 0x9EFC,  2, 5, { 0x06, 0x0a, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-60-94 檣	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9F40,  2, 5, { 0x06, 0x0a, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-01 檗	# [cjk] */
{ 0x9F41,  2, 5, { 0x08, 0x06, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-02 蘗	# [cjk] */
{ 0x9F42,  2, 5, { 0x06, 0x0a, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-03 檻	# [cjk] */
{ 0x9F43,  2, 5, { 0x06, 0x0a, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-04 櫃	# [cjk] */
{ 0x9F44,  2, 5, { 0x06, 0x0a, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-05 櫂	# [cjk] */
{ 0x9F45,  2, 5, { 0x06, 0x0a, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-06 檸	# [cjk] */
{ 0x9F46,  2, 5, { 0x06, 0x0a, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-07 檳	# [cjk] */
{ 0x9F47,  2, 5, { 0x06, 0x0a, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-08 檬	# [cjk] */
{ 0x9F48,  2, 5, { 0x06, 0x0a, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-09 櫞	# [cjk] */
{ 0x9F49,  2, 5, { 0x06, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-10 櫑	# [cjk] */
{ 0x9F4A,  2, 5, { 0x06, 0x0a, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-11 櫟	# [cjk] */
{ 0x9F4B,  2, 5, { 0x06, 0x0a, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-12 檪	# [cjk] */
{ 0x9F4C,  2, 5, { 0x06, 0x0a, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-13 櫚	# [cjk] */
{ 0x9F4D,  2, 5, { 0x06, 0x0a, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-14 櫪	# [cjk] */
{ 0x9F4E,  2, 5, { 0x06, 0x0a, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-15 櫻	# [cjk] */
{ 0x9F4F,  2, 5, { 0x06, 0x0b, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-16 欅	# [cjk] */
{ 0x9F50,  2, 5, { 0x08, 0x06, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-17 蘖	# [cjk] */
{ 0x9F51,  2, 5, { 0x06, 0x0a, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-18 櫺	# [cjk] */
{ 0x9F52,  2, 5, { 0x06, 0x0b, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-19 欒	# [cjk] */
{ 0x9F53,  2, 5, { 0x06, 0x0b, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-20 欖	# [cjk] */
{ 0x9F54,  2, 5, { 0x09, 0x0b, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-21 鬱	# [cjk] */
{ 0x9F55,  2, 5, { 0x06, 0x0b, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-22 欟	# [cjk] */
{ 0x9F56,  2, 5, { 0x06, 0x0b, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-23 欸	# [cjk] */
{ 0x9F57,  2, 5, { 0x06, 0x0b, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-24 欷	# [cjk] */
{ 0x9F58,  2, 5, { 0x07, 0x06, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-25 盜	# [cjk] */
{ 0x9F59,  2, 5, { 0x06, 0x0b, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-26 欹	# [cjk] */
{ 0x9F5A,  2, 5, { 0x09, 0x08, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-27 飮	# [cjk] */
{ 0x9F5B,  2, 5, { 0x06, 0x0b, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-28 歇	# [cjk] */
{ 0x9F5C,  2, 5, { 0x06, 0x0b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-29 歃	# [cjk] */
{ 0x9F5D,  2, 5, { 0x06, 0x0b, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-30 歉	# [cjk] */
{ 0x9F5E,  2, 5, { 0x06, 0x0b, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-31 歐	# [cjk] */
{ 0x9F5F,  2, 5, { 0x06, 0x0b, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-32 歙	# [cjk] */
{ 0x9F60,  2, 5, { 0x06, 0x0b, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-33 歔	# [cjk] */
{ 0x9F61,  2, 5, { 0x06, 0x0b, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-34 歛	# [cjk] */
{ 0x9F62,  2, 5, { 0x06, 0x0b, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-35 歟	# [cjk] */
{ 0x9F63,  2, 5, { 0x06, 0x0b, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-36 歡	# [cjk] */
{ 0x9F64,  2, 5, { 0x06, 0x0b, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-37 歸	# [cjk] */
{ 0x9F65,  2, 5, { 0x06, 0x0b, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-38 歹	# [cjk] */
{ 0x9F66,  2, 5, { 0x06, 0x0b, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-39 歿	# [cjk] */
{ 0x9F67,  2, 5, { 0x06, 0x0b, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-40 殀	# [cjk] */
{ 0x9F68,  2, 5, { 0x06, 0x0b, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-41 殄	# [cjk] */
{ 0x9F69,  2, 5, { 0x06, 0x0b, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-42 殃	# [cjk] */
{ 0x9F6A,  2, 5, { 0x06, 0x0b, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-43 殍	# [cjk] */
{ 0x9F6B,  2, 5, { 0x06, 0x0b, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-44 殘	# [cjk] */
{ 0x9F6C,  2, 5, { 0x06, 0x0b, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-45 殕	# [cjk] */
{ 0x9F6D,  2, 5, { 0x06, 0x0b, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-46 殞	# [cjk] */
{ 0x9F6E,  2, 5, { 0x06, 0x0b, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-47 殤	# [cjk] */
{ 0x9F6F,  2, 5, { 0x06, 0x0b, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-48 殪	# [cjk] */
{ 0x9F70,  2, 5, { 0x06, 0x0b, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-49 殫	# [cjk] */
{ 0x9F71,  2, 5, { 0x06, 0x0b, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-50 殯	# [cjk] */
{ 0x9F72,  2, 5, { 0x06, 0x0b, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-51 殲	# [cjk] */
{ 0x9F73,  2, 5, { 0x06, 0x0b, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-52 殱	# [cjk] */
{ 0x9F74,  2, 5, { 0x06, 0x0b, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-53 殳	# [cjk] */
{ 0x9F75,  2, 5, { 0x06, 0x0b, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-54 殷	# [cjk] */
{ 0x9F76,  2, 5, { 0x06, 0x0b, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-55 殼	# [cjk] */
{ 0x9F77,  2, 5, { 0x06, 0x0b, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-56 毆	# [cjk] */
{ 0x9F78,  2, 5, { 0x06, 0x0b, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-57 毋	# [cjk] */
{ 0x9F79,  2, 5, { 0x06, 0x0b, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-58 毓	# [cjk] */
{ 0x9F7A,  2, 5, { 0x06, 0x0b, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-59 毟	# [cjk] */
{ 0x9F7B,  2, 5, { 0x06, 0x0b, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-60 毬	# [cjk] */
{ 0x9F7C,  2, 5, { 0x06, 0x0b, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-61 毫	# [cjk] */
{ 0x9F7D,  2, 5, { 0x06, 0x0b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-62 毳	# [cjk] */
{ 0x9F7E,  2, 5, { 0x06, 0x0b, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-63 毯	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x9F80,  2, 5, { 0x09, 0x0e, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-64 麾	# [cjk] */
{ 0x9F81,  2, 5, { 0x06, 0x0c, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-65 氈	# [cjk] */
{ 0x9F82,  2, 5, { 0x06, 0x0c, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-66 氓	# [cjk] */
{ 0x9F83,  2, 5, { 0x06, 0x0c, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-67 气	# [cjk] */
{ 0x9F84,  2, 5, { 0x06, 0x0c, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-68 氛	# [cjk] */
{ 0x9F85,  2, 5, { 0x06, 0x0c, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-69 氤	# [cjk] */
{ 0x9F86,  2, 5, { 0x06, 0x0c, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-70 氣	# [cjk] */
{ 0x9F87,  2, 5, { 0x06, 0x0c, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-71 汞	# [cjk] */
{ 0x9F88,  2, 5, { 0x06, 0x0c, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-72 汕	# [cjk] */
{ 0x9F89,  2, 5, { 0x06, 0x0c, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-73 汢	# [cjk] */
{ 0x9F8A,  2, 5, { 0x06, 0x0c, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-74 汪	# [cjk] */
{ 0x9F8B,  2, 5, { 0x06, 0x0c, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-75 沂	# [cjk] */
{ 0x9F8C,  2, 5, { 0x06, 0x0c, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-76 沍	# [cjk] */
{ 0x9F8D,  2, 5, { 0x06, 0x0c, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-77 沚	# [cjk] */
{ 0x9F8E,  2, 5, { 0x06, 0x0c, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-78 沁	# [cjk] */
{ 0x9F8F,  2, 5, { 0x06, 0x0c, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-79 沛	# [cjk] */
{ 0x9F90,  2, 5, { 0x06, 0x0c, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-80 汾	# [cjk] */
{ 0x9F91,  2, 5, { 0x06, 0x0c, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-81 汨	# [cjk] */
{ 0x9F92,  2, 5, { 0x06, 0x0c, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-82 汳	# [cjk] */
{ 0x9F93,  2, 5, { 0x06, 0x0c, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-83 沒	# [cjk] */
{ 0x9F94,  2, 5, { 0x06, 0x0c, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-84 沐	# [cjk] */
{ 0x9F95,  2, 5, { 0x06, 0x0c, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-85 泄	# [cjk] */
{ 0x9F96,  2, 5, { 0x06, 0x0c, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-86 泱	# [cjk] */
{ 0x9F97,  2, 5, { 0x06, 0x0c, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-87 泓	# [cjk] */
{ 0x9F98,  2, 5, { 0x06, 0x0c, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-88 沽	# [cjk] */
{ 0x9F99,  2, 5, { 0x06, 0x0c, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-89 泗	# [cjk] */
{ 0x9F9A,  2, 5, { 0x06, 0x0c, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-90 泅	# [cjk] */
{ 0x9F9B,  2, 5, { 0x06, 0x0c, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-91 泝	# [cjk] */
{ 0x9F9C,  2, 5, { 0x06, 0x0c, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-92 沮	# [cjk] */
{ 0x9F9D,  2, 5, { 0x06, 0x0c, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-93 沱	# [cjk] */
{ 0x9F9E,  2, 5, { 0x06, 0x0c, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-61-94 沾	# [cjk] */
{ 0x9F9F,  2, 5, { 0x06, 0x0c, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-01 沺	# [cjk] */
{ 0x9FA0,  2, 5, { 0x06, 0x0c, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-02 泛	# [cjk] */
{ 0x9FA1,  2, 5, { 0x06, 0x0c, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-03 泯	# [cjk] */
{ 0x9FA2,  2, 5, { 0x06, 0x0c, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-04 泙	# [cjk] */
{ 0x9FA3,  2, 5, { 0x06, 0x0c, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-05 泪	# [cjk] */
{ 0x9FA4,  2, 5, { 0x06, 0x0d, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-06 洟	# [cjk] */
{ 0x9FA5,  2, 5, { 0x08, 0x08, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-07 衍	# [cjk] */
{ 0x9FA6,  2, 5, { 0x06, 0x0d, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-08 洶	# [cjk] */
{ 0x9FA7,  2, 5, { 0x06, 0x0d, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-09 洫	# [cjk] */
{ 0x9FA8,  2, 5, { 0x06, 0x0d, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-10 洽	# [cjk] */
{ 0x9FA9,  2, 5, { 0x06, 0x0d, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-11 洸	# [cjk] */
{ 0x9FAA,  2, 5, { 0x06, 0x0d, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-12 洙	# [cjk] */
{ 0x9FAB,  2, 5, { 0x06, 0x0d, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-13 洵	# [cjk] */
{ 0x9FAC,  2, 5, { 0x06, 0x0d, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-14 洳	# [cjk] */
{ 0x9FAD,  2, 5, { 0x06, 0x0d, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-15 洒	# [cjk] */
{ 0x9FAE,  2, 5, { 0x06, 0x0d, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-16 洌	# [cjk] */
{ 0x9FAF,  2, 5, { 0x06, 0x0d, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-17 浣	# [cjk] */
{ 0x9FB0,  2, 5, { 0x06, 0x0d, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-18 涓	# [cjk] */
{ 0x9FB1,  2, 5, { 0x06, 0x0d, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-19 浤	# [cjk] */
{ 0x9FB2,  2, 5, { 0x06, 0x0d, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-20 浚	# [cjk] */
{ 0x9FB3,  2, 5, { 0x06, 0x0d, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-21 浹	# [cjk] */
{ 0x9FB4,  2, 5, { 0x06, 0x0d, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-22 浙	# [cjk] */
{ 0x9FB5,  2, 5, { 0x06, 0x0d, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-23 涎	# [cjk] */
{ 0x9FB6,  2, 5, { 0x06, 0x0d, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-24 涕	# [cjk] */
{ 0x9FB7,  2, 5, { 0x06, 0x0f, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-25 濤	# [cjk] */
{ 0x9FB8,  2, 5, { 0x06, 0x0d, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-26 涅	# [cjk] */
{ 0x9FB9,  2, 5, { 0x06, 0x0d, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-27 淹	# [cjk] */
{ 0x9FBA,  2, 5, { 0x06, 0x0e, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-28 渕	# [cjk] */
{ 0x9FBB,  2, 5, { 0x06, 0x0e, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-29 渊	# [cjk] */
{ 0x9FBC,  2, 5, { 0x06, 0x0d, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-30 涵	# [cjk] */
{ 0x9FBD,  2, 5, { 0x06, 0x0d, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-31 淇	# [cjk] */
{ 0x9FBE,  2, 5, { 0x06, 0x0d, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-32 淦	# [cjk] */
{ 0x9FBF,  2, 5, { 0x06, 0x0d, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-33 涸	# [cjk] */
{ 0x9FC0,  2, 5, { 0x06, 0x0d, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-34 淆	# [cjk] */
{ 0x9FC1,  2, 5, { 0x06, 0x0d, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-35 淬	# [cjk] */
{ 0x9FC2,  2, 5, { 0x06, 0x0d, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-36 淞	# [cjk] */
{ 0x9FC3,  2, 5, { 0x06, 0x0d, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-37 淌	# [cjk] */
{ 0x9FC4,  2, 5, { 0x06, 0x0d, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-38 淨	# [cjk] */
{ 0x9FC5,  2, 5, { 0x06, 0x0d, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-39 淒	# [cjk] */
{ 0x9FC6,  2, 5, { 0x06, 0x0d, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-40 淅	# [cjk] */
{ 0x9FC7,  2, 5, { 0x06, 0x0d, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-41 淺	# [cjk] */
{ 0x9FC8,  2, 5, { 0x06, 0x0d, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-42 淙	# [cjk] */
{ 0x9FC9,  2, 5, { 0x06, 0x0d, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-43 淤	# [cjk] */
{ 0x9FCA,  2, 5, { 0x06, 0x0d, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-44 淕	# [cjk] */
{ 0x9FCB,  2, 5, { 0x06, 0x0d, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-45 淪	# [cjk] */
{ 0x9FCC,  2, 5, { 0x06, 0x0d, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-46 淮	# [cjk] */
{ 0x9FCD,  2, 5, { 0x06, 0x0e, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-47 渭	# [cjk] */
{ 0x9FCE,  2, 5, { 0x06, 0x0e, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-48 湮	# [cjk] */
{ 0x9FCF,  2, 5, { 0x06, 0x0e, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-49 渮	# [cjk] */
{ 0x9FD0,  2, 5, { 0x06, 0x0e, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-50 渙	# [cjk] */
{ 0x9FD1,  2, 5, { 0x06, 0x0e, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-51 湲	# [cjk] */
{ 0x9FD2,  2, 5, { 0x06, 0x0e, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-52 湟	# [cjk] */
{ 0x9FD3,  2, 5, { 0x06, 0x0e, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-53 渾	# [cjk] */
{ 0x9FD4,  2, 5, { 0x06, 0x0e, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-54 渣	# [cjk] */
{ 0x9FD5,  2, 5, { 0x06, 0x0e, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-55 湫	# [cjk] */
{ 0x9FD6,  2, 5, { 0x06, 0x0e, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-56 渫	# [cjk] */
{ 0x9FD7,  2, 5, { 0x06, 0x0e, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-57 湶	# [cjk] */
{ 0x9FD8,  2, 5, { 0x06, 0x0e, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-58 湍	# [cjk] */
{ 0x9FD9,  2, 5, { 0x06, 0x0e, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-59 渟	# [cjk] */
{ 0x9FDA,  2, 5, { 0x06, 0x0e, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-60 湃	# [cjk] */
{ 0x9FDB,  2, 5, { 0x06, 0x0e, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-61 渺	# [cjk] */
{ 0x9FDC,  2, 5, { 0x06, 0x0e, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-62 湎	# [cjk] */
{ 0x9FDD,  2, 5, { 0x06, 0x0e, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-63 渤	# [cjk] */
{ 0x9FDE,  2, 5, { 0x06, 0x0e, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-64 滿	# [cjk] */
{ 0x9FDF,  2, 5, { 0x06, 0x0e, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-65 渝	# [cjk] */
{ 0x9FE0,  2, 5, { 0x06, 0x0e, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-66 游	# [cjk] */
{ 0x9FE1,  2, 5, { 0x06, 0x0e, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-67 溂	# [cjk] */
{ 0x9FE2,  2, 5, { 0x06, 0x0e, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-68 溪	# [cjk] */
{ 0x9FE3,  2, 5, { 0x06, 0x0e, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-69 溘	# [cjk] */
{ 0x9FE4,  2, 5, { 0x06, 0x0e, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-70 滉	# [cjk] */
{ 0x9FE5,  2, 5, { 0x06, 0x0e, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-71 溷	# [cjk] */
{ 0x9FE6,  2, 5, { 0x06, 0x0e, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-72 滓	# [cjk] */
{ 0x9FE7,  2, 5, { 0x06, 0x0e, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-73 溽	# [cjk] */
{ 0x9FE8,  2, 5, { 0x06, 0x0e, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-74 溯	# [cjk] */
{ 0x9FE9,  2, 5, { 0x06, 0x0e, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-75 滄	# [cjk] */
{ 0x9FEA,  2, 5, { 0x06, 0x0e, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-76 溲	# [cjk] */
{ 0x9FEB,  2, 5, { 0x06, 0x0e, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-77 滔	# [cjk] */
{ 0x9FEC,  2, 5, { 0x06, 0x0e, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-78 滕	# [cjk] */
{ 0x9FED,  2, 5, { 0x06, 0x0e, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-79 溏	# [cjk] */
{ 0x9FEE,  2, 5, { 0x06, 0x0e, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-80 溥	# [cjk] */
{ 0x9FEF,  2, 5, { 0x06, 0x0e, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-81 滂	# [cjk] */
{ 0x9FF0,  2, 5, { 0x06, 0x0e, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-82 溟	# [cjk] */
{ 0x9FF1,  2, 5, { 0x06, 0x0f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-83 潁	# [cjk] */
{ 0x9FF2,  2, 5, { 0x06, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-84 漑	# [cjk] */
{ 0x9FF3,  2, 5, { 0x07, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-85 灌	# [cjk] */
{ 0x9FF4,  2, 5, { 0x06, 0x0e, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-86 滬	# [cjk] */
{ 0x9FF5,  2, 5, { 0x06, 0x0e, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-87 滸	# [cjk] */
{ 0x9FF6,  2, 5, { 0x06, 0x0e, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-88 滾	# [cjk] */
{ 0x9FF7,  2, 5, { 0x06, 0x0f, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-89 漿	# [cjk] */
{ 0x9FF8,  2, 5, { 0x06, 0x0e, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-90 滲	# [cjk] */
{ 0x9FF9,  2, 5, { 0x06, 0x0f, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-91 漱	# [cjk] */
{ 0x9FFA,  2, 5, { 0x06, 0x0e, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-92 滯	# [cjk] */
{ 0x9FFB,  2, 5, { 0x06, 0x0f, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-93 漲	# [cjk] */
{ 0x9FFC,  2, 5, { 0x06, 0x0e, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-62-94 滌	# [cjk] */
{ 0xE040,  2, 5, { 0x06, 0x0f, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-01 漾	# [cjk] */
{ 0xE041,  2, 5, { 0x06, 0x0f, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-02 漓	# [cjk] */
{ 0xE042,  2, 5, { 0x06, 0x0e, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-03 滷	# [cjk] */
{ 0xE043,  2, 5, { 0x06, 0x0f, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-04 澆	# [cjk] */
{ 0xE044,  2, 5, { 0x06, 0x0f, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-05 潺	# [cjk] */
{ 0xE045,  2, 5, { 0x06, 0x0f, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-06 潸	# [cjk] */
{ 0xE046,  2, 5, { 0x06, 0x0f, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-07 澁	# [cjk] */
{ 0xE047,  2, 5, { 0x06, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-08 澀	# [cjk] */
{ 0xE048,  2, 5, { 0x06, 0x0f, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-09 潯	# [cjk] */
{ 0xE049,  2, 5, { 0x06, 0x0f, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-10 潛	# [cjk] */
{ 0xE04A,  2, 5, { 0x06, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-11 濳	# [cjk] */
{ 0xE04B,  2, 5, { 0x06, 0x0f, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-12 潭	# [cjk] */
{ 0xE04C,  2, 5, { 0x06, 0x0f, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-13 澂	# [cjk] */
{ 0xE04D,  2, 5, { 0x06, 0x0f, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-14 潼	# [cjk] */
{ 0xE04E,  2, 5, { 0x06, 0x0f, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-15 潘	# [cjk] */
{ 0xE04F,  2, 5, { 0x06, 0x0f, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-16 澎	# [cjk] */
{ 0xE050,  2, 5, { 0x06, 0x0f, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-17 澑	# [cjk] */
{ 0xE051,  2, 5, { 0x06, 0x0f, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-18 濂	# [cjk] */
{ 0xE052,  2, 5, { 0x06, 0x0f, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-19 潦	# [cjk] */
{ 0xE053,  2, 5, { 0x06, 0x0f, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-20 澳	# [cjk] */
{ 0xE054,  2, 5, { 0x06, 0x0f, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-21 澣	# [cjk] */
{ 0xE055,  2, 5, { 0x06, 0x0f, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-22 澡	# [cjk] */
{ 0xE056,  2, 5, { 0x06, 0x0f, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-23 澤	# [cjk] */
{ 0xE057,  2, 5, { 0x06, 0x0f, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-24 澹	# [cjk] */
{ 0xE058,  2, 5, { 0x06, 0x0f, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-25 濆	# [cjk] */
{ 0xE059,  2, 5, { 0x06, 0x0f, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-26 澪	# [cjk] */
{ 0xE05A,  2, 5, { 0x06, 0x0f, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-27 濟	# [cjk] */
{ 0xE05B,  2, 5, { 0x06, 0x0f, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-28 濕	# [cjk] */
{ 0xE05C,  2, 5, { 0x06, 0x0f, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-29 濬	# [cjk] */
{ 0xE05D,  2, 5, { 0x06, 0x0f, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-30 濔	# [cjk] */
{ 0xE05E,  2, 5, { 0x06, 0x0f, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-31 濘	# [cjk] */
{ 0xE05F,  2, 5, { 0x06, 0x0f, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-32 濱	# [cjk] */
{ 0xE060,  2, 5, { 0x06, 0x0f, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-33 濮	# [cjk] */
{ 0xE061,  2, 5, { 0x06, 0x0f, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-34 濛	# [cjk] */
{ 0xE062,  2, 5, { 0x07, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-35 瀉	# [cjk] */
{ 0xE063,  2, 5, { 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-36 瀋	# [cjk] */
{ 0xE064,  2, 5, { 0x06, 0x0f, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-37 濺	# [cjk] */
{ 0xE065,  2, 5, { 0x07, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-38 瀑	# [cjk] */
{ 0xE066,  2, 5, { 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-39 瀁	# [cjk] */
{ 0xE067,  2, 5, { 0x07, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-40 瀏	# [cjk] */
{ 0xE068,  2, 5, { 0x06, 0x0f, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-41 濾	# [cjk] */
{ 0xE069,  2, 5, { 0x07, 0x00, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-42 瀛	# [cjk] */
{ 0xE06A,  2, 5, { 0x07, 0x00, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-43 瀚	# [cjk] */
{ 0xE06B,  2, 5, { 0x06, 0x0f, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-44 潴	# [cjk] */
{ 0xE06C,  2, 5, { 0x07, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-45 瀝	# [cjk] */
{ 0xE06D,  2, 5, { 0x07, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-46 瀘	# [cjk] */
{ 0xE06E,  2, 5, { 0x07, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-47 瀟	# [cjk] */
{ 0xE06F,  2, 5, { 0x07, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-48 瀰	# [cjk] */
{ 0xE070,  2, 5, { 0x07, 0x00, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-49 瀾	# [cjk] */
{ 0xE071,  2, 5, { 0x07, 0x00, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-50 瀲	# [cjk] */
{ 0xE072,  2, 5, { 0x07, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-51 灑	# [cjk] */
{ 0xE073,  2, 5, { 0x07, 0x00, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-52 灣	# [cjk] */
{ 0xE074,  2, 5, { 0x07, 0x00, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-53 炙	# [cjk] */
{ 0xE075,  2, 5, { 0x07, 0x00, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-54 炒	# [cjk] */
{ 0xE076,  2, 5, { 0x07, 0x00, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-55 炯	# [cjk] */
{ 0xE077,  2, 5, { 0x07, 0x00, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-56 烱	# [cjk] */
{ 0xE078,  2, 5, { 0x07, 0x00, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-57 炬	# [cjk] */
{ 0xE079,  2, 5, { 0x07, 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-58 炸	# [cjk] */
{ 0xE07A,  2, 5, { 0x07, 0x00, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-59 炳	# [cjk] */
{ 0xE07B,  2, 5, { 0x07, 0x00, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-60 炮	# [cjk] */
{ 0xE07C,  2, 5, { 0x07, 0x00, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-61 烟	# [cjk] */
{ 0xE07D,  2, 5, { 0x07, 0x00, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-62 烋	# [cjk] */
{ 0xE07E,  2, 5, { 0x07, 0x00, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-63 烝	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE080,  2, 5, { 0x07, 0x00, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-64 烙	# [cjk] */
{ 0xE081,  2, 5, { 0x07, 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-65 焉	# [cjk] */
{ 0xE082,  2, 5, { 0x07, 0x00, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-66 烽	# [cjk] */
{ 0xE083,  2, 5, { 0x07, 0x01, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-67 焜	# [cjk] */
{ 0xE084,  2, 5, { 0x07, 0x01, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-68 焙	# [cjk] */
{ 0xE085,  2, 5, { 0x07, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-69 煥	# [cjk] */
{ 0xE086,  2, 5, { 0x07, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-70 煕	# [cjk] */
{ 0xE087,  2, 5, { 0x07, 0x01, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-71 熈	# [cjk] */
{ 0xE088,  2, 5, { 0x07, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-72 煦	# [cjk] */
{ 0xE089,  2, 5, { 0x07, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-73 煢	# [cjk] */
{ 0xE08A,  2, 5, { 0x07, 0x01, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-74 煌	# [cjk] */
{ 0xE08B,  2, 5, { 0x07, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-75 煖	# [cjk] */
{ 0xE08C,  2, 5, { 0x07, 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-76 煬	# [cjk] */
{ 0xE08D,  2, 5, { 0x07, 0x01, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-77 熏	# [cjk] */
{ 0xE08E,  2, 5, { 0x07, 0x01, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-78 燻	# [cjk] */
{ 0xE08F,  2, 5, { 0x07, 0x01, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-79 熄	# [cjk] */
{ 0xE090,  2, 5, { 0x07, 0x01, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-80 熕	# [cjk] */
{ 0xE091,  2, 5, { 0x07, 0x01, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-81 熨	# [cjk] */
{ 0xE092,  2, 5, { 0x07, 0x01, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-82 熬	# [cjk] */
{ 0xE093,  2, 5, { 0x07, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-83 燗	# [cjk] */
{ 0xE094,  2, 5, { 0x07, 0x01, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-84 熹	# [cjk] */
{ 0xE095,  2, 5, { 0x07, 0x01, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-85 熾	# [cjk] */
{ 0xE096,  2, 5, { 0x07, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-86 燒	# [cjk] */
{ 0xE097,  2, 5, { 0x07, 0x01, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-87 燉	# [cjk] */
{ 0xE098,  2, 5, { 0x07, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-88 燔	# [cjk] */
{ 0xE099,  2, 5, { 0x07, 0x01, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-89 燎	# [cjk] */
{ 0xE09A,  2, 5, { 0x07, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-90 燠	# [cjk] */
{ 0xE09B,  2, 5, { 0x07, 0x01, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-91 燬	# [cjk] */
{ 0xE09C,  2, 5, { 0x07, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-92 燧	# [cjk] */
{ 0xE09D,  2, 5, { 0x07, 0x01, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-93 燵	# [cjk] */
{ 0xE09E,  2, 5, { 0x07, 0x01, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-63-94 燼	# [cjk] */
{ 0xE09F,  2, 5, { 0x07, 0x01, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-01 燹	# [cjk] */
{ 0xE0A0,  2, 5, { 0x07, 0x01, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-02 燿	# [cjk] */
{ 0xE0A1,  2, 5, { 0x07, 0x02, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-03 爍	# [cjk] */
{ 0xE0A2,  2, 5, { 0x07, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-04 爐	# [cjk] */
{ 0xE0A3,  2, 5, { 0x07, 0x02, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-05 爛	# [cjk] */
{ 0xE0A4,  2, 5, { 0x07, 0x02, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-06 爨	# [cjk] */
{ 0xE0A5,  2, 5, { 0x07, 0x02, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-07 爭	# [cjk] */
{ 0xE0A6,  2, 5, { 0x07, 0x02, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-08 爬	# [cjk] */
{ 0xE0A7,  2, 5, { 0x07, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-09 爰	# [cjk] */
{ 0xE0A8,  2, 5, { 0x07, 0x02, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-10 爲	# [cjk] */
{ 0xE0A9,  2, 5, { 0x07, 0x02, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-11 爻	# [cjk] */
{ 0xE0AA,  2, 5, { 0x07, 0x02, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-12 爼	# [cjk] */
{ 0xE0AB,  2, 5, { 0x07, 0x02, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-13 爿	# [cjk] */
{ 0xE0AC,  2, 5, { 0x07, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-14 牀	# [cjk] */
{ 0xE0AD,  2, 5, { 0x07, 0x02, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-15 牆	# [cjk] */
{ 0xE0AE,  2, 5, { 0x07, 0x02, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-16 牋	# [cjk] */
{ 0xE0AF,  2, 5, { 0x07, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-17 牘	# [cjk] */
{ 0xE0B0,  2, 5, { 0x07, 0x02, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-18 牴	# [cjk] */
{ 0xE0B1,  2, 5, { 0x07, 0x02, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-19 牾	# [cjk] */
{ 0xE0B2,  2, 5, { 0x07, 0x02, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-20 犂	# [cjk] */
{ 0xE0B3,  2, 5, { 0x07, 0x02, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-21 犁	# [cjk] */
{ 0xE0B4,  2, 5, { 0x07, 0x02, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-22 犇	# [cjk] */
{ 0xE0B5,  2, 5, { 0x07, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-23 犒	# [cjk] */
{ 0xE0B6,  2, 5, { 0x07, 0x02, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-24 犖	# [cjk] */
{ 0xE0B7,  2, 5, { 0x07, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-25 犢	# [cjk] */
{ 0xE0B8,  2, 5, { 0x07, 0x02, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-26 犧	# [cjk] */
{ 0xE0B9,  2, 5, { 0x07, 0x02, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-27 犹	# [cjk] */
{ 0xE0BA,  2, 5, { 0x07, 0x02, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-28 犲	# [cjk] */
{ 0xE0BB,  2, 5, { 0x07, 0x02, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-29 狃	# [cjk] */
{ 0xE0BC,  2, 5, { 0x07, 0x02, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-30 狆	# [cjk] */
{ 0xE0BD,  2, 5, { 0x07, 0x02, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-31 狄	# [cjk] */
{ 0xE0BE,  2, 5, { 0x07, 0x02, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-32 狎	# [cjk] */
{ 0xE0BF,  2, 5, { 0x07, 0x02, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-33 狒	# [cjk] */
{ 0xE0C0,  2, 5, { 0x07, 0x02, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-34 狢	# [cjk] */
{ 0xE0C1,  2, 5, { 0x07, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-35 狠	# [cjk] */
{ 0xE0C2,  2, 5, { 0x07, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-36 狡	# [cjk] */
{ 0xE0C3,  2, 5, { 0x07, 0x02, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-37 狹	# [cjk] */
{ 0xE0C4,  2, 5, { 0x07, 0x02, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-38 狷	# [cjk] */
{ 0xE0C5,  2, 5, { 0x05, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-39 倏	# [cjk] */
{ 0xE0C6,  2, 5, { 0x07, 0x03, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-40 猗	# [cjk] */
{ 0xE0C7,  2, 5, { 0x07, 0x03, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-41 猊	# [cjk] */
{ 0xE0C8,  2, 5, { 0x07, 0x03, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-42 猜	# [cjk] */
{ 0xE0C9,  2, 5, { 0x07, 0x03, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-43 猖	# [cjk] */
{ 0xE0CA,  2, 5, { 0x07, 0x03, 0x00, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-44 猝	# [cjk] */
{ 0xE0CB,  2, 5, { 0x07, 0x03, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-45 猴	# [cjk] */
{ 0xE0CC,  2, 5, { 0x07, 0x03, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-46 猯	# [cjk] */
{ 0xE0CD,  2, 5, { 0x07, 0x03, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-47 猩	# [cjk] */
{ 0xE0CE,  2, 5, { 0x07, 0x03, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-48 猥	# [cjk] */
{ 0xE0CF,  2, 5, { 0x07, 0x03, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-49 猾	# [cjk] */
{ 0xE0D0,  2, 5, { 0x07, 0x03, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-50 獎	# [cjk] */
{ 0xE0D1,  2, 5, { 0x07, 0x03, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-51 獏	# [cjk] */
{ 0xE0D2,  2, 5, { 0x09, 0x0e, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-52 默	# [cjk] */
{ 0xE0D3,  2, 5, { 0x07, 0x03, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-53 獗	# [cjk] */
{ 0xE0D4,  2, 5, { 0x07, 0x03, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-54 獪	# [cjk] */
{ 0xE0D5,  2, 5, { 0x07, 0x03, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-55 獨	# [cjk] */
{ 0xE0D6,  2, 5, { 0x07, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-56 獰	# [cjk] */
{ 0xE0D7,  2, 5, { 0x07, 0x03, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-57 獸	# [cjk] */
{ 0xE0D8,  2, 5, { 0x07, 0x03, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-58 獵	# [cjk] */
{ 0xE0D9,  2, 5, { 0x07, 0x03, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-59 獻	# [cjk] */
{ 0xE0DA,  2, 5, { 0x07, 0x03, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-60 獺	# [cjk] */
{ 0xE0DB,  2, 5, { 0x07, 0x03, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-61 珈	# [cjk] */
{ 0xE0DC,  2, 5, { 0x07, 0x03, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-62 玳	# [cjk] */
{ 0xE0DD,  2, 5, { 0x07, 0x03, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-63 珎	# [cjk] */
{ 0xE0DE,  2, 5, { 0x07, 0x03, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-64 玻	# [cjk] */
{ 0xE0DF,  2, 5, { 0x07, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-65 珀	# [cjk] */
{ 0xE0E0,  2, 5, { 0x07, 0x03, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-66 珥	# [cjk] */
{ 0xE0E1,  2, 5, { 0x07, 0x03, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-67 珮	# [cjk] */
{ 0xE0E2,  2, 5, { 0x07, 0x03, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-68 珞	# [cjk] */
{ 0xE0E3,  2, 5, { 0x07, 0x04, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-69 璢	# [cjk] */
{ 0xE0E4,  2, 5, { 0x07, 0x04, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-70 琅	# [cjk] */
{ 0xE0E5,  2, 5, { 0x07, 0x04, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-71 瑯	# [cjk] */
{ 0xE0E6,  2, 5, { 0x07, 0x04, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-72 琥	# [cjk] */
{ 0xE0E7,  2, 5, { 0x07, 0x03, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-73 珸	# [cjk] */
{ 0xE0E8,  2, 5, { 0x07, 0x04, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-74 琲	# [cjk] */
{ 0xE0E9,  2, 5, { 0x07, 0x04, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-75 琺	# [cjk] */
{ 0xE0EA,  2, 5, { 0x07, 0x04, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-76 瑕	# [cjk] */
{ 0xE0EB,  2, 5, { 0x07, 0x04, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-77 琿	# [cjk] */
{ 0xE0EC,  2, 5, { 0x07, 0x04, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-78 瑟	# [cjk] */
{ 0xE0ED,  2, 5, { 0x07, 0x04, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-79 瑙	# [cjk] */
{ 0xE0EE,  2, 5, { 0x07, 0x04, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-80 瑁	# [cjk] */
{ 0xE0EF,  2, 5, { 0x07, 0x04, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-81 瑜	# [cjk] */
{ 0xE0F0,  2, 5, { 0x07, 0x04, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-82 瑩	# [cjk] */
{ 0xE0F1,  2, 5, { 0x07, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-83 瑰	# [cjk] */
{ 0xE0F2,  2, 5, { 0x07, 0x04, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-84 瑣	# [cjk] */
{ 0xE0F3,  2, 5, { 0x07, 0x04, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-85 瑪	# [cjk] */
{ 0xE0F4,  2, 5, { 0x07, 0x04, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-86 瑶	# [cjk] */
{ 0xE0F5,  2, 5, { 0x07, 0x04, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-87 瑾	# [cjk] */
{ 0xE0F6,  2, 5, { 0x07, 0x04, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-88 璋	# [cjk] */
{ 0xE0F7,  2, 5, { 0x07, 0x04, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-89 璞	# [cjk] */
{ 0xE0F8,  2, 5, { 0x07, 0x04, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-90 璧	# [cjk] */
{ 0xE0F9,  2, 5, { 0x07, 0x04, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-91 瓊	# [cjk] */
{ 0xE0FA,  2, 5, { 0x07, 0x04, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-92 瓏	# [cjk] */
{ 0xE0FB,  2, 5, { 0x07, 0x04, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-93 瓔	# [cjk] */
{ 0xE0FC,  2, 5, { 0x07, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-64-94 珱	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE140,  2, 5, { 0x07, 0x04, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-01 瓠	# [cjk] */
{ 0xE141,  2, 5, { 0x07, 0x04, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-02 瓣	# [cjk] */
{ 0xE142,  2, 5, { 0x07, 0x04, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-03 瓧	# [cjk] */
{ 0xE143,  2, 5, { 0x07, 0x04, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-04 瓩	# [cjk] */
{ 0xE144,  2, 5, { 0x07, 0x04, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-05 瓮	# [cjk] */
{ 0xE145,  2, 5, { 0x07, 0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-06 瓲	# [cjk] */
{ 0xE146,  2, 5, { 0x07, 0x04, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-07 瓰	# [cjk] */
{ 0xE147,  2, 5, { 0x07, 0x04, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-08 瓱	# [cjk] */
{ 0xE148,  2, 5, { 0x07, 0x04, 0x03, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-09 瓸	# [cjk] */
{ 0xE149,  2, 5, { 0x07, 0x04, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-10 瓷	# [cjk] */
{ 0xE14A,  2, 5, { 0x07, 0x05, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-11 甄	# [cjk] */
{ 0xE14B,  2, 5, { 0x07, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-12 甃	# [cjk] */
{ 0xE14C,  2, 5, { 0x07, 0x05, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-13 甅	# [cjk] */
{ 0xE14D,  2, 5, { 0x07, 0x05, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-14 甌	# [cjk] */
{ 0xE14E,  2, 5, { 0x07, 0x05, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-15 甎	# [cjk] */
{ 0xE14F,  2, 5, { 0x07, 0x05, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-16 甍	# [cjk] */
{ 0xE150,  2, 5, { 0x07, 0x05, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-17 甕	# [cjk] */
{ 0xE151,  2, 5, { 0x07, 0x05, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-18 甓	# [cjk] */
{ 0xE152,  2, 5, { 0x07, 0x05, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-19 甞	# [cjk] */
{ 0xE153,  2, 5, { 0x07, 0x05, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-20 甦	# [cjk] */
{ 0xE154,  2, 5, { 0x07, 0x05, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-21 甬	# [cjk] */
{ 0xE155,  2, 5, { 0x07, 0x05, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-22 甼	# [cjk] */
{ 0xE156,  2, 5, { 0x07, 0x05, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-23 畄	# [cjk] */
{ 0xE157,  2, 5, { 0x07, 0x05, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-24 畍	# [cjk] */
{ 0xE158,  2, 5, { 0x07, 0x05, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-25 畊	# [cjk] */
{ 0xE159,  2, 5, { 0x07, 0x05, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-26 畉	# [cjk] */
{ 0xE15A,  2, 5, { 0x07, 0x05, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-27 畛	# [cjk] */
{ 0xE15B,  2, 5, { 0x07, 0x05, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-28 畆	# [cjk] */
{ 0xE15C,  2, 5, { 0x07, 0x05, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-29 畚	# [cjk] */
{ 0xE15D,  2, 5, { 0x07, 0x05, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-30 畩	# [cjk] */
{ 0xE15E,  2, 5, { 0x07, 0x05, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-31 畤	# [cjk] */
{ 0xE15F,  2, 5, { 0x07, 0x05, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-32 畧	# [cjk] */
{ 0xE160,  2, 5, { 0x07, 0x05, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-33 畫	# [cjk] */
{ 0xE161,  2, 5, { 0x07, 0x05, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-34 畭	# [cjk] */
{ 0xE162,  2, 5, { 0x07, 0x05, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-35 畸	# [cjk] */
{ 0xE163,  2, 5, { 0x07, 0x05, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-36 當	# [cjk] */
{ 0xE164,  2, 5, { 0x07, 0x05, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-37 疆	# [cjk] */
{ 0xE165,  2, 5, { 0x07, 0x05, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-38 疇	# [cjk] */
{ 0xE166,  2, 5, { 0x07, 0x05, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-39 畴	# [cjk] */
{ 0xE167,  2, 5, { 0x07, 0x05, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-40 疊	# [cjk] */
{ 0xE168,  2, 5, { 0x07, 0x05, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-41 疉	# [cjk] */
{ 0xE169,  2, 5, { 0x07, 0x05, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-42 疂	# [cjk] */
{ 0xE16A,  2, 5, { 0x07, 0x05, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-43 疔	# [cjk] */
{ 0xE16B,  2, 5, { 0x07, 0x05, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-44 疚	# [cjk] */
{ 0xE16C,  2, 5, { 0x07, 0x05, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-45 疝	# [cjk] */
{ 0xE16D,  2, 5, { 0x07, 0x05, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-46 疥	# [cjk] */
{ 0xE16E,  2, 5, { 0x07, 0x05, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-47 疣	# [cjk] */
{ 0xE16F,  2, 5, { 0x07, 0x05, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-48 痂	# [cjk] */
{ 0xE170,  2, 5, { 0x07, 0x05, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-49 疳	# [cjk] */
{ 0xE171,  2, 5, { 0x07, 0x05, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-50 痃	# [cjk] */
{ 0xE172,  2, 5, { 0x07, 0x05, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-51 疵	# [cjk] */
{ 0xE173,  2, 5, { 0x07, 0x05, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-52 疽	# [cjk] */
{ 0xE174,  2, 5, { 0x07, 0x05, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-53 疸	# [cjk] */
{ 0xE175,  2, 5, { 0x07, 0x05, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-54 疼	# [cjk] */
{ 0xE176,  2, 5, { 0x07, 0x05, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-55 疱	# [cjk] */
{ 0xE177,  2, 5, { 0x07, 0x05, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-56 痍	# [cjk] */
{ 0xE178,  2, 5, { 0x07, 0x05, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-57 痊	# [cjk] */
{ 0xE179,  2, 5, { 0x07, 0x05, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-58 痒	# [cjk] */
{ 0xE17A,  2, 5, { 0x07, 0x05, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-59 痙	# [cjk] */
{ 0xE17B,  2, 5, { 0x07, 0x05, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-60 痣	# [cjk] */
{ 0xE17C,  2, 5, { 0x07, 0x05, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-61 痞	# [cjk] */
{ 0xE17D,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-62 痾	# [cjk] */
{ 0xE17E,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-63 痿	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE180,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-64 痼	# [cjk] */
{ 0xE181,  2, 5, { 0x07, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-65 瘁	# [cjk] */
{ 0xE182,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-66 痰	# [cjk] */
{ 0xE183,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-67 痺	# [cjk] */
{ 0xE184,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-68 痲	# [cjk] */
{ 0xE185,  2, 5, { 0x07, 0x05, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-69 痳	# [cjk] */
{ 0xE186,  2, 5, { 0x07, 0x06, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-70 瘋	# [cjk] */
{ 0xE187,  2, 5, { 0x07, 0x06, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-71 瘍	# [cjk] */
{ 0xE188,  2, 5, { 0x07, 0x06, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-72 瘉	# [cjk] */
{ 0xE189,  2, 5, { 0x07, 0x06, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-73 瘟	# [cjk] */
{ 0xE18A,  2, 5, { 0x07, 0x06, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-74 瘧	# [cjk] */
{ 0xE18B,  2, 5, { 0x07, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-75 瘠	# [cjk] */
{ 0xE18C,  2, 5, { 0x07, 0x06, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-76 瘡	# [cjk] */
{ 0xE18D,  2, 5, { 0x07, 0x06, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-77 瘢	# [cjk] */
{ 0xE18E,  2, 5, { 0x07, 0x06, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-78 瘤	# [cjk] */
{ 0xE18F,  2, 5, { 0x07, 0x06, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-79 瘴	# [cjk] */
{ 0xE190,  2, 5, { 0x07, 0x06, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-80 瘰	# [cjk] */
{ 0xE191,  2, 5, { 0x07, 0x06, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-81 瘻	# [cjk] */
{ 0xE192,  2, 5, { 0x07, 0x06, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-82 癇	# [cjk] */
{ 0xE193,  2, 5, { 0x07, 0x06, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-83 癈	# [cjk] */
{ 0xE194,  2, 5, { 0x07, 0x06, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-84 癆	# [cjk] */
{ 0xE195,  2, 5, { 0x07, 0x06, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-85 癜	# [cjk] */
{ 0xE196,  2, 5, { 0x07, 0x06, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-86 癘	# [cjk] */
{ 0xE197,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-87 癡	# [cjk] */
{ 0xE198,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-88 癢	# [cjk] */
{ 0xE199,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-89 癨	# [cjk] */
{ 0xE19A,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-90 癩	# [cjk] */
{ 0xE19B,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-91 癪	# [cjk] */
{ 0xE19C,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-92 癧	# [cjk] */
{ 0xE19D,  2, 5, { 0x07, 0x06, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-93 癬	# [cjk] */
{ 0xE19E,  2, 5, { 0x07, 0x06, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-65-94 癰	# [cjk] */
{ 0xE19F,  2, 5, { 0x07, 0x06, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-01 癲	# [cjk] */
{ 0xE1A0,  2, 5, { 0x07, 0x06, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-02 癶	# [cjk] */
{ 0xE1A1,  2, 5, { 0x07, 0x06, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-03 癸	# [cjk] */
{ 0xE1A2,  2, 5, { 0x07, 0x06, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-04 發	# [cjk] */
{ 0xE1A3,  2, 5, { 0x07, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-05 皀	# [cjk] */
{ 0xE1A4,  2, 5, { 0x07, 0x06, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-06 皃	# [cjk] */
{ 0xE1A5,  2, 5, { 0x07, 0x06, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-07 皈	# [cjk] */
{ 0xE1A6,  2, 5, { 0x07, 0x06, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-08 皋	# [cjk] */
{ 0xE1A7,  2, 5, { 0x07, 0x06, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-09 皎	# [cjk] */
{ 0xE1A8,  2, 5, { 0x07, 0x06, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-10 皖	# [cjk] */
{ 0xE1A9,  2, 5, { 0x07, 0x06, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-11 皓	# [cjk] */
{ 0xE1AA,  2, 5, { 0x07, 0x06, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-12 皙	# [cjk] */
{ 0xE1AB,  2, 5, { 0x07, 0x06, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-13 皚	# [cjk] */
{ 0xE1AC,  2, 5, { 0x07, 0x06, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-14 皰	# [cjk] */
{ 0xE1AD,  2, 5, { 0x07, 0x06, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-15 皴	# [cjk] */
{ 0xE1AE,  2, 5, { 0x07, 0x06, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-16 皸	# [cjk] */
{ 0xE1AF,  2, 5, { 0x07, 0x06, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-17 皹	# [cjk] */
{ 0xE1B0,  2, 5, { 0x07, 0x06, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-18 皺	# [cjk] */
{ 0xE1B1,  2, 5, { 0x07, 0x06, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-19 盂	# [cjk] */
{ 0xE1B2,  2, 5, { 0x07, 0x06, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-20 盍	# [cjk] */
{ 0xE1B3,  2, 5, { 0x07, 0x06, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-21 盖	# [cjk] */
{ 0xE1B4,  2, 5, { 0x07, 0x06, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-22 盒	# [cjk] */
{ 0xE1B5,  2, 5, { 0x07, 0x06, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-23 盞	# [cjk] */
{ 0xE1B6,  2, 5, { 0x07, 0x06, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-24 盡	# [cjk] */
{ 0xE1B7,  2, 5, { 0x07, 0x06, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-25 盥	# [cjk] */
{ 0xE1B8,  2, 5, { 0x07, 0x06, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-26 盧	# [cjk] */
{ 0xE1B9,  2, 5, { 0x07, 0x06, 0x03, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-27 盪	# [cjk] */
{ 0xE1BA,  2, 5, { 0x08, 0x06, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-28 蘯	# [cjk] */
{ 0xE1BB,  2, 5, { 0x07, 0x06, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-29 盻	# [cjk] */
{ 0xE1BC,  2, 5, { 0x07, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-30 眈	# [cjk] */
{ 0xE1BD,  2, 5, { 0x07, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-31 眇	# [cjk] */
{ 0xE1BE,  2, 5, { 0x07, 0x07, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-32 眄	# [cjk] */
{ 0xE1BF,  2, 5, { 0x07, 0x07, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-33 眩	# [cjk] */
{ 0xE1C0,  2, 5, { 0x07, 0x07, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-34 眤	# [cjk] */
{ 0xE1C1,  2, 5, { 0x07, 0x07, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-35 眞	# [cjk] */
{ 0xE1C2,  2, 5, { 0x07, 0x07, 0x00, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-36 眥	# [cjk] */
{ 0xE1C3,  2, 5, { 0x07, 0x07, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-37 眦	# [cjk] */
{ 0xE1C4,  2, 5, { 0x07, 0x07, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-38 眛	# [cjk] */
{ 0xE1C5,  2, 5, { 0x07, 0x07, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-39 眷	# [cjk] */
{ 0xE1C6,  2, 5, { 0x07, 0x07, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-40 眸	# [cjk] */
{ 0xE1C7,  2, 5, { 0x07, 0x07, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-41 睇	# [cjk] */
{ 0xE1C8,  2, 5, { 0x07, 0x07, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-42 睚	# [cjk] */
{ 0xE1C9,  2, 5, { 0x07, 0x07, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-43 睨	# [cjk] */
{ 0xE1CA,  2, 5, { 0x07, 0x07, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-44 睫	# [cjk] */
{ 0xE1CB,  2, 5, { 0x07, 0x07, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-45 睛	# [cjk] */
{ 0xE1CC,  2, 5, { 0x07, 0x07, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-46 睥	# [cjk] */
{ 0xE1CD,  2, 5, { 0x07, 0x07, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-47 睿	# [cjk] */
{ 0xE1CE,  2, 5, { 0x07, 0x07, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-48 睾	# [cjk] */
{ 0xE1CF,  2, 5, { 0x07, 0x07, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-49 睹	# [cjk] */
{ 0xE1D0,  2, 5, { 0x07, 0x07, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-50 瞎	# [cjk] */
{ 0xE1D1,  2, 5, { 0x07, 0x07, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-51 瞋	# [cjk] */
{ 0xE1D2,  2, 5, { 0x07, 0x07, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-52 瞑	# [cjk] */
{ 0xE1D3,  2, 5, { 0x07, 0x07, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-53 瞠	# [cjk] */
{ 0xE1D4,  2, 5, { 0x07, 0x07, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-54 瞞	# [cjk] */
{ 0xE1D5,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-55 瞰	# [cjk] */
{ 0xE1D6,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-56 瞶	# [cjk] */
{ 0xE1D7,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-57 瞹	# [cjk] */
{ 0xE1D8,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-58 瞿	# [cjk] */
{ 0xE1D9,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-59 瞼	# [cjk] */
{ 0xE1DA,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-60 瞽	# [cjk] */
{ 0xE1DB,  2, 5, { 0x07, 0x07, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-61 瞻	# [cjk] */
{ 0xE1DC,  2, 5, { 0x07, 0x07, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-62 矇	# [cjk] */
{ 0xE1DD,  2, 5, { 0x07, 0x07, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-63 矍	# [cjk] */
{ 0xE1DE,  2, 5, { 0x07, 0x07, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-64 矗	# [cjk] */
{ 0xE1DF,  2, 5, { 0x07, 0x07, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-65 矚	# [cjk] */
{ 0xE1E0,  2, 5, { 0x07, 0x07, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-66 矜	# [cjk] */
{ 0xE1E1,  2, 5, { 0x07, 0x07, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-67 矣	# [cjk] */
{ 0xE1E2,  2, 5, { 0x07, 0x07, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-68 矮	# [cjk] */
{ 0xE1E3,  2, 5, { 0x07, 0x07, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-69 矼	# [cjk] */
{ 0xE1E4,  2, 5, { 0x07, 0x08, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-70 砌	# [cjk] */
{ 0xE1E5,  2, 5, { 0x07, 0x08, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-71 砒	# [cjk] */
{ 0xE1E6,  2, 5, { 0x07, 0x09, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-72 礦	# [cjk] */
{ 0xE1E7,  2, 5, { 0x07, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-73 砠	# [cjk] */
{ 0xE1E8,  2, 5, { 0x07, 0x09, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-74 礪	# [cjk] */
{ 0xE1E9,  2, 5, { 0x07, 0x08, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-75 硅	# [cjk] */
{ 0xE1EA,  2, 5, { 0x07, 0x08, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-76 碎	# [cjk] */
{ 0xE1EB,  2, 5, { 0x07, 0x08, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-77 硴	# [cjk] */
{ 0xE1EC,  2, 5, { 0x07, 0x08, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-78 碆	# [cjk] */
{ 0xE1ED,  2, 5, { 0x07, 0x08, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-79 硼	# [cjk] */
{ 0xE1EE,  2, 5, { 0x07, 0x08, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-80 碚	# [cjk] */
{ 0xE1EF,  2, 5, { 0x07, 0x08, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-81 碌	# [cjk] */
{ 0xE1F0,  2, 5, { 0x07, 0x08, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-82 碣	# [cjk] */
{ 0xE1F1,  2, 5, { 0x07, 0x08, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-83 碵	# [cjk] */
{ 0xE1F2,  2, 5, { 0x07, 0x08, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-84 碪	# [cjk] */
{ 0xE1F3,  2, 5, { 0x07, 0x08, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-85 碯	# [cjk] */
{ 0xE1F4,  2, 5, { 0x07, 0x08, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-86 磑	# [cjk] */
{ 0xE1F5,  2, 5, { 0x07, 0x08, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-87 磆	# [cjk] */
{ 0xE1F6,  2, 5, { 0x07, 0x08, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-88 磋	# [cjk] */
{ 0xE1F7,  2, 5, { 0x07, 0x08, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-89 磔	# [cjk] */
{ 0xE1F8,  2, 5, { 0x07, 0x08, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-90 碾	# [cjk] */
{ 0xE1F9,  2, 5, { 0x07, 0x08, 0x02, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-91 碼	# [cjk] */
{ 0xE1FA,  2, 5, { 0x07, 0x08, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-92 磅	# [cjk] */
{ 0xE1FB,  2, 5, { 0x07, 0x08, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-93 磊	# [cjk] */
{ 0xE1FC,  2, 5, { 0x07, 0x08, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-66-94 磬	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE240,  2, 5, { 0x07, 0x08, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-01 磧	# [cjk] */
{ 0xE241,  2, 5, { 0x07, 0x08, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-02 磚	# [cjk] */
{ 0xE242,  2, 5, { 0x07, 0x08, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-03 磽	# [cjk] */
{ 0xE243,  2, 5, { 0x07, 0x08, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-04 磴	# [cjk] */
{ 0xE244,  2, 5, { 0x07, 0x09, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-05 礇	# [cjk] */
{ 0xE245,  2, 5, { 0x07, 0x09, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-06 礒	# [cjk] */
{ 0xE246,  2, 5, { 0x07, 0x09, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-07 礑	# [cjk] */
{ 0xE247,  2, 5, { 0x07, 0x09, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-08 礙	# [cjk] */
{ 0xE248,  2, 5, { 0x07, 0x09, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-09 礬	# [cjk] */
{ 0xE249,  2, 5, { 0x07, 0x09, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-10 礫	# [cjk] */
{ 0xE24A,  2, 5, { 0x07, 0x09, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-11 祀	# [cjk] */
{ 0xE24B,  2, 5, { 0x07, 0x09, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-12 祠	# [cjk] */
{ 0xE24C,  2, 5, { 0x07, 0x09, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-13 祗	# [cjk] */
{ 0xE24D,  2, 5, { 0x07, 0x09, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-14 祟	# [cjk] */
{ 0xE24E,  2, 5, { 0x07, 0x09, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-15 祚	# [cjk] */
{ 0xE24F,  2, 5, { 0x07, 0x09, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-16 祕	# [cjk] */
{ 0xE250,  2, 5, { 0x07, 0x09, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-17 祓	# [cjk] */
{ 0xE251,  2, 5, { 0x07, 0x09, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-18 祺	# [cjk] */
{ 0xE252,  2, 5, { 0x07, 0x09, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-19 祿	# [cjk] */
{ 0xE253,  2, 5, { 0x07, 0x09, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-20 禊	# [cjk] */
{ 0xE254,  2, 5, { 0x07, 0x09, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-21 禝	# [cjk] */
{ 0xE255,  2, 5, { 0x07, 0x09, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-22 禧	# [cjk] */
{ 0xE256,  2, 5, { 0x09, 0x0f, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-23 齋	# [cjk] */
{ 0xE257,  2, 5, { 0x07, 0x09, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-24 禪	# [cjk] */
{ 0xE258,  2, 5, { 0x07, 0x09, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-25 禮	# [cjk] */
{ 0xE259,  2, 5, { 0x07, 0x09, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-26 禳	# [cjk] */
{ 0xE25A,  2, 5, { 0x07, 0x09, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-27 禹	# [cjk] */
{ 0xE25B,  2, 5, { 0x07, 0x09, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-28 禺	# [cjk] */
{ 0xE25C,  2, 5, { 0x07, 0x09, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-29 秉	# [cjk] */
{ 0xE25D,  2, 5, { 0x07, 0x09, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-30 秕	# [cjk] */
{ 0xE25E,  2, 5, { 0x07, 0x09, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-31 秧	# [cjk] */
{ 0xE25F,  2, 5, { 0x07, 0x09, 0x03, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-32 秬	# [cjk] */
{ 0xE260,  2, 5, { 0x07, 0x09, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-33 秡	# [cjk] */
{ 0xE261,  2, 5, { 0x07, 0x09, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-34 秣	# [cjk] */
{ 0xE262,  2, 5, { 0x07, 0x0a, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-35 稈	# [cjk] */
{ 0xE263,  2, 5, { 0x07, 0x0a, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-36 稍	# [cjk] */
{ 0xE264,  2, 5, { 0x07, 0x0a, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-37 稘	# [cjk] */
{ 0xE265,  2, 5, { 0x07, 0x0a, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-38 稙	# [cjk] */
{ 0xE266,  2, 5, { 0x07, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-39 稠	# [cjk] */
{ 0xE267,  2, 5, { 0x07, 0x0a, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-40 稟	# [cjk] */
{ 0xE268,  2, 5, { 0x07, 0x09, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-41 禀	# [cjk] */
{ 0xE269,  2, 5, { 0x07, 0x0a, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-42 稱	# [cjk] */
{ 0xE26A,  2, 5, { 0x07, 0x0a, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-43 稻	# [cjk] */
{ 0xE26B,  2, 5, { 0x07, 0x0a, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-44 稾	# [cjk] */
{ 0xE26C,  2, 5, { 0x07, 0x0a, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-45 稷	# [cjk] */
{ 0xE26D,  2, 5, { 0x07, 0x0a, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-46 穃	# [cjk] */
{ 0xE26E,  2, 5, { 0x07, 0x0a, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-47 穗	# [cjk] */
{ 0xE26F,  2, 5, { 0x07, 0x0a, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-48 穉	# [cjk] */
{ 0xE270,  2, 5, { 0x07, 0x0a, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-49 穡	# [cjk] */
{ 0xE271,  2, 5, { 0x07, 0x0a, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-50 穢	# [cjk] */
{ 0xE272,  2, 5, { 0x07, 0x0a, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-51 穩	# [cjk] */
{ 0xE273,  2, 5, { 0x09, 0x0f, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-52 龝	# [cjk] */
{ 0xE274,  2, 5, { 0x07, 0x0a, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-53 穰	# [cjk] */
{ 0xE275,  2, 5, { 0x07, 0x0a, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-54 穹	# [cjk] */
{ 0xE276,  2, 5, { 0x07, 0x0a, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-55 穽	# [cjk] */
{ 0xE277,  2, 5, { 0x07, 0x0a, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-56 窈	# [cjk] */
{ 0xE278,  2, 5, { 0x07, 0x0a, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-57 窗	# [cjk] */
{ 0xE279,  2, 5, { 0x07, 0x0a, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-58 窕	# [cjk] */
{ 0xE27A,  2, 5, { 0x07, 0x0a, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-59 窘	# [cjk] */
{ 0xE27B,  2, 5, { 0x07, 0x0a, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-60 窖	# [cjk] */
{ 0xE27C,  2, 5, { 0x07, 0x0a, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-61 窩	# [cjk] */
{ 0xE27D,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-62 竈	# [cjk] */
{ 0xE27E,  2, 5, { 0x07, 0x0a, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-63 窰	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE280,  2, 5, { 0x07, 0x0a, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-64 窶	# [cjk] */
{ 0xE281,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-65 竅	# [cjk] */
{ 0xE282,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-66 竄	# [cjk] */
{ 0xE283,  2, 5, { 0x07, 0x0a, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-67 窿	# [cjk] */
{ 0xE284,  2, 5, { 0x09, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-68 邃	# [cjk] */
{ 0xE285,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-69 竇	# [cjk] */
{ 0xE286,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-70 竊	# [cjk] */
{ 0xE287,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-71 竍	# [cjk] */
{ 0xE288,  2, 5, { 0x07, 0x0a, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-72 竏	# [cjk] */
{ 0xE289,  2, 5, { 0x07, 0x0a, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-73 竕	# [cjk] */
{ 0xE28A,  2, 5, { 0x07, 0x0a, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-74 竓	# [cjk] */
{ 0xE28B,  2, 5, { 0x07, 0x0a, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-75 站	# [cjk] */
{ 0xE28C,  2, 5, { 0x07, 0x0a, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-76 竚	# [cjk] */
{ 0xE28D,  2, 5, { 0x07, 0x0a, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-77 竝	# [cjk] */
{ 0xE28E,  2, 5, { 0x07, 0x0a, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-78 竡	# [cjk] */
{ 0xE28F,  2, 5, { 0x07, 0x0a, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-79 竢	# [cjk] */
{ 0xE290,  2, 5, { 0x07, 0x0a, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-80 竦	# [cjk] */
{ 0xE291,  2, 5, { 0x07, 0x0a, 0x03, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-81 竭	# [cjk] */
{ 0xE292,  2, 5, { 0x07, 0x0a, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-82 竰	# [cjk] */
{ 0xE293,  2, 5, { 0x07, 0x0b, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-83 笂	# [cjk] */
{ 0xE294,  2, 5, { 0x07, 0x0b, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-84 笏	# [cjk] */
{ 0xE295,  2, 5, { 0x07, 0x0b, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-85 笊	# [cjk] */
{ 0xE296,  2, 5, { 0x07, 0x0b, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-86 笆	# [cjk] */
{ 0xE297,  2, 5, { 0x07, 0x0b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-87 笳	# [cjk] */
{ 0xE298,  2, 5, { 0x07, 0x0b, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-88 笘	# [cjk] */
{ 0xE299,  2, 5, { 0x07, 0x0b, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-89 笙	# [cjk] */
{ 0xE29A,  2, 5, { 0x07, 0x0b, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-90 笞	# [cjk] */
{ 0xE29B,  2, 5, { 0x07, 0x0b, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-91 笵	# [cjk] */
{ 0xE29C,  2, 5, { 0x07, 0x0b, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-92 笨	# [cjk] */
{ 0xE29D,  2, 5, { 0x07, 0x0b, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-93 笶	# [cjk] */
{ 0xE29E,  2, 5, { 0x07, 0x0b, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-67-94 筐	# [cjk] */
{ 0xE29F,  2, 5, { 0x07, 0x0b, 0x01, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-01 筺	# [cjk] */
{ 0xE2A0,  2, 5, { 0x07, 0x0b, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-02 笄	# [cjk] */
{ 0xE2A1,  2, 5, { 0x07, 0x0b, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-03 筍	# [cjk] */
{ 0xE2A2,  2, 5, { 0x07, 0x0b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-04 笋	# [cjk] */
{ 0xE2A3,  2, 5, { 0x07, 0x0b, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-05 筌	# [cjk] */
{ 0xE2A4,  2, 5, { 0x07, 0x0b, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-06 筅	# [cjk] */
{ 0xE2A5,  2, 5, { 0x07, 0x0b, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-07 筵	# [cjk] */
{ 0xE2A6,  2, 5, { 0x07, 0x0b, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-08 筥	# [cjk] */
{ 0xE2A7,  2, 5, { 0x07, 0x0b, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-09 筴	# [cjk] */
{ 0xE2A8,  2, 5, { 0x07, 0x0b, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-10 筧	# [cjk] */
{ 0xE2A9,  2, 5, { 0x07, 0x0b, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-11 筰	# [cjk] */
{ 0xE2AA,  2, 5, { 0x07, 0x0b, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-12 筱	# [cjk] */
{ 0xE2AB,  2, 5, { 0x07, 0x0b, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-13 筬	# [cjk] */
{ 0xE2AC,  2, 5, { 0x07, 0x0b, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-14 筮	# [cjk] */
{ 0xE2AD,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-15 箝	# [cjk] */
{ 0xE2AE,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-16 箘	# [cjk] */
{ 0xE2AF,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-17 箟	# [cjk] */
{ 0xE2B0,  2, 5, { 0x07, 0x0b, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-18 箍	# [cjk] */
{ 0xE2B1,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-19 箜	# [cjk] */
{ 0xE2B2,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-20 箚	# [cjk] */
{ 0xE2B3,  2, 5, { 0x07, 0x0b, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-21 箋	# [cjk] */
{ 0xE2B4,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-22 箒	# [cjk] */
{ 0xE2B5,  2, 5, { 0x07, 0x0b, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-23 箏	# [cjk] */
{ 0xE2B6,  2, 5, { 0x07, 0x0b, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-24 筝	# [cjk] */
{ 0xE2B7,  2, 5, { 0x07, 0x0b, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-25 箙	# [cjk] */
{ 0xE2B8,  2, 5, { 0x07, 0x0b, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-26 篋	# [cjk] */
{ 0xE2B9,  2, 5, { 0x07, 0x0b, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-27 篁	# [cjk] */
{ 0xE2BA,  2, 5, { 0x07, 0x0b, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-28 篌	# [cjk] */
{ 0xE2BB,  2, 5, { 0x07, 0x0b, 0x03, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-29 篏	# [cjk] */
{ 0xE2BC,  2, 5, { 0x07, 0x0b, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-30 箴	# [cjk] */
{ 0xE2BD,  2, 5, { 0x07, 0x0b, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-31 篆	# [cjk] */
{ 0xE2BE,  2, 5, { 0x07, 0x0b, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-32 篝	# [cjk] */
{ 0xE2BF,  2, 5, { 0x07, 0x0b, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-33 篩	# [cjk] */
{ 0xE2C0,  2, 5, { 0x07, 0x0c, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-34 簑	# [cjk] */
{ 0xE2C1,  2, 5, { 0x07, 0x0c, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-35 簔	# [cjk] */
{ 0xE2C2,  2, 5, { 0x07, 0x0b, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-36 篦	# [cjk] */
{ 0xE2C3,  2, 5, { 0x07, 0x0b, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-37 篥	# [cjk] */
{ 0xE2C4,  2, 5, { 0x07, 0x0c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-38 籠	# [cjk] */
{ 0xE2C5,  2, 5, { 0x07, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-39 簀	# [cjk] */
{ 0xE2C6,  2, 5, { 0x07, 0x0c, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-40 簇	# [cjk] */
{ 0xE2C7,  2, 5, { 0x07, 0x0c, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-41 簓	# [cjk] */
{ 0xE2C8,  2, 5, { 0x07, 0x0b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-42 篳	# [cjk] */
{ 0xE2C9,  2, 5, { 0x07, 0x0b, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-43 篷	# [cjk] */
{ 0xE2CA,  2, 5, { 0x07, 0x0c, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-44 簗	# [cjk] */
{ 0xE2CB,  2, 5, { 0x07, 0x0c, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-45 簍	# [cjk] */
{ 0xE2CC,  2, 5, { 0x07, 0x0b, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-46 篶	# [cjk] */
{ 0xE2CD,  2, 5, { 0x07, 0x0c, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-47 簣	# [cjk] */
{ 0xE2CE,  2, 5, { 0x07, 0x0c, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-48 簧	# [cjk] */
{ 0xE2CF,  2, 5, { 0x07, 0x0c, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-49 簪	# [cjk] */
{ 0xE2D0,  2, 5, { 0x07, 0x0c, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-50 簟	# [cjk] */
{ 0xE2D1,  2, 5, { 0x07, 0x0c, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-51 簷	# [cjk] */
{ 0xE2D2,  2, 5, { 0x07, 0x0c, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-52 簫	# [cjk] */
{ 0xE2D3,  2, 5, { 0x07, 0x0c, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-53 簽	# [cjk] */
{ 0xE2D4,  2, 5, { 0x07, 0x0c, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-54 籌	# [cjk] */
{ 0xE2D5,  2, 5, { 0x07, 0x0c, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-55 籃	# [cjk] */
{ 0xE2D6,  2, 5, { 0x07, 0x0c, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-56 籔	# [cjk] */
{ 0xE2D7,  2, 5, { 0x07, 0x0c, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-57 籏	# [cjk] */
{ 0xE2D8,  2, 5, { 0x07, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-58 籀	# [cjk] */
{ 0xE2D9,  2, 5, { 0x07, 0x0c, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-59 籐	# [cjk] */
{ 0xE2DA,  2, 5, { 0x07, 0x0c, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-60 籘	# [cjk] */
{ 0xE2DB,  2, 5, { 0x07, 0x0c, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-61 籟	# [cjk] */
{ 0xE2DC,  2, 5, { 0x07, 0x0c, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-62 籤	# [cjk] */
{ 0xE2DD,  2, 5, { 0x07, 0x0c, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-63 籖	# [cjk] */
{ 0xE2DE,  2, 5, { 0x07, 0x0c, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-64 籥	# [cjk] */
{ 0xE2DF,  2, 5, { 0x07, 0x0c, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-65 籬	# [cjk] */
{ 0xE2E0,  2, 5, { 0x07, 0x0c, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-66 籵	# [cjk] */
{ 0xE2E1,  2, 5, { 0x07, 0x0c, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-67 粃	# [cjk] */
{ 0xE2E2,  2, 5, { 0x07, 0x0c, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-68 粐	# [cjk] */
{ 0xE2E3,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-69 粤	# [cjk] */
{ 0xE2E4,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-70 粭	# [cjk] */
{ 0xE2E5,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-71 粢	# [cjk] */
{ 0xE2E6,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-72 粫	# [cjk] */
{ 0xE2E7,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-73 粡	# [cjk] */
{ 0xE2E8,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-74 粨	# [cjk] */
{ 0xE2E9,  2, 5, { 0x07, 0x0c, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-75 粳	# [cjk] */
{ 0xE2EA,  2, 5, { 0x07, 0x0c, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-76 粲	# [cjk] */
{ 0xE2EB,  2, 5, { 0x07, 0x0c, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-77 粱	# [cjk] */
{ 0xE2EC,  2, 5, { 0x07, 0x0c, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-78 粮	# [cjk] */
{ 0xE2ED,  2, 5, { 0x07, 0x0c, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-79 粹	# [cjk] */
{ 0xE2EE,  2, 5, { 0x07, 0x0c, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-80 粽	# [cjk] */
{ 0xE2EF,  2, 5, { 0x07, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-81 糀	# [cjk] */
{ 0xE2F0,  2, 5, { 0x07, 0x0c, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-82 糅	# [cjk] */
{ 0xE2F1,  2, 5, { 0x07, 0x0c, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-83 糂	# [cjk] */
{ 0xE2F2,  2, 5, { 0x07, 0x0c, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-84 糘	# [cjk] */
{ 0xE2F3,  2, 5, { 0x07, 0x0c, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-85 糒	# [cjk] */
{ 0xE2F4,  2, 5, { 0x07, 0x0c, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-86 糜	# [cjk] */
{ 0xE2F5,  2, 5, { 0x07, 0x0c, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-87 糢	# [cjk] */
{ 0xE2F6,  2, 5, { 0x09, 0x0b, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-88 鬻	# [cjk] */
{ 0xE2F7,  2, 5, { 0x07, 0x0c, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-89 糯	# [cjk] */
{ 0xE2F8,  2, 5, { 0x07, 0x0c, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-90 糲	# [cjk] */
{ 0xE2F9,  2, 5, { 0x07, 0x0c, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-91 糴	# [cjk] */
{ 0xE2FA,  2, 5, { 0x07, 0x0c, 0x03, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-92 糶	# [cjk] */
{ 0xE2FB,  2, 5, { 0x07, 0x0c, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-93 糺	# [cjk] */
{ 0xE2FC,  2, 5, { 0x07, 0x0d, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-68-94 紆	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE340,  2, 5, { 0x07, 0x0d, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-01 紂	# [cjk] */
{ 0xE341,  2, 5, { 0x07, 0x0d, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-02 紜	# [cjk] */
{ 0xE342,  2, 5, { 0x07, 0x0d, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-03 紕	# [cjk] */
{ 0xE343,  2, 5, { 0x07, 0x0d, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-04 紊	# [cjk] */
{ 0xE344,  2, 5, { 0x07, 0x0d, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-05 絅	# [cjk] */
{ 0xE345,  2, 5, { 0x07, 0x0d, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-06 絋	# [cjk] */
{ 0xE346,  2, 5, { 0x07, 0x0d, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-07 紮	# [cjk] */
{ 0xE347,  2, 5, { 0x07, 0x0d, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-08 紲	# [cjk] */
{ 0xE348,  2, 5, { 0x07, 0x0d, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-09 紿	# [cjk] */
{ 0xE349,  2, 5, { 0x07, 0x0d, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-10 紵	# [cjk] */
{ 0xE34A,  2, 5, { 0x07, 0x0d, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-11 絆	# [cjk] */
{ 0xE34B,  2, 5, { 0x07, 0x0d, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-12 絳	# [cjk] */
{ 0xE34C,  2, 5, { 0x07, 0x0d, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-13 絖	# [cjk] */
{ 0xE34D,  2, 5, { 0x07, 0x0d, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-14 絎	# [cjk] */
{ 0xE34E,  2, 5, { 0x07, 0x0d, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-15 絲	# [cjk] */
{ 0xE34F,  2, 5, { 0x07, 0x0d, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-16 絨	# [cjk] */
{ 0xE350,  2, 5, { 0x07, 0x0d, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-17 絮	# [cjk] */
{ 0xE351,  2, 5, { 0x07, 0x0d, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-18 絏	# [cjk] */
{ 0xE352,  2, 5, { 0x07, 0x0d, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-19 絣	# [cjk] */
{ 0xE353,  2, 5, { 0x07, 0x0d, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-20 經	# [cjk] */
{ 0xE354,  2, 5, { 0x07, 0x0d, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-21 綉	# [cjk] */
{ 0xE355,  2, 5, { 0x07, 0x0d, 0x01, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-22 絛	# [cjk] */
{ 0xE356,  2, 5, { 0x07, 0x0d, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-23 綏	# [cjk] */
{ 0xE357,  2, 5, { 0x07, 0x0d, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-24 絽	# [cjk] */
{ 0xE358,  2, 5, { 0x07, 0x0d, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-25 綛	# [cjk] */
{ 0xE359,  2, 5, { 0x07, 0x0d, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-26 綺	# [cjk] */
{ 0xE35A,  2, 5, { 0x07, 0x0d, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-27 綮	# [cjk] */
{ 0xE35B,  2, 5, { 0x07, 0x0d, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-28 綣	# [cjk] */
{ 0xE35C,  2, 5, { 0x07, 0x0d, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-29 綵	# [cjk] */
{ 0xE35D,  2, 5, { 0x07, 0x0d, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-30 緇	# [cjk] */
{ 0xE35E,  2, 5, { 0x07, 0x0d, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-31 綽	# [cjk] */
{ 0xE35F,  2, 5, { 0x07, 0x0d, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-32 綫	# [cjk] */
{ 0xE360,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-33 總	# [cjk] */
{ 0xE361,  2, 5, { 0x07, 0x0d, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-34 綢	# [cjk] */
{ 0xE362,  2, 5, { 0x07, 0x0d, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-35 綯	# [cjk] */
{ 0xE363,  2, 5, { 0x07, 0x0d, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-36 緜	# [cjk] */
{ 0xE364,  2, 5, { 0x07, 0x0d, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-37 綸	# [cjk] */
{ 0xE365,  2, 5, { 0x07, 0x0d, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-38 綟	# [cjk] */
{ 0xE366,  2, 5, { 0x07, 0x0d, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-39 綰	# [cjk] */
{ 0xE367,  2, 5, { 0x07, 0x0d, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-40 緘	# [cjk] */
{ 0xE368,  2, 5, { 0x07, 0x0d, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-41 緝	# [cjk] */
{ 0xE369,  2, 5, { 0x07, 0x0d, 0x03, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-42 緤	# [cjk] */
{ 0xE36A,  2, 5, { 0x07, 0x0d, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-43 緞	# [cjk] */
{ 0xE36B,  2, 5, { 0x07, 0x0d, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-44 緻	# [cjk] */
{ 0xE36C,  2, 5, { 0x07, 0x0d, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-45 緲	# [cjk] */
{ 0xE36D,  2, 5, { 0x07, 0x0d, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-46 緡	# [cjk] */
{ 0xE36E,  2, 5, { 0x07, 0x0e, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-47 縅	# [cjk] */
{ 0xE36F,  2, 5, { 0x07, 0x0e, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-48 縊	# [cjk] */
{ 0xE370,  2, 5, { 0x07, 0x0e, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-49 縣	# [cjk] */
{ 0xE371,  2, 5, { 0x07, 0x0e, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-50 縡	# [cjk] */
{ 0xE372,  2, 5, { 0x07, 0x0e, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-51 縒	# [cjk] */
{ 0xE373,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-52 縱	# [cjk] */
{ 0xE374,  2, 5, { 0x07, 0x0e, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-53 縟	# [cjk] */
{ 0xE375,  2, 5, { 0x07, 0x0e, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-54 縉	# [cjk] */
{ 0xE376,  2, 5, { 0x07, 0x0e, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-55 縋	# [cjk] */
{ 0xE377,  2, 5, { 0x07, 0x0e, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-56 縢	# [cjk] */
{ 0xE378,  2, 5, { 0x07, 0x0e, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-57 繆	# [cjk] */
{ 0xE379,  2, 5, { 0x07, 0x0e, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-58 繦	# [cjk] */
{ 0xE37A,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-59 縻	# [cjk] */
{ 0xE37B,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-60 縵	# [cjk] */
{ 0xE37C,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-61 縹	# [cjk] */
{ 0xE37D,  2, 5, { 0x07, 0x0e, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-62 繃	# [cjk] */
{ 0xE37E,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-63 縷	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE380,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-64 縲	# [cjk] */
{ 0xE381,  2, 5, { 0x07, 0x0e, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-65 縺	# [cjk] */
{ 0xE382,  2, 5, { 0x07, 0x0e, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-66 繧	# [cjk] */
{ 0xE383,  2, 5, { 0x07, 0x0e, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-67 繝	# [cjk] */
{ 0xE384,  2, 5, { 0x07, 0x0e, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-68 繖	# [cjk] */
{ 0xE385,  2, 5, { 0x07, 0x0e, 0x01, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-69 繞	# [cjk] */
{ 0xE386,  2, 5, { 0x07, 0x0e, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-70 繙	# [cjk] */
{ 0xE387,  2, 5, { 0x07, 0x0e, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-71 繚	# [cjk] */
{ 0xE388,  2, 5, { 0x07, 0x0e, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-72 繹	# [cjk] */
{ 0xE389,  2, 5, { 0x07, 0x0e, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-73 繪	# [cjk] */
{ 0xE38A,  2, 5, { 0x07, 0x0e, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-74 繩	# [cjk] */
{ 0xE38B,  2, 5, { 0x07, 0x0e, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-75 繼	# [cjk] */
{ 0xE38C,  2, 5, { 0x07, 0x0e, 0x01, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-76 繻	# [cjk] */
{ 0xE38D,  2, 5, { 0x07, 0x0e, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-77 纃	# [cjk] */
{ 0xE38E,  2, 5, { 0x07, 0x0d, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-78 緕	# [cjk] */
{ 0xE38F,  2, 5, { 0x07, 0x0e, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-79 繽	# [cjk] */
{ 0xE390,  2, 5, { 0x08, 0x0f, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-80 辮	# [cjk] */
{ 0xE391,  2, 5, { 0x07, 0x0e, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-81 繿	# [cjk] */
{ 0xE392,  2, 5, { 0x07, 0x0e, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-82 纈	# [cjk] */
{ 0xE393,  2, 5, { 0x07, 0x0e, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-83 纉	# [cjk] */
{ 0xE394,  2, 5, { 0x07, 0x0e, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-84 續	# [cjk] */
{ 0xE395,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-85 纒	# [cjk] */
{ 0xE396,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-86 纐	# [cjk] */
{ 0xE397,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-87 纓	# [cjk] */
{ 0xE398,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-88 纔	# [cjk] */
{ 0xE399,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-89 纖	# [cjk] */
{ 0xE39A,  2, 5, { 0x07, 0x0e, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-90 纎	# [cjk] */
{ 0xE39B,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-91 纛	# [cjk] */
{ 0xE39C,  2, 5, { 0x07, 0x0e, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-92 纜	# [cjk] */
{ 0xE39D,  2, 5, { 0x07, 0x0f, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-93 缸	# [cjk] */
{ 0xE39E,  2, 5, { 0x07, 0x0f, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-69-94 缺	# [cjk] */
{ 0xE39F,  2, 5, { 0x07, 0x0f, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-01 罅	# [cjk] */
{ 0xE3A0,  2, 5, { 0x07, 0x0f, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-02 罌	# [cjk] */
{ 0xE3A1,  2, 5, { 0x07, 0x0f, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-03 罍	# [cjk] */
{ 0xE3A2,  2, 5, { 0x07, 0x0f, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-04 罎	# [cjk] */
{ 0xE3A3,  2, 5, { 0x07, 0x0f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-05 罐	# [cjk] */
{ 0xE3A4,  2, 5, { 0x07, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-06 网	# [cjk] */
{ 0xE3A5,  2, 5, { 0x07, 0x0f, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-07 罕	# [cjk] */
{ 0xE3A6,  2, 5, { 0x07, 0x0f, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-08 罔	# [cjk] */
{ 0xE3A7,  2, 5, { 0x07, 0x0f, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-09 罘	# [cjk] */
{ 0xE3A8,  2, 5, { 0x07, 0x0f, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-10 罟	# [cjk] */
{ 0xE3A9,  2, 5, { 0x07, 0x0f, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-11 罠	# [cjk] */
{ 0xE3AA,  2, 5, { 0x07, 0x0f, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-12 罨	# [cjk] */
{ 0xE3AB,  2, 5, { 0x07, 0x0f, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-13 罩	# [cjk] */
{ 0xE3AC,  2, 5, { 0x07, 0x0f, 0x01, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-14 罧	# [cjk] */
{ 0xE3AD,  2, 5, { 0x07, 0x0f, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-15 罸	# [cjk] */
{ 0xE3AE,  2, 5, { 0x07, 0x0f, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-16 羂	# [cjk] */
{ 0xE3AF,  2, 5, { 0x07, 0x0f, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-17 羆	# [cjk] */
{ 0xE3B0,  2, 5, { 0x07, 0x0f, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-18 羃	# [cjk] */
{ 0xE3B1,  2, 5, { 0x07, 0x0f, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-19 羈	# [cjk] */
{ 0xE3B2,  2, 5, { 0x07, 0x0f, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-20 羇	# [cjk] */
{ 0xE3B3,  2, 5, { 0x07, 0x0f, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-21 羌	# [cjk] */
{ 0xE3B4,  2, 5, { 0x07, 0x0f, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-22 羔	# [cjk] */
{ 0xE3B5,  2, 5, { 0x07, 0x0f, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-23 羞	# [cjk] */
{ 0xE3B6,  2, 5, { 0x07, 0x0f, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-24 羝	# [cjk] */
{ 0xE3B7,  2, 5, { 0x07, 0x0f, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-25 羚	# [cjk] */
{ 0xE3B8,  2, 5, { 0x07, 0x0f, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-26 羣	# [cjk] */
{ 0xE3B9,  2, 5, { 0x07, 0x0f, 0x02, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-27 羯	# [cjk] */
{ 0xE3BA,  2, 5, { 0x07, 0x0f, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-28 羲	# [cjk] */
{ 0xE3BB,  2, 5, { 0x07, 0x0f, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-29 羹	# [cjk] */
{ 0xE3BC,  2, 5, { 0x07, 0x0f, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-30 羮	# [cjk] */
{ 0xE3BD,  2, 5, { 0x07, 0x0f, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-31 羶	# [cjk] */
{ 0xE3BE,  2, 5, { 0x07, 0x0f, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-32 羸	# [cjk] */
{ 0xE3BF,  2, 5, { 0x08, 0x0b, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-33 譱	# [cjk] */
{ 0xE3C0,  2, 5, { 0x07, 0x0f, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-34 翅	# [cjk] */
{ 0xE3C1,  2, 5, { 0x07, 0x0f, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-35 翆	# [cjk] */
{ 0xE3C2,  2, 5, { 0x07, 0x0f, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-36 翊	# [cjk] */
{ 0xE3C3,  2, 5, { 0x07, 0x0f, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-37 翕	# [cjk] */
{ 0xE3C4,  2, 5, { 0x07, 0x0f, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-38 翔	# [cjk] */
{ 0xE3C5,  2, 5, { 0x07, 0x0f, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-39 翡	# [cjk] */
{ 0xE3C6,  2, 5, { 0x07, 0x0f, 0x03, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-40 翦	# [cjk] */
{ 0xE3C7,  2, 5, { 0x07, 0x0f, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-41 翩	# [cjk] */
{ 0xE3C8,  2, 5, { 0x07, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-42 翳	# [cjk] */
{ 0xE3C9,  2, 5, { 0x07, 0x0f, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-43 翹	# [cjk] */
{ 0xE3CA,  2, 5, { 0x09, 0x08, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-44 飜	# [cjk] */
{ 0xE3CB,  2, 5, { 0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-45 耆	# [cjk] */
{ 0xE3CC,  2, 5, { 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-46 耄	# [cjk] */
{ 0xE3CD,  2, 5, { 0x08, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-47 耋	# [cjk] */
{ 0xE3CE,  2, 5, { 0x08, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-48 耒	# [cjk] */
{ 0xE3CF,  2, 5, { 0x08, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-49 耘	# [cjk] */
{ 0xE3D0,  2, 5, { 0x08, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-50 耙	# [cjk] */
{ 0xE3D1,  2, 5, { 0x08, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-51 耜	# [cjk] */
{ 0xE3D2,  2, 5, { 0x08, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-52 耡	# [cjk] */
{ 0xE3D3,  2, 5, { 0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-53 耨	# [cjk] */
{ 0xE3D4,  2, 5, { 0x08, 0x00, 0x00, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-54 耿	# [cjk] */
{ 0xE3D5,  2, 5, { 0x08, 0x00, 0x00, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-55 耻	# [cjk] */
{ 0xE3D6,  2, 5, { 0x08, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-56 聊	# [cjk] */
{ 0xE3D7,  2, 5, { 0x08, 0x00, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-57 聆	# [cjk] */
{ 0xE3D8,  2, 5, { 0x08, 0x00, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-58 聒	# [cjk] */
{ 0xE3D9,  2, 5, { 0x08, 0x00, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-59 聘	# [cjk] */
{ 0xE3DA,  2, 5, { 0x08, 0x00, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-60 聚	# [cjk] */
{ 0xE3DB,  2, 5, { 0x08, 0x00, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-61 聟	# [cjk] */
{ 0xE3DC,  2, 5, { 0x08, 0x00, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-62 聢	# [cjk] */
{ 0xE3DD,  2, 5, { 0x08, 0x00, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-63 聨	# [cjk] */
{ 0xE3DE,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-64 聳	# [cjk] */
{ 0xE3DF,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-65 聲	# [cjk] */
{ 0xE3E0,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-66 聰	# [cjk] */
{ 0xE3E1,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-67 聶	# [cjk] */
{ 0xE3E2,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-68 聹	# [cjk] */
{ 0xE3E3,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-69 聽	# [cjk] */
{ 0xE3E4,  2, 5, { 0x08, 0x00, 0x01, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-70 聿	# [cjk] */
{ 0xE3E5,  2, 5, { 0x08, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-71 肄	# [cjk] */
{ 0xE3E6,  2, 5, { 0x08, 0x00, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-72 肆	# [cjk] */
{ 0xE3E7,  2, 5, { 0x08, 0x00, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-73 肅	# [cjk] */
{ 0xE3E8,  2, 5, { 0x08, 0x00, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-74 肛	# [cjk] */
{ 0xE3E9,  2, 5, { 0x08, 0x00, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-75 肓	# [cjk] */
{ 0xE3EA,  2, 5, { 0x08, 0x00, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-76 肚	# [cjk] */
{ 0xE3EB,  2, 5, { 0x08, 0x00, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-77 肭	# [cjk] */
{ 0xE3EC,  2, 5, { 0x05, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-78 冐	# [cjk] */
{ 0xE3ED,  2, 5, { 0x08, 0x00, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-79 肬	# [cjk] */
{ 0xE3EE,  2, 5, { 0x08, 0x00, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-80 胛	# [cjk] */
{ 0xE3EF,  2, 5, { 0x08, 0x00, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-81 胥	# [cjk] */
{ 0xE3F0,  2, 5, { 0x08, 0x00, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-82 胙	# [cjk] */
{ 0xE3F1,  2, 5, { 0x08, 0x00, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-83 胝	# [cjk] */
{ 0xE3F2,  2, 5, { 0x08, 0x00, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-84 胄	# [cjk] */
{ 0xE3F3,  2, 5, { 0x08, 0x00, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-85 胚	# [cjk] */
{ 0xE3F4,  2, 5, { 0x08, 0x00, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-86 胖	# [cjk] */
{ 0xE3F5,  2, 5, { 0x08, 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-87 脉	# [cjk] */
{ 0xE3F6,  2, 5, { 0x08, 0x00, 0x03, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-88 胯	# [cjk] */
{ 0xE3F7,  2, 5, { 0x08, 0x00, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-89 胱	# [cjk] */
{ 0xE3F8,  2, 5, { 0x08, 0x01, 0x00, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-90 脛	# [cjk] */
{ 0xE3F9,  2, 5, { 0x08, 0x01, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-91 脩	# [cjk] */
{ 0xE3FA,  2, 5, { 0x08, 0x01, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-92 脣	# [cjk] */
{ 0xE3FB,  2, 5, { 0x08, 0x01, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-93 脯	# [cjk] */
{ 0xE3FC,  2, 5, { 0x08, 0x01, 0x01, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-70-94 腋	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE440,  2, 5, { 0x09, 0x06, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-01 隋	# [cjk] */
{ 0xE441,  2, 5, { 0x08, 0x01, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-02 腆	# [cjk] */
{ 0xE442,  2, 5, { 0x08, 0x01, 0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-03 脾	# [cjk] */
{ 0xE443,  2, 5, { 0x08, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-04 腓	# [cjk] */
{ 0xE444,  2, 5, { 0x08, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-05 腑	# [cjk] */
{ 0xE445,  2, 5, { 0x08, 0x00, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-06 胼	# [cjk] */
{ 0xE446,  2, 5, { 0x08, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-07 腱	# [cjk] */
{ 0xE447,  2, 5, { 0x08, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-08 腮	# [cjk] */
{ 0xE448,  2, 5, { 0x08, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-09 腥	# [cjk] */
{ 0xE449,  2, 5, { 0x08, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-10 腦	# [cjk] */
{ 0xE44A,  2, 5, { 0x08, 0x01, 0x01, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-11 腴	# [cjk] */
{ 0xE44B,  2, 5, { 0x08, 0x01, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-12 膃	# [cjk] */
{ 0xE44C,  2, 5, { 0x08, 0x01, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-13 膈	# [cjk] */
{ 0xE44D,  2, 5, { 0x08, 0x01, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-14 膊	# [cjk] */
{ 0xE44E,  2, 5, { 0x08, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-15 膀	# [cjk] */
{ 0xE44F,  2, 5, { 0x08, 0x01, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-16 膂	# [cjk] */
{ 0xE450,  2, 5, { 0x08, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-17 膠	# [cjk] */
{ 0xE451,  2, 5, { 0x08, 0x01, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-18 膕	# [cjk] */
{ 0xE452,  2, 5, { 0x08, 0x01, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-19 膤	# [cjk] */
{ 0xE453,  2, 5, { 0x08, 0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-20 膣	# [cjk] */
{ 0xE454,  2, 5, { 0x08, 0x01, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-21 腟	# [cjk] */
{ 0xE455,  2, 5, { 0x08, 0x01, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-22 膓	# [cjk] */
{ 0xE456,  2, 5, { 0x08, 0x01, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-23 膩	# [cjk] */
{ 0xE457,  2, 5, { 0x08, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-24 膰	# [cjk] */
{ 0xE458,  2, 5, { 0x08, 0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-25 膵	# [cjk] */
{ 0xE459,  2, 5, { 0x08, 0x01, 0x02, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-26 膾	# [cjk] */
{ 0xE45A,  2, 5, { 0x08, 0x01, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-27 膸	# [cjk] */
{ 0xE45B,  2, 5, { 0x08, 0x01, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-28 膽	# [cjk] */
{ 0xE45C,  2, 5, { 0x08, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-29 臀	# [cjk] */
{ 0xE45D,  2, 5, { 0x08, 0x01, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-30 臂	# [cjk] */
{ 0xE45E,  2, 5, { 0x08, 0x01, 0x02, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-31 膺	# [cjk] */
{ 0xE45F,  2, 5, { 0x08, 0x01, 0x03, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-32 臉	# [cjk] */
{ 0xE460,  2, 5, { 0x08, 0x01, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-33 臍	# [cjk] */
{ 0xE461,  2, 5, { 0x08, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-34 臑	# [cjk] */
{ 0xE462,  2, 5, { 0x08, 0x01, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-35 臙	# [cjk] */
{ 0xE463,  2, 5, { 0x08, 0x01, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-36 臘	# [cjk] */
{ 0xE464,  2, 5, { 0x08, 0x01, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-37 臈	# [cjk] */
{ 0xE465,  2, 5, { 0x08, 0x01, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-38 臚	# [cjk] */
{ 0xE466,  2, 5, { 0x08, 0x01, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-39 臟	# [cjk] */
{ 0xE467,  2, 5, { 0x08, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-40 臠	# [cjk] */
{ 0xE468,  2, 5, { 0x08, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-41 臧	# [cjk] */
{ 0xE469,  2, 5, { 0x08, 0x01, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-42 臺	# [cjk] */
{ 0xE46A,  2, 5, { 0x08, 0x01, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-43 臻	# [cjk] */
{ 0xE46B,  2, 5, { 0x08, 0x01, 0x03, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-44 臾	# [cjk] */
{ 0xE46C,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-45 舁	# [cjk] */
{ 0xE46D,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-46 舂	# [cjk] */
{ 0xE46E,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-47 舅	# [cjk] */
{ 0xE46F,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-48 與	# [cjk] */
{ 0xE470,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-49 舊	# [cjk] */
{ 0xE471,  2, 5, { 0x08, 0x02, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-50 舍	# [cjk] */
{ 0xE472,  2, 5, { 0x08, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-51 舐	# [cjk] */
{ 0xE473,  2, 5, { 0x08, 0x02, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-52 舖	# [cjk] */
{ 0xE474,  2, 5, { 0x08, 0x02, 0x00, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-53 舩	# [cjk] */
{ 0xE475,  2, 5, { 0x08, 0x02, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-54 舫	# [cjk] */
{ 0xE476,  2, 5, { 0x08, 0x02, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-55 舸	# [cjk] */
{ 0xE477,  2, 5, { 0x08, 0x02, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-56 舳	# [cjk] */
{ 0xE478,  2, 5, { 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-57 艀	# [cjk] */
{ 0xE479,  2, 5, { 0x08, 0x02, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-58 艙	# [cjk] */
{ 0xE47A,  2, 5, { 0x08, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-59 艘	# [cjk] */
{ 0xE47B,  2, 5, { 0x08, 0x02, 0x01, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-60 艝	# [cjk] */
{ 0xE47C,  2, 5, { 0x08, 0x02, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-61 艚	# [cjk] */
{ 0xE47D,  2, 5, { 0x08, 0x02, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-62 艟	# [cjk] */
{ 0xE47E,  2, 5, { 0x08, 0x02, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-63 艤	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0xE480,  2, 5, { 0x08, 0x02, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-64 艢	# [cjk] */
{ 0xE481,  2, 5, { 0x08, 0x02, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-65 艨	# [cjk] */
{ 0xE482,  2, 5, { 0x08, 0x02, 0x01, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-66 艪	# [cjk] */
{ 0xE483,  2, 5, { 0x08, 0x02, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-67 艫	# [cjk] */
{ 0xE484,  2, 5, { 0x08, 0x02, 0x00, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-68 舮	# [cjk] */
{ 0xE485,  2, 5, { 0x08, 0x02, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-69 艱	# [cjk] */
{ 0xE486,  2, 5, { 0x08, 0x02, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-70 艷	# [cjk] */
{ 0xE487,  2, 5, { 0x08, 0x02, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-71 艸	# [cjk] */
{ 0xE488,  2, 5, { 0x08, 0x02, 0x01, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-72 艾	# [cjk] */
{ 0xE489,  2, 5, { 0x08, 0x02, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-73 芍	# [cjk] */
{ 0xE48A,  2, 5, { 0x08, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-74 芒	# [cjk] */
{ 0xE48B,  2, 5, { 0x08, 0x02, 0x02, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-75 芫	# [cjk] */
{ 0xE48C,  2, 5, { 0x08, 0x02, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-76 芟	# [cjk] */
{ 0xE48D,  2, 5, { 0x08, 0x02, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-77 芻	# [cjk] */
{ 0xE48E,  2, 5, { 0x08, 0x02, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-78 芬	# [cjk] */
{ 0xE48F,  2, 5, { 0x08, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-79 苡	# [cjk] */
{ 0xE490,  2, 5, { 0x08, 0x02, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-80 苣	# [cjk] */
{ 0xE491,  2, 5, { 0x08, 0x02, 0x03, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-81 苟	# [cjk] */
{ 0xE492,  2, 5, { 0x08, 0x02, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-82 苒	# [cjk] */
{ 0xE493,  2, 5, { 0x08, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-83 苴	# [cjk] */
{ 0xE494,  2, 5, { 0x08, 0x02, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-84 苳	# [cjk] */
{ 0xE495,  2, 5, { 0x08, 0x02, 0x03, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-85 苺	# [cjk] */
{ 0xE496,  2, 5, { 0x08, 0x03, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-86 莓	# [cjk] */
{ 0xE497,  2, 5, { 0x08, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-87 范	# [cjk] */
{ 0xE498,  2, 5, { 0x08, 0x02, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-88 苻	# [cjk] */
{ 0xE499,  2, 5, { 0x08, 0x02, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-89 苹	# [cjk] */
{ 0xE49A,  2, 5, { 0x08, 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-90 苞	# [cjk] */
{ 0xE49B,  2, 5, { 0x08, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-91 茆	# [cjk] */
{ 0xE49C,  2, 5, { 0x08, 0x02, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-92 苜	# [cjk] */
{ 0xE49D,  2, 5, { 0x08, 0x03, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-93 茉	# [cjk] */
{ 0xE49E,  2, 5, { 0x08, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-71-94 苙	# [cjk] */
{ 0xE49F,  2, 5, { 0x08, 0x03, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-01 茵	# [cjk] */
{ 0xE4A0,  2, 5, { 0x08, 0x03, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-02 茴	# [cjk] */
{ 0xE4A1,  2, 5, { 0x08, 0x03, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-03 茖	# [cjk] */
{ 0xE4A2,  2, 5, { 0x08, 0x03, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-04 茲	# [cjk] */
{ 0xE4A3,  2, 5, { 0x08, 0x03, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-05 茱	# [cjk] */
{ 0xE4A4,  2, 5, { 0x08, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-06 荀	# [cjk] */
{ 0xE4A5,  2, 5, { 0x08, 0x03, 0x00, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-07 茹	# [cjk] */
{ 0xE4A6,  2, 5, { 0x08, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-08 荐	# [cjk] */
{ 0xE4A7,  2, 5, { 0x08, 0x03, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-09 荅	# [cjk] */
{ 0xE4A8,  2, 5, { 0x08, 0x03, 0x00, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-10 茯	# [cjk] */
{ 0xE4A9,  2, 5, { 0x08, 0x03, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-11 茫	# [cjk] */
{ 0xE4AA,  2, 5, { 0x08, 0x03, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-12 茗	# [cjk] */
{ 0xE4AB,  2, 5, { 0x08, 0x03, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-13 茘	# [cjk] */
{ 0xE4AC,  2, 5, { 0x08, 0x03, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-14 莅	# [cjk] */
{ 0xE4AD,  2, 5, { 0x08, 0x03, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-15 莚	# [cjk] */
{ 0xE4AE,  2, 5, { 0x08, 0x03, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-16 莪	# [cjk] */
{ 0xE4AF,  2, 5, { 0x08, 0x03, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-17 莟	# [cjk] */
{ 0xE4B0,  2, 5, { 0x08, 0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-18 莢	# [cjk] */
{ 0xE4B1,  2, 5, { 0x08, 0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-19 莖	# [cjk] */
{ 0xE4B2,  2, 5, { 0x08, 0x03, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-20 茣	# [cjk] */
{ 0xE4B3,  2, 5, { 0x08, 0x03, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-21 莎	# [cjk] */
{ 0xE4B4,  2, 5, { 0x08, 0x03, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-22 莇	# [cjk] */
{ 0xE4B5,  2, 5, { 0x08, 0x03, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-23 莊	# [cjk] */
{ 0xE4B6,  2, 5, { 0x08, 0x03, 0x01, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-24 荼	# [cjk] */
{ 0xE4B7,  2, 5, { 0x08, 0x03, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-25 莵	# [cjk] */
{ 0xE4B8,  2, 5, { 0x08, 0x03, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-26 荳	# [cjk] */
{ 0xE4B9,  2, 5, { 0x08, 0x03, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-27 荵	# [cjk] */
{ 0xE4BA,  2, 5, { 0x08, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-28 莠	# [cjk] */
{ 0xE4BB,  2, 5, { 0x08, 0x03, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-29 莉	# [cjk] */
{ 0xE4BC,  2, 5, { 0x08, 0x03, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-30 莨	# [cjk] */
{ 0xE4BD,  2, 5, { 0x08, 0x03, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-31 菴	# [cjk] */
{ 0xE4BE,  2, 5, { 0x08, 0x04, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-32 萓	# [cjk] */
{ 0xE4BF,  2, 5, { 0x08, 0x03, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-33 菫	# [cjk] */
{ 0xE4C0,  2, 5, { 0x08, 0x03, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-34 菎	# [cjk] */
{ 0xE4C1,  2, 5, { 0x08, 0x03, 0x03, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-35 菽	# [cjk] */
{ 0xE4C2,  2, 5, { 0x08, 0x04, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-36 萃	# [cjk] */
{ 0xE4C3,  2, 5, { 0x08, 0x03, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-37 菘	# [cjk] */
{ 0xE4C4,  2, 5, { 0x08, 0x04, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-38 萋	# [cjk] */
{ 0xE4C5,  2, 5, { 0x08, 0x03, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-39 菁	# [cjk] */
{ 0xE4C6,  2, 5, { 0x08, 0x03, 0x03, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-40 菷	# [cjk] */
{ 0xE4C7,  2, 5, { 0x08, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-41 萇	# [cjk] */
{ 0xE4C8,  2, 5, { 0x08, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-42 菠	# [cjk] */
{ 0xE4C9,  2, 5, { 0x08, 0x03, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-43 菲	# [cjk] */
{ 0xE4CA,  2, 5, { 0x08, 0x04, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-44 萍	# [cjk] */
{ 0xE4CB,  2, 5, { 0x08, 0x04, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-45 萢	# [cjk] */
{ 0xE4CC,  2, 5, { 0x08, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-46 萠	# [cjk] */
{ 0xE4CD,  2, 5, { 0x08, 0x03, 0x02, 0x03, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-47 莽	# [cjk] */
{ 0xE4CE,  2, 5, { 0x08, 0x04, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-48 萸	# [cjk] */
{ 0xE4CF,  2, 5, { 0x08, 0x05, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-49 蔆	# [cjk] */
{ 0xE4D0,  2, 5, { 0x08, 0x03, 0x03, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-50 菻	# [cjk] */
{ 0xE4D1,  2, 5, { 0x08, 0x04, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-51 葭	# [cjk] */
{ 0xE4D2,  2, 5, { 0x08, 0x04, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-52 萪	# [cjk] */
{ 0xE4D3,  2, 5, { 0x08, 0x04, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-53 萼	# [cjk] */
{ 0xE4D4,  2, 5, { 0x08, 0x05, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-54 蕚	# [cjk] */
{ 0xE4D5,  2, 5, { 0x08, 0x04, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-55 蒄	# [cjk] */
{ 0xE4D6,  2, 5, { 0x08, 0x04, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-56 葷	# [cjk] */
{ 0xE4D7,  2, 5, { 0x08, 0x04, 0x01, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-57 葫	# [cjk] */
{ 0xE4D8,  2, 5, { 0x08, 0x04, 0x02, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-58 蒭	# [cjk] */
{ 0xE4D9,  2, 5, { 0x08, 0x04, 0x01, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-59 葮	# [cjk] */
{ 0xE4DA,  2, 5, { 0x08, 0x04, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-60 蒂	# [cjk] */
{ 0xE4DB,  2, 5, { 0x08, 0x04, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-61 葩	# [cjk] */
{ 0xE4DC,  2, 5, { 0x08, 0x04, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-62 葆	# [cjk] */
{ 0xE4DD,  2, 5, { 0x08, 0x04, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-63 萬	# [cjk] */
{ 0xE4DE,  2, 5, { 0x08, 0x04, 0x01, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-64 葯	# [cjk] */
{ 0xE4DF,  2, 5, { 0x08, 0x04, 0x01, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-65 葹	# [cjk] */
{ 0xE4E0,  2, 5, { 0x08, 0x04, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-66 萵	# [cjk] */
{ 0xE4E1,  2, 5, { 0x08, 0x04, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-67 蓊	# [cjk] */
{ 0xE4E2,  2, 5, { 0x08, 0x04, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-68 葢	# [cjk] */
{ 0xE4E3,  2, 5, { 0x08, 0x04, 0x02, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-69 蒹	# [cjk] */
{ 0xE4E4,  2, 5, { 0x08, 0x04, 0x02, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-70 蒿	# [cjk] */
{ 0xE4E5,  2, 5, { 0x08, 0x04, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-71 蒟	# [cjk] */
{ 0xE4E6,  2, 5, { 0x08, 0x04, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-72 蓙	# [cjk] */
{ 0xE4E7,  2, 5, { 0x08, 0x04, 0x03, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-73 蓍	# [cjk] */
{ 0xE4E8,  2, 5, { 0x08, 0x04, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-74 蒻	# [cjk] */
{ 0xE4E9,  2, 5, { 0x08, 0x04, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-75 蓚	# [cjk] */
{ 0xE4EA,  2, 5, { 0x08, 0x04, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-76 蓐	# [cjk] */
{ 0xE4EB,  2, 5, { 0x08, 0x04, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-77 蓁	# [cjk] */
{ 0xE4EC,  2, 5, { 0x08, 0x04, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-78 蓆	# [cjk] */
{ 0xE4ED,  2, 5, { 0x08, 0x04, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-79 蓖	# [cjk] */
{ 0xE4EE,  2, 5, { 0x08, 0x04, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-80 蒡	# [cjk] */
{ 0xE4EF,  2, 5, { 0x08, 0x05, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-81 蔡	# [cjk] */
{ 0xE4F0,  2, 5, { 0x08, 0x04, 0x03, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-82 蓿	# [cjk] */
{ 0xE4F1,  2, 5, { 0x08, 0x04, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-83 蓴	# [cjk] */
{ 0xE4F2,  2, 5, { 0x08, 0x05, 0x00, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-84 蔗	# [cjk] */
{ 0xE4F3,  2, 5, { 0x08, 0x05, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-85 蔘	# [cjk] */
{ 0xE4F4,  2, 5, { 0x08, 0x05, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-86 蔬	# [cjk] */
{ 0xE4F5,  2, 5, { 0x08, 0x05, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-87 蔟	# [cjk] */
{ 0xE4F6,  2, 5, { 0x08, 0x05, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-88 蔕	# [cjk] */
{ 0xE4F7,  2, 5, { 0x08, 0x05, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-89 蔔	# [cjk] */
{ 0xE4F8,  2, 5, { 0x08, 0x04, 0x03, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-90 蓼	# [cjk] */
{ 0xE4F9,  2, 5, { 0x08, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-91 蕀	# [cjk] */
{ 0xE4FA,  2, 5, { 0x08, 0x05, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-92 蕣	# [cjk] */
{ 0xE4FB,  2, 5, { 0x08, 0x05, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-93 蕘	# [cjk] */
{ 0xE4FC,  2, 5, { 0x08, 0x05, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* 1-72-94 蕈	# [cjk] */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,  0, 0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }	},	/* gap or reserve */
{ 0x0000,