/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.Map;
import java.util.WeakHashMap;

public final class Symbol extends Atom implements SymbolName {
	
	
	public static final Symbol QUOTE = getSymbol("quote");
	
	
	public static final Symbol QUASIQUOTE = getSymbol("quasiquote");
	
	
	public static final Symbol UNQUOTE = getSymbol("unquote");
	
	
	public static final Symbol UNQUOTE_SPLICING =
		getSymbol("unquote-splicing");
	
	
	//private static long genIdSeq = 1;
	private static Map<String, Symbol> flyweight;
	
	private String name;
	//private long genId = 0;
	private Symbol replace = null;
	private boolean replaced = false;
	private Symbol macroSymbol = null;
	
	
	private Symbol(String name) {
		//if(name == null) {
		//	throw new NullPointerException("Symbol");
		//}
		this.name = name;
	}
	
	
	public static Symbol getSymbol(String name) {
		Symbol res;
		
		if(name == null) {
			throw new NullPointerException("Symbol");
		}
		
		synchronized(Symbol.class) {
			if(flyweight == null) {
				//flyweight = new HashMap<String, Symbol>();
				flyweight = new WeakHashMap<String, Symbol>();
			}
			
			res = flyweight.get(name);
			if(res == null) {
				res = new Symbol(name);
				flyweight.put(name, res);
			}
		}
		return res;
	}
	
	
	/*package*/ static Symbol newAndMark(
			Map<Symbol, Symbol> box, Symbol sym, boolean mark) {
		Symbol res;
		
		if(sym == null) {
			throw new NullPointerException();
		}
		
		if(mark) {
			res = box.get(sym);
			
			if(res == null) {
				//res = new Symbol(sym.name);
				res = new Symbol(null);
				//res.genId = sym.genId;
				res.replace = sym;
				res.replaced = true;
				res.macroSymbol = sym;
				box.put(sym, res);
			}
		} else {
			if(!sym.replaced) {
				res = sym;
			} else if((res = sym.replace) == null) {
				throw new NullPointerException();
			}
		}
		return res;
	}
	
	
	public static Symbol gensym() {
		Symbol res = new Symbol(null);
		
		//res.genId = genIdSeq++;
		return res;
	}
	
	
	public static Symbol encloseSymbol(Symbol sym) {
		Symbol res = new Symbol(null);
		
		//res.genId = genIdSeq++;
		res.macroSymbol = sym.macroSymbol;
		return res;
	}
	
	
	public boolean isEqv(Atom a) {
		return equals(a);
	}
	
	
	public String getName() {
		//return (genId != 0) ? "#" + name + genId : name;
		return (name == null) ? "#:" + hashCode() : name;
	}
	
	
	public boolean isGenerated() {
		//return genId > 0;
		return name == null;
	}
	
	/**
	 * @return the replaced
	 */
	public boolean isReplaced() {
		return replace != null;
	}
	
	
	public LispString toLispString() {
		return new LispString(getName());
	}
	
	
	public String print() {
		return getName();
	}
	
	
	public String getResult() {
		return getName();
	}
	
	
	/*
	public boolean equals(Object o) {
		if(o instanceof Symbol) {
			Symbol s = (Symbol)o;
			
			return (name.equals(s.name) &&
					(genId == s.genId) &&
					(replaced == s.replaced));
		}
		return false;
	}
	
	
	public int hashCode() {
		int l = 17;
		
		l = 37 * l + name.hashCode();
		l = 37 * l + (int)(l ^ (l >>> 32));
		return l;
	}
	*/
	
	
	/*package*/ Symbol getEnclosedSymbol() {
		Symbol sym = this;
		
		while(sym.macroSymbol != null) {
			sym = sym.macroSymbol;
		}
		return sym;
		//return macroSymbol;
	}
	
	
	/*package*/ /*Symbol getReplacedRoot() {
		Symbol sym = this;
		
		while(sym.replace != null) {
			sym = sym.replace;
		}
		return sym;
	}*/
	
	
	public String toString() {
		return "Symbol:" + getName();
	}
	
	
	public boolean isTypeSymbol() {
		return true;
	}
	
}
