/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.morilib.lisp.util.NullSet;


/*package*/ class PatternMatch {
	
	private static final Datum ELLIPSIS = Symbol.getSymbol("...");
	private static final Datum UNDERBAR = Symbol.getSymbol("_");
	private static final int PATTERN = 0;
	private static final int TEMPLATE = 1;
	
	
	/*// ͤȥѥ᡼ѥե饰ξ뤿ΥǡǼ饹
	private static class D2 {
		private Datum d;          // ͤȤʤǡ
		private boolean useprm;   // ѥ᡼Ѥ줿Ȥtrue
		
		private D2() {
			// default
			useprm = false;
		}
		
		private D2(Datum d, boolean useprm) {
			this.d = d;
			this.useprm = useprm;
		}
		
	}*/
	
	
	private static Datum compilePattern1(
			Datum src,
			PatternDepthMap mp,
			int typ,
			Set<Symbol> st,
			Set<Symbol> reserve) throws PatternEllipsisException {
		Datum d = src;
		Datum res = null;
		Cons  rp  = null;
		
		while(true) {
			if(d instanceof Cons) {
				Cons c = (Cons)d;
				Cons n = new Cons();
				Datum car;
				
				if(ELLIPSIS.equals(c.getCar())) {
					throw new PatternEllipsisException();
				}
				
				// car򥳥ѥ
				car = compilePattern1(c.getCar(), mp, typ, st, reserve);
				
				// cadr"..."ΤȤϷ֤Ȥ
				if(c.getCdr() instanceof Cons) {
					Cons c2 = (Cons)c.getCdr();
					
					if(ELLIPSIS.equals(c2.getCar())) {
						Datum n2;
						
						if(c.getCar() instanceof Symbol) {
							if(reserve.contains((Symbol)c.getCar())) {
								throw new PatternEllipsisException();
							}
						}
						
						if(typ == PATTERN) {
							// cddrNILޤAtomǤʤȤϥ顼
							// Ϻͽ
							if(c2.getCdr() instanceof Cons) {
								throw new LispException("bad ellipsis");
							}
							
							// ѥ᡼ǻѤƤ륷ܥ򽸹ɲ
							if(c2.getCdr() instanceof Symbol) {
								st.add((Symbol)c2.getCdr());
							}
							
							// άɲ
							n2 = new PatternIntEllipsis(car, c2.getCdr());
						} else if(typ == TEMPLATE) {
							Datum cdr2;
							
							// ֤ܥ뤬ʤȤ
							// 0ʾη֤βǽ
							//if(!car2.useprm) {
								//throw new LispException(
								//		"no repetition symbol");
							//}
							
							cdr2 = compilePattern1(
									c2.getCdr(), mp, typ, st, reserve);
							n2 = new PatternIntEllipsis(car, cdr2);
						} else {
							throw new RuntimeException();
						}
						
						// cdrɲäæ
						if(rp == null) {
							res = n2;
							//res.useprm = res.useprm || car2.useprm;
						} else {
							rp.setCdr(n2);
						}
						break;
					}
				}
				n.setCar(car);
				
				// cdrɲ
				if(rp == null) {
					res = rp = n;
					//res.useprm = res.useprm || car2.useprm;
				} else {
					rp.setCdr(n);
					rp = n;
				}
				d = c.getCdr();
			} else if(d instanceof LispVector) {
				LispVector v = (LispVector)d;
				List<Datum> rv = new ArrayList<Datum>();
				
				for(int i = 0; i < v.size(); i++) {
					Datum v1;
					
					v1 = compilePattern1(v.get(i), mp, typ, st, reserve);
					
					if(i < v.size() - 1 &&
							ELLIPSIS.equals(v.get(i + 1))) {
						if(v.get(i) instanceof Symbol) {
							if(reserve.contains((Symbol)v.get(i))) {
								throw new PatternEllipsisException(
										((Symbol)v.get(i)).getName());
							}
						}
						
						if(typ == PATTERN) {
							// üǤʤȤϥ顼
							// Ϻͽ
							if(i + 1 != v.size() - 1) {
								throw new LispException("bad ellipsis");
							}
							
							// ѥ᡼ǻѤƤ륷ܥ򽸹ɲ
							if(v.get(i + 1) instanceof Symbol) {
								st.add((Symbol)v.get(i + 1));
							}
							
							// άɲ
							rv.add(new PatternIntEllipsis(
									v1, Nil.NIL, true));
						} else if(typ == TEMPLATE) {
							rv.add(new PatternIntEllipsis(
									v1, Nil.NIL, true));
						} else {
							throw new RuntimeException();
						}
						i++;
					} else {
						rv.add(v1);
					}
				}
				res = new LispVector(rv);
				break;
			} else {
				// ѥ᡼ǻѤƤ륷ܥ򽸹ɲ
				if(d instanceof Symbol) {
					//if(mp.contains((Symbol)d)) {
					//	res.useprm = true;
					//}
					st.add((Symbol)d);
				}
				
				if(rp == null) {
					res = d;
				} else {
					rp.setCdr(d);
				}
				break;
			}
		}
		
		return res;
	}
	
	
	public static Datum compilePattern(
			Datum d,
			PatternDepthMap mp,
			Set<Symbol> st,
			Set<Symbol> reserve) throws PatternEllipsisException {
		return compilePattern1(d, mp, PATTERN, st, reserve);
	}
	
	
	public static Datum compileTemplate(Datum d, PatternDepthMap mp) {
		Set<Symbol> sz = NullSet.getInstance();
		Set<Symbol> em = Collections.emptySet();
		
		try {
			return compilePattern1(d, mp, TEMPLATE, sz, em);
		} catch (PatternEllipsisException e) {
			throw new RuntimeException("Internal error");
		}
	}
	
	
	private static void searchLevel0(
			Datum in,
			int lev,
			Map<Symbol, Integer> res,
			Set<Symbol> st) {
		Datum sp = in;
		
		while(true) {
			while(true) {
				if(sp instanceof Cons) {
					Cons spc = (Cons)sp;
					
					searchLevel0(spc.getCar(), lev, res, st);
					sp = spc.getCdr();
				} else if(sp instanceof LispVector) {
					LispVector v = (LispVector)sp;
					
					for(int i = 0; i < v.size(); i++) {
						searchLevel0(v.get(i), lev, res, st);
					}
					return;
				} else if(sp instanceof PatternIntEllipsis) {
					// "..."Υޥå
					PatternIntEllipsis si = (PatternIntEllipsis)sp;
					
					searchLevel0(
							si.getEllipsisList(), lev + 1, res, st);
					sp = si.getCdr();
				} else if(sp instanceof Symbol && st.contains(sp)) {
					Symbol sy = (Symbol)sp;
					
					res.put(sy, lev);
					return;
				} else {
					return;
				}
			}
		}
	}
	
	
	public static void validateLevel(
			Datum pat,
			Datum tpl,
			Set<Symbol> st) throws PatternDepthException {
		Map<Symbol, Integer> p0 = new HashMap<Symbol, Integer>();
		Map<Symbol, Integer> t0 = new HashMap<Symbol, Integer>();
		
		searchLevel0(pat, 0, p0, st);
		searchLevel0(tpl, 0, t0, st);
		for(Map.Entry<Symbol, Integer> d : p0.entrySet()) {
			if(t0.containsKey(d.getKey())) {
				int ddepth = t0.get(d.getKey());
				
				if(ddepth != d.getValue()) {
					throw new PatternDepthException(
							d.getKey().getName());
				}
			}
		}
	}
	
	
	private static void collectParam1(
			Datum src, Set<Symbol> col, Set<Symbol> reserved) {
		Datum sp = src;
		
		while(true) {
			if(sp instanceof Cons) {
				Cons spc = (Cons)sp;
				
				collectParam1(spc.getCar(), col, reserved);
				sp = spc.getCdr();
			} else if(sp instanceof LispVector) {
				LispVector v = (LispVector)sp;
				
				for(int i = 0; i < v.size(); i++) {
					collectParam1(v.get(i), col, reserved);
				}
				return;
			} else if(sp instanceof PatternIntEllipsis) {
				// "..."Υޥå
				PatternIntEllipsis si = (PatternIntEllipsis)sp;
				
				collectParam1(si.getEllipsisList(), col, reserved);
				sp = si.getCdr();
			} else if(sp instanceof Symbol && !reserved.contains(sp)) {
				col.add((Symbol)sp);
				return;
			} else {
				return;
			}
		}
	}
	
	private static Set<Symbol> collectParam1(
			Datum src, Set<Symbol> reserved) {
		Set<Symbol> col = new HashSet<Symbol>();
		
		collectParam1(src, col, reserved);
		return col;
	}
	
	private static boolean match(
			Datum src,
			Datum dest,
			PatternDepthMap mp,
			PatternDepthIndex index,  // ֿץǥå
			Set<Symbol> reserved) {
		Datum sp = src;
		Datum dp = dest;
		
		while(true) {
			if(sp instanceof Cons) {
				Cons spc = (Cons)sp;
				
				if(dp instanceof Cons) {
					// ¤Ʊǽ
					Cons dpc = (Cons)dp;
					boolean bl;
					
					bl = match(
							spc.getCar(), dpc.getCar(),
							mp, index, reserved);
					if(bl) {
						sp = spc.getCdr();
						dp = dpc.getCdr();
					} else {
						// carι¤ä
						return false;
					}
				} else {
					// ¤㤦
					return false;
				}
			} else if(sp instanceof LispVector) {
				LispVector vs = (LispVector)sp;
				LispVector vd;
				
				if(!(dp instanceof LispVector)) {
					// ¤㤦
					return false;
				}
				
				vd = (LispVector)dp;
				for(int i = 0; i < vs.size(); i++) {
					Datum dd = vs.get(i);
					
					if(dd instanceof PatternIntEllipsis) {
						PatternIntEllipsis si = (PatternIntEllipsis)dd;
						
						if(si.isUseVector()) {
							PatternDepthIndex nind = index.addDepthNew();
							
							for(int j = i; j < vd.size(); j++) {
								boolean mtr;
								
								mtr = match(
										si.getEllipsisList(),
										vd.get(j),
										mp, nind, reserved);
								if(mtr) {
									nind = nind.incNew();
								} else {
									return false;
								}
							}
							
							// ޥå
							// [ܥ, ľοο]ǿϿ
							Set<Symbol> col = collectParam1(
									si.getEllipsisList(), reserved);
							int rep = nind.pop();
							
							mp.setRepetaion(col, nind, rep);
							return true;
						} else {
							boolean bl;
							
							bl = match(
									vs.get(i), vd.get(i),
									mp, index, reserved);
							if(!bl) {
								// ¤ä
								return false;
							}
						}
					} else if(i >= vd.size()) {
						return false;
					} else {
						boolean bl;
						
						bl = match(
								vs.get(i), vd.get(i),
								mp, index, reserved);
						if(!bl) {
							// ¤ä
							return false;
						}
					}
				}
				return true;
			} else if(sp instanceof PatternIntEllipsis) {
				// "..."Υޥå
				PatternIntEllipsis si = (PatternIntEllipsis)sp;
				Datum pt = dp;
				PatternDepthIndex nind = index.addDepthNew();
				
				while(true) {
					if(pt instanceof Cons) {
						// ֤˥ޥå
						Cons ptc = (Cons)pt;
						boolean mtr;
						
						mtr = match(
								si.getEllipsisList(), ptc.getCar(),
								mp, nind, reserved);
						if(mtr) {
							pt = ptc.getCdr();
							nind = nind.incNew();
						} else {
							return false;
						}
					} else {
						// cdrޥå
						Set<Symbol> col = collectParam1(
								si.getEllipsisList(), reserved);
						int rep = nind.pop();
						
						// ޥå
						// [ܥ, ľοο]ǿϿ
						mp.setRepetaion(col, nind, rep);
						return match(
								si.getCdr(), pt,
								mp, index, reserved);
					}
				}
			} else if(sp instanceof Symbol && !reserved.contains(sp)) {
				// dp˥ޡդ
				mp.put((Symbol)sp, index, dp);
				return true;
			} else if(sp.equals(UNDERBAR)) {
				return true;
			} else {
				// return (equal? sp dp)
				return sp.isEqv(dp);
			}
		}
	}
	
	
	public static boolean match(
			Datum src,
			Datum dest,
			PatternDepthMap mp,
			Set<Symbol> reserved) {
		return match(src, dest, mp, new PatternDepthIndex(), reserved);
	}
	
	
	private static void collectParam2(
			Datum src, Set<Symbol> col, PatternDepthMap mp) {
		Datum sp = src;
		
		while(true) {
			if(sp instanceof Cons) {
				Cons spc = (Cons)sp;
				
				collectParam2(spc.getCar(), col, mp);
				sp = spc.getCdr();
			} else if(sp instanceof LispVector) {
				LispVector v = (LispVector)sp;
				
				for(int i = 0; i < v.size(); i++) {
					collectParam2(v.get(i), col, mp);
				}
				return;
			} else if(sp instanceof PatternIntEllipsis) {
				// "..."Υޥå
				PatternIntEllipsis si = (PatternIntEllipsis)sp;
				
				collectParam2(si.getEllipsisList(), col, mp);
				sp = si.getCdr();
			} else if(sp instanceof Symbol) {
				if(mp.contains((Symbol)sp)) {
					col.add((Symbol)sp);
				}
				return;
			} else {
				return;
			}
		}
	}
	
	private static Set<Symbol> collectParam2(
			Datum src, PatternDepthMap mp) {
		Set<Symbol> col = new HashSet<Symbol>();
		
		collectParam2(src, col, mp);
		return col;
	}
	
	// expand1¹Ԥɬnullå
	private static Datum expand1(
			Datum templ,
			PatternDepthMap args,
			PatternDepthIndex index,
			UserSyntax usyn,
			Map<Symbol, Symbol> box) throws PatternDepthException {
		Datum sp = templ;
		ConsListBuilder bld1 = new ConsListBuilder();
		
		while(true) {
			if(sp instanceof Cons) {
				// 󥹥ꥹ
				Cons spc = (Cons)sp;
				Cons n = new Cons();
				Datum car;
				
				car = expand1(spc.getCar(), args, index, usyn, box);
				if(car == null) {
					return null;
				} else {
					n.setCar(car);
					bld1.append(n);
				}
				
				sp = spc.getCdr();
			} else if(sp instanceof LispVector) {
				LispVector  ve = (LispVector)sp;
				List<Datum> vr = new ArrayList<Datum>();
				
				for(int j = 0; j < ve.size(); j++) {
					Datum dd = ve.get(j);
					
					if(dd instanceof PatternIntEllipsis) {
						// "..."Ÿ
						PatternIntEllipsis si = (PatternIntEllipsis)dd;
						
						//
						Set<Symbol> params =
							collectParam2(si.getEllipsisList(), args);
						
						// [ܥ, ľοο]
						//   ǿκǾͤ
						int rep = args.getRepetaion(params, index);
						
						// ֤Ÿ
						index.addDepth();  // ɲ()
						for(int i = 0; i < rep; i++, index.inc()) {
							Datum rpt = expand1(
									si.getEllipsisList(),
									args, index, usyn, box);
							
							if(rpt == null) {
								int v = index.pop();
								
								if(v > 0) {
									break;
								} else {
									// 1Ÿʤä
									return null;
								}
							} else {
								vr.add(rpt);
							}
						}
						index.pop();
					} else {
						Datum d3;
						
						d3 = expand1(ve.get(j), args, index, usyn, box);
						if(d3 == null) {
							return null;
						} else {
							vr.add(d3);
						}
					}
				}
				return new LispVector(vr);
			} else if(sp instanceof PatternIntEllipsis) {
				// "..."Ÿ
				PatternIntEllipsis si = (PatternIntEllipsis)sp;
				ConsListBuilder bld2 = new ConsListBuilder();
				
				//
				Set<Symbol> params = collectParam2(
						si.getEllipsisList(), args);
				
				// [ܥ, ľοο]ǿκǾͤ
				int rep = args.getRepetaion(params, index);
				
				// ֤Ÿ
				index.addDepth();  // ɲ()
				for(int i = 0; i < rep; i++, index.inc()) {
					Cons n = new Cons();
					Datum rpt = expand1(
							si.getEllipsisList(),
							args, index, usyn, box);
					
					if(rpt == null) {
						int v = index.pop();
						
						if(v > 0) {
							break;
						//} else if(index.isAllZero()) {
						//	return Undef.UNDEF2;
						} else {
							// 1Ÿʤä
							return null;
						}
					} else {
						n.setCar(rpt);
						bld2.append(n);
					}
				}
				index.pop();
				
				// cdrŸ
				Datum cdr = expand1(si.getCdr(), args, index, usyn, box);
				
				if(cdr == null) {
					return null;
				} else {
					return bld1.get(bld2.get(cdr));
				}
			} else if(sp instanceof Symbol) {
				Symbol sy1 = (Symbol)sp;
				
				if(args.contains(sy1)) {
					Datum dt = args.get(sy1, index);
					
					// ޡդ
					dt = PatternMatch.markReplace(box, dt, true);
					return bld1.get(dt);
				} else if(sy1.isGenerated()) {
					return bld1.get(sy1);
				} else {
					//menv.bindDatum(sy1, Symbol.gensym());
					//return bld1.get(new SymbolScope(sy1, usyn));
					return bld1.get(sy1);
				}
			} else {
				return bld1.get(sp);
			}
		}
	}
	
	
	public static Datum expand(
			Datum templ,
			PatternDepthMap args,
			UserSyntax usyn,
			Map<Symbol, Symbol> box) throws PatternDepthException {
		Datum res = expand1(
				templ, args, new PatternDepthIndex(), usyn, box);
		
		if(res == null) {
			throw new LispException("syntax expansion has failed");
		}
		return res;
	}
	
	/**
	 * ׾ɲä롣
	 * 
	 * @param src
	 * @return
	 */
	public static Datum appendScope(
			Datum src, PatternDepthMap args, UserSyntax usyn) {
		Datum sp = src;
		ConsListBuilder bld1 = new ConsListBuilder();
		
		while(true) {
			if(sp instanceof Cons) {
				Cons spc = (Cons)sp;
				Cons app = new Cons();
				
				app.setCar(appendScope(spc.getCar(), args, usyn));
				bld1.append(app);
				sp = spc.getCdr();
			} else if(sp instanceof LispVector) {
				LispVector v = (LispVector)sp;
				List<Datum> vr = new ArrayList<Datum>();
				
				for(int i = 0; i < v.size(); i++) {
					vr.add(appendScope(v.get(i), args, usyn));
				}
				return new LispVector(vr);
			} else if(sp instanceof Symbol) {
				Symbol sy1 = (Symbol)sp;
				
				if(sy1.isReplaced()) {
					return bld1.get(sy1);
				} else if(sy1.isGenerated()) {
					return bld1.get(sy1);
				} else {
					return bld1.get(new SymbolScope(sy1, usyn));
					//return bld1.get(sy1);
				}
			} else {
				return bld1.get(sp);
			}
		}
	}
	
	/**
	 * evalʤɤΤ˥׾
	 * 
	 * @param src
	 * @return
	 */
	public static Datum removeScope(Datum src) {
		Datum sp = src;
		ConsListBuilder bld1 = new ConsListBuilder();
		
		while(true) {
			if(sp instanceof Cons) {
				Cons spc = (Cons)sp;
				Cons app = new Cons();
				
				app.setCar(removeScope(spc.getCar()));
				bld1.append(app);
				sp = spc.getCdr();
			} else if(sp instanceof LispVector) {
				LispVector v = (LispVector)sp;
				List<Datum> vr = new ArrayList<Datum>();
				
				for(int i = 0; i < v.size(); i++) {
					vr.add(removeScope(v.get(i)));
				}
				return new LispVector(vr);
			} else if(sp instanceof SymbolScope) {
				return bld1.get(((SymbolScope)sp).getSymbol());
			} else {
				return bld1.get(sp);
			}
		}
	}
	
	
	public static Datum markReplace(
			Map<Symbol, Symbol> box, Datum src, boolean mark) {
		Datum sp = src;
		ConsListBuilder bld1 = new ConsListBuilder();
		
		while(true) {
			if(sp instanceof Cons) {
				Cons spc = (Cons)sp;
				Cons app = new Cons();
				
				app.setCar(markReplace(box, spc.getCar(), mark));
				bld1.append(app);
				sp = spc.getCdr();
			} else if(sp instanceof LispVector) {
				LispVector v = (LispVector)sp;
				List<Datum> vr = new ArrayList<Datum>();
				
				for(int i = 0; i < v.size(); i++) {
					vr.add(markReplace(box, v.get(i), mark));
				}
				return new LispVector(vr);
			} else if(sp instanceof Symbol) {
				Symbol mk = Symbol.newAndMark(box, (Symbol)sp, mark);
				
				return bld1.get(mk);
			} else {
				return bld1.get(sp);
			}
		}
	}
	
}
