/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.Collections;
import java.util.List;

public class MultiValues extends Datum {
	
	//
	private List<Datum> values;
	
	private MultiValues(List<Datum> values) {
		if(values == null) {
			throw new NullPointerException();
		}
		this.values = values;
	}
	
	
	public static Datum newValues(List<Datum> values) {
		if(values.size() == 0) {
			return Undef.UNDEF;
		} else if(values.size() == 1) {
			return values.get(0);
		} else {
			return new MultiValues(values);
		}
	}
	
	
	public List<Datum> getValues() {
		return Collections.unmodifiableList(values);
	}
	
}
