/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

public final class LispCharacter extends Atom {
	
	
	public static final LispCharacter NEWLINE =
		new LispCharacter('\n');
	
	public static final LispCharacter SPACE = new LispCharacter(' ');
	
	//
	private char character;
	
	
	public LispCharacter(char ch) {
		character = ch;
	}
	
	
	private static String getName(char ch) {
		if(ch == '\n') {
			return "newline";
		} else if(ch == ' ') {
			return "space";
		} else {
			return Character.toString(ch);
		}
	}
	
	
	public static LispCharacter getByName(String name) {
		if("newline".equals(name)) {
			return NEWLINE;
		} else if("space".equals(name)) {
			return SPACE;
		} else {
			return null;
		}
	}
	
	/**
	 * @return the character
	 */
	public char getCharacter() {
		return character;
	}
	
	@Override
	public String getResult() {
		return "#\\" + getName(character);
	}

	@Override
	public String print() {
		return Character.toString(character);
	}

	@Override
	public LispString toLispString() {
		return new LispString("#\\" + getName(character));
	}
	
	
	public boolean equals(Object d) {
		if(d instanceof LispCharacter) {
			return character == ((LispCharacter)d).character;
		}
		return false;
	}
	
	
	public int hashCode() {
		int l = 17;
		
		l = 37 * l + (int)character;
		return l;
	}
	
	
	public String toString() {
		return Character.toString(character);
	}
	
	
	public boolean isTypeCharacter() {
		return true;
	}

}
