/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

public final class LispBoolean extends Atom {
	
	private boolean value;
	
	
	public static final LispBoolean TRUE = new LispBoolean(true);
	
	
	public static final LispBoolean FALSE = new LispBoolean(false);
	
	
	public static LispBoolean getInstance(boolean value) {
		return value ? TRUE : FALSE;
	}
	
	
	private LispBoolean(boolean value) {
		this.value = value;
	}
	
	public boolean equals(Object o) {
		if(o instanceof LispBoolean) {
			return value == ((LispBoolean)o).value;
		}
		return false;
	}
	
	
	public int hashCode() {
		return (value ? 1 : 0);
	}
	
	
	public String toString() {
		return (value ? "#t" : "#f");
	}
	
	
	public boolean isEqv(Atom a) {
		return equals(a);
	}
	
	
	public boolean getValue() {
		return value;
	}


	public String print() {
		return (value ? "#t" : "#f");
	}


	public String getResult() {
		return (value ? "#t" : "#f");
	}
	
	
	public LispString toLispString() {
		return new LispString(value ? "#t" : "#f");
	}
	
	
	public boolean isTypeBoolean() {
		return true;
	}
	
	
	public boolean isTrue() {
		return value;
	}

}
