﻿// //////////////////////////////////////////////////////////////////////////
//
// Constant.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/09/01
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Text;

namespace DShowCAC
{
	// //////////////////////////////////////////////////////////////////////
	// Define

	public class WM
	{
		public const int		App = 0x8000;
		public const int		GraphNotify = App + 1;
	}

	public class Const
	{
		// Define OLE Automation constants
		public static int		OATrue = -1;
		public static int		OAFalse = 0;
	}

	// //////////////////////////////////////////////////////////////////////
	// Window Styles

	/// <summary>
	/// Window Styles
	/// </summary>
	public class WS
	{
		public static int		Overlapped       = 0x00000000;
		public static int		Popup            = unchecked((int)0x80000000);
		public static int		Child            = 0x40000000;
		public static int		Minimize         = 0x20000000;
		public static int		Visible          = 0x10000000;
		public static int		Disabled         = 0x08000000;
		public static int		ClipSiblings     = 0x04000000;
		public static int		ClipChildren     = 0x02000000;
		public static int		Maximize         = 0x01000000;
		public static int		Caption          = 0x00C00000;		// WS.Border | WS.DLGFrame
		public static int		Border           = 0x00800000;
		public static int		DLGFrame         = 0x00400000;
		public static int		VScroll          = 0x00200000;
		public static int		HScroll          = 0x00100000;
		public static int		SysMenu          = 0x00080000;
		public static int		ThickFrame       = 0x00040000;
		public static int		Group            = 0x00020000;
		public static int		TabStop          = 0x00010000;

		public static int		MinimizeBox      = 0x00020000;
		public static int		MaximizeBox      = 0x00010000;

		public static int		Tiled            = Overlapped;
		public static int		Iconic           = Minimize;
		public static int		SizeBox          = ThickFrame;
		public static int		TiledWindow      = OverlappedWindow;

		public static int		OverlappedWindow = Overlapped |
												   Caption |
												   SysMenu |
												   ThickFrame |
												   MinimizeBox |
												   MaximizeBox;

		public static int		PopupWindow      = Popup |
												   Border |
												   SysMenu;

		public static int		ChildWindow      = Child;
	}
}

// //////////////////////////////////////////////////////////////////////////
