package com.sanpudo.formula;

import java.math.BigDecimal;

/**
 * 右括弧。
 * 
 * @author Sanpudo.
 */
class RPar extends Token {

	/** コンストラクタ。 */
	RPar(String formula, int location) {
		super(formula, location);
	}

	/** token文字列を返す。 */
	String strToken() {
		return ")";
	}

	/** 正規化した式を返す。 */
	String normalized() {
		return "";
	}

	/** ファクターの構造が完全であるかチェックする。 */
	boolean isComplete() {
		// 右括弧は常に完全
		return true;
	}

	/** ファクターの構造が完全でないとき、その理由メッセージを返す。 */
	String imcompleteMessage() {
		// 右括弧は常に完全
		return null;
	}

	/** doubleの評価値を返す。 */
	double value() throws FormulaEvaluatorException {
		throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
				strToken(), location);
	}

	/** BigDecimalの評価値を返す。 */
	BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
		throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
				strToken(), location);
	}

}
