package com.sanpudo.formula;

import java.math.BigDecimal;

/**
 * 左括弧。
 * 
 * @author Sanpudo.
 */
class LPar extends Container {
	/** この左括弧に囲まれたファクター。 */
	Token child;

	/** コンストラクタ。 */
	LPar(String formula, int location) {
		super(formula, location);
		child = null;
	}

	/** token文字列を返す。 */
	String strToken() {
		return "(";
	}

	/** 正規化した式を返す。 */
	String normalized() {
		return child.normalized();
	}

	/** ファクターの構造が完全であるかチェックする。 */
	boolean isComplete() {
		if (this.isOpen()) {
			return false;
		}
		if (child == null) {
			return false;
		} else {
			return child.isComplete();
		}
	}

	/** ファクターの構造が完全でないとき、その理由メッセージを返す。 */
	String imcompleteMessage() {
		if (this.isOpen()) {
			return Messages.PAREN_INCOMPLETE;
		}
		if (child == null) {
			return Messages.VALUE_EXPECT;
		} else {
			return child.imcompleteMessage();
		}

	}

	/** 子の登録。 */
	void bind(Token token) {
		this.child = token;
		token.parent = this;
	}

	/** doubleの評価値を返す。 */
	double value() throws FormulaEvaluatorException {
		return child.value();
	}

	/** BigDecimalの評価値を返す。 */
	BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
		return child.value(rounding);
	}

	/** 引数が満たされているか。 */
	boolean filled() {
		return child != null;
	}
}
