package com.sanpudo.formula;

import java.math.BigDecimal;

/**
 * 関数を実装するクラスのインタフェース。
 * 
 * @author Sanpudo.
 */
public interface FunctionImplementation {

	/** このクラスで定義されている関数名であるときtrueを返す。 
	 * @param name 関数名
	 * @return このクラスで定義されている関数である時true
	 * */
	public boolean supports(String name);

	/** このクラスで定義されている関数名の配列を返す。 
	 * @return このクラスで定義されてる関数名の配列
	 * */
	public String[] names();

	/** 指定した名前の関数の引数の個数を返す。 
	 * @param name 関数名
	 * @return 関数の引数の個数
	 * */
	public int numberOfArgs(String name);

	/** 指定した名前の関数のdoubleの関数実行結果を返す。 
	 * @param name 関数名
	 * @param args 関数に渡す引数
	 * @return 関数実行結果
	 * @exception 関数実行時に評価できない状況が発生
	 * */
	public double value(String name, double[] args)
			throws FunctionEvalException;

	/** 指定した名前の関数のBigDecimalの関数実行結果を返す。 
	 * @param name 関数名
	 * @param args 関数に渡す引数
	 * @return 関数実行結果
	 * @exception 関数実行時に評価できない状況が発生
	 * */
	public BigDecimal value(String name, BigDecimal[] args)
			throws FunctionEvalException;

}