package com.sanpudo.formula;

/**
 * 関数実装に関する例外。
 * 
 * @author Sanpudo.
 */
public class FunctionException extends RuntimeException {
	private static final long serialVersionUID = 1L;
	private String functionName;

	/**
	 * コンストラクタ。
	 * 
	 * @param msg
	 *            例外メッセージ
	 * @param functionName
	 *            関数名
	 */
	public FunctionException(String msg, String functionName) {
		super(msg);
		this.functionName = functionName;
	}

	/**
	 * 例外の発生した関数名を返す。
	 * 
	 * @return 例外の発生した関数名
	 */
	public String getFunctionName() {
		return functionName;
	}
}
