package com.sanpudo.formula;

import java.math.BigDecimal;

/**
 * 即値。
 * 
 * @author Sanpudo.
 */
class DirectValue extends Value {
	/** 即値の値。 */
	String value;

	/** トークンの正規表現。 */
	static final String regex = "(-?\\d+(\\.\\d*)?)|(-?\\.\\d+)";

	/** コンストラクタ。 */
	DirectValue(String formula, int location, String value) {
		super(formula, location);
		this.value = value;
	}

	/** token文字列を返す。 */
	String strToken() {
		return value;
	}

	/** doubleの評価値を返す。 */
	double value() throws FormulaEvaluatorException {
		try {
			return Double.parseDouble(value);
		} catch (NumberFormatException e) {
			throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
					strToken(), location);
		}
	}

	/** BigDecimalの評価値を返す。 */
	BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
		try {
			return rounding.everyRound(new BigDecimal(value).setScale(
					rounding.scale, rounding.rMode));
		} catch (Exception e) {
			throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
					strToken(), location);
		}
	}
}
