package com.sanpudo.formula;

/**
 * 左括弧および関数。
 * 
 * @author Sanpudo.
 */
abstract class Container extends Token {

	/** 対応する右括弧 */
	RPar rPar;

	/** コンストラクタ。 */
	Container(String formula, int location) {
		super(formula, location);
		rPar = null;
	}

	/** 対応する右括弧による解消。 */
	void close(RPar rPar) {
		rPar.parent = this;
		this.rPar = rPar;
	}

	/** 引数が満たされているか。 */
	abstract boolean filled();

	/** 右括弧で解消されているかどうか。 */
	boolean isOpen() {
		return (rPar == null);
	}
}
