/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Container;
import com.sanpudo.formula.Delimiter;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.Function;
import com.sanpudo.formula.LPar;
import com.sanpudo.formula.Operator;
import com.sanpudo.formula.RPar;
import com.sanpudo.formula.Token;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parser {
    private String input;

    Parser(String input) {
        this.input = input;
    }

    Token parse(Vector<Token> tokens) throws FormulaEvaluatorException {
        Token current = null;
        for (Token next : tokens) {
            Function func;
            if (current == null) {
                if (next.isNonValue()) {
                    this.error(next, "Value expected");
                }
            } else if (current.isValue() || current.isRPar()) {
                if (next.isValue() || next.isContainer()) {
                    this.error(next, "Operator expected");
                } else if (next.isOperator()) {
                    Operator op = (Operator)next;
                    Token f1 = current.getF1(op);
                    if (f1.parent == null) {
                        op.parent = null;
                    } else if (f1.parent.isLPar()) {
                        ((LPar)f1.parent).bind(op);
                    } else if (f1.parent.isFunction()) {
                        ((Function)f1.parent).reBind(op);
                    } else if (f1.parent.isOperator()) {
                        ((Operator)f1.parent).bindF2(op);
                    }
                    op.bindF1(f1);
                } else if (next.isRPar()) {
                    Container container = current.recentOpenContainer();
                    if (container == null) {
                        this.error(next, "No corresponding left parenthesis");
                    }
                    if (!container.filled()) {
                        if (container.isLPar()) {
                            this.error(next, "Value expected");
                        } else {
                            this.error(next, "Next value expected");
                        }
                    }
                    container.close((RPar)next);
                } else if (next.isDelimiter()) {
                    func = current.recentOpenFunc();
                    if (func == null) {
                        this.error(next, "Invalid delimitter");
                    }
                    if (func.filled()) {
                        this.error(next, "Right parenthesis expected");
                    }
                    ((Delimiter)next).bindToParent(current);
                }
            } else if (current.isLPar()) {
                if (next.isNonValue()) {
                    this.error(next, "Value expected");
                }
                ((LPar)current).bind(next);
            } else if (current.isFunction()) {
                if (next.isOperator() || next.isDelimiter()) {
                    this.error(next, "Value expected");
                }
                if (next.isRPar()) {
                    if (!((Function)current).filled()) {
                        this.error(next, "Value expected");
                    }
                    ((Function)current).close((RPar)next);
                } else {
                    if (((Function)current).filled()) {
                        this.error(next, "Right parenthesis expected");
                    }
                    ((Function)current).bind(next);
                }
            } else if (current.isOperator()) {
                if (next.isNonValue()) {
                    this.error(next, "Value expected");
                }
                ((Operator)current).bindF2(next);
            } else if (current.isDelimiter()) {
                if (next.isNonValue()) {
                    this.error(next, "Value expected");
                }
                func = current.recentOpenFunc();
                func.bind(next);
            }
            current = next;
        }
        if (current == null) {
            throw new FormulaEvaluatorException("Null input", this.input, this.input.length());
        }
        Token root = current.root();
        if (!root.isComplete()) {
            throw new FormulaEvaluatorException(root.imcompleteMessage(), this.input, this.input.length());
        }
        return root;
    }

    private void error(Token token, String msg) throws FormulaEvaluatorException {
        throw new FormulaEvaluatorException(msg, this.input, token.location);
    }
}

