/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.Rounding;
import com.sanpudo.formula.Token;
import java.math.BigDecimal;
import java.math.RoundingMode;

class Operator
extends Token {
    char operator;
    Token f1;
    Token f2;
    static final char[] operators = new char[]{'+', '-', '*', '/', '^'};
    static final int[] strength;

    static {
        int[] nArray = new int[5];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        strength = nArray;
    }

    Operator(String formula, int location, char operator) {
        super(formula, location);
        this.operator = operator;
        this.f1 = null;
        this.f2 = null;
    }

    boolean isComplete() {
        if (this.f1 == null || this.f2 == null) {
            return false;
        }
        return this.f1.isComplete() && this.f2.isComplete();
    }

    String imcompleteMessage() {
        if (this.f1 == null) {
            return "Value expected";
        }
        if (this.f2 == null) {
            return "Incomplete operator";
        }
        String wk = this.f1.imcompleteMessage();
        if (wk != null) {
            return wk;
        }
        return this.f2.imcompleteMessage();
    }

    void bindF1(Token token) {
        this.f1 = token;
        token.parent = this;
    }

    void bindF2(Token token) {
        this.f2 = token;
        token.parent = this;
    }

    boolean stronger(Operator op) {
        return this.strength() > op.strength();
    }

    int strength() {
        int i = 0;
        while (i < operators.length) {
            if (this.operator == operators[i]) {
                return strength[i];
            }
            ++i;
        }
        return -1;
    }

    String strToken() {
        return String.valueOf(this.operator);
    }

    String normalized() {
        return "(" + this.f1.normalized() + this.strToken() + this.f2.normalized() + ")";
    }

    double value() throws FormulaEvaluatorException {
        switch (this.operator) {
            case '+': {
                return this.f1.value() + this.f2.value();
            }
            case '-': {
                return this.f1.value() - this.f2.value();
            }
            case '*': {
                return this.f1.value() * this.f2.value();
            }
            case '/': {
                return this.f1.value() / this.f2.value();
            }
            case '^': {
                return Math.pow(this.f1.value(), this.f2.value());
            }
        }
        throw new FormulaEvaluatorException("Library internal error", this.strToken(), this.location);
    }

    BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
        switch (this.operator) {
            case '+': {
                return this.f1.value(rounding).add(this.f2.value(rounding));
            }
            case '-': {
                return this.f1.value(rounding).subtract(this.f2.value(rounding));
            }
            case '*': {
                return rounding.everyRound(this.f1.value(rounding).multiply(this.f2.value(rounding)));
            }
            case '/': {
                return rounding.everyRound(this.f1.value(rounding).divide(this.f2.value(rounding), 20, RoundingMode.HALF_UP));
            }
            case '^': {
                try {
                    return rounding.everyRound(this.f1.value(rounding).pow(this.f2.value(rounding).intValueExact()));
                }
                catch (ArithmeticException e) {
                    throw new FormulaEvaluatorException("Invalid pow calculation", (Throwable)e, this.formula, this.location);
                }
            }
        }
        throw new FormulaEvaluatorException("Library internal error", this.formula, this.location);
    }
}

