/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Environments;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.FunctionException;
import com.sanpudo.formula.FunctionImplementation;
import com.sanpudo.formula.FunctionInterpreter;
import com.sanpudo.formula.Lex;
import com.sanpudo.formula.Parser;
import com.sanpudo.formula.RoundPoint;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaEvaluator {
    private Environments environments;

    public FormulaEvaluator() {
        this.environments = new Environments();
    }

    public FormulaEvaluator(int scale) {
        this();
        this.environments.setScale(scale);
    }

    public FormulaEvaluator(RoundPoint rondPoint, int scale, RoundingMode rMode) throws FormulaEvaluatorException {
        this();
        this.environments.setRounding(rondPoint, scale, rMode);
    }

    FormulaEvaluator(Environments environments) {
        this.environments = environments;
    }

    public void parse(String formula) throws FormulaEvaluatorException {
        new Parser(formula).parse(new Lex(this.environments).analyze(formula));
    }

    public double dEvaluate(String formula) throws FormulaEvaluatorException {
        return new Parser(formula).parse(new Lex(this.environments).analyze(formula)).value();
    }

    double dEvaluateParam(String formula) throws FormulaEvaluatorException {
        return new Parser(formula).parse(new Lex(this.environments).analyze(formula, true)).value();
    }

    public BigDecimal bdEvaluate(String formula) throws FormulaEvaluatorException {
        BigDecimal bd = new Parser(formula).parse(new Lex(this.environments).analyze(formula)).value(this.environments.rounding);
        return this.environments.rounding.round(bd);
    }

    BigDecimal bdEvaluateParam(String formula) throws FormulaEvaluatorException {
        BigDecimal bd = new Parser(formula).parse(new Lex(this.environments).analyze(formula, true)).value(this.environments.rounding);
        return this.environments.rounding.round(bd);
    }

    public void setRounding(int scale, RoundingMode rMode) {
        this.environments.setRounding(scale, rMode);
    }

    public void setScale(int scale) {
        this.environments.setScale(scale);
    }

    public void setRounding(RoundPoint roundPoint, int scale, RoundingMode rMode) throws FormulaEvaluatorException {
        this.environments.setRounding(roundPoint, scale, rMode);
    }

    public void defineUserConstant(String name, String value, boolean override) throws FormulaEvaluatorException {
        this.environments.defineUserConstant(name, value, false, override);
    }

    public void defineUserConstant(String name, String value) throws FormulaEvaluatorException {
        this.environments.defineUserConstant(name, value);
    }

    public Map<String, String> getConstants() {
        Hashtable<String, String> h = new Hashtable<String, String>(Environments.predefine);
        h.putAll(this.environments.userDefine);
        return h;
    }

    public void defineUserFunction(FunctionImplementation func) throws FormulaEvaluatorException, FunctionException {
        this.environments.defineUserFunction(func);
    }

    public void checkUserFunction(String funcName, int numberOfArgs, String formula) throws FormulaEvaluatorException {
        FunctionInterpreter.checkFormula(funcName, numberOfArgs, formula, this.environments);
    }

    public void defineUserFunction(String funcName, int numberOfArgs, String formula) throws FormulaEvaluatorException {
        this.defineUserFunction(new FunctionInterpreter(funcName, numberOfArgs, formula, this.environments));
    }

    public void loadUserFunction(String className) throws FormulaEvaluatorException {
        this.environments.loadUserFunction(className);
    }

    public int getScale() {
        return this.environments.rounding.scale;
    }

    public RoundingMode getRoundingMode() {
        return this.environments.rounding.rMode;
    }

    public RoundPoint getRoundPoint() {
        return this.environments.rounding.roundPoint;
    }
}

