/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraphVXY;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIVXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIVXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogVXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGFigureElementGraphVXY
extends SGFigureElementGraph
implements SGIFigureElementGraphVXY,
SGIVXYDataConstants {
    public String getClassDescription() {
        return "VXY Graph";
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!(sGData instanceof SGIVXYTypeData)) {
            return false;
        }
        return super.addData(sGData, string, sGProperties);
    }

    public boolean addData(SGData sGData, String string) {
        if (!(sGData instanceof SGIVXYTypeData)) {
            return false;
        }
        return super.addData(sGData, string);
    }

    protected SGFigureElementGraph.ElementGroupSetInGraph createGroupSet(SGData sGData, String string) {
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(0);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(3);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return null;
        }
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = null;
        if (!(sGData instanceof SGIVXYTypeData)) {
            return null;
        }
        elementGroupSetInVXYGraph = this.createSingleGroupSet((SGIVXYTypeData)((Object)sGData), sGAxis5, sGAxis6, string);
        return elementGroupSetInVXYGraph;
    }

    private ElementGroupSetInVXYGraph createSingleGroupSet(SGIVXYTypeData sGIVXYTypeData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.createGroupSetVXYInstance(sGIVXYTypeData, sGAxis, sGAxis2);
        elementGroupSetInVXYGraph.setName(string);
        return elementGroupSetInVXYGraph;
    }

    private ElementGroupSetInVXYGraph createGroupSetVXYInstance(SGIVXYTypeData sGIVXYTypeData, SGAxis sGAxis, SGAxis sGAxis2) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = new ElementGroupSetInVXYGraph();
        elementGroupSetInVXYGraph.setXAxis(sGAxis);
        elementGroupSetInVXYGraph.setYAxis(sGAxis2);
        int n = sGIVXYTypeData.getPointsNumber();
        elementGroupSetInVXYGraph.initPointsArray(n);
        if (!elementGroupSetInVXYGraph.addDrawingElementGroup(3)) {
            return null;
        }
        float f = SGUtilityForFigureElement.getInitialMagnitudePerCM(sGIVXYTypeData, this);
        elementGroupSetInVXYGraph.setMagnitudePerCM(f);
        elementGroupSetInVXYGraph.setDirectionInvariant(sGIVXYTypeData.isPolar());
        if (!elementGroupSetInVXYGraph.updateDrawingElementsLocation((SGData)((Object)sGIVXYTypeData))) {
            return null;
        }
        elementGroupSetInVXYGraph.setMagnification(this.getMagnification());
        return elementGroupSetInVXYGraph;
    }

    protected float getInitialMagnitudePerCM(SGIVXYTypeData sGIVXYTypeData) {
        double[] dArray = sGIVXYTypeData.getMagnitudeArray();
        float f = (float)SGUtilityNumber.max(dArray);
        float f2 = (float)SGUtilityNumber.min(dArray);
        float f3 = Math.max(this.getGraphRectWidth(), this.getGraphRectHeight());
        float f4 = 0.1f * f3;
        float f5 = f4 / f;
        float f6 = f / (f4 * 0.035277776f);
        float f7 = (float)SGUtilityNumber.getNumberInRangeOrder(f6, f2, f, 3);
        return f7;
    }

    protected boolean createDataDialog() {
        SGPropertyDialogVXYData sGPropertyDialogVXYData = new SGPropertyDialogVXYData(this.mDialogOwner, true);
        this.mDialog = sGPropertyDialogVXYData;
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        List list = this.mChildList;
        if (bl) {
            SGUtilityForFigureElementJava2D.clipGraphRect(this, graphics2D);
        }
        for (int i = 0; i < list.size(); ++i) {
            SGFigureElementGraph.ElementGroupSetInGraph elementGroupSetInGraph = (SGFigureElementGraph.ElementGroupSetInGraph)list.get(i);
            if (!elementGroupSetInGraph.isVisible()) continue;
            elementGroupSetInGraph.setClipFlag(bl);
            elementGroupSetInGraph.paintGraphics2D(graphics2D);
        }
        if (bl) {
            graphics2D.setClip(this.getViewBounds());
        }
    }

    private ElementGroupArrow getGroupArrow(ElementGroupSetInVXYGraph elementGroupSetInVXYGraph) {
        ArrayList arrayList = elementGroupSetInVXYGraph.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupArrow)) continue;
            return (ElementGroupArrow)sGElementGroup;
        }
        return null;
    }

    protected SGFigureElementGraph.ElementGroupSetInGraph getGroupSetNewInstance(SGData sGData) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = null;
        if (sGData instanceof SGIVXYTypeData) {
            elementGroupSetInVXYGraph = new ElementGroupSetInVXYGraph();
        }
        return elementGroupSetInVXYGraph;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!(sGData instanceof SGIVXYTypeData)) {
            return false;
        }
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        SGFigureElementGraph.ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.addToList(elementGroupSetInGraph);
        int n = this.setDataProperties(element, elementGroupSetInGraph, sGData);
        if (n == 1) {
            return false;
        }
        this.createDataDialog();
        return true;
    }

    protected int setDataProperties(Element element, SGFigureElementGraph.ElementGroupSetInGraph elementGroupSetInGraph, SGData sGData) {
        SGIVXYTypeData sGIVXYTypeData;
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph;
        if (super.setDataProperties(element, elementGroupSetInGraph, sGData) == 1) {
            return 1;
        }
        if (sGData instanceof SGIVXYTypeData && this.setPropertyOfElementGroupSetInVXYGraph(element, elementGroupSetInVXYGraph = (ElementGroupSetInVXYGraph)elementGroupSetInGraph, sGIVXYTypeData = (SGIVXYTypeData)((Object)sGData)) == 1) {
            return 1;
        }
        return 0;
    }

    private int setPropertyOfElementGroupSetInVXYGraph(Element element, ElementGroupSetInVXYGraph elementGroupSetInVXYGraph, SGIVXYTypeData sGIVXYTypeData) {
        SGIFigureElementAxis sGIFigureElementAxis = this.mAxisElement;
        String string = null;
        Float f = null;
        Boolean bl = null;
        SGElementGroupArrow sGElementGroupArrow = null;
        NodeList nodeList = null;
        int n = sGIVXYTypeData.getPointsNumber();
        elementGroupSetInVXYGraph.initPointsArray(n);
        nodeList = element.getElementsByTagName("Arrow");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInVXYGraph.addDrawingElementGroup(3)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroupArrow = elementGroupSetInVXYGraph.getArrowGroup();
        if (!((SGElementGroup)sGElementGroupArrow).readProperty(element2)) {
            return 1;
        }
        string = element.getAttribute("MagnitudePerCM");
        if (string.length() != 0) {
            f = SGUtilityText.getFloat(string);
            if (f == null) {
                return 1;
            }
            elementGroupSetInVXYGraph.setMagnitudePerCM(((Number)f).floatValue());
        }
        if ((string = element.getAttribute("DirectionInvariant")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return 1;
            }
            elementGroupSetInVXYGraph.setDirectionInvariant(bl);
        }
        elementGroupSetInVXYGraph.updateDrawingElementsLocation(sGIVXYTypeData);
        elementGroupSetInVXYGraph.initPropertiesHistory();
        return 0;
    }

    private ElementGroupSetInVXYGraph getVXYGroupSet(int n) {
        return (ElementGroupSetInVXYGraph)this.getGroupSet(n);
    }

    public boolean setMagnitudePerCMDirectly(int n, float f) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setMagnitudePerCM(f)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setDirectionInvariantDirectly(int n, boolean bl) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setDirectionInvariant(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setLineWidthDirectly(int n, float f, String string) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setLineTypeDirectly(int n, int n2) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setLineType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setHeadSizeDirectly(int n, float f, String string) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setHeadSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setColorDirectly(int n, Color color) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setStartTypeDirectly(int n, int n2) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setStartHeadType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setEndTypeDirectly(int n, int n2) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setEndHeadType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setOpenAngleDirectly(int n, float f) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setHeadOpenAngle(f)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    public boolean setCloseAngleDirectly(int n, float f) {
        ElementGroupSetInVXYGraph elementGroupSetInVXYGraph = this.getVXYGroupSet(n);
        if (elementGroupSetInVXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInVXYGraph)) {
            return false;
        }
        if (!elementGroupSetInVXYGraph.setHeadCloseAngle(f)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInVXYGraph);
    }

    private class ElementGroupArrow
    extends SGElementGroupArrow
    implements SGFigureElementGraph.IElementGroupInGraph,
    SGIVXYDataConstants {
        protected SGFigureElementGraph.ElementGroupSetInGraph mGroupSet = null;
        private boolean mFocusedFlag = false;

        public boolean setElementGroupSet(SGFigureElementGraph.ElementGroupSetInGraph elementGroupSetInGraph) {
            this.mGroupSet = elementGroupSetInGraph;
            return true;
        }

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupArrow() {
            this.init();
        }

        private boolean init() {
            this.setLineWidth(1.5f, "pt");
            this.setLineType(1);
            this.setColor(DEFAULT_COLOR);
            this.setStartHeadType(-1);
            this.setEndHeadType(10);
            this.setHeadSize(0.4f, "cm");
            this.setHeadOpenAngle(0.5235988f);
            this.setHeadCloseAngle(1.0471976f);
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            SGFigureElementGraph.ElementGroupSetInGraph elementGroupSetInGraph = this.mGroupSet;
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (this.isFocused() & SGFigureElementGraphVXY.this.mSymbolsVisibleFlagAroundFocusedObjects) {
                for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                    SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)sGDrawingElementArray[i];
                    this.emphasisArrow(sGDrawingElementArrow2D, graphics2D);
                }
            }
            return true;
        }

        private boolean emphasisArrow(SGDrawingElementArrow2D sGDrawingElementArrow2D, Graphics2D graphics2D) {
            SGTuple2f sGTuple2f = sGDrawingElementArrow2D.getStart();
            SGTuple2f sGTuple2f2 = sGDrawingElementArrow2D.getEnd();
            SGFigureElementGraphVXY.this.drawAnchorsForFocusedObjects(new Point2D.Float(sGTuple2f.x, sGTuple2f.y), graphics2D);
            SGFigureElementGraphVXY.this.drawAnchorsForFocusedObjects(new Point2D.Float(sGTuple2f2.x, sGTuple2f2.y), graphics2D);
            return true;
        }
    }

    class ElementGroupSetInVXYGraph
    extends SGFigureElementGraph.ElementGroupSetInGraph
    implements SGIVXYDataDialogObserver {
        private SGTuple2f[] mStartPointsArray = null;
        private SGTuple2f[] mEndPointsArray = null;
        private float mMagnitudePerCM = 1.0f;
        private boolean mDirectionFixedFlag;

        private void initPointsArray(int n) {
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
                sGTuple2fArray2[i] = new SGTuple2f();
            }
            this.mStartPointsArray = sGTuple2fArray;
            this.mEndPointsArray = sGTuple2fArray2;
        }

        public float getMagnitudePerCM() {
            return this.mMagnitudePerCM;
        }

        public boolean setMagnitudePerCM(float f) {
            this.mMagnitudePerCM = f;
            this.updateDrawingElementsLocation(SGFigureElementGraphVXY.this.getData(this));
            return true;
        }

        protected ElementGroupSetInVXYGraph() {
            this.mPopupMenu = SGFigureElementGraphVXY.this.createGroupSetPopupMenu(this);
        }

        public String getClassDescription() {
            return "";
        }

        protected boolean createDrawingElements() {
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            ElementGroupArrow elementGroupArrow = null;
            if (n != 3) {
                return false;
            }
            elementGroupArrow = new ElementGroupArrow();
            this.addElementGroup(elementGroupArrow);
            return true;
        }

        private boolean addElementGroup(SGElementGroupVXY sGElementGroupVXY) {
            SGFigureElementGraph.IElementGroupInGraph iElementGroupInGraph = (SGFigureElementGraph.IElementGroupInGraph)((Object)sGElementGroupVXY);
            iElementGroupInGraph.setElementGroupSet(this);
            if (!sGElementGroupVXY.initDrawingElement(this.mStartPointsArray, this.mEndPointsArray)) {
                throw new Error();
            }
            if (!sGElementGroupVXY.setPropertiesOfDrawingElements()) {
                return false;
            }
            this.mDrawingElementGroupList.add(sGElementGroupVXY);
            return true;
        }

        public boolean isDirectionInvariant() {
            return this.mDirectionFixedFlag;
        }

        public boolean setDirectionInvariant(boolean bl) {
            this.mDirectionFixedFlag = bl;
            return true;
        }

        public boolean updateDrawingElementsLocation(SGIData sGIData) {
            if (!(sGIData instanceof SGIVXYTypeData)) {
                return false;
            }
            SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)sGIData;
            int n = sGIVXYTypeData.getPointsNumber();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            if (!SGFigureElementGraphVXY.this.calcLocationOfPoints(sGIVXYTypeData.getXCoordinateArray(), sGIVXYTypeData.getYCoordinateArray(), sGAxis, sGAxis2, this.mStartPointsArray)) {
                return false;
            }
            double[] dArray = sGIVXYTypeData.getXComponentArray();
            double[] dArray2 = sGIVXYTypeData.getYComponentArray();
            double[] dArray3 = sGIVXYTypeData.getMagnitudeArray();
            float f = this.getMagnification();
            SGTuple2f[] sGTuple2fArray = this.mStartPointsArray;
            SGTuple2f[] sGTuple2fArray2 = this.mEndPointsArray;
            float f2 = 1.0f / (0.035277776f * this.getMagnitudePerCM());
            double d = sGAxis.getMaxValue() - sGAxis.getMinValue();
            double d2 = sGAxis2.getMaxValue() - sGAxis2.getMinValue();
            double d3 = (double)SGFigureElementGraphVXY.this.mGraphRectHeight / d2 / ((double)SGFigureElementGraphVXY.this.mGraphRectWidth / d);
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2;
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible() || !(sGElementGroup instanceof ElementGroupArrow)) continue;
                ElementGroupArrow elementGroupArrow = (ElementGroupArrow)sGElementGroup;
                float f3 = f * f2;
                if (this.isDirectionInvariant()) {
                    for (n2 = 0; n2 < sGTuple2fArray.length; ++n2) {
                        float f4 = sGTuple2fArray[n2].x + f3 * (float)dArray[n2];
                        float f5 = sGTuple2fArray[n2].y - f3 * (float)dArray2[n2];
                        sGTuple2fArray2[n2].setValues(f4, f5);
                    }
                } else {
                    for (n2 = 0; n2 < sGTuple2fArray.length; ++n2) {
                        double d4 = d3 * dArray2[n2] / dArray[n2];
                        double d5 = Math.atan(d4);
                        if (dArray[n2] < 0.0) {
                            d5 += Math.PI;
                        }
                        double d6 = Math.cos(d5);
                        double d7 = Math.sin(d5);
                        float f6 = f3 * (float)(dArray3[n2] * d6);
                        float f7 = -f3 * (float)(dArray3[n2] * d7);
                        float f8 = sGTuple2fArray[n2].x + f6;
                        float f9 = sGTuple2fArray[n2].y + f7;
                        sGTuple2fArray2[n2].setValues(f8, f9);
                    }
                }
                elementGroupArrow.setLocation(sGTuple2fArray, sGTuple2fArray2);
            }
            return true;
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            SGIVisible sGIVisible;
            int n;
            ArrayList<SGIVisible> arrayList2 = new ArrayList<SGIVisible>();
            for (n = 0; n < arrayList.size(); ++n) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(n);
                sGIVisible = null;
                if (sGDrawingElement instanceof SGDrawingElementArrow) {
                    sGIVisible = this.getArrowGroup();
                }
                if (sGIVisible == null) continue;
                arrayList2.add(sGIVisible);
            }
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGProperties sGProperties;
                sGIVisible = (SGDrawingElement)arrayList.get(i);
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                SGProperties sGProperties2 = ((SGDrawingElement)sGIVisible).getProperties();
                if (!sGProperties2.equals(sGProperties = sGDrawingElement.getProperties())) {
                    n = 1;
                }
                sGElementGroup.setProperty((SGDrawingElement)sGIVisible);
            }
            return n != 0;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            Rectangle2D rectangle2D = null;
            if (!this.getClipFlag()) {
                rectangle2D = SGFigureElementGraphVXY.this.getGraphRect();
            }
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupArrow elementGroupArrow = (ElementGroupArrow)arrayList.get(i);
                if (!elementGroupArrow.isVisible()) continue;
                elementGroupArrow.paintElement(graphics2D, rectangle2D);
            }
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public int getXAxisLocation() {
            return SGFigureElementGraphVXY.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        public int getYAxisLocation() {
            return SGFigureElementGraphVXY.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGFigureElementGraphVXY.this.mDialog;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            String string = SGFigureElementGraphVXY.this.mAxisElement.getLocationName(this.getXAxis());
            String string2 = SGFigureElementGraphVXY.this.mAxisElement.getLocationName(this.getYAxis());
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            SGVXYData sGVXYData = (SGVXYData)SGFigureElementGraphVXY.this.getData(this);
            boolean bl = sGVXYData.isPolar();
            element.setAttribute("Polar", Boolean.toString(bl));
            float f = this.getMagnitudePerCM();
            element.setAttribute("MagnitudePerCM", Float.toString(f));
            boolean bl2 = this.isDirectionInvariant();
            element.setAttribute("DirectionInvariant", Boolean.toString(bl2));
            return true;
        }

        public SGProperties getProperties() {
            SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = new SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties();
            if (!this.getProperties(elementGroupSetInVXYGraphProperties)) {
                return null;
            }
            return elementGroupSetInVXYGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)sGProperties;
            elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor = this.getMagnitudePerCM();
            elementGroupSetInVXYGraphProperties.mDirectionInvariant = this.isDirectionInvariant();
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)sGProperties;
            this.setMagnitudePerCM(elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor);
            this.setDirectionInvariant(elementGroupSetInVXYGraphProperties.mDirectionInvariant);
            return true;
        }

        public float getLineWidth(String string) {
            return this.getArrowGroup().getLineWidth(string);
        }

        public int getLineType() {
            return this.getArrowGroup().getLineType();
        }

        public Color getColor() {
            return this.getArrowGroup().getColor();
        }

        public float getHeadSize(String string) {
            return this.getArrowGroup().getHeadSize(string);
        }

        public float getHeadOpenAngle() {
            return this.getArrowGroup().getHeadOpenAngle();
        }

        public float getHeadCloseAngle() {
            return this.getArrowGroup().getHeadCloseAngle();
        }

        public int getStartHeadType() {
            return this.getArrowGroup().getStartHeadType();
        }

        public int getEndHeadType() {
            return this.getArrowGroup().getEndHeadType();
        }

        public boolean setLineWidth(float f, String string) {
            return this.getArrowGroup().setLineWidth(f, string);
        }

        public boolean setLineType(int n) {
            return this.getArrowGroup().setLineType(n);
        }

        public boolean setColor(Color color) {
            return this.getArrowGroup().setColor(color);
        }

        public boolean setHeadSize(float f, String string) {
            return this.getArrowGroup().setHeadSize(f, string);
        }

        public boolean setHeadOpenAngle(float f) {
            return this.getArrowGroup().setHeadOpenAngle(f);
        }

        public boolean setHeadCloseAngle(float f) {
            return this.getArrowGroup().setHeadCloseAngle(f);
        }

        public boolean setStartHeadType(int n) {
            return this.getArrowGroup().setStartHeadType(n);
        }

        public boolean setEndHeadType(int n) {
            return this.getArrowGroup().setEndHeadType(n);
        }

        public boolean hasValidAngle(Number number, Number number2) {
            float f = number != null ? number.floatValue() : this.getHeadOpenAngle();
            float f2 = number2 != null ? number2.floatValue() : this.getHeadCloseAngle();
            return f < f2;
        }
    }
}

