/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGFigureElementGraph
extends SGFigureElement
implements SGIFigureElementGraph,
SGIFigureDrawingElementConstants,
SGIDrawingElementConstants {
    protected SGIFigureElementAxis mAxisElement = null;
    protected SGPropertyDialog mDialog = null;
    public static final int MAX_NUMBER_OF_ANCHORS = 8;

    public ArrayList getVisibleDataList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mChildList.get(i);
            if (!elementGroupSetInGraph.isVisible()) continue;
            arrayList.add(this.mDataList.get(i));
        }
        return arrayList;
    }

    public void dispose() {
        super.dispose();
        this.mDialog.dispose();
        this.mDialog = null;
    }

    public String toString() {
        return new String("SGGraphElement");
    }

    public String getInstanceDescription() {
        return "Graph";
    }

    protected abstract boolean createDataDialog();

    protected boolean updateAllDrawingElementsLocation() {
        List list = this.mChildList;
        List list2 = this.mDataList;
        for (int i = 0; i < list.size(); ++i) {
            SGData sGData;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)list.get(i);
            if (!elementGroupSetInGraph.isVisible() || elementGroupSetInGraph.updateDrawingElementsLocation(sGData = (SGData)list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
        return true;
    }

    public boolean addData(SGData sGData, String string) {
        if (!super.addData(sGData, string)) {
            return false;
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.createGroupSet(sGData, string);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.addToList(elementGroupSetInGraph);
        elementGroupSetInGraph.initPropertiesHistory();
        if (this.mDialog == null) {
            this.createDataDialog();
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!super.addData(sGData, string)) {
            return false;
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.createGroupSet(sGData, string);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.addToList(elementGroupSetInGraph);
        if (!elementGroupSetInGraph.setWholeProperties(sGProperties)) {
            return false;
        }
        elementGroupSetInGraph.setVisible(true);
        elementGroupSetInGraph.setName(string);
        elementGroupSetInGraph.initPropertiesHistory();
        if (this.mDialog == null) {
            this.createDataDialog();
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    protected abstract ElementGroupSetInGraph createGroupSet(SGData var1, String var2);

    public String getDataName(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getName();
        }
        return null;
    }

    public boolean setDataName(String string, SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            elementGroupSetInGraph.setName(string);
            return true;
        }
        return false;
    }

    public SGProperties getDataProperties(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getWholeProperties();
        }
        return null;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getDrawingElementList();
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data==null");
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph == null) {
            throw new Error();
        }
        ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
        return arrayList;
    }

    public boolean getVisibleInLegendFlag(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data==null");
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph == null) {
            throw new Error();
        }
        boolean bl = elementGroupSetInGraph.isVisibleInLegend();
        return bl;
    }

    public SGAxis getXAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getXAxis();
        }
        return null;
    }

    public SGAxis getYAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getYAxis();
        }
        return null;
    }

    public SGAxis getZAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mZAxis;
        }
        return null;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mChildList.get(i);
            elementGroupSetInGraph.zoom(f);
        }
        this.updateAllDrawingElementsLocation();
        this.updateImage();
        return true;
    }

    public boolean removeData(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        this.removeChild(elementGroupSetInGraph);
        return super.removeData(sGData);
    }

    public boolean setDataVisible(SGData sGData, boolean bl) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        elementGroupSetInGraph.setVisible(bl);
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        if (!this.updateAllDrawingElementsLocation()) {
            return false;
        }
        this.updateImage();
        return true;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGIFigureElementLegend) {
            SGIFigureElementLegend sGIFigureElementLegend = (SGIFigureElementLegend)sGIFigureElement;
            bl = this.synchronizeToLegendElement(sGIFigureElementLegend, string);
        } else if (sGIFigureElement instanceof SGIFigureElementAxis) {
            SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)sGIFigureElement;
            bl = this.synchronizeToAxisElement(sGIFigureElementAxis, string);
        } else if (!(sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
            bl = this.synchronizeArgument(sGIFigureElement, string);
        }
        return bl;
    }

    protected boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        this.updateAllDrawingElementsLocation();
        this.updateImage();
        return true;
    }

    protected boolean synchronizeToLegendElement(SGIFigureElementLegend sGIFigureElementLegend, String string) {
        SGIDisposable sGIDisposable;
        SGIDisposable sGIDisposable2;
        SGData sGData;
        int n;
        List list = sGIFigureElementLegend.getDataList();
        if (list.size() != this.mDataList.size()) {
            throw new Error("dataList.size()!=this.mDataList.size()");
        }
        ArrayList<SGProperties> arrayList = new ArrayList<SGProperties>();
        ArrayList<SGProperties> arrayList2 = new ArrayList<SGProperties>();
        block0: for (n = 0; n < list.size(); ++n) {
            sGData = (SGData)list.get(n);
            for (int i = this.mDataList.size() - 1; i >= 0; --i) {
                SGData sGData2 = (SGData)this.mDataList.get(i);
                if (!sGData.equals(sGData2)) continue;
                sGIDisposable2 = (SGData)this.mDataList.remove(i);
                arrayList.add((SGProperties)sGIDisposable2);
                sGIDisposable = (SGElementGroupSet)this.mChildList.remove(i);
                arrayList2.add((SGProperties)sGIDisposable);
                continue block0;
            }
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            sGData = (SGData)arrayList.get(n);
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(n);
            boolean bl = false;
            sGIDisposable2 = sGIFigureElementLegend.getDataProperties(sGData);
            if (!sGIDisposable2.equals(sGIDisposable = elementGroupSetInGraph.getWholeProperties()) & !string.equals("Notify the change on undo")) {
                bl = true;
            }
            if (bl) {
                elementGroupSetInGraph.setChanged(true);
            }
            if (elementGroupSetInGraph.setWholeProperties((SGProperties)sGIDisposable2)) continue;
            return false;
        }
        this.mDataList = arrayList;
        this.mChildList = arrayList2;
        this.updateAllDrawingElementsLocation();
        this.updateImage();
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    protected boolean isInsideAxisRange(SGTuple2d sGTuple2d, SGAxis sGAxis, SGAxis sGAxis2) {
        return sGAxis.insideRange(sGTuple2d.x) && sGAxis2.insideRange(sGTuple2d.y);
    }

    protected boolean calcLocationOfPoints(double[] dArray, double[] dArray2, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("xValueArray==null || yValueArray==null");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("xValueArray.length!=yValueArray.length");
        }
        int n = dArray.length;
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n2 = sGAxis.getScaleType();
        int n3 = sGAxis2.getScaleType();
        boolean bl = sGAxis.isInvertCoordinates();
        boolean bl2 = sGAxis2.isInvertCoordinates();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        if (n2 == 0) {
            d5 = d;
            d6 = d2;
        } else if (n2 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
        }
        if (n3 == 0) {
            d7 = d3;
            d8 = d4;
        } else if (n3 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
        }
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        float f3 = this.mGraphRectWidth;
        float f4 = this.mGraphRectHeight;
        for (int i = 0; i < n; ++i) {
            if (n2 == 0) {
                dArray3[i] = dArray[i];
            } else if (n2 == 1) {
                dArray3[i] = Math.log(dArray[i]);
            }
            if (n3 == 0) {
                dArray4[i] = dArray2[i];
            } else if (n3 == 1) {
                dArray4[i] = Math.log(dArray2[i]);
            }
            float f5 = bl ? (float)((d6 - dArray3[i]) / (d6 - d5)) : (float)((dArray3[i] - d5) / (d6 - d5));
            float f6 = bl2 ? (float)(1.0 - (d8 - dArray4[i]) / (d8 - d7)) : (float)(1.0 - (dArray4[i] - d7) / (d8 - d7));
            float f7 = f + f5 * f3;
            float f8 = f2 + f6 * f4;
            sGTuple2fArray[i].setValues(f7, f8);
        }
        return true;
    }

    protected boolean calcLocationOfPairs(SGTuple2d[] sGTuple2dArray, SGTuple2d[] sGTuple2dArray2, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        if (sGTuple2dArray == null || sGTuple2dArray2 == null || sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null || startLocationArray==null || endLocationArray==null");
        }
        if (sGTuple2dArray.length != sGTuple2dArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startLocationArray.length != endLocationArray.length");
        }
        int n = sGTuple2dArray.length;
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n2 = sGAxis.getScaleType();
        int n3 = sGAxis2.getScaleType();
        boolean bl = sGAxis.isInvertCoordinates();
        boolean bl2 = sGAxis2.isInvertCoordinates();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        if (n2 == 0) {
            d5 = d;
            d6 = d2;
        } else if (n2 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
        }
        if (n3 == 0) {
            d7 = d3;
            d8 = d4;
        } else if (n3 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
        }
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        double d9 = d6 - d5;
        double d10 = d8 - d7;
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        float f3 = this.mGraphRectWidth;
        float f4 = this.mGraphRectHeight;
        for (int i = 0; i < n; ++i) {
            if (n2 == 0) {
                dArray[i] = sGTuple2dArray[i].x;
                dArray3[i] = sGTuple2dArray2[i].x;
            } else if (n2 == 1) {
                dArray[i] = Math.log(sGTuple2dArray[i].x);
                dArray3[i] = Math.log(sGTuple2dArray2[i].x);
            }
            if (n3 == 0) {
                dArray2[i] = sGTuple2dArray[i].y;
                dArray4[i] = sGTuple2dArray2[i].y;
            } else if (n3 == 1) {
                dArray2[i] = Math.log(sGTuple2dArray[i].y);
                dArray4[i] = Math.log(sGTuple2dArray2[i].y);
            }
            if (bl) {
                fArray[i] = (float)(1.0 - (dArray[i] - d5) / d9);
                fArray3[i] = (float)(1.0 - (dArray3[i] - d5) / d9);
            } else {
                fArray[i] = (float)((dArray[i] - d5) / d9);
                fArray3[i] = (float)((dArray3[i] - d5) / d9);
            }
            if (bl2) {
                fArray2[i] = (float)((dArray2[i] - d7) / d10);
                fArray4[i] = (float)((dArray4[i] - d7) / d10);
            } else {
                fArray2[i] = (float)(1.0 - (dArray2[i] - d7) / d10);
                fArray4[i] = (float)(1.0 - (dArray4[i] - d7) / d10);
            }
            sGTuple2fArray[i].x = f + fArray[i] * f3;
            sGTuple2fArray[i].y = f2 + fArray2[i] * f4;
            sGTuple2fArray2[i].x = f + fArray3[i] * f3;
            sGTuple2fArray2[i].y = f2 + fArray4[i] * f4;
        }
        return true;
    }

    public int getSelectedDataNumber() {
        return this.getFocusedObjectsList().size();
    }

    public ArrayList getFocusedDataList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
            SGData sGData = this.getData(elementGroupSetInGraph);
            arrayList2.add(sGData);
        }
        return arrayList2;
    }

    public ArrayList cutFocusedObjects() {
        return new ArrayList();
    }

    public ArrayList cutFocusedData() {
        ArrayList arrayList = this.getFocusedDataList();
        this.hideSelectedData();
        return arrayList;
    }

    protected boolean hideGroupSet(SGElementGroupSet sGElementGroupSet) {
        sGElementGroupSet.setVisible(false);
        return true;
    }

    protected boolean removeGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mChildList.get(i))) continue;
            this.mChildList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    protected boolean hideSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            sGElementGroupSet.setVisible(false);
        }
        this.clearFocusedObjects();
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean isDataVisible(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        return elementGroupSetInGraph.isVisible();
    }

    public boolean removeSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            this.removeGroupSet(sGElementGroupSet);
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    protected boolean moveObjectToHead(Object object, List list) {
        return this.moveObjectTo(object, list, list.size() - 1);
    }

    protected boolean moveObjectToTail(Object object, List list) {
        return this.moveObjectTo(object, list, 0);
    }

    private boolean moveObjectTo(Object object, List list, int n) {
        if (!(object instanceof ElementGroupSetInGraph)) {
            return false;
        }
        int n2 = list.indexOf(object);
        if (n2 == -1) {
            return false;
        }
        List list2 = this.mDataList;
        SGData sGData = (SGData)list2.get(n2);
        if (!SGUtility.moveObject(object, list, n)) {
            return false;
        }
        return SGUtility.moveObject(sGData, list2, n);
    }

    protected ElementGroupSetInGraph getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mChildList.get(i);
            return elementGroupSetInGraph;
        }
        return null;
    }

    protected SGData getData(ElementGroupSetInGraph elementGroupSetInGraph) {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mChildList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInGraph)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    protected boolean drawAnchorsForFocusedObjects(Point2D point2D, Graphics2D graphics2D) {
        SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(point2D, graphics2D);
        return true;
    }

    protected boolean drawAnchorsOnRectangle(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float();
        ((Point2D)float_).setLocation(f, f2);
        this.drawAnchorsForFocusedObjects(float_, graphics2D);
        ((Point2D)float_).setLocation(f + f3, f2);
        this.drawAnchorsForFocusedObjects(float_, graphics2D);
        ((Point2D)float_).setLocation(f, f2 + f4);
        this.drawAnchorsForFocusedObjects(float_, graphics2D);
        ((Point2D)float_).setLocation(f + f3, f2 + f4);
        this.drawAnchorsForFocusedObjects(float_, graphics2D);
        return true;
    }

    protected JPopupMenu createGroupSetPopupMenu(ElementGroupSetInGraph elementGroupSetInGraph) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Data --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Front");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Back");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Cut");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Copy");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Delete");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Property");
        return jPopupMenu;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        List list = this.mChildList;
        for (int i = list.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)list.get(i);
            if (!elementGroupSetInGraph.isVisible() || !elementGroupSetInGraph.onMouseClicked(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        List list = this.mChildList;
        for (int i = list.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)list.get(i);
            if (!elementGroupSetInGraph.isVisible() || !elementGroupSetInGraph.onMousePressed(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.getFocusedObjectsList().size() != 0) {
            return true;
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    public boolean setChangedFocusedObjects() {
        return true;
    }

    protected boolean drawRectangle(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(d, d3, d2, d3);
        Line2D.Double double_2 = new Line2D.Double(d, d4, d2, d4);
        Line2D.Double double_3 = new Line2D.Double(d, d3, d, d4);
        Line2D.Double double_4 = new Line2D.Double(d2, d3, d2, d4);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
        graphics2D.draw(double_4);
        return true;
    }

    public String getTagName() {
        return "Graph";
    }

    public Element createElement(Document document) {
        return null;
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        return true;
    }

    public boolean createElementOfData(Document document, ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleChildList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(i);
            Element element = elementGroupSetInGraph.createElement(document);
            if (element == null) {
                return false;
            }
            element.setAttribute("Type", elementGroupSetInGraph.getDataType());
            arrayList.add(element);
        }
        return true;
    }

    public SGProperties getProperties() {
        GraphProperties graphProperties = new GraphProperties();
        if (!this.getProperties(graphProperties)) {
            return null;
        }
        return graphProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        graphProperties.visibleElementGroupList = this.getVisibleChildList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        boolean bl = this.setVisibleChildList(graphProperties.visibleElementGroupList);
        return bl;
    }

    protected boolean setVisibleChildList(List list) {
        ElementGroupSetInGraph elementGroupSetInGraph;
        int n;
        ArrayList arrayList = new ArrayList(list);
        ArrayList<ElementGroupSetInGraph> arrayList2 = new ArrayList<ElementGroupSetInGraph>();
        ArrayList<SGData> arrayList3 = new ArrayList<SGData>();
        ArrayList<SGData> arrayList4 = new ArrayList<SGData>();
        for (n = 0; n < this.mChildList.size(); ++n) {
            elementGroupSetInGraph = (ElementGroupSetInGraph)this.mChildList.get(n);
            boolean bl = list.contains(elementGroupSetInGraph);
            elementGroupSetInGraph.setVisible(bl);
            if (bl) continue;
            arrayList2.add(elementGroupSetInGraph);
            arrayList4.add(this.getData(elementGroupSetInGraph));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(n);
            SGData sGData = this.getData(elementGroupSetInGraph);
            arrayList3.add(sGData);
        }
        this.mChildList.clear();
        this.mDataList.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            this.mChildList.add(arrayList.get(n));
            this.mDataList.add(arrayList3.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.mChildList.add(arrayList2.get(n));
            this.mDataList.add(arrayList4.get(n));
        }
        return true;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.updateAllDrawingElementsLocation();
        this.updateImage();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.updateAllDrawingElementsLocation();
        this.updateImage();
        this.notifyChangeOnUndo();
        return true;
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            GraphProperties graphProperties = (GraphProperties)list.get(i);
            hashSet.addAll(graphProperties.visibleElementGroupList);
        }
        return hashSet;
    }

    protected boolean removeUselessChild() {
        Set set = this.getAvailableChildSet();
        if (set.size() != 0) {
            boolean bl = false;
            ArrayList arrayList = new ArrayList(this.mChildList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object e = arrayList.get(i);
                if (!set.contains(e)) {
                    SGData sGData = this.getData((ElementGroupSetInGraph)e);
                    this.removeChild(e);
                    this.mDataList.remove(sGData);
                    bl = true;
                }
                e = null;
            }
            if (bl) {
                arrayList.clear();
                set.clear();
                this.notifyToListener("Merge Data");
            }
        }
        return true;
    }

    protected ElementGroupSetInGraph getGroupSet(int n) {
        ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.getChildObject(n);
        if (elementGroupSetInGraph == null) {
            return null;
        }
        if (!elementGroupSetInGraph.isVisible()) {
            return null;
        }
        return elementGroupSetInGraph;
    }

    public boolean setAxisXDirectly(int n, int n2) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSet(n);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInGraph)) {
            return false;
        }
        if (!elementGroupSetInGraph.setXAxisLocation(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInGraph);
    }

    public boolean setAxisYDirectly(int n, int n2) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSet(n);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInGraph)) {
            return false;
        }
        if (!elementGroupSetInGraph.setYAxisLocation(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInGraph);
    }

    public boolean setVisibleInLegendDirectly(int n, boolean bl) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSet(n);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInGraph)) {
            return false;
        }
        if (!elementGroupSetInGraph.setVisibleInLegend(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInGraph);
    }

    public boolean setNameDirectly(int n, String string) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSet(n);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInGraph)) {
            return false;
        }
        if (!elementGroupSetInGraph.setName(string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInGraph);
    }

    protected boolean setDirectlyBefore(ElementGroupSetInGraph elementGroupSetInGraph) {
        return elementGroupSetInGraph.prepare();
    }

    protected boolean setDirectlyAfter(ElementGroupSetInGraph elementGroupSetInGraph) {
        if (!elementGroupSetInGraph.commit()) {
            return false;
        }
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    protected boolean readProperty(SGElementGroup sGElementGroup, Element element) {
        String string = element.getAttribute("Visible");
        if (string.length() != 0) {
            Boolean bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            sGElementGroup.setVisible(bl);
        }
        return true;
    }

    protected int setDataProperties(Element element, ElementGroupSetInGraph elementGroupSetInGraph, SGData sGData) {
        Object object;
        SGIFigureElementAxis sGIFigureElementAxis = this.mAxisElement;
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        if (!elementGroupSetInGraph.setName(string2)) {
            return 1;
        }
        string = element.getAttribute("XAxisPosition");
        if (string.length() != 0) {
            object = sGIFigureElementAxis.getAxis(string);
            if (object == null) {
                return 1;
            }
            elementGroupSetInGraph.setXAxis((SGAxis)object);
        }
        if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
            object = sGIFigureElementAxis.getAxis(string);
            if (object == null) {
                return 1;
            }
            elementGroupSetInGraph.setYAxis((SGAxis)object);
        }
        if ((string = element.getAttribute("VisibleInLegend")).length() != 0) {
            object = SGUtilityText.getBoolean(string);
            if (object == null) {
                return 1;
            }
            boolean bl = (Boolean)object;
            if (!elementGroupSetInGraph.setVisibleInLegend(bl)) {
                return 1;
            }
        }
        return 0;
    }

    public static class GraphProperties
    extends SGProperties {
        ArrayList visibleElementGroupList = new ArrayList();

        public void dispose() {
            this.visibleElementGroupList.clear();
            this.visibleElementGroupList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GraphProperties)) {
                return false;
            }
            GraphProperties graphProperties = (GraphProperties)object;
            return graphProperties.visibleElementGroupList.equals(this.visibleElementGroupList);
        }
    }

    public static interface IElementGroupInGraph {
        public void setFocused(boolean var1);

        public boolean isFocused();

        public boolean setElementGroupSet(ElementGroupSetInGraph var1);
    }

    abstract class ElementGroupSetForMultipleData
    extends ElementGroupSetInGraph {
        protected ArrayList mElementGroupSetList;

        protected ElementGroupSetForMultipleData() {
            this.mElementGroupSetList = new ArrayList();
        }

        public void dispose() {
            super.dispose();
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
                sGElementGroupSet.dispose();
            }
            this.mElementGroupSetList.clear();
            this.mElementGroupSetList = null;
        }

        public ArrayList getVisibleFlagList() {
            if (this.mElementGroupSetList.size() == 0) {
                return new ArrayList();
            }
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(0);
            ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
            return arrayList;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
                sGISelectable.setSelected(bl);
            }
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setVisible(bl);
            }
        }

        public boolean setName(String string) {
            super.setName(string);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setName(string);
            }
            return true;
        }

        public boolean setVisibleInLegend(boolean bl) {
            super.setVisibleInLegend(bl);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setVisibleInLegend(bl);
            }
            return true;
        }

        public boolean contains(int n, int n2) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                if (!elementGroupSetInGraph.contains(n, n2)) continue;
                return true;
            }
            return false;
        }

        public SGElementGroup getElementGroupAt(int n, int n2) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                SGElementGroup sGElementGroup = elementGroupSetInGraph.getElementGroupAt(n, n2);
                if (sGElementGroup == null) continue;
                return sGElementGroup;
            }
            return null;
        }

        public boolean setMagnification(float f) {
            super.setMagnification(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.setMagnification(f);
            }
            return true;
        }

        public boolean zoom(float f) {
            super.zoom(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.zoom(f);
            }
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.addDrawingElementGroup(n);
            }
            return true;
        }

        public boolean onDrawingElement(int n, int n2) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                boolean bl = elementGroupSetInGraph.onDrawingElement(n, n2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.paintGraphics2D(graphics2D);
            }
        }

        public void setClipFlag(boolean bl) {
            super.setClipFlag(bl);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setClipFlag(bl);
            }
        }

        public ArrayList getDrawingElementList() {
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            if (this.mElementGroupSetList.size() == 0) {
                return arrayList;
            }
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(0);
            ArrayList arrayList2 = sGElementGroupSet.getElementGroupList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                arrayList.add(sGDrawingElement);
            }
            return arrayList;
        }

        public boolean setDrawingElementProperties(ArrayList arrayList) {
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(i);
                elementGroupSetInGraph.setDrawingElementProperties(arrayList);
            }
            return true;
        }
    }

    protected abstract class ElementGroupSetInGraph
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIPropertyDialogObserver,
    SGISelectable,
    SGINode,
    SGFigureElement.ChildObject {
        private int mID;
        protected boolean mClipFlag = true;
        protected boolean mSelectedFlag = false;
        protected SGProperties mTemporaryProperties = null;
        protected JPopupMenu mPopupMenu = new JPopupMenu();

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        public boolean setXAxisLocation(int n) {
            this.mXAxis = this.getAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            this.mYAxis = this.getAxis(n);
            return true;
        }

        private SGAxis getAxis(int n) {
            return SGFigureElementGraph.this.mAxisElement.getAxisInPlane(n);
        }

        public void finalize() {
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
        }

        protected void setClipFlag(boolean bl) {
            this.mClipFlag = bl;
        }

        protected boolean getClipFlag() {
            return this.mClipFlag;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
            ArrayList arrayList = new ArrayList(this.mDrawingElementGroupList);
            for (int i = 0; i < arrayList.size(); ++i) {
                IElementGroupInGraph iElementGroupInGraph = (IElementGroupInGraph)arrayList.get(i);
                iElementGroupInGraph.setFocused(bl);
            }
        }

        protected ElementGroupSetInGraph() {
        }

        public ArrayList getVisibleFlagList() {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            ArrayList arrayList2 = new ArrayList(this.mDrawingElementGroupList);
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                boolean bl = sGElementGroup.isVisible();
                arrayList.add(bl);
            }
            return arrayList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementGraph.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Move to Front") | string.equals("Move to Back") | string.equals("Cut") | string.equals("Copy") | string.equals("Paste") | string.equals("Delete")) {
                SGFigureElementGraph.this.notifyToListener(string);
            }
        }

        protected abstract boolean createDrawingElements();

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            if (this.contains(n, n2)) {
                SGFigureElementGraph.this.updateFocusedObjectsList(this, mouseEvent);
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    SGFigureElementGraph.this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    this.mPopupMenu.show(SGFigureElementGraph.this.getComponent(), n, n2);
                }
                return true;
            }
            return false;
        }

        protected boolean onMousePressed(MouseEvent mouseEvent) {
            return this.contains(mouseEvent.getX(), mouseEvent.getY());
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            if (!SGFigureElementGraph.this.updateAllDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementGraph.this.updateImage();
            SGFigureElementGraph.this.repaint();
            SGFigureElementGraph.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setWholeProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            if (!SGFigureElementGraph.this.updateAllDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementGraph.this.updateImage();
            SGFigureElementGraph.this.repaint();
            SGFigureElementGraph.this.notifyChange();
            return true;
        }

        public boolean preview() {
            if (!SGFigureElementGraph.this.updateAllDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementGraph.this.updateImage();
            SGFigureElementGraph.this.repaint();
            SGFigureElementGraph.this.notifyChange();
            return true;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementGraph.this.mAxisElement;
            elementGroupSetPropertiesInFigureElement.xAxis = sGIFigureElementAxis.getLocationInCube(this.getXAxis());
            elementGroupSetPropertiesInFigureElement.yAxis = sGIFigureElementAxis.getLocationInCube(this.getYAxis());
            elementGroupSetPropertiesInFigureElement.zAxis = sGIFigureElementAxis.getLocationInCube(this.getZAxis());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSet.ElementGroupSetProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementGraph.this.mAxisElement;
            this.setXAxis(sGIFigureElementAxis.getAxisInCube(elementGroupSetPropertiesInFigureElement.xAxis));
            this.setYAxis(sGIFigureElementAxis.getAxisInCube(elementGroupSetPropertiesInFigureElement.yAxis));
            this.setZAxis(sGIFigureElementAxis.getAxisInCube(elementGroupSetPropertiesInFigureElement.zAxis));
            return true;
        }

        public String getDataType() {
            return SGFigureElementGraph.this.getData(this).getDataType();
        }

        public String getInstanceDescription() {
            return this.mID + ": " + this.getDataType() + ": " + this.getName();
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("Type", this.getDataType());
            return true;
        }

        public String getTagName() {
            return "Data";
        }

        protected abstract boolean updateDrawingElementsLocation(SGIData var1);

        public boolean setDrawingElementProperties(ArrayList arrayList) {
            ArrayList arrayList2 = this.mDrawingElementGroupList;
            if (arrayList.size() != arrayList2.size()) {
                throw new IllegalArgumentException("dElementList.size() != groupList.size()");
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
                sGElementGroup.setProperty(sGDrawingElement);
            }
            return true;
        }

        protected abstract boolean synchronizeDrawingElement(ArrayList var1);

        public boolean setMementoBackward() {
            if (!super.setMementoBackward()) {
                return false;
            }
            SGFigureElementGraph.this.updateAllDrawingElementsLocation();
            SGFigureElementGraph.this.updateImage();
            SGFigureElementGraph.this.notifyChangeOnUndo();
            return true;
        }

        public boolean setMementoForward() {
            if (!super.setMementoForward()) {
                return false;
            }
            SGFigureElementGraph.this.updateAllDrawingElementsLocation();
            SGFigureElementGraph.this.updateImage();
            SGFigureElementGraph.this.notifyChangeOnUndo();
            return true;
        }

        public void notifyToRoot() {
            SGFigureElementGraph.this.notifyToRoot();
        }
    }
}

